/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class FootnoteLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager {
    private Footnote footnote;
    private InlineStackingLayoutManager citationLM;
    private FootnoteBodyLayoutManager bodyLM;

    public FootnoteLayoutManager(Footnote node) {
        super(node);
        this.footnote = node;
        this.citationLM = new InlineLayoutManager(this.footnote.getFootnoteCitation());
        this.bodyLM = new FootnoteBodyLayoutManager(this.footnote.getFootnoteBody());
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.citationLM.setParent(this.getParent());
        this.bodyLM.setParent(this);
        LinkedList<KnuthInlineBox> returnedList = new LinkedList<KnuthInlineBox>();
        while (!this.citationLM.isFinished()) {
            LinkedList partialList = this.citationLM.getNextKnuthElements(context, alignment);
            if (partialList == null) continue;
            returnedList.addAll(partialList);
        }
        if (returnedList.size() == 0) {
            returnedList.add(new KnuthInlineBox(0, 0, 0, 0, null, true));
        }
        this.setFinished(true);
        this.addAnchor(returnedList);
        return returnedList;
    }

    private void addAnchor(LinkedList citationList) {
        KnuthInlineBox lastBox = null;
        ListIterator citationIterator = citationList.listIterator(citationList.size());
        while (citationIterator.hasPrevious() && lastBox == null) {
            Object obj = citationIterator.previous();
            if (obj instanceof KnuthElement) {
                KnuthElement element = (KnuthElement)obj;
                if (!(element instanceof KnuthInlineBox)) continue;
                lastBox = (KnuthInlineBox)element;
                continue;
            }
            KnuthSequence seq = (KnuthSequence)obj;
            ListIterator nestedIterator = seq.listIterator(seq.size());
            while (nestedIterator.hasPrevious() && lastBox == null) {
                KnuthElement element = (KnuthElement)nestedIterator.previous();
                if (!(element instanceof KnuthInlineBox)) continue;
                lastBox = (KnuthInlineBox)element;
            }
        }
        if (lastBox != null) {
            lastBox.setFootnoteBodyLM(this.bodyLM);
        }
    }

    public List addALetterSpaceTo(List oldList) {
        log.warn("null implementation of addALetterSpaceTo() called!");
        return oldList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
        log.warn("null implementation of getWordChars() called!");
    }

    public void hyphenate(Position pos, HyphContext hc) {
        log.warn("null implementation of hyphenate called!");
    }

    public boolean applyChanges(List oldList) {
        log.warn("null implementation of applyChanges() called!");
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        log.warn("null implementation of getChangeKnuthElement() called!");
        return null;
    }
}

