/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public class PageNumberLayoutManager
extends LeafNodeLayoutManager {
    private PageNumber fobj;
    private Font font;

    public PageNumberLayoutManager(PageNumber node) {
        super(node);
        this.fobj = node;
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo());
    }

    public InlineArea get(LayoutContext context) {
        TextArea text = new TextArea();
        String str = this.getCurrentPV().getPageNumberString();
        int width = 0;
        for (int count = 0; count < str.length(); ++count) {
            width += this.font.getCharWidth(str.charAt(count));
        }
        text.setTextArea(str);
        text.setIPD(width);
        text.setBPD(this.font.getAscender() - this.font.getDescender());
        text.setOffset(this.font.getAscender());
        text.addTrait(Trait.FONT_NAME, this.font.getFontName());
        text.addTrait(Trait.FONT_SIZE, new Integer(this.font.getFontSize()));
        text.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addTextDecoration(text, this.fobj.getTextDecoration());
        return text;
    }

    public int getLead() {
        return this.font.getAscender();
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        area.setOffset(context.getBaseline());
    }

    protected InlineArea getEffectiveArea() {
        TextArea baseArea = (TextArea)this.curArea;
        TextArea ta = new TextArea();
        TraitSetter.setProducerID(ta, this.fobj.getId());
        ta.setIPD(baseArea.getIPD());
        ta.setBPD(baseArea.getBPD());
        ta.setOffset(baseArea.getOffset());
        ta.addTrait(Trait.FONT_NAME, this.font.getFontName());
        ta.getTraits().putAll(baseArea.getTraits());
        this.updateContent(ta);
        return ta;
    }

    private void updateContent(TextArea area) {
        area.setTextArea(this.getCurrentPV().getPageNumberString());
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

