/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.java2d.Java2DRenderer;

public class PNGRenderer_onthefly
extends Java2DRenderer {
    public static final String MIME_TYPE = "image/png";
    private String fileSyntax;
    private File outputDir;
    private PNGEncodeParam renderParams;
    private OutputStream firstOutputStream;

    public String getMimeType() {
        return MIME_TYPE;
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.info("rendering areas to PNG");
        this.setOutputDirectory();
        this.firstOutputStream = outputStream;
    }

    private void setOutputDirectory() {
        int i;
        File f = this.getUserAgent().getOutputFile();
        this.outputDir = f.getParentFile();
        String s = f.getName();
        if (s.charAt((i = s.lastIndexOf(".")) - 1) == '1') {
            --i;
        }
        this.fileSyntax = s.substring(0, i);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        BufferedImage image = this.getPageImage(pageViewport);
        log.debug("Encoding page" + (this.getCurrentPageNumber() + 1));
        this.renderParams = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
        OutputStream os = this.getCurrentOutputStream(this.getCurrentPageNumber());
        PNGImageEncoder encoder = new PNGImageEncoder(os, this.renderParams);
        encoder.encode((RenderedImage)image);
        os.flush();
        this.setCurrentPageNumber(this.getCurrentPageNumber() + 1);
    }

    private OutputStream getCurrentOutputStream(int pageNumber) {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        File f = new File(this.outputDir + File.separator + this.fileSyntax + (pageNumber + 1) + ".png");
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            return os;
        }
        catch (FileNotFoundException e) {
            new FOPException("Can't build the OutputStream\n" + e);
            return null;
        }
    }
}

