/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfTable
extends RtfContainer {
    private RtfTableRow row;
    private int highestRow = 0;
    private ITableColumnsInfo tableContext;
    private RtfAttributes headerAttribs = null;

    RtfTable(IRtfTableContainer parent, Writer w, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w);
        this.tableContext = tc;
    }

    RtfTable(IRtfTableContainer parent, Writer w, RtfAttributes attrs, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w, attrs);
        this.tableContext = tc;
    }

    public RtfTableRow newTableRow() throws IOException {
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, this.attrib, this.highestRow);
        return this.row;
    }

    public RtfTableRow newTableRow(RtfAttributes attrs) throws IOException {
        RtfAttributes attr = null;
        if (this.attrib != null) {
            attr = (RtfAttributes)this.attrib.clone();
            attr.set(attrs);
        } else {
            attr = attrs;
        }
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, attr, this.highestRow);
        return this.row;
    }

    protected void writeRtfPrefix() throws IOException {
        this.writeGroupMark(true);
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
    }

    public boolean isHighestRow(int id) {
        return this.highestRow == id;
    }

    public ITableColumnsInfo getITableColumnsInfo() {
        return this.tableContext;
    }

    public void setHeaderAttribs(RtfAttributes attrs) {
        this.headerAttribs = attrs;
    }

    public RtfAttributes getHeaderAttribs() {
        return this.headerAttribs;
    }

    public RtfAttributes getRtfAttributes() {
        if (this.headerAttribs != null) {
            return this.headerAttribs;
        }
        return super.getRtfAttributes();
    }
}

