/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.spi.p2.core.repository;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.provisional.p2.core.repository.IRepository;

public abstract class AbstractRepository
extends PlatformObject
implements IRepository {
    protected String description;
    protected transient URL location;
    protected String name;
    protected Map properties = new OrderedProperties();
    protected String provider;
    protected String type;
    protected String version;

    protected AbstractRepository(String name, String type, String version, URL location, String description, String provider, Map properties) {
        this.name = name;
        this.type = type;
        this.version = version;
        this.location = location;
        this.description = description == null ? "" : description;
        String string = this.provider = provider == null ? "" : provider;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    protected void assertModifiable() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException("Repository not modifiable: " + this.location);
        }
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized URL getLocation() {
        return this.location;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized Map getProperties() {
        return OrderedProperties.unmodifiableProperties(this.properties);
    }

    public synchronized String getProvider() {
        return this.provider;
    }

    public synchronized String getType() {
        return this.type;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    public boolean isModifiable() {
        return false;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public synchronized void setName(String value) {
        this.name = value;
    }

    public synchronized String setProperty(String key, String value) {
        this.assertModifiable();
        return (String)(value == null ? this.properties.remove(key) : this.properties.put(key, value));
    }

    public synchronized void setProvider(String provider) {
        this.provider = provider;
    }
}

