/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.web;

import com.insightful.splusserver.api.java.AdministrationService;
import com.insightful.splusserver.api.java.ExpressionService;
import com.insightful.splusserver.configuration.ServerPropertyManager;
import com.insightful.splusserver.domain.SplusDataResult;
import com.insightful.splusserver.domain.SplusJobs;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class WebServiceClient {
    private static String[] RESULT_NAMES = new String[]{"splusCode", "created", "createdBy", "jobId", "status", "resultsDir", "error", "warnings", "output", "resultSpxml"};
    private static String DEFAULT_ERROR_MESSAGE = "Server Error";

    public static Vector queryServer(String string, String string2, String string3) {
        SplusDataResult splusDataResult;
        Object object;
        List<Object> list = null;
        try {
            object = new AdministrationService(string2, string3, string);
            Method method = null;
            splusDataResult = null;
            SplusJobs splusJobs = null;
            try {
                try {
                    method = object.getClass().getMethod("getJobs", String.class, String.class);
                    splusJobs = (SplusJobs)method.invoke(object, splusDataResult, splusDataResult);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = object.getClass().getMethod("getJobs", String.class);
                        splusJobs = (SplusJobs)method.invoke(object, splusDataResult);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        list = new Vector();
                        list.add(WebServiceClient.handleSevereException(noSuchMethodException));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                list = new Vector();
                list.add(WebServiceClient.handleSevereException(illegalArgumentException));
            }
            catch (IllegalAccessException illegalAccessException) {
                list = new Vector();
                list.add(WebServiceClient.handleSevereException(illegalAccessException));
            }
            catch (InvocationTargetException invocationTargetException) {
                list = new Vector();
                list.add(WebServiceClient.handleSevereException(invocationTargetException));
            }
            if (splusJobs != null) {
                list = splusJobs.getJobs();
            }
        }
        catch (ApiException apiException) {
            list = new Vector<SplusDataResult>();
            list.add(WebServiceClient.handleSevereException((Exception)((Object)apiException)));
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            list = new Vector();
            list.add(WebServiceClient.handleSevereException((Exception)((Object)notAuthenticatedException)));
        }
        catch (IException iException) {
            list = new Vector();
            list.add(WebServiceClient.handleSevereException((Exception)((Object)iException)));
        }
        object = new Vector();
        for (int i = 0; list != null && i < list.size(); ++i) {
            splusDataResult = (SplusDataResult)list.get(i);
            ((Vector)object).add(WebServiceClient.packageSplusDataResult(splusDataResult));
        }
        return object;
    }

    public static Vector queryExpressionService(String string, String string2, String string3, String string4) {
        SplusDataResult splusDataResult = null;
        try {
            ExpressionService expressionService = new ExpressionService(string2, string3, string);
            splusDataResult = expressionService.getJob(string4);
        }
        catch (ApiException apiException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)apiException));
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)notAuthenticatedException));
        }
        catch (IException iException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)iException));
        }
        return WebServiceClient.packageSplusDataResult(splusDataResult);
    }

    public static Vector callExpressionService(String string, String string2, String string3, String string4, boolean bl) {
        SplusDataResult splusDataResult = null;
        try {
            ExpressionService expressionService = new ExpressionService(string2, string3, string);
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            splusDataResult = expressionService.eval(string4, bl2);
        }
        catch (ApiException apiException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)apiException));
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)notAuthenticatedException));
        }
        catch (IException iException) {
            splusDataResult = WebServiceClient.handleSevereException((Exception)((Object)iException));
        }
        return WebServiceClient.packageSplusDataResult(splusDataResult);
    }

    private static SplusDataResult handleSevereException(Exception exception) {
        Logger logger = Logger.getLogger(WebServiceClient.class.toString());
        logger.log(Level.SEVERE, exception.getMessage(), exception);
        SplusDataResult splusDataResult = WebServiceClient.getSplusDataResultInstance();
        splusDataResult.setError(WebServiceClient.getErrorMessage(exception));
        return splusDataResult;
    }

    protected static String getErrorMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception instanceof ServerNotRespondingException ? "Server Not Responding" : (exception instanceof NotAuthenticatedException ? "Invalid Credentials" : (exception instanceof JobDoesNotExistException ? "Job Does Not Exist On Server" : (exception instanceof BridgeException ? "Server Bridge Exception" : DEFAULT_ERROR_MESSAGE)));
        }
        return string;
    }

    private static Vector packageSplusDataResult(SplusDataResult splusDataResult) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(RESULT_NAMES);
        if (splusDataResult != null) {
            vector.add(splusDataResult.getCode());
            vector.add(splusDataResult.getCreated());
            vector.add(splusDataResult.getCreatedBy());
            vector.add(splusDataResult.getJobId());
            vector.add(splusDataResult.getStatus() != null ? splusDataResult.getStatus().name() : null);
            vector.add(splusDataResult.getResultsDir());
            vector.add(splusDataResult.getError());
            vector.add(splusDataResult.getWarnings());
            vector.add(splusDataResult.getTextOutput());
            try {
                if (splusDataResult.hasReturnValue().booleanValue() && splusDataResult.getReturnValue() != null) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        Marshaller marshaller = new Marshaller((Writer)stringWriter);
                        marshaller.setMapping(ServerPropertyManager.getXmlMapping());
                        marshaller.marshal((Object)splusDataResult.getReturnValue().getSplusValue());
                        vector.add(stringWriter.toString());
                    }
                    catch (IOException iOException) {
                        WebServiceClient.handleSevereException(iOException);
                    }
                    catch (MappingException mappingException) {
                        WebServiceClient.handleSevereException((Exception)((Object)mappingException));
                    }
                    catch (MarshalException marshalException) {
                        WebServiceClient.handleSevereException((Exception)((Object)marshalException));
                    }
                    catch (ValidationException validationException) {
                        WebServiceClient.handleSevereException((Exception)((Object)validationException));
                    }
                } else {
                    vector.add(null);
                }
            }
            catch (NullPointerException nullPointerException) {
                vector.add(null);
            }
            for (int i = 1; i < RESULT_NAMES.length + 1; ++i) {
                if (vector.get(i) != null) continue;
                vector.set(i, "");
            }
        } else {
            for (int i = 0; i < RESULT_NAMES.length; ++i) {
                vector.add("");
            }
        }
        return vector;
    }

    private static SplusDataResult getSplusDataResultInstance() {
        SplusDataResult splusDataResult = new SplusDataResult();
        splusDataResult.setHasError(Boolean.FALSE);
        splusDataResult.setHasReturnValue(Boolean.FALSE);
        splusDataResult.setHasTextOutput(Boolean.FALSE);
        splusDataResult.setHasWarnings(Boolean.FALSE);
        return splusDataResult;
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Object object;
        System.out.println(WebServiceClient.callExpressionService("http://atlantic:8080", "test", "fooasdf", "source(auto.print=T, echo=T, exprs.literal={1})", false));
        WebServiceClient.callExpressionService("http://vmlnx01:8080", "test", "foo", "2:10", false);
        WebServiceClient.callExpressionService("http://atlanticccc:8080", "test", "foo", "2:10", false);
        WebServiceClient.callExpressionService("http://atlantic:8080", "test", "foo", "2:10", false);
        SplusDataResult splusDataResult = null;
        try {
            object = new ExpressionService("admin", "admin", "http://atlantic:8080");
            serializable = Boolean.TRUE;
            splusDataResult = object.eval("1:10\nvalidate()\n1:10\n", (Boolean)serializable);
            Thread.sleep(10000L);
            object = new ExpressionService("admin", "admin", "http://atlantic:8080");
            splusDataResult = object.getJob(splusDataResult.getJobId());
            System.out.println(splusDataResult.getCode());
            System.out.println(splusDataResult.getTextOutput());
            object = new ExpressionService("admin", "admin", "http://atlantic:8080");
            serializable = Boolean.FALSE;
            splusDataResult = object.eval("1:10\nvalidate()\n1:10\n", (Boolean)serializable);
            System.out.println(splusDataResult.getCode());
            System.out.println(splusDataResult.getTextOutput());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = (String)WebServiceClient.queryExpressionService("http://atlantic:8080", "admin", "admin", "487").get(9);
        System.out.println(WebServiceClient.queryExpressionService("http://atlantic:8080", "admin", "admin", "487").get(9));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "", true));
        serializable = WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "lm(fuel.frame)", false);
        System.out.println(((Vector)serializable).get(9));
        Vector vector = WebServiceClient.callExpressionService("http://atlantic:8080", "admin", "admin", "lm(fuel.frame)", true);
        Vector vector2 = WebServiceClient.queryServer("http://atlantic:8080", "admin", "admin");
        System.out.println(vector);
        System.out.println(WebServiceClient.queryExpressionService("http://atlantic:8080", "admin", "admin", "487"));
        System.out.println(WebServiceClient.queryExpressionService("http://atlantic:8080", "admin", "admin", (String)vector.get(4)));
        System.out.println(WebServiceClient.queryExpressionService("http://atlantic:8080", "test", "test", (String)vector.get(4)));
        System.out.println(WebServiceClient.queryExpressionService("http://atlantic:8080", "admin", "test", (String)vector.get(4)));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "1:5", false));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "list(a=1)$a", false));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "validate()", false));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "{\nx<-5\nx}", true));
        System.out.println(WebServiceClient.callExpressionService("http://vmwin01:8080", "brianf", "foo", "\"asdf\"", true));
    }
}

