/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.web;

import com.insightful.splus.web.AdministrationServiceClient;
import com.insightful.splusserver.api.java.AdministrationService;
import com.insightful.splusserver.api.java.ExpressionService;
import com.insightful.splusserver.configuration.ServerPropertyManager;
import com.insightful.splusserver.domain.SplusDataResult;
import com.insightful.splusserver.domain.SplusJobs;
import com.insightful.splusserver.exception.GenericException;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceClientUtilities {
    private static final String EMPTY_STRING = "";
    private static final String[] RESULT_NAMES = new String[]{"splusCode", "created", "createdBy", "jobId", "status", "resultsDir", "error", "warnings", "output", "resultSpxml"};
    private static final String DEFAULT_ERROR_MESSAGE = "Server Error";
    public static final String DATE_TIME_PATTERN = "MM/dd/yyyy HH:mm:ss z";

    protected static String[] resultNames() {
        return RESULT_NAMES;
    }

    protected static String emptyString() {
        return EMPTY_STRING;
    }

    protected static String getErrorMessage(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception instanceof ServerNotRespondingException ? "Server Not Responding" : (exception instanceof NotAuthenticatedException ? "Invalid Credentials" : (exception instanceof JobDoesNotExistException ? "Job Does Not Exist On Server" : (exception instanceof BridgeException ? "Server Bridge Exception" : DEFAULT_ERROR_MESSAGE)));
        }
        return string;
    }

    protected static AdministrationService getAdministrativeServiceObject(String string, String string2, String string3) throws ServerNotRespondingException, GenericException, NotAuthenticatedException {
        AdministrationService administrationService = null;
        try {
            administrationService = string3 == null ? new AdministrationService(string) : new AdministrationService(string2, string3, string);
            return administrationService;
        }
        catch (ServerNotRespondingException serverNotRespondingException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)serverNotRespondingException));
            throw serverNotRespondingException;
        }
        catch (ApiException apiException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)apiException));
            throw new GenericException(apiException.getMessage());
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)notAuthenticatedException));
            throw notAuthenticatedException;
        }
    }

    protected static ExpressionService getExpressionService(String string, String string2, String string3) throws ServerNotRespondingException, GenericException, NotAuthenticatedException {
        try {
            ExpressionService expressionService = null;
            expressionService = string3 == null ? new ExpressionService(string) : new ExpressionService(string2, string3, string);
            return expressionService;
        }
        catch (ServerNotRespondingException serverNotRespondingException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)serverNotRespondingException));
            throw serverNotRespondingException;
        }
        catch (ApiException apiException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)apiException));
            throw new GenericException(apiException.getMessage());
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)notAuthenticatedException));
            throw notAuthenticatedException;
        }
    }

    protected static void logException(Class clazz, Exception exception) {
        Logger logger = Logger.getLogger(AdministrationServiceClient.class.toString());
        logger.log(Level.SEVERE, exception.getMessage(), exception);
    }

    protected static Vector<String> splusJobs2Vector(SplusJobs splusJobs) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < RESULT_NAMES.length; ++i) {
            vector.add(RESULT_NAMES[i]);
        }
        List list = splusJobs.getJobs();
        for (int i = 0; i < list.size(); ++i) {
            vector.addAll(WebServiceClientUtilities.splusDataResult2Vector((SplusDataResult)list.get(i), false));
        }
        return vector;
    }

    protected static Vector<String> splusDataResult2Vector(SplusDataResult splusDataResult, Boolean bl) {
        Vector<String> vector;
        block13: {
            int n;
            vector = new Vector<String>();
            if (bl.booleanValue()) {
                for (n = 0; n < RESULT_NAMES.length; ++n) {
                    vector.add(RESULT_NAMES[n]);
                }
            }
            if (splusDataResult != null) {
                vector.add(splusDataResult.getCode() != null ? splusDataResult.getCode() : EMPTY_STRING);
                vector.add(splusDataResult.getCreated() != null ? splusDataResult.getCreated() : EMPTY_STRING);
                vector.add(splusDataResult.getCreatedBy() != null ? splusDataResult.getCreatedBy() : EMPTY_STRING);
                vector.add(splusDataResult.getJobId() != null ? splusDataResult.getJobId() : EMPTY_STRING);
                vector.add(splusDataResult.getStatus() != null ? splusDataResult.getStatus().name() : EMPTY_STRING);
                vector.add(splusDataResult.getResultsDir() != null ? splusDataResult.getResultsDir() : EMPTY_STRING);
                vector.add(splusDataResult.getError() != null ? splusDataResult.getError() : EMPTY_STRING);
                vector.add(splusDataResult.getWarnings() != null ? splusDataResult.getWarnings() : EMPTY_STRING);
                vector.add(splusDataResult.getTextOutput() != null ? splusDataResult.getTextOutput() : EMPTY_STRING);
                try {
                    if (splusDataResult.hasReturnValue().booleanValue() && splusDataResult.getReturnValue() != null) {
                        try {
                            StringWriter stringWriter = new StringWriter();
                            Marshaller marshaller = new Marshaller((Writer)stringWriter);
                            marshaller.setMapping(ServerPropertyManager.getXmlMapping());
                            marshaller.marshal((Object)splusDataResult.getReturnValue().getSplusValue());
                            vector.add(stringWriter.toString());
                        }
                        catch (IOException iOException) {
                            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, iOException);
                            vector.add(EMPTY_STRING);
                        }
                        catch (MappingException mappingException) {
                            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)mappingException));
                            vector.add(EMPTY_STRING);
                        }
                        catch (MarshalException marshalException) {
                            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)marshalException));
                            vector.add(EMPTY_STRING);
                        }
                        catch (ValidationException validationException) {
                            WebServiceClientUtilities.logException(WebServiceClientUtilities.class, (Exception)((Object)validationException));
                            vector.add(EMPTY_STRING);
                        }
                        break block13;
                    }
                    vector.add(EMPTY_STRING);
                }
                catch (NullPointerException nullPointerException) {
                    vector.add(EMPTY_STRING);
                }
            } else {
                for (n = 0; n < RESULT_NAMES.length; ++n) {
                    vector.add(EMPTY_STRING);
                }
            }
        }
        return vector;
    }

    protected static SplusDataResult wrapExceptionInDataResult(Exception exception) {
        SplusDataResult splusDataResult = WebServiceClientUtilities.getSplusDataResultInstance();
        splusDataResult.setError(WebServiceClientUtilities.getErrorMessage(exception));
        return splusDataResult;
    }

    protected static SplusJobs wrapExceptionInSplusJobs(Exception exception) {
        ArrayList<SplusDataResult> arrayList = new ArrayList<SplusDataResult>();
        arrayList.add(WebServiceClientUtilities.wrapExceptionInDataResult(exception));
        SplusJobs splusJobs = new SplusJobs();
        splusJobs.setJobs(arrayList);
        return splusJobs;
    }

    private static SplusDataResult getSplusDataResultInstance() {
        SplusDataResult splusDataResult = new SplusDataResult();
        splusDataResult.setHasError(Boolean.FALSE);
        splusDataResult.setHasReturnValue(Boolean.FALSE);
        splusDataResult.setHasTextOutput(Boolean.FALSE);
        splusDataResult.setHasWarnings(Boolean.FALSE);
        return splusDataResult;
    }

    public static void main(String[] stringArray) {
    }
}

