/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.NumberAxisRange;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class CombinedHorizontalNumberAxis
extends HorizontalNumberAxis
implements CombinableAxis {
    private HorizontalNumberAxis parentAxis = null;
    private boolean visible = false;
    private double reserveHeight = 0.0;

    public CombinedHorizontalNumberAxis(HorizontalNumberAxis horizontalNumberAxis, boolean bl) {
        super(horizontalNumberAxis.getLabel(), horizontalNumberAxis.getLabelFont(), horizontalNumberAxis.getLabelPaint(), horizontalNumberAxis.getLabelInsets(), horizontalNumberAxis.isTickLabelsVisible(), horizontalNumberAxis.getTickLabelFont(), horizontalNumberAxis.getTickLabelPaint(), horizontalNumberAxis.getTickLabelInsets(), horizontalNumberAxis.getVerticalTickLabels(), horizontalNumberAxis.isTickMarksVisible(), horizontalNumberAxis.getTickMarkStroke(), horizontalNumberAxis.isAutoRange(), horizontalNumberAxis.autoRangeIncludesZero(), horizontalNumberAxis.autoRangeStickyZero(), horizontalNumberAxis.getAutoRangeMinimumSize(), horizontalNumberAxis.getMinimumAxisValue(), horizontalNumberAxis.getMaximumAxisValue(), horizontalNumberAxis.isInverted(), horizontalNumberAxis.isAutoTickUnitSelection(), horizontalNumberAxis.getTickUnit(), horizontalNumberAxis.isGridLinesVisible(), horizontalNumberAxis.getGridStroke(), horizontalNumberAxis.getGridPaint(), horizontalNumberAxis.isCrosshairVisible(), horizontalNumberAxis.getCrosshairValue(), horizontalNumberAxis.getCrosshairStroke(), horizontalNumberAxis.getCrosshairPaint());
        this.parentAxis = horizontalNumberAxis;
        this.visible = bl;
        this.setCrosshairVisible(horizontalNumberAxis.isCrosshairVisible());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (this.visible) {
            this.parentAxis.draw(graphics2D, rectangle2D, rectangle2D2);
        } else if (this.gridLinesVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
                graphics2D.setStroke(this.gridStroke);
                graphics2D.setPaint(this.gridPaint);
                Line2D.Float float_ = new Line2D.Float(f, (float)rectangle2D2.getMaxY(), f, (float)rectangle2D2.getMinY());
                graphics2D.draw(float_);
            }
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.reserveHeight > 0.0) {
            return this.reserveHeight;
        }
        return this.parentAxis.reserveHeight(graphics2D, plot, rectangle2D);
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (this.visible) {
            return this.parentAxis.reserveAxisArea(graphics2D, plot, rectangle2D, d);
        }
        return new Rectangle2D.Double();
    }

    public Axis getParentAxis() {
        return this.parentAxis;
    }

    public AxisRange getRange() {
        this.autoAdjustRange();
        return new NumberAxisRange(new Double(this.getMinimumAxisValue()), new Double(this.getMaximumAxisValue()));
    }

    public void setRange(AxisRange axisRange) {
        this.setAutoRange(false);
        Number number = (Number)axisRange.getMin();
        Number number2 = (Number)axisRange.getMax();
        this.setMinimumAxisValue(number.doubleValue());
        this.setMaximumAxisValue(number2.doubleValue());
        if (this.visible) {
            HorizontalNumberAxis horizontalNumberAxis = (HorizontalNumberAxis)this.getParentAxis();
            horizontalNumberAxis.setAutoRange(false);
            horizontalNumberAxis.setMinimumAxisValue(number.doubleValue());
            horizontalNumberAxis.setMaximumAxisValue(number2.doubleValue());
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setReserveDimension(double d) {
        this.reserveHeight = d;
    }
}

