/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.debug.core.model;

import com.insightful.splus.SplusSystem;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.debug.connection.DebugConnection;
import com.insightful.splus.eclipse.debug.core.SplusDebugPlugin;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class SplusDebugLineBreakpoint
extends LineBreakpoint
implements IBreakpointManagerListener {
    private static final String FUNCTION_NAME = "functionName";
    private static final String OUTER_FUNCTION_NAME = "outerFunctionName";
    private static final String FUNCTION_ADDRESS = "functionAddress";
    private String m_breakOuterFunction = "";
    private String m_breakFunction = null;
    private long[] m_breakAddress = null;
    private static HashMap g_markers = new HashMap();
    private static HashMap g_updatedResources = new HashMap();

    public SplusDebugLineBreakpoint() {
    }

    public SplusDebugLineBreakpoint(IResource iResource, int n, String string, String string2, long[] lArray) throws CoreException {
        final IResource iResource2 = iResource;
        final int n2 = n;
        this.m_breakFunction = string;
        this.m_breakOuterFunction = string2;
        this.m_breakAddress = lArray;
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource2.createMarker("com.insightful.splus.eclipse.debug.splusLineBreakpointMarker");
                iMarker.setAttribute(SplusDebugLineBreakpoint.FUNCTION_NAME, (Object)SplusDebugLineBreakpoint.this.m_breakFunction);
                iMarker.setAttribute(SplusDebugLineBreakpoint.OUTER_FUNCTION_NAME, (Object)SplusDebugLineBreakpoint.this.m_breakOuterFunction);
                iMarker.setAttribute(SplusDebugLineBreakpoint.FUNCTION_ADDRESS, (Object)SplusDebugLineBreakpoint.this.longArrayToString(SplusDebugLineBreakpoint.this.m_breakAddress));
                iMarker.setAttribute("lineNumber", n2);
                iMarker.setAttribute("org.eclipse.debug.core.id", (Object)"com.insightful.splus.eclipse.debug");
                SplusDebugLineBreakpoint.this.setMarker(iMarker);
                SplusDebugLineBreakpoint.this.setEnabled(true);
                SplusDebugLineBreakpoint.this.register(true);
            }
        };
        this.run(null, iWorkspaceRunnable);
    }

    public void setEnabled(boolean bl) throws CoreException {
        super.setEnabled(bl);
        this.doSetEnabled(bl);
    }

    private void doSetEnabled(boolean bl) {
        boolean bl2;
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        boolean bl3 = bl2 = bl && iBreakpointManager.isEnabled();
        if (bl2) {
            SplusDebugPlugin.getDefault().getDebugManager().addBreakpoint(this.m_breakFunction, this.m_breakOuterFunction, this.m_breakAddress);
        } else {
            SplusDebugPlugin.getDefault().getDebugManager().removeBreakpoint(this.m_breakFunction, this.m_breakOuterFunction, this.m_breakAddress);
        }
    }

    public void setMarker(IMarker iMarker) throws CoreException {
        NoConnection noConnection;
        super.setMarker(iMarker);
        this.m_breakFunction = (String)iMarker.getAttribute(FUNCTION_NAME);
        this.m_breakOuterFunction = (String)iMarker.getAttribute(OUTER_FUNCTION_NAME);
        this.m_breakAddress = this.stringToLongArray((String)iMarker.getAttribute(FUNCTION_ADDRESS));
        this.addMarker(iMarker);
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (this.isEnabled() && iBreakpointManager.isEnabled() && (noConnection = SplusEditorPlugin.getDefault().getConnection()) instanceof DebugConnection) {
            SplusDebugPlugin.getDefault().getDebugManager().addBreakpoint(this.m_breakFunction, this.m_breakOuterFunction, this.m_breakAddress);
        }
        iBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public void delete() throws CoreException {
        this.setEnabled(false);
        this.removeMarker(this.getMarker());
        super.delete();
    }

    protected void register(boolean bl) throws CoreException {
        if (bl) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void run(ISchedulingRule iSchedulingRule, IWorkspaceRunnable iWorkspaceRunnable) throws DebugException {
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iSchedulingRule, 0, null);
        }
        catch (CoreException coreException) {
            throw new DebugException(coreException.getStatus());
        }
    }

    public String getModelIdentifier() {
        return "com.insightful.splus.eclipse.debug";
    }

    public String getBreakpointFunction() {
        return this.m_breakFunction;
    }

    public long[] getBreakpointAddress() {
        return this.m_breakAddress;
    }

    private String longArrayToString(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(lArray[i]);
        }
        return stringBuffer.toString();
    }

    private long[] stringToLongArray(String string) {
        if (string == null) {
            return new long[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        long[] lArray = new long[stringTokenizer.countTokens()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Long.parseLong(stringTokenizer.nextToken());
        }
        return lArray;
    }

    public static void updateResources() {
        for (IMarker iMarker : g_markers.keySet()) {
            try {
                SplusDebugLineBreakpoint.updateResource(iMarker);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private static int getLineOffset(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (true) {
            if (n4 == n) {
                return n2 + 1;
            }
            if ((n2 = string.indexOf("\n", n2 + 1)) == -1) break;
            ++n4;
        }
        return -1;
    }

    private static void updateResource(IMarker iMarker) throws CoreException {
        IResource iResource = iMarker.getResource();
        if (!iMarker.exists()) {
            return;
        }
        boolean bl = iMarker.getAttribute("org.eclipse.debug.core.enabled").equals("true");
        if (iResource.getType() == 1 && bl) {
            IPath iPath = iResource.getLocation();
            String string = SplusParseTreeBuilder.toString((File)iPath.toFile());
            String string2 = (String)iMarker.getAttribute(FUNCTION_NAME);
            String string3 = iPath.toString();
            String string4 = string3 + ":" + string2;
            Long l = new Long(iResource.getModificationStamp());
            Object v = g_updatedResources.get(string4);
            String string5 = "";
            if (v == null || !l.equals(v)) {
                String[] stringArray = SplusParseTreeBuilder.getInstance().getSyntaxErrors(string);
                if (stringArray == null) {
                    PObject pObject = SplusParseTreeBuilder.getInstance().getParseTreeResult(string);
                    PObject pObject2 = SplusParseTreeBuilder.getFunctionDefinition((PObject)pObject, (String)string2);
                    if (pObject2 != null) {
                        int n = SplusParseTreeBuilder.getStartLine((PObject)pObject2);
                        int n2 = SplusParseTreeBuilder.getStartColumn((PObject)pObject2);
                        int n3 = SplusParseTreeBuilder.getEndLine((PObject)pObject2);
                        int n4 = SplusParseTreeBuilder.getEndColumn((PObject)pObject2);
                        int n5 = SplusDebugLineBreakpoint.getLineOffset(string, n) + n2 - 1;
                        int n6 = SplusDebugLineBreakpoint.getLineOffset(string, n3) + n4 + 1;
                        String string6 = "\"" + string2 + "\" <- " + string.substring(n5, n6);
                        StringBuffer stringBuffer = new StringBuffer();
                        block7: for (int i = 0; i < string6.length(); ++i) {
                            char c = string6.charAt(i);
                            switch (c) {
                                case '\'': {
                                    stringBuffer.append("\\'");
                                    continue block7;
                                }
                                case '\"': {
                                    stringBuffer.append("\\\"");
                                    continue block7;
                                }
                                case '\n': {
                                    stringBuffer.append("\\n");
                                    continue block7;
                                }
                                case '\r': {
                                    stringBuffer.append("\\r");
                                    continue block7;
                                }
                                case '\t': {
                                    stringBuffer.append("\\t");
                                    continue block7;
                                }
                                default: {
                                    stringBuffer.append(c);
                                }
                            }
                        }
                        String string7 = "source(text=\"" + stringBuffer.toString() + "\")";
                        SplusSystem.getEngineQueryHandler().processDataQuery(string7);
                        g_updatedResources.put(string4, l);
                        return;
                    }
                    string5 = string2 + " not found in file :\n" + string3 + "\n" + "Defunct breakpoint will be disabled.";
                    iMarker.setAttribute("org.eclipse.debug.core.enabled", (Object)"false");
                } else {
                    string5 = "Syntax errors found in " + string3 + ".\n" + "Unable to update function with breakpoints (" + string2 + ").";
                }
                if (string5.length() != 0) {
                    SplusEditorPlugin.displayWarning((String)"Unable to Update S-PLUS", (String)string5);
                }
            }
        }
    }

    private void addMarker(IMarker iMarker) {
        if (g_markers.get(iMarker) == null) {
            g_markers.put(iMarker, iMarker);
        }
    }

    private void removeMarker(IMarker iMarker) {
        if (g_markers.get(iMarker) != null) {
            g_markers.remove(iMarker);
        }
    }

    public void breakpointManagerEnablementChanged(boolean bl) {
        try {
            this.doSetEnabled(this.isEnabled() && bl);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

