#ifndef ATTRIBUTES_H
#define ATTRIBUTES_H

#include "Thread.h"


  /* The attributes controlling a thread.
     This is a composition of the native threads
     attributes (e.g. priorities) 
     and those for the S thread (such as the onExit 
     expression, etc.).

     Add to these as we go.
   */
#include "S_io.h"

typedef struct {

  ThreadAttributes native_attrs;
  s_connection *connections[3];

  long maxHistoryLength;   /* Controls the length of the previous tasks that are cached */

} SCThreadAttributes;


#define NUM_ATTR_SLOTS 8


typedef enum {
  Attr_ALL,
  Attr_CANCEL,
  Attr_ACCESS,
  Attr_DETACH,
  Attr_CONNECTIONS,
  Attr_PRIORITY,
  Attr_STACK_SIZE
} AttributeEntries;

typedef enum _ThreadAttributesSlots {
   S_PRIORITY=0,
   S_DETACH,
   S_CONNECTIONS,
   S_STACKSIZE,
   S_ACCESS,
   S_CANCEL,
   S_ONEXIT,
   S_SCHEDULE
} ThreadAttributeSlots;


void get_thread_attributes_slots(void);

#define INIT_ATTR_SLOTS pthread_once(&attributes_slot_once, get_thread_attributes_slots);

SCThreadAttributes *S_thread_attributes_to_C(s_object *s_attr, s_evaluator *S_evaluator);

#endif
