/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_mmap.h,v $: $Revision: #4 $, $Date: 2006/06/26 $  */
#ifndef S_MMAP_H
#define S_MMAP_H 1

#include "libext.h"
S_begin_extern_c

/* Public macros and functions taken from S_memory.h */
/* S_struct.h and S_tokens.h must be include before this file */

#define MAP_TAG(p) ((p)->map ? (p)->map->tag : 0)
#define SET_MAP_NOTIFY(obj, notify) ((obj)->map ? ((obj)->map->notify = notify) :\
  Recover("can't notify: not a mapped object", NULL_ENTRY, S_evaluator))

/* macros to create direct maps */
#define MAP_NUMERIC(p, length, notify) s_direct_map((char *)(p), S_MODE_DOUBLE, length, notify, S_evaluator)
#define MAP_INTEGER(p, length, notify) s_direct_map((char *)(p), S_MODE_INT, length, notify, S_evaluator)
#define MAP_LOGICAL(p, length, notify) s_direct_map((char *)(p), S_MODE_LGL, length, notify, S_evaluator)
#define MAP_SINGLE(p, length, notify) s_direct_map((char *)(p), S_MODE_REAL, length, notify, S_evaluator)
#define MAP_RAW(p, length, notify) s_direct_map((char *)(p), S_MODE_RAW, length, notify, S_evaluator)
#define MAP_CHARACTER(p, length, notify) s_direct_map((char *)(p), S_MODE_CHAR, length, notify, S_evaluator)
#define MAP_COMPLEX(p, length, notify) s_direct_map((char *)(p), S_MODE_COMPLEX, length, notify, S_evaluator)

LibExtern s_object *
s_direct_map(char *ptr, int mode, size_t length, s_map_notify notify, s_evaluator *S_evaluator);

S_end_extern_c
#include "unlibext.h"
#endif /* S_MMAP_H */
