/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_sig.h,v $: $Revision: #10 $, $Date: 2006/06/26 $  */
/***
   NAME   S_sig
   MODULE Sqpe
   PURPOSE
     Declare some signal handling related stuff (split off from S.h).
   NOTES
     
***/
#ifndef S_sigINCLUDED
#define S_sigINCLUDED 1

/* Pre-requisite includes go here. */
#include <S_ansi.h>

#include <signal.h>

/*
 * Type of value returned by a signal handler is void by
 * default.  This can be overridden by typedef'ing it in
 * system.h for the particular machine, and then #define'ing
 * S_SIG_DEFINED.  Also, type of the signal handler itself.
 */
#ifndef S_SIG_DEFINED
#define S_sig void S_CDECL 
#endif 
typedef void (S_CDECL *S_sigpf)(int);

/* definitions for signals that are not in the ANSI standard */
#ifndef SIGPIPE
#define SIGPIPE	13
#endif
#ifndef SIGQUIT
#define SIGQUIT 3
#endif
#ifndef SIGKILL
#define SIGKILL	9
#endif
#ifndef SIGALRM
#define SIGALRM	14
#endif

#endif /* S_sigINCLUDED */
