<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="S-PLUS">
		<html>
			<!-- create title for html page -->
			<title>Correlation Matrix for state.x77</title>

			<body>
				<!-- create a title for the top of the page -->
				<h2>Correlation Matrix for:<br/>
					<code>createXMLFile(format(cor(state.x77)), &quot;corXMLFile.xml&quot;)</code>
				</h2>
				<!-- create html table version of matrix -->
				<xsl:call-template name="Matrix">
					<xsl:with-param name="element" select="./Matrix"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="Matrix">
		<xsl:param name="element" select="''"/>

		<div>
			<!-- create table for display of data frame or of matrix -->
			<table cellspacing="1" cellpadding="5" border="1">
				 <!-- create a row of column headers -->
				 <tr>
				  	<th></th>
					<xsl:for-each select="$element/Columns/Column"><th><xsl:value-of select="@name"/></th></xsl:for-each>
				</tr>

				 <!-- create an html row for each row of data in the matrix -->
				<xsl:for-each select="$element/RowNames/Items/Item">
					<xsl:variable name="rowNumber" select="position()"/>
					<tr>
						<!-- first item is row header that contains row name -->
						<th><xsl:value-of select="./text()"/></th>

						<!-- add actual data...watch for factors and missng values -->
						<xsl:for-each select="../../../Columns/Column">
							<xsl:variable name="colType" select="./@type"/>
							<xsl:variable name="value" select="./Items/Item[$rowNumber]/text()"/>
							<xsl:variable name="levels" select="./Attrs/Attr[@name = '.Label']" />

							<td align="right">
								<xsl:choose>
									<!-- character value -->
									<xsl:when test="$colType= 'character'"><xsl:value-of select="$value"/></xsl:when>
									<!-- factor value -->
									<xsl:when test="$colType= 'factor'">
										<xsl:value-of select="$levels/Vector/Items/Item[position() = $value]/text()"/>
									</xsl:when>
									<!-- non-factor value -->
									<xsl:when test="count($levels) = 0"><xsl:value-of select="$value"/></xsl:when>
									<!-- missing factor -->
									<xsl:when test="$value = 'NA'"><xsl:text/></xsl:when>
								</xsl:choose>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</table>
		</div>
	</xsl:template>

</xsl:stylesheet>

