#ifndef __APRIORI_ENTRIES_H__
#define __APRIORI_ENTRIES_H__

// global types
#ifdef WIN32
typedef __int64 INT64;
#else
typedef long long INT64;
#endif

#undef APRIORI_API
#if defined(WIN32)
#define APRIORI_API(returnType) __declspec(dllexport) returnType __stdcall
#else
#define APRIORI_API(returnType) extern returnType
#endif

#if defined(ZEROSTRUCT)
typedef struct {} APRIORI_ISTREE;
typedef struct {} APRIORI_ITEMSET;
#else
#define APRIORI_ISTREE void
#define APRIORI_ITEMSET void
#endif

APRIORI_API(APRIORI_ITEMSET*) apriori_is_create();
APRIORI_API(void) apriori_ist_delete(APRIORI_ISTREE* apriori_istree);
APRIORI_API(void) apriori_is_delete(APRIORI_ITEMSET* apriori_itemset);
APRIORI_API(INT64) apriori_is_cnt(APRIORI_ITEMSET* iset);
APRIORI_API(void) apriori_read_transaction_start(APRIORI_ITEMSET* apriori_itemset);
APRIORI_API(INT64) apriori_add_item_to_hash(APRIORI_ITEMSET* apriori_itemset, const char* item_string, INT64 add_new_item);
APRIORI_API(INT64) apriori_read_transaction_add_item(APRIORI_ITEMSET* apriori_itemset, const char* item_string, INT64 add_new_item);
APRIORI_API(INT64) apriori_read_transaction_end(APRIORI_ITEMSET* apriori_itemset);
APRIORI_API(void) apriori_add_transaction_to_tree(APRIORI_ITEMSET* apriori_itemset, APRIORI_ISTREE* istree);
APRIORI_API(INT64) apriori_is_recode(APRIORI_ITEMSET* apriori_itemset, INT64 minfrq, INT64 sort_direction);
APRIORI_API(char) apriori_is_getapp(APRIORI_ITEMSET* apriori_itemset, INT64 i);
APRIORI_API(APRIORI_ISTREE*) apriori_ist_create(INT64 rule_support_both, INT64 cnt, INT64 supp, double conf, const char *apps);
APRIORI_API(void) apriori_ist_setcnt(APRIORI_ISTREE *apriori_istree, INT64 item, INT64 cnt);
APRIORI_API(INT64) apriori_is_getfrq(APRIORI_ITEMSET* apriori_itemset, INT64 item);
APRIORI_API(void) apriori_ist_settac(APRIORI_ISTREE *apriori_istree, INT64 cnt);
APRIORI_API(INT64) apriori_ist_check(APRIORI_ISTREE *apriori_istree, char *apps);
APRIORI_API(INT64) apriori_ist_height(APRIORI_ISTREE *apriori_istree);
APRIORI_API(INT64) apriori_ist_addlvl(APRIORI_ISTREE *apriori_istree);
APRIORI_API(void) apriori_ist_init(APRIORI_ISTREE *apriori_istree, INT64 minlen, INT64 arem, double minval);
APRIORI_API(INT64) apriori_extract_rule(APRIORI_ISTREE *apriori_istree, APRIORI_ITEMSET* apriori_itemset,
					     INT64 *supp, double *conf, double *lift, double *aval,
					     INT64 *body_supp, INT64* head_supp, INT64* set_supp);
APRIORI_API(const char*) apriori_extract_rule_item(APRIORI_ITEMSET* apriori_itemset, INT64 rule_item);

#endif /* __APRIORI_ENTRIES_H__ */


