<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="line-height">20pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-body">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="header">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="padding">
		<xsl:attribute name="padding-start">2pt</xsl:attribute>
		<xsl:attribute name="padding-end">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="text-align">right</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page" page-width="11in" page-height="8.5in">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body">
					<fo:block>
						<xsl:apply-templates />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></fo:block>

		<xsl:apply-templates select="NaiveBayesModel"/>
	</xsl:template>
	
	<xsl:template match="NaiveBayesModel">
		<xsl:variable name="dependentColumn" select="./XTProps/Property[@name='dependentColumn']/@value" />
		<xsl:variable name="columnInfoElement" select="../XTMetaData/ColumnDefinitions" />
		<xsl:variable name="independentColumns" select="./XTProps/Property[@name='counts']" />
				
		<fo:block xsl:use-attribute-sets="small-cap"><xsl:text>Dependent Column - </xsl:text><xsl:value-of select="$dependentColumn"/></fo:block>

		<xsl:call-template name="CreateTables">
			<xsl:with-param name="element" select="$independentColumns" />
			<xsl:with-param name="depCol" select="$dependentColumn" />
			<xsl:with-param name="columnInfo" select="$columnInfoElement" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="CreateTables">
		<xsl:param name="element" select="''" />
		<xsl:param name="depCol" select="''" />
		<xsl:param name="columnInfo" select="''" />
		
		<xsl:for-each select="$element/Property">
			<xsl:call-template name="CreateTable">
				<xsl:with-param name="element" select="." />
				<xsl:with-param name="depCol" select="$depCol" />
				<xsl:with-param name="columnInfo" select="$columnInfo" />
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="CreateTable">
		<xsl:param name="element" select="''" />
		<xsl:param name="depCol" select="''" />
		<xsl:param name="columnInfo" select="''" />
		
		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-width"><xsl:value-of select="string-length($element/@name) * 8"/>pt</xsl:attribute>
			</xsl:element>
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-width">
					<xsl:call-template name="DepLevelWidth">
						<xsl:with-param name="element" select="$columnInfo/ColumnInfo[@name=$element/@name]" />
						<xsl:with-param name="TotalNum" select="count($columnInfo/ColumnInfo[@name=$element/@name]/Level)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<xsl:for-each select="$columnInfo/ColumnInfo[@name=$depCol]/Level">
				<xsl:element name="fo:table-column">
					<xsl:attribute name="column-width">
						<xsl:call-template name="DepLevelWidth">
							<xsl:with-param name="element" select="$columnInfo/ColumnInfo[@name=$depCol]" />
							<xsl:with-param name="TotalNum" select="count($columnInfo/ColumnInfo[@name=$depCol]/Level)" />
							<xsl:with-param name="minWidth" select="100" />
						</xsl:call-template>pt
					</xsl:attribute>
				</xsl:element>
			</xsl:for-each>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<xsl:element name="fo:table-cell">
						<xsl:attribute name="column-number">1</xsl:attribute>
						<xsl:attribute name="background-color">#82C0FF</xsl:attribute>
						<xsl:attribute name="text-align">left</xsl:attribute>
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:attribute name="number-columns-spanned"><xsl:value-of select="count($columnInfo/ColumnInfo[@name=$depCol]/Level) + 2" /></xsl:attribute>
						<fo:block><xsl:value-of select="$element/@name"/><xsl:text> and </xsl:text><xsl:value-of select="$depCol"/></fo:block>
					</xsl:element>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell column-number="1" number-columns-spanned="2" background-color="#82C0FF"><fo:block></fo:block></fo:table-cell>
					<xsl:element name="fo:table-cell">
						<xsl:attribute name="column-number">3</xsl:attribute>
						<xsl:attribute name="background-color">#CCE6FF</xsl:attribute>
						<xsl:attribute name="text-align">center</xsl:attribute>
						<xsl:attribute name="font-weight">bold</xsl:attribute>
						<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
						<xsl:attribute name="border-start-style">double</xsl:attribute>
						<xsl:attribute name="border-start-width">2pt</xsl:attribute>
						<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
						<xsl:attribute name="border-end-style">double</xsl:attribute>
						<xsl:attribute name="border-end-width">2pt</xsl:attribute>
						<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
						<xsl:attribute name="border-before-style">double</xsl:attribute>
						<xsl:attribute name="border-before-width">2pt</xsl:attribute>
						<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
						<xsl:attribute name="border-after-style">double</xsl:attribute>
						<xsl:attribute name="border-after-width">2pt</xsl:attribute>
						<xsl:attribute name="number-columns-spanned"><xsl:value-of select="count($columnInfo/ColumnInfo[@name=$depCol]/Level)" /></xsl:attribute>
						<xsl:attribute name="text-align">center</xsl:attribute>
						<fo:block><xsl:value-of select="$depCol"/></fo:block>
					</xsl:element>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell number-columns-spanned="2" background-color="#82C0FF"><fo:block></fo:block></fo:table-cell>
					<xsl:for-each select="$columnInfo/ColumnInfo[@name=$depCol]/Level">
						<fo:table-cell xsl:use-attribute-sets="header left right top bottom padding" background-color="#CCE6FF"><fo:block><xsl:value-of select="./@value"/></fo:block></fo:table-cell>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:for-each select="$element/Property">
					<xsl:variable name="indepName" select="$element/@name"/>
					<xsl:variable name="position" select="position()" />
					<xsl:variable name="propElement" select="." />

					<fo:table-row>						
						<xsl:element name="fo:table-cell">
							<xsl:attribute name="text-align">left</xsl:attribute>
							<xsl:attribute name="font-weight">bold</xsl:attribute>
							<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-start-style">double</xsl:attribute>
							<xsl:attribute name="border-start-width">2pt</xsl:attribute>
							<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-end-style">double</xsl:attribute>
							<xsl:attribute name="border-end-width">2pt</xsl:attribute>
							<xsl:attribute name="background-color">#CCE6FF</xsl:attribute>
							<xsl:choose>
								<xsl:when test="position()=1">
									<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
									<xsl:attribute name="border-before-style">double</xsl:attribute>
									<xsl:attribute name="border-before-width">2pt</xsl:attribute>
									<fo:block><xsl:value-of select="$indepName"/></fo:block>
								</xsl:when>
								<xsl:when test="position()=last()">
									<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
									<xsl:attribute name="border-after-style">double</xsl:attribute>
									<xsl:attribute name="border-after-width">2pt</xsl:attribute>
									<fo:block><xsl:text></xsl:text></fo:block>
								</xsl:when>
								<xsl:otherwise>
									<fo:block><xsl:text></xsl:text></fo:block>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:element>
	
						<fo:table-cell background-color="#CCE6FF" xsl:use-attribute-sets="cell left right top bottom">
							<fo:block><xsl:value-of select="./@name"/></fo:block>
						</fo:table-cell>

						<xsl:for-each select="$columnInfo/ColumnInfo[@name=$depCol]/Level">
							<xsl:variable name="levelNum" select="position()" />
							<xsl:variable name="levelCount" select="$propElement/Property[$levelNum]/@value"/>
							
							<xsl:element name="fo:table-cell">
								<xsl:attribute name="background-color">
									<xsl:choose>
										<xsl:when test="$position mod 2 = 0">#FFFFFF</xsl:when>
										<xsl:otherwise>#EEEEEE</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
								<xsl:attribute name="border-start-style">double</xsl:attribute>
								<xsl:attribute name="border-start-width">2pt</xsl:attribute>
								<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
								<xsl:attribute name="border-end-style">double</xsl:attribute>
								<xsl:attribute name="border-end-width">2pt</xsl:attribute>
								<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
								<xsl:attribute name="border-before-style">double</xsl:attribute>
								<xsl:attribute name="border-before-width">2pt</xsl:attribute>
								<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
								<xsl:attribute name="border-after-style">double</xsl:attribute>
								<xsl:attribute name="border-after-width">2pt</xsl:attribute>
								<xsl:attribute name="text-align">right</xsl:attribute>
								<fo:block>
									<xsl:choose>
										<xsl:when test="not(boolean($levelCount))">0</xsl:when>
										<xsl:otherwise><xsl:value-of select="$levelCount"/></xsl:otherwise>
									</xsl:choose>
								</fo:block>
							</xsl:element>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell number-columns-spanned="2" background-color="#CCE6FF" xsl:use-attribute-sets="left right top bottom" text-align="center"><fo:block>Totals</fo:block></fo:table-cell>

					<xsl:for-each select="$columnInfo/ColumnInfo[@name=$depCol]/Level">
						<xsl:variable name="curLevel" select="." />

						<xsl:element name="fo:table-cell">
							<xsl:attribute name="background-color">
								<xsl:choose>
									<xsl:when test="count($element/Property) mod 2 = 1">#FFFFFF</xsl:when>
									<xsl:otherwise>#EEEEEE</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-start-style">double</xsl:attribute>
							<xsl:attribute name="border-start-width">2pt</xsl:attribute>
							<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-end-style">double</xsl:attribute>
							<xsl:attribute name="border-end-width">2pt</xsl:attribute>
							<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-before-style">double</xsl:attribute>
							<xsl:attribute name="border-before-width">2pt</xsl:attribute>
							<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
							<xsl:attribute name="border-after-style">double</xsl:attribute>
							<xsl:attribute name="border-after-width">2pt</xsl:attribute>
							<xsl:attribute name="text-align">right</xsl:attribute>
							<fo:block>
								<xsl:call-template name="Summation">
									<xsl:with-param name="Property" select="$element"/>
									<xsl:with-param name="DepLevel" select="$curLevel/@value" />
									<xsl:with-param name="CurrentNum" select="1" />
									<xsl:with-param name="TotalNum" select="count($element/Property)" />
									<xsl:with-param name="summation" select="0" />
								</xsl:call-template>
							</fo:block>
						</xsl:element>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="DepLevelWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/Level[$CurrentNum]/@value" />
		<xsl:variable name="thisWidth" select="string-length($this) * 8" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="DepLevelWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="DepLevelWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="Summation">
		<xsl:param name="Property" select="''" />
		<xsl:param name="DepLevel" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="summation" select="0" />

		<xsl:variable name="numValues" select="count($Property/Property[$CurrentNum]/Property[@name=$DepLevel])"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$numValues=0"><xsl:value-of select="$summation"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$summation + $Property/Property[$CurrentNum]/Property[@name=$DepLevel]/@value"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$numValues=0">
						<xsl:call-template name="Summation">
							<xsl:with-param name="Property" select="$Property"/>
							<xsl:with-param name="DepLevel" select="$DepLevel" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="summation" select="$summation"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="Summation">
							<xsl:with-param name="Property" select="$Property"/>
							<xsl:with-param name="DepLevel" select="$DepLevel" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="summation" select="$summation + $Property/Property[$CurrentNum]/Property[@name=$DepLevel]/@value" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
