/**
 * This extension of ClientObjectFactoryImpl overrides the shutdown
 *   method to notify the client rather than kill the client.
 *   (The client can then kill itself if it wants to.)
 * The class keeps a list of listeners and notifies them when
 *   the server shuts down.
 * This is a more generic version of a client object factory,
 *   hence the name.
 *
 * author Gary Nelson, gnelson@insightful.com
 * version 19 April 2001
 **/

import java.util.Vector;
import java.util.Iterator;
import javax.swing.event.*;
import java.rmi.RemoteException;
import com.insightful.splus.ClientObjectFactoryImpl;


public class ClientObjFactoryGeneric extends ClientObjectFactoryImpl
{
	// Constructor is required to throw a remote exception.
	public ClientObjFactoryGeneric() throws RemoteException {
		m_vecListeners = new Vector();
	}

	protected Vector m_vecListeners;
	public synchronized void addChangeListener(ChangeListener listener) {
		m_vecListeners.add(listener);
	}
	public synchronized void removeChangeListener(ChangeListener listener) {
		m_vecListeners.remove(listener);
	}

	public void shutdown()
		throws RemoteException
	{
		ChangeEvent ev = new ChangeEvent(this);
		Iterator it = m_vecListeners.iterator();
		while (it.hasNext()) {
			((ChangeListener) it.next()).stateChanged(ev);
		}
	}
}
