/**
 * SplusServlet is a simple servlet that receives S-PLUS
 *   expressions, passes them on to S-PLUS, and responds
 *   with the output from S-PLUS.
 * The servlet gives command-line access to the S-PLUS
 *   session running behind a Web browser, 
 *
 * author Gary Nelson, gnelson@insightful.com
 * version 24 April 2001
 */

import java.io.*;
import javax.servlet.http.*;
import javax.servlet.*;
import com.insightful.splus.*;


public class SplusServlet extends HttpServlet
{
	/* S-PLUS connection manager for this Web site */
	protected SpConnectionManager m_mgr = null;

	/* Initialize the servlet. */
	public void init() 
	throws ServletException
	{
		// Get a connections manager for S+AS 2.0.
		m_mgr = SpConnectionManager.getManager(
			getServletContext());
	}

	/* Shut down the servlet. */
	public void destroy() {
		m_mgr.release();
	}
		
	/* Respond to a GET request. */
	protected void doGet(HttpServletRequest req,
			HttpServletResponse resp)
		throws ServletException, IOException
	{
		String strExp = req.getQueryString();
		respond(resp, strExp);
	}

	/* Respond to a POST request. */
	protected void doPost(HttpServletRequest req,
			HttpServletResponse resp)
	throws ServletException, IOException
	{
		String strExp = req.getParameter("expression");
		respond(resp, strExp);
	}

	/* Respond. */
	protected void respond(HttpServletResponse resp, String strExp)
	throws IOException
	{
		SplusDataResult spdr = m_mgr.eval(strExp,
			true, false, true, true, false);

		String strOutput = spdr.hasOutput() ?
			spdr.getOutput() : "";
		String[] vstrWarnings = spdr.hasWarning() ?
			spdr.getWarning() : null;
		String strError = spdr.hasError() ?
			spdr.getError() : null;

		// Format the response as HTML.
		// Using a sting buffer allows us to report
		//   the length of the page.
		StringBuffer buf = new StringBuffer();
		buf.append("<HTML>\n");
		buf.append("<HEAD>\n");
		buf.append("<TITLE>S-PLUS: " + strExp + "</TITLE>\n");
		buf.append("</HEAD>\n");
		buf.append("<BODY>\n");
		buf.append("<H1>S-PLUS Response</H1>\n");
		buf.append("<P>Command: <EM>" + strExp+ "</EM>:\n");
		buf.append("<P><BLOCKQUOTE><PRE>\n" + strOutput +
			"</PRE></BLOCKQUOTE>\n");

		if (vstrWarnings != null) {
			buf.append("<H2>S-PLUS Warning(s)</H2>\n");
			buf.append("<BLOCKQUOTE><PRE>\n");
			for (int i = 0; i < vstrWarnings.length; i++) {
				buf.append(vstrWarnings[i] + '\n');
			}
			buf.append("</PRE></BLOCKQUOTE>\n");
		}

		if (strError != null) {
			buf.append("<H2>S-PLUS Error</H2>\n");
			buf.append("<BLOCKQUOTE><PRE>\n" + strError +
				"\n</PRE></BLOCKQUOTE>\n");
		}

		buf.append("<H1>Next Expression:</H1>\n");
		buf.append("<FORM ACTION=\"\" " +
			"METHOD=\"POST\">\n");
		buf.append("<INPUT NAME=\"expression\">\n");
		buf.append("<INPUT TYPE=\"SUBMIT\" VALUE=\"Evaluate\">\n");
		buf.append("</FORM>\n");

		buf.append("</BODY>\n");
		buf.append("</HTML>");

		// Pass the response to the client.
		resp.setContentType("text/html");
		resp.setContentLength(buf.length());
		resp.getOutputStream().print(buf.toString());
	}
}
