import com.insightful.splus.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class GraphButtonsExample {

  static ActionListener buttonActionListener;

  public static void main(String [] args){

    // Get the graph component
    JComponent splusGraph = SplusUserApp.getGraph();

    // Create the window
    JFrame window = new JFrame("Graph Buttons Example");

    // Create buttons which query S-PLUS to produce graphs

    buttonActionListener = new ActionListener(){
      public void actionPerformed(ActionEvent e){
	String cmd = e.getActionCommand() + "\n";
	try {
	  SplusUserApp.eval(cmd, false, false,
			    false, false, false);
	}
	catch (Exception ex) {
	  System.out.println(ex);
	}
      }
    };
    
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel,
					BoxLayout.Y_AXIS));
    buttonPanel.add(makeButton("plot(sin(1:10))"));
    buttonPanel.add(makeButton("plot(rnorm(100))"));
    buttonPanel.add(makeButton(
			       "print(example.normal.qq())"));
    buttonPanel.add(makeButton("show colors, linetypes",
			       "{image(matrix(data=1:100,nrow=10,ncol=10));" +
			       "for (a in 1:50) { ang <- a*0.06; " + 
			       "lines(c(5,5+10*cos(ang))," +
			       "c(5,5+10*sin(ang)), col=a) };for (a in 1:50) { " +
			       "ang <- -a*0.06; lines(c(5,5+10*cos(ang)), " +
			       "c(5,5+10*sin(ang)), lty=a) }}"));
    buttonPanel.add(makeButton(
			       "for (x in 1:10) plot(1:x)"));
    
    // Create an Exit button
    
    JButton exitButton = new JButton("Exit");
    exitButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent ae){
        System.exit(0);
      }
    });
    
    // Also exit if the window is closed by the user
    
    window.addWindowListener(new WindowAdapter(){
      public void windowClosing(WindowEvent e){
        System.exit(0);
      }
    });
    
    // Add the elements to the content pane
    Container contentPane = window.getContentPane();
    contentPane.setLayout(new BorderLayout());
    contentPane.add(splusGraph, BorderLayout.CENTER);
    contentPane.add(buttonPanel, BorderLayout.EAST);
    contentPane.add(exitButton, BorderLayout.SOUTH);
    
    // Show the window
    window.setSize(600, 400);
    window.show();
  }
  
  // Utility methods to create a button
  private static JButton makeButton(String splusCode){
    return makeButton(splusCode, splusCode);
  }

  private static JButton makeButton(String buttonName,
    String splusCode){
    JButton b = new JButton(buttonName);
    b.setActionCommand(splusCode);
    b.addActionListener(buttonActionListener);
    return b;
  } 
}



