#include <cdefs.h>

#if defined(HPUX)
SPLUS_LIBRARY=libsconnect.sl
#else
SPLUS_LIBRARY=libsconnect.so
#endif

#if defined(linux)
/* need to undef linux for LOCAL_LIBS */
#undef linux

/* need to undef i386 for LOCAL_LIBS */
#if defined(i386)
#define i386_BAK 1
#undef i386
#endif

LOCAL_LIBS=-lstdc++\ -D_PTHREADS

/* redefine i386 */
#if defined(i386_BAK)
#define i386 1
#undef i386_BAK
#endif

/* redfine linux */
#define linux 1

#elif defined(SUNOS5)
LOCAL_LIBS=-lCstd
#else
LOCAL_LIBS=
#endif

#if( defined(WIN32) )
OBJS= sconnect_com.o  spchar.o      spint.o       spmatrix.o      spolecli_com.o \
      sconnect_gen.o  spchar_com.o  spint_com.o   spmatrix_com.o  spproxy.o \
      spalcfrm.o      spconnec.o    splang.o      spnamed.o       sprecurs.o \
      sparray.o       spengcon.o    splist.o      spnum.o         spstruct.o \
      spattach.o      speval.o      splist_com.o  spnum_com.o     spvariant.o \
      spbrace.o       spexcept.o    splog.o       spobject.o      spvector.o \
      spcall.o        spfunc.o      splog_com.o   spolecli.o      spvector_com.o
#else /* UNIX */
OBJS= spchar.o      spint.o       spmatrix.o \
      sconnect_gen.o  spproxy.o \
      spalcfrm.o      spconnec.o    splang.o      spnamed.o       sprecurs.o \
      sparray.o       spengcon.o    splist.o      spnum.o         spstruct.o \
      spattach.o      speval.o      \
      spbrace.o       spexcept.o    splog.o       spobject.o      spvector.o \
      spcall.o        spfunc.o
#endif

all : $(OBJS)
update :
	echo "Nothing for update to do in slocal/sconnect, libraries made by S_MAKE install"
install.funs : $(QFILES)
	QINSTALL $(DEST)/$(FUNS_DIR) $(QFILES)
install : $(OBJS) monitor libsconnect
	cp -f $(SPLUS_LIBRARY) $(L)
	cp -f sconnect-monitor $(SHOME)/cmd
	sleep 1 ; touch $@
libsconnect : $(OBJS)
#if defined(SUNOS5)
	$(CXX) -G -o $(SPLUS_LIBRARY) $(OBJS) $(MISC_CXXFLAGS) $(LOCAL_LIBS)
#elif defined(IBMRS6000)
POUND We should use LIBRARY when that is fixed up on AIX.
POUND	${SHOME}/cmd/LIBRARY $(SPLUS_LIBRARY) $(OBJS) $(LOCAL_LIBS)
	$(CXX) -G -qmkshrobj -brtl -bdynamic -bhalt:5 -o $(SPLUS_LIBRARY) $(OBJS) -L$(SHOME)/newfun/lib -lSqpe $(LOCAL_LIBS)
#else
	${SHOME}/cmd/LIBRARY $(SPLUS_LIBRARY) $(OBJS) $(LOCAL_LIBS)
#endif
monitor: sconnect-monitor.c
#if defined(HPUX)
	$(CXX) -AA -mt -DSYSV sconnect-monitor.c -o sconnect-monitor
#else
	$(CC) sconnect-monitor.c -o sconnect-monitor
#endif


