/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
 
	spbrace.h: interface for the CSPbrace wrapping S-PLUS object of class "{". 
*/

#if !defined(__SCONNECT_SPBRACE_H_INCLUDED__)
#define __SCONNECT_SPBRACE_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "splang.h"

class SCONNECT_LIB_EXTERN CSPbrace : public CSPlanguage  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPbrace();
	//Copy constructor: copy appropriate data members
	CSPbrace(const CSPbrace& sObject);
	//Construct from object of a base class
	CSPbrace(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPbrace(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPbrace(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPbrace& operator=(const CSPbrace& sObject);
	//Assign from the base class
	CSPbrace& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPbrace& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPbrace();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Attach an S object and coerce to appropriate class that override this method
	virtual void Attach(s_object *ps_object, BOOL bTryToFreeOnDetach=FALSE);

  //Return TRUE if the object is a valid numeric class
	virtual BOOL IsValid(void) const;
	//If not valid object, throw execption
	void Validate(void) const;
	virtual CSPobject Eval(void) const;           //Eval in current eval frame
	virtual CSPobject Eval(long lFrame) const     //Eval in lFrame 
	{
		return CSPlanguage::Eval(lFrame);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs) const              //Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs);
	}
	virtual CSPobject Eval(const CSPnamed& sArgs, long lFrame) const//Eval in current eval frame
	{
		return CSPlanguage::Eval(sArgs, lFrame);
	}

};

#endif // !defined(__SCONNECT_SPBRACE_H_INCLUDED__)
