/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#ifdef WIN32

#include "windows.h"
#include "oleauto.h"

#include "spchar.h"
#include "spvariant.h"

int CSPcharacter::GetVariantType( void )
{
	return VT_BSTR;
}

BOOL CSPcharacter::GetAsVariant(void *pvVariant, BOOL bMissingsAsErrors, BOOL bValidate)
{
	BOOL bSuccess = FALSE;
#ifndef WIN32
	return bSuccess;
#endif // !WIN32

	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if( !pvVariant )
		return bSuccess;

	LPVARIANT lpReturnVariant = (LPVARIANT)pvVariant;
	memset( lpReturnVariant, 0, sizeof(VARIANT) );

	long vecLength = GetLength(FALSE);
	if ( vecLength <= 0 )
		return bSuccess;

	if ( vecLength > 1 || m_b2DGet )
	{
		SAFEARRAYBOUND aDim[2]; 
		aDim[0].lLbound = 1; 
		aDim[0].cElements = vecLength;
		aDim[1].lLbound = 1; 
		aDim[1].cElements = 1;

		// Allocate and init safearray
		SAFEARRAY *psaVector = SafeArrayCreate(VT_VARIANT, 2, aDim);
		if ( !psaVector )
			return bSuccess; // ERROR_NOT_ENOUGH_MEMORY;

		// Lock down data in safe array and get it into a pointer
		void *pvData = NULL;
		HRESULT hr = SafeArrayAccessData (psaVector, &pvData);
		if ( hr != S_OK || !pvData )
			return bSuccess;

		// Copy the data
		VARIANT *pVariantArray = (VARIANT *)pvData;
		memset( pVariantArray, 0, sizeof(VARIANT) * vecLength );
		void *pvRawData = GetRawPtr(FALSE);
		int *pDataSizes = new int[vecLength];
		for( long i=0; i<vecLength; i++ )
		{
			pDataSizes[i] = GetElementSize();
			pVariantArray[i].vt = VT_BSTRA;
		}
		bSuccess = ConvertByteArrayToVariantArray(
			pVariantArray,
			(char *)pvRawData,
			vecLength,
			pDataSizes,
			bMissingsAsErrors );
		if ( pDataSizes )
			delete [] pDataSizes;

		// Release the ref on the safearray
		hr = SafeArrayUnaccessData (psaVector);
		if ( hr != S_OK )
			return bSuccess;

		lpReturnVariant->vt = VT_ARRAY | VT_VARIANT;
		lpReturnVariant->parray = psaVector;
	}
	else
	{
		void *pvRawData = GetRawPtr(FALSE);
		bSuccess = ConvertVoidPtrToVariant(
			lpReturnVariant,
			pvRawData,
			VT_BSTRA,
			GetElementSize(),
			bMissingsAsErrors );
	}
	return bSuccess;
}

#endif // WIN32
