/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	splist.h: interface for the CSPlist class.
*/
#ifndef SCONNECT_SPLIST_H
#define SCONNECT_SPLIST_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "sprecurs.h"
#include "spchar.h"
#include "spnamed.h"

class SCONNECT_LIB_EXTERN CSPlist : public TSPvector<s_object*, S_MODE_LIST>  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPlist();
	//Copy constructor: copy appropriate data members
	CSPlist(const CSPlist& sObject);
	//Construct from object of a base class
	CSPlist(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPlist(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPlist(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPlist& operator=(const CSPlist& sObject);
	//Assign from the base class
	CSPlist& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPlist& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPlist();

	//Construct a 'list' of with a specified length 
	explicit CSPlist(long lLength);
	explicit CSPlist(int  nLength);
	explicit CSPlist(const CSPlistNamed& slistNamed);
	CSPlist& operator=(const CSPlistNamed& slistNamed);
//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Proxy to assist indexing operator for lvalue/rvalue, type conversions and ref count.
	class SCONNECT_LIB_EXTERN CProxy : public TSPvector<s_object*, S_MODE_LIST>::CSPvectorProxy
	{
	public:
		CProxy(CSPlist& sVector, long lZeroBasedIndex);
		CProxy(const CProxy& proxyRhs);
		CProxy& operator=(long lRhs);
		CProxy& operator=(double dRhs);
		CProxy& operator=(const s_object* ps_object);
		CProxy& operator=(const CProxy& proxyRhs);
	};
	CSPlist& operator=(const CProxy& proxyRhs);

	// Zero-based indexing
	const s_object* GetAt(long lZeroIndex, BOOL bValidate=TRUE) const;
	s_object*& GetAt(long lZeroIndex, BOOL bValidate=TRUE);
	const s_object* GetAt(int nZeroIndex, BOOL bValidate=TRUE) const
	{
	  return GetAt((long)nZeroIndex, bValidate);
	}
	s_object*& GetAt(int nZeroIndex, BOOL bValidate=TRUE)
	{
	  return GetAt((long)nZeroIndex, bValidate);
	}

	const s_object* GetAt( const char *pszName, BOOL bValidate=TRUE ) const;
	s_object*& GetAt( const char *pszName, BOOL bValidate=TRUE );
	void SetAt(const char* pszName, s_object* ps_element, BOOL bValidate=TRUE);
	void SetAt(long lZeroIndex, s_object* ps_element, BOOL bValidate=TRUE);
	void SetAt(int nZeroIndex, s_object* ps_element, BOOL bValidate=TRUE)
	{
		SetAt((long)nZeroIndex, ps_element, bValidate);
	}

	//Subscripting, C style zero-based and Fortran one-based-indexing: must over-load all required [] and ().
	const s_object* operator[](int nZeroBasedIndex) const //rvalue only
	{ return MyTypeValue(&(*this), nZeroBasedIndex);}
	CProxy operator[](int nZeroBasedIndex)//both lvalue and rvalue     
	{ return CProxy(*this, nZeroBasedIndex);}
	//Subscripting, Fortran style and one-based-indexing
	const s_object* operator()(int nOneBasedIndex) const 
	{ return MyTypeValue(&(*this), nOneBasedIndex-1L);}
	CProxy operator()(int nOneBasedIndex)            
	{ return CProxy(*this, nOneBasedIndex-1);}
	//long arguments are needed to avoid ambiguity between int and operator s_object*()
	const s_object* operator[](long lZeroBasedIndex) const 
	{	return MyTypeValue(&(*this), lZeroBasedIndex);}
	CProxy operator[](long lZeroBasedIndex)            
	{	return CProxy(*this, lZeroBasedIndex);}
	const s_object* operator()(long lOneBasedIndex) const 
	{ return MyTypeValue(&(*this), lOneBasedIndex-1L);}
	CProxy operator()(long lOneBasedIndex)            
	{ return CProxy(*this, lOneBasedIndex-1);}
	// By name
	CProxy operator()( const char* pszName );
	CProxy operator[]( const char* pszName );

	//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
	s_object*& GetAtDirect(long lZeroIndex, BOOL bValidate=TRUE);
	s_object*& GetAtDirect( const char *pszName, BOOL bValidate=TRUE );
	void SetAtDirect(long lZeroIndex, s_object* ps_element, BOOL bValidate=TRUE);
	void SetAtDirect(const char* pszName, s_object* ps_element, BOOL bValidate=TRUE);
	long Add(s_object *element, BOOL bValidate=TRUE);
	long Append( s_object *list, BOOL bValidate=TRUE );
	// Insert element at index: zero-base
	virtual BOOL InsertAt(s_object* ps_object, long lElement, const char* pszName=NULL, BOOL bValidate=TRUE);
	BOOL SetNames(s_object *names, BOOL bValidate=TRUE);
	CSPcharacter GetNames(BOOL bValidate=TRUE) const;
	// Remove vector at index: zero-base
	virtual BOOL RemoveAt(long lElement, long nElement=1, BOOL bValidate=TRUE);
	// Remove vector with name
	virtual BOOL RemoveAt(const char* pszName, BOOL bValidate=TRUE);
	s_object* GetData(BOOL bValidate=TRUE) const;

#ifdef WIN32
	#include "splist_com.h"
#endif

};

#endif // SCONNECT_SPLIST_H
