/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

// SPint.cxx: implementation of the CSPlogical class.
//
//////////////////////////////////////////////////////////////////////

#include <memory.h>
#include "splog.h"
#include "speval.h"
#include "spalcfrm.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//////////////////////// CSPlogical ////////////////////////

//Default constructor
CSPlogical::CSPlogical()
: TSPvector<long, S_MODE_LGL>()
{
}
//Copy constructor 
CSPlogical::CSPlogical(const CSPlogical& sObject)
: TSPvector<long, S_MODE_LGL>()
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a base class object
CSPlogical::CSPlogical(const CSPobject& sObject)
: TSPvector<long, S_MODE_LGL>()
{	
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a valid S-expression
CSPlogical::CSPlogical(const char* pszExpression)
: TSPvector<long, S_MODE_LGL>(pszExpression)
{
}
//Construct from a valid S object
CSPlogical::CSPlogical(s_object* ps_object, BOOL bTryToFreeOnDetach)
: TSPvector<long, S_MODE_LGL>()
{
	Attach(ps_object, bTryToFreeOnDetach);
}
//Assigment from the same class
CSPlogical& CSPlogical::operator=(const CSPlogical& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the base class
CSPlogical& CSPlogical::operator=(const CSPobject& sObject)
{
	Attach(&sObject, TRUE);
	return *this;
}
//Assigment from the S object
CSPlogical& CSPlogical::operator=(s_object* ps_object)
{
	Attach(ps_object, FALSE);
	return *this;
}
//The destructor
CSPlogical::~CSPlogical()
{
}
//Construct a 'logical' vector of length nLength
CSPlogical::CSPlogical(long lLength)
: TSPvector<long, S_MODE_LGL>( lLength)
{
}
CSPlogical::CSPlogical(int nLength)
: TSPvector<long, S_MODE_LGL>( (long) nLength)
{
}
CSPlogical::CSPlogical(long* plValues, long lLength)
: TSPvector<long, S_MODE_LGL>( lLength)
{
	SetAtDirect(plValues, 0L, lLength-1, FALSE);
}
CSPlogical::CSPlogical(long* plValues, int nLength)
: TSPvector<long, S_MODE_LGL>( (long) nLength)
{
	SetAtDirect(plValues, 0L, (long)(nLength-1), FALSE);
}
CSPlogical::CSPlogical(int* pnValues, long lLength)
: TSPvector<long, S_MODE_LGL>( lLength)
{
	SetAtDirect(pnValues, 0L, lLength-1, FALSE);
}
CSPlogical::CSPlogical(int* pnValues, int nLength)
: TSPvector<long, S_MODE_LGL>( (long) nLength)
{
	SetAtDirect(pnValues, 0L, (long)(nLength-1), FALSE);
}
//Direct access to elements of logical vector (ZERO-BASED INDEX). Use it carefully!
void CSPlogical::SetAtDirect(long lIndex, long lElement, BOOL bValidate)
{
	if(bValidate && (!IsValid()) || (lIndex >= GetLength(FALSE)))
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	//Warning: no ref-count check.
	LOGICAL_POINTER(GetPtr())[lIndex] =  lElement? 1L : 0L; 
}
//Direct access to elements of logical vector (ZERO-BASED INDEX). Use it carefully!
void CSPlogical::SetAtDirect(long* plValues, long lStartIndex, long lEndIndex, BOOL bValidate)
{
	if(bValidate  
	&& (!IsValid() || (lStartIndex > lEndIndex)
	    || (lStartIndex >= GetLength(FALSE)) || (lEndIndex >= GetLength(FALSE)))
	)
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	long j=0;

	if(plValues != NULL)
	{
		for(long n=lStartIndex; n<= lEndIndex; n++)
			LOGICAL_POINTER(GetPtr())[n] = plValues[j++]? 1L : 0L; //pValues[j] better be valid!
	}
}

//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
void CSPlogical::SetAtDirect(int* pnValues, long lStartIndex, long lEndIndex, BOOL bValidate)
{
	if(bValidate  
	&& (!IsValid() || (lStartIndex > lEndIndex)
	    || (lStartIndex >= GetLength(FALSE)) || (lEndIndex >= GetLength(FALSE)))
	)
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);  

	long j=0;

	if(pnValues != NULL)
	{
		for(long n=lStartIndex; n<= lEndIndex; n++)
			LOGICAL_POINTER(GetPtr())[n] = pnValues[j++]? 1L : 0L; //pValues[j] better be valid!
	}
}

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////

