/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

// SPolecli.cxx: implementation of the CSPoleclient class.
//
//////////////////////////////////////////////////////////////////////

#include <memory.h>
#include "spolecli.h"
#include "speval.h"
#include "spexcept.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//////////////////////// CSPoleclient ////////////////////////

void CSPoleclient::Init(void *pvDispatch, long id, const char *pszName, BOOL bValidate)
{
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);

#ifdef WIN32
	char szEval[_MAX_PATH];
#else
	char szEval[MAX_FILE_NAME_LEN];
#endif
	sprintf( szEval, "OLEClient( dispatch=%ld, gui.id=%ld, gui.name=\"%s\" )", (long)pvDispatch, id, pszName );
	s_object *ps_new_object = SPL_DirectParseEval( szEval );
	ReAttachAndAssign( ps_new_object );

//	long nSlotID = get_slot_offset(MAKE_CLASS("OLEClient"), "gui.id", S_evaluator);
//	if ( nSlotID < 0 )
//		SCONNECT_ThrowException("Class OLEClient is missing gui.id slot");
//	long nSlotName = get_slot_offset(MAKE_CLASS("OLEClient"), "gui.name", S_evaluator);
//	if ( nSlotName < 0 )
//		SCONNECT_ThrowException("Class OLEClient is missing gui.name slot");
//
//	s_object *ps_object = Clone();
//
//	s_object *ps_data = LIST_POINTER(ps_object)[0];
//	SET_LENGTH(ps_data,1);
//	INTEGER_POINTER(ps_data)[0]=(long)pvDispatch;
//
//	s_object *ps_IDslot = LIST_POINTER(ps_object)[nSlotID];
//	SET_LENGTH(ps_IDslot,1);
//	INTEGER_POINTER(ps_IDslot)[0]=id;
//	s_object *ps_NAMEslot = LIST_POINTER(ps_object)[nSlotName];
//	SET_LENGTH(ps_NAMEslot,1);
//	CHARACTER_POINTER(ps_NAMEslot)[0] = SPL_AllocateStringInFrame( ps_object, pszName );
//
//	ReAttachAndAssign( ps_object );
}

//Default constructor
CSPoleclient::CSPoleclient()
: CSPinteger()
{
	Attach( NEW(MAKE_CLASS("OLEClient")) );
}

CSPoleclient::CSPoleclient(void *pvDispatch, long id, const char *pszName)
: CSPinteger()
{
//	s_object *ps_object = NEW(MAKE_CLASS("OLEClient"));
//	Attach( ps_object );
	Init(pvDispatch, id, pszName, FALSE);
}

//Construct from a valid S-expression
CSPoleclient::CSPoleclient(const char* pszExpression)
: CSPinteger()
{
	Create(pszExpression);
}

//Copy constructor 
CSPoleclient::CSPoleclient(s_object* ps_object)
: CSPinteger()
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to corece object to class OLEClient"); 
}

//Copy constructor 
CSPoleclient::CSPoleclient(const CSPoleclient& sobject)
: CSPinteger()
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to corece object to class OLEClient"); 
}

//Assigment operator
CSPoleclient& CSPoleclient::operator = (s_object* ps_object)
{
	if(!CoerceAttach(ps_object))
		SCONNECT_ThrowException("Failed to corece object to class OLEClient"); 
	return *this;
}

//Assigment operator
CSPoleclient& CSPoleclient::operator = (const CSPoleclient& sobject)
{
	if(!CoerceAttach(sobject.GetPtr()))
		SCONNECT_ThrowException("Failed to corece object to class OLEClient"); 
	return *this;
}

//Create a persistent object when pszName != NULL
BOOL CSPoleclient::Create(
	const char* pszExpression, //==NULL, uses the default constructor, else use the expression to instantiate it.
	const char* pszName,       //object name
	long lDataBase )				//database
{
	BOOL bSuccess = TRUE;	
	try
	{
		bSuccess = CSPinteger::BaseCreate("OLEClient", pszExpression, pszName, lDataBase );
		if(bSuccess)
			Coerce();
	}
	catch(...)
	{
		bSuccess = FALSE;
	}

	return bSuccess;
}

//The destructor
CSPoleclient::~CSPoleclient()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid 'OLEClient' class
BOOL CSPoleclient::IsValid(void) const
{
	if(CSPobject::IsValid())
		return IS(GetPtr(), MAKE_CLASS("OLEClient"));
	return FALSE;
}

//Coerce to OLEClient class
BOOL CSPoleclient::Coerce(void)
{
	return CSPinteger::BaseCoerce("OLEClient");
}

//Coerce() coerces to "OLEClient" class and attach
BOOL CSPoleclient::CoerceAttach(s_object* ps_object)
{
	return CSPinteger::BaseCoerceAttach(ps_object, "OLEClient");
}

void CSPoleclient::Attach(s_object *ps_object, BOOL bTryToFreeOnDetach)
{
	CSPobject::Attach(AS(ps_object, MAKE_CLASS("OLEClient")), bTryToFreeOnDetach); 
}
