/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spolecli.h: interface for the CSPoleclient class.
*/

#ifndef __SCONNECT_SPOLECLI_H__INCLUDED__
#define __SCONNECT_SPOLECLI_H__INCLUDED__

#include "spint.h"

class SCONNECT_LIB_EXTERN CSPoleclient : public CSPinteger  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:

	//Default constructor
	CSPoleclient();

	CSPoleclient(void *pvDispatch, long id=0, const char *pszName=NULL);

	//Construct from a valid S-expression
	explicit CSPoleclient(const char* pszExpression);

	//Copy constructors 
	explicit CSPoleclient(s_object* ps_object);
	CSPoleclient(const CSPoleclient& sobject);

	void Init(void *pvDispatch, long id=0, const char *pszName=NULL, BOOL bValidate=TRUE);

	//Assignment operators
	CSPoleclient& operator = (s_object* ps_object);
	CSPoleclient& operator = (const CSPoleclient& sobject);

	//Create a persistent object when pszName != NULL
	virtual BOOL Create(
		const char* pszExpression=NULL, //==NULL, uses the default constructor, else use the expression to instantiate it.
		const char* pszName=NULL,  //object name
		long lDataBase=1 );        //database, only used if name given

	//The destructor
	virtual ~CSPoleclient();

	virtual void Attach(s_object *ps_object, BOOL bTryToFreeOnDetach=FALSE);

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:

  //Return TRUE if the object is a valid integer class
	virtual BOOL IsValid(void) const;

	//Coerce the data to integer class	
	virtual BOOL Coerce(void);

	//Coerce() coerces to integer class and attatch
	virtual BOOL CoerceAttach(s_object* ps_object);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:

	#include "spolecli_com.h"

};

#endif // __SCONNECT_SPOLECLI_H__INCLUDED__
