#!/bin/sh

echo $@ >> /tmp/ncpmount.log


set -- $(getopt "S:u:V:o:" "$@")
while [ $# -gt 0 ]
do
    case "$1" in
    (-S) SERVER=$2; shift
    ;;
    (-u) USER=$2; shift 
    ;;
    (-V) VOLUME=$2; shift 
    ;;
    (-o) OPTIONS=$2; shift 
    ;;
    (--) shift; break
    ;;
    (-*) echo "$0: error - unrecognized option $1" 1>&2; exit 1;;
    (*)  break;;
    esac
    shift
done
#

MNTPT=$1


# ensure correct permissions:
mkdir -p /var/home
chmod 755 /var/home
chown root.root /var/home


USERID=$(id -u $USER)
USERUPCASE="$(echo $USER|tr [:lower:] [:upper:] )"

echo "USER:$USER USERID:$USERID USERUPCASE:$USERUPCASE SERVER:$SERVER VOLUME:$VOLUME" >> /tmp/ncpmount.log

#sci:
if [ "$USERID" -ge 4000 -a "$USERID" -le 7999 ]; then
  echo "SCI mount" >> /tmp/ncpmount.log

  if [ "$SERVER" = "FSSCI" ]; then IPSERVER=fssci.sci.uni-klu.ac.at; fi
  if [ "$SERVER" = "FSEDU" ]; then IPSERVER=fsedu.sci.uni-klu.ac.at; fi
  if [ "$SERVER" = "FSSCI" -a "$VOLUME" = "HOME" ]; then SHARE=HomeSci/home/$USERUPCASE; fi
  if [ "$SERVER" = "FSSCI" -a "$VOLUME" = "INSTITUT" ]; then SHARE=INSTITUT/institut; fi
  if [ "$SERVER" = "FSEDU" -a "$VOLUME" = "PROJEKT" ]; then SHARE=PROJEKT; fi

  if mount | grep "/$IPSERVER/$SHARE" 2>&1 1>/dev/null ; then
    echo ""
    echo "already mounted" >> /tmp/ncpmount.log
  else
    echo exec mount -t cifs //$IPSERVER/$SHARE $MNTPT -o uid=$USERID,user=$USER,noserverino,noacl,nobrl >> /tmp/ncpmount.log
    exec mount -t cifs //$IPSERVER/$SHARE $MNTPT -o uid=$USERID,user=$USER,noserverino,noacl,nobrl >> /tmp/ncpmount.log 2>&1
  fi
# edu:
elif [ "$USERID" -ge 8000 -a "$USERID" -le 29999 ]; then
  echo "EDU mount" >> /tmp/ncpmount.log

  if [ "$SERVER" = "FSSCI" ]; then IPSERVER=fssci.sci.uni-klu.ac.at; fi
  if [ "$SERVER" = "FSEDU" ]; then IPSERVER=fsedu.sci.uni-klu.ac.at; fi
  if [ "$SERVER" = "FSEDU" -a "$VOLUME" = "HOME" ]; then SHARE=HomeEdu/home/$USERUPCASE; fi
  if [ "$SERVER" = "FSEDU" -a "$VOLUME" = "PROJEKT" ]; then SHARE=PROJEKT; fi

  if mount | grep "/$IPSERVER/$SHARE" 2>&1 1>/dev/null ; then
    echo ""
    echo "already mounted" >> /tmp/ncpmount.log
  else
    exec mount -t cifs //$IPSERVER/$SHARE $MNTPT -o uid=$USERID,user=$USER,noserverino,noacl,nobrl >> /tmp/ncpmount.log
  fi
else
  echo "USERID $USERID not in known ranges" >> /tmp/ncpmount.log
fi
