// Clears all radio buttons
function webdeveloper_clearRadioButtons()
{
    var clearedRadioButtons = 0;
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var inputElement        = null;
    var inputElementList    = null;
    var inputElementsLength = null;
    var pageDocument        = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        inputElementsLength = inputElementList.length;

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement = inputElementList[j];

            // If the element is a radio button
            if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "radio")
            {
                inputElement.checked = false;

                clearedRadioButtons++;
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_clearRadioButtons");

        // If one radio button was cleared
        if(clearedRadioButtons == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_clearRadioButtonsSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_clearRadioButtonsMultipleResult", [clearedRadioButtons]));
        }
    }
}

// Converts form methods
function webdeveloper_convertFormMethods(method)
{
    var convertedForms         = 0;
    var displayFormDetailsMenu = document.getElementById("webdeveloper-display-form-details-menu");
    var documentList           = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength         = documentList.length;
    var form                   = null;
    var formLength             = null;
    var formList               = null;
    var pageDocument           = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.forms;
        formLength   = formList.length;

        // Loop through all the forms
        for(var j = 0; j < formLength; j++)
        {
            form = formList[j];

            // If this form is not already the right method
            if((!form.hasAttribute("method") && method == "post") || (form.hasAttribute("method") && form.getAttribute("method").toLowerCase() != method))
            {
                form.setAttribute("method", method);
                convertedForms++;
            }
        }
    }

    // Reapply the display form details style sheet if it is currently on - fixes bug with form method not updating
    if(displayFormDetailsMenu.getAttribute("checked"))
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-form-details", false);
        webdeveloper_displayFormDetails(displayFormDetailsMenu, false);
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_convertFormMethods");

        // If one form was converted
        if(convertedForms == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_convertFormMethodsSingleResult", [method.toUpperCase()]));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_convertFormMethodsMultipleResult", [convertedForms, method.toUpperCase()]));
        }
    }
}

// Inserts simple clean "submit" button in all forms
function webdeveloper_insertCleanSubmit()
{
    var submitsInserted         = 0;
    var displayFormDetailsMenu = document.getElementById("webdeveloper-display-form-details-menu");
    var documentList           = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength         = documentList.length;
    var form                   = null;
    var formLength             = null;
    var formList               = null;
    var pageDocument           = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.getElementsByTagName("form");
        formLength   = formList.length;

        // Loop through all the forms
        for(var j = 0; j < formLength; j++)
        {
            form = formList[j];
            var sub = pageDocument.createElement("input");
            sub.setAttribute('type', 'submit');
            form.appendChild(sub);
	    submitsInserted++;
        }
    }
    // Reapply the display form details style sheet if it is currently on - fixes bug with form method not updating
    if(displayFormDetailsMenu.getAttribute("checked"))
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-form-details", false);
        webdeveloper_displayFormDetails(displayFormDetailsMenu, false);
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_insertCleanSubmit");

        // If one element was enabled
        if(submitsInserted == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_insertCleanSubmitSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_insertCleanSubmitMultipleResult", [submitsInserted]));
        }
    }
}

// Converts select elements to text inputs
function webdeveloper_convertSelectElementsToTextInputs()
{
    var convertedSelectElements = 0;
    var displayFormDetailsMenu  = document.getElementById("webdeveloper-display-form-details-menu");
    var documentList            = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength          = documentList.length;
    var inputElement            = null;
    var pageDocument            = null;
    var parentNode              = null;
    var selectElement           = null;
    var selectElements          = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument   = documentList[i];
        selectElements = pageDocument.getElementsByTagName("select");

        // While there are select elements
        while(selectElements.length > 0)
        {
            inputElement  = pageDocument.createElement("input");
            selectElement = selectElements[0];
            parentNode    = selectElement.parentNode;

            inputElement.value = selectElement.value;

            // If the select element has an id attribute
            if(selectElement.hasAttribute("id"))
            {
                inputElement.setAttribute("id", selectElement.getAttribute("id"));
            }

            // If the select element has a name attribute
            if(selectElement.hasAttribute("name"))
            {
                inputElement.setAttribute("name", selectElement.getAttribute("name"));
            }

            inputElement.setAttribute("type", "text");

            parentNode.insertBefore(inputElement, selectElement);
            webdeveloper_removeElement(selectElement);
            convertedSelectElements++;
        }
    }

    // Reapply the display form details style sheet if it is currently on - fixes bug with form method not updating
    if(displayFormDetailsMenu.getAttribute("checked"))
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-form-details", false);
        webdeveloper_displayFormDetails(displayFormDetailsMenu, false);
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_convertSelectElementsToTextInputs");

        // If one select element was converted
        if(convertedSelectElements == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_convertSelectElementsToTextInputsSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_convertSelectElementsToTextInputsMultipleResult", [convertedSelectElements]));
        }
    }
}

// Displays/hides the form details for the page
function webdeveloper_displayFormDetails(element)
{
    var buttonElement          = null;
    var buttonElementList      = null;
    var buttonElementsLength   = null;
    var display                = element.getAttribute("checked");
    var documentList           = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength         = documentList.length;
    var inputElement           = null;
    var inputElementList       = null;
    var inputElementsLength    = null;
    var pageDocument           = null;
    var selectElement          = null;
    var selectElementList      = null;
    var selectElementsLength   = null;
    var spanElement            = null;
    var text                   = null;
    var textAreaElement        = null;
    var textAreaElementList    = null;
    var textAreaElementsLength = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        inputElementsLength = inputElementList.length;

        // Need to do this to stop the feature running twice
        webdeveloper_removeAllElementsByXPath(pageDocument, "//span[@class='webdeveloper-display-form-details']");

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement = inputElementList[j];

            // If the input element is unhidden - need to do this to stop it running twice
            if(inputElement.className.indexOf("webdeveloper-unhidden") != -1)
            {
                inputElement.className = webdeveloper_removeSubstring(inputElement.className, "webdeveloper-unhidden");

                inputElement.setAttribute("type", "hidden");
            }

            // If displaying
            if(display)
            {
                spanElement = pageDocument.createElement("span");
                text        = "<input";

                // If the element is hidden
                if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "hidden")
                {
                    inputElement.className += " webdeveloper-unhidden";

                    inputElement.setAttribute("type", "text");
                }

                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));

                // If the element has an id attribute
                if(inputElement.hasAttribute("id"))
                {
                    text += ' id="' + inputElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(inputElement.hasAttribute("name"))
                {
                    text += ' name="' + inputElement.getAttribute("name") + '"';
                }

                // If the element is a checkbox or radio button
                if(inputElement.hasAttribute("type") && (inputElement.getAttribute("type").toLowerCase() == "checkbox" || inputElement.getAttribute("type").toLowerCase() == "radio"))
                {
                    text += ' value="' + inputElement.value + '"';
                }

                // If the element has a size attribute
                if(inputElement.hasAttribute("size"))
                {
                    text += ' size="' + inputElement.getAttribute("size") + '"';
                }

                // If the element has a maxlength attribute
                if(inputElement.hasAttribute("maxlength"))
                {
                    text += ' maxlength="' + inputElement.getAttribute("maxlength") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-display-form-details");
                spanElement.setAttribute("title", text);
                spanElement.appendChild(pageDocument.createTextNode(text));
                inputElement.parentNode.insertBefore(spanElement, inputElement);
            }
        }

        // If displaying
        if(display)
        {
            buttonElementList      = pageDocument.getElementsByTagName("button");
            buttonElementsLength   = buttonElementList.length;
            selectElementList      = pageDocument.getElementsByTagName("select");
            selectElementsLength   = selectElementList.length;
            textAreaElementList    = pageDocument.getElementsByTagName("textarea");
            textAreaElementsLength = textAreaElementList.length;

            // Loop through all the button tags
            for(j = 0; j < buttonElementsLength; j++)
            {
                buttonElement = buttonElementList[j];
                spanElement   = pageDocument.createElement("span");
                text          = "<button";

                // If the element has an id attribute
                if(buttonElement.hasAttribute("id"))
                {
                    text += ' id="' + buttonElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(buttonElement.hasAttribute("name"))
                {
                    text += ' name="' + buttonElement.getAttribute("name") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-display-form-details");
                spanElement.setAttribute("title", text);
                spanElement.appendChild(pageDocument.createTextNode(text));
                buttonElement.parentNode.insertBefore(spanElement, buttonElement);
            }

            // Loop through all the select tags
            for(j = 0; j < selectElementsLength; j++)
            {
                selectElement = selectElementList[j];
                spanElement   = pageDocument.createElement("span");
                text          = "<select";

                // If the element has an id attribute
                if(selectElement.hasAttribute("id"))
                {
                    text += ' id="' + selectElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(selectElement.hasAttribute("name"))
                {
                    text += ' name="' + selectElement.getAttribute("name") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-display-form-details");
                spanElement.setAttribute("title", text);
                spanElement.appendChild(pageDocument.createTextNode(text));
                selectElement.parentNode.insertBefore(spanElement, selectElement);
            }

            // Loop through all the textarea tags
            for(j = 0; j < textAreaElementsLength; j++)
            {
                textAreaElement = textAreaElementList[j];
                spanElement     = pageDocument.createElement("span");
                text            = "<textarea";

                // If the element has an id attribute
                if(textAreaElement.hasAttribute("id"))
                {
                    text += ' id="' + textAreaElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(textAreaElement.hasAttribute("name"))
                {
                    text += ' name="' + textAreaElement.getAttribute("name") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-display-form-details");
                spanElement.setAttribute("title", text);
                spanElement.appendChild(pageDocument.createTextNode(text));
                textAreaElement.parentNode.insertBefore(spanElement, textAreaElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_form_details.css", "webdeveloper-display-form-details");
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-form-details-tooltips", "*:before, span.webdeveloper-display-form-details");
}

// Enables form auto completion
function webdeveloper_enableFormAutoCompletion()
{
    var autoCompleteElements       = null;
    var autoCompleteElementsLength = null;
    var documentList               = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength             = documentList.length;
    var enabledElements            = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        autoCompleteElements       = webdeveloper_evaluateXPath(documentList[i], "//*[@autocomplete]");
        autoCompleteElementsLength = autoCompleteElements.length;

        // Loop through the auto complete elements
        for(var j = 0; j < autoCompleteElementsLength; j++)
        {
            autoCompleteElements[j].removeAttribute("autocomplete");
            enabledElements++;
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_enableAutoCompletion");

        // If one element was enabled
        if(enabledElements == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_enableAutoCompletionSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_enableAutoCompletionMultipleResult", [enabledElements]));
        }
    }
}

// Enables all the form fields
function webdeveloper_enableFormFields()
{
    var documentList             = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength           = documentList.length;
    var enabledFields            = 0;
    var form                     = null;
    var formElement              = null;
    var formElementList          = null;
    var formElements             = null;
    var formElementsLength       = null;
    var formLength               = null;
    var formList                 = null;
    var imageInputElement        = null;
    var imageInputElements       = null;
    var imageInputElementsLength = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        formList     = documentList[i].forms;
        formLength   = formList.length;

        // Loop through the forms
        for(var j = 0; j < formLength; j++)
        {
            form                     = formList[j];
            formElementList          = new Array();
            formElements             = form.elements;
            formElementsLength       = formElements.length;
            imageInputElements       = webdeveloper_evaluateXPath(form, "//input[@type='image']");
            imageInputElementsLength = imageInputElements.length;

            // Loop through the form elements
            for(var k = 0; k < formElementsLength; k++)
            {
                formElementList.push(formElements[k]);
            }

            // Loop through the image input elements
            for(k = 0; k < imageInputElementsLength; k++)
            {
                formElementList.push(imageInputElements[k]);
            }

            formElementsLength = formElementList.length;

            // Loop through the form elements
            for(k = 0; k < formElementsLength; k++)
            {
                formElement = formElementList[k];

                // If the form element is disabled
                if(formElement.disabled)
                {
                    formElement.disabled = false;
                    enabledFields++;
                }
            }
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_enableFormFields");

        // If one field was enabled
        if(enabledFields == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_enableFormFieldsSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_enableFormFieldsMultipleResult", [enabledFields]));
        }
    }
}

// Makes all the form fields writable
function webdeveloper_makeFormFieldsWritable()
{
    var documentList           = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength         = documentList.length;
    var readOnlyElements       = null;
    var readOnlyElementsLength = null;
    var writableFields         = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        readOnlyElements       = webdeveloper_evaluateXPath(documentList[i], "//*[@readonly]");
        readOnlyElementsLength = readOnlyElements.length;

        // Loop through all the input tags
        for(var j = 0; j < readOnlyElementsLength; j++)
        {
            readOnlyElements[j].removeAttribute("readonly");
            writableFields++;
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_makeFormFieldsWritable");

        // If one field was made writable
        if(writableFields == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_makeFormFieldsWritableSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_makeFormFieldsWritableMultipleResult", [writableFields]));
        }
    }
}

// Populates the form fields on the page
function webdeveloper_populateFormFields()
{
    var documentList           = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength         = documentList.length;
    var inputElement           = null;
    var inputElementList       = null;
    var inputElementName       = null;
    var inputElementsLength    = null;
    var inputElementType       = null;
    var option                 = null;
    var options                = null;
    var optionsLength          = null;
    var pageDocument           = null;
    var selectElement          = null;
    var selectElementList      = null;
    var selectElementsLength   = null;
    var textAreaElement        = null;
    var textAreaElementList    = null;
    var textAreaElementsLength = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument           = documentList[i];
        inputElementList       = pageDocument.getElementsByTagName("input");
        inputElementsLength    = inputElementList.length;
        selectElementList      = pageDocument.getElementsByTagName("select");
        selectElementsLength   = selectElementList.length;
        textAreaElementList    = pageDocument.getElementsByTagName("textarea");
        textAreaElementsLength = textAreaElementList.length;

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement      = inputElementList[j];
            inputElementType  = inputElement.getAttribute("type");

            // If the input element is not disabled
            if(!inputElement.disabled)
            {
                // If the input element value is not set and the type is not set or is password or text
                if(webdeveloper_trim(inputElement.value) == "" && (!inputElementType || inputElementType == "password" || inputElementType == "text"))
                {
                    inputElementName = inputElement.getAttribute("name");

                    // If the input element type is text, the name contains email and the populate form fields email preference is set
                    if(inputElementType == "text" && inputElementName.toLowerCase().indexOf("email") != -1 && webdeveloper_isPreferenceSet("webdeveloper.populate.form.fields.email"))
                    {
                        inputElement.value = webdeveloper_getStringPreference("webdeveloper.populate.form.fields.email", true);
                    }
                    else if(inputElementType == "password")
                    {
                        inputElement.value = "password";
                    }
                    else
                    {
                        inputElement.value = inputElementName;
                    }
                }
                else if(inputElementType == "checkbox" || inputElementType == "radio")
                {
                    inputElement.checked = true;
                }
            }
        }

        // Loop through all the select tags
        for(j = 0; j < selectElementsLength; j++)
        {
            selectElement = selectElementList[j];

            // If the select element is not disabled and the value is not set
            if(!selectElement.disabled && webdeveloper_trim(selectElement.value) == "")
            {
                options       = selectElement.options;
                optionsLength = options.length;

                // Loop through the options
                for(var k = 0; k < optionsLength; k++)
                {
                    option = options.item(k);

                    // If the optionis set and the option text and option value are not empty
                    if(option && webdeveloper_trim(option.text) != "" && webdeveloper_trim(option.value) != "")
                    {
                        selectElement.selectedIndex = k;

                        break;
                    }
                }
            }
        }

        // Loop through all the text area tags
        for(j = 0; j < textAreaElementsLength; j++)
        {
            textAreaElement = textAreaElementList[j];

            // If the text area element is not disabled and the value is not set
            if(!textAreaElement.disabled && webdeveloper_trim(textAreaElement.value) == "")
            {
                textAreaElement.value = textAreaElement.getAttribute("name");
            }
        }
    }
}

// Removes all maximum lengths on form elements
function webdeveloper_removeMaximumLengths()
{
    var documentList                = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength              = documentList.length;
    var maximumLengthElements       = null;
    var maximumLengthElementsLength = null;
    var removed                     = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        maximumLengthElements       = webdeveloper_evaluateXPath(documentList[i], "//input[@maxlength]");
        maximumLengthElementsLength = maximumLengthElements.length;

        // Loop through all the input tags
        for(var j = 0; j < maximumLengthElementsLength; j++)
        {
            maximumLengthElements[j].removeAttribute("maxlength");
            removed++;
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_removeMaximumLengths");

        // If one maxlength was removed
        if(removed == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_removeMaximumLengthsSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_removeMaximumLengthsMultipleResult", [removed]));
        }
    }
}

// Shows all passwords on a form
function webdeveloper_showPasswords()
{
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var inputElement        = null;
    var inputElementList    = null;
    var inputElementsLength = null;
    var pageDocument        = null;
    var shownPasswords      = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        inputElementsLength = inputElementList.length;

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElement = inputElementList[j];

            // If the element is password
            if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "password")
            {
                inputElement.setAttribute("type", "text");
                shownPasswords++;
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_showPasswords");

        // If one password was shown
        if(shownPasswords == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_showPasswordsSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_showPasswordsMultipleResult", [shownPasswords]));
        }
    }
}

// Updates the forms menu
function webdeveloper_updateFormsMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-form-details-" + suffix), "checked", "webdeveloper-display-form-details");
}

// Displays all the forms for the page
function webdeveloper_viewFormInformation()
{
    var cellDataElement          = null;
    var cellHeaderElement        = null;
    var divElement               = null;
    var documentList             = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength           = documentList.length;
    var documentURL              = null;
    var elementStates            = null;
    var elementStatesLength      = null;
    var elementType              = null;
    var elementValue             = null;
    var form                     = null;
    var formElement              = null;
    var formElementId            = null;
    var formElementList          = null;
    var formElements             = null;
    var formElementsLength       = null;
    var formLength               = null;
    var formList                 = null;
    var imageInputElements       = null;
    var imageInputElementsLength = null;
    var labelElement             = null;
    var labelLength              = null;
    var labelList                = null;
    var labelValue               = null;
    var linkElement              = null;
    var oldTab                   = getBrowser().selectedTab;
    var oldURL                   = getBrowser().currentURI.spec;
    var generatedDocument        = webdeveloper_generateDocument("");
    var bodyElement              = webdeveloper_getDocumentBodyElement(generatedDocument);
    var headElement              = webdeveloper_getDocumentHeadElement(generatedDocument);
    var headerElement            = generatedDocument.createElement("h1");
    var pageDocument             = null;
    var pElement                 = null;
    var preElement               = null;
    var scriptElement            = generatedDocument.createElement("script");
    var spanElement              = null;
    var stringBundle             = document.getElementById("webdeveloper-string-bundle");
    var tableElement             = null;
    var tableRowElement          = null;
    var title                    = stringBundle.getFormattedString("webdeveloper_viewFormInformationTitle", [oldURL]);

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    bodyElement.appendChild(headerElement);

    webdeveloper_addGeneratedTools(generatedDocument);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        divElement    = generatedDocument.createElement("div");
        headerElement = generatedDocument.createElement("h2");
        linkElement   = generatedDocument.createElement("a");
        pageDocument  = documentList[i];
        documentURL   = pageDocument.documentURI;
        formList      = pageDocument.forms;
        formLength    = formList.length;
        labelList     = pageDocument.getElementsByTagName("label");
        labelLength   = labelList.length;
        spanElement   = generatedDocument.createElement("span");

        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedDocument.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        bodyElement.appendChild(headerElement);

        headerElement = generatedDocument.createElement("h3");

        spanElement.setAttribute("class", "expanded pivot");
        headerElement.appendChild(spanElement);

        // If there is one form
        if(formLength == 1)
        {
            headerElement.appendChild(generatedDocument.createTextNode(formLength + " " + stringBundle.getString("webdeveloper_form").toLowerCase()));
        }
        else
        {
            headerElement.appendChild(generatedDocument.createTextNode(formLength + " " + stringBundle.getString("webdeveloper_forms").toLowerCase()));
        }

        bodyElement.appendChild(headerElement);

        // Loop through the forms
        for(var j = 0; j < formLength; j++)
        {
            form                     = formList[j];
            formElementList          = new Array();
            formElements             = form.elements;
            formElementsLength       = formElements.length;
            headerElement            = generatedDocument.createElement("h3");
            imageInputElements       = webdeveloper_evaluateXPath(form, "//input[@type='image']");
            imageInputElementsLength = imageInputElements.length;
            tableElement             = generatedDocument.createElement("table");
            tableRowElement          = generatedDocument.createElement("tr");

            // Loop through the form elements
            for(var k = 0; k < formElementsLength; k++)
            {
                formElementList.push(formElements[k]);
            }

            // Loop through the image input elements
            for(k = 0; k < imageInputElementsLength; k++)
            {
                formElementList.push(imageInputElements[k]);
            }

            formElementsLength = formElementList.length;

            headerElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_form")));
            divElement.appendChild(headerElement);

            //  Form id heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_id")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Form name heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_name")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Form method heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_method")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Form action heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_action")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            tableRowElement = generatedDocument.createElement("tr");

            //  Form id
            cellDataElement = generatedDocument.createElement("td");

            cellDataElement.appendChild(generatedDocument.createTextNode(form.getAttribute("id")));
            tableRowElement.appendChild(cellDataElement);

            //  Form name
            cellDataElement = generatedDocument.createElement("td");

            cellDataElement.appendChild(generatedDocument.createTextNode(form.getAttribute("name")));
            tableRowElement.appendChild(cellDataElement);

            //  Form method
            cellDataElement = generatedDocument.createElement("td");

            cellDataElement.appendChild(generatedDocument.createTextNode(form.getAttribute("method")));
            tableRowElement.appendChild(cellDataElement);

            //  Form action
            cellDataElement = generatedDocument.createElement("td");

            cellDataElement.appendChild(generatedDocument.createTextNode(form.getAttribute("action")));
            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);
            divElement.appendChild(tableElement);

            pElement = generatedDocument.createElement("p");

            divElement.appendChild(pElement);

            headerElement   = generatedDocument.createElement("h3");
            tableElement    = generatedDocument.createElement("table");
            tableRowElement = generatedDocument.createElement("tr");

            headerElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_elements")));
            divElement.appendChild(headerElement);

            //  Element index heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_index")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Element id heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_id")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Element name heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_name")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            //  Element type heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_type")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            //  Element value heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_value")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            //  Element label heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_label")));
            tableRowElement.appendChild(cellHeaderElement);

            //  Element size heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_size")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            //  Element maximum length heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_maximumLength")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            //  Element state heading
            cellHeaderElement = generatedDocument.createElement("th");

            cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_state")));
            tableRowElement.appendChild(cellHeaderElement);
            tableElement.appendChild(tableRowElement);

            // Loop through the form elements
            for(k = 0; k < formElementsLength; k++)
            {
                elementStates   = new Array();
                elementValue    = "";
                formElement     = formElementList[k];
                formElementId   = formElement.getAttribute("id");
                elementType     = formElement.tagName.toLowerCase();
                labelElement    = "";
                labelValue      = "";
                tableRowElement = generatedDocument.createElement("tr");

                // If this is an even row
                if(k % 2 != 0)
                {
                    tableRowElement.setAttribute("class", "shaded");
                }

                // If the element has an id
                if(formElementId)
                {
                    // Loop through the labels
                    for(var l = 0; l < labelLength; l++)
                    {
                        labelElement = labelList[l];

                        // If this is the label for the element
                        if(labelElement.hasAttribute("for") && labelElement.getAttribute("for") == formElementId)
                        {
                            labelValue = labelElement.innerHTML;
                        }
                    }
                }

                // If this is an input element
                if(elementType == "input")
                {
                    elementType  = formElement.getAttribute("type");
                    elementValue = formElement.value;
                }
                else if(elementType == "textarea")
                {
                    elementValue = formElement.value;
                }

                // If the element is checked
                if(formElement.checked)
                {
                    elementStates.push("Checked");
                }

                // If the element is disabled
                if(formElement.disabled)
                {
                    elementStates.push("Disabled");
                }

                // If the element is read only
                if(formElement.readOnly)
                {
                    elementStates.push("Readonly");
                }

                elementStatesLength = elementStates.length;

                //  Element index
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(k));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element id
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(formElementId));
                tableRowElement.appendChild(cellDataElement);

                //  Element name
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(formElement.getAttribute("name")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element type
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(elementType));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element value
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(elementValue));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element label
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(labelValue));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element size
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(formElement.getAttribute("size")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element maximum length
                cellDataElement = generatedDocument.createElement("td");

                cellDataElement.appendChild(generatedDocument.createTextNode(formElement.getAttribute("maxlength")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Element state
                cellDataElement = generatedDocument.createElement("td");

                // Loop through the element states
                for(l = 0; l < elementStatesLength; l++)
                {
                    pElement = generatedDocument.createElement("p");

                    pElement.appendChild(generatedDocument.createTextNode(elementStates[l]));
                    cellDataElement.appendChild(pElement);
                }

                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            tableElement.setAttribute("class", "sortable");
            divElement.setAttribute("class", "output");
            divElement.appendChild(tableElement);
            divElement.appendChild(generatedDocument.createElement("hr"));
            bodyElement.appendChild(divElement);
        }
    }

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/dom.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/xpath.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/output_pivot.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/table_sort.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
