var webdeveloper_appliedStyles          = new Array();
var webdeveloper_javaScriptCurrentTime  = null;
var webdeveloper_javaScriptPreviousTime = null;
var webdeveloper_outlineElement         = null;
var webdeveloper_outlinedElements       = new Array();
var webdeveloper_selectedTab            = -1;

window.addEventListener("load", webdeveloper_initialize, false);
window.addEventListener("unload", webdeveloper_uninitialize, false);

// Displays the about dialog
function webdeveloper_about()
{
    window.openDialog("chrome://webdeveloper/content/about/about.xul", "webdeveloper-about-dialog", "centerscreen,chrome,modal");
}

// Add applied style
function webdeveloper_addAppliedStyle(id)
{
    // If the id is not in the applied styles
    if(!webdeveloper_contains(webdeveloper_appliedStyles, id))
    {
        webdeveloper_appliedStyles.push(id);
        webdeveloper_configureElement(document.getElementById("webdeveloper-statusbar-panel"), "hidden", false);
    }
}

// Add applied style if the element exists
function webdeveloper_addAppliedStyleByElement(id)
{
    var currentDocument = webdeveloper_getContentDocument();

    // If the element exists
    if(currentDocument.getElementById(id))
    {
        webdeveloper_addAppliedStyle(id);
    }
}

// Outlines the element in the event
function webdeveloper_addElementOutline(event, currentElement)
{
    var element = event.target;

    // If the element is set, is not the same as the current outline element and has a style property
    if(element && element != currentElement && element.style)
    {
        webdeveloper_removeElementOutline(currentElement);

        element.style.MozOutline = "1px solid #ff0000";

        return element;
    }

    return null;
}

// Adds the generated styles to a page
function webdeveloper_addGeneratedStyles(generatedDocument)
{
    var headElement  = webdeveloper_getDocumentHeadElement(generatedDocument);
    var linkElement  = generatedDocument.createElement("link");
    var styleElement = generatedDocument.createElement("style");

    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated/generated_content.css");
    linkElement.setAttribute("id", "webdeveloper-generated-content-stylesheet");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    headElement.appendChild(linkElement);

    styleElement.setAttribute("type", "text/css");
    styleElement.appendChild(generatedDocument.createTextNode("body, td, th { font-size: " + webdeveloper_getIntegerPreference("webdeveloper.generated.content.font.size", true) + "px !important; }"));
    headElement.appendChild(styleElement);
    
    generatedDocument.documentElement.setAttribute("id", "webdeveloper-generated-content");
}

// Adds the generated tools to a page
function webdeveloper_addGeneratedTools(generatedDocument)
{
    var linkElement     = generatedDocument.createElement("a");
    var listElement     = generatedDocument.createElement("ul");
    var listItemElement = generatedDocument.createElement("li");
    var stringBundle    = document.getElementById("webdeveloper-string-bundle");

    linkElement.setAttribute("href", "#");
    linkElement.setAttribute("id", "webdeveloper-generated-tool-collapse-all");
    linkElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_collapseAll")));
    listItemElement.appendChild(linkElement);
    listElement.appendChild(listItemElement);

    linkElement     = generatedDocument.createElement("a");
    listItemElement = generatedDocument.createElement("li");

    linkElement.setAttribute("href", "#");
    linkElement.setAttribute("id", "webdeveloper-generated-tool-expand-all");
    linkElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_expandAll")));
    listItemElement.appendChild(linkElement);
    listElement.appendChild(listItemElement);

    listElement.setAttribute("id", "tools");
    webdeveloper_getDocumentBodyElement(generatedDocument).appendChild(listElement);
}

// Adds a status menu item
function webdeveloper_addStatusMenuItem(statusMenu, menuId)
{
    var originalMenuItem = document.getElementById(menuId + "-menu");
    var statusMenuItem   = document.createElement("menuitem");

    statusMenuItem.setAttribute("checked", true);
    statusMenuItem.setAttribute("class", "webdeveloper-generated-menu");
    statusMenuItem.setAttribute("label", originalMenuItem.getAttribute("label"));
    statusMenuItem.setAttribute("oncommand", originalMenuItem.getAttribute("oncommand"));
    statusMenuItem.setAttribute("type", "checkbox");

    statusMenu.insertBefore(statusMenuItem, document.getElementById("webdeveloper-separator-statusbar"));
}

// Adds the style sheet at the given location with the given id
function webdeveloper_addStyleSheet(location, id)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var linkElement    = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        linkElement  = pageDocument.createElement("link");

        linkElement.setAttribute("href", location);
        linkElement.setAttribute("id", id);
        linkElement.setAttribute("rel", "stylesheet");
        linkElement.setAttribute("type", "text/css");

        webdeveloper_getDocumentHeadElement(pageDocument).appendChild(linkElement);
    }

    webdeveloper_addAppliedStyle(id);
}

// Adjusts the position of the given element
function webdeveloper_adjustElementPosition(element, xPosition, yPosition, offset)
{
    // If the element is set
    if(element)
    {
        var clientHeight  = element.clientHeight;
        var clientWidth   = element.clientWidth;
        var contentWindow = webdeveloper_getContentWindow();
        var innerHeight   = contentWindow.innerHeight;
        var innerWidth    = contentWindow.innerWidth;
        var offsetX       = contentWindow.pageXOffset;
        var offsetY       = contentWindow.pageYOffset;

        // If the x position is less than 0
        if(xPosition < 0)
        {
            xPosition = 0;
        }

        // If the y position is less than 0
        if(yPosition < 0)
        {
            yPosition = 0;
        }

        // If the element will fit at the x position
        if((xPosition + clientWidth + offset + 5) < (innerWidth + offsetX))
        {
            element.style.left = xPosition + offset + "px";
        }
        else
        {
            element.style.left = (innerWidth + offsetX - clientWidth - offset) + "px";
        }

        // If the element will fit at the y position
        if((yPosition + clientHeight + offset + 5) < (innerHeight + offsetY))
        {
            element.style.top = yPosition + offset + "px";
        }
        else
        {
            element.style.top = (innerHeight + offsetY - clientHeight - offset) + "px";
        }
    }
}

// Applies all selected style sheets
function webdeveloper_applyStyleSheets(reset)
{
    var appliedStyle        = null;
    var appliedStyles       = webdeveloper_appliedStyles.slice(0);
    var appliedStylesLength = appliedStyles.length;
    var element             = null;

    // Loop through the duplicated applied styles
    for(var i = 0; i < appliedStylesLength; i++)
    {
        appliedStyle = appliedStyles[i];

        // Switch on the style
        switch(appliedStyle)
        {
            case "webdeveloper-add-user-style-sheet":
                element = document.getElementById("webdeveloper-add-user-style-sheet-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_addUserStyleSheet(element);
                break;
            case "webdeveloper-disable-all-styles":
                element = document.getElementById("webdeveloper-disable-all-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleStyles(element);
                break;
            case "webdeveloper-disable-browser-default-styles":
                element = document.getElementById("webdeveloper-disable-browser-default-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleBrowserDefaultStyles(element);
                break;
            case "webdeveloper-disable-embedded-styles":
                element = document.getElementById("webdeveloper-disable-embedded-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleEmbeddedStyles(element);
                break;
            case "webdeveloper-disable-inline-styles":
                element = document.getElementById("webdeveloper-disable-inline-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleInlineStyles(element);
                break;
            case "webdeveloper-disable-linked-styles":
                element = document.getElementById("webdeveloper-disable-linked-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleLinkedStyles(element);
                break;
            case "webdeveloper-disable-print-styles":
                element = document.getElementById("webdeveloper-disable-print-styles-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_togglePrintStyles(element);
                break;
            case "webdeveloper-display-abbreviations":
                element = document.getElementById("webdeveloper-display-abbreviations-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAbbreviations(element);
                break;
            case "webdeveloper-display-access-keys":
                element = document.getElementById("webdeveloper-display-access-keys-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAccessKeys(element);
                break;
            case "webdeveloper-display-alt-attributes":
                element = document.getElementById("webdeveloper-display-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAltAttributes(element);
                break;
            case "webdeveloper-display-anchors":
                element = document.getElementById("webdeveloper-display-anchors-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayAnchors(element);
                break;
            case "webdeveloper-display-block-size":
                element = document.getElementById("webdeveloper-display-block-size-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayBlockSize(element);
                break;
            case "webdeveloper-display-div-order":
                element = document.getElementById("webdeveloper-display-div-order-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayDivOrder(element);
                break;
            case "webdeveloper-display-element-information":
                element = document.getElementById("webdeveloper-display-element-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayElementInformation(element);
                break;
            case "webdeveloper-display-current-size-title":
                element = document.getElementById("webdeveloper-display-current-size-title-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayWindowSizeInTitle(element);
                break;
            case "webdeveloper-display-form-details":
                element = document.getElementById("webdeveloper-display-form-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayFormDetails(element);
                break;
            case "webdeveloper-display-handheld-css":
                element = document.getElementById("webdeveloper-display-handheld-css-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayHandheldCSS(element);
                break;
            case "webdeveloper-display-id-class-details":
                element = document.getElementById("webdeveloper-display-id-class-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayIdClassDetails(element);
                break;
            case "webdeveloper-display-image-dimensions":
                element = document.getElementById("webdeveloper-display-image-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImageDimensions(element);
                break;
            case "webdeveloper-display-image-file-sizes":
                element = document.getElementById("webdeveloper-display-image-file-sizes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImageFileSizes(element);
                break;
            case "webdeveloper-display-image-paths":
                element = document.getElementById("webdeveloper-display-image-paths-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayImagePaths(element);
                break;
            case "webdeveloper-display-line-guides":
                element = document.getElementById("webdeveloper-display-line-guides-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayLineGuides(element);
                break;
            case "webdeveloper-display-link-details":
                element = document.getElementById("webdeveloper-display-link-details-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayLinkDetails(element);
                break;
            case "webdeveloper-display-object-information":
                element = document.getElementById("webdeveloper-display-object-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayObjectInformation(element);
                break;
            case "webdeveloper-display-print-css":
                element = document.getElementById("webdeveloper-display-print-css-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayPrintCSS(element);
                break;
            case "webdeveloper-display-ruler":
                element = document.getElementById("webdeveloper-display-ruler-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayRuler(element);
                break;
            case "webdeveloper-display-stack-levels":
                element = document.getElementById("webdeveloper-display-stack-levels-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayStackLevels(element);
                break;
            case "webdeveloper-display-tab-index":
                element = document.getElementById("webdeveloper-display-tab-index-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTabIndex(element);
                break;
            case "webdeveloper-display-table-depth":
                element = document.getElementById("webdeveloper-display-table-depth-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTableDepth(element);
                break;
            case "webdeveloper-display-table-information":
                element = document.getElementById("webdeveloper-display-table-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTableInformation(element);
                break;
            case "webdeveloper-display-title-attributes":
                element = document.getElementById("webdeveloper-display-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTitleAttributes(element);
                break;
            case "webdeveloper-display-topographic-information":
                element = document.getElementById("webdeveloper-display-topographic-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayTopographicInformation(element);
                break;
            case "webdeveloper-display-window-size-title":
                element = document.getElementById("webdeveloper-display-window-size-title-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_displayWindowSizeInTitle(element);
                break;
            case "webdeveloper-hide-background-images":
                element = document.getElementById("webdeveloper-hide-background-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_hideBackgroundImages(element);
                break;
            case "webdeveloper-hide-images":
                element = document.getElementById("webdeveloper-hide-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_hideImages(element, "webdeveloper-hide-images");
                break;
            case "webdeveloper-linearize-page":
                element = document.getElementById("webdeveloper-linearize-page-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_linearizePage(element);
                break;
            case "webdeveloper-make-images-invisible":
                element = document.getElementById("webdeveloper-make-images-invisible-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_makeImagesInvisible(element, "webdeveloper-make-images-invisible");
                break;
            case "webdeveloper-outline-absolute-positioned-elements":
                element = document.getElementById("webdeveloper-outline-absolute-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("absolute", element);
                break;
            case "webdeveloper-outline-all-images":
                element = document.getElementById("webdeveloper-outline-all-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineAllImages(element);
                break;
            case "webdeveloper-outline-all-tables":
                element = document.getElementById("webdeveloper-outline-all-tables-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineTables(element);
                break;
            case "webdeveloper-outline-background-images":
                element = document.getElementById("webdeveloper-outline-background-images-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineBackgroundImages(element, true);
                break;
            case "webdeveloper-outline-block-level-elements":
                element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineBlockLevelElements(element);
                break;
            case "webdeveloper-outline-current-element":
                element = document.getElementById("webdeveloper-outline-current-element-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineCurrentElement(element);
                break;
            case "webdeveloper-outline-custom-elements":
                element = document.getElementById("webdeveloper-outline-custom-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineElements(element);
                break;
            case "webdeveloper-outline-deprecated-elements":
                element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineDeprecatedElements(element);
                break;
            case "webdeveloper-outline-external-links":
                element = document.getElementById("webdeveloper-outline-external-links-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineExternalLinks(element);
                break;
            case "webdeveloper-outline-fixed-positioned-elements":
                element = document.getElementById("webdeveloper-outline-fixed-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("fixed", element);
                break;
            case "webdeveloper-outline-floated-elements":
                element = document.getElementById("webdeveloper-outline-floated-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineFloatedElements(element);
                break;
            case "webdeveloper-outline-frames":
                element = document.getElementById("webdeveloper-outline-frames-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineFrames(element);
                break;
            case "webdeveloper-outline-headings":
                element = document.getElementById("webdeveloper-outline-headings-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineHeadings(element);
                break;
            case "webdeveloper-outline-images-with-adjusted-dimensions":
                element = document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithAdjustedDimensions(element);
                break;
            case "webdeveloper-outline-images-with-empty-alt-attributes":
                element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithEmptyAltAttributes(element);
                break;
            case "webdeveloper-outline-images-with-oversized-dimensions":
                element = document.getElementById("webdeveloper-outline-images-with-oversized-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithOversizedDimensions(element);
                break;
            case "webdeveloper-outline-images-without-alt-attributes":
                element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutAltAttributes(element);
                break;
            case "webdeveloper-outline-images-without-dimensions":
                element = document.getElementById("webdeveloper-outline-images-without-dimensions-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutDimensions(element);
                break;
            case "webdeveloper-outline-images-without-title-attributes":
                element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineImagesWithoutTitleAttributes(element);
                break;
            case "webdeveloper-outline-links-with-ping-attributes":
                element = document.getElementById("webdeveloper-outline-links-with-ping-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineLinksWithPingAttributes(element);
                break;
            case "webdeveloper-outline-links-without-title-attributes":
                element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineLinksWithoutTitleAttributes(element);
                break;
            case "webdeveloper-outline-relative-positioned-elements":
                element = document.getElementById("webdeveloper-outline-relative-positioned-elements-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlinePositionedElements("relative", element);
                break;
            case "webdeveloper-outline-table-cells":
                element = document.getElementById("webdeveloper-outline-table-cells-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_outlineTableCells(element);
                break;
            case "webdeveloper-replace-images-with-alt-attributes":
                element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_replaceImagesWithAltAttributes(element);
                break;
            case "webdeveloper-show-comments":
                element = document.getElementById("webdeveloper-show-comments-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleComments(element);
                break;
            case "webdeveloper-small-screen-rendering":
                element = document.getElementById("webdeveloper-small-screen-rendering-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_smallScreenRendering(element);
                break;
            case "webdeveloper-use-border-box-model":
                element = document.getElementById("webdeveloper-use-border-box-model-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_toggleBorderBoxModel(element);
                break;
            case "webdeveloper-view-style-information":
                element = document.getElementById("webdeveloper-view-style-information-menu");
                webdeveloper_configureElement(element, "checked", !reset);
                webdeveloper_viewStyleInformation(element);
                break;
        }
    }
}

// Changes the options
function webdeveloper_changeOptions()
{
    var element                   = null;
    var hideContextMenuPreference = webdeveloper_getBooleanPreference("webdeveloper.context.hide", true);
    var hideMenuPreference        = webdeveloper_getBooleanPreference("webdeveloper.menu.hide", true);
    var toolbar                   = document.getElementById("webdeveloper-toolbar");

    // If the toolbar exists
    if(toolbar)
    {
        var toolbarVisible = window.toolbar.visible;

        // If the toolbar is visible
        if(toolbarVisible)
        {
            var toolbarButtons       = toolbar.getElementsByTagName("toolbarbutton");
            var toolbarButtonsLength = toolbarButtons.length;
            var toolbarPreference    = webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true);

            toolbar.setAttribute("mode", toolbarPreference);

            // If the toolbar preference is set to icons
            if(toolbarPreference == "icons")
            {
                toolbarPreference = "pictures";
            }

            toolbar.setAttribute("buttonstyle", toolbarPreference);

            // Loop through the toolbar buttons
            for(var i = 0; i < toolbarButtonsLength; i++)
            {
                toolbarButtons[i].setAttribute("buttonstyle", toolbarPreference);
            }

            // If the toolbar preference is not set to text
            if(toolbarPreference != "text")
            {
                element = document.getElementById("webdeveloper-javascript-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-render-mode-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }
            }
        }
    }

    element = document.getElementById("webdeveloper-menu");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideMenuPreference);
    }

    element = document.getElementById("webdeveloper-context");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }

    element = document.getElementById("webdeveloper-context-separator1");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }
}

// Clears the applied styles
function webdeveloper_clearAppliedStyles()
{
    webdeveloper_appliedStyles = new Array();

    webdeveloper_configureElement(document.getElementById("webdeveloper-statusbar-panel"), "hidden", true);
}

// Configures the element with the given attribute and value
function webdeveloper_configureElement(element, attribute, value)
{
    // If the element exists
    if(element)
    {
        // If the value is set
        if(value)
        {
            element.setAttribute(attribute, value);
        }
        else
        {
            element.removeAttribute(attribute);
        }
    }
}

// Configures the element based on whether the applied style exists
function webdeveloper_configureElementByAppliedStyle(element, attribute, id)
{
    webdeveloper_configureElement(element, attribute, webdeveloper_contains(webdeveloper_appliedStyles, id));
}

// Configure the keyboard shortcuts
function webdeveloper_configureKeyboardShortcuts(reset)
{
    var bookmarklet         = null;
    var id                  = null;
    var key                 = null;
    var keyElement          = null;
    var keyPreference       = null;
    var keyPreferenceValue  = null;
    var keys                = null;
    var keySet              = null;
    var keysLength          = null;
    var mainDocument        = null;
    var path                = null;
    var success             = false;
    var toolCount           = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
    var url                 = null;
    var viewSourceWithCount = webdeveloper_getIntegerPreference("webdeveloper.view.source.with.count", true);
    var windowEnumeration   = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

    // Loop through the open windows
    while(windowEnumeration.hasMoreElements())
    {
        mainDocument = windowEnumeration.getNext().document;

        // If a main document was found
        if(mainDocument)
        {
            keySet = mainDocument.getElementById("mainKeyset");

            // If the key set was not found
            if(!keySet)
            {
                keySet = mainDocument.getElementById("navKeys");
            }

            // If the key set was found
            if(keySet)
            {
                keys       = keySet.childNodes;
                keysLength = keys.length;

                // Loop through the keys
                for(var i = 0; i < keysLength; i++)
                {
                    key = keys.item(i);

                    // If the key has an id starting with webdeveloper
                    if(key.hasAttribute("id") && key.getAttribute("id").indexOf("webdeveloper-") == 0)
                    {
                        id = key.getAttribute("id").split("-").join(".");

                        // If the key preference is set
                        if(webdeveloper_isPreferenceSet(id))
                        {
                            keyPreferenceValue = webdeveloper_getStringPreference(id, true);

                            key.setAttribute("key", keyPreferenceValue);

                            // If the key preference value is set
                            if(keyPreferenceValue)
                            {
                                key.setAttribute("disabled", false);
                            }
                            else
                            {
                                key.setAttribute("disabled", true);
                            }
                        }
                        else if(!reset)
                        {
                            webdeveloper_setStringPreference(id, key.getAttribute("key"));
                        }

                        success = true;
                    }
                }

                // Loop through the possible tools
                for(i = 1; i <= toolCount; i++)
                {
                    bookmarklet   = "webdeveloper.tool." + i + ".bookmarklet";
                    keyPreference = "webdeveloper.tool." + i + ".key";
                    keyElement    = mainDocument.getElementById(keyPreference);
                    path          = "webdeveloper.tool." + i + ".path";
                    url           = "webdeveloper.tool." + i + ".url";

                    // If the bookmarklet, path or URL preference and key preference is set
                    if((webdeveloper_isPreferenceSet(bookmarklet) || webdeveloper_isPreferenceSet(path) || webdeveloper_isPreferenceSet(url)) && webdeveloper_isPreferenceSet(keyPreference))
                    {
                        keyPreferenceValue = webdeveloper_getStringPreference(keyPreference, true);

                        // If the key preference value is set
                        if(keyPreferenceValue)
                        {
                            key = mainDocument.createElement("key");

                            key.setAttribute("id", keyPreference);
                            key.setAttribute("key", keyPreferenceValue);
                            key.setAttribute("modifiers", "accel,shift");

                            // If the bookmarklet preference is set
                            if(webdeveloper_getStringPreference(bookmarklet, true))
                            {
                                key.setAttribute("oncommand", "webdeveloper_runBookmarklet('" + encodeURIComponent(webdeveloper_getStringPreference(bookmarklet, true)).replace(new RegExp("'", "gi"), "\\'") + "')");
                            }
                            else if(webdeveloper_getStringPreference(path, true))
                            {
                                key.setAttribute("oncommand", "webdeveloper_loadApplicationWithURL('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "', getBrowser().currentURI.spec)");
                            }
                            else
                            {
                                key.setAttribute("oncommand", "webdeveloper_loadURL('" + webdeveloper_getStringPreference(url, true) + "' + encodeURIComponent(getBrowser().currentURI.spec))");
                            }

                            keySet.appendChild(key);
                        }
                    }
                    else
                    {
                        webdeveloper_removeElement(keyElement);
                    }
                }

                // Loop through the possible view source with options
                for(i = 1; i <= viewSourceWithCount; i++)
                {
                    keyPreference = "webdeveloper.view.source.with." + i + ".key";
                    keyElement    = mainDocument.getElementById(keyPreference);
                    path          = "webdeveloper.view.source.with." + i + ".path";

                    // If the path and key preferences are set
                    if(webdeveloper_isPreferenceSet(path) && webdeveloper_isPreferenceSet(keyPreference))
                    {
                        keyPreferenceValue = webdeveloper_getStringPreference(keyPreference, true);

                        // If the key preference value is set
                        if(keyPreferenceValue)
                        {
                            key = mainDocument.createElement("key");

                            key.setAttribute("id", keyPreference);
                            key.setAttribute("key", keyPreferenceValue);
                            key.setAttribute("modifiers", "accel,shift");
                            key.setAttribute("oncommand", "webdeveloper_loadApplicationWithSource('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "')");
                            keySet.appendChild(key);
                        }
                    }
                    else
                    {
                        webdeveloper_removeElement(keyElement);
                    }
                }
            }
        }
    }

    return success;
}

// Copies the elements ancestors to the clipboard
function webdeveloper_copyElementAncestors(event)
{
    var informationElement = document.getElementById("webdeveloper-information");
    var keyCode            = event.charCode;

    // If the information element is set and the key code is set and is 99
    if(informationElement && keyCode && keyCode == 99)
    {
        Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper).copyString(informationElement.value);

        event.preventDefault();
    }
}

// Disables the given preference
function webdeveloper_disablePreference(element, preference)
{
    // If the element and preference are set
    if(element && preference)
    {
        webdeveloper_setBooleanPreference(preference, !webdeveloper_convertToBoolean(element.getAttribute("checked")));
    }
}

// Displays the elements ancestors in the information bar
function webdeveloper_displayElementAncestors(event)
{
    var eventTarget        = event.target;
    var informationElement = document.getElementById("webdeveloper-information");

    // If there is a target and the information element is set
    if(eventTarget && informationElement)
    {
        var tagName = eventTarget.tagName;

        // If the tag name is set and does not equal scrollbar
        if(tagName && tagName != "scrollbar")
        {
            var ancestorList   = webdeveloper_getElementAncestors(eventTarget);
            var ancestorLength = ancestorList.length;
            var ancestorText   = "";

            // Loop through the ancestors
            for(var i = 0; i < ancestorLength; i++)
            {
                ancestorText += webdeveloper_getElementDescription(ancestorList[i]) + " > ";
            }

            informationElement.value = ancestorText + webdeveloper_getElementDescription(eventTarget);

            webdeveloper_configureElement(document.getElementById("webdeveloper-information-text-toolbar"), "hidden", false);

            event.preventDefault();
        }
    }
}

// Enables the given preference
function webdeveloper_enablePreference(element, preference)
{
    // If the element and preference are set
    if(element && preference)
    {
    	webdeveloper_setBooleanPreference(preference, webdeveloper_convertToBoolean(element.getAttribute("checked")));
/*
        var checked = element.getAttribute("checked");

        // If the element is checked (explicit check required)
        if(checked)
        {
            webdeveloper_setBooleanPreference(preference, true);
        }
        else
        {
            webdeveloper_setBooleanPreference(preference, false);
        }
*/
    }
}

// Formats a file size
function webdeveloper_formatFileSize(fileSize)
{
    // If the file size is set
    if(fileSize)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        // If the file size is greater than a kilobyte
        if(fileSize > 1024)
        {
            return Math.round(fileSize / 1024) + " " + stringBundle.getString("webdeveloper_kilobytes");
        }
        else
        {
            return fileSize + " " + stringBundle.getString("webdeveloper_bytes");
        }
    }
    else
    {
        return "";
    }
}

// Generates a document in a new tab or window
function webdeveloper_generateDocument(url)
{
    var generatedPage = null;
    var request       = new XMLHttpRequest();

    // If the open tabs preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true))
    {
        getBrowser().selectedTab = getBrowser().addTab(url);

        generatedPage = window;
    }
    else
    {
        generatedPage = window.open(url);
    }

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send(null);

    return generatedPage.content.document;
}

// Returns a description for an element
function webdeveloper_getElementDescription(element)
{
    var description = null;

    // If the element and tag name are set
    if(element && element.tagName)
    {
        description = element.tagName.toLowerCase();

        // If the element has an id attribute
        if(element.hasAttribute("id"))
        {
            description += " #" + element.getAttribute("id");
        }

        // If the element has a class attribute
        if(element.hasAttribute("class"))
        {
            description += " ." + element.getAttribute("class");
        }
    }

    return description;
}

// Opens the help
function webdeveloper_help()
{
    webdeveloper_loadURL("http://chrispederick.com/work/web-developer/help/");
}

// Initializes the extension
function webdeveloper_initialize(event)
{
	// Try to get the window content
	try
	{
		var windowContent = window.getBrowser();
	
		// If the window content is set
		if(windowContent)
		{
			var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);
			var dashboard      = document.getElementById("webdeveloper-dashboard");
			var tabBox         = windowContent.mTabBox;
	
			webdeveloper_upgrade();
			webdeveloper_setupDefaultOptions();
			webdeveloper_setupLocalizedOptions();
			webdeveloper_configureKeyboardShortcuts(false);
			webdeveloper_changeOptions();
	
			windowContent.addEventListener("load", webdeveloper_pageLoad, true);
			windowContent.addEventListener("unload", webdeveloper_pageUnload, true);
	
			// If the dashboard is set
			if(dashboard)
			{
				webdeveloper_setupDashboardPosition(webdeveloper_getStringPreference("webdeveloper.dashboard.position", true));
			}
	
			// If the console service is set
			if(consoleService)
			{
				consoleService.registerListener(WebDeveloperErrorConsoleListener);
			}
	
			// If the tab box is set
			if(tabBox)
			{
				tabBox.addEventListener("select", webdeveloper_tabSelect, false);
			}
	
			window.removeEventListener("load", webdeveloper_initialize, false);
		}
	}
	catch(exception)
	{
		// Do nothing
	}
}

// Returns true if the DOM Inspector is available
function webdeveloper_isDOMInspectorAvailable()
{
    try
    {
        Components.classes["@mozilla.org/inspector/dom-utils;1"].getService(Components.interfaces.inIDOMUtils);

        return true;
    }
    catch(exception)
    {
        return false;
    }
}

// Returns true if the DOM Inspector chrome is available
function webdeveloper_isDOMInspectorChromeAvailable()
{
	// If the inspectDOMDocument method is available
	if(typeof inspectDOMDocument == "function")
	{
		return true;
	}
	
	return false;
}

// Returns true if the information text toolbar is in use
function webdeveloper_isInformationTextToolbarInUse()
{
    // If one of the features that use the information text toolbar is enabled
    if(webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-display-element-information") || webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-outline-current-element") || webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-view-style-information"))
    {
        return true;
    }

    return false;
}

// Loads the given URL
function webdeveloper_loadURL(url)
{
    var oldTab = getBrowser().selectedTab;

    webdeveloper_generateDocument(url);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Logs a debug message to the error console
function webdeveloper_logDebug(message)
{
    // If the debug preference is set
    if(webdeveloper_getBooleanPreference("webdeveloper.debug", true))
    {
        Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService).logStringMessage("Web Developer: " + message);
        webdeveloper_openErrorConsole(false);
    }
}

// Opens the error console
function webdeveloper_openErrorConsole(toggle)
{
    // If the open error console in dashboard preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.error.console.dashboard", true))
    {
        var errorConsole = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_errorConsole");

        // If the error console is already open in the dashboard
        if(webdeveloper_isOpenInDashboard(errorConsole))
        {
            // If toggling the console
            if(toggle)
            {
                webdeveloper_closeInDashboard(errorConsole);
            }
            else
            {
                webdeveloper_selectInDashboard(errorConsole);
            }
        }
        else
        {
            webdeveloper_openInDashboard(errorConsole, "chrome://global/content/console.xul");
        }
    }
    else
    {
        webdeveloper_javaScriptPreviousTime = webdeveloper_javaScriptCurrentTime;
        webdeveloper_javaScriptCurrentTime  = new Date().getTime();

        // If the previous time is not set or the current time is greater than a second different from the previous time
        if(!webdeveloper_javaScriptPreviousTime || webdeveloper_javaScriptCurrentTime - webdeveloper_javaScriptPreviousTime > 1500)
        {
            toJavaScriptConsole();
        }
    }
}

// Opens a toolbar button automatically if another toolbar button is open on the toolbar
function webdeveloper_openToolbarButton(currentToolbarButton)
{
    // If the toolbar button is set and is not open
    if(currentToolbarButton && !currentToolbarButton.open)
    {
        var toolbarButton        = null;
        var toolbarButtons       = currentToolbarButton.parentNode.getElementsByTagName("toolbarbutton");
        var toolbarButtonsLength = toolbarButtons.length;

        // Loop through the toolbar buttons
        for(var i = 0; i < toolbarButtonsLength; i++)
        {
            toolbarButton = toolbarButtons.item(i);

            // If the toolbar button is set, is not the same toolbar button and is open
            if(toolbarButton && toolbarButton != currentToolbarButton && toolbarButton.open)
            {
                toolbarButton.open        = false;
                currentToolbarButton.open = true;

                break;
            }
        }
    }
}

// Displays the options dialog
function webdeveloper_options(openPage)
{
    // If an open page is set
    if(openPage)
    {
        window.openDialog("chrome://webdeveloper/content/options/options.xul", "webdeveloper-options-dialog", "centerscreen,chrome,modal,resizable", openPage);
    }
    else
    {
        window.openDialog("chrome://webdeveloper/content/options/options.xul", "webdeveloper-options-dialog", "centerscreen,chrome,modal,resizable");
    }

    webdeveloper_changeOptions();
}

// Handles the page being loaded
function webdeveloper_pageLoad(event)
{
    var contentDocument = webdeveloper_getPageLoadEventContentDocument(event);

    // If the content document is set
    if(contentDocument)
    {
        // Reset the display line guides and display ruler features
        webdeveloper_configureElement(document.getElementById("webdeveloper-line-guides-toolbar"), "hidden", true);
        webdeveloper_configureElement(document.getElementById("webdeveloper-ruler-toolbar"), "hidden", true);
        webdeveloper_removeAppliedStyle("webdeveloper-display-line-guides");
        webdeveloper_removeAppliedStyle("webdeveloper-display-ruler");

        webdeveloper_updateMetaRedirects(getBrowser().selectedBrowser);
        webdeveloper_updateRenderMode(contentDocument);

        // If the persist features preference is set and is true
        if(webdeveloper_getBooleanPreference("webdeveloper.persist.features", true))
        {
            webdeveloper_applyStyleSheets(false);
        }
        else
        {
            // Reset the information text toolbar
            webdeveloper_configureElement(document.getElementById("webdeveloper-information-text-toolbar"), "hidden", true);

            webdeveloper_clearAppliedStyles();
        }
    }
}

// Handles the page being unloaded
function webdeveloper_pageUnload(event)
{
    var contentDocument = webdeveloper_getPageLoadEventContentDocument(event);

    // If the content document is set
    if(contentDocument)
    {
        webdeveloper_updateCSSStatus();
        webdeveloper_updateJavaScriptStatus();
    }
}

// Remove applied style
function webdeveloper_removeAppliedStyle(id)
{
    // If the id is in the applied styles
    if(webdeveloper_contains(webdeveloper_appliedStyles, id))
    {
        var appliedStylesLength = webdeveloper_appliedStyles.length;

        // Loop through the applied styles
        for(var i = 0; i < appliedStylesLength; i++)
        {
            // If this style sheet is in the applied styles
            if(webdeveloper_appliedStyles[i] == id)
            {
                webdeveloper_appliedStyles.splice(i, 1);
                break;
            }
        }

        // If the only applied style has been removed
        if(webdeveloper_appliedStyles.length == 0)
        {
            webdeveloper_configureElement(document.getElementById("webdeveloper-statusbar-panel"), "hidden", true);
        }
    }
}

// Removes the outline from an element
function webdeveloper_removeElementOutline(element)
{
    // If the element is set
    if(element)
    {
        element.style.MozOutline = "";

        // If the element has an empty style attribute
        if(element.hasAttribute("style") && element.getAttribute("style") == "")
        {
            element.removeAttribute("style");
        }
    }
}

// Removes all the generated menu items from the menu
function webdeveloper_removeGeneratedMenuItems(menu)
{
    var generatedMenuItems = new Array();
    var menuItem           = null;
    var menuItems          = menu.childNodes;
    var menuItemsLength    = menuItems.length;

    // Loop through the menu items
    for(var i = 0; i < menuItemsLength; i++)
    {
        menuItem = menuItems.item(i);

        // If this is a generated menu item
        if(menuItem && menuItem.hasAttribute("class") && menuItem.getAttribute("class") == "webdeveloper-generated-menu")
        {
            generatedMenuItems.push(menuItem);
        }
    }

    menuItemsLength = generatedMenuItems.length;

    // Loop through the generated menu items
    for(i = 0; i < menuItemsLength; i++)
    {
        menu.removeChild(generatedMenuItems[i]);
    }
}

// Removes the style sheet with the given id
function webdeveloper_removeStyleSheet(id)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        webdeveloper_removeElement(documentList[i].getElementById(id));
    }

    webdeveloper_removeAppliedStyle(id);
}

// Resets the CSS status button
function webdeveloper_resetCSSStatus()
{
    var cssButton = document.getElementById("webdeveloper-css-statusbar");

    webdeveloper_javaScriptCurrentTime  = null;
    webdeveloper_javaScriptPreviousTime = null;

    // If the CSS button exists
    if(cssButton)
    {
        // If the CSS button has a class attribute
        if(cssButton.hasAttribute("class"))
        {
            cssButton.removeAttribute("class");
        }

        // If the CSS button has a tooltip text attribute
        if(cssButton.hasAttribute("tooltiptext"))
        {
            cssButton.removeAttribute("tooltiptext");
        }

        // If the toolbar preference is set to text and the CSS button has a label attribute
        if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text" && cssButton.hasAttribute("label"))
        {
            cssButton.removeAttribute("label");
        }
    }
}

// Resets the JavaScript status button
function webdeveloper_resetJavaScriptStatus()
{
    var javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    webdeveloper_javaScriptCurrentTime  = null;
    webdeveloper_javaScriptPreviousTime = null;

    // If the JavaScript button exists
    if(javaScriptButton)
    {
        // If JavaScript is enabled
        if(webdeveloper_getBooleanPreference("javascript.enabled", false))
        {
            // If the JavaScript button has a class attribute
            if(javaScriptButton.hasAttribute("class"))
            {
                javaScriptButton.removeAttribute("class");
            }

            // If the JavaScript button has a tooltip text attribute
            if(javaScriptButton.hasAttribute("tooltiptext"))
            {
                javaScriptButton.removeAttribute("tooltiptext");
            }

            // If the toolbar preference is set to text and the JavaScript button has a label attribute
            if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text" && javaScriptButton.hasAttribute("label"))
            {
                javaScriptButton.removeAttribute("label");
            }
        }
        else
        {
            var stringBundle = document.getElementById("webdeveloper-string-bundle");

            // If the JavaScript button does not have a class attribute or it is not set to disabled
            if(!javaScriptButton.hasAttribute("class") || javaScriptButton.getAttribute("class") != "disabled")
            {
                javaScriptButton.setAttribute("class", "disabled");
                javaScriptButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptDisabledTooltip"));

                // If the toolbar preference is set to text
                if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
                {
                    javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptDisabledLabel"));
                }
            }
        }
    }
}

// Resets the page
function webdeveloper_resetPage()
{
    webdeveloper_applyStyleSheets(true);
    webdeveloper_clearAppliedStyles();

    webdeveloper_outlinedElements = new Array();
}

// Runs the given bookmarklet
function webdeveloper_runBookmarklet(bookmarklet)
{
    eval(decodeURIComponent(bookmarklet));
}

// Sets up the default options
function webdeveloper_setupDefaultOptions()
{
    // Set default custom colors
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.1.color", "#ff0000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.2.color", "#33ff33");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.3.color", "#3333ff");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.4.color", "#ff0000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.custom.5.color", "#33ff33");

    // Set default dashboard position
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.dashboard.position", "bottom");

    // Set default edit CSS preferences
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.edit.color.background", "#ffffff");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.edit.color.text", "#000000");
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.edit.font.size", 12);
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.edit.update.frequency", 2000);

    // Set default feature tooltip colors
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.background", "#ffff99");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.border", "#ffcc66");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.color.text", "#000000");
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.feature.tooltip.opacity", "0.9");

    // Set default generated content font size
    webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.generated.content.font.size", 12);

    // Set default information preference
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.information.tidy", true);

    // Set default line guides preference
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.line.guides.color", "#000000");

    // Set default magnification preference
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.magnification.level", "2");

    // Set default open tabs preference
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.open.tabs", true);

    // Set default populate form fields email
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.populate.form.fields.email", "example@example.com");

    // Set default style information preference
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.style.information.dashboard", true);

    // Set default accessibility preferences
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.validate.local.accessibility.section508", true);
    webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.validate.local.accessibility.wai.priority1", true);

    // Set default CSS profile preference
    webdeveloper_setStringPreferenceIfNotSet("webdeveloper.validate.local.css.profile", "css21");
}

// Sets up the localized options
function webdeveloper_setupLocalizedOptions()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the string bundle is set
    if(stringBundle)
    {
        // Set default resize count
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.count", 1);

        // Set 800x600
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.resize.1.description", stringBundle.getString("webdeveloper_resize800x600"));
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.1.width", 800);
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.resize.1.height", 600);

        // Set default tool count
        webdeveloper_setIntegerPreferenceIfNotSet("webdeveloper.tool.count", 6);

        // Set CSS validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.1.description", stringBundle.getString("webdeveloper_validateCSS"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.1.url", "http://jigsaw.w3.org/css-validator/validator?profile=css21&warning=0&uri=");

        // Set feed validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.2.description", stringBundle.getString("webdeveloper_validateFeed"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.2.url", "http://validator.w3.org/feed/check.cgi?url=");

        // Set HTML validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.description", stringBundle.getString("webdeveloper_validateHTML"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.key", "H");
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.3.url", "http://validator.w3.org/check?verbose=1&uri=");

        // Set links validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.4.description", stringBundle.getString("webdeveloper_validateLinks"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.4.url", "http://validator.w3.org/checklink?check=Check&hide_type=all&summary=on&uri=");

        // Set section 508 validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.5.description", stringBundle.getString("webdeveloper_validateSection508"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.5.url", "http://www.cynthiasays.com/mynewtester/cynthia.exe?rptmode=-1&url1=");

        // Set WAI validator
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.6.description", stringBundle.getString("webdeveloper_validateWAI"));
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.6.url", "http://www.cynthiasays.com/mynewtester/cynthia.exe?rptmode=2&url1=");
    }
}

// Sorts two images
function webdeveloper_sortImages(imageOne, imageTwo)
{
    // If both images are set
    if(imageOne && imageTwo)
    {
        var imageOneSrc = imageOne.src;
        var imageTwoSrc = imageTwo.src;

        // If the images are equal
        if(imageOneSrc == imageTwoSrc)
        {
            return 0;
        }
        else if(imageOneSrc < imageTwoSrc)
        {
            return -1;
        }
    }

    return 1;
}

// Handles a tab being selected
function webdeveloper_tabSelect(event)
{
    var selectedTab = getBrowser().mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_selectedTab)
    {
        webdeveloper_selectedTab = selectedTab;

        webdeveloper_resetCSSStatus();
        webdeveloper_resetJavaScriptStatus();
        webdeveloper_updateAppliedStyles();
        webdeveloper_updateRenderMode(webdeveloper_getContentDocument());

        // Reset the display line guides and display ruler toolbars
        webdeveloper_configureElement(document.getElementById("webdeveloper-line-guides-toolbar"), "hidden", !webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-display-line-guides"));
        webdeveloper_configureElement(document.getElementById("webdeveloper-ruler-toolbar"), "hidden", !webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-display-ruler"));

        // Reset the information text toolbar
        webdeveloper_configureElement(document.getElementById("webdeveloper-information-text-toolbar"), "hidden", !webdeveloper_isInformationTextToolbarInUse());
    }
}

// Tidies a list of images by removing duplicates and sorting
function webdeveloper_tidyImages(imageList)
{
    var image              = null;
    var imageListLength    = imageList.length;
    var imageSrc           = null;
    var newImageList       = new Array();
    var newImageListLength = null;
    var tidiedImageList    = new Array();

    // Loop through the images
    for(var i = 0; i < imageListLength; i++)
    {
        image    = imageList[i];
        imageSrc = image.src;

        // If the image src is set and does not end in '.xul'
        if(imageSrc && !webdeveloper_endsWith(imageSrc, ".xul"))
        {
            newImageList.push(image);
        }
    }

    newImageList.sort(webdeveloper_sortImages);

    newImageListLength = newImageList.length;

    // Loop through the images
    for(i = 0; i < newImageListLength; i++)
    {
        image = newImageList[i];

        // If this is not the last image and the image is the same as the next image
        if(i + 1 < newImageListLength && image.src == newImageList[i + 1].src)
        {
            continue;
        }

        tidiedImageList.push(image);
    }

    return tidiedImageList;
}

// Toggles the applied style with the given id
function webdeveloper_toggleAppliedStyle(element, id)
{
    webdeveloper_removeAppliedStyle(id);

    // If the menu is checked
    if(element && webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        webdeveloper_addAppliedStyle(id);
    }
}

// Toggles the feature tooltip styles
function webdeveloper_toggleFeatureTooltipStyles(element, styleSheetId, selectors)
{
    webdeveloper_removeStyleSheet(styleSheetId, false);

    // If the menu is checked
    if(webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        var colors         = " background-color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.background", true) + " !important; border-color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.border", true) + " !important; color: " + webdeveloper_getStringPreference("webdeveloper.feature.tooltip.color.text", true) + " !important; ";
        var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength = documentList.length;
        var opacityValue   = webdeveloper_getStringPreference("webdeveloper.feature.tooltip.opacity", true);
        var opacity        = " -moz-opacity: " + opacityValue + " !important;  opacity: " + opacityValue + " !important; ";
        var pageDocument   = null;
        var styleElement   = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];
            styleElement = pageDocument.createElement("style");

            styleElement.appendChild(pageDocument.createTextNode(selectors + " {" + colors + opacity + "}"));
            styleElement.setAttribute("id", styleSheetId);
            styleElement.setAttribute("type", "text/css");

            webdeveloper_getDocumentHeadElement(pageDocument).appendChild(styleElement);
        }
    }
}

// Toggles an individual style sheet
function webdeveloper_toggleIndividualStyleSheet(selectedStyleSheetHref)
{
    var currentDocument  = webdeveloper_getContentDocument();
    var styleSheet       = null;
    var styleSheetHref   = null;
    var styleSheetList   = currentDocument.styleSheets;
    var styleSheetLength = styleSheetList.length;

    // Loop through the style sheets
    for(var i = 0; i < styleSheetLength; i++)
    {
        styleSheet     = styleSheetList[i];
        styleSheetHref = styleSheet.href;

        // If this is the selected style sheet
        if(styleSheetHref == selectedStyleSheetHref)
        {
            styleSheet.disabled = !styleSheet.disabled;
        }
    }
}

// Toggles the style sheet with the given id
function webdeveloper_toggleStyleSheet(element, location, id)
{
    webdeveloper_removeStyleSheet(id);

    // If the menu is checked
    if(element && webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        webdeveloper_addStyleSheet(location, id);
    }
}

// Toggles the toolbar
function webdeveloper_toggleToolbar()
{
    var toolbar = document.getElementById("webdeveloper-toolbar");

    toolbar.collapsed = !toolbar.collapsed;

    document.persist("webdeveloper-toolbar", "collapsed");
}

// Uninitializes the extension
function webdeveloper_uninitialize(event)
{
	// Try to get the window content
	try
	{
		var windowContent = window.getBrowser();
	
		// If the window content is set
		if(windowContent)
		{
			var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);
			var tabBox         = windowContent.mTabBox;
	
			windowContent.removeEventListener("load", webdeveloper_pageLoad, true);
			windowContent.removeEventListener("unload", webdeveloper_pageUnload, true);
	
			// If the console service is set
			if(consoleService)
			{
				consoleService.unregisterListener(WebDeveloperErrorConsoleListener);
			}
	
			// If the tab box is set
			if(tabBox)
			{
				tabBox.removeEventListener("select", webdeveloper_tabSelect, false);
			}
	
			window.removeEventListener("close", webdeveloper_uninitialize, false);
		}
	}
	catch(exception)
	{
		// Do nothing
	}
}

// Updates the applied styles
function webdeveloper_updateAppliedStyles()
{
    webdeveloper_clearAppliedStyles();
    webdeveloper_addAppliedStyleByElement("webdeveloper-add-user-style-sheet");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-all-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-browser-default-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-all-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-embedded-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-inline-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-linked-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-disable-print-styles");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-abbreviations");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-access-keys");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-alt-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-anchors");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-block-size");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-div-order");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-element-information");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-form-details");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-handheld-css");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-id-class-details");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-image-dimensions");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-image-file-sizes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-image-paths");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-line-guides");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-link-details");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-object-information");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-print-css");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-ruler");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-stack-levels");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-tab-index");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-table-depth");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-table-information");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-title-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-topographic-information");
    webdeveloper_addAppliedStyleByElement("webdeveloper-display-window-size-title");
    webdeveloper_addAppliedStyleByElement("webdeveloper-hide-background-images");
    webdeveloper_addAppliedStyleByElement("webdeveloper-hide-images");
    webdeveloper_addAppliedStyleByElement("webdeveloper-linearize-page");
    webdeveloper_addAppliedStyleByElement("webdeveloper-make-images-invisible");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-absolute-positioned-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-all-images");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-background-images");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-block-level-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-current-element");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-custom-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-deprecated-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-external-links");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-fixed-positioned-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-floated-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-frames");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-headings");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-images-with-adjusted-dimensions");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-images-with-empty-alt-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-images-without-alt-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-images-without-dimensions");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-images-without-title-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-links-with-ping-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-links-without-title-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-relative-positioned-elements");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-table-captions");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-table-cells");
    webdeveloper_addAppliedStyleByElement("webdeveloper-outline-all-tables");
    webdeveloper_addAppliedStyleByElement("webdeveloper-replace-images-with-alt-attributes");
    webdeveloper_addAppliedStyleByElement("webdeveloper-show-comments");
    webdeveloper_addAppliedStyleByElement("webdeveloper-small-screen-rendering");
    webdeveloper_addAppliedStyleByElement("webdeveloper-use-border-box-model");
    webdeveloper_addAppliedStyleByElement("webdeveloper-view-style-information");
}

// Updates the CSS status button
function webdeveloper_updateCSSStatus(error)
{
    var cssButton = document.getElementById("webdeveloper-css-statusbar");

    // If the CSS button is set
    if(cssButton)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        // If the error is set
        if(error)
        {
            var errorMessage = error.errorMessage;

            cssButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_cssErrorTooltip", [errorMessage]));

            // If the CSS button does not have a class attribute or it is not set to error
            if(!cssButton.hasAttribute("class") || cssButton.getAttribute("class") != "error")
            {
                cssButton.setAttribute("class", "error");

                // If the toolbar preference is set to text
                if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
                {
                    cssButton.setAttribute("label", stringBundle.getString("webdeveloper_cssErrorLabel"));
                }
            }

            // If the open CSS console error preference is set
            if(webdeveloper_getBooleanPreference("webdeveloper.open.css.console.error", true))
            {
                webdeveloper_openErrorConsole(false);
            }
        }
        else if(!cssButton.hasAttribute("class") || cssButton.getAttribute("class") != "valid")
        {
            cssButton.setAttribute("class", "valid");
            cssButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_cssNoErrorsTooltip"));

            // If the toolbar preference is set to text
            if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
            {
                cssButton.setAttribute("label", stringBundle.getString("webdeveloper_cssNoErrorsLabel"));
            }
        }
    }
}

// Updates the JavaScript status button
function webdeveloper_updateJavaScriptStatus(error)
{
    var javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    // If the JavaScript button is set
    if(javaScriptButton)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        // If the error is set
        if(error)
        {
            var errorMessage = error.errorMessage;
            var warning      = error.flags & error.warningFlag != 0;

            // If this is a warning
            if(warning)
            {
                javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptWarningTooltip", [errorMessage]));

                // If the JavaScript button does not have a class attribute or it is not set to warning
                if(!javaScriptButton.hasAttribute("class") || javaScriptButton.getAttribute("class") != "warning")
                {
                    javaScriptButton.setAttribute("class", "warning");

                    // If the toolbar preference is set to text
                    if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
                    {
                        javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptWarningLabel"));
                    }
                }

                // If the open JavaScript console warning preference is set
                if(webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.warning", true))
                {
                    webdeveloper_openErrorConsole(false);
                }
            }
            else
            {
                javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptErrorTooltip", [errorMessage]));

                // If the JavaScript button does not have a class attribute or it is not set to error
                if(!javaScriptButton.hasAttribute("class") || javaScriptButton.getAttribute("class") != "error")
                {
                    javaScriptButton.setAttribute("class", "error");

                    // If the toolbar preference is set to text
                    if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
                    {
                        javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptErrorLabel"));
                    }
                }

                // If the open JavaScript console error preference is set
                if(webdeveloper_getBooleanPreference("webdeveloper.open.javascript.console.error", true))
                {
                    webdeveloper_openErrorConsole(false);
                }
            }
        }
        else if(!javaScriptButton.hasAttribute("class") || (javaScriptButton.getAttribute("class") != "disabled" && javaScriptButton.getAttribute("class") != "valid"))
        {
            javaScriptButton.setAttribute("class", "valid");
            javaScriptButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));

            // If the toolbar preference is set to text
            if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
            {
                javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
            }
        }
    }
}

// Updates the meta redirects status
function webdeveloper_updateMetaRedirects(browser)
{
    // If the browser doc shell allow meta redirects is set
    if(browser && browser.docShell && browser.docShell.allowMetaRedirects)
    {
        browser.docShell.allowMetaRedirects = !webdeveloper_getBooleanPreference("webdeveloper.meta.redirects.disable", true);
    }
}

// Updates the options menu
function webdeveloper_updateOptionsMenu(suffix)
{
    var appliedStyles = true;

    // If there are no applied styles
    if(webdeveloper_appliedStyles.length == 0)
    {
        appliedStyles = false;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-persist-features-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.persist.features", true));
    webdeveloper_configureElement(document.getElementById("webdeveloper-reset-page-" + suffix), "disabled", !appliedStyles);
}

// Updates the render mode status button
function webdeveloper_updateRenderMode(currentDocument)
{
    var element = document.getElementById("webdeveloper-render-mode-statusbar");

    // If the render mode button exists
    if(element)
    {
        var renderMode   = currentDocument.compatMode;
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var textToolbar  = false;

        // If the toolbar preference has a value and is set to text
        if(webdeveloper_getStringPreference("webdeveloper.toolbar.icons", true) == "text")
        {
            textToolbar = true;
        }

        // If the render mode is quirks mode
        if(renderMode == "BackCompat")
        {
            element.setAttribute("class", "quirks");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_quirksModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_quirksModeLabel"));
            }
        }
        else
        {
            // If the render mode button has a class attribute
            if(element.hasAttribute("class"))
            {
                element.removeAttribute("class");
            }

            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
            }
        }
    }
}

// Updates the status menu
function webdeveloper_updateStatusMenu(statusMenu)
{
    var appliedStylesLength = webdeveloper_appliedStyles.length;

    webdeveloper_removeGeneratedMenuItems(statusMenu);

    // Loop through the applied styles
    for(var i = 0; i < appliedStylesLength; i++)
    {
        webdeveloper_addStatusMenuItem(statusMenu,webdeveloper_appliedStyles[i]);
    }

    // If the status menu has only two children
    if(statusMenu.childNodes.length == 2)
    {
        return false;
    }

    return true;
}

// Error console listener
var WebDeveloperErrorConsoleListener =
{
    // Observes changes in the console
    observe: function(error)
    {
        // If the document and error are set
        if(document && error)
        {
            // Try to convert the error to a script error
            try
            {
                error = error.QueryInterface(Components.interfaces.nsIScriptError);

                var errorCategory = error.category;
                var sourceName    = error.sourceName;

                // If the error category is set and is content javascript
                if(errorCategory && errorCategory == "content javascript")
                {
                    webdeveloper_updateJavaScriptStatus(error);
                }
                else if(errorCategory && errorCategory == "CSS Parser")
                {
                    webdeveloper_updateCSSStatus(error);
                }
                else if(sourceName && sourceName.indexOf("chrome://webdeveloper/") != -1 && webdeveloper_getBooleanPreference("webdeveloper.debug", true))
                {
                    webdeveloper_openErrorConsole(false);
                }
            }
            catch(exception)
            {
                // Do nothing
            }
        }

        return false;
    }
}
