

;; Brace macros
;; ------------
;;(global-set-key  dead_circumflex "{")
(defun TeX-Inserting (sta stb stc)
  (if (= (preceding-char) sta )
      (insert stb)
    (progn (insert stc) (backward-char 1))))
(defun TeX-schweif () (interactive) (TeX-Inserting ?\\ "{"  "{}"))
(defun TeX-rundekl () (interactive) (TeX-Inserting ?\\ "("  "()"))
(defun TeX-eckigek () (interactive) (TeX-Inserting ?\\ "["  "[]"))
(defun TeX-exponen () (interactive) (TeX-Inserting ?\\ "^" "^{}"))
(defun TeX-subscri () (interactive) (TeX-Inserting ?\\ "_" "_{}"))
(defun TeX-dollarm () (interactive) (TeX-Inserting ?\\ "$"  "$$"))
(defun TeX-REVbbox () (interactive) (TeX-Inserting ?\\ "bbox{"
"\\bbox{}"))

(add-hook 'LaTeX-mode-hook
          '(lambda ()
             ;; Uncomment this for automatic bracket closing
             ;; Begin bracket closing
             (local-set-key  "{" 'TeX-schweif)
             (local-set-key  "(" 'TeX-rundekl)
             (local-set-key  "[" 'TeX-eckigek)
             (local-set-key  "^" 'TeX-exponen)
             (local-set-key  "_" 'TeX-subscri)
             (local-set-key  "$" 'TeX-dollarm)
             (local-set-key  "\C-b" 'TeX-REVbbox)
             ;; End bracket closing
))

(add-hook 'LaTeX-mode-hook 'turn-on-reftex)

(add-hook 'LaTeX-mode-hook
	  '(lambda ()
;	     (emaxima-mode t)
 	     (auto-fill-mode t)
 	     (latex-math-mode t)
 	     (abbrev-mode t)
;;	     (longlines-mode t)
             (flyspell-mode t)
;;;              (reftex-mode t)
	     )
)
;;; 
;;; ;(add-hook 'LaTeX-mode-hook
;;; ;	  '(lambda ()
;;; ;	     (emaxima-mode t)
;;; ;             ;(if (featurep 'xemacs)
;;; ;               (easy-menu-add emaxima-menu emaxima-mode-map)
;;; ;	     ;)
;;; ;	     )
;;; ;	  )

(add-hook 'LaTeX-mode-hook
       '(lambda () "Set german8 as default dictionary."
         (setq ispell-personal-dictionary "~/.ispell-dict-personal")
         (ispell-change-dictionary "german8")
        )
)

