(*******************************************************************************)
(* GeoProof, an interactive geometry tool writen in OCaml.                    *)
(* Copyright (C) 2004 Nicolas Franois et Julien Narboux                       *)
(*                                                                             *)
(* This program is free software; you can redistribute it and/or               *)
(* modify it under the terms of the GNU General Public License                 *)
(* as published by the Free Software Foundation; either version 2              *)
(* of the License, or (at your option) any later version.                      *)
(*                                                                             *)
(* This program is distributed in the hope that it will be useful,             *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of              *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *)
(* GNU General Public License for more details.                                *)
(*                                                                             *)
(* You should have received a copy of the GNU General Public License           *)
(* along with this program; if not, write to the Free Software                 *)
(* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)
(*******************************************************************************)

let window_about () =
  let windowabout =
    GWindow.window 
      ~type_hint:`DIALOG  
      ~position:`CENTER_ON_PARENT 
      ~resizable:false
      ~title:"About GeoProof"
      ~border_width:3
     ()
  in
  windowabout#set_destroy_with_parent true;
  windowabout#set_skip_pager_hint true;
  windowabout#set_skip_taskbar_hint true;
  (* windowabout#set_decorated false; 
  This function exists in Gtk but not in lablgtk *)
  
  let vbox = GPack.vbox ~spacing:5 ~packing:windowabout#add () in

  let labeltitre =
    GMisc.label 
      ~line_wrap:true 
      ~markup:"<span size=\"x-large\" style=\"italic\" weight=\"bold\">Welcome to GeoProof !</span>\nhttp://home.gna.org/geoproof/"
      ~justify:`CENTER ~packing:vbox#add ()
  in

  let labelcopyright =
    GMisc.label 
      ~text:
      "\nCopyright (C) 2004-2008 Julien Narboux\nCopyright (C) 2003-2004 Nicolas Francois\n"
      ~packing:vbox#add ()
  in

  let dessin = GMisc.image  ~packing:vbox#add () in
  let pix = Icons.get_pixbuf Icons.icon_geoproof 375 220 in

  dessin#set_pixbuf pix;
 
  let geoproof_version_label =
    GMisc.label ~line_wrap:true ~text:("Version "^Autoconf.version)
      ~justify:`CENTER ~packing:vbox#add ()
  in

    let geoproof_compile_date_label =
    GMisc.label ~line_wrap:true ~text:("Compiled "^Autoconf.compiled)
      ~justify:`CENTER ~packing:vbox#add ()
  in

  let libs =    
    GMisc.label ~line_wrap:true ~text:"Libraries versions :"
      ~justify:`CENTER ~packing:vbox#add ()
  in

  let lib_label s () = GMisc.label  ~text:s ~packing:vbox#add () in

  lib_label ("Run-time Cairo version : "^(Cairo.run_time_version_string ())) ();
  lib_label ("Compile-time Cairo version : "^(Cairo.compile_time_version_string)) ();
   
  let gtk_version_string = let x,y,z = GMain.Main.version in Printf.sprintf "%d.%d.%d" x y z in
  lib_label ("GTK version : "^gtk_version_string) ();

  let button = GButton.button ~label:"Close" ~packing: vbox#add () in

  ignore (button#connect#clicked ~callback:windowabout#destroy);

  windowabout#show()



