(*******************************************************************************)
(* GeoProof, an interactive geometry tool writen in OCaml.                    *)
(* Copyright (C) 2004 Nicolas Franois et Julien Narboux                       *)
(*                                                                             *)
(* This program is free software; you can redistribute it and/or               *)
(* modify it under the terms of the GNU General Public License                 *)
(* as published by the Free Software Foundation; either version 2              *)
(* of the License, or (at your option) any later version.                      *)
(*                                                                             *)
(* This program is distributed in the hope that it will be useful,             *)
(* but WITHOUT ANY WARRANTY; without even the implied warranty of              *)
(* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *)
(* GNU General Public License for more details.                                *)
(*                                                                             *)
(* You should have received a copy of the GNU General Public License           *)
(* along with this program; if not, write to the Free Software                 *)
(* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)
(*******************************************************************************)

open Geometric_functions.GeometryFunctions
open Types_de_base
open Fonctions
open Repere
open Options
open Optionsdeconfiguration
open Objets_graphiques
open Objets_ligne
open Construction
open List

class type virtual t_objet_droite =
object
  inherit Objets_ligne.t_objet_ligne
  method paint : Cairo.t ->  Repere.t -> unit
  method est_proche : Repere.t -> t_coords -> bool
  method objet_type : t_type_objet 
end

class virtual objet_droite =
  object (self)
    inherit objet_ligne
	
    method paint cr rep = 
      if self#objet_calculable then
	begin
	  let eq = self#equation_droite in
	  let l = line_inter_frame rep eq in
	    if length l = 0 
	    then 
	      ()
	    else
	      begin
		let c1 = hd l
		and c2 = hd (tl l) in
		  Cairo.move_to cr c1.xfloat c1.yfloat;
	          Cairo.line_to cr c2.xfloat c2.yfloat;
		  Cairo.stroke cr
	      end
	end

    method est_proche rep c =
      if self#objet_calculable then
	begin
	  let eq = self#equation_droite in
	  distance2_point_droite_pixel rep c eq <= !!pixels_proche
	end
      else false
	  
    method objet_type = TYPE_DROITE
  end

