--- status: DRAFT
--- author(s): L. Gold, and Dan Grayson
--- notes:  

document { 
     -- check this node for accuracy
     Key => {(degreesRing,List),(degreesRing,ZZ)},
     Headline => "the ring of degrees",
     Usage => "degreesRing x",
     Inputs => {
	  "x" => {ofClass{List,ZZ}, "a list of integers, or a single integer"}
	  },
     Outputs => {
	  PolynomialRing => {
	       "the ring of Laurent polynomials whose monomials correspond to the degrees of the
	       monomials in a ring whose heft vector is ", TT "x", ", or, if ", TT "x", " is an integer, in a
	       ring with degree rank ", TT "x", " and no heft vector.  See ", TO "degreeMonoid", "."
	       }
	  },
     PARA {
	  "This function produces a Laurent polynomial ring in ", TT "n", " variables",
	  TT "T_0, ... , T_{n-1}", ", where ", TT "n", " is the length of ", TT "x", " if ", TT "x", " is a list and is ", TT "x", " otherwise.
	  If ", TT "n=1", ", then the single variable is ", TT "T", ".  Use ", TO "use", " as in the following
	  example to assign the indeterminates of the ring to global variables, or assign the ring itself to a global
	  variable."
	  },
     EXAMPLE lines ///
     degreesRing 3
     describe oo
     T_0
     use degreesRing 3
     T_0
     ///,
     PARA {
     	  "Elements of this ring are used as variables for Poincare polynomials generated by ", TO "poincare", " and ", TO "poincareN", " as well as ", 
     	  TO2(hilbertSeries,  "Hilbertseries"), "."
	  },
     PARA{
	  "The degrees ring is a Laurent polynomial ring, as can be seen by
	  the option in the definition of the ring that says ", 
	  TT "Inverses => true", ". The monomial ordering
	  used in the degrees ring is ", TT "RevLex", " so the polynomials
	  in it will be displayed with the smallest exponents first,
	  because such polynomials are often used as Hilbert series."
	  },
     EXAMPLE lines ///
     W = degreesRing {1,2,5}
     describe W
     use W
     (1+T_1+T_2^2)^3
     degreesRing 3
     describe oo
     R = QQ[x,y,Degrees => {{1,-2},{2,-1}}];
     heft R
     describe degreesRing R
     S = QQ[x,y,Degrees => {-2,1}];
     heft S
     describe degreesRing S
     ///,
     SeeAlso => {
	  "poincare", "poincareN", "hilbertFunction", "hilbertSeries", "hilbertPolynomial", "reduceHilbert",
	  "division in polynomial rings with monomials less than 1", heft, use }
     }

undocumented {(degreesRing, QuotientRing), (degreesRing,PolynomialRing)}

document { 
     Key => degreesRing,
     Headline => "the ring of degrees"
     }

document { 
     Key => {(degreesRing,Ring),(degreesRing, Module),(degreesRing,GeneralOrderedMonoid)},
     Headline => "the ring of degrees",
     Usage => "degreesRing R",
     Inputs => {
	  "R"
	  },
     Outputs => {
	  PolynomialRing => "actually Laurent polynomial ring"
	  },
     "This function produces a Laurent polynomial ring in n
     variables", TT "T_0, ... , T_{n-1}"," whose monomials are the
     degrees of elements of the given ring. If n=1, then the variable
     has no subscript.",
     EXAMPLE {
	  "R =  ZZ [x, y];",
	  "degreesRing R",
	  "S = ZZ[x,y, Degrees=>{{1,1},{1,1}}];",
	  "degreesRing S"
     	  }
     }
