--- status: Draft
--- author(s): MES
--- notes: 

document { 
     Key => toDual,
     Headline => "inverse system",
     Usage => "g = toDual(d,f)",
     Inputs => {
	  "d" => ZZ => "",
	  "f" => Matrix => {"a homogeneous one row matrix over a polynomial ring 
	    R = k[x1 ... xn]"}
	  },
     Outputs => {
	  "g" => Matrix => "a one row matrix"
	  },
     "Returns generators for the intersection of the submodule I' = Hom(R/image f, E) and the submodule
     of E generated by y1^d ... yn^d.  For this notation, and more details and examples, see
     ", TO "inverse systems", ".",
     PARA{},
     "If I = ideal f contains the powers x1^(d+1), ..., xn^(d+1), then toDual(d,f)
     is a matrix whose entries correspond to the generators of Hom_R(R/image f, E).",
     EXAMPLE lines ///
     	  R = ZZ/32003[a..e];
	  f = matrix{{a^2, b^2, c^2, d^2, e^3, a*d-e^2}}
	  g = toDual(1,f)
	  ideal fromDual g == ideal f
	  g = toDual(2,f)
	  ideal fromDual g == ideal f
	  g = toDual(3,f)
	  ideal fromDual g == ideal f
	  ///,
     SeeAlso => fromDual
     }

TEST ///
 R = QQ[a,b,c]
 f= matrix"a-b,c"
 toDual(1,f)
 toDual(2,f)
 toDual(3,f)
///
