/**
* Copyright (c) 2012, Ynon Perek
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
* conditions are met:
* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* Neither the name of the <ORGANIZATION> nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <QtGui>
#include <QtWebKit>
#include <QNetworkReply>
#include "flwebview.h"


#include <QtCore/QDebug>

FlWebView::FlWebView              ( QWidget * parent, bool withClose ):
QWebView(parent)
{
    this->topLevel=false;
    this->linksHighlighted=false;

    QVBoxLayout *vbox = new QVBoxLayout(this);
    QHBoxLayout *hbox = new QHBoxLayout();
    setOption(WV_IGNORE_DROPS, true);
    setOption(WV_OPEN_NEW_WINDOWS, true);
    connect(this->page(), SIGNAL(loadFinished(bool)),this,SLOT(removeTargets()));
    connect(this->page(), SIGNAL(windowCloseRequested()),this, SLOT(windowCloseRequested()));
//    connect(this->page(), SIGNAL(),this, SLOT(windowCloseRequested()));
    connect(this->page(), SIGNAL(destroyed(QObject*)),this, SLOT(windowCloseRequested()));
    connect(this->page(), SIGNAL(destroyed()),this, SLOT(windowCloseRequested()));
    connect(this->page(), SIGNAL(loadFinished(bool)),this, SLOT(myraise()));

    QToolButton *closeButton = new QToolButton(this);
    closeButton->setIcon(QIcon("./cancel.png"));
    closeButton->setToolTip(tr("Close"));
/*    QToolButton *incButton = new QToolButton(this);
    incButton->setIcon(QIcon("./fontsizeup.png"));
    incButton->setToolTip(tr("Larger"));
    QToolButton *decButton = new QToolButton(this);
    decButton->setIcon(QIcon("./fontsizedown.png"));
    decButton->setToolTip(tr("Smaller"));
*/
//    hbox->addWidget(incButton, 0, Qt::AlignRight);
//    hbox->addWidget(decButton, 0, Qt::AlignRight);
    hbox->addWidget(closeButton, 1, Qt::AlignRight);

 //     vbox->addWidget(this);
      vbox->addLayout(hbox);
      vbox->addStretch(1);
          if(!withClose){closeButton->hide();
   }
    connect(closeButton,SIGNAL(clicked()),this,SLOT(windowCloseByJavaScript()));
//    connect(parent->incButton,SIGNAL(clicked()),this,SLOT(increaseFontSize()));
//    connect(parent->decButton,SIGNAL(clicked()),this,SLOT(decreaseFontSize()));

    defaultFontSize=16;
    FontSize=16;
    this->page()->settings ()->setFontSize(QWebSettings::DefaultFontSize,this->FontSize);
    this->page()->setForwardUnsupportedContent(true);
    connect(this->page(),SIGNAL(unsupportedContent(QNetworkReply*)),this, SLOT(download(QNetworkReply*)));


    connect(this, SIGNAL(titleChanged(QString)), SLOT(adjustTitle()));
    this->installEventFilter(this);
}

/*
FlWebView::FlWebView              ( QWidget * parent):
    QWebView(parent)
{
    FlWebView::FlWebView(parent, true);
}

FlWebView::FlWebView              ( QWidget * parent, bool withClose, PDFWindow *pdfview ):
    QWebView(parent)
{
    FlWebView::FlWebView(parent, withClose);
    setPDFview(pdfview);
    connect(this, SIGNAL(pdfDownloaded(QByteArray)), this->pdfview, SLOT(openDocument(QByteArray)));
}
*/

void FlWebView::dropEvent         ( QDropEvent * ev )
{
    if ( ! getOption(WV_IGNORE_DROPS) )
    {
        QWebView::dropEvent(ev);
    }
}

FlWebView *FlWebView::createWindow ( QWebPage::WebWindowType type )
{
    if ( ! getOption(WV_OPEN_NEW_WINDOWS) )
    {
        return FlWebView::createWindow( type );
    }

    qDebug() << "Create window: " << type;
//    FlWebView *newwindow = new FlWebView(this,true);//,this->pdfview);
    FlWebView *newwindow = new FlWebView(this,false);//,this->pdfview);
    newwindow->setWindowFlags( Qt::Window );
    newwindow->setPDFview(this->getPDFview());

    if ( type == QWebPage::WebModalDialog )
    {
        newwindow->setWindowModality( Qt::WindowModal );
    }

    //newwindow->setWindowModality( Qt::WindowModal );

    newwindow->show();
    return newwindow;
}

void FlWebView::windowCloseRequested(){
  qDebug() << "close window";
  this->close();
}

void FlWebView::windowCloseByJavaScript(){
  qDebug() << "window.close()";
  QString jsclose =    "window.close()";
     this->page()->mainFrame()->evaluateJavaScript(jsclose);
}



void FlWebView::removeTargets(){
    QApplication::setOverrideCursor(Qt::WaitCursor);
    QString codeA_blank =    "$('a[target=\"_blank\"]').removeAttr('target')";
    QString codeAblank =     "$('a[target=\"blank\"]').removeAttr('target')";
    QString codeAnew =       "$('a[target=\"new\"]').removeAttr('target')";
    QString codeForm_blank = "$('form[target=\"_blank\"]').removeAttr('target')";
    QString codeFormblank =  "$('form[target=\"blank\"]').removeAttr('target')";
    QString codeFormnew =    "$('form[target=\"new\"]').removeAttr('target')";
    qDebug() << "remove target";
    this->page()->mainFrame()->evaluateJavaScript(codeA_blank);
    this->page()->mainFrame()->evaluateJavaScript(codeAblank);
    this->page()->mainFrame()->evaluateJavaScript(codeAnew);
    this->page()->mainFrame()->evaluateJavaScript(codeForm_blank);
    this->page()->mainFrame()->evaluateJavaScript(codeFormblank);
    this->page()->mainFrame()->evaluateJavaScript(codeFormnew);
    for (int i = 0; i < this->page()->mainFrame()->childFrames().size(); ++i) {
        if (this->page()->mainFrame()->childFrames().at(i)){
            qDebug() << "remove target level " << i;
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeA_blank);
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeAblank);
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeAnew);
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeForm_blank);
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeFormblank);
            this->page()->mainFrame()->childFrames().at(i)->evaluateJavaScript(codeFormnew);
        }
    }
    QApplication::setOverrideCursor(Qt::ArrowCursor);
}


void FlWebView::setOption(FlWebView::TWebViewOptions opt, bool value)
{
    m_opts.insert(opt, value);
}

bool FlWebView::getOption(TWebViewOptions opt)
{
    return m_opts.value(opt, false);
}

FlWebView::~FlWebView(){
    this->~QWebView();
    this->close();
}

void FlWebView::increaseFontSize(){
  qDebug() << "fontsize++";
  if(this->FontSize<32)
    this->FontSize++;
  this->page()->settings ()->setFontSize(QWebSettings::DefaultFontSize,this->FontSize);
}

void FlWebView::decreaseFontSize(){
  qDebug() << "fontsize--";
  if(this->FontSize>8)
    this->FontSize--;
  this->page()->settings ()->setFontSize(QWebSettings::DefaultFontSize,this->FontSize);
}

void FlWebView::resetFontSize(){
  qDebug() << "fontsize reset";
  this->FontSize=this->defaultFontSize;
  this->page()->settings ()->setFontSize(QWebSettings::DefaultFontSize,this->defaultFontSize);
}

void FlWebView::download(QNetworkReply* reply){
    if(reply->header(QNetworkRequest::ContentTypeHeader).toString().left(15)==QString("application/pdf")){
      qDebug() << "download" << reply->header(QNetworkRequest::ContentTypeHeader) << " \n" << reply->rawHeaderList() << " \n " << reply->url();
      this->netReply=reply;

      connect(this->netReply, SIGNAL(downloadProgress(qint64,qint64)), SLOT(setProgress(qint64,qint64)));
      connect(this->netReply, SIGNAL(finished()), this, SLOT(openPDF()));
      this->page()->mainFrame()->setHtml("<body><html><h1>Downloading PDF, please wait</h1></html></body>");
    } else {
        qDebug()<< "unhandled download: " << reply->header(QNetworkRequest::ContentTypeHeader) << endl;
    }
}

void FlWebView::myraise(){
    qDebug() << "raise flwebview";
    this->raise();
    this->show();
}

void FlWebView::openPDF(){
    qDebug() << "pdf:" << endl;
    int length=this->netReply->bytesAvailable();
    QByteArray pdfdata =this->netReply->readAll();
    qDebug() << pdfdata.left(32).toHex() << endl << "##################";
//    browser->pdfview->documentWidget->setDocument(pdfdata);
    if(!this->topLevel)
        this->windowCloseByJavaScript();
    else
        this->back();
    emit(pdfDownloaded(pdfdata));
}


void FlWebView::setPDFview(PDFWindow *pdfwin){
    this->pdfview=pdfwin;
    qDebug() << "connect pdfDownloaded with openDocument:";
    connect(this, SIGNAL(pdfDownloaded(QByteArray)), this->pdfview, SLOT(openDocument(QByteArray)));
}

PDFWindow *FlWebView::getPDFview(){
    return this->pdfview;
}


void FlWebView::adjustTitle()
{
    if (progress <= 0 || progress >= 100)
        setWindowTitle(this->title());
    else
        setWindowTitle(QString("%1 (%2%)").arg(this->title()).arg(progress));
}

void FlWebView::setProgress(qint64 part, qint64 all)
{
    qDebug() << "in setProgress";
    progress = part*100/all;
    adjustTitle();
}

bool FlWebView::eventFilter(QEvent* e, QObject* o) {
   qDebug() << "eventfilter";
   if (o == this && e->type() == QEvent::Close) {
       qDebug() << "close event";
       this->windowCloseByJavaScript();
   }
   return false;
}
