/* GdkSupport.c generated by valac 0.40.4, the Vala compiler
 * generated from GdkSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _GdkSnifferPrivate {
	DetectedPhotoInformation* detected;
	gboolean size_ready;
	gboolean area_prepared;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};


static gpointer gdk_reader_parent_class = NULL;
static gpointer gdk_sniffer_parent_class = NULL;

gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType gdk_reader_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GdkReader* gdk_reader_construct (GType object_type,
                                 const gchar* filepath,
                                 PhotoFileFormat file_format);
PhotoFileReader* photo_file_reader_construct (GType object_type,
                                              const gchar* filepath,
                                              PhotoFileFormat file_format);
static PhotoMetadata* gdk_reader_real_read_metadata (PhotoFileReader* base,
                                              GError** error);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self,
                                    GFile* file,
                                    GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_unscaled_read (PhotoFileReader* base,
                                          GError** error);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value,
                                   gpointer v_object);
void value_take_photo_file_sniffer (GValue* value,
                                    gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
GType gdk_sniffer_get_type (void) G_GNUC_CONST;
#define GDK_SNIFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GDK_SNIFFER, GdkSnifferPrivate))
GdkSniffer* gdk_sniffer_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options);
PhotoFileSniffer* photo_file_sniffer_construct (GType object_type,
                                                GFile* file,
                                                PhotoFileSnifferOptions options);
static DetectedPhotoInformation* gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  gboolean* is_corrupted,
                                                  GError** error);
DetectedPhotoInformation* detected_photo_information_new (void);
DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
static void gdk_sniffer_on_size_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* loader,
                                   gint width,
                                   gint height);
static void _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                                    gint width,
                                                                    gint height,
                                                                    gpointer self);
static void gdk_sniffer_on_area_prepared (GdkSniffer* self,
                                   GdkPixbufLoader* pixbuf_loader);
static void _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                                    gpointer self);
gchar* photo_metadata_exif_hash (PhotoMetadata* self);
gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
static guint8* _vala_array_dup5 (guint8* self,
                          int length);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
PhotoFileFormat photo_file_format_from_pixbuf_name (const gchar* name);
static void gdk_sniffer_finalize (PhotoFileSniffer * obj);


GdkReader*
gdk_reader_construct (GType object_type,
                      const gchar* filepath,
                      PhotoFileFormat file_format)
{
	GdkReader* self = NULL;
#line 8 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 9 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = (GdkReader*) photo_file_reader_construct (object_type, filepath, file_format);
#line 8 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self;
#line 354 "GdkSupport.c"
}


static PhotoMetadata*
gdk_reader_real_read_metadata (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 13 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 13 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	metadata = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp2_, &_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_media_metadata_unref0 (metadata);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 391 "GdkSupport.c"
	}
#line 16 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = metadata;
#line 16 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 397 "GdkSupport.c"
}


static GdkPixbuf*
gdk_reader_real_unscaled_read (PhotoFileReader* base,
                               GError** error)
{
	GdkReader * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError * _inner_error_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = _tmp3_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp2_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = _tmp4_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 434 "GdkSupport.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = _tmp0_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp5_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 446 "GdkSupport.c"
}


static GdkPixbuf*
gdk_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	GdkReader * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Dimensions _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_;
	gint _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError * _inner_error_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = *scaled;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = _tmp3_.width;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = *scaled;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = _tmp5_.height;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = gdk_pixbuf_new_from_file_at_scale (_tmp2_, _tmp4_, _tmp6_, FALSE, &_inner_error_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp8_ = _tmp7_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp2_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = _tmp8_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 501 "GdkSupport.c"
	}
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp9_ = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = NULL;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp9_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 513 "GdkSupport.c"
}


static void
gdk_reader_class_init (GdkReaderClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_reader_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader *, GError**)) gdk_reader_real_read_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader *, GError**)) gdk_reader_real_unscaled_read;
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader *, Dimensions*, Dimensions*, GError**)) gdk_reader_real_scaled_read;
#line 528 "GdkSupport.c"
}


static void
gdk_reader_instance_init (GdkReader * self)
{
}


GType
gdk_reader_get_type (void)
{
	static volatile gsize gdk_reader_type_id__volatile = 0;
	if (g_once_init_enter (&gdk_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdkReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkReader), 0, (GInstanceInitFunc) gdk_reader_instance_init, NULL };
		GType gdk_reader_type_id;
		gdk_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "GdkReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gdk_reader_type_id__volatile, gdk_reader_type_id);
	}
	return gdk_reader_type_id__volatile;
}


GdkSniffer*
gdk_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	GdkSniffer* self = NULL;
#line 33 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 34 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = (GdkSniffer*) photo_file_sniffer_construct (object_type, file, options);
#line 33 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self;
#line 564 "GdkSupport.c"
}


static void
_gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender,
                                                               gint width,
                                                               gint height,
                                                               gpointer self)
{
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_on_size_prepared ((GdkSniffer*) self, _sender, width, height);
#line 576 "GdkSupport.c"
}


static void
_gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender,
                                                               gpointer self)
{
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_on_area_prepared ((GdkSniffer*) self, _sender);
#line 586 "GdkSupport.c"
}


static guint8*
_vala_array_dup5 (guint8* self,
                  int length)
{
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 596 "GdkSupport.c"
}


static gpointer
_detected_photo_information_ref0 (gpointer self)
{
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self ? detected_photo_information_ref (self) : NULL;
#line 605 "GdkSupport.c"
}


static DetectedPhotoInformation*
gdk_sniffer_real_sniff (PhotoFileSniffer* base,
                        gboolean* is_corrupted,
                        GError** error)
{
	GdkSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* result = NULL;
	DetectedPhotoInformation* _tmp0_;
	GdkPixbufLoader* pixbuf_loader = NULL;
	GdkPixbufLoader* _tmp1_;
	GdkPixbufLoader* _tmp2_;
	GdkPixbufLoader* _tmp3_;
	GChecksum* md5_checksum = NULL;
	gboolean _tmp4_;
	DetectedPhotoInformation* _tmp6_;
	PhotoMetadata* _tmp7_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	guint8* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gint __tmp24__size_ = 0;
	gboolean _tmp25_;
	guint8* buffer = NULL;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gint buffer_length1;
	gint _buffer_size_;
	gsize count = 0UL;
	GFileInputStream* fins = NULL;
	GFile* _tmp29_;
	GFileInputStream* _tmp30_;
	GFileInputStream* _tmp53_;
	gboolean _tmp55_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_;
	DetectedPhotoInformation* _tmp63_;
	DetectedPhotoInformation* _tmp64_;
	GError * _inner_error_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_SNIFFER, GdkSniffer);
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = detected_photo_information_new ();
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_detected_photo_information_unref0 (self->priv->detected);
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->detected = _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = gdk_pixbuf_loader_new ();
#line 40 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	pixbuf_loader = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = pixbuf_loader;
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_signal_connect (_tmp2_, "size-prepared", (GCallback) _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared, self);
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = pixbuf_loader;
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_signal_connect (_tmp3_, "area-prepared", (GCallback) _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared, self);
#line 45 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	md5_checksum = NULL;
#line 46 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 46 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp4_) {
#line 674 "GdkSupport.c"
		GChecksum* _tmp5_;
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp5_ = g_checksum_new (G_CHECKSUM_MD5);
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		md5_checksum = _tmp5_;
#line 682 "GdkSupport.c"
	}
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = self->priv->detected;
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = photo_metadata_new ();
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_media_metadata_unref0 (_tmp6_->metadata);
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_->metadata = _tmp7_;
#line 692 "GdkSupport.c"
	{
		DetectedPhotoInformation* _tmp8_;
		PhotoMetadata* _tmp9_;
		GFile* _tmp10_;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp8_ = self->priv->detected;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp9_ = _tmp8_->metadata;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp10_, &_inner_error_);
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 707 "GdkSupport.c"
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* err = NULL;
		DetectedPhotoInformation* _tmp11_;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		err = _inner_error_;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_inner_error_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp11_ = self->priv->detected;
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_media_metadata_unref0 (_tmp11_->metadata);
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp11_->metadata = NULL;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_error_free0 (err);
#line 728 "GdkSupport.c"
	}
	__finally34:
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 741 "GdkSupport.c"
	}
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp13_) {
#line 747 "GdkSupport.c"
		DetectedPhotoInformation* _tmp14_;
		PhotoMetadata* _tmp15_;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp14_ = self->priv->detected;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp15_ = _tmp14_->metadata;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp12_ = _tmp15_ != NULL;
#line 756 "GdkSupport.c"
	} else {
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp12_ = FALSE;
#line 760 "GdkSupport.c"
	}
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp12_) {
#line 764 "GdkSupport.c"
		DetectedPhotoInformation* _tmp16_;
		DetectedPhotoInformation* _tmp17_;
		PhotoMetadata* _tmp18_;
		gchar* _tmp19_;
		DetectedPhotoInformation* _tmp20_;
		DetectedPhotoInformation* _tmp21_;
		PhotoMetadata* _tmp22_;
		gchar* _tmp23_;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp16_ = self->priv->detected;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp17_ = self->priv->detected;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp18_ = _tmp17_->metadata;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp19_ = photo_metadata_exif_hash (_tmp18_);
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_free0 (_tmp16_->exif_md5);
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp16_->exif_md5 = _tmp19_;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp20_ = self->priv->detected;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp21_ = self->priv->detected;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp22_ = _tmp21_->metadata;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp23_ = photo_metadata_thumbnail_hash (_tmp22_);
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_free0 (_tmp20_->thumbnail_md5);
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp20_->thumbnail_md5 = _tmp23_;
#line 797 "GdkSupport.c"
	}
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp25_) {
#line 803 "GdkSupport.c"
		guint8* _tmp26_;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp26_ = g_new0 (guint8, 64 * 1024);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = (g_free (_tmp24_), NULL);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = _tmp26_;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24__length1 = 64 * 1024;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		__tmp24__size_ = _tmp24__length1;
#line 815 "GdkSupport.c"
	} else {
		guint8* _tmp27_;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp27_ = g_new0 (guint8, 8 * 1024);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = (g_free (_tmp24_), NULL);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = _tmp27_;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24__length1 = 8 * 1024;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		__tmp24__size_ = _tmp24__length1;
#line 828 "GdkSupport.c"
	}
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp28_ = (_tmp24_ != NULL) ? _vala_array_dup5 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp28__length1 = _tmp24__length1;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer = _tmp28_;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer_length1 = _tmp28__length1;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_buffer_size_ = buffer_length1;
#line 65 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	count = (gsize) 0;
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp29_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp30_ = g_file_read (_tmp29_, NULL, &_inner_error_);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	fins = _tmp30_;
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		buffer = (g_free (buffer), NULL);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = (g_free (_tmp24_), NULL);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 68 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 862 "GdkSupport.c"
	}
	{
		gboolean _tmp31_ = FALSE;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp31_ = TRUE;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		while (TRUE) {
#line 870 "GdkSupport.c"
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp32_;
			guint8* _tmp33_;
			gint _tmp33__length1;
			gsize _tmp34_;
			gsize _tmp35_;
			gsize _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp31_) {
#line 886 "GdkSupport.c"
			}
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp31_ = FALSE;
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp32_ = fins;
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp33_ = buffer;
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp33__length1 = buffer_length1;
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			bytes_read = (gsize) g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_input_stream_get_type (), GInputStream), _tmp33_, (gsize) _tmp33__length1, NULL, &_inner_error_);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				g_propagate_error (error, _inner_error_);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_object_unref0 (fins);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				buffer = (g_free (buffer), NULL);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp24_ = (g_free (_tmp24_), NULL);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_checksum_free0 (md5_checksum);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_object_unref0 (pixbuf_loader);
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				return NULL;
#line 914 "GdkSupport.c"
			}
#line 71 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp34_ = bytes_read;
#line 71 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp34_ <= ((gsize) 0)) {
#line 72 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				break;
#line 922 "GdkSupport.c"
			}
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp35_ = count;
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp36_ = bytes_read;
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			count = _tmp35_ + _tmp36_;
#line 76 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp37_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 76 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp37_) {
#line 934 "GdkSupport.c"
				GChecksum* _tmp38_;
				guint8* _tmp39_;
				gint _tmp39__length1;
				gsize _tmp40_;
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp38_ = md5_checksum;
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp39_ = buffer;
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp39__length1 = buffer_length1;
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp40_ = bytes_read;
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				g_checksum_update (_tmp38_, _tmp39_, _tmp40_);
#line 949 "GdkSupport.c"
			}
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp42_ = self->priv->size_ready;
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp42_) {
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp41_ = TRUE;
#line 957 "GdkSupport.c"
			} else {
				gboolean _tmp43_;
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp43_ = self->priv->area_prepared;
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp41_ = !_tmp43_;
#line 964 "GdkSupport.c"
			}
#line 80 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp41_) {
#line 968 "GdkSupport.c"
				GdkPixbufLoader* _tmp44_;
				guint8* _tmp45_;
				gint _tmp45__length1;
				gsize _tmp46_;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp44_ = pixbuf_loader;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp45_ = buffer;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp45__length1 = buffer_length1;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp46_ = bytes_read;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				gdk_pixbuf_loader_write (_tmp44_, _tmp45_ + 0, (gsize) (((gint) _tmp46_) - 0), &_inner_error_);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_object_unref0 (fins);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					buffer = (g_free (buffer), NULL);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_tmp24_ = (g_free (_tmp24_), NULL);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_checksum_free0 (md5_checksum);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_object_unref0 (pixbuf_loader);
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					return NULL;
#line 999 "GdkSupport.c"
				}
			}
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp49_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp49_) {
#line 1006 "GdkSupport.c"
				gboolean _tmp50_;
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp50_ = self->priv->size_ready;
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp48_ = _tmp50_;
#line 1012 "GdkSupport.c"
			} else {
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp48_ = FALSE;
#line 1016 "GdkSupport.c"
			}
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp48_) {
#line 1020 "GdkSupport.c"
				gboolean _tmp51_;
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp51_ = self->priv->area_prepared;
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp47_ = _tmp51_;
#line 1026 "GdkSupport.c"
			} else {
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp47_ = FALSE;
#line 1030 "GdkSupport.c"
			}
#line 84 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp47_) {
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				break;
#line 1036 "GdkSupport.c"
			}
		}
	}
	{
		GdkPixbufLoader* _tmp52_;
#line 90 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp52_ = pixbuf_loader;
#line 90 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		gdk_pixbuf_loader_close (_tmp52_, &_inner_error_);
#line 90 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1048 "GdkSupport.c"
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* err = NULL;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		err = _inner_error_;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_inner_error_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_error_free0 (err);
#line 1062 "GdkSupport.c"
	}
	__finally35:
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (fins);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		buffer = (g_free (buffer), NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp24_ = (g_free (_tmp24_), NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 1081 "GdkSupport.c"
	}
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp53_ = fins;
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp53_ != NULL) {
#line 1087 "GdkSupport.c"
		GFileInputStream* _tmp54_;
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp54_ = fins;
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_object_unref0 (fins);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			buffer = (g_free (buffer), NULL);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp24_ = (g_free (_tmp24_), NULL);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_checksum_free0 (md5_checksum);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_object_unref0 (pixbuf_loader);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			return NULL;
#line 1109 "GdkSupport.c"
		}
	}
#line 97 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp55_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 97 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp55_) {
#line 1116 "GdkSupport.c"
		DetectedPhotoInformation* _tmp56_;
		GChecksum* _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp56_ = self->priv->detected;
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp57_ = md5_checksum;
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp58_ = g_checksum_get_string (_tmp57_);
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp59_ = g_strdup (_tmp58_);
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_free0 (_tmp56_->md5);
#line 98 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp56_->md5 = _tmp59_;
#line 1133 "GdkSupport.c"
	}
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp61_ = self->priv->size_ready;
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (!_tmp61_) {
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp60_ = TRUE;
#line 1141 "GdkSupport.c"
	} else {
		gboolean _tmp62_;
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp62_ = self->priv->area_prepared;
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp60_ = !_tmp62_;
#line 1148 "GdkSupport.c"
	}
#line 101 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_vala_is_corrupted = _tmp60_;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp63_ = self->priv->detected;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp64_ = _detected_photo_information_ref0 (_tmp63_);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp64_;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (fins);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer = (g_free (buffer), NULL);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp24_ = (g_free (_tmp24_), NULL);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_checksum_free0 (md5_checksum);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (pixbuf_loader);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (is_corrupted) {
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		*is_corrupted = _vala_is_corrupted;
#line 1172 "GdkSupport.c"
	}
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 1176 "GdkSupport.c"
}


static void
gdk_sniffer_on_size_prepared (GdkSniffer* self,
                              GdkPixbufLoader* loader,
                              gint width,
                              gint height)
{
	DetectedPhotoInformation* _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (IS_GDK_SNIFFER (self));
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (GDK_IS_PIXBUF_LOADER (loader));
#line 107 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = self->priv->detected;
#line 107 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	dimensions_init (&_tmp0_->image_dim, width, height);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->size_ready = TRUE;
#line 1197 "GdkSupport.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self ? g_object_ref (self) : NULL;
#line 1206 "GdkSupport.c"
}


static void
gdk_sniffer_on_area_prepared (GdkSniffer* self,
                              GdkPixbufLoader* pixbuf_loader)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	GdkPixbuf* _tmp4_;
	DetectedPhotoInformation* _tmp5_;
	GdkPixbuf* _tmp6_;
	DetectedPhotoInformation* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbufFormat* format = NULL;
	GdkPixbufFormat* _tmp9_;
	DetectedPhotoInformation* _tmp10_;
	GdkPixbufFormat* _tmp11_;
	gchar* _tmp12_;
	DetectedPhotoInformation* _tmp13_;
	DetectedPhotoInformation* _tmp14_;
	const gchar* _tmp15_;
#line 111 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (IS_GDK_SNIFFER (self));
#line 111 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (GDK_IS_PIXBUF_LOADER (pixbuf_loader));
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = gdk_pixbuf_loader_get_pixbuf (pixbuf_loader);
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	pixbuf = _tmp1_;
#line 113 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = pixbuf;
#line 113 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp2_ == NULL) {
#line 114 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf);
#line 114 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return;
#line 1250 "GdkSupport.c"
	}
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = self->priv->detected;
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = pixbuf;
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_->colorspace = gdk_pixbuf_get_colorspace (_tmp4_);
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = self->priv->detected;
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = pixbuf;
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_->channels = gdk_pixbuf_get_n_channels (_tmp6_);
#line 118 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = self->priv->detected;
#line 118 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp8_ = pixbuf;
#line 118 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_->bits_per_channel = gdk_pixbuf_get_bits_per_sample (_tmp8_);
#line 120 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp9_ = gdk_pixbuf_loader_get_format (pixbuf_loader);
#line 120 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	format = _tmp9_;
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp10_ = self->priv->detected;
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp11_ = format;
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp12_ = gdk_pixbuf_format_get_name (_tmp11_);
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp10_->format_name);
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp10_->format_name = _tmp12_;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp13_ = self->priv->detected;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp14_ = self->priv->detected;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp15_ = _tmp14_->format_name;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp13_->file_format = photo_file_format_from_pixbuf_name (_tmp15_);
#line 124 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->area_prepared = TRUE;
#line 111 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (pixbuf);
#line 1296 "GdkSupport.c"
}


static void
gdk_sniffer_class_init (GdkSnifferClass * klass)
{
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileSnifferClass *) klass)->finalize = gdk_sniffer_finalize;
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_type_class_add_private (klass, sizeof (GdkSnifferPrivate));
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer *, gboolean*, GError**)) gdk_sniffer_real_sniff;
#line 1311 "GdkSupport.c"
}


static void
gdk_sniffer_instance_init (GdkSniffer * self)
{
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv = GDK_SNIFFER_GET_PRIVATE (self);
#line 29 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->detected = NULL;
#line 30 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->size_ready = FALSE;
#line 31 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->area_prepared = FALSE;
#line 1326 "GdkSupport.c"
}


static void
gdk_sniffer_finalize (PhotoFileSniffer * obj)
{
	GdkSniffer * self;
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GDK_SNIFFER, GdkSniffer);
#line 29 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_detected_photo_information_unref0 (self->priv->detected);
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	PHOTO_FILE_SNIFFER_CLASS (gdk_sniffer_parent_class)->finalize (obj);
#line 1340 "GdkSupport.c"
}


GType
gdk_sniffer_get_type (void)
{
	static volatile gsize gdk_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&gdk_sniffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdkSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkSniffer), 0, (GInstanceInitFunc) gdk_sniffer_instance_init, NULL };
		GType gdk_sniffer_type_id;
		gdk_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "GdkSniffer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gdk_sniffer_type_id__volatile, gdk_sniffer_type_id);
	}
	return gdk_sniffer_type_id__volatile;
}



