/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class MarqueePane
extends JScrollPane {
    private int _scrollDelay = 100;
    private int _stayDelay = 2000;
    private int _scrollAmount = 2;
    private int _scrollDirection = 0;
    private int _stayPosition = -1;
    private Timer _scrollTimer = null;
    private int _scrollTimes;
    private boolean _reachStayPosition = false;
    public static final int SCROLL_DIRECTION_LEFT = 0;
    public static final int SCROLL_DIRECTION_RIGHT = 1;
    public static final int SCROLL_DIRECTION_UP = 2;
    public static final int SCROLL_DIRECTION_DOWN = 3;

    public MarqueePane(Component component) {
        super(component);
        this.startAutoScrolling();
    }

    public MarqueePane() {
        this.startAutoScrolling();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        this.setWheelScrollingEnabled(false);
    }

    public int getScrollDelay() {
        return this._scrollDelay;
    }

    public void setScrollDelay(int n) {
        this._scrollDelay = n;
    }

    public int getScrollAmount() {
        return this._scrollAmount;
    }

    public void setScrollAmount(int n) {
        this._scrollAmount = n;
    }

    public int getScrollDirection() {
        return this._scrollDirection;
    }

    public void setScrollDirection(int n) {
        this._scrollDirection = n;
    }

    public int getStayDelay() {
        return this._stayDelay;
    }

    public void setStayDelay(int n) {
        this._stayDelay = n;
    }

    public void stopAutoScrolling() {
        if (this._scrollTimer != null) {
            if (this._scrollTimer.isRunning()) {
                this._scrollTimer.stop();
            }
            this._scrollTimer = null;
        }
    }

    public void startAutoScrolling() {
        this.stopAutoScrolling();
        this._scrollTimer = new Timer(this.getScrollDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BoundedRangeModel boundedRangeModel = MarqueePane.this.getScrollDirection() == 0 || MarqueePane.this.getScrollDirection() == 1 ? MarqueePane.this.getHorizontalScrollBar().getModel() : MarqueePane.this.getVerticalScrollBar().getModel();
                int n = boundedRangeModel.getValue();
                if (MarqueePane.this.getScrollDirection() == 0 || MarqueePane.this.getScrollDirection() == 2) {
                    if (n + boundedRangeModel.getExtent() == boundedRangeModel.getMaximum()) {
                        boundedRangeModel.setValue(boundedRangeModel.getMinimum());
                        MarqueePane.this._scrollTimes = 0;
                    } else if (n + MarqueePane.this.getScrollAmount() + boundedRangeModel.getExtent() > boundedRangeModel.getMaximum()) {
                        boundedRangeModel.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                    } else {
                        boundedRangeModel.setValue(n + MarqueePane.this.getScrollAmount());
                        MarqueePane.this._scrollTimes++;
                    }
                    MarqueePane.this._reachStayPosition = boundedRangeModel.getValue() == boundedRangeModel.getMinimum();
                } else {
                    if (n == boundedRangeModel.getMinimum()) {
                        int n2 = boundedRangeModel.getMaximum();
                        int n3 = boundedRangeModel.getExtent();
                        boundedRangeModel.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                        if (n2 != boundedRangeModel.getMaximum() || n3 != boundedRangeModel.getExtent()) {
                            boundedRangeModel.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                        }
                        MarqueePane.this._scrollTimes = 0;
                    } else if (n - MarqueePane.this.getScrollAmount() < boundedRangeModel.getMinimum()) {
                        boundedRangeModel.setValue(boundedRangeModel.getMinimum());
                    } else {
                        boundedRangeModel.setValue(n - MarqueePane.this.getScrollAmount());
                        MarqueePane.this._scrollTimes++;
                    }
                    MarqueePane.this._reachStayPosition = boundedRangeModel.getValue() == boundedRangeModel.getMinimum() || boundedRangeModel.getValue() == boundedRangeModel.getMaximum();
                }
                if (!MarqueePane.this._reachStayPosition && MarqueePane.this.getStayPosition() >= 0 && MarqueePane.this._scrollTimes % MarqueePane.this.getStayPosition() == 0) {
                    MarqueePane.this._reachStayPosition = true;
                }
                if (MarqueePane.this._scrollTimer != null) {
                    MarqueePane.this._scrollTimer.setDelay(MarqueePane.this._reachStayPosition ? MarqueePane.this.getStayDelay() : MarqueePane.this.getScrollDelay());
                }
            }
        });
        this._scrollTimer.start();
    }

    public int getStayPosition() {
        return this._stayPosition;
    }

    public void setStayPosition(int n) {
        this._stayPosition = n;
    }
}

