/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UUIDBox
extends JP2Box {
    public UUIDBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        Property[] propertyArray = new Property[2];
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        if (this._boxHeader.getLength() != 0L && n < 16) {
            this.wrongBoxSize();
            return false;
        }
        byte[] byArray = new byte[16];
        ModuleBase.readByteBuf(this._dstrm, byArray, this._module);
        propertyArray[0] = new Property("UUID", PropertyType.BYTE, PropertyArity.ARRAY, byArray);
        int n2 = n - 16;
        if (n2 > 0) {
            byte[] byArray2 = new byte[n2];
            ModuleBase.readByteBuf(this._dstrm, byArray2, this._module);
            propertyArray[1] = new Property("Data", PropertyType.BYTE, PropertyArity.ARRAY, byArray2);
        } else {
            propertyArray[1] = new Property("Data", PropertyType.BOOLEAN, Boolean.FALSE);
        }
        this._module.addUUID(new Property("UUIDBox", PropertyType.PROPERTY, PropertyArity.ARRAY, propertyArray));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "UUID Box";
    }
}

