/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class PageLabelNode {
    protected PdfModule _module;
    protected PageLabelNode _parent;
    protected PdfDictionary _dict;
    protected boolean _walkFinished;
    private List _descendants;
    private Iterator _descendantsIter;
    private int _currentKey;
    private PdfObject _currentValue;
    private int _prevKey;
    private PdfObject _prevValue;
    private int _currentNumsIndex;
    private int _currentNumsLength;
    private Vector _currentNumsVec;
    private PageLabelNode _currentDescendant;
    private PageLabelNode _currentLeaf;

    public PageLabelNode(PdfModule pdfModule, PageLabelNode pageLabelNode, PdfDictionary pdfDictionary) {
        this._module = pdfModule;
        this._parent = pageLabelNode;
        this._dict = pdfDictionary;
    }

    public void buildSubtree() throws PdfException {
        PdfArray pdfArray = null;
        try {
            pdfArray = (PdfArray)this._dict.get("Kids");
            if (pdfArray != null) {
                Vector vector = pdfArray.getContent();
                this._descendants = new ArrayList(vector.size());
                for (int i = 0; i < vector.size(); ++i) {
                    PdfDictionary pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)vector.elementAt(i));
                    PageLabelNode pageLabelNode = new PageLabelNode(this._module, this, pdfDictionary);
                    pageLabelNode.buildSubtree();
                    this._descendants.add(pageLabelNode);
                }
            } else {
                this._descendants = null;
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid page label node");
        }
    }

    public void startWalk() {
        if (this._descendants != null) {
            this._descendantsIter = this._descendants.listIterator();
            this._walkFinished = false;
        } else {
            this._descendantsIter = null;
            this._walkFinished = true;
        }
        this._currentDescendant = null;
        this._currentLeaf = null;
        this._currentKey = -1;
        this._currentValue = null;
        this._prevKey = -1;
        this._prevValue = null;
    }

    public PageLabelNode nextLeafObject() {
        PageLabelNode pageLabelNode;
        if (this._walkFinished) {
            return null;
        }
        if (this._currentDescendant == null) {
            if (this._descendantsIter == null) {
                this._walkFinished = true;
                return this;
            }
            this._currentDescendant = (PageLabelNode)this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((pageLabelNode = this._currentDescendant.nextLeafObject()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = (PageLabelNode)this._descendantsIter.next();
                this._currentDescendant.startWalk();
                return this._currentDescendant.nextLeafObject();
            }
            this._walkFinished = true;
            return null;
        }
        return pageLabelNode;
    }

    public boolean findNextKeyValue() throws PdfException {
        try {
            PdfObject pdfObject;
            if (this._currentLeaf == null || this._currentNumsIndex >= this._currentNumsLength) {
                this._currentLeaf = this.nextLeafObject();
                if (this._currentLeaf == null) {
                    this._prevKey = this._currentKey;
                    this._prevValue = this._currentValue;
                    this._currentKey = Integer.MAX_VALUE;
                    return false;
                }
                this._currentNumsIndex = 0;
                pdfObject = (PdfArray)this._module.resolveIndirectObject(this._currentLeaf._dict.get("Nums"));
                if (pdfObject == null) {
                    throw new PdfInvalidException("Missing expected element in page number dictionary");
                }
                this._currentNumsVec = ((PdfArray)pdfObject).getContent();
                this._currentNumsLength = this._currentNumsVec.size();
            }
            pdfObject = (PdfSimpleObject)this._currentNumsVec.elementAt(this._currentNumsIndex);
            this._prevKey = this._currentKey;
            this._prevValue = this._currentValue;
            this._currentKey = ((PdfSimpleObject)pdfObject).getIntValue();
            this._currentValue = (PdfObject)this._currentNumsVec.elementAt(this._currentNumsIndex + 1);
            this._currentNumsIndex += 2;
            return true;
        }
        catch (PdfInvalidException pdfInvalidException) {
            throw pdfInvalidException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PdfInvalidException("Invalid date in page number tree");
        }
    }

    public int getCurrentKey() {
        return this._currentKey;
    }

    public PdfObject _getCurrentValue() {
        return this._currentValue;
    }

    public int getPrevKey() {
        return this._prevKey;
    }

    public PdfObject getPrevValue() {
        return this._prevValue;
    }

    public static String intToRoman(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 1000) {
            stringBuffer.append("M");
            n -= 1000;
        }
        if (n >= 900) {
            stringBuffer.append("CM");
            n -= 900;
        }
        if (n >= 500) {
            stringBuffer.append("D");
            while (n >= 600) {
                stringBuffer.append("C");
                n -= 100;
            }
            n -= 500;
        }
        if (n >= 400) {
            stringBuffer.append("CD");
            n -= 400;
        }
        while (n >= 100) {
            stringBuffer.append("C");
            n -= 100;
        }
        if (n >= 90) {
            stringBuffer.append("XC");
            n -= 90;
        }
        if (n >= 50) {
            stringBuffer.append("L");
            while (n >= 60) {
                stringBuffer.append("X");
                n -= 10;
            }
            n -= 50;
        }
        if (n >= 40) {
            stringBuffer.append("XL");
            n -= 40;
        }
        while (n >= 10) {
            stringBuffer.append("X");
            n -= 10;
        }
        switch (n) {
            case 1: {
                stringBuffer.append("I");
                break;
            }
            case 2: {
                stringBuffer.append("II");
                break;
            }
            case 3: {
                stringBuffer.append("III");
                break;
            }
            case 4: {
                stringBuffer.append("IV");
                break;
            }
            case 5: {
                stringBuffer.append("V");
                break;
            }
            case 6: {
                stringBuffer.append("VI");
                break;
            }
            case 7: {
                stringBuffer.append("VII");
                break;
            }
            case 8: {
                stringBuffer.append("VIII");
                break;
            }
            case 9: {
                stringBuffer.append("IX");
            }
        }
        String string = stringBuffer.toString();
        if (bl) {
            return string;
        }
        return string.toLowerCase();
    }

    public static String intToBase26(int n, boolean bl) {
        int n2 = (n - 1) / 26 + 1;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = bl ? 65 + (n - 1) % 26 : 97 + (n - 1) % 26;
        while (--n2 >= 0) {
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }
}

