/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.StdStructTypes;
import edu.harvard.hul.ois.jhove.module.pdf.StructureTree;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class StructureElement {
    private StructureTree _tree;
    private PdfDictionary _dict;
    private PdfModule _module;
    private List children;
    private String _structType;
    private boolean _structIsInline;
    private boolean _attrIsBlock;
    private static final String[] blockLevelAttrs = new String[]{"SpaceBefore", "SpaceAfter", "StartIndent", "EndIndent", "TextIndent", "TextAlign", "BBox", "Width", "Height", "BlockAlign", "InlineAlign"};

    public StructureElement(PdfDictionary pdfDictionary, StructureTree structureTree) throws PdfException {
        this._tree = structureTree;
        this._dict = pdfDictionary;
        this._module = structureTree.getModule();
        this._structType = null;
        try {
            PdfObject pdfObject = this._module.resolveIndirectObject(pdfDictionary.get("S"));
            Token token = ((PdfSimpleObject)pdfObject).getToken();
            String string = ((Name)token).getValue();
            string = this._tree.dereferenceStructType(string);
            if (StdStructTypes.includes(string)) {
                this._structType = string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void buildSubtree() throws PdfException {
        PdfObject pdfObject = null;
        try {
            pdfObject = this._module.resolveIndirectObject(this._dict.get("K"));
        }
        catch (IOException iOException) {
            throw new PdfInvalidException("Invalid data in document structure tree");
        }
        this.children = null;
        if (pdfObject instanceof PdfSimpleObject) {
            return;
        }
        if (pdfObject instanceof PdfDictionary) {
            PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
            if (this.isStructElem(pdfDictionary)) {
                StructureElement structureElement = new StructureElement(pdfDictionary, this._tree);
                structureElement.buildSubtree();
                structureElement.checkAttributes();
                this.children = new ArrayList(1);
                this.children.add(structureElement);
            } else if (!this.isMarkedContent(pdfDictionary) && !this.isObjectRef(pdfDictionary)) {
                throw new PdfInvalidException("Unknown element in structure tree");
            }
        } else if (pdfObject instanceof PdfArray) {
            Vector vector = ((PdfArray)pdfObject).getContent();
            this.children = new LinkedList();
            for (int i = 0; i < vector.size(); ++i) {
                PdfDictionary pdfDictionary;
                PdfObject pdfObject2 = (PdfObject)vector.elementAt(i);
                try {
                    pdfObject2 = this._module.resolveIndirectObject(pdfObject2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!(pdfObject2 instanceof PdfDictionary) || !this.isStructElem(pdfDictionary = (PdfDictionary)pdfObject2)) continue;
                StructureElement structureElement = new StructureElement(pdfDictionary, this._tree);
                structureElement.buildSubtree();
                structureElement.checkAttributes();
                this.children.add(structureElement);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void checkAttributes() throws PdfException {
        PdfObject pdfObject;
        this._attrIsBlock = false;
        this._structIsInline = !this._structType.equals("Figure") && !this._structType.equals("TH") && !this._structType.equals("TD") && !this._structType.equals("TR") && !StdStructTypes.isBlockLevel(this._structType);
        try {
            pdfObject = this._module.resolveIndirectObject(this._dict.get("A"));
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid structure attribute reference");
        }
        if (pdfObject == null) {
            return;
        }
        if (pdfObject instanceof PdfArray) {
            Vector vector = ((PdfArray)pdfObject).getContent();
            for (int i = 0; i < vector.size(); ++i) {
                PdfObject pdfObject2;
                try {
                    pdfObject2 = this._module.resolveIndirectObject((PdfObject)vector.elementAt(i));
                }
                catch (IOException iOException) {
                    throw new PdfInvalidException("Invalid structure attribute");
                }
                if (pdfObject2 instanceof PdfDictionary) {
                    this.checkAttribute((PdfDictionary)pdfObject2);
                    continue;
                }
                if (pdfObject2 instanceof PdfSimpleObject) {
                    try {
                        Numeric numeric = (Numeric)((PdfSimpleObject)pdfObject2).getToken();
                        continue;
                    }
                    catch (Exception exception) {
                        throw new PdfInvalidException("Invalid structure attribute");
                    }
                }
                throw new PdfInvalidException("Invalid structure attribute");
            }
        } else if (pdfObject instanceof PdfDictionary) {
            this.checkAttribute((PdfDictionary)pdfObject);
        } else {
            throw new PdfInvalidException("Structure attribute has illegal type");
        }
        if (this._structIsInline && this._attrIsBlock) {
            throw new PdfInvalidException("Block-level attributes in inline structure element");
        }
    }

    private void checkAttribute(PdfDictionary pdfDictionary) throws PdfException {
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("O");
            Name name = (Name)pdfSimpleObject.getToken();
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)pdfDictionary.get("Placement");
            if (pdfSimpleObject2 != null && !"Inline".equals(pdfSimpleObject2.getStringValue())) {
                this._structIsInline = false;
            }
            if (this.attrIsBlockLevel(pdfDictionary)) {
                this._attrIsBlock = true;
            }
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid attribute in document structure");
        }
    }

    private boolean isStructElem(PdfDictionary pdfDictionary) throws PdfException {
        try {
            String string;
            PdfObject pdfObject = pdfDictionary.get("Type");
            if (pdfObject != null && !"StructElem".equals(((PdfSimpleObject)pdfObject).getStringValue())) {
                return false;
            }
            PdfObject pdfObject2 = this._module.resolveIndirectObject(pdfDictionary.get("S"));
            if (!(pdfObject2 instanceof PdfSimpleObject)) {
                return false;
            }
            Token token = ((PdfSimpleObject)pdfObject2).getToken();
            if (!(token instanceof Name)) {
                return false;
            }
            boolean bl = false;
            String string2 = ((Name)token).getValue();
            if (!StdStructTypes.includes(string2 = this._tree.dereferenceStructType(string2)) && bl) {
                throw new PdfInvalidException("Non-standard structure type name");
            }
            PdfObject pdfObject3 = pdfDictionary.get("P");
            if (!(pdfObject3 instanceof PdfIndirectObj)) {
                return false;
            }
            PdfDictionary pdfDictionary2 = (PdfDictionary)this._module.resolveIndirectObject(pdfObject3);
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary2.get("Type");
            return pdfSimpleObject == null || "StructTreeRoot".equals(string = pdfSimpleObject.getStringValue()) || "StructElem".equals(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean attrIsBlockLevel(PdfDictionary pdfDictionary) {
        for (int i = 0; i < blockLevelAttrs.length; ++i) {
            if (pdfDictionary.get(blockLevelAttrs[i]) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isMarkedContent(PdfDictionary pdfDictionary) {
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Type");
            if (!pdfSimpleObject.getStringValue().equals("MCR")) {
                return false;
            }
            PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)this._module.resolveIndirectObject(pdfDictionary.get("MCID"));
            return pdfSimpleObject2 != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isObjectRef(PdfDictionary pdfDictionary) {
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Type");
            if (!pdfSimpleObject.getStringValue().equals("OBJR")) {
                return false;
            }
            PdfObject pdfObject = this._module.resolveIndirectObject(pdfDictionary.get("Obj"));
            return pdfObject != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

