#include "iso6937tables.h"

// conversion tables from iso/iec 6937 to unicode for single byte characters
// double byte chracters are marked as 0xFFFF for further processing

const iso6937table iso6937table_base
{
    0x00, 0x01, 0x02, 0x03,   0x04, 0x05, 0x06, 0x07,       // iso 0x00-0x07
    0x08, 0x09, 0x0A, 0x0B,   0x0C, 0x0D, 0x0E, 0x0F,       // iso 0x08-0x0F
    0x10, 0x11, 0x12, 0x13,   0x14, 0x15, 0x16, 0x17,       // iso 0x10-0x17
    0x18, 0x19, 0x1A, 0x1B,   0x1C, 0x1D, 0x1E, 0x1F,       // iso 0x18-0x1F
    0x20, 0x21, 0x22, 0x23,   0x24, 0x25, 0x26, 0x27,       // iso 0x20-0x27
    0x28, 0x29, 0x2A, 0x2B,   0x2C, 0x2D, 0x2E, 0x2F,       // iso 0x28-0x2F
    0x30, 0x31, 0x32, 0x33,   0x34, 0x35, 0x36, 0x37,       // iso 0x30-0x37
    0x38, 0x39, 0x3A, 0x3B,   0x3C, 0x3D, 0x3E, 0x3F,       // iso 0x38-0x3F
    0x40, 0x41, 0x42, 0x43,   0x44, 0x45, 0x46, 0x47,       // iso 0x40-0x47
    0x48, 0x49, 0x4A, 0x4B,   0x4C, 0x4D, 0x4E, 0x4F,       // iso 0x48-0x4F
    0x50, 0x51, 0x52, 0x53,   0x54, 0x55, 0x56, 0x57,       // iso 0x50-0x57
    0x58, 0x59, 0x5A, 0x5B,   0x5C, 0x5D, 0x5E, 0x5F,       // iso 0x58-0x5F
    0x60, 0x61, 0x62, 0x63,   0x64, 0x65, 0x66, 0x67,       // iso 0x60-0x67
    0x68, 0x69, 0x6A, 0x6B,   0x6C, 0x6D, 0x6E, 0x6F,       // iso 0x68-0x6F
    0x70, 0x71, 0x72, 0x73,   0x74, 0x75, 0x76, 0x77,       // iso 0x70-0x77
    0x78, 0x79, 0x7A, 0x7B,   0x7C, 0x7D, 0x7E, 0x7F,       // iso 0x78-0x7F
    0x80, 0x81, 0x82, 0x83,   0x84, 0x85, 0x86, 0x87,       // iso 0x80-0x87
    0x88, 0x89, 0x8A, 0x8B,   0x8C, 0x8D, 0x8E, 0x8F,       // iso 0x88-0x8F
    0x90, 0x91, 0x92, 0x93,   0x94, 0x95, 0x96, 0x97,       // iso 0x90-0x97
    0x98, 0x99, 0x9A, 0x9B,   0x9C, 0x9D, 0x9E, 0x9F,       // iso 0x98-0x9F
    0xA0, 0xA1, 0xA2, 0xA3,                                 // iso 0xA0-0xA3
    0xA4, // warning - this character is not in iso 6937 table
    0xA5, // iso 0xA5
    0xA6, // warning - this character is not in iso 6937 table
    0xA7,                                                   // iso 0xA0-0xA7
    0xA4, 0x2018, 0x201C, 0xAB, 0x2190, 0x2191, 0x2192, 0x2193,// iso 0xA8-0xAF
    0xB0, 0xB1, 0xB2, 0xB3,   0xD7, 0xB5, 0xB6, 0xB7,       // iso 0xB0-0xB7
    0xF7, 0x2019,0x201D,0xBB, 0xBC, 0xBD, 0xBE, 0xBF,       // iso 0xB8-0xBF
    0xC0,// warning - should be accent marker, but no table available
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, // accents C1-C7
    0xFFFF, // accents C8
    0xC9, // warning - should be accent marker, but no table available
    0xFFFF, 0xFFFF,// accents CA-CB
    0xCC, // warning - should be accent marker, but no table available
    0xFFFF, 0xFFFF, 0xFFFF,// accents CD-CF
    0x2014, 0xB9, 0xAE, 0xA9, 0x2122, 0x266A, 0xAC, 0xA6,   // iso 0xD0-0xD7
    0xD8, // warning - this character is not in iso 6937 table
    0xD9, // warning - this character is not in iso 6937 table
    0xDA, // warning - this character is not in iso 6937 table
    0xDB, // warning - this character is not in iso 6937 table
    0x215B, 0x215C, 0x215D, 0x215E,                         // iso 0xDC-0xDF
    0x2126, 0xC6, 0xD0, 0xAA, 0x126,                        // iso 0xE0-0xE4
    0xE5, // warning - this character is not in iso 6937 table
    0x132, 0x013F,                                          // iso 0xE6-0xE7
    0x141, 0xD8, 0x152, 0xBA, 0xDE,  0x166, 0x014A, 0x149,  // iso 0xE8-0xEF
    0x138, 0xE6, 0x111, 0xF0, 0x127, 0x131, 0x133,  0x140,  // iso 0xF0-0xF7
    0x142, 0xF8, 0x153, 0xDF, 0xFE,  0x167, 0x014B, 0xAD,   // iso 0xF8-0xFF
};

//
// Double byte character tables...
//

// note: all characters marked as 0xFFFF are not in iso/iec 6937 encoding
// they will be processed in the next step as character without any accent

const iso6937table iso6937table_C1
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC0 /*iso C141*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xC8 /*iso C145*/, 0xFFFF, 0xFFFF,              // iso 0x40-0x47
    0xFFFF, 0xCC /*iso C149*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x00D2 /*iso C14F*/,            // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xD9 /*iso C155*/, 0xFFFF, 0xFFFF,              // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE0 /*iso C161*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xE8 /*iso C165*/, 0xFFFF, 0xFFFF,              // iso 0x60-0x67
    0xFFFF, 0xEC /*iso C169*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x00F2 /*iso C16F*/,            // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x00F9 /*iso C175*/, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C2
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xB4 /*iso C220*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC1 /*iso C241*/, 0xFFFF, 0x106 /*iso C243*/,
    0xFFFF, 0xC9 /*iso C245*/, 0xFFFF, 0xFFFF,              // iso 0x40-0x47
    0xFFFF, 0xCD /*iso C249*/, 0xFFFF, 0xFFFF,
    0x139 /*iso C24C*/, 0xFFFF,
    0x143 /*iso C24E*/, 0xD3 /*iso C24F*/,                  // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0x154 /*iso C252*/, 0x015A /*iso C253*/,
    0xFFFF, 0xDA /*iso C255*/, 0xFFFF, 0xFFFF,              // iso 0x50-0x57
    0xFFFF, 0xDD /*iso C259*/, 0x179 /*iso C25A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE1 /*iso C261*/, 0xFFFF, 0x107 /*iso C263*/,
    0xFFFF, 0xE9 /*iso C265*/, 0xFFFF, 0xFFFF,              // iso 0x60-0x67
    0xFFFF, 0xED /*iso C269*/, 0xFFFF, 0xFFFF,
    0x013A /*iso C26C*/, 0xFFFF,
    0x144 /*iso C26E*/, 0xF3 /*iso C26F*/,                  // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0x155 /*iso C272*/, 0x015B /*iso C273*/,
    0xFFFF, 0xFA /*iso C275*/, 0xFFFF, 0xFFFF,              // iso 0x70-0x77
    0xFFFF, 0xFD /*iso C279*/, 0x017A /*iso C27A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C3
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC2 /*iso C341*/, 0xFFFF, 0x108 /*iso C343*/,
    0xFFFF, 0xCA /*iso C345*/, 0xFFFF, 0x011C /*iso C347*/, // iso 0x40-0x47
    0x124 /*iso C348*/, 0xCE /*iso C349*/, 0x134 /*iso C34A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xD4 /*iso C34F*/,              // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0x015C /*iso C353*/,
    0xFFFF, 0xDB /*iso C355*/, 0xFFFF, 0x174 /*iso C357*/,  // iso 0x50-0x57
    0xFFFF, 0x176 /*iso C359*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE2 /*iso C361*/, 0xFFFF, 0x109 /*iso C363*/,
    0xFFFF, 0xEA /*iso C365*/, 0xFFFF, 0x011D /*iso C367*/, // iso 0x60-0x67
    0x125 /*iso C368*/, 0xEE /*iso C369*/, 0x135 /*iso C36A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xF4 /*iso C36F*/,              // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0x015D /*iso C373*/,
    0xFFFF, 0xFB /*iso C375*/, 0xFFFF, 0x175 /*iso C377*/,  // iso 0x70-0x77
    0xFFFF, 0x177 /*iso C379*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C4
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC3 /*iso C441*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x40-0x47
    0xFFFF, 0x128 /*iso C449*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xD1 /*iso C44E*/, 0xD5 /*iso C44F*/,   // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x168 /*iso C455*/, 0xFFFF, 0xFFFF,             // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE3 /*iso C461*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x60-0x67
    0xFFFF, 0x129 /*iso C469*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xF1 /*iso C46E*/, 0xF5 /*iso C46F*/,   // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x169 /*iso C475*/, 0xFFFF, 0xFFFF,             // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C5
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xAF /*iso C520*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0x0100 /*iso C541*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0112 /*iso C545*/, 0xFFFF, 0xFFFF,            // iso 0x40-0x47
    0xFFFF, 0x012A /*iso C549*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x014C /*iso C54F*/,            // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016A /*iso C555*/, 0xFFFF, 0xFFFF,            // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0x0101 /*iso C561*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0113 /*iso C565*/, 0xFFFF, 0xFFFF,            // iso 0x60-0x67
    0xFFFF, 0x012B /*iso C569*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x014D /*iso C56F*/,            // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016B /*iso C575*/, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C6
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02D8 /*iso C620*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0x102 /*iso C641*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x011E /*iso C647*/,            // iso 0x40-0x47
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016C /*iso C655*/, 0xFFFF, 0xFFFF,            // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0x103 /*iso C661*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x011F /*iso C667*/,            // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016D /*iso C675*/, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C7
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02D9 /*iso C720*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xFFFF, 0xFFFF, 0x010A /*iso C743*/,
    0xFFFF, 0x116 /*iso C745*/, 0xFFFF, 0x120 /*iso C747*/, // iso 0x40-0x47
    0xFFFF, 0x130 /*iso C749*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0x017B /*iso C75A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xFFFF, 0xFFFF, 0x010B /*iso C763*/,
    0xFFFF, 0x117 /*iso C765*/, 0xFFFF, 0x121 /*iso C767*/, // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0x017C /*iso C77A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_C8
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xA8 /*iso C820*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC4 /*iso C841*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xCB /*iso C845*/, 0xFFFF, 0xFFFF,              // iso 0x40-0x47
    0xFFFF, 0xCF /*iso C849*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xD6 /*iso C84F*/,              // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xDC /*iso C855*/, 0xFFFF, 0xFFFF,              // iso 0x50-0x57
    0xFFFF, 0x178 /*iso C859*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE4 /*iso C861*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xEB /*iso C865*/, 0xFFFF, 0xFFFF,              // iso 0x60-0x67
    0xFFFF, 0xEF /*iso C869*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xF6 /*iso C86F*/,              // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFC /*iso C875*/, 0xFFFF, 0xFFFF,              // iso 0x70-0x77
    0xFFFF, 0xFF /*iso C879*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_CA
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02DA /*iso CA20*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xC5 /*iso CA41*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x40-0x47
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016E /*iso CA55*/, 0xFFFF, 0xFFFF,            // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xE5 /*iso CA61*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x016F /*iso CA75*/, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_CB
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x0-0x7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x8-0xF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xB8 /*iso CB20*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                 // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xFFFF, 0xFFFF, 0xC7 /*iso CB43*/,
    0xFFFF, 0xFFFF, 0xFFFF, 0x122 /*iso CB47*/,             // iso 0x40-0x47
    0xFFFF, 0xFFFF, 0xFFFF, 0x136 /*iso CB4B*/,
    0x013B /*iso CB4C*/, 0xFFFF, 0x145 /*iso CB4E*/, 0xFFFF,// iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0x156 /*iso CB52*/, 0x015E /*iso CB53*/,
    0x162 /*iso CB54*/, 0xFFFF, 0xFFFF, 0xFFFF,             // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xFFFF, 0xFFFF, 0xE7 /*iso CB63*/,
    0xFFFF, 0xFFFF, 0xFFFF, 0x123 /*iso CB67*/,             // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0x137 /*iso CB6B*/,
    0x013C /*iso CB6C*/, 0xFFFF, 0x146 /*iso CB6E*/, 0xFFFF,// iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0x157 /*iso CB72*/, 0x015F /*iso CB73*/,
    0x163 /*iso CB74*/, 0xFFFF, 0xFFFF, 0xFFFF,             // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_CD
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x00-0x07
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x08-0x0F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02DD /*iso CD20*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x40-0x47
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x150 /*iso CD4F*/,             // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x170 /*iso CD55*/, 0xFFFF, 0xFFFF,             // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0x0151 /*iso CD6F*/,            // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x171 /*iso CD75*/, 0xFFFF, 0xFFFF,             // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_CE
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x0-0x7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x8-0xF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02DB /*iso CE20*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0x0104 /*iso CE41*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0118 /*iso CE45*/, 0xFFFF, 0xFFFF,            // iso 0x40-0x47
    0xFFFF, 0x012E /*iso CE49*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0172 /*iso CE55*/, 0xFFFF, 0xFFFF,            // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0x0105 /*iso CE61*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0119 /*iso CE65*/, 0xFFFF, 0xFFFF,            // iso 0x60-0x67
    0xFFFF, 0x012F /*iso CE69*/, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0x0173 /*iso CE75*/, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_CF
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x0-0x7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x8-0xF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0x02C7 /*iso CF20*/, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xFFFF, 0xFFFF, 0x010C /*iso CF43*/,
    0x010E /*iso CF44*/, 0x011A /*iso CF45*/,
    0xFFFF,              0xFFFF,                            // iso 0x40-0x47
    0xFFFF,              0xFFFF,
    0xFFFF,              0xFFFF,
    0x013D /*iso CF4C*/, 0xFFFF,
    0x0147 /*iso CF4E*/, 0xFFFF,                            // iso 0x48-0x4F
    0xFFFF,              0xFFFF,
    0x0158 /*iso CF52*/, 0x0160 /*iso CF53*/,
    0x0164 /*iso CF54*/, 0xFFFF, 0xFFFF, 0xFFFF,            // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0x017D /*iso CF5A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF,              0xFFFF,
    0xFFFF,              0x010D /*iso CF63*/,
    0x010F /*iso CF64*/, 0x011B /*iso CF65*/,
    0xFFFF,              0xFFFF,                            // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0x013E /*iso CF6C*/, 0xFFFF, 0x148 /*iso CF6E*/, 0xFFFF,// iso 0x68-0x6F
    0xFFFF,              0xFFFF,
    0x0159 /*iso CF72*/, 0x0161 /*iso CF73*/,
    0x0165 /*iso CF74*/, 0xFFFF, 0xFFFF, 0xFFFF,            // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0x017E /*iso CF7A*/, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

const iso6937table iso6937table_dummy
{
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x0-0x7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x8-0xF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x10-0x17
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x18-0x1F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x20-0x27
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x28-0x2F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x30-0x37
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x38-0x3F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x40-0x47
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x48-0x4F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x50-0x57
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x58-0x5F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x60-0x67
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x68-0x6F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x70-0x77
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x78-0x7F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x80-0x87
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x88-0x8F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x90-0x97
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0x98-0x9F
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA0-0xA7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xA8-0xAF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB0-0xB7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xB8-0xBF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC0-0xC7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xC8-0xCF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD0-0xD7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xD8-0xDF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE0-0xE7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xE8-0xEF
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF0-0xF7
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,                         // iso 0xF8-0xFF
};

static const iso6937table* d = &iso6937table_dummy;
const std::array<const iso6937table *,256> iso6937table_secondary
{
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x00-0x0F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x10-0x1F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x20-0x2F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x30-0x3F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x40-0x4F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x50-0x5F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x60-0x6F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x70-0x7F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x80-0x8F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0x90-0x9F
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0xA0-0xAF
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0xB0-0xDF
    d,                  &iso6937table_C1,
    &iso6937table_C2,   &iso6937table_C3,
    &iso6937table_C4,   &iso6937table_C5,
    &iso6937table_C6,   &iso6937table_C7,

    &iso6937table_C8,   d,
    &iso6937table_CA,   &iso6937table_CB,
    d,                  &iso6937table_CD,
    &iso6937table_CE,   &iso6937table_CF,                  // 0xC0-0xCF
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0xD0-0xDF
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0xE0-0xEF
    d, d, d, d, d, d, d, d,   d, d, d, d, d, d, d, d,      // 0xF0-0xFF
};
