#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# VirtuaVerse
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220330.3

# Set game-specific variables

GAME_ID='virtuaverse'
GAME_NAME='VirtuaVerse'

ARCHIVE_BASE_1='virtuaverse_1_35_53585.sh'
ARCHIVE_BASE_1_MD5='5285b1fb4793e2c87d39f567eceabe71'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='1800000'
ARCHIVE_BASE_1_VERSION='1.35-gog53585'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/virtuaverse'

ARCHIVE_BASE_0='virtuaverse_1_34_51687.sh'
ARCHIVE_BASE_0_MD5='0592cc967de9f333344f2d69c7665173'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1800000'
ARCHIVE_BASE_0_VERSION='1.34-gog51687'

UNITY3D_NAME='VirtuaVerse'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/MonoBleedingEdge
${UNITY3D_NAME}_Data/Plugins
UnityPlayer.so"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
