!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_inwffil
!! NAME
!! wvl_inwffil
!!
!! FUNCTION
!! This method initialises wavefunctions either from disk or from scratch. When
!! initialised from scratch, the wavefunctions are orthonormalised with the
!! Loewedin algorithm.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  ireadwf=1 for reading from file, 0 otherwise.
!!  mpi_enreg=informations about MPI parallelization
!!  option=1 for reading a file following ABINIT format, -1 for a BigDFT format.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  wff <type(wffile_type)>= structure with informations on wf file.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_wfsinp(dtset, hdr, ireadwf, mpi_enreg, option, psps, rprimd, wff, wfs, xred)

  use defs_basis
  use defs_datatypes
#if defined HAVE_BIGDFT
  use libbigdft
#endif

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_12geometry
 use interfaces_13io_mpi
#endif
!End of the abilint section

  implicit none

!Arguments -------------------------------
  !scalars
  integer, intent(in)                       :: ireadwf, option
  type(dataset_type), intent(in)            :: dtset
  type(hdr_type), intent(in)                :: hdr
  type(MPI_type), intent(in)                :: mpi_enreg
  type(pseudopotential_type),intent(in)     :: psps
  type(wffile_type), intent(in)             :: wff
  type(wvl_wf_type), intent(inout)          :: wfs
  !arrays
  real(dp), intent(in)                      :: rprimd(3, 3)
  real(dp), intent(inout)                   :: xred(3, dtset%natom)

!Local variables-------------------------------
  character(len = 500)  :: message
  logical               :: parallel
  integer               :: i, iorb
  real(dp)              :: cprec, eks, radcov, atomMass
  real(dp), allocatable :: xcart(:,:), rhopot(:), pot_ion(:)
  integer, parameter    :: ngx = 31
  integer, parameter    :: npsp = 15
	real(dp)              :: xp(ngx, npsp), psiat(ngx, 3, npsp), occupat(3, npsp), psiatn(ngx)
	integer               :: ng(npsp), ns(npsp), np(npsp)
	character(len = 20)   :: pspatomnames(npsp), atomnames(100)
	character(len = 2)    :: atomSymbol

#if defined HAVE_BIGDFT
  write(message, '(a,a)' ) ch10,&
    &  ' wvl_wfsinp : wavefunction initialisation.'
  call wrtout(6,message,'COLL')

  if (ireadwf == 1) then
    call wvl_rwwf(dtset, mpi_enreg, option, rprimd, wff, wfs, xred)

#if defined MPI
    call transallwaves(mpi_enreg%me, mpi_enreg%nproc, dtset%mband, &
                     & wfs%mbandp, wfs%keys%nvctr(0), wfs%keys%nvctr(1), &
                     & wfs%mvctrp, wfs%psi, wfs%psit)
    call loewe_p(mpi_enreg%me, mpi_enreg%nproc, dtset%mband, &
               & wfs%mbandp, wfs%mvctrp, wfs%psit)
    call checkortho_p(mpi_enreg%me, mpi_enreg%nproc, dtset%mband, &
                    & wfs%mbandp, wfs%mvctrp, wfs%psit)
    call untransallwaves(mpi_enreg%me, mpi_enreg%nproc, dtset%mband, &
                       & wfs%mbandp, wfs%keys%nvctr(0), wfs%keys%nvctr(1), &
                       & wfs%mvctrp, wfs%psit, wfs%psi)
#else
    call loewe(dtset%mband, wfs%mbandp, wfs%mvctrp, wfs%psi)
    call checkortho(dtset%mband, wfs%mbandp, wfs%mvctrp, wfs%psi)
#endif

  else
    ! Store xcart for each atom
    allocate(xcart(3, dtset%natom))
    call xredxcart(dtset%natom, 1, rprimd, xcart, xred)

    ! Grep the name of elements...
    do i = 1, dtset%ntypat, 1
      call atmdata(atomMass, radcov, atomSymbol, psps%znucltypat(i))
      write(atomnames(i), "(A,A)") trim(adjustl(atomSymbol)), "_lda"
    end do
    ! We read the file with atomic orbital informations.
    write(*,*) "wvl_wfsinp: read file '"//trim(dtset%wvl_internal%orbital_path)//"'"
    call readAtomicOrbitals(mpi_enreg%me, dtset%wvl_internal%orbital_path, &
                          & ngx, npsp, xp, psiat, occupat, ng, &
                          & ns, np, pspatomnames, wfs%mband_init, atomnames, &
                          & dtset%typat, dtset%natom)

    ! We allocate memory for temporary storage of wavefunctions
    allocate(wfs%occ_init(wfs%mband_init))
    wfs%mbandp_init = ceiling(real(wfs%mband_init) / real(mpi_enreg%nproc))
    allocate(wfs%psi_init(wfs%keys%nvctr(0) + 7 * wfs%keys%nvctr(1), wfs%mbandp_init))

    ! We create the wave-functions from atomic orbitals.
    call createAtomicOrbitals(mpi_enreg%me, mpi_enreg%nproc, npsp, pspatomnames, atomnames, &
                            & dtset%natom, xcart, wfs%mband_init, wfs%mbandp_init, &
                            & wfs%occ_init, occupat, ngx, xp, &
                            & psiat, psiatn, ng, ns, np, wfs%keys%nvctr(0), wfs%keys%nvctr(1), &
                            & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
                            & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid, &
                            & dtset%wvl_internal%fineGrid(1, 1), &
                            & dtset%wvl_internal%fineGrid(2, 1), &
                            & dtset%wvl_internal%fineGrid(1, 2), &
                            & dtset%wvl_internal%fineGrid(2, 2), &
                            & dtset%wvl_internal%fineGrid(1, 3), &
                            & dtset%wvl_internal%fineGrid(2, 3), &
                            & wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%keyg, &
                            & wfs%keys%keyv, dtset%typat, wfs%psi_init, wfs%ekinetic_init)
  
    write(message, '(a,a,a)' ) &
      &  '  | wavefunctions have been calculated.'
    call wrtout(6,message,'COLL')
    
    ! Wavefunctions will be orthogonalised later, after a diagonalisation
    ! of the associated KS hamiltonian.
    deallocate(xcart)
  end if


#else
  write(message, '(a,a,a,a)' ) ch10,&
    &  ' wvl_inwffil : BigDFT library is not compiled.', ch10, &
    &  '   Action, used the flag --enable-bigdft when configuring.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
#endif
end subroutine wvl_wfsinp
!!***
