// per problemi vari di link separo costanti e roba rete Fastweb da AdunanzA.h / AdunanzA.cpp

#if !defined(_FASTWEBNET_H_)
#define _FASTWEBNET_H_

// #include <wx/string.h> in realta' ci andrebbe, ma se lo metto fallisce la compilazione di amulecmd!
#include "Types.h"  // needed for uint32

class wxString;

/*
MAN Milano........................   1.0.0.0/8
MAN Milano hinterland Nord........   2.0.0.0/8
MAN Genova........................   5.0.0.0/8
MAN Veneto........................  11.0.0.0/8
MAN Milano hinterland Sud.........  14.0.0.0/8
MAN Ancona........................  21.0.0.0/8
MAN Grosseto......................  22.0.0.0/8
MAN Roma..........................  23.0.0.0/8
MAN Toscana.......................  27.0.0.0/8
MAN Piemonte......................  28.0.0.0/8
MAN Triveneto.....................  29.0.0.0/8
MAN Bari..........................  31.0.0.0/8
MAN Sicilia.......................  36.0.0.0/8
MAN Bologna.......................  37.0.0.0/8
MAN Napoli........................  39.0.0.0/8
MAN Torino........................  41.0.0.0/8
MAN Reggio Emilia.................  42.0.0.0/8
MAN Cagliari......................  51.0.0.0/8

Routers & OAM.....................  10.0.0.0/8
Organization, Administration & Management (ad. es.: Server interni ntp, voip, billing etc. etc.)
*/


// Definizione zone italia FW
#define MAN_MILANO         1
#define MAN_MILANO_H_NORD  2
#define MAN_GENOVA         5
#define FASTWEB_ROUTERS   10
#define MAN_VENETO        11
#define MAN_MILANO_H_SUD  14
#define MAN_ANCONA        21
#define MAN_GROSSETO      22
#define MAN_ROMA          23
#define MAN_TOSCANA       27
#define MAN_PIEMONTE      28
#define MAN_TRIVENETO     29
#define MAN_BARI          31
#define MAN_SICILIA       36
#define MAN_BOLOGNA       37
#define MAN_NAPOLI        39
#define MAN_TORINO        41
#define MAN_REGGIO_EMILIA 42
#define MAN_CAGLIARI      51


// Definizioni per icone e per riconoscimento client
#define ADUNANZA_ICON_NONE      0
#define ADUNANZA_ICON_FW        1
#define ADUNANZA_ICON_ADU       2

class CFastwebNet
{
	public:
		static inline bool AduIsFastWebLANIP(uint32 ip)
		{
			switch (ip & 0xff) {
				case MAN_ROMA:
				case MAN_MILANO:
				case MAN_MILANO_H_NORD:
				case MAN_MILANO_H_SUD:
				case MAN_GENOVA:
				case MAN_TRIVENETO:
				case MAN_BARI:
				case MAN_BOLOGNA:
				case MAN_NAPOLI:
				case MAN_TORINO:
				case MAN_REGGIO_EMILIA:
				case MAN_TOSCANA:
				case MAN_PIEMONTE:
				case MAN_VENETO:
				case MAN_GROSSETO:
				case MAN_SICILIA:
				case MAN_ANCONA:
				case MAN_CAGLIARI:
				case FASTWEB_ROUTERS:
					return true;
				default:
					return false;
			}
		}


		static bool AduIsFastWebIP(uint32 ip)
		{
			if (CFastwebNet::AduIsFastWebLANIP(ip)) return true;
			
			// match rapido: (ip & mask) == netid

			// netid 213.140.0.0/19			- netid (hex) 0x00008cd5 / mask 0x00e0ffff
			if ((ip & 0x00e0ffff) == 0x00008cd5 ||
			// netid 213.156.32.0/19		- netid (hex) 0x00209cd5 / mask 0x00e0ffff
					(ip & 0x00e0ffff) == 0x00209cd5 ||
			// netid 62.101.64.0/18			- netid (hex) 0x0040653e / mask 0x00c0ffff
					(ip & 0x00c0ffff) == 0x0040653e ||
			// netid 81.208.0.0/17			-	netid (hex) 0x0000d051 / mask 0x0080ffff
					(ip & 0x0080ffff) == 0x0000d051 ||
			// netid 83.103.0.0/17			- netid (hex) 0x00006753 / mask 0x0080ffff
					(ip & 0x0080ffff) == 0x00006753 ||
			// netid 85.18.0.0/16       - netid (hex) 0x00001255 / mask 0x0000ffff
					(ip & 0x0000ffff) == 0x00001255 ||
			// netid 89.96.0.0/15       - netid (hex) 0x00006059 / mask 0x0000f7ff
					(ip & 0x0000f7ff) == 0x00006059 ||
			// netid 93.32.0.0/11       - netid (hex) 0x0000205d / mask 0x0000e0ff  // Allineamento 3.15b74
					(ip & 0x0000e0ff) == 0x0000205d)
					return true;


			return false;
		}
		static bool AduIsValidKaduAddress( uint32 host );

		static bool AduIsFastWebIP(const wxString& ipv4string);

		static bool	AduIsFiber(uint32 ip);
		// static uint32	AduGetTypeBand();

		static wxString GetFWCityFromIP(uint32 dwUserIP);

};


#endif

