# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################

import gtk
import gobject
import pango

from APTonCD.core import *
from APTonCD.core import gui
from APTonCD.core import constants
from APTonCD.core import utils
from APTonCD.core.utils import get_icon
from APTonCD.widgets import *

#columns indexes
(COL_CHECK, COL_TITLE) = range(2)

WINDOW_NAME = 'missingdialog'

class MissingDialog(controller.IController):
    """
        show installed packages that doesnt appear on cache directory.
    """
    def __init__(self, controller = None, missing_list = []):
        """
            Constructor.
        """

        self.controller = controller
        self.glade = gui.get_glade(constants.CREATE_GUI, WINDOW_NAME)
        gui.setCursorToBusy(self.controller.get_parent_widget(),True)
        #main widget
        self.window = gui.get_widget(self.glade, WINDOW_NAME)
        self.window.set_icon_name(constants.APP_ICON_NAME)
        self.window.set_transient_for(self.controller.get_main_window())
        self.window.set_position(gtk.WIN_POS_CENTER_ON_PARENT)

        #get work widgets
        self.tvwNotInstalled = gui.get_widget(self.glade, 'tvwNotInstalled')
        self.store = gtk.ListStore(gobject.TYPE_BOOLEAN, str)

        self.__create_ui()
        if len(missing_list)>0:
            for n in missing_list:
                self.store.append([False, n])
        gui.setCursorToNormal(self.controller.get_parent_widget())

    def __create_ui(self):
        self.store.set_sort_column_id(COL_TITLE, gtk.SORT_ASCENDING)
        # Create all cell renders
        self.cellRendererToggle = gtk.CellRendererToggle()
        self.cellRendererText = gtk.CellRendererText()
        self.cellRendererText.set_property('ellipsize', pango.ELLIPSIZE_END)
        
        column = gtk.TreeViewColumn('', self.cellRendererToggle, active = COL_CHECK)
        column.set_sort_column_id(COL_CHECK)
        column.set_clickable(True)
        self.tvwNotInstalled.append_column(column)
        
        # add the pixbuf column to the tree view widget
        column = gtk.TreeViewColumn(constants.MESSAGE_0004, self.cellRendererText, markup = COL_TITLE)
        column.set_sort_column_id(COL_TITLE)
        column.set_clickable(True)
        column.set_resizable(True)
        column.set_expand(True)
        column.set_min_width(300)
        self.tvwNotInstalled.append_column(column) 
        
        self.tvwNotInstalled.set_model(self.store)
       

    def run(self):
        """
            This will show the dialog and will wait for an user interaction.
        """
        result = self.window.run()
        return result,  self.store
        
    def destroy(self):
        """
            This will destroy the main dialog window.
        """
        self.window.destroy()

    def get_main_window(self):
        """
            implements IController interface method.
            for access the class windows object.
        """
        if self.controller:
            return self.controller.get_main_window()
        else:
            return self.window

    def get_parent_widget(self):
        """
            implements IController interface method.
            for container widget
        """
        if self.controller:
            self.controller.get_parent_widget()
        else:
            return self.window.get_children()[0]

