/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.javancss.FunctionMetric;
import net.sourceforge.cobertura.javancss.Javancss;
import net.sourceforge.cobertura.javancss.JavancssFactory;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Source;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexityCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ComplexityCalculator.class);
    public static final Complexity ZERO_COMPLEXITY = new Complexity();
    private final FileFinder finder;
    private final JavancssFactory javancssFactory;
    private Map sourceFileCNNCache = new HashMap();
    private Map packageCNNCache = new HashMap();
    private static final int FILE_FUNCTION_METRIC_CACHE_SIZE = 6;
    private Map<String, List<FunctionMetric>> sourceFileFunctionMetricCache = new LinkedHashMap<String, List<FunctionMetric>>(6, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<FunctionMetric>> arg0) {
            return this.size() > 6;
        }
    };
    private boolean calculateMethodComplexity;
    private String encoding;

    public ComplexityCalculator(FileFinder finder) {
        this(finder, new JavancssFactory());
    }

    public ComplexityCalculator(FileFinder finder, JavancssFactory javancssFactory) {
        this.finder = (FileFinder)Validate.notNull((Object)finder, (String)"finder should not be null", (Object[])new Object[0]);
        this.javancssFactory = (JavancssFactory)Validate.notNull((Object)javancssFactory, (String)"javancssFactory should not be null", (Object[])new Object[0]);
    }

    private Complexity getAccumlatedCCNForSingleFile(String sourceFileName) throws IOException {
        List<FunctionMetric> methodMetrics = this.getFunctionMetricsForSingleFile(sourceFileName);
        if (methodMetrics.isEmpty()) {
            return ZERO_COMPLEXITY;
        }
        int classCcn = 0;
        for (FunctionMetric singleMethodMetrics : methodMetrics) {
            classCcn += singleMethodMetrics.ccn;
        }
        return new Complexity(classCcn, methodMetrics.size());
    }

    public double getCCNForProject(ProjectData projectData) {
        Complexity act = new Complexity();
        for (Object pkg : projectData.getPackages()) {
            PackageData packageData = (PackageData)pkg;
            act.add(this.getCCNForPackageInternal(packageData));
        }
        return act.averageCCN();
    }

    public double getCCNForPackage(PackageData packageData) {
        return this.getCCNForPackageInternal(packageData).averageCCN();
    }

    private Complexity getCCNForPackageInternal(PackageData packageData) {
        Complexity cachedCCN = (Complexity)this.packageCNNCache.get(packageData.getName());
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity act = new Complexity();
        for (SourceFileData sourceData : packageData.getSourceFiles()) {
            act.add(this.getCCNForSourceFileNameInternal(sourceData.getName()));
        }
        this.packageCNNCache.put(packageData.getName(), act);
        return act;
    }

    public double getCCNForSourceFile(SourceFileData sourceFile) {
        return this.getCCNForSourceFileNameInternal(sourceFile.getName()).averageCCN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FunctionMetric> getFunctionMetricsForSingleFile(String sourceFileName) {
        List functionMetrics = Collections.emptyList();
        if (!this.sourceFileFunctionMetricCache.containsKey(sourceFileName)) {
            Source source = null;
            try {
                source = this.finder.getSource(sourceFileName);
                if (source != null && sourceFileName.endsWith(".java")) {
                    Javancss javancss = this.javancssFactory.newInstance(source.getInputStream(), this.encoding);
                    if (javancss.getLastErrorMessage() != null) {
                        logger.warn("JavaNCSS got an error while parsing the java " + source.getOriginDesc() + "\n" + javancss.getLastErrorMessage());
                    }
                    functionMetrics = javancss.getFunctionMetrics();
                }
            }
            finally {
                if (source != null) {
                    source.close();
                }
            }
            this.sourceFileFunctionMetricCache.put(sourceFileName, functionMetrics);
        }
        return this.sourceFileFunctionMetricCache.get(sourceFileName);
    }

    private Complexity getCCNForSourceFileNameInternal(String sourceFileName) {
        Complexity cachedCCN = (Complexity)this.sourceFileCNNCache.get(sourceFileName);
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity result = ZERO_COMPLEXITY;
        try {
            result = this.getAccumlatedCCNForSingleFile(sourceFileName);
        }
        catch (IOException ex) {
            logger.info("Cannot find source file during CCN computation, source=[" + sourceFileName + "]");
        }
        this.sourceFileCNNCache.put(sourceFileName, result);
        return result;
    }

    public double getCCNForClass(ClassData classData) {
        return this.getCCNForSourceFileNameInternal(classData.getSourceFileName()).averageCCN();
    }

    public int getCCNForMethod(ClassData classData, String methodName, String methodDescriptor) {
        if (!this.calculateMethodComplexity) {
            return 0;
        }
        Validate.notNull((Object)classData, (String)"classData must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)methodName, (String)"methodName must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)methodDescriptor, (String)"methodDescriptor must not be null", (Object[])new Object[0]);
        int complexity = 0;
        List<FunctionMetric> methodMetrics = this.getFunctionMetricsForSingleFile(classData.getSourceFileName());
        String goldenMethodName = methodName;
        boolean isConstructor = false;
        if (goldenMethodName.equals("<init>")) {
            isConstructor = true;
            goldenMethodName = classData.getBaseName();
        }
        goldenMethodName = classData.getName() + "." + goldenMethodName;
        goldenMethodName = goldenMethodName.replaceAll(Pattern.quote("$"), ".");
        TraceSignatureVisitor v = new TraceSignatureVisitor(1);
        SignatureReader r = new SignatureReader(methodDescriptor);
        r.accept((SignatureVisitor)v);
        String goldenSignature = v.getDeclaration();
        goldenSignature = goldenSignature.substring(1, goldenSignature.length() - 1);
        HashMap<String, Integer> candidateSignatureToCcn = new HashMap<String, Integer>();
        for (FunctionMetric singleMethodMetrics : methodMetrics) {
            String candidateMethodName = singleMethodMetrics.name.substring(0, singleMethodMetrics.name.indexOf(40));
            String candidateSignature = ComplexityCalculator.stripTypeParameters(singleMethodMetrics.name.substring(singleMethodMetrics.name.indexOf(40) + 1, singleMethodMetrics.name.length() - 1));
            if (!goldenMethodName.equals(candidateMethodName)) continue;
            candidateSignatureToCcn.put(candidateSignature, singleMethodMetrics.ccn);
        }
        if (candidateSignatureToCcn.size() == 1) {
            return (Integer)candidateSignatureToCcn.values().iterator().next();
        }
        if (!goldenSignature.isEmpty()) {
            try {
                Executable realMethod;
                String[] goldenParameterTypeStrings = goldenSignature.split(",");
                Class[] goldenParameterTypes = new Class[goldenParameterTypeStrings.length];
                for (int i = 0; i < goldenParameterTypeStrings.length; ++i) {
                    goldenParameterTypes[i] = ClassUtils.getClass((String)goldenParameterTypeStrings[i].trim(), (boolean)false);
                }
                Class klass = ClassUtils.getClass((String)classData.getName(), (boolean)false);
                if (isConstructor) {
                    realMethod = klass.getDeclaredConstructor(goldenParameterTypes);
                    goldenSignature = ((Constructor)realMethod).toGenericString();
                } else {
                    realMethod = klass.getDeclaredMethod(methodName, goldenParameterTypes);
                    goldenSignature = ((Method)realMethod).toGenericString();
                }
                goldenSignature = goldenSignature.replaceAll("\\.\\.\\.", "[]");
                goldenSignature = goldenSignature.substring(goldenSignature.indexOf("(") + 1, goldenSignature.length() - 1);
                goldenSignature = ComplexityCalculator.stripTypeParameters(goldenSignature);
            }
            catch (Exception e) {
                logger.error("Error while getting method CC for " + goldenMethodName, (Throwable)e);
                return 0;
            }
        }
        goldenSignature = goldenSignature.replaceAll(Pattern.quote("$"), ".");
        double signatureMatchPercentTillNow = 0.0;
        for (Map.Entry candidateSignatureToCcnEntry : candidateSignatureToCcn.entrySet()) {
            String candidateSignature = (String)candidateSignatureToCcnEntry.getKey();
            double currentMatchPercent = ComplexityCalculator.matchSignatures(candidateSignature, goldenSignature);
            if (currentMatchPercent == 1.0) {
                return (Integer)candidateSignatureToCcnEntry.getValue();
            }
            if (!(currentMatchPercent > signatureMatchPercentTillNow)) continue;
            complexity = (Integer)candidateSignatureToCcnEntry.getValue();
            signatureMatchPercentTillNow = currentMatchPercent;
        }
        return complexity;
    }

    private static final String stripTypeParameters(String signature) {
        StringBuilder strippedSignature = new StringBuilder();
        int openIndex = -1;
        int openCount = 0;
        int open = 60;
        int close = 62;
        block0: while ((openIndex = signature.indexOf(60)) > -1) {
            strippedSignature.append(signature.substring(0, openIndex));
            for (int i = openIndex + 1; i < signature.length(); ++i) {
                if (signature.charAt(i) == '>') {
                    if (openCount == 0) {
                        signature = signature.substring(i + 1);
                        continue block0;
                    }
                    --openCount;
                    continue;
                }
                if (signature.charAt(i) != '<') continue;
                ++openCount;
            }
        }
        strippedSignature.append(signature);
        return strippedSignature.toString();
    }

    private static final double matchSignatures(String candidate, String golden) {
        String[] candidateParamTypes = candidate.split(",");
        String[] goldenParamTypes = golden.split(",");
        if (goldenParamTypes.length != candidateParamTypes.length) {
            return 0.0;
        }
        int totalParamTypes = goldenParamTypes.length;
        if (totalParamTypes == 0) {
            return 1.0;
        }
        double totalMatchPercent = 0.0;
        for (int i = 0; i < totalParamTypes; ++i) {
            String goldenParamType = goldenParamTypes[i].trim();
            String candidateParamType = candidateParamTypes[i].trim();
            if (goldenParamType.length() < candidateParamType.length()) {
                return 0.0;
            }
            if (goldenParamType.equals(candidateParamType)) {
                totalMatchPercent += 1.0;
                continue;
            }
            int partialMatchIndex = goldenParamType.lastIndexOf(candidateParamType);
            if (partialMatchIndex > 1 && goldenParamType.length() == partialMatchIndex + candidateParamType.length() && goldenParamType.charAt(partialMatchIndex - 1) == '.') {
                totalMatchPercent += 1.0 - (double)partialMatchIndex / (double)goldenParamType.length();
                continue;
            }
            return 0.0;
        }
        return totalMatchPercent / (double)totalParamTypes;
    }

    public void setCalculateMethodComplexity(boolean calculateMethodComplexity) {
        this.calculateMethodComplexity = calculateMethodComplexity;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private static class Complexity {
        private double accumlatedCCN;
        private int methodsNum;

        public Complexity(double accumlatedCCN, int methodsNum) {
            this.accumlatedCCN = accumlatedCCN;
            this.methodsNum = methodsNum;
        }

        public Complexity() {
            this(0.0, 0);
        }

        public double averageCCN() {
            if (this.methodsNum == 0) {
                return 0.0;
            }
            return this.accumlatedCCN / (double)this.methodsNum;
        }

        public void add(Complexity second) {
            this.accumlatedCCN += second.accumlatedCCN;
            this.methodsNum += second.methodsNum;
        }
    }
}

