/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.TypeDesc;

public class DelegatedCodeAssembler
implements CodeAssembler {
    protected final CodeAssembler mAssembler;

    public DelegatedCodeAssembler(CodeAssembler assembler) {
        if (assembler == null) {
            throw new IllegalArgumentException();
        }
        this.mAssembler = assembler;
    }

    public int getParameterCount() {
        return this.mAssembler.getParameterCount();
    }

    public LocalVariable getParameter(int index) {
        return this.mAssembler.getParameter(index);
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        return this.mAssembler.createLocalVariable(name, type);
    }

    public LocalVariable createLocalVariable(TypeDesc type) {
        return this.mAssembler.createLocalVariable(type);
    }

    public Label createLabel() {
        return this.mAssembler.createLabel();
    }

    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        this.mAssembler.exceptionHandler(startLocation, endLocation, catchClassName);
    }

    public void mapLineNumber(int lineNumber) {
        this.mAssembler.mapLineNumber(lineNumber);
    }

    public void inline(Object code) {
        this.mAssembler.inline(code);
    }

    public void loadNull() {
        this.mAssembler.loadNull();
    }

    public void loadConstant(String value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadConstant(TypeDesc type) {
        this.mAssembler.loadConstant(type);
    }

    public void loadConstant(boolean value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadConstant(int value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadConstant(long value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadConstant(float value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadConstant(double value) {
        this.mAssembler.loadConstant(value);
    }

    public void loadLocal(LocalVariable local) {
        this.mAssembler.loadLocal(local);
    }

    public void loadThis() {
        this.mAssembler.loadThis();
    }

    public void storeLocal(LocalVariable local) {
        this.mAssembler.storeLocal(local);
    }

    public void loadFromArray(TypeDesc type) {
        this.mAssembler.loadFromArray(type);
    }

    public void storeToArray(TypeDesc type) {
        this.mAssembler.storeToArray(type);
    }

    public void loadField(String fieldName, TypeDesc type) {
        this.mAssembler.loadField(fieldName, type);
    }

    public void loadField(String className, String fieldName, TypeDesc type) {
        this.mAssembler.loadField(className, fieldName, type);
    }

    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.mAssembler.loadField(classDesc, fieldName, type);
    }

    public void loadStaticField(String fieldName, TypeDesc type) {
        this.mAssembler.loadStaticField(fieldName, type);
    }

    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.mAssembler.loadStaticField(className, fieldName, type);
    }

    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.mAssembler.loadStaticField(classDesc, fieldName, type);
    }

    public void storeField(String fieldName, TypeDesc type) {
        this.mAssembler.storeField(fieldName, type);
    }

    public void storeField(String className, String fieldName, TypeDesc type) {
        this.mAssembler.storeField(className, fieldName, type);
    }

    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.mAssembler.storeField(classDesc, fieldName, type);
    }

    public void storeStaticField(String fieldName, TypeDesc type) {
        this.mAssembler.storeStaticField(fieldName, type);
    }

    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.mAssembler.storeStaticField(className, fieldName, type);
    }

    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.mAssembler.storeStaticField(classDesc, fieldName, type);
    }

    public void returnVoid() {
        this.mAssembler.returnVoid();
    }

    public void returnValue(TypeDesc type) {
        this.mAssembler.returnValue(type);
    }

    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.mAssembler.convert(fromType, toType);
    }

    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        this.mAssembler.convert(fromType, toType, fpConvertMode);
    }

    public void invoke(Method method) {
        this.mAssembler.invoke(method);
    }

    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeVirtual(methodName, ret, params);
    }

    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeVirtual(className, methodName, ret, params);
    }

    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeVirtual(classDesc, methodName, ret, params);
    }

    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeStatic(methodName, ret, params);
    }

    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeStatic(className, methodName, ret, params);
    }

    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeStatic(classDesc, methodName, ret, params);
    }

    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeInterface(className, methodName, ret, params);
    }

    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeInterface(classDesc, methodName, ret, params);
    }

    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokePrivate(methodName, ret, params);
    }

    public void invokeSuper(Method method) {
        this.mAssembler.invokeSuper(method);
    }

    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeSuper(superClassName, methodName, ret, params);
    }

    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.mAssembler.invokeSuper(superClassDesc, methodName, ret, params);
    }

    public void invoke(Constructor constructor) {
        this.mAssembler.invoke(constructor);
    }

    public void invokeConstructor(TypeDesc[] params) {
        this.mAssembler.invokeConstructor(params);
    }

    public void invokeConstructor(String className, TypeDesc[] params) {
        this.mAssembler.invokeConstructor(className, params);
    }

    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        this.mAssembler.invokeConstructor(classDesc, params);
    }

    public void invokeSuperConstructor(TypeDesc[] params) {
        this.mAssembler.invokeSuperConstructor(params);
    }

    public void newObject(TypeDesc type) {
        this.mAssembler.newObject(type);
    }

    public void newObject(TypeDesc type, int dimensions) {
        this.mAssembler.newObject(type, dimensions);
    }

    public void dup() {
        this.mAssembler.dup();
    }

    public void dupX1() {
        this.mAssembler.dupX1();
    }

    public void dupX2() {
        this.mAssembler.dupX2();
    }

    public void dup2() {
        this.mAssembler.dup2();
    }

    public void dup2X1() {
        this.mAssembler.dup2X1();
    }

    public void dup2X2() {
        this.mAssembler.dup2X2();
    }

    public void pop() {
        this.mAssembler.pop();
    }

    public void pop2() {
        this.mAssembler.pop2();
    }

    public void swap() {
        this.mAssembler.swap();
    }

    public void swap2() {
        this.mAssembler.swap2();
    }

    public void branch(Location location) {
        this.mAssembler.branch(location);
    }

    public void ifNullBranch(Location location, boolean choice) {
        this.mAssembler.ifNullBranch(location, choice);
    }

    public void ifEqualBranch(Location location, boolean choice) {
        this.mAssembler.ifEqualBranch(location, choice);
    }

    public void ifZeroComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        this.mAssembler.ifZeroComparisonBranch(location, choice);
    }

    public void ifComparisonBranch(Location location, String choice) throws IllegalArgumentException {
        this.mAssembler.ifComparisonBranch(location, choice);
    }

    public void ifComparisonBranch(Location location, String choice, TypeDesc type) throws IllegalArgumentException {
        this.mAssembler.ifComparisonBranch(location, choice, type);
    }

    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        this.mAssembler.switchBranch(cases, locations, defaultLocation);
    }

    public void jsr(Location location) {
        this.mAssembler.jsr(location);
    }

    public void ret(LocalVariable local) {
        this.mAssembler.ret(local);
    }

    public void math(byte opcode) {
        this.mAssembler.math(opcode);
    }

    public void arrayLength() {
        this.mAssembler.arrayLength();
    }

    public void throwObject() {
        this.mAssembler.throwObject();
    }

    public void checkCast(TypeDesc type) {
        this.mAssembler.checkCast(type);
    }

    public void instanceOf(TypeDesc type) {
        this.mAssembler.instanceOf(type);
    }

    public void integerIncrement(LocalVariable local, int amount) {
        this.mAssembler.integerIncrement(local, amount);
    }

    public void monitorEnter() {
        this.mAssembler.monitorEnter();
    }

    public void monitorExit() {
        this.mAssembler.monitorExit();
    }

    public void nop() {
        this.mAssembler.nop();
    }

    public void breakpoint() {
        this.mAssembler.breakpoint();
    }
}

