/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.tool.re.BlockStatement;
import net.sf.jiapi.tool.re.BreakStatement;
import net.sf.jiapi.tool.re.ControlFlowGraph;
import net.sf.jiapi.tool.re.IfStatement;
import net.sf.jiapi.tool.re.Loop;
import net.sf.jiapi.tool.re.LoopStatement;
import net.sf.jiapi.tool.re.Node;
import net.sf.jiapi.tool.re.Statement;

public class StatementBuilder {
    private final ControlFlowGraph cfg;

    public StatementBuilder(ControlFlowGraph cfg) {
        this.cfg = cfg;
    }

    public List<Statement> structure() {
        Statement s;
        LinkedList<Statement> statements = new LinkedList<Statement>();
        Node node = this.cfg.getRootNode();
        do {
            s = this.structure(node, null);
            statements.add(s);
        } while ((node = s.getNextNode()) != null);
        return statements;
    }

    private Statement structure(Node node, Loop loop) {
        Statement stmt = null;
        if (this.cfg.getLoops().containsKey(node)) {
            stmt = this.structureLoop(this.cfg.getLoops().get(node));
        } else if (node.getSuccessors().size() == 2) {
            stmt = this.structureIfElse(node, loop);
        } else {
            stmt = new BlockStatement(node);
            if (loop != null && stmt.getNextNode().equals(loop.getPostDominator())) {
                stmt = new BreakStatement((BlockStatement)stmt);
            }
        }
        return stmt;
    }

    private LoopStatement structureLoop(Loop loop) {
        Statement s;
        LoopStatement loopStmt = new LoopStatement(loop);
        Node header = loop.getHeader();
        Node body = loop.getLoopBody();
        do {
            s = this.structure(body, loop);
            loopStmt.addStatement(s);
        } while (!header.equals(body = s.getNextNode()));
        return loopStmt;
    }

    private IfStatement structureIfElse(Node node, Loop loop) {
        IfStatement stmt = new IfStatement(node);
        Node exitNode = stmt.getNextNode();
        Node ifBodyNode = stmt.getIfBody();
        while (true) {
            System.out.println("Structuring ifElse, ifBodyNode " + ifBodyNode.getId());
            Statement s = this.structure(ifBodyNode, loop);
            ifBodyNode = s.getNextNode();
            System.out.println("  exit " + exitNode.getId() + ", start " + s.getStartNode().getId());
            if (exitNode.equals(s.getStartNode())) break;
            stmt.addStatementForIfBlock(s);
        }
        Node elseBody = stmt.getElseBody();
        System.out.println("  ifBlock done");
        if (elseBody != null) {
            System.out.println("  handling else body " + elseBody.getId());
            while (true) {
                Statement s = this.structure(elseBody, loop);
                elseBody = s.getNextNode();
                if (exitNode.equals(s.getStartNode())) break;
                stmt.addStatementForElseBlock(s);
            }
        }
        System.out.println("  returning IfStmt, next: " + stmt.getNextNode().getId());
        return stmt;
    }
}

