//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_47.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot47(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[47] = {1.305515013125343e-02,1.175180025752869e-01,3.265593280368458e-01,6.404110729936394e-01,1.059422930904129e+00,
    1.584064500142716e+00,2.214928211181823e+00,2.952733067582333e+00,3.798329258784967e+00,4.752703717801292e+00,5.816986714180142e+00,6.992459592672030e+00,
    8.280563791571433e+00,9.682911302704166e+00,1.120129676860915e+01,1.283771145312411e+01,1.459435937123215e+01,1.647367592514004e+01,1.847834946939599e+01,
    2.061134632270739e+01,2.287593986374059e+01,2.527574450030938e+01,2.781475549654652e+01,3.049739589543077e+01,3.332857210467152e+01,3.631374015101746e+01,
    3.945898519246037e+01,4.277111766890962e+01,4.625779055728257e+01,4.992764370799211e+01,5.379048337743119e+01,5.785750814902426e+01,6.214159695498769e+01,
    6.665768169372780e+01,7.142323736942693e+01,7.645893917399606e+01,8.178956284611218e+01,8.744525018712591e+01,9.346334201875047e+01,9.989113009426819e+01,
    1.067901735806911e+02,1.142434497130025e+02,1.223680610067415e+02,1.313400409943002e+02,1.414496758849499e+02,1.532532691757077e+02,1.681855266899249e+02
    };
  constexpr double aw[47] = {2.255595142545266e-01,2.032420488894175e-01,1.649941365520042e-01,1.206496106072594e-01,7.943921517210567e-02,
    4.707528821179732e-02,2.509253201516196e-02,1.202207095066536e-02,5.172859200829822e-03,1.996976286940151e-03,6.909053409296403e-04,2.139513219971487e-04,
    5.921620546142635e-05,1.462514745736820e-05,3.217512378236771e-06,6.292772352983083e-07,1.091730772425100e-07,1.676066012388592e-08,2.270963504317804e-09,
    2.707662235924643e-10,2.831612790978552e-11,2.588042390934693e-12,2.059142599411916e-13,1.419954809596533e-14,8.445465399310963e-16,4.309089409252813e-17,
    1.874744659362926e-18,6.908187502757036e-20,2.139739182673124e-21,5.523554741854495e-23,1.176858621995547e-24,2.046766797091668e-26,2.868947494657381e-28,
    3.193603995328041e-30,2.774926548053356e-32,1.844063569752035e-34,9.146355819266344e-37,3.286828103995520e-39,8.249169834951546e-42,1.380291946286455e-44,
    1.449562336634452e-47,8.809113969446201e-51,2.763116491256896e-54,3.769132436919883e-58,1.687960399559856e-62,1.453890194705030e-67,6.187316729259933e-74
    };
  constexpr double x[18048] = {  5.467511021237293e-04, -2.876859366954057e-06,  1.134981492953782e-08, -3.978795271221758e-11,  1.307034783129944e-13,
 -4.119632245224067e-16,  1.261586874891134e-18, -3.781850026583832e-21,  1.115044394053330e-23, -3.244028307963330e-26,  9.333989307661844e-29, -2.660445124027756e-31,
  4.917247423175959e-03, -2.581728830387726e-05,  1.014131008104515e-07, -3.529396165164045e-10,  1.146765874300654e-12, -3.558983788844206e-15,  1.067386590616553e-17,
 -3.113686869048336e-20,  8.866774201574975e-23, -2.469528259204516e-25,  6.731139592536547e-28, -1.794704243378801e-30,  1.363952189723162e-02, -7.130249000567684e-05,
  2.776500567742146e-07, -9.521766443723357e-10,  3.025083831443189e-12, -9.089659740458179e-15,  2.606432347437158e-17, -7.152440660039846e-20,  1.875078347023694e-22,
 -4.665155040558159e-25,  1.085906195833280e-27, -2.294063469526492e-30,  2.667621084252745e-02, -1.385477971264899e-04,  5.324320347451049e-07, -1.785308954857501e-09,
  5.476201231956915e-12, -1.561440523784071e-14,  4.145308867620391e-17, -1.014163036317985e-19,  2.221214118269599e-22, -4.025186310999457e-25,  4.307115226104448e-28,
  8.077864862656225e-31,  4.397145021175914e-02, -2.263927165734421e-04,  8.546868995728757e-07, -2.778775467851128e-09,  8.109343183478386e-12, -2.136944482425748e-14,
  4.988830444008663e-17, -9.673211512343496e-20,  1.204140705128339e-22,  1.196834767983320e-25, -1.547611424801500e-27,  7.046210542055917e-30,  6.545109291160013e-02,
 -3.333204476081140e-04,  1.230328491703291e-06, -3.842951352346545e-09,  1.047915926773113e-11, -2.454266085187576e-14,  4.534329035893971e-17, -4.232295006789145e-20,
 -1.351621853189717e-22,  1.008074718864037e-24, -3.995413344119999e-27,  1.198503174108890e-29,  9.102299780609163e-02, -4.574834244462182e-04,  1.642803933238082e-06,
 -4.878647255700151e-09,  1.213974029283721e-11, -2.361974886771891e-14,  2.449407754616753e-17,  6.076252310077552e-20, -4.860793488630760e-22,  1.881133187405533e-24,
 -5.202727596944297e-27,  9.663560288183232e-30,  1.205773897470390e-01, -5.967344788761307e-04,  2.073738246366157e-06, -5.784355302174911e-09,  1.269993392294772e-11,
 -1.769307676660309e-14, -1.205008763768145e-17,  1.927251246737848e-19, -8.068725944652529e-22,  2.205702875976816e-24, -3.536803153274972e-27, -2.771320112646628e-30,
  1.539872897993930e-01, -7.486631275632266e-04,  2.503652030972364e-06, -6.463743445639267e-09,  1.187378399716703e-11, -6.680597798888702e-15, -5.938052104570365e-17,
  3.183609076417590e-19, -9.446989206708600e-22,  1.548419802477479e-24,  1.412225830771367e-27, -2.136376665590392e-29,  1.911090146474186e-01, -9.106364045931606e-04,
  2.912725098660058e-06, -6.832879771504849e-09,  9.520378281176780e-12,  8.584497178369197e-15, -1.089217286336467e-16,  3.957796995146816e-19, -7.771097569866490e-22,
 -1.685603803882751e-25,  8.148778766919732e-27, -3.564943901399638e-29,  2.317827439771336e-01, -1.079843583673394e-03,  3.281577092499457e-06, -6.826683119508059e-09,
  5.668466800893812e-12,  2.641294380158714e-14, -1.499799607398096e-16,  3.883332034683135e-19, -2.676590842788484e-22, -2.532959121758817e-24,  1.356510023396129e-26,
 -3.379719600545121e-29,  2.758331544310528e-01, -1.253344067435194e-03,  3.592035311755937e-06, -6.404145239167817e-09,  5.227998644430459e-13,  4.446372155325485e-14,
 -1.719182359704157e-16,  2.764950644743641e-19,  5.022183118206360e-22, -4.713557330926841e-24,  1.424453113121607e-26, -1.023272932639382e-29,  3.230701185219212e-01,
 -1.428117664557599e-03,  3.827860248961426e-06, -5.551949653118398e-09, -5.548931018955007e-12,  6.006671821494262e-14, -1.665172232002715e-16,  6.621574912325041e-20,
  1.339978034008644e-21, -5.737910951080957e-24,  8.245405456479951e-27,  2.877944947782651e-29,  3.732894666722585e-01, -1.601116429977530e-03,  3.975400735284988e-06,
 -4.286218469860748e-09, -1.204758563146412e-11,  7.061744729534036e-14, -1.300193613163209e-16, -2.089700403523445e-19,  1.989728558714246e-21, -4.884184881896548e-24,
 -3.513866810457045e-27,  6.568218401775961e-29,  4.262738103158351e-01, -1.769317210154705e-03,  4.024153042649031e-06, -2.652243749614558e-09, -1.838952921823212e-11,
  7.398477286111732e-14, -6.439658153602213e-17, -4.932432852173500e-19,  2.208914412508648e-21, -2.032658639745587e-24, -1.707232105431118e-26,  7.925919711251733e-29,
  4.817934237555584e-01, -1.929774014998240e-03,  3.967201732238016e-06, -7.221965028374173e-10, -2.396435538498571e-11,  6.886868808119330e-14,  2.247580869985150e-17,
 -7.203939100323231e-19,  1.850561979058034e-21,  2.178702075726263e-24, -2.674173684485421e-26,  5.609479606850875e-29,  5.396071822198790e-01, -2.079669331261501e-03,
  3.801524356748479e-06,  1.409055056856642e-09, -2.819743782852073e-11,  5.505092246218009e-14,  1.178418545409691e-16, -8.296326145143670e-19,  9.237049633313733e-22,
  6.484850354089654e-24, -2.749131091715113e-26, -2.519528556128635e-31,  5.994635532972427e-01, -2.216363499437207e-03,  3.528147171578981e-06,  3.629755110364391e-09,
 -3.061073875728656e-11,  3.349585128088182e-14,  2.061425780959280e-16, -7.814130371979939e-19, -3.903096328136260e-22,  9.391136080284982e-24, -1.738336415900176e-26,
 -6.804795217195223e-29,  6.611016386561777e-01, -2.337441297718592e-03,  3.152144611814300e-06,  5.818319793251866e-09, -3.087536198353627e-11,  6.280792994587259e-15,
  2.717825585496076e-16, -5.691134248471820e-19, -1.774928708040142e-21,  9.707187940608726e-24,  1.103533305459930e-27, -1.160213113611472e-28,  7.242522626785275e-01,
 -2.440754912516998e-03,  2.682481246364865e-06,  7.851178197558321e-09, -2.885009665382378e-11, -2.363985486363668e-14,  3.020628824505597e-16, -2.232842290291395e-19,
 -2.861233360358124e-21,  7.020012899033370e-24,  2.161527768785955e-26, -1.183322880687074e-28,  7.886391043467085e-01, -2.524462525206986e-03,  2.131701008902002e-06,
  9.610866607284299e-09, -2.460158461415479e-11, -5.280688081532018e-14,  2.897034072678143e-16,  1.930589358596261e-19, -3.333386107610132e-21,  1.917360901285109e-24,
  3.626411414216032e-26, -6.844807377380469e-29,  8.539798684346545e-01, -2.587061808839872e-03,  1.515474497527872e-06,  1.099382362732527e-08, -1.840362305428623e-11,
 -7.771379358614102e-14,  2.344393209845644e-16,  5.973661257787210e-19, -3.024879562389215e-21, -4.143006844296608e-24,  3.885903422337390e-26,  1.563582185075365e-29,
  9.199874917586766e-01, -2.627417705914116e-03,  8.520207992070823e-07,  1.191734755751275e-08, -1.071529144553257e-11, -9.528442493380675e-14,  1.433460698509013e-16,
  9.058281200094217e-19, -1.975067411507528e-21, -9.291342479131122e-24,  2.763340894745154e-26,  9.832158238874943e-29,  9.863713799515487e-01, -2.644783948050643e-03,
  1.614254048631217e-07,  1.232522859196699e-08, -2.139838931267399e-12, -1.033009503639933e-13,  2.979093800040629e-17,  1.052642922792160e-18, -4.267091607938124e-22,
 -1.187690775680442e-23,  6.222815371559518e-27,  1.427023286179566e-28,  1.052838669933860e+00, -2.638817879469786e-03, -5.351198741609079e-07,  1.219165429539323e-08,
  6.631655911680382e-12, -1.007187263515415e-13, -8.881943191961511e-17,  1.005533349516169e-18,  1.236844546057703e-21, -1.104475145910238e-23, -1.762230469090574e-26,
  1.283058981950843e-28,  1.119095512974512e+00, -2.609588257122924e-03, -1.216125684816838e-06,  1.152310195123008e-08,  1.488616419299141e-11, -8.782017051379709e-14,
 -1.940835509382519e-16,  7.736055503278674e-19,  2.597296432853595e-21, -7.043858088296282e-24, -3.510396338398985e-26,  6.126109759136312e-29,  1.184848372961007e+00,
 -2.557575819564270e-03, -1.860631016808214e-06,  1.035806824944915e-08,  2.195734689498543e-11, -6.618326696708508e-14, -2.698655884853398e-16,  4.054974663532439e-19,
  3.318575429458705e-21, -1.148364408971850e-24, -3.992844398518917e-26, -2.845694330847068e-29,  1.249805334243894e+00, -2.483666542287250e-03, -2.449013539292655e-06,
  8.764636140467888e-09,  2.728980553553069e-11, -3.846769863858902e-14, -3.051457124542357e-16, -2.181304079585288e-20,  3.240193987808030e-21,  4.782769219973057e-24,
 -3.081029579528877e-26, -1.014263221486217e-28,  1.313677413182820e+00, -2.389137627209142e-03, -2.963751963468473e-06,  6.836030187681228e-09,  3.049218887731049e-11,
 -8.048927770192698e-15, -2.959100580790165e-16, -4.208146940429199e-19,  2.418615497110996e-21,  8.946525429725276e-24, -1.185361751681673e-26, -1.275219077823318e-28,
  1.376179867308428e+00, -2.275636405991771e-03, -3.390109541860238e-06,  4.684454678675890e-09,  3.137353544205324e-11,  2.144646043082274e-14, -2.457182538599913e-16,
 -7.134870117447017e-19,  1.104643011689011e-21,  1.020147200097528e-23,  9.317792235240367e-27, -9.953052547457869e-29,  1.437033495829526e+00, -2.145152468506566e-03,
 -3.716710627999250e-06,  2.433632751188800e-09,  2.995899078010402e-11,  4.663579149525650e-14, -1.648492192883255e-16, -8.486046701710894e-19, -3.351603859840817e-22,
  8.418950112702167e-24,  2.481218700330400e-26, -3.501223858472780e-29,  1.495965925063064e+00, -1.999983456450559e-03, -3.935986220678939e-06,  2.105606340570969e-10,
  2.648323813580953e-11,  6.483269382142594e-14, -6.820970011506645e-17, -8.121228133005971e-19, -1.527702630996517e-21,  4.460760508498412e-24,  2.964801169209112e-26,
  3.394479897858000e-29,  1.552712872250004e+00, -1.842695085297050e-03, -4.044469464896257e-06, -1.862948588145373e-09,  2.136238434811061e-11,  7.439039414325557e-14,
  2.756401274135975e-17, -6.282679212141828e-19, -2.198949987913159e-21, -1.916029955104053e-25,  2.349334804944651e-26,  7.718365852716409e-29,  1.607019381147547e+00,
 -1.676076072817990e-03, -4.042927988849456e-06, -3.678337461116723e-09,  1.514738552061654e-11,  7.488632453969649e-14,  1.072238909501215e-16, -3.513815773498207e-19,
 -2.243786815805879e-21, -4.000715550564676e-24,  1.031021958389797e-26,  8.041139408531188e-29,  1.658641022761542e+00, -1.503088756798419e-03, -3.936326493291805e-06,
 -5.147421443050905e-09,  8.464117383780285e-12,  6.712304159696002e-14,  1.596254335161105e-16, -5.093686110821300e-20, -1.740575795072600e-21, -5.909066105014160e-24,
 -3.776569527613215e-27,  4.981030353141526e-29,  1.707345054606100e+00, -1.326816275851384e-03, -3.733619913537347e-06, -6.208043895600641e-09,  1.946663524092294e-12,
  5.294894708883051e-14,  1.795128043128665e-16,  2.061658044641783e-19, -9.093242292951203e-22, -5.649653256730336e-24, -1.329112482030430e-26,  5.966652699696058e-30,
  1.752911531954371e+00, -1.150407263194852e-03, -3.447384460413600e-06, -6.827863573135187e-09, -3.828860224669065e-12,  3.493018652187261e-14,  1.680496575417888e-16,
  3.713603787408637e-19, -3.051726022471197e-23, -3.733976888169769e-24, -1.558512080457563e-26, -2.850553091315272e-29,  1.795134364679129e+00, -9.770190618788735e-04,
 -3.093300618891601e-06, -7.006001839697225e-09, -8.402696368292421e-12,  1.592794128671277e-14,  1.320400176484988e-16,  4.242790906030668e-19,  6.465602670346458e-22,
 -1.152947487832724e-24, -1.148056755000186e-26, -4.040434613298480e-29,  1.833822313479968e+00, -8.097605095638803e-04, -2.689508448853348e-06, -6.772430494464316e-09,
 -1.147568628948404e-11, -1.350548633901251e-15,  8.205942994554148e-17,  3.745173030955347e-19,  9.755895416121903e-22,  1.063569582288138e-24, -4.277367939551526e-27,
 -3.057583527911433e-29,  1.868799919567050e+00, -6.516353602009430e-04, -2.255861014016363e-06, -6.185144849892577e-09, -1.293460058106018e-11, -1.475577808774182e-14,
  2.994032921084954e-17,  2.553937567890801e-19,  9.433851423069140e-22,  2.239415444623510e-24,  2.193689503038284e-27, -1.034784187514353e-29,  1.899908362249138e+00,
 -5.054874078245170e-04, -1.813106213447320e-06, -5.325328542251375e-09, -1.285594762469745e-11, -2.299153329224471e-14, -1.382078119408126e-17,  1.119872132623167e-19,
  6.524443197271591e-22,  2.245432370917252e-24,  5.416011512161168e-27,  6.902361758833101e-30,  1.927006239450398e+00, -3.739483532273816e-04, -1.382030496047121e-06,
 -4.290864381050199e-09, -1.148809921690352e-11, -2.575770892335914e-14, -4.216909682421386e-17, -1.280232604181348e-20,  2.667123484083754e-22,  1.439768742161399e-24,
  5.056542881437921e-27,  1.346823414055679e-29,  1.949970267301831e+00, -2.593894057847381e-04, -9.825997388074141e-07, -3.188668152449688e-09, -9.214044708503604e-12,
 -2.372154565734979e-14, -5.267138128574735e-17, -9.006906419614004e-20, -5.655153720228801e-23,  4.143275055949561e-25,  2.587702957136600e-27,  1.004003171862238e-29,
  1.968695898139394e+00, -1.638775326207603e-04, -6.331328364486921e-07, -2.126410151250579e-09, -6.499295146816064e-12, -1.832700001433259e-14, -4.755210680931745e-17,
 -1.113322220747363e-19, -2.227702711263466e-22, -3.157385977849622e-25,  6.639893975940518e-29,  2.825448664006741e-30,  1.983097870056637e+00, -8.913711117208811e-05,
 -3.495420711006017e-07, -1.204234785898644e-09, -3.831147634259395e-12, -1.147867951449038e-14, -3.263326830208805e-17, -8.807423182492850e-20, -2.243737819059839e-22,
 -5.318262844624313e-25, -1.135676999055911e-27, -2.007789057257532e-30,  1.993110796075123e+00, -3.651713556882680e-05, -1.446696467157258e-07, -5.070827604223563e-10,
 -1.656471830908659e-12, -5.157185641534985e-15, -1.547449338603324e-17, -4.501285691968097e-20, -1.272938496508470e-22, -3.502484512737979e-25, -9.367920711858635e-28,
 -2.428871209056713e-30,  1.998691242981440e+00, -6.956870429922163e-06, -2.771722623463417e-08, -9.807480818535705e-11, -3.249869563708098e-13, -1.032474040223393e-15,
 -3.184150326855853e-18, -9.602587220226513e-21, -2.844948553478405e-23, -8.305912066153119e-26, -2.394648847846494e-28, -6.827658442170760e-31,  5.354222871881900e-04,
 -2.787935733573623e-06,  1.088464036746714e-08, -3.776100135722841e-11,  1.227586213290479e-13, -3.829165750151150e-16,  1.160519914088363e-18, -3.443023116236103e-21,
  1.004707126347014e-23, -2.893056158110032e-26,  8.239080638624636e-29, -2.324455701655054e-31,  4.815574489500599e-03, -2.502261799934358e-05,  9.728561029702435e-08,
 -3.351471719706965e-10,  1.078078930751451e-12, -3.312960405027941e-15,  9.840456395174939e-18, -2.843669993028285e-20,  8.024363659751221e-23, -2.215437244480469e-25,
  5.988716326004858e-28, -1.584504082920867e-30,  1.335868311638293e-02, -6.912618480640836e-05,  2.665084541782833e-07, -9.051963296595798e-10,  2.849387296284645e-12,
 -8.487485372639224e-15,  2.414317745911890e-17, -6.578467965102516e-20,  1.714713205250532e-22, -4.250413295352980e-25,  9.891851603173269e-28, -2.104240154857761e-30,
  2.613040495510345e-02, -1.343725695390677e-04,  5.115239095918458e-07, -1.700134936359784e-09,  5.173635950930940e-12, -1.465281706549979e-14,  3.871078821487079e-17,
 -9.453688071287793e-20,  2.079484913506279e-22, -3.846801095467485e-25,  4.588593994141861e-28,  4.841848790943524e-31,  4.307934622061327e-02, -2.196864289214125e-04,
  8.221061953016551e-07, -2.652380946747536e-09,  7.693710357305587e-12, -2.020418852245372e-14,  4.723431668091530e-17, -9.282128822135393e-20,  1.236800995795811e-22,
  6.365099151452140e-26, -1.261855421556486e-27,  5.969090803993760e-30,  6.413720828802723e-02, -3.236594679308102e-04,  1.185203067017575e-06, -3.679152913437301e-09,
  9.999090064378733e-12, -2.346909868600146e-14,  4.410293675157381e-17, -4.609732513250636e-20, -1.016246037357111e-22,  8.584220270725008e-25, -3.496519900321490e-27,
  1.070838438658602e-29,  8.921898280863817e-02, -4.445719017309858e-04,  1.585410097172674e-06, -4.688158082932202e-09,  1.167335288001510e-11, -2.301317130320698e-14,
  2.598756378409596e-17,  4.625218070434770e-20, -4.220024519918046e-22,  1.681480962696832e-24, -4.781349513987911e-27,  9.463127234817641e-30,  1.182231968736733e-01,
 -5.804187945643448e-04,  2.005533452955259e-06, -5.584001181823397e-09,  1.234360269610636e-11, -1.792036849020265e-14, -7.003521664645011e-18,  1.681481818632507e-19,
 -7.300374385802618e-22,  2.062415212433405e-24, -3.613028866008816e-27, -7.722008455963759e-31,  1.510322090226632e-01, -7.289409519743718e-04,  2.427222341005256e-06,
 -6.274906259531250e-09,  1.172662532398901e-11, -8.002125218055480e-15, -5.088119325823265e-17,  2.890315692551028e-19, -8.881544048433606e-22,  1.587324745382554e-24,
  5.621466357215230e-28, -1.736438585955338e-29,  1.875125570036507e-01, -8.876599803458685e-04,  2.831649713572955e-06, -6.679318516174851e-09,  9.666810099760321e-12,
  6.100544208780358e-15, -9.818852338369926e-17,  3.708750071263587e-19, -7.776781686089401e-22,  1.271895562275318e-25,  6.667497541134047e-27, -3.169944858357703e-29,
  2.275153582760474e-01, -1.053917067004841e-03,  3.200217876962925e-06, -6.731953475077892e-09,  6.161605879902246e-12,  2.294285626083072e-14, -1.392395208621783e-16,
  3.784109524158594e-19, -3.494355070120211e-22, -2.019908761516713e-24,  1.209332517438129e-26, -3.298923643784556e-29,  2.708767642993037e-01, -1.224914975569504e-03,
  3.515264384813042e-06, -6.388887764332143e-09,  1.371449744033986e-12,  4.043224936944609e-14, -1.639761116463291e-16,  2.899600413905198e-19,  3.426646583149039e-22,
 -4.154205285058615e-24,  1.369023995285057e-26, -1.474321682003348e-29,  3.174184696673119e-01, -1.397762695564341e-03,  3.760743098338423e-06, -5.631338297840339e-09,
 -4.387386370859471e-12,  5.609721017856022e-14, -1.640934582928406e-16,  1.058559732635507e-19,  1.139629707610432e-21, -5.385541271786968e-24,  9.306671116285789e-27,
  1.966206732500892e-29,  3.669482771253547e-01, -1.569522133297458e-03,  3.922855598610792e-06, -4.467852455684176e-09, -1.066687878479978e-11,  6.743380024810926e-14,
 -1.350057187577730e-16, -1.481336610311417e-19,  1.812038575896804e-21, -4.969775395839094e-24, -8.356299816885489e-28,  5.607976916565432e-29,  4.192607194393450e-01,
 -1.737256183576887e-03,  3.990609268301343e-06, -2.934727179474600e-09, -1.692636663969917e-11,  7.228144043617259e-14, -7.722970108990767e-17, -4.238538789177350e-19,
  2.124276839595944e-21, -2.646951186396362e-24, -1.367339246758724e-26,  7.499782992479965e-29,  4.741377389722463e-01, -1.898077480039872e-03,  3.956280325911765e-06,
 -1.094584627352894e-09, -2.258318641831245e-11,  6.917281198131177e-14,  3.144178753704466e-18, -6.601225047419001e-19,  1.910352247953618e-21,  1.160139950464119e-24,
 -2.414788035244812e-26,  6.138359318285555e-29,  5.313494256564413e-01, -2.049197086831074e-03,  3.815762873342174e-06,  9.668500296507192e-10, -2.707000079100472e-11,
  5.760391865847367e-14,  9.505954523202829e-17, -7.965507705552127e-19,  1.137403428101805e-21,  5.389366688463115e-24, -2.717830404891699e-26,  1.410291431910431e-29,
  5.906548138303843e-01, -2.187972367317108e-03,  3.568788559612142e-06,  3.145603975882895e-09, -2.989312574410973e-11,  3.817961446457622e-14,  1.841379899918547e-16,
 -7.886333969044650e-19, -6.541917167120671e-23,  8.641094433456785e-24, -1.999133571217510e-26, -5.056734733974926e-29,  6.518027381307114e-01, -2.311953247750466e-03,
  3.219005692843087e-06,  5.325667803557519e-09, -3.068584085815700e-11,  1.260625710760948e-14,  2.551047537456839e-16, -6.203210756521391e-19, -1.425876053817028e-21,
  9.652516260338733e-24, -3.751933173482901e-27, -1.043361717277773e-28,  7.145327482953427e-01, -2.418926086603688e-03,  2.773911442816682e-06,  7.386185855558511e-09,
 -2.925095752683923e-11, -1.647547617895016e-14,  2.945682142936487e-16, -3.106435281889527e-19, -2.594211194143824e-21,  7.779831648206711e-24,  1.636618028766779e-26,
 -1.196388728293585e-28,  7.785760823381535e-01, -2.506954364973479e-03,  2.244636031734101e-06,  9.209171547748624e-09, -2.558781754275600e-11, -4.580111112560346e-14,
  2.936280376742624e-16,  8.776875747177733e-20, -3.239020744051275e-21,  3.302910254228146e-24,  3.290116950298309e-26, -8.384600971065919e-29,  8.436566971016568e-01,
 -2.574415431222376e-03,  1.645583347471817e-06,  1.068724264883701e-08, -1.990033573721283e-11, -7.189759989064022e-14,  2.497901490726306e-16,  4.984845321058313e-19,
 -3.145946283154006e-21, -2.581768411870664e-24,  3.903426647480664e-26, -7.503016163357517e-30,  9.094923546821813e-01, -2.620032564972593e-03,  9.939380429364126e-07,
  1.173085280078201e-08, -1.258456066242273e-11, -9.154720408966835e-14,  1.677757105665191e-16,  8.374956042900988e-19, -2.288668570506250e-21, -8.105170604730063e-24,
  3.153035216536755e-26,  7.844897356215509e-29,  9.757957626548621e-01, -2.642901672590946e-03,  3.090546979425241e-07,  1.227451185275196e-08, -4.196330362885688e-12,
 -1.022342158636980e-13,  5.900990950643304e-17,  1.032207361107592e-18, -8.482984589594179e-22, -1.150404536586209e-23,  1.237216681883798e-26,  1.360976391841830e-28,
  1.042275765407546e+00, -2.642511989043592e-03, -3.882502068420676e-07,  1.228153962161567e-08,  4.598266808921536e-12, -1.025084330615837e-13, -6.017107093890540e-17,
  1.038625799829734e-18,  8.279365921410598e-22, -1.163343032133316e-23, -1.173714295891578e-26,  1.385271705718512e-28,  1.108638583229081e+00, -2.618760239764835e-03,
 -1.076478150237961e-06,  1.174698379668514e-08,  1.308498277702687e-11, -9.220909630546810e-14, -1.712990277151046e-16,  8.523964413833691e-19,  2.319152684328147e-21,
 -8.387495161685907e-24, -3.191692308076542e-26,  8.334785233260987e-29,  1.174589095095802e+00, -2.571957810889234e-03, -1.734271102315121e-06,  1.069844864795808e-08,
  2.056989529778979e-11, -7.251184324640972e-14, -2.570333624889838e-16,  5.107201211386556e-19,  3.248244421706520e-21, -2.763889861802643e-24, -4.067986496883948e-26,
 -5.407605313867288e-30,  1.239832160369402e+00, -2.502830586296007e-03, -2.341244761947906e-06,  9.194720292331358e-09,  2.644722831599925e-11, -4.578665799997062e-14,
 -3.042807316939749e-16,  8.438166347895978e-20,  3.389146445598251e-21,  3.464640022273797e-24, -3.500153255889589e-26, -8.843610647973139e-29,  1.304073973870551e+00,
 -2.412511234353064e-03, -2.878798923859699e-06,  7.322227669525730e-09,  3.025928394938935e-11, -1.528312313510630e-14, -3.065616274875534e-16, -3.383683490012861e-19,
  2.730794053826959e-21,  8.359169095246743e-24, -1.753205632075844e-26, -1.299661589091502e-28,  1.367023448038100e+00, -2.302523864416957e-03, -3.330871127940406e-06,
  5.189535546651306e-09,  3.174189617343628e-11,  1.531382678771190e-14, -2.651453378724699e-16, -6.721992957270353e-19,  1.477507587719755e-21,  1.048202634007953e-23,
  4.599549185862506e-27, -1.146731664483384e-28,  1.428393615137443e+00, -2.174761120863395e-03, -3.684600910689242e-06,  2.920215270060176e-09,  3.085021311157922e-11,
  4.239335393884933e-14, -1.887133919532762e-16, -8.542922796092528e-19, -1.463485374903710e-23,  9.375098510458286e-24,  2.285625455595140e-26, -5.408561693425614e-29,
  1.487903041759052e+00, -2.031453937935742e-03, -3.930874622108947e-06,  6.445689009782933e-10,  2.776165189964976e-11,  6.291742021482415e-14, -9.160776035692115e-17,
 -8.582083149276877e-19, -1.345442371389295e-21,  5.672817988298532e-24,  3.085735758925530e-26,  2.055766718862122e-29,  1.545277247165776e+00, -1.875134338703262e-03,
 -4.064724861652984e-06, -1.509218156222228e-09,  2.285534158550915e-11,  7.483288129925336e-14,  8.987675819801844e-18, -6.985566992949730e-19, -2.188118278664540e-21,
  8.155493215415568e-25,  2.684712271316375e-26,  7.482328378743204e-29,  1.600250116422598e+00, -1.708591822119650e-03, -4.085564020980158e-06, -3.423861153706111e-09,
  1.667000632613146e-11,  7.733339011921789e-14,  9.635894666034262e-17, -4.254005132869190e-19, -2.379515484476660e-21, -3.515246751581517e-24,  1.401826291989871e-26,
  8.796120312315405e-29,  1.652565298692862e+00, -1.534824039357597e-03, -3.997238021477357e-06, -5.001048327370049e-09,  9.844739429538208e-12,  7.093044580221678e-14,
  1.573872615278640e-16, -1.100635776057999e-19, -1.955462738853315e-21, -6.012948787344446e-24, -1.333397417211323e-27,  6.136272030076137e-29,  1.701977580628297e+00,
 -1.356982609761466e-03, -3.807893850804025e-06, -6.168189461885315e-09,  3.049175318703458e-12,  5.732304640312546e-14,  1.848467658131446e-16,  1.737112825331852e-19,
 -1.122195490524829e-21, -6.173543268964685e-24, -1.283850462143406e-26,  1.487476930128256e-29,  1.748254224434126e+00, -1.178315063244514e-03, -3.529662620456443e-06,
 -6.883313838400867e-09, -3.089083444322252e-12,  3.908791647104490e-14,  1.784129963036370e-16,  3.681103238181209e-19, -1.764580198488258e-22, -4.381792780833767e-24,
 -1.678663841380123e-26, -2.588804984188844e-29,  1.791176259972289e+00, -1.002104015102388e-03, -3.178168218504572e-06, -7.137720250124403e-09, -8.051473764992880e-12,
  1.924175583914245e-14,  1.442025991292735e-16,  4.442127586529191e-19,  5.963513019476589e-22, -1.648643470559359e-24, -1.332627771606109e-26, -4.342817157836184e-29,
  1.830539720193340e+00, -8.316047765447780e-04, -2.771879815518082e-06, -6.956146928067194e-09, -1.148213521629941e-11,  7.482773616150530e-16,  9.298848348255626e-17,
  4.063130430189053e-19,  1.010460579638385e-21,  8.640751199547247e-25, -5.735112032399163e-27, -3.575927318141607e-29,  1.866156809282891e+00, -6.699826756400315e-04,
 -2.331334079423305e-06, -6.394417847813106e-09, -1.322193328254486e-11, -1.394791152954362e-14,  3.752622593453725e-17,  2.868879662091417e-19,  1.025464165844625e-21,
  2.316986453940755e-24,  1.657154538451712e-27, -1.415322146670299e-29,  1.897856993210555e+00, -5.202514051786290e-04, -1.878259556699953e-06, -5.534719262336938e-09,
 -1.331882877570272e-11, -2.328316889720550e-14, -1.038039041740871e-17,  1.342011922479256e-19,  7.372504527929025e-22,  2.467904977998439e-24,  5.700929227714244e-27,
  5.982447790543842e-30,  1.925488002980359e+00, -3.852137229585426e-04, -1.434640904644578e-06, -4.478850294350283e-09, -1.201339782155517e-11, -2.677305507963389e-14,
 -4.239999766332944e-17, -3.398007325746954e-21,  3.223307666867084e-22,  1.654235812913862e-24,  5.675570379315405e-27,  1.467045395162828e-29,  1.948916742157793e+00,
 -2.674058024939284e-04, -1.021764185984208e-06, -3.339957859524937e-09, -9.701322025475575e-12, -2.501611198583346e-14, -5.521626026874772e-17, -9.161919290078898e-20,
 -3.966205960104782e-23,  5.271213920241315e-25,  3.063498707984803e-27,  1.162030044837733e-29,  1.968030093743386e+00, -1.690464590731126e-04, -6.592859902090565e-07,
 -2.233394276058780e-09, -6.877504361829029e-12, -1.950647421982368e-14, -5.077091376146047e-17, -1.186419678091733e-19, -2.340571630900874e-22, -3.103823516478147e-25,
  2.069645895302838e-28,  3.588036501859297e-30,  1.982735635922450e+00, -9.199231081105731e-05, -3.643683948023056e-07, -1.267413143844196e-09, -4.068757230622646e-12,
 -1.229230023966405e-14, -3.520280800804398e-17, -9.556946667724514e-20, -2.443587585965930e-22, -5.790477448574181e-25, -1.226051557185520e-27, -2.097689742286090e-30,
  1.992962373633622e+00, -3.769929124757461e-05, -1.509171314344852e-07, -5.344320751143284e-10, -1.763433940577252e-12, -5.544170011784124e-15, -1.679382936654175e-17,
 -4.929544953814800e-20, -1.406038415085105e-22, -3.899461080502518e-25, -1.050350793621075e-27, -2.739249156628456e-30,  1.998662964443516e+00, -7.183405823842428e-06,
 -2.892601781770405e-08, -1.034440407692358e-10, -3.464229555553044e-13, -1.112225821172120e-15, -3.466231183183844e-18, -1.056272191328654e-20, -3.161952416905411e-23,
 -9.326681367709974e-26, -2.716448869682168e-28, -7.823608715737241e-31,  5.244418750478075e-04, -2.702638320715420e-06,  1.044304526791167e-08, -3.585664888606091e-11,
  1.153711895888971e-13, -3.561855627254268e-16,  1.068464204126670e-18, -3.137564250945239e-21,  9.062508830778438e-24, -2.583061787915820e-26,  7.281809449792896e-29,
 -2.033668206937753e-31,  4.717015523529448e-03, -2.426013189740743e-05,  9.336519409561724e-08, -3.184154163781729e-10,  1.014118406662438e-12, -3.086061229181224e-15,
  9.079011140437969e-18, -2.599202243665246e-20,  7.268296128119265e-23, -1.989272004307678e-25,  5.332970174142813e-28, -1.400133727784989e-30,  1.308637479491282e-02,
 -6.703680426296250e-05,  2.559141379585201e-07, -8.609332631685754e-10,  2.685285897207559e-12, -7.929546595664694e-15,  2.237577866842455e-17, -6.053496258429707e-20,
  1.568602192810238e-22, -3.872723743525300e-25,  9.005595869392284e-28, -1.926168343893613e-30,  2.560097180696519e-02, -1.303605994590375e-04,  4.916094496350418e-07,
 -1.619651619632967e-09,  4.889659621452863e-12, -1.375478326692648e-14,  3.615486006330766e-17, -8.810052551615022e-20,  1.944347882324676e-22, -3.659791623155340e-25,
  4.743342675362559e-28,  2.294740414275369e-31,  4.221355553749485e-02, -2.132348312697777e-04,  7.910030824932692e-07, -2.532453533234024e-09,  7.300754623268302e-12,
 -1.910130386630773e-14,  4.469100721288942e-17, -8.883610700936722e-20,  1.251236993048611e-22,  1.814645512792424e-26, -1.020122513439495e-27,  5.041862866556162e-30,
  6.286125784284134e-02, -3.143517582836114e-04,  1.141997840173960e-06, -3.522865463068912e-09,  9.540186465314173e-12, -2.242645676786721e-14,  4.277114238996287e-17,
 -4.888095418873760e-20, -7.312858476855727e-23,  7.276311517044875e-25, -3.051588234135417e-27,  9.532498861590354e-30,  8.746570989998367e-02, -4.321105121473785e-04,
  1.530257764270939e-06, -4.505032242906817e-09,  1.121942371543276e-11, -2.237540036737662e-14,  2.710240944617692e-17,  3.368053239810152e-20, -3.648121776152912e-22,
  1.498463223532529e-24, -4.372012270440602e-27,  9.124002492527597e-30,  1.159331905505392e-01, -5.646392288280335e-04,  1.939698571867564e-06, -5.389378376090214e-09,
  1.198388248572639e-11, -1.803452743056142e-14, -2.611466652564154e-18,  1.459470057628432e-19, -6.583955595281538e-22,  1.917702950158815e-24, -3.611233665510593e-27,
  7.873481134165260e-31,  1.481548083658074e-01, -7.098211916855665e-04,  2.353043732977855e-06, -6.088624248980119e-09,  1.155501048352522e-11, -9.129317895196037e-15,
 -4.317758928958094e-17,  2.615278368920350e-19, -8.307803739527074e-22,  1.595591005700515e-24, -1.234829679210712e-28, -1.388314975710130e-29,  1.840067195727309e-01,
 -8.653247520954162e-04,  2.752429526284853e-06, -6.523798025130613e-09,  9.766082374032158e-12,  3.865827570530176e-15, -8.815138314162417e-17,  3.461113798219630e-19,
 -7.686245559719680e-22,  3.671261266277580e-25,  5.357026558003958e-27, -2.789785316959006e-29,  2.233503842761652e-01, -1.028636748087847e-03,  3.120040513350546e-06,
 -6.629874913421802e-09,  6.587896952709886e-12,  1.972692635905972e-14, -1.288108437700857e-16,  3.661560917047324e-19, -4.137915043068505e-22, -1.564831818307594e-24,
  1.067071429801361e-26, -3.159250731159257e-29,  2.660328636776424e-01, -1.197099093987755e-03,  3.438755391058289e-06, -6.360686452398940e-09,  2.141403924984496e-12,
  3.659535389975820e-14, -1.557254534359317e-16,  2.986368437228218e-19,  2.028042239122679e-22, -3.620616115832548e-24,  1.296542684523661e-26, -1.801258506352855e-29,
  3.118871612188350e-01, -1.367948164502167e-03,  3.692782183627732e-06, -5.692773824395226e-09, -3.304563969250526e-12,  5.219847915083179e-14, -1.606475621614775e-16,
  1.392954458110105e-19,  9.526374103816214e-22, -4.998382849568251e-24,  9.993789166257174e-27,  1.177231907806807e-29,  3.607326107625632e-01, -1.538356545468396e-03,
  3.868261281249153e-06, -4.627910450125468e-09, -9.350906958083319e-12,  6.415027699048586e-14, -1.383685832666490e-16, -9.301280833948411e-20,  1.633094379259941e-21,
 -4.956623702935546e-24,  1.425268023975356e-27,  4.675422800420970e-29,  4.123753150583438e-01, -1.705476671112793e-03,  3.953814979787525e-06, -3.194088620825592e-09,
 -1.550019494821658e-11,  7.029310242775676e-14, -8.816097461881915e-17, -3.575008588071375e-19,  2.019923109809824e-21, -3.129433397556768e-24, -1.049088493745906e-26,
  6.948911608244494e-29,  4.666086378155446e-01, -1.866485814982779e-03,  3.941022974953310e-06, -1.444850019776329e-09, -2.120043689305105e-11,  6.903341100143372e-14,
 -1.447843307885399e-17, -5.985040673363039e-19,  1.935391200513872e-21,  2.492501285828307e-25, -2.137582224981098e-26,  6.424277886085539e-29,  5.232137527172196e-01,
 -2.018631849757167e-03,  3.824804753202990e-06,  5.430630946810522e-10, -2.589689271480105e-11,  5.962199134063754e-14,  7.329335989271455e-17, -7.572579630607841e-19,
  1.312035879699864e-21,  4.318354761283900e-24, -2.628475233161027e-26,  2.612156110494211e-29,  5.819602526434432e-01, -2.159279141223819e-03,  3.603692023079463e-06,
  2.673655309810689e-09, -2.908712898100173e-11,  4.233399066469940e-14,  1.620725886436083e-16, -7.859079241881799e-19,  2.307759625196747e-22,  7.801949860041040e-24,
 -2.184358076962664e-26, -3.378120566055699e-29,  6.426068222261344e-01, -2.285953895408787e-03,  3.279977247105420e-06,  4.837038013444746e-09, -3.037392275204208e-11,
  1.851550717587098e-14,  2.371489531776250e-16, -6.604269760803528e-19, -1.082158359033508e-21,  9.414475761657653e-24, -8.052074247188599e-27, -9.088882835773946e-29,
  7.049019766198785e-01, -2.396388236963033e-03,  2.859727943123252e-06,  6.915915453153037e-09, -2.951052258532770e-11, -9.519332878145144e-15,  2.847509345912597e-16,
 -3.890610323047257e-19, -2.303618806953385e-21,  8.329624535905387e-24,  1.114024635147993e-26, -1.173415258663638e-28,  7.685848690374352e-01, -2.488562263498461e-03,
  2.352660673153501e-06,  8.792821806581147e-09, -2.643323000879425e-11, -3.873614145188447e-14,  2.946541248910730e-16, -1.373087860635775e-20, -3.097350843352108e-21,
  4.541423165801424e-24,  2.893824577205216e-26, -9.568323973404222e-29,  8.333861691576500e-01, -2.560743296832182e-03,  1.771873442196463e-06,  1.035766392732933e-08,
 -2.127726665304109e-11, -6.574659638130476e-14,  2.623265022783600e-16,  3.966274583870510e-19, -3.210924463305152e-21, -1.033525597745842e-24,  3.821946334166470e-26,
 -2.924171276873944e-29,  8.990290139616969e-01, -2.611521540386551e-03,  1.133440467671258e-06,  1.151507887775592e-08, -1.437338301616842e-11, -8.724772508604704e-14,
  1.901581714869162e-16,  7.598394242991971e-19, -2.556977920627943e-21, -6.781195583788686e-24,  3.451054187712444e-26,  5.678885952795997e-29,  9.652300318869870e-01,
 -2.639841354687864e-03,  4.558787938424025e-07,  1.219109980789185e-08, -6.224528719087657e-12, -1.004746027781935e-13,  8.747016600748277e-17,  9.985425397186920e-19,
 -1.252118666314908e-21, -1.089227386702955e-23,  1.813791524034449e-26,  1.253279579703786e-28,  1.031700440404799e+00, -2.645027382341216e-03, -2.404981803619270e-07,
  1.233864201478662e-08,  2.536026513489150e-12, -1.036009565929726e-13, -3.078216938762538e-17,  1.058340356489860e-18,  4.021707290481789e-22, -1.197894037720524e-23,
 -5.495012880238102e-27,  1.444746770699856e-28,  1.098147216228455e+00, -2.626804792197366e-03, -9.343197453740352e-07,  1.194137495380737e-08,  1.120166444428423e-11,
 -9.602576933675652e-14, -1.464400534273770e-16,  9.215392722824819e-19,  1.995162230751390e-21, -9.584736896593228e-24, -2.779867466878662e-26,  1.034476608785348e-28,
  1.164274336347519e+00, -2.585312971531727e-03, -1.603963938325742e-06,  1.101563497838426e-08,  1.905918901124533e-11, -7.849739950331796e-14, -2.412951834001922e-16,
  6.127578524297369e-19,  3.119462184717479e-21, -4.388728282559516e-24, -4.038414000850416e-26,  1.900647931931027e-29,  1.229784086967507e+00, -2.521112076340155e-03,
 -2.228400686268954e-06,  9.610154323210598e-09,  2.545872294765347e-11, -5.304868276449544e-14, -3.003829261009565e-16,  1.945524342280336e-19,  3.487776727390936e-21,
  1.991433565710480e-24, -3.853636604508375e-26, -7.163294575555036e-29,  1.294378436225307e+00, -2.435181954133366e-03, -2.788038690710134e-06,  7.803528116551257e-09,
  2.987933147118533e-11, -2.274414646530584e-14, -3.147683354408104e-16, -2.463145874099019e-19,  3.017723752456088e-21,  7.543668686903596e-24, -2.323174132516754e-26,
 -1.284198004882273e-28,  1.357760465263796e+00, -2.328913080939141e-03, -3.265540509440260e-06,  5.699504049451013e-09,  3.198304237518402e-11,  8.730172077558435e-15,
 -2.832480712391587e-16, -6.188560117568596e-19,  1.856919083549090e-21,  1.056104911609420e-23, -7.444697932448981e-28, -1.278499911920135e-28,  1.419635850905154e+00,
 -2.204089303759228e-03, -3.646569546716880e-06,  3.420347404452738e-09,  3.165085251383763e-11,  3.757745544650498e-14, -2.125881648244408e-16, -8.491890906583936e-19,
  3.386986836245612e-22,  1.023592424119318e-23,  2.003964174507936e-26, -7.403733799541554e-29,  1.479714391786125e+00, -2.062862349618581e-03, -3.920433560697657e-06,
  1.098694406915851e-09,  2.899604371327217e-11,  6.042580810919039e-14, -1.162079427487096e-16, -8.977552089699259e-19, -1.118826846813444e-21,  6.920637391733976e-24,
  3.141565876601680e-26,  4.364972588169909e-30,  1.537711568439067e+00, -1.907718249626544e-03, -4.080591957582468e-06, -1.131554502105503e-09,  2.435253117815881e-11,
  7.480599292883249e-14, -1.154626039356730e-17, -7.678931028693620e-19, -2.138646720089989e-21,  1.953965837895322e-24,  3.003583335068681e-26,  6.961811859014362e-29,
  1.593350126453598e+00, -1.741436027038782e-03, -4.124998598601012e-06, -3.144646264075141e-09,  1.823879051746812e-11,  7.949435306624963e-14,  8.336350083376876e-17,
 -5.034538809030430e-19, -2.495020536337390e-21, -2.875160825109023e-24,  1.803156410297328e-26,  9.420417845039341e-29,  1.646361670571612e+00, -1.567039206938070e-03,
 -4.056258030697351e-06, -4.831979569763960e-09,  1.130083427079605e-11,  7.466348751544828e-14,  1.533968502040871e-16, -1.761066451836465e-19, -2.172206068032263e-21,
 -6.008743893468482e-24,  1.632141573394091e-27,  7.350855611856564e-29,  1.696488256392980e+00, -1.387740915581425e-03, -3.881580785175665e-06, -6.109988351117526e-09,
  4.240371591934180e-12,  6.181346904934173e-14,  1.891738285758151e-16,  1.341474093176639e-19, -1.353502053067371e-21, -6.671006145695276e-24, -1.195769659480742e-26,
  2.543949770650927e-29,  1.743483965341418e+00, -1.206883542560613e-03, -3.612532377343057e-06, -6.926248965309408e-09, -2.263675054786226e-12,  4.349272493570906e-14,
  1.886163813802108e-16,  3.598079965486138e-19, -3.465537617949048e-22, -5.074953155581268e-24, -1.784167692540600e-26, -2.180567586829735e-29,  1.787116447702004e+00,
 -1.027874130932991e-03, -3.264580482670223e-06, -7.263272842278242e-09, -7.631011651681499e-12,  2.285397149938623e-14,  1.568980439332369e-16,  4.622397172116574e-19,
  5.269374489422506e-22, -2.220700291279084e-24, -1.529504822368861e-26, -4.596236624028705e-29,  1.827168417936322e+00, -8.541168313175965e-04, -2.856454966261209e-06,
 -7.139616175979033e-09, -1.144391191560864e-11,  3.120203054784632e-15,  1.048222774420830e-16,  4.390980396815665e-19,  1.037044096936898e-21,  6.015806094174409e-25,
 -7.430473869829282e-27, -4.136834478115431e-29,  1.863439086154547e+00, -6.889438975670353e-04, -2.409345438677730e-06, -6.608148713102618e-09, -1.349121506450863e-11,
 -1.294710217396458e-14,  4.603112025059625e-17,  3.210489033946329e-19,  1.109907205343301e-21,  2.369539382966061e-24,  9.374936363028771e-28, -1.868516261079289e-29,
  1.895745509637077e+00, -5.355468063500658e-04, -1.945970202540079e-06, -5.751558039176049e-09, -1.378666494717641e-11, -2.348445709073615e-14, -6.278795872349009e-18,
  1.592592247689654e-19,  8.302598615821857e-22,  2.700839966691527e-24,  5.935869607687067e-27,  4.614552896529874e-30,  1.923923848774178e+00, -3.969091437083650e-04,
 -1.489558243717934e-06, -4.675403648564005e-09, -1.255903636623804e-11, -2.779057458130657e-14, -4.234146516054428e-17,  7.914516180792421e-21,  3.861284467591991e-22,
  1.894521354107001e-24,  6.347389072967892e-27,  1.586187763123341e-29,  1.947830513108010e+00, -2.757429112152726e-04, -1.062791753469250e-06, -3.499254466415587e-09,
 -1.021510462362364e-11, -2.637221129406959e-14, -5.779633893575640e-17, -9.256007628346602e-20, -1.835212075046864e-23,  6.603985625881686e-25,  3.613407497982793e-27,
  1.341205556444964e-29,  1.967343186912684e+00, -1.744298506868641e-04, -6.867600537928797e-07, -2.346622731824718e-09, -7.280092363150351e-12, -2.076569646149302e-14,
 -5.419941300387410e-17, -1.263086554304414e-19, -2.450415295465253e-22, -2.986873327754439e-25,  3.845018186788894e-28,  4.510545014451090e-30,  1.982361738874072e+00,
 -9.496921948946399e-05, -3.799762173621615e-07, -1.334526858002506e-09, -4.323273310447730e-12, -1.317018217827193e-14, -3.799142813961295e-17, -1.037321254898294e-19,
 -2.661096870817899e-22, -6.299583917003445e-25, -1.320001734045947e-27, -2.169080670493236e-30,  1.992809120489240e+00, -3.893276926447120e-05, -1.575033373881569e-07,
 -5.635564631277573e-10, -1.878462345663217e-12, -5.964306878135986e-15, -1.823926206883118e-17, -5.402773182678474e-20, -1.554281086399280e-22, -4.344709702701300e-25,
 -1.178451573825352e-27, -3.090721182278549e-30,  1.998633760006896e+00, -7.419875227841785e-06, -3.020135190086830e-08, -1.091693868096047e-10, -3.695239280653803e-13,
 -1.199081959437002e-15, -3.776673054384279e-18, -1.163043473854692e-20, -3.518130575264598e-23, -1.048538096346895e-25, -3.085447377143679e-28, -8.977115170618722e-31,
  5.137957289838825e-04, -2.620784229251053e-06,  1.002361046598219e-08, -3.406633555620343e-11,  1.084969595335018e-13, -3.315647129388201e-16,  9.845365225779869e-19,
 -2.861897286347194e-21,  8.182949510953825e-24, -2.308917734200998e-26,  6.443743159897398e-29, -1.781637339957945e-31,  4.621445022806121e-03, -2.352822305952729e-05,
  8.963956535054673e-08, -3.026716954366278e-10,  9.545185255916630e-13, -2.876641932610141e-15,  8.382748554242424e-18, -2.377675021836913e-20,  6.589115934972271e-23,
 -1.787782699728463e-25,  4.753279218228756e-28, -1.238291937111195e-30,  1.282225778863463e-02, -6.503009742432587e-05,  2.458355857107401e-07, -8.192088045038924e-10,
  2.531930736509685e-12, -7.412313086213775e-15,  2.074902579760119e-17, -5.573171491441556e-20,  1.435468461153763e-22, -3.528952740820238e-25,  8.195046949910860e-28,
 -1.760135237614075e-30,  2.508727391724564e-02, -1.265041577573623e-04,  4.726341098227199e-07, -1.543571511297379e-09,  4.623044892952995e-12, -1.291597736837867e-14,
  3.377319765777759e-17, -8.208573847023938e-20,  1.816029202505301e-22, -3.468659506790713e-25,  4.798826901626249e-28,  3.109961589835786e-32,  4.137308256094973e-02,
 -2.070264072336946e-04,  7.613020921613594e-07, -2.418640228381576e-09,  6.929255247264106e-12, -1.805811584532442e-14,  4.225969613558352e-17, -8.482915243168313e-20,
  1.250937162364926e-22, -1.846488073728838e-26, -8.162419592381205e-28,  4.245573745401196e-30,  6.162185865631709e-02, -3.053823119019142e-04,  1.100624690439358e-06,
 -3.373755408939345e-09,  9.101810275205765e-12, -2.141661440246579e-14,  4.137348870271261e-17, -5.082471072757662e-20, -4.903288433979403e-23,  6.136325426970660e-25,
 -2.656171638204348e-27,  8.457481068433412e-30,  8.576141385688150e-02, -4.200816736771192e-04,  1.477259789569409e-06, -4.329065888444656e-09,  1.077849006337440e-11,
 -2.171489638513538e-14,  2.788990205797126e-17,  2.283668363222585e-20, -3.139197037629855e-22,  1.331489393830931e-24, -3.979855876876673e-27,  8.688378602411993e-30,
  1.137052637852703e-01, -5.493770982269883e-04,  1.876164573949199e-06, -5.200523838669910e-09,  1.162288415590332e-11, -1.805048239878311e-14,  1.190268649979047e-18,
  1.259551567197767e-19, -5.919465343002152e-22,  1.774321370698872e-24, -3.549183932407443e-27,  1.977538886659016e-30,  1.453527139817327e-01, -6.912859670530632e-04,
  2.281083321938801e-06, -5.905258639306462e-09,  1.136263934871305e-11, -1.008065777368014e-14, -3.621837756882253e-17,  2.358598327325384e-19, -7.735668161401061e-22,
  1.579351135054886e-24, -6.666631658325882e-28, -1.088284404313953e-29,  1.805889673851216e-01, -8.436157966705425e-04,  2.675083681868993e-06, -6.367033878991285e-09,
  9.823013267061396e-12,  1.863722084767046e-15, -7.880234015895047e-17,  3.217658785035916e-19, -7.518369798721682e-22,  5.579307041596648e-25,  4.209352287610174e-27,
 -2.430812255980645e-29,  2.192852566294655e-01, -1.003992837158079e-03,  3.041126937629589e-06, -6.521476765053131e-09,  6.952343376092114e-12,  1.675694911117292e-14,
 -1.187517489514283e-16,  3.520931093569516e-19, -4.627729504238805e-22, -1.165295133804562e-24,  9.319372355887985e-27, -2.977519261656887e-29,  2.612990048697695e-01,
 -1.169893727027341e-03,  3.362656231352166e-06, -6.320768944257682e-09,  2.836617494356992e-12,  3.295890144002895e-14, -1.472916558760951e-16,  3.031396023730258e-19,
  8.159946182789175e-23, -3.118569917050960e-24,  1.212086310951871e-26, -2.021480799091445e-29,  3.064740192589008e-01, -1.338679981030605e-03,  3.624185435782830e-06,
 -5.737503189694783e-09, -2.298816771625523e-12,  4.839302218055632e-14, -1.563470040549643e-16,  1.669788150739897e-19,  7.799971382443121e-22, -4.590325196782731e-24,
  1.036040842391497e-26,  5.086938097187264e-30,  3.546407215763227e-01, -1.507635042034510e-03,  3.811870421325297e-06, -4.767442131115140e-09, -8.101291009951225e-12,
  6.080391957070904e-14, -1.402680398947019e-16, -4.359393535579838e-20,  1.456153785730412e-21, -4.861109757857533e-24,  3.286119381586472e-27,  3.792702213737560e-29,
  4.056164208506658e-01, -1.674003577499070e-03,  3.914043909692294e-06, -3.430963078879983e-09, -1.411626504900711e-11,  6.806431594336429e-14, -9.728355291558924e-17,
 -2.947409902099981e-19,  1.900430416651839e-21, -3.489742662709123e-24, -7.570999223534908e-27,  6.312101366889630e-29,  4.592056331117980e-01, -1.835032645722589e-03,
  3.921695018403547e-06, -1.773036115982218e-09, -1.982456472145664e-11,  6.849183214403126e-14, -3.036928714305377e-17, -5.365874488455972e-19,  1.929658380075435e-21,
 -5.488891530970947e-25, -1.852581007757459e-26,  6.498010115606865e-29,  5.152004536428521e-01, -1.988014297446887e-03,  3.828875049255532e-06,  1.383407824288919e-10,
 -2.468855484001819e-11,  6.113147407424684e-14,  5.269986715140403e-17, -7.129859292512032e-19,  1.448876336618811e-21,  3.292961871899527e-24, -2.491465409247497e-26,
  3.576614799498494e-29,  5.733809872657849e-01, -2.130329115599723e-03,  3.633012127043706e-06,  2.215238563710430e-09, -2.820332879374593e-11,  4.596075564380817e-14,
  1.402115608336105e-16, -7.742004270488570e-19,  4.956035101064188e-22,  6.903177583465780e-24, -2.298112837002934e-26, -1.814766124232521e-29,  6.335158422713532e-01,
 -2.259490131193077e-03,  3.335119011294679e-06,  4.354320619116692e-09, -2.994821361131391e-11,  2.398157625517966e-14,  2.182226547883523e-16, -6.897030381464290e-19,
 -7.499601506558644e-22,  9.016636090655784e-24, -1.173381973011445e-26, -7.633256275324132e-29,  6.953626935805891e-01, -2.373186488414399e-03,  2.939880827947926e-06,
  6.442591463597381e-09, -2.963349327286504e-11, -2.824084937613449e-15,  2.728708394410403e-16, -4.579029871702319e-19, -1.996963303368149e-21,  8.673370893458555e-24,
  6.086999296581230e-27, -1.118675883226827e-28,  7.586689205838243e-01, -2.469326168889165e-03,  2.455612622679436e-06,  8.364076242579202e-09, -2.713732420331140e-11,
 -3.168009720425893e-14,  2.929081695433778e-16, -1.100152421784658e-19, -2.914063443346080e-21,  5.612086554273096e-24,  2.453564712787685e-26, -1.038223110584529e-28,
  8.231723248284497e-01, -2.546077026537127e-03,  1.894080516852721e-06,  1.000705384588488e-08, -2.252840078249146e-11, -5.932912810276392e-14,  2.719900707643989e-16,
  2.935747427793055e-19, -3.220977969892951e-21,  4.635652207509549e-25,  3.649193376922880e-26, -4.888635686467881e-29,  8.886019323014769e-01, -2.601905333389524e-03,
  1.270184808522722e-06,  1.127140014426928e-08, -1.607102494786934e-11, -8.243808488672553e-14,  2.102533752572224e-16,  6.743810761963004e-19, -2.775711305476507e-21,
 -5.357411868767149e-24,  3.651396823476890e-26,  3.419259191532578e-29,  9.546788844619428e-01, -2.635610996551658e-03,  6.015085187841933e-07,  1.207555489311669e-08,
 -8.210788158352913e-12, -9.804469321337760e-14,  1.148105186058400e-16,  9.523513684694012e-19, -1.629888310889711e-21, -1.006047895994760e-23,  2.334634055914874e-26,
  1.108540373565849e-28,  1.021117421407292e+00, -2.646358580852320e-03, -9.225949671305721e-08,  1.236261224244703e-08,  4.590257972437251e-13, -1.039830717244001e-13,
 -1.033527112100030e-18,  1.064280014095528e-18, -3.148809174915379e-23, -1.207085160496276e-23,  9.098184793604502e-28,  1.458971849650215e-28,  1.087625959595730e+00,
 -2.633703264465588e-03, -7.900118574377651e-07,  1.210505540268687e-08,  9.248129401229185e-12, -9.922380518980440e-14, -1.197964706016538e-16,  9.796582752396155e-19,
  1.631242449696702e-21, -1.060033010204050e-23, -2.285494247597232e-26,  1.207418681110783e-28,  1.153908265385518e+00, -2.597610869790481e-03, -1.469999447531288e-06,
  1.130771380414033e-08,  1.743277754854613e-11, -8.407147437565695e-14, -2.227664073858057e-16,  7.097430434128144e-19,  2.932659634709567e-21, -5.980039529223433e-24,
 -3.899982441216089e-26,  4.392497840905718e-29,  1.219664724289541e+00, -2.538471152818873e-03, -2.110671072327007e-06,  1.000861648157783e-08,  2.432616405648393e-11,
 -6.017983611211585e-14, -2.933643114229148e-16,  3.070050277232861e-19,  3.531014290172664e-21,  3.926703611810735e-25, -4.125416648860824e-26, -5.137230895835833e-29,
  1.284593704282571e+00, -2.457103604379946e-03, -2.691544284136054e-06,  8.277545753301013e-09,  2.934840293571455e-11, -3.037019187999169e-14, -3.202737196259163e-16,
 -1.455925974620259e-19,  3.271219452150427e-21,  6.502796858357707e-24, -2.876906293021826e-26, -1.225422387081715e-28,  1.348393009750121e+00, -2.354755118591323e-03,
 -3.194071539102176e-06,  6.212254433290773e-09,  3.208829890542535e-11,  1.731348188325948e-15, -2.996870891233004e-16, -5.533683890295790e-19,  2.235194681683514e-21,
  1.041546238046271e-23, -6.611090764661868e-27, -1.383037857818827e-28,  1.410761420750687e+00, -2.233089019149012e-03, -3.602463014900372e-06,  3.932488164746401e-09,
  3.234946229643178e-11,  3.219158254523637e-14, -2.361572612041484e-16, -8.323068623419502e-19,  7.207812465246611e-22,  1.096640902056923e-23,  1.633751452032157e-26,
 -9.421962644238906e-29,  1.471400310205736e+00, -2.094165103028742e-03, -3.904426240968210e-06,  1.572139084085700e-09,  3.017461396022776e-11,  5.733136493765729e-14,
 -1.418071387991310e-16, -9.293287937828697e-19, -8.470668419827637e-22,  8.175741666315587e-24,  3.120223487630832e-26, -1.448431457600901e-29,  1.530015329472213e+00,
 -1.940410562444390e-03, -4.091783465738083e-06, -7.299675492691017e-10,  2.584409869213098e-11,  7.426321068314859e-14, -3.399311889361427e-17, -8.349665742422722e-19,
 -2.045959802863402e-21,  3.214432653443457e-24,  3.292634220385589e-26,  6.121565426410341e-29,  1.586318150538611e+00, -1.774581876384031e-03, -4.160930624968939e-06,
 -2.840002769671321e-09,  1.984749597157833e-11,  8.131680412795057e-14,  6.813450245755226e-17, -5.848032298527076e-19, -2.584531196642662e-21, -2.069548614089818e-24,
  2.228123780529884e-26,  9.861503266446018e-29,  1.640028250875694e+00, -1.599718017596903e-03, -4.113106984521113e-06, -4.639021854340420e-09,  1.283047841508249e-11,
  7.827778612672218e-14,  1.474603240455265e-16, -2.490591311453140e-19, -2.386533025481768e-21, -5.875122851526278e-24,  5.139392436936899e-27,  8.592505314134980e-29,
  1.690874724833180e+00, -1.419085592357485e-03, -3.954451970485219e-06, -6.032004381770112e-09,  5.522320690370421e-12,  6.639359505449813e-14,  1.922868391712291e-16,
  8.690292626713076e-20, -1.601966549288779e-21, -7.123443195808074e-24, -1.057491316796205e-26,  3.769196350510401e-29,  1.738598103478159e+00, -1.236116809525501e-03,
 -3.695835166517740e-06, -6.955259573818863e-09, -1.347743790840716e-12,  4.813898665478883e-14,  1.985072911238310e-16,  3.456555804541980e-19, -5.423152057775345e-22,
 -5.806234616795508e-24, -1.868015173656342e-26, -1.600139541233662e-29,  1.782952162999005e+00, -1.054341451436692e-03, -3.352456575433444e-06, -7.381503364401650e-09,
 -7.135218813221428e-12,  2.677666431501996e-14,  1.700639406301030e-16,  4.777005220761191e-19,  4.354869093136974e-22, -2.873542663270058e-24, -1.736026193850836e-26,
 -4.776906485669787e-29,  1.823705700333697e+00, -8.773142797163829e-04, -2.943226462228795e-06, -7.322078597975516e-09, -1.135533517613472e-11,  5.787242476229993e-15,
  1.175844439614055e-16,  4.725689343362167e-19,  1.052896646038030e-21,  2.662239898289694e-25, -9.380835580676640e-27, -4.733627589395740e-29,  1.860644253611895e+00,
 -7.085395410993324e-04, -2.489946722005985e-06, -6.826016536298463e-09, -1.373836042298500e-11, -1.173039039429724e-14,  5.553059376930968e-17,  3.579363287504599e-19,
  1.195673837595219e-21,  2.389085993560608e-24,  9.609222004276110e-31, -2.402403630977507e-29,  1.893571744428826e+00, -5.513944284709506e-04, -2.016327940833214e-06,
 -5.975908807687284e-09, -1.425748389694585e-11, -2.357854338412308e-14, -1.432635352707215e-18,  1.874294158301873e-19,  9.318081871404177e-22,  2.941814071678634e-24,
  6.098853913933528e-27,  2.692915064076341e-30,  1.922312019057954e+00, -4.090534876910424e-04, -1.546887275353293e-06, -4.880849834336689e-09, -1.312498436949814e-11,
 -2.880264942179020e-14, -4.193626264591778e-17,  2.141225824033925e-20,  4.590726454005836e-22,  2.162715992096487e-24,  7.070640702563521e-27,  1.700028484029567e-29,
  1.946710266875681e+00, -2.844160285456625e-04, -1.105781109311207e-06, -3.666991942701078e-09, -1.075663014312173e-11, -2.779046698138949e-14, -6.039246300927970e-17,
 -9.273787051220051e-20,  8.171334224158930e-24,  8.173154249911997e-25,  4.247165897921420e-27,  1.543481602713286e-29,  1.966634298167992e+00, -1.800385812225285e-04,
 -7.156323530638155e-07, -2.466498615629461e-09, -7.708705240610821e-12, -2.210981797144146e-14, -5.784742695543193e-17, -1.343186533029333e-19, -2.554667825475626e-22,
 -2.790254481445827e-25,  6.066908708802955e-28,  5.623019153935547e-30,  1.981975679265654e+00, -9.807428279340018e-05, -3.964144294325726e-07, -1.405857006054329e-09,
 -4.596035224549336e-12, -1.411781402432310e-14, -4.101862786686242e-17, -1.126208695638459e-19, -2.897617350124757e-22, -6.846825998696886e-25, -1.416532767893196e-27,
 -2.213404532300454e-30,  1.992650825795013e+00, -4.022036683842938e-05, -1.644503622461773e-07, -5.945904584004772e-10, -2.002251408193076e-12, -6.420779297937038e-15,
 -1.982408814515730e-17, -5.926105695854974e-20, -1.719513506021530e-22, -4.844424425566204e-25, -1.323020270674883e-27, -3.488745036958127e-30,  1.998603588843139e+00,
 -7.666828539283733e-06, -3.154766649457778e-08, -1.152786606098366e-10, -3.944390191985780e-13, -1.293760729388150e-15, -4.118671361641259e-18, -1.281909378690858e-20,
 -3.918805740720102e-23, -1.180235261405013e-25, -3.509151880702474e-28, -1.031505707448776e-30,  5.034704218015532e-04, -2.542201514227406e-06,  9.625015400211424e-09,
 -3.238217744468871e-11,  1.020956129844544e-13, -3.088685949650641e-16,  9.079478611269133e-19, -2.612859741428413e-21,  7.396305905985121e-24, -2.066180095131991e-26,
  5.709065686935465e-29, -1.562887569341095e-31,  4.528743721423202e-03, -2.282537945164864e-05,  8.609727500049297e-08, -2.878489527752030e-10,  8.989448275307830e-13,
 -2.683212511225930e-15,  7.745576797176976e-18, -2.176764383245335e-20,  5.978464252010117e-23, -1.608116642298902e-25,  4.240376208847260e-28, -1.096112062131595e-30,
  1.256600946606495e-02, -6.310205716962264e-05,  2.362433394971099e-07, -7.798573474593760e-10,  2.388540475049415e-12, -6.932554774104942e-15,  1.925098113968185e-17,
 -5.133530564262639e-20,  1.314144173734252e-22, -3.216178034753347e-25,  7.454907021482892e-28, -1.606098651130751e-30,  2.458870387025987e-02, -1.227959381931032e-04,
  4.545466800027050e-07, -1.471626078927661e-09,  4.372648087884033e-12, -1.213235616224417e-14,  3.155430426414282e-17, -7.647053536501836e-20,  1.694611497919308e-22,
 -3.276911659608632e-25,  4.777471327025519e-28, -1.213593580945285e-31,  4.055697657392388e-02, -2.010502275642270e-04,  7.329318758860097e-07, -2.310607135762284e-09,
  6.578045199265360e-12, -1.707193422510186e-14,  3.994037904849797e-17, -8.084273791483030e-20,  1.238843934446942e-22, -4.758701002791616e-26, -6.448320395828459e-28,
  3.563293591279497e-30,  6.041768645096023e-02, -2.967368111507855e-04,  1.060999437785442e-06, -3.231499638597958e-09,  8.683291521679663e-12, -2.044088538287274e-14,
  3.993160898217589e-17, -5.206010620248501e-20, -2.876756692220432e-23,  5.145338007787080e-25, -2.305877708027230e-27,  7.480903289722391e-30,  8.410439840552102e-02,
 -4.084684915432729e-04,  1.426331520475571e-06, -4.160047864880561e-09,  1.035093182323902e-11, -2.103895753314249e-14,  2.839568443102100e-17,  1.352820577735354e-20,
 -2.687607469886817e-22,  1.179797770127618e-24, -3.608359653499929e-27,  8.189800478942877e-30,  1.115373832127680e-01, -5.346142727760104e-04,  1.814862179658710e-06,
 -5.017443055919246e-09,  1.126243502330525e-11, -1.798167745123621e-14,  4.461229341638688e-18,  1.080076644005849e-19, -5.306028191228432e-22,  1.634374461799329e-24,
 -3.441737630914878e-27,  2.860397225167907e-30,  1.426236229896936e-01, -6.733176778728329e-04,  2.211304231439546e-06, -5.725114348003927e-09,  1.115285447849953e-11,
 -1.087339481991801e-14, -2.995235462119953e-17,  2.120093651376406e-19, -7.172983796895802e-22,  1.543891868632452e-24, -1.087654093751901e-27, -8.322054588584276e-30,
  1.772568254177239e-01, -8.225180708019192e-04,  2.599623190042798e-06, -6.209667214887969e-09,  9.842090944624431e-12,  7.788028374773442e-17, -7.012647914426258e-17,
  2.980589276838953e-19, -7.289693521695489e-22,  7.059150406055245e-25,  3.214166461353156e-27, -2.097184951468651e-29,  2.153174503816347e-01, -9.799749370233513e-04,
  2.963547208477220e-06, -6.407709690109919e-09,  7.259771682115273e-12,  1.402350078114192e-14, -1.091062724776992e-16,  3.366825835778060e-19, -4.983239200664034e-22,
 -8.181212710287542e-25,  8.054605949472735e-27, -2.767838265698290e-29,  2.566727532366784e-01, -1.143295053661870e-03,  3.287100457910740e-06, -6.270298818535289e-09,
  3.461134143134957e-12,  2.952595123479977e-14, -1.387834112332074e-16,  3.040462944629303e-19, -2.216053649396846e-23, -2.651967726886965e-24,  1.119977271070811e-26,
 -2.151805697982361e-29,  3.011768494640838e-01, -1.309962450734697e-03,  3.555145994542707e-06, -5.766743612530707e-09, -1.368086961956859e-12,  4.469946961063963e-14,
 -1.513464290953919e-16,  1.893750123688450e-19,  6.222431442782183e-22, -4.173143265574934e-24,  1.045835752949559e-26, -4.517642561001666e-31,  3.486708060187802e-01,
 -1.477371028205432e-03,  3.753922928999256e-06, -4.887517392011099e-09, -6.918949289174418e-12,  5.742794378816815e-14, -1.408624224696402e-16,  2.314715513145251e-22,
  1.283899560743821e-21, -4.698745723101433e-24,  4.772568948414240e-27,  2.975749554861165e-29,  3.989827652047311e-01, -1.642859649453271e-03,  3.871561695451361e-06,
 -3.646062570672081e-09, -1.277896023994325e-11,  6.563723161692762e-14, -1.047041801301165e-16, -2.359904434142541e-19,  1.769999744006012e-21, -3.739035503858658e-24,
 -4.943812858384541e-27,  5.623737712802645e-29,  4.519281074227277e-01, -1.803749479765088e-03,  3.898560489471725e-06, -2.079315042992503e-09, -1.846319772202396e-11,
  6.758963028129226e-14, -4.453320665587296e-17, -4.752919767763789e-19,  1.897247305622520e-21, -1.232930894010924e-24, -1.568399902945044e-26,  6.392519932714173e-29,
  5.073096596103762e-01, -1.957383278649200e-03,  3.828205588440807e-06, -2.468330305647920e-10, -2.345486692587307e-11,  6.216204948979397e-14,  3.340182646949477e-17,
 -6.649142612814843e-19,  1.549885105217814e-21,  2.330170954274475e-24, -2.317154718398047e-26,  4.309246410991586e-29,  5.649179566190285e-01, -2.101166287425977e-03,
  3.656918376541795e-06,  1.771514524520953e-09, -2.725220857978617e-11,  4.906771711305724e-14,  1.187920665906975e-16, -7.545436023200140e-19,  7.274182126961255e-22,
  5.972240623746084e-24, -2.346276215034328e-26, -4.015449782616993e-30,  6.245315631293626e-01, -2.232608279359109e-03,  3.384512561780527e-06,  3.879264204924046e-09,
 -2.941778565035936e-11,  2.898476442633319e-14,  1.986231030235692e-16, -7.086050713930707e-19, -4.345788807889197e-22,  8.484524456832486e-24, -1.476207702937407e-26,
 -6.128167532394915e-29,  6.859174639750941e-01, -2.349366259713738e-03,  3.014346386651646e-06,  5.968355055774748e-09, -2.962556058372075e-11,  3.564028741017158e-15,
  2.592021364204853e-16, -5.167724578974576e-19, -1.681505648690252e-21,  8.820628814032234e-24,  1.335266261447428e-27, -1.037250652493074e-28,  7.488315308989242e-01,
 -2.449287219278460e-03,  2.553356679534088e-06,  7.925190957559675e-09, -2.770093134316844e-11, -2.469761028064455e-14,  2.885539131457245e-16, -1.998523301401275e-19,
 -2.695478420143400e-21,  6.500571877938418e-24,  1.985611604377589e-26, -1.082877081898053e-28,  8.130190737797802e-01, -2.530450259405665e-03,  2.011964435322395e-06,
  9.637464033503961e-09, -2.364909999191899e-11, -5.271434696512333e-14,  2.787716568372755e-16,  1.910476559717677e-19, -3.178581614711575e-21,  1.875013453328052e-24,
  3.395669654406884e-26, -6.587492094121245e-29,  8.782154842170684e-01, -2.591207322526692e-03,  1.403845287935712e-06,  1.100135405927122e-08, -1.766784893106800e-11,
 -7.717561687637463e-14,  2.278655572141152e-16,  5.827568746356294e-19, -2.941986506305856e-21, -3.873461117777889e-24,  3.751830201896823e-26,  1.151446706790141e-29,
  9.441469790060640e-01, -2.630221683111586e-03,  7.455627418085896e-07,  1.192865380071551e-08, -1.014199942048794e-11, -9.497547236031142e-14,  1.406930584514474e-16,
  8.945895874905348e-19, -1.974125573213996e-21, -9.034043385104337e-24,  2.784740331745111e-26,  9.328650406831549e-29,  1.010531450458400e+00, -2.646503284596119e-03,
  5.606731114779371e-08,  1.235332814076766e-08, -1.618472187086982e-12, -1.036507931145673e-13,  2.868700183468157e-17,  1.056339135427810e-18, -4.638414552586909e-22,
 -1.190666859291379e-23,  7.276319453184338e-27,  1.427398625592185e-28,  1.077079429683575e+00, -2.639439952962946e-03, -6.439293401863613e-07,  1.223700287757179e-08,
  7.237152975685192e-12, -1.017642153863658e-13, -9.169380770678685e-17,  1.025586459273882e-18,  1.234495267859067e-21, -1.140394436589620e-23, -1.722540611795826e-26,
  1.345126623060184e-28,  1.143495167824817e+00, -2.608823483034246e-03, -1.332689744459994e-06,  1.157290326651023e-08,  1.569954774303009e-11, -8.916899957572134e-14,
 -2.016142571370536e-16,  7.998467869783397e-19,  2.689830433610569e-21, -7.494105980201359e-24, -3.652498961108848e-26,  6.841891448728847e-29,  1.209477838813496e+00,
 -2.554869585033039e-03, -1.988273312122398e-06,  1.038782693809774e-08,  2.305292218812546e-11, -6.710465617621891e-14, -2.831864454225434e-16,  4.199011528533466e-19,
  3.514962713330030e-21, -1.296071537164173e-24, -4.301403172097095e-26, -2.819418377037541e-29,  1.274722865455482e+00, -2.478230702573336e-03, -2.589417688846417e-06,
  8.741842162102362e-09,  2.866386522209964e-11, -3.809364342397337e-14, -3.228512566743256e-16, -3.740045070119988e-20,  3.483331229244762e-21,  5.246925014775231e-24,
 -3.394887141055022e-26, -1.121545603190114e-28,  1.338923368584614e+00, -2.380000774606888e-03, -3.116444146430752e-06,  6.725548321285974e-09,  3.204978916221623e-11,
 -5.638646927595425e-15, -3.141241018505453e-16, -4.759059383429931e-19,  2.603903037042067e-21,  1.002697695048778e-23, -1.286423431547601e-26, -1.453027975630041e-28,
  1.401771736619091e+00, -2.261711117891213e-03, -3.552147381153554e-06,  4.454914393672081e-09,  3.293474356637477e-11,  2.624712860421474e-14, -2.590787426229159e-16,
 -8.028075454505837e-19,  1.126282500862716e-21,  1.153114564459073e-23,  1.175608261771011e-26, -1.138720405577120e-28,  1.462961310156713e+00, -2.125316756887305e-03,
 -3.882626593610082e-06,  2.063912110580607e-09,  3.128508518328039e-11,  5.361295667049852e-14, -1.681618754757150e-16, -9.514864319020401e-19, -5.304832371633759e-22,
  9.405000547896485e-24,  3.010619740544551e-26, -3.569141561228321e-29,  1.522188173281996e+00, -1.973172726465724e-03, -4.098013194759145e-06, -3.046322640369041e-10,
  2.731927310541660e-11,  7.315954500993869e-14, -5.826953459536333e-17, -8.983265036686029e-19, -1.905913142400883e-21,  4.582119557771318e-24,  3.537150597365287e-26,
  4.933680353663005e-29,  1.579153040087955e+00, -1.808000118847371e-03, -4.193051357319320e-06, -2.509349034359979e-09,  2.148880943223062e-11,  8.274613015634406e-14,
  5.059221741878218e-17, -6.685197391125897e-19, -2.641939246723801e-21, -1.090731372826754e-24,  2.667436337934377e-26,  1.006293925687877e-28,  1.633563221613224e+00,
 -1.632841936412843e-03, -4.167491241491804e-06, -4.421019994444888e-09,  1.443081432620817e-11,  8.172432650789466e-14,  1.393860321896203e-16, -3.287649693929889e-19,
 -2.593392771143089e-21, -5.590295036825676e-24,  9.191415099398959e-27,  9.819371237004035e-29,  1.685134655055570e+00, -1.451009139709471e-03, -4.026261246284881e-06,
 -5.932772813441441e-09,  6.896507575272102e-12,  7.103164607846974e-14,  1.939633259186361e-16,  3.145873467784059e-20, -1.865588767701321e-21, -7.509295329391001e-24,
 -8.616411414705422e-27,  5.159606786608901e-29,  1.733593973858740e+00, -1.266017635034299e-03, -3.779395045680736e-06, -6.968859130263985e-09, -3.365493342706756e-13,
  5.301714257873696e-14,  2.079102313020465e-16,  3.248116399640857e-19, -7.649398302284644e-22, -6.565382962665129e-24, -1.922059574258315e-26, -8.216685408450553e-30,
  1.778680594209375e+00, -1.081517314817167e-03, -3.441701193372421e-06, -7.491156260976184e-09, -6.557779041403810e-12,  3.102018050694049e-14,  1.836181223469507e-16,
  4.898427895887821e-19,  3.190304006800216e-22, -3.610308152112775e-24, -1.948384926778239e-26, -4.856520864379832e-29,  1.820148790765894e+00, -9.012146300226860e-04,
 -3.032177188867135e-06, -7.502680104441871e-09, -1.121027856936510e-11,  8.771865731127816e-15,  1.312889721745655e-16,  5.063383695498718e-19,  1.055208033766334e-21,
 -1.524827140479233e-25, -1.159983333790185e-26, -5.355818766273168e-29,  1.857769732224265e+00, -7.287905178456589e-04, -2.573185301038493e-06, -7.047631267278094e-09,
 -1.395880640695575e-11, -1.027298656306675e-14,  6.610139015319363e-17,  3.975718405358176e-19,  1.281410922628405e-21,  2.366218549197871e-24, -1.189637985169316e-27,
 -3.024543113570595e-29,  1.891333445776689e+00, -5.678158094984193e-04, -2.089423127845543e-06, -6.207801138918845e-09, -1.472895567216490e-11, -2.354648138564895e-14,
  4.249096276462084e-18,  2.189890360794829e-19,  1.042126842345684e-21,  3.187426910966870e-24,  6.162881676255900e-27,  9.483836148746373e-32,  1.920650678868036e+00,
 -4.216664808158400e-04, -1.606736658121277e-06, -5.095512458391741e-09, -1.371104460631219e-11, -2.980019127112102e-14, -4.111895251558448e-17,  3.740437468327282e-20,
  5.422044210054900e-22,  2.460814953363682e-24,  7.841811349175529e-27,  1.802941737331653e-29,  1.945554627385474e+00, -2.934412615943352e-04, -1.150836248333565e-06,
 -3.843624133452794e-09, -1.132714373090991e-11, -2.927098807752714e-14, -6.298079766789013e-17, -9.197145907341050e-20,  4.082220636654516e-23,  1.001434812867770e-24,
  4.975351545176607e-27,  1.770712200855340e-29,  1.965902503266482e+00, -1.858841628518378e-04, -7.459852125160211e-07, -2.593452198849764e-09, -8.165094430114361e-12,
 -2.354422015542890e-14, -6.172427214845235e-17, -1.426491192320040e-19, -2.650118613082616e-22, -2.494335053836880e-25,  8.826435755386042e-28,  6.960599416984656e-30,
  1.981576930864863e+00, -1.013143512987201e-04, -4.137354268822388e-07, -1.481706999478717e-09, -4.888496913009493e-12, -1.514117265471535e-14, -4.430561004530351e-17,
 -1.222987487490762e-19, -3.154537344197761e-22, -7.432967408724950e-25, -1.514221389668935e-27, -2.219649650442116e-30,  1.992487267151042e+00, -4.156506462116633e-05,
 -1.717819869023399e-07, -6.276802317919244e-10, -2.135562462546893e-12, -6.917107391874866e-15, -2.156312834301487e-17, -6.505306061824865e-20, -1.903820117828688e-22,
 -5.405619622029473e-25, -1.486237611178031e-27, -3.939458441018974e-30,  1.998572407851038e+00, -7.924852536388955e-06, -3.296974818678722e-08, -1.218021820196093e-10,
 -4.213325379839501e-13, -1.397061786631479e-15, -4.495820822031912e-18, -1.414389362101071e-20, -4.370089958200404e-23, -1.330119147305346e-25, -3.996357650643023e-28,
 -1.186923380318170e-30,  4.934531935408452e-04, -2.466728427446028e-06,  9.246030364794467e-09, -3.079690705002143e-11,  9.613035796789113e-14, -2.879296939922034e-16,
  8.379925778363637e-19, -2.387651510433470e-21,  6.691982123050061e-24, -1.850991932422434e-26,  5.064185503970230e-29, -1.372759760422805e-31,  4.438798223395285e-03,
 -2.215017750226057e-05,  8.272764751068806e-08, -2.738852527103576e-10,  8.470912416960845e-13, -2.504421649648713e-15,  7.162018780945707e-18, -1.994398126067261e-20,
  5.428945429197908e-23, -1.447767754290477e-25,  3.786170456059420e-28, -9.711038284838683e-31,  1.231732276516924e-02, -6.124890430009560e-05,  2.271098557281471e-07,
 -7.427252856408653e-10,  2.254395597780471e-12, -6.487315190823454e-15,  1.787076588899509e-17, -4.730967660705017e-20,  1.203562892091992e-22, -2.931688162623922e-25,
  6.779951505303433e-28, -1.463781446959461e-30,  2.410468267590152e-02, -1.192290316220135e-04,  4.372990652394094e-07, -1.403564456808051e-09,  4.137403683602006e-12,
 -1.140014495702674e-14,  2.948730062815232e-17, -7.123285314387216e-20,  1.580066234717484e-22, -3.087244219175385e-25,  4.697520236647021e-28, -2.365359631313974e-31,
  3.976432945971765e-02, -1.952959180861148e-04,  7.058249817440367e-07, -2.208038601381178e-09,  6.246011162215417e-12, -1.614008207543098e-14,  3.773199128560965e-17,
 -7.691052968355641e-20,  1.217431307267722e-22, -7.042298748700915e-26, -5.012136832350697e-28,  2.979991165131432e-30,  5.924747289723267e-02, -2.884015965101734e-04,
  1.023041714436884e-06, -3.095785942364877e-09,  8.283938860610929e-12, -1.950010649185085e-14,  3.846369952983531e-17, -5.270147048642019e-20, -1.182769180960631e-23,
  4.286155216802355e-25, -1.996461804754141e-27,  6.598590329652513e-30,  8.249303351293728e-02, -3.972547379616038e-04,  1.377390870094317e-06, -3.997762049144568e-09,
  9.936993459173622e-12, -2.035384920237935e-14,  2.866025987644473e-17,  5.580264424980408e-21, -2.288006149749195e-22,  1.042514774141644e-24, -3.259690558663083e-27,
  7.654596692029612e-30,  1.094275868796597e-01, -5.203331765124856e-04,  1.755722210414931e-06, -4.840114352094463e-09,  1.090410744206233e-11, -1.784018260937955e-14,
  7.256391170567814e-18,  9.194346226349613e-20, -4.742111880475106e-22,  1.499424134082184e-24, -3.301197823998712e-27,  3.490102028630597e-30,  1.399653022978130e-01,
 -6.558990327050860e-04,  2.143666235737991e-06, -5.548445505070340e-09,  1.092866566614143e-11, -1.152355889624947e-14, -2.432915034272384e-17,  1.899360260818137e-19,
 -6.625835321996208e-22,  1.493726647828503e-24, -1.404847712911414e-27, -6.157628213536856e-30,  1.740078789496361e-01, -8.020164727209920e-04,  2.526051787021186e-06,
 -6.052269953451138e-09,  9.827480672707537e-12, -1.507619044159544e-15, -6.210342029956057e-17,  2.751615794382577e-19, -7.014561743984347e-22,  8.169474170916543e-25,
  2.359731578341477e-27, -1.791307634269974e-29,  2.114444832176508e-01, -9.565721343556083e-04,  2.887360433602033e-06, -6.289448685178324e-09,  7.514810368191437e-12,
  1.151624860135213e-14, -9.990640720543321e-17,  3.203248188656124e-19, -5.222645064336510e-22, -5.196371252609916e-25,  6.886075104284754e-27, -2.541801617663133e-29,
  2.521516914734292e-01, -1.117298239195353e-03,  3.212208049775720e-06, -6.210374601636517e-09,  4.019033948763071e-12,  2.629714361769693e-14, -1.302937897176927e-16,
  3.018942204198171e-19, -1.097977540691716e-22, -2.223126818608689e-24,  1.023819621417249e-26, -2.208005516289494e-29,  2.959934432871714e-01, -1.281798391921314e-03,
  3.485842602226265e-06, -5.781676602946524e-09, -5.099801602782004e-13,  4.113289941632991e-14, -1.457871738871534e-16,  2.069636774073229e-19,  4.795224155197575e-22,
 -3.756597472123691e-24,  1.033635765467677e-26, -4.925800156464848e-30,  3.428210106782069e-01, -1.447576041465030e-03,  3.694645808806138e-06, -4.989215710489951e-09,
 -5.804173534573063e-12,  5.405181108324993e-14, -1.403059070244490e-16,  3.864905018536340e-20,  1.118476033120913e-21, -4.483894409903588e-24,  5.916041049284871e-27,
  2.235030462695543e-29,  3.924729897165757e-01, -1.612065543899391e-03,  3.826625036857783e-06, -3.840162644788563e-09, -1.149184729178378e-11,  6.305131320162770e-14,
 -1.105394330068675e-16, -1.815375868259252e-19,  1.632412303193291e-21, -3.889383078374747e-24, -2.625335419221323e-27,  4.913332335174607e-29,  4.447753214886352e-01,
 -1.772665722624171e-03,  3.871880650954820e-06, -2.363974338920310e-09, -1.712313578180539e-11,  6.636795045805233e-14, -5.699891939480992e-17, -4.154058467353485e-19,
  1.842241476099902e-21, -1.804681795919353e-24, -1.292188832458035e-26,  6.141198215229250e-29,  4.995413501441067e-01, -1.926775766912662e-03,  3.823033075840139e-06,
 -6.121276457025167e-10, -2.220508825308921e-11,  6.274595772683715e-14,  1.548993319308505e-17, -6.141508324130598e-19,  1.617560137927123e-21,  1.442895992169155e-24,
 -2.115479425947059e-26,  4.823140038188524e-29,  5.565719264331613e-01, -2.071833244763325e-03,  3.675593205775527e-06,  1.343477793385679e-09, -2.624404103302412e-11,
  5.166802258550044e-14,  9.802175858661746e-17, -7.280074583092190e-19,  9.255177499237233e-22,  5.033975730702159e-24, -2.336022845321392e-26,  8.374192842890298e-30,
  6.156555658007288e-01, -2.205353930114742e-03,  3.428259575253201e-06,  3.413469430734012e-09, -2.879203487242281e-11,  3.351233418676441e-14,  1.786325461864756e-16,
 -7.177434811491138e-19, -1.403741212155582e-22,  7.844547740467645e-24, -1.712751075162652e-26, -4.628954482408493e-29,  6.765686707070727e-01, -2.324973058141898e-03,
  3.083126026936282e-06,  5.495249305313315e-09, -2.949327371434774e-11,  9.605457704846339e-15,  2.440269529321792e-16, -5.654984052348557e-19, -1.364075502670833e-21,
  8.785645924309440e-24, -3.009653961836901e-27, -9.347014539734789e-29,  7.390758273596112e-01, -2.428487526435437e-03,  2.645784594430260e-06,  7.478398637596809e-09,
 -2.812613331100329e-11, -1.784899211404694e-14,  2.817866933809888e-16, -2.822193770709924e-19, -2.448314967515348e-21,  7.198994523714620e-24,  1.505804680394065e-26,
 -1.092493135129943e-28,  8.029301874364804e-01, -2.513898455960537e-03,  2.125310080661367e-06,  9.251009269236858e-09, -2.463610754049389e-11, -4.597105734225804e-14,
  2.827089690519403e-16,  9.066926466111852e-20, -3.087370686722588e-21,  3.170980906144874e-24,  3.074026623857543e-26, -7.979439734137401e-29,  8.678739456178277e-01,
 -2.579453416232971e-03,  1.534115464441096e-06,  1.070662286926381e-08, -1.915540733110725e-11, -7.152179389074862e-14,  2.428458453926380e-16,  4.866724323675301e-19,
 -3.054355494181714e-21, -2.369134861438736e-24,  3.753809661590554e-26, -1.042989374090755e-29,  9.336389237718693e-01, -2.623687507547545e-03,  8.876708889011867e-07,
  1.175137758245093e-08, -1.200575174353503e-11, -9.130568792391443e-14,  1.648098439589933e-16,  8.264366311791727e-19, -2.278363626002334e-21, -7.843777304037469e-24,
  3.152061688175830e-26,  7.335190965381264e-29,  9.999472724210900e-01, -2.645462383836998e-03,  2.040836145513124e-07,  1.231089588784910e-08, -3.682217732457216e-12,
 -1.026094461246151e-13,  5.799272887788200e-17,  1.034706316743630e-18, -8.857459000928165e-22, -1.149192661740858e-23,  1.340543981537264e-26,  1.351471235508242e-28,
  1.066512299588711e+00, -2.644002198450359e-03, -4.964580638064381e-07,  1.233640532098764e-08,  5.182209628329465e-12, -1.036161895909802e-13, -6.248693118248432e-17,
  1.058400427531492e-18,  8.130066726951007e-22, -1.197142950520842e-23, -1.107837519317933e-26,  1.441824697178765e-28,  1.133039436245244e+00, -2.618925368562600e-03,
 -1.192367430617184e-06,  1.180957387171605e-08,  1.386964355580608e-11, -9.372952601134030e-14, -1.780560353443373e-16,  8.813290887922651e-19,  2.394533513796219e-21,
 -8.887960877893527e-24, -3.299928378491344e-26,  9.153515014543704e-29,  1.199227346290064e+00, -2.570270989819615e-03, -1.861451782116288e-06,  1.074557189845400e-08,
  2.164388211478138e-11, -7.374738901061674e-14, -2.698639035909437e-16,  5.312993641768255e-19,  3.437101636368814e-21, -3.034104921128209e-24, -4.370265430534572e-26,
 -2.809738145608429e-30,  1.264769187269309e+00, -2.498518699727360e-03, -2.481790357790889e-06,  9.193947897370053e-09,  2.782448903004223e-11, -4.584187948099793e-14,
 -3.223114638418727e-16,  7.681687646550213e-20,  3.646624448361589e-21,  3.794334126338073e-24, -3.857221471054547e-26, -9.726670620588276e-29,  1.329354025813956e+00,
 -2.404600795170054e-03, -3.032665847145152e-06,  7.237028789553357e-09,  3.186059714772698e-11, -1.332778437827300e-14, -3.262294344225377e-16, -3.869173955433043e-19,
  2.954059982920500e-21,  9.383373920018825e-24, -1.933696155214879e-26, -1.481833405239097e-28,  1.392668409059651e+00, -2.289905465136204e-03, -3.495510464986311e-06,
  4.985724428116133e-09,  3.339570915939177e-11,  1.976395465150693e-14, -2.809897841173871e-16, -7.600439408835596e-19,  1.548610251462978e-21,  1.189567307099424e-23,
  6.337105107884956e-27, -1.321435740011270e-28,  1.454398090080050e+00, -2.156270112289778e-03, -3.854821630694115e-06,  2.572823174920264e-09,  3.231481893924657e-11,
  4.925577506468929e-14, -1.949886148929098e-16, -9.628156645976750e-19, -1.706658450183273e-22,  1.057115838243375e-23,  2.803335280171691e-26, -5.879463699762565e-29,
  1.514229901649503e+00, -2.005963912864293e-03, -4.098998116201571e-06,  1.440969753674744e-10,  2.876640697777178e-11,  7.145250897545895e-14, -8.424975714755343e-17,
 -9.563993616006193e-19, -1.715004888691312e-21,  6.036093538344170e-24,  3.721409143925275e-26,  3.380733438464100e-29,  1.571853768498348e+00, -1.841659007332971e-03,
 -4.221045811682865e-06, -2.152229266940345e-09,  2.315430846574994e-11,  8.372613878449357e-14,  3.068569123455144e-17, -7.534754680848220e-19, -2.660932988767880e-21,
  6.474899939821272e-26,  3.109269343540564e-26,  9.966434776392699e-29,  1.626964843716865e+00, -1.666390024737392e-03, -4.219103605390857e-06, -4.176872614511463e-09,
  1.609795862063786e-11,  8.494956533693081e-14,  1.289890742829770e-16, -4.148939296896271e-19, -2.786952503159463e-21, -5.132744967875259e-24,  1.377066396730682e-26,
  1.097960898304427e-28,  1.679265750218735e+00, -1.483502017312393e-03, -4.096744754612340e-06, -5.810810525789528e-09,  8.363727111074357e-12,  7.569033801378651e-14,
  1.939672991800866e-16, -3.262727456311232e-20, -2.141539872185353e-21, -7.804109355201117e-24, -6.011853349291658e-27,  6.703000366009749e-29,  1.728468903343827e+00,
 -1.296587309816804e-03, -3.863017786130080e-06, -6.965487022264270e-09,  7.744134043089595e-13,  5.811313510812378e-14,  2.166256711240845e-16,  2.964029776744467e-19,
 -1.015194583907186e-21, -7.338660127121921e-24, -1.937036636300143e-26,  1.795446758265503e-30,  1.774298885949102e+00, -1.109412234851055e-03, -3.532203353581738e-06,
 -7.590873376259403e-09, -5.892190685950070e-12,  3.559263066001830e-14,  1.974560104898936e-16,  4.978176308925349e-19,  1.745162241506295e-22, -4.432348800136329e-24,
 -2.161426509979625e-26, -4.802129383225338e-29,  1.816494842921356e+00, -9.258352109046811e-04, -3.123279179531174e-06, -7.680464973323433e-09, -1.100216383982846e-11,
  1.209673799771777e-14,  1.459376887855494e-16,  5.399229251633222e-19,  1.040781912445396e-21, -6.654674856617012e-25, -1.409548959983358e-26, -5.988226259609645e-29,
  1.854812858188049e+00, -7.497180983859346e-04, -2.659103412075247e-06, -7.272525782175065e-09, -1.414747583204263e-11, -8.548257164200289e-15,  7.782019861049507e-17,
  4.399280241749329e-19,  1.365399083242621e-21,  2.289977608675889e-24, -2.674618707133188e-27, -3.741457865492791e-29,  1.889028274272716e+00, -5.848332109958175e-04,
 -2.165346238124083e-06, -6.447224171926876e-09, -1.519834891825418e-11, -2.336704670146093e-14,  1.086525144955250e-17,  2.542205834422585e-19,  1.161304037500989e-21,
  3.433084891828483e-24,  6.095162223478475e-27, -3.320296190432089e-30,  1.918937912574099e+00, -4.347687337256815e-04, -1.669218908656671e-06, -5.319710429377035e-09,
 -1.431682165913431e-11, -3.077243359074209e-14, -3.981496383294395e-17,  5.623445220515221e-20,  6.366334899534165e-22,  2.790618565241420e-24,  8.654544112563278e-27,
  1.887572770103502e-29,  1.944362152434730e+00, -3.028355715523141e-04, -1.198066731001197e-06, -4.029624790672079e-09, -1.192788656580091e-11, -3.081324729521495e-14,
 -6.553200752677092e-17, -9.004834520379200e-20,  8.065046642466988e-23,  1.216758433649304e-24,  5.809314454381182e-27,  2.024530452278351e-29,  1.965146830566062e+00,
 -1.919787874801509e-04, -7.779062916284561e-07, -2.727942648771317e-09, -8.651121173555246e-12, -2.507449911216245e-14, -6.583847055426222e-17, -1.512657328132947e-19,
 -2.732780819815159e-22, -2.075512586628768e-25,  1.223143094475075e-27,  8.564237376225322e-30,  1.981164939175100e+00, -1.046967097167177e-04, -4.319953901318183e-07,
 -1.562404497354154e-09, -5.202237087734331e-12, -1.624676550376807e-14, -4.787540545224220e-17, -1.328332875246887e-19, -3.433261174884333e-22, -8.058097102536220e-25,
 -1.611094708770001e-27, -2.173731795480261e-30,  1.992318209842917e+00, -4.297004074031272e-05, -1.795238217762666e-07, -6.629847186197376e-10, -2.279230937212270e-12,
 -7.457187121849759e-15, -2.347291451148671e-17, -7.146847011516260e-20, -2.109554254634475e-22, -6.036238110994275e-25, -1.670570515527652e-27, -4.449742878394147e-30,
  1.998540171503316e+00, -8.194573791373280e-06, -3.447276372067608e-08, -1.287730326142049e-10, -4.503856849324654e-13, -1.509876394465752e-15, -4.912170309360346e-18,
 -1.562212763934599e-20, -4.879011545508602e-23, -1.500930718847071e-25, -4.557384705242409e-28, -1.367732660755068e-30,  4.837319120978159e-04, -2.394212719273477e-06,
  8.885509439565232e-09, -2.930381963409149e-11,  9.056758961005710e-14, -2.685965268475602e-16,  7.740388882530747e-19, -2.183790350660814e-21,  6.060677654859635e-24,
 -1.660001079956634e-26,  4.497405412718079e-29, -1.207283212382095e-31,  4.351500660806683e-03, -2.150127615246021e-05,  7.952072206103191e-08, -2.607233474301856e-10,
  7.986774547602773e-13, -2.339042779328190e-15,  6.627145814220862e-18, -1.828726878043186e-20,  4.934010301119570e-23, -1.304532664707875e-25,  3.383593580568137e-28,
 -8.611029172401989e-31,  1.207590531141416e-02, -5.946707278390122e-05,  2.184093669238934e-07, -7.076700657094898e-10,  2.128833187938210e-12, -6.073887220396586e-15,
  1.659846453080079e-17, -4.362203007491973e-20,  1.102752062974410e-22, -2.672977681742930e-25,  6.165115790909583e-28, -1.332744046364197e-30,  2.363465822978634e-02,
 -1.157969019019524e-04,  4.208460811415765e-07, -1.339152237611255e-09,  3.916319090221253e-12, -1.071582276894576e-14,  2.756192261992497e-17, -6.635086198653444e-20,
  1.472280080746463e-22, -2.901694925434342e-25,  4.573758091305414e-28, -3.215678475513255e-31,  3.899427354266923e-02, -1.897536293868550e-04,  6.799176405431978e-07,
 -2.110636357700594e-09,  5.932093030245161e-12, -1.525991847409950e-14,  3.563263010097923e-17, -7.305893526807864e-20,  1.188772322695910e-22, -8.800140520855713e-26,
 -3.813300490565154e-28,  2.482389777529635e-30,  5.811000304125310e-02, -2.803636366053325e-04,  9.866748322871715e-07, -2.966313283279782e-09,  7.903048329229435e-12,
 -1.859471444593112e-14,  3.698497255017985e-17, -5.284793334050771e-20,  2.232791536195504e-24,  3.543240380644892e-25, -1.723890012317764e-27,  5.805226256818401e-30,
  8.092575276041913e-02, -3.864248314118236e-04,  1.330358364507401e-06, -3.841989358016621e-09,  9.536803461642813e-12, -1.966492154487715e-14,  2.871947104957830e-17,
 -1.165382435168038e-21, -1.935373621618839e-22,  9.187014771767378e-25, -2.934992604598185e-27,  7.103127411414722e-30,  1.073739820317937e-01, -5.065167854522214e-04,
  1.698675890953454e-06, -4.668492754823534e-09,  1.054924519782819e-11, -1.763680199233664e-14,  9.626296469229351e-18,  7.760719620835227e-20, -4.225704901406640e-22,
  1.370585652913207e-24, -3.137647141009078e-27,  3.913497905824692e-30,  1.373755873181716e-01, -6.390130733194860e-04,  2.078126338104124e-06, -5.375460583329169e-09,
  1.069277409407618e-11, -1.204598661468315e-14, -1.929977521160401e-17,  1.695823980541646e-19, -6.098810409836006e-22,  1.432671298364892e-24, -1.634733533376365e-27,
 -4.346497912386752e-30,  1.708397736849122e-01, -7.820958971127452e-04,  2.454366735419356e-06, -5.895349890336533e-09,  9.783034546170409e-12, -2.908155517178277e-15,
 -5.470860592300201e-17,  2.532022695030066e-19, -6.705293562420072e-22,  8.964097639471680e-25,  1.633567750120957e-27, -1.514208610241444e-29,  2.076639173567837e-01,
 -9.337730837219685e-04,  2.812615658144705e-06, -6.167496382153334e-09,  7.721874472498941e-12,  9.224220021095553e-15, -9.117373251218182e-17,  3.033640574571817e-19,
 -5.362767821812325e-22, -2.658783367534901e-25,  5.818848244148940e-27, -2.308728515978750e-29,  2.477334234516098e-01, -1.091897540718746e-03,  3.138086195402649e-06,
 -6.142029552608974e-09,  4.514388652108245e-12,  2.327106092248318e-14, -1.219014200113398e-16,  2.971773073475757e-19, -1.826932848035816e-22, -1.833057843392138e-24,
  9.265522479148945e-27, -2.204504723412300e-29,  2.909215836787541e-01, -1.254189248998248e-03,  3.416440062259312e-06, -5.783443128161485e-09,  2.781667413371093e-13,
  3.770515887341435e-14, -1.397971294567594e-16,  2.202239002336367e-19,  3.516647252886775e-22, -3.348576748332263e-24,  1.003914780716041e-26, -8.432862400341411e-30,
  3.370894395429161e-01, -1.418259855111689e-03,  3.634253102340469e-06, -5.073616717363771e-09, -4.756702799302889e-12,  5.070135233086026e-14, -1.387465870283565e-16,
  7.190503462754231e-20,  9.615340743685325e-22, -4.229583874137101e-24,  6.751509623412827e-27,  1.576349321534748e-29,  3.860856574015027e-01, -1.581639902300591e-03,
  3.779481010258321e-06, -4.014089758468273e-09, -1.025773226371685e-11,  6.034314298451284e-14, -1.149123346905050e-16, -1.315568421531343e-19,  1.491006212058284e-21,
 -3.953251983915154e-24, -6.196951300874622e-28,  4.205378690042455e-29,  4.377464225835896e-01, -1.741808705300493e-03,  3.841912689417817e-06, -2.627403801564379e-09,
 -1.581036449326301e-11,  6.486699810557283e-14, -6.781540675404471e-17, -3.575881463622770e-19,  1.768611393801555e-21, -2.268516710800138e-24, -1.029645939464804e-26,
  5.776437035239986e-29,  4.918953606830878e-01, -1.896226828740451e-03,  3.813597317660249e-06, -9.573552465685275e-10, -2.094781399696678e-11,  6.291725280286647e-14,
 -9.749542081117440e-19, -5.617168976895683e-19,  1.654794303251173e-21,  6.402095946891891e-25, -1.895669045990375e-26,  5.137028397621891e-29,  5.483434950765481e-01,
 -2.042371071230521e-03,  3.689230007508365e-06,  9.319609725049872e-10, -2.518878849693076e-11,  5.377944198181850e-14,  7.807814497727865e-17, -6.956707444282464e-19,
  1.090039985642873e-21,  4.110167779474936e-24, -2.275364107898974e-26,  1.888069410231359e-29,  6.068892506700329e-01, -2.177771785995353e-03,  3.466480027073966e-06,
  2.958384944329852e-09, -2.808054575334504e-11,  3.755810201260007e-14,  1.585143313011548e-16, -7.178529429593276e-19,  1.292462525085746e-22,  7.123020880136682e-24,
 -1.884349495940650e-26, -3.183297849143078e-29,  6.673185148262869e-01, -2.300052283489586e-03,  3.146245019780177e-06,  5.025206541710012e-09, -2.924390489728283e-11,
  1.526745583357663e-14,  2.276292284143420e-16, -6.041193678468650e-19, -1.050919763058901e-21,  8.586385108099615e-24, -6.867423117711073e-27, -8.167634245953756e-29,
  7.294047673324624e-01, -2.406969961610797e-03,  2.732814671498018e-06,  7.025889272830362e-09, -2.841616914396148e-11, -1.118954689946670e-14,  2.728274411154416e-16,
 -3.563119674115588e-19, -2.179464231675914e-21,  7.705618185598819e-24,  1.028956488661850e-26, -1.069999111867230e-28,  7.929092921012634e-01, -2.496458695368996e-03,
  2.233927980711257e-06,  8.849845495662015e-09, -2.548753011571369e-11, -3.916662735430812e-14,  2.838833788928710e-16, -6.069871004692203e-21, -2.951959597058545e-21,
  4.327007530076978e-24,  2.698389305657599e-26, -9.038849259772728e-29,  8.575814840072775e-01, -2.566671891524056e-03,  1.660709853344348e-06,  1.038901396943562e-08,
 -2.052651380952278e-11, -6.554108468869504e-14,  2.550935595521071e-16,  3.878569605574596e-19, -3.112783783901834e-21, -8.829445665719444e-25,  3.662224884986586e-26,
 -3.090068861980087e-29,  9.231592647892183e-01, -2.616025477226781e-03,  1.027475323259312e-06,  1.154489927272373e-08, -1.379048043427114e-11, -8.708105958969518e-14,
  1.868886818387548e-16,  7.492602597089452e-19, -2.537323616338093e-21, -6.524645476033695e-24,  3.427929525761302e-26,  5.185327268710281e-29,  9.893696222327396e-01,
 -2.643239948907584e-03,  3.513934217954897e-07,  1.223564830319238e-08, -5.718159846672927e-12, -1.008735404490754e-13,  8.650630158481230e-17,  9.998580359418102e-19,
 -1.288398497967289e-21, -1.083993876594068e-23,  1.910872887444351e-26,  1.234540055026599e-28,  1.055929286814409e+00, -2.647380463920160e-03, -3.479923308129447e-07,
  1.240267072548373e-08,  3.097302918685723e-12, -1.047577145294536e-13, -3.255281889478676e-17,  1.077448099078337e-18,  3.756051904426738e-22, -1.228582728186022e-23,
 -4.603880662465940e-27,  1.493461060393117e-28,  1.122545559555978e+00, -2.627893819853744e-03, -1.049383648679399e-06,  1.201626780153464e-08,  1.195436190340153e-11,
 -9.769839020763549e-14, -1.523559402583552e-16,  9.525882012370444e-19,  2.051835982978686e-21, -1.012105862285541e-23, -2.850394100808726e-26,  1.123446773792402e-28,
  1.188917303926349e+00, -2.584641043845788e-03, -1.730476905478320e-06,  1.107972780768161e-08,  2.010543574501422e-11, -8.003329053707326e-14, -2.534665249455283e-16,
  6.392018113266374e-19,  3.296449062528195e-21, -4.776881384465173e-24, -4.324134945854075e-26,  2.392343883344236e-29,  1.254736113154018e+00, -2.517924217235277e-03,
 -2.368823446587080e-06,  9.631385697026642e-09,  2.683053955406290e-11, -5.353824258174320e-14, -3.185085385759983e-16,  1.953885606180363e-19,  3.754465184087550e-21,
  2.171194420647990e-24, -4.244509517184303e-26, -7.809620176459725e-29,  1.319687662198167e+00, -2.428506101522433e-03, -2.942773068268404e-06,  7.744237007902113e-09,
  3.151492537678463e-11, -2.127630669279494e-14, -3.356900579692779e-16, -2.871446837408319e-19,  3.276368439212982e-21,  8.479666079833813e-24, -2.583544679332008e-26,
 -1.463943379727415e-28,  1.383453250807241e+00, -2.317621122825483e-03, -3.432463945977042e-06,  5.522844466942686e-09,  3.372185754959656e-11,  1.277082200287103e-14,
 -3.015125762271851e-16, -7.035992524816589e-19,  1.979970982521912e-21,  1.202796947398814e-23,  1.612143553841469e-28, -1.481242417340214e-28,  1.445711540524824e+00,
 -2.186976327020885e-03, -3.820813869858781e-06,  3.097477764275009e-09,  3.325095183757060e-11,  4.425228435959687e-14, -2.219651891241381e-16, -9.619770508823063e-19,
  2.293918450414069e-22,  1.163364756412799e-23,  2.491352582208579e-26, -8.316372348807060e-29,  1.506140484168093e+00, -2.038741048827987e-03, -4.094460599782973e-06,
  6.156728129440464e-10,  3.017303694145569e-11,  6.910317428296967e-14, -1.117625305623038e-16, -1.007512843309188e-18, -1.470601493434373e-21,  7.549016970604483e-24,
  3.829210048256097e-26,  1.459019484737295e-29,  1.564419441225930e+00, -1.875524255371959e-03, -4.244594380421374e-06, -1.768331481224055e-09,  2.483443723853417e-11,
  8.419981663016315e-14,  8.398391315499153e-18, -8.383394730330573e-19, -2.635167553264270e-21,  1.395108094493411e-24,  3.539241223258504e-26,  9.514564857407312e-29,
  1.620231466871117e+00, -1.700338834625489e-03, -4.267624072407814e-06, -3.905549277620031e-09,  1.782691353329213e-11,  8.789565444179630e-14,  1.160965247230345e-16,
 -5.069169210588829e-19, -2.960623261216955e-21, -4.482144664360442e-24,  1.883458648651637e-26,  1.201145648489936e-28,  1.673265755977234e+00, -1.516552502630271e-03,
 -4.165620789369559e-06, -5.664627957843348e-09,  9.923970896233124e-12,  8.032658551461043e-14,  1.920517937239026e-16, -1.056920719863048e-19, -2.426061625986134e-21,
 -7.980755234394525e-24, -2.698498713811988e-27,  8.376705376819170e-29,  1.723220216859130e+00, -1.327825494661519e-03, -3.946490009470312e-06, -6.943513073769736e-09,
  1.989318482194433e-12,  6.340782221999909e-14,  2.244293662494980e-16,  2.595405030109646e-19, -1.293282584894741e-21, -8.108411996857514e-24, -1.902651062011990e-26,
  1.425353302038496e-29,  1.769804142660526e+00, -1.138035770480422e-03, -3.623835146239956e-06, -7.679191375061708e-09, -5.131816966193567e-12,  4.049931918124114e-14,
  2.114478861039787e-16,  5.006781510884891e-19, -1.115262713860876e-24, -5.338651353506439e-24, -2.368445891045296e-26, -4.576244464848571e-29,  1.812740941696527e+00,
 -9.511930795989957e-04, -3.216492352445031e-06, -7.854368606482231e-09, -1.072396014775951e-11,  1.578439394258654e-14,  1.615173932666004e-16,  5.727305554453412e-19,
  1.006024504428427e-21, -1.283829683252445e-24, -1.686793891604797e-26, -6.610014527127368e-29,  1.851770881979047e+00, -7.713438673464085e-04, -2.747737180619080e-06,
 -7.500147361185205e-09, -1.429874053403192e-11, -6.527743945009011e-15,  9.076210889765604e-17,  4.849158157974889e-19,  1.445494724312625e-21,  2.147738308931302e-24,
 -4.496808184841844e-27, -4.557903058019613e-29,  1.886653800017023e+00, -6.024696170255016e-04, -2.244187339241478e-06, -6.694119816594591e-09, -1.566248342650161e-11,
 -2.301654740316672e-14,  1.852260532408247e-17,  2.934064670954555e-19,  1.289237464079826e-21,  3.672753656649757e-24,  5.856314288638141e-27, -7.711450070412523e-30,
  1.917171720278916e+00, -4.483817723796174e-04, -1.734450325107935e-06, -5.553754506029152e-09, -1.494168608238245e-11, -3.170670062378549e-14, -3.793959872586007e-17,
  7.828256966096325e-20,  7.435289702430241e-22,  3.153602247504508e-24,  9.498797079131253e-27,  1.944459265203023e-29,  1.943131330186578e+00, -3.126168191709778e-04,
 -1.247587921478536e-06, -4.225487400508964e-09, -1.256008173822880e-11, -3.241593796606379e-14, -6.801031461503150e-17, -8.672003912262639e-20,  1.288584828796117e-22,
  1.467755360878821e-24,  6.761044631799838e-27,  2.306180195731166e-29,  1.964366258218843e+00, -1.983353708435229e-04, -8.114889422951946e-07, -2.870459818684859e-09,
 -9.168760594441441e-12, -2.670644241278765e-14, -7.019739117438798e-17, -1.601199693759259e-19, -2.797735767394127e-22, -1.505492198307632e-25,  1.640916265156017e-27,
  1.048145943862643e-29,  1.980739119636513e+00, -1.082291083691872e-04, -4.512545874612210e-07, -1.648303490023214e-09, -5.538970292472010e-12, -1.744167594020401e-14,
 -5.175299839624692e-17, -1.442964928179337e-19, -3.735180571907857e-22, -8.721380255364290e-25, -1.704478789456810e-27, -2.057729769593168e-30,  1.992143406021545e+00,
 -4.443868606905301e-05, -1.877034673554127e-07, -7.006768666006516e-10, -2.434174298872686e-12, -8.045333840597856e-15, -2.557190073155666e-17, -7.858002058066037e-20,
 -2.339373703379930e-22, -6.745272363266637e-25, -1.878806187558202e-27, -5.027284925251766e-30,  1.998506831681153e+00, -8.476661848989981e-06, -3.606229481937357e-08,
 -1.362273412282653e-10, -4.817984981254150e-13, -1.633199063297528e-15, -5.372285941599287e-18, -1.727350448471722e-20, -5.453664046432273e-23, -1.695858882273466e-25,
 -5.204361370644125e-28, -1.578406026336411e-30,  4.742950365292864e-04, -2.324510994525718e-06,  8.542384032520448e-09, -2.789672470026833e-11,  8.537658653291765e-14,
 -2.507319716988163e-16,  7.155205192658503e-19, -1.999073197096673e-21,  5.494218601011488e-24, -1.490290100143317e-26,  3.998643853916956e-29, -1.063068708325811e-31,
  4.266748374849802e-03, -2.087741135643223e-05,  7.646719868427540e-08, -2.483102841401715e-10,  7.534465426314194e-13, -2.185961636094241e-15,  6.136518844259488e-18,
 -1.678098676362718e-20,  4.487854239743687e-23, -1.176472552236945e-25,  3.026465922022243e-28, -7.642273307634055e-31,  1.184147859269887e-02, -5.775319606275640e-05,
  2.101177543500989e-07, -6.745593204798768e-10,  2.011242163956518e-12, -5.689791042647126e-15,  1.542503764479040e-17, -4.024254004025678e-20,  1.010825732414718e-22,
 -2.437739515080782e-25,  5.605553993965031e-28, -1.212439726053121e-30,  2.317810386658912e-02, -1.124933633790762e-04,  4.051452631983075e-07, -1.278170345268169e-09,
  3.708469723411466e-12, -1.007610766588409e-14,  2.576851124237249e-17, -6.180320128683209e-20,  1.371076268414539e-22, -2.721769111150549e-25,  4.418111682341875e-28,
 -3.823440790167691e-31,  3.824597954672626e-02, -1.844140081749931e-04,  6.551495622658550e-07, -2.018118679048743e-09,  5.635283003111312e-12, -1.442885632123904e-14,
  3.363974086017036e-17, -6.930829072840666e-20,  1.154597574990793e-22, -1.011997824418738e-25, -2.816726686746091e-28,  2.058814643070867e-30,  5.700411285023724e-02,
 -2.726104993086130e-04,  9.518256478663992e-07, -2.842791938739957e-09,  7.539910664657711e-12, -1.772481261399719e-14,  3.550805625588631e-17, -5.258521515100633e-20,
  1.380684753993517e-23,  2.902621322355904e-25, -1.484378693489236e-27,  5.094816592540917e-30,  7.940105080044314e-02, -3.759638156218819e-04,  1.285157167746560e-06,
 -3.692509463188943e-09,  9.150391570661793e-12, -1.897671587472591e-14,  2.860494956632732e-17, -6.851462549838329e-21, -1.625034661164489e-22,  8.073895943709500e-25,
 -2.634625206245740e-27,  6.550859822461689e-30,  1.053747429144638e-01, -4.931486233049581e-04,  1.643655107760522e-06, -4.502513455381265e-09,  1.019898777559734e-11,
 -1.738117814045490e-14,  1.161723327451799e-17,  6.485051742936716e-20, -3.754462061883538e-22,  1.248610176788263e-24, -2.959257253660697e-27,  4.170708323751449e-30,
  1.348523805929877e-01, -6.226431947536505e-04,  2.014639289860777e-06, -5.206327147235349e-09,  1.044759583171222e-11, -1.245435966742111e-14, -1.481703315906301e-17,
  1.508784572947222e-19, -5.595237222544538e-22,  1.363919634123255e-24, -1.791932824348966e-27, -2.846988789949003e-30,  1.677502156679241e-01, -7.627412839108261e-04,
  2.384559564062087e-06, -5.739355615252983e-09,  9.712303230374122e-12, -4.138480493303901e-15, -4.791440557167661e-17,  2.322730154691768e-19, -6.372361219144592e-22,
  9.491790773620280e-25,  1.022984620236549e-27, -1.265865540178145e-29,  2.039733611254306e-01, -9.115660846707110e-04,  2.739352712182497e-06, -6.042586552897248e-09,
  7.885155153022230e-12,  7.136034300697485e-15, -8.292092087196643e-17,  2.860930302130556e-19, -5.418973859326267e-22, -5.275370272857027e-26,  4.854345599064978e-27,
 -2.075926759031334e-29,  2.434155776524919e-01, -1.067086406307078e-03,  3.064830073770465e-06, -6.066232107392814e-09,  4.951223864131715e-12,  2.044455933422038e-14,
 -1.136717234898037e-16,  2.903449199384263e-19, -2.422449358681854e-22, -1.481718447082982e-24,  8.305123695110482e-27, -2.154208391026898e-29,  2.859590503629776e-01,
 -1.227135201970994e-03,  3.347089749410803e-06, -5.773139812327165e-09,  9.992241848108512e-13,  3.442518598147820e-14, -1.334908888531315e-16,  2.296251164032137e-19,
  2.382469935365939e-22, -2.955269413240668e-24,  9.606957731848280e-27, -1.107916411501673e-29,  3.314741608507916e-01, -1.389430581824319e-03,  3.572945937107408e-06,
 -5.141791926022928e-09, -3.775794473947214e-12,  4.739893244324421e-14, -1.363249903633935e-16,  1.002912569576961e-19,  8.142812333028736e-22, -3.947404036965244e-24,
  7.315627523571430e-27,  1.001666374118581e-29,  3.798192605983678e-01, -1.551599429887896e-03,  3.730366528751823e-06, -4.168709574601964e-09, -9.078719429712260e-12,
  5.754630374677708e-14, -1.179493642353857e-16, -8.612300375962356e-20,  1.348670282693669e-21, -3.943073007714009e-24,  1.078668908481386e-27,  3.519460004104163e-29,
  4.308404527407991e-01, -1.711203721579900e-03,  3.808908565547395e-06, -2.870082635223796e-09, -1.453007851705091e-11,  6.312559584497635e-14, -7.704835244965533e-17,
 -3.023738394704304e-19,  1.680132426070744e-21, -2.630810162458867e-24, -7.850866766208425e-27,  5.328541573850046e-29,  4.843713902482932e-01, -1.865769605456558e-03,
  3.800139571474628e-06, -1.282460021080160e-09, -1.969094590737869e-11,  6.271111693429382e-14, -1.595923228223668e-17, -5.085366101564673e-19,  1.664742734677875e-21,
 -7.232996691376746e-26, -1.666037621385849e-26,  5.273509412097963e-29,  5.402330997368529e-01, -2.012819266020602e-03,  3.698031221795131e-06,  5.376403309900033e-10,
 -2.409601775563964e-11,  5.542364415941851e-14,  5.910870412643329e-17, -6.585958792784945e-19,  1.221848117573200e-21,  3.219300784329946e-24, -2.172727243223727e-26,
  2.745362664220843e-29,  5.982338413377276e-01, -2.149905522812514e-03,  3.499310353279435e-06,  2.515305388717429e-09, -2.729296496239112e-11,  4.112194640534375e-14,
  1.385098491980910e-16, -7.097621697890492e-19,  3.718072424501929e-22,  6.345329101791715e-24, -1.994251386612362e-26, -1.830273887086867e-29,  6.581690163316728e-01,
 -2.274649042653286e-03,  3.203751105566276e-06,  4.560037868853532e-09, -2.888531334353893e-11,  2.052405663412382e-14,  2.102891259635739e-16, -6.328628676190775e-19,
 -7.475868945040881e-22,  8.243519259377210e-24, -1.018280308473798e-26, -6.890682278745913e-29,  7.198211355570054e-01, -2.384777945465846e-03,  2.814391148253828e-06,
  6.569792475437801e-09, -2.857532924414618e-11, -4.769031143401871e-15,  2.619165222183272e-16, -4.215460859208039e-19, -1.895776600547909e-21,  8.024343524477282e-24,
  5.683690371813397e-27, -1.019287475096340e-28,  7.829598628930632e-01, -2.478169468676979e-03,  2.337654672301409e-06,  8.436148289447010e-09, -2.620279894727523e-11,
 -3.236598883744496e-14,  2.824158017832820e-16, -9.783983127892828e-20, -2.777739321169904e-21,  5.324462709435158e-24,  2.283666613037130e-26, -9.755625281834755e-29,
  8.473421493531146e-01, -2.552893220682313e-03,  1.783365305651989e-06,  1.005043930655026e-08, -2.177529164917160e-11, -5.929979448119217e-14,  2.645562474414471e-16,
  2.880190307280439e-19, -3.118580516254448e-21,  5.491758334359327e-25,  3.484996228674603e-26, -4.926457148955735e-29,  9.127124744298099e-01, -2.607255401231451e-03,
  1.164633563415285e-06,  1.131056928428592e-08, -1.548559732385870e-11, -8.235336221163149e-14,  2.066978474160348e-16,  6.645764175886301e-19, -2.747039195895913e-21,
 -5.114360270284468e-24,  3.607299314618272e-26,  2.962782744854807e-29,  9.788032122441854e-01, -2.639843198302144e-03,  4.976060727510034e-07,  1.212814021365750e-08,
 -7.712627052919729e-12, -9.846645080698974e-14,  1.138675703756088e-16,  9.525433734356607e-19, -1.663607245813653e-21, -9.971209181607833e-24,  2.421633245539440e-26,
  1.081667339048549e-28,  1.045335140663556e+00, -2.649568391361955e-03, -1.989321905476823e-07,  1.243543416547971e-08,  9.967848853417863e-13, -1.051760110607730e-13,
 -2.282670663089868e-18,  1.082368175186339e-18, -6.841076643236039e-23, -1.233808114006655e-23,  1.994445932059800e-27,  1.497933953872206e-28,  1.112018111767654e+00,
 -2.635709006349030e-03, -9.041059157167895e-07,  1.219171637514679e-08,  9.966026031827001e-12, -1.010277879879574e-13, -1.248205344953937e-16,  1.012207172336437e-18,
  1.668196408499765e-21, -1.115690248771739e-23, -2.315963765251390e-26,  1.299916502496066e-28,  1.178551901737225e+00, -2.597947687243218e-03, -1.595643925430484e-06,
  1.138828523027074e-08,  1.844544856447227e-11, -8.588996614068637e-14, -2.341202832600390e-16,  7.416054113772703e-19,  3.093673967946201e-21, -6.477495379866792e-24,
 -4.159175428395293e-26,  5.103677671235156e-29,  1.244627257287494e+00, -2.536405284454061e-03, -2.250707761373531e-06,  1.005169498110249e-08,  2.568384622116631e-11,
 -6.110316045703093e-14, -3.113462811945936e-16,  3.164480419335195e-19,  3.801298435228345e-21,  4.111813311025605e-25, -4.538782181372326e-26, -5.507616046300483e-29,
  1.309927154040494e+00, -2.451668025829145e-03, -2.846832258602993e-06,  8.244631348094132e-09,  3.100824478363232e-11, -2.941722672304472e-14, -3.422178986199064e-16,
 -1.776285639886629e-19,  3.561496799124817e-21,  7.319061278111462e-24, -3.214490131419680e-26, -1.395409588224098e-28,  1.374128279600511e+00, -2.344806548689112e-03,
 -3.362945376876335e-06,  6.064037782523218e-09,  3.390335390690436e-11,  5.305670222302018e-15, -3.202612991021457e-16, -6.333238197862925e-19,  2.411486181618206e-21,
  1.190004775628985e-23, -6.650350540699676e-27, -1.608856411144462e-28,  1.436902750457755e+00, -2.217385049450576e-03, -3.780423801360428e-06,  3.636274778490834e-09,
  3.408055006890393e-11,  3.860311868512832e-14, -2.487334900640793e-16, -9.477507929309202e-19,  6.651925150810322e-22,  1.254969722572113e-23,  2.070792972565515e-26,
 -1.080036894048771e-28,  1.497920067117996e+00, -2.071458870223205e-03, -4.084130804901671e-06,  1.109342489678886e-09,  3.152596600221087e-11,  6.607729324264066e-14,
 -1.405887513620795e-16, -1.049927368012766e-18, -1.171170166953184e-21,  9.087087068228825e-24,  3.844549933207599e-26, -8.183369415849237e-30,  1.556849306006364e+00,
 -1.909559007344944e-03, -4.263374667085463e-06, -1.357505714977837e-09,  2.651849881826799e-11,  8.411022356885069e-14, -1.624612385808243e-17, -9.215799613572933e-19,
 -2.558471861235800e-21,  2.892313360200726e-24,  3.940523668647700e-26,  8.654148197383140e-29,  1.613361539748598e+00, -1.734662310089380e-03, -4.312720792170046e-06,
 -3.606108986820134e-09,  1.961148415944137e-11,  9.050079769934165e-14,  1.005533316655871e-16, -6.040826802176168e-19, -3.107121719482214e-21, -3.620439587967085e-24,
  2.431139269534214e-26,  1.284395959966145e-28,  1.667132469496180e+00, -1.550146548049295e-03, -4.232589800021059e-06, -5.492742901706317e-09,  1.157630886050770e-11,
  8.489127735647830e-14,  1.879622429914355e-16, -1.879362748756774e-19, -2.714376659201020e-21, -8.009827918428348e-24,  1.373761496071939e-27,  1.014567930447183e-28,
  1.717845244226716e+00, -1.359730063977027e-03, -4.029578388087964e-06, -6.901243687421509e-09,  3.311901279924919e-12,  6.887638117444853e-14,  2.310721881207818e-16,
  2.133396072532842e-19, -1.598695074388825e-21, -8.852686941557110e-24, -1.807746604907589e-26,  2.932655402192154e-29,  1.765193432710548e+00, -1.167396385316552e-03,
 -3.716450461444549e-06, -7.754540063364094e-09, -4.269948350400275e-12,  4.574210805534908e-14,  2.254361558220631e-16,  4.973806810052050e-19, -2.108348587949884e-22,
 -6.325178109896737e-24, -2.560995891734017e-26, -4.137267791070762e-29,  1.808884104483866e+00, -9.773049196408398e-04, -3.311763160893400e-06, -8.023210329885682e-09,
 -1.036819053967354e-11,  1.985683912840728e-14,  1.779966378292897e-16,  6.040478385576523e-19,  9.469447381321765e-22, -2.018471833125255e-24, -1.990672025264118e-26,
 -7.193690615340451e-29,  1.848640967200772e+00, -7.936896702520534e-04, -2.839115540134448e-06, -7.729848583632280e-09, -1.440638540599633e-11, -4.181224607217630e-15,
  1.049986859475091e-16,  5.323699502688629e-19,  1.519068480323994e-21,  1.925128070428105e-24, -6.700568534368631e-27, -5.475928532494160e-29,  1.884207499738083e+00,
 -6.207487285001368e-04, -2.326035480293919e-06, -6.948375166843260e-09, -1.611767888588984e-11, -2.246863465099885e-14,  2.733575977400173e-17,  3.368220285284544e-19,
  1.425577487849666e-21,  3.898678374625698e-24,  5.399564996586592e-27, -1.325548028492418e-29,  1.915350014097305e+00, -4.625280678470928e-04, -1.802550865567757e-06,
 -5.797943233693228e-09, -1.558473370378309e-11, -3.258815188432874e-14, -3.539698596635947e-17,  1.039669814347111e-19,  8.641047969251399e-22,  3.550749327363602e-24,
  1.035982245652547e-26,  1.961596905590618e-29,  1.941860575477344e+00, -3.228038121327348e-04, -1.299521222160320e-06, -4.431724760393227e-09, -1.322491703185924e-11,
 -3.407680675805900e-14, -7.037241973454201e-17, -8.169690753189732e-20,  1.868182610872468e-22,  1.759383589470657e-24,  7.842953402068261e-27,  2.616289867334518e-29,
  1.963559711182363e+00, -2.049675995522099e-04, -8.468325881112381e-07, -3.021526098982624e-09, -9.720105216605684e-12, -2.844599630386677e-14, -7.480680792480484e-17,
 -1.691458322266390e-19, -2.838949297730510e-22, -7.504489344491002e-26,  2.150940274483119e-27,  1.276715947365768e-29,  1.980298855696093e+00, -1.119197971930365e-04,
 -4.715777044131191e-07, -1.739786567141494e-09, -5.900558900477176e-12, -1.873361165017394e-14, -5.596545112104382e-17, -1.567647547418096e-19, -4.061635938641395e-22,
 -9.420741444416725e-25, -1.790809785463116e-27, -1.848941996405306e-30,  1.991962593819226e+00, -4.597462084223186e-05, -1.963506905046533e-07, -7.409450181490156e-10,
 -2.601400920305719e-12, -8.686331229557307e-15, -2.788070176077920e-17, -8.646949222424786e-20, -2.596280885550888e-22, -7.542899867184950e-25, -2.114088773866330e-27,
 -5.680630833124972e-30,  1.998472337495420e+00, -8.771832697923079e-06, -3.774437663187022e-08, -1.442046025746468e-10, -5.157920479785219e-13, -1.768140816083351e-15,
 -5.881323732684481e-18, -1.912051617693651e-20, -6.103381291942991e-23, -1.918619410191341e-25, -5.951564141641771e-28, -1.824260858016978e-30,  4.651315828342915e-04,
 -2.257488117763392e-06,  8.215656976528648e-09, -2.656990207244334e-11,  8.052923873735450e-14, -2.342117856519654e-16,  6.619293741837684e-19, -1.831542495141203e-21,
  4.985412206974850e-24, -1.339316500314702e-26,  3.559199327476878e-29, -9.372189743946698e-32,  4.184443618028767e-03, -2.027739099459171e-05,  7.355838889907529e-08,
 -2.365970481839568e-10,  7.111628375368196e-13, -2.044165146060223e-15,  5.686136379365098e-18, -1.541036600025438e-20,  4.085328026492241e-23, -1.061879965828661e-25,
  2.709380819995415e-28, -6.788396493256673e-31,  1.161377718708607e-02, -5.610409433714718e-05,  2.022124306141688e-07, -6.432700748096094e-10,  1.901058937233741e-12,
 -5.332754074766511e-15,  1.434224247028273e-17, -3.714408635474745e-20,  9.269775721969676e-23, -2.223855391112194e-25,  5.096676469642309e-28, -1.102256433193158e-30,
  2.273451700046909e-02, -1.093125598465559e-04,  3.901566891772656e-07, -1.220413984343026e-09,  3.512994367420799e-12, -9.477942423100527e-15,  2.409799692431066e-17,
 -5.756915408196788e-20,  1.276231830370387e-22, -2.548543659237081e-25,  4.240152470771960e-28, -4.237130187565595e-31,  3.751865466539123e-02, -1.792681702265949e-04,
  6.314637425498012e-07, -1.930219554135697e-09,  5.354624366447227e-12, -1.364437606358676e-14,  3.175027248797152e-17, -6.567387356702079e-20,  1.116345814478661e-22,
 -1.107651361641199e-25, -1.992143486358236e-28,  1.699039315465417e-30,  5.592868687136240e-02, -2.651303239264128e-04,  9.184244262696087e-07, -2.724943535211631e-09,
  7.193817380148080e-12, -1.689022871436453e-14,  3.404334738036175e-17, -5.198723755379089e-20,  2.323980031503002e-23,  2.351785374077909e-25, -1.274416346534095e-27,
  4.461034992113486e-30,  7.791748089794621e-02, -3.658573384302678e-04,  1.241713087770973e-06, -3.549102247204907e-09,  8.777703976445372e-12, -1.829306064547238e-14,
  2.834453486293881e-17, -1.160630219844587e-20, -1.352663687517970e-22,  7.076088436767669e-25, -2.358357748357484e-27,  6.009285336001155e-30,  1.034281085936525e-01,
 -4.802127552820592e-04,  1.590592628245263e-06, -4.342094897126133e-09,  9.854292586711925e-12, -1.708189165555900e-14,  1.327144455633092e-17,  5.353295466015612e-20,
 -3.325822501774647e-22,  1.133955473406821e-24, -2.772570175404668e-27,  4.295795716919763e-30,  1.323936503485163e-01, -6.067731614409367e-04,  1.953158054667552e-06,
 -5.041176232347313e-09,  1.019528447707334e-11, -1.276125167016994e-14, -1.083582138250189e-17,  1.337452602360143e-19, -5.117395058588335e-22,  1.290116672876190e-24,
 -1.889280778472411e-27, -1.619707687779894e-30,  1.647369710150118e-01, -7.439376614069929e-04,  2.316616749944569e-06, -5.584681230640804e-09,  9.618549184627182e-12,
 -5.212654910025113e-15, -4.169105576988698e-17,  2.124350351037731e-19, -6.024572356472084e-22,  9.796274044502423e-25,  5.154816222544919e-28, -1.045479157498154e-29,
  2.003704702348962e-01, -8.899391522079437e-04,  2.667603015324052e-06, -5.915387745499291e-09,  8.008613547333825e-12,  5.240099498522591e-15, -7.515311452389602e-17,
  2.687576570877980e-19, -5.405153765454515e-22,  1.238258039274542e-25,  3.991165092466870e-27, -1.848961181698667e-29,  2.391958102158482e-01, -1.042857567998818e-03,
  2.992523626745690e-06, -5.983886876285580e-09,  5.333487611431296e-12,  1.781307086461041e-14, -1.056581640823070e-16,  2.818018870557520e-19, -2.898334878428689e-22,
 -1.168240299593884e-24,  7.375042187218373e-27, -2.068434024226298e-29,  2.811036246837373e-01, -1.200635271691462e-03,  3.277930159949477e-06, -5.751816067434818e-09,
  1.656214925664278e-12,  3.129932451244941e-14, -1.269701217997791e-16,  2.356199597920924e-19,  1.386511883519149e-22, -2.581349253342050e-24,  9.075264174694110e-27,
 -1.297370408549947e-29,  3.259732135259352e-01, -1.361094776459624e-03,  3.510912667916957e-06, -5.194797570117565e-09, -2.860291694693351e-12,  4.416364571017374e-14,
 -1.331729933318722e-16,  1.241317990876380e-19,  6.775343315039889e-22, -3.647471010422580e-24,  7.645209655836597e-27,  5.098832518585524e-30,  3.736722285491798e-01,
 -1.521958978661753e-03,  3.679507937101027e-06, -4.304916216676987e-09, -7.956271880484299e-12,  5.469132767578725e-14, -1.197778676260681e-16, -4.522552520499761e-20,
  1.207851772774426e-21, -3.870896015414079e-24,  2.482905677794822e-27,  2.870545550842332e-29,  4.240563568113624e-01, -1.680874073919068e-03,  3.773114016223376e-06,
 -3.092567037650376e-09, -1.328671296917755e-11,  6.118082356877074e-14, -8.477676454528547e-17, -2.501810573813912e-19,  1.580322528165639e-21, -2.899404119978764e-24,
 -5.615536497437735e-27,  4.824961354240027e-29,  4.769690091567997e-01, -1.835435307740965e-03,  3.782901029372438e-06, -1.587506920769721e-09, -1.844167606135458e-11,
  6.216323987634875e-14, -2.945373474253248e-17, -4.554305789346019e-19,  1.650703270994513e-21, -6.922834488804776e-25, -1.433849881710244e-26,  5.257431352304463e-29,
  5.322410228917757e-01, -1.983215678913275e-03,  3.702206500405611e-06,  1.610427186842624e-10, -2.297482921223868e-11,  5.662548419662210e-14,  4.123164876866257e-17,
 -6.178076658265758e-19,  1.322409774787996e-21,  2.376467204585137e-24, -2.036586553149205e-26,  3.411974978184292e-29,  5.896903889786869e-01, -2.121797665368714e-03,
  3.526901600459570e-06,  2.085371347488604e-09, -2.643888558722251e-11,  4.420925268392632e-14,  1.188363133555216e-16, -6.943647354821493e-19,  5.857204261420273e-22,
  5.535240734870796e-24, -2.047227329643905e-26, -5.999765242142993e-30,  6.491220156930041e-01, -2.248807975848241e-03,  3.255712987478685e-06,  4.101424851432123e-09,
 -2.842581097158704e-11,  2.535592171883805e-14,  1.922780669950765e-16, -6.521216912773202e-19, -4.588472642572870e-22,  7.779443599386126e-24, -1.292466956036939e-26,
 -5.569104889757584e-29,  7.103275423580291e-01, -2.361955243780933e-03,  2.890483373871817e-06,  6.112161568675175e-09, -2.860884025877383e-11,  1.368739052240811e-15,
  2.493076142428624e-16, -4.775536909400721e-19, -1.603870596548188e-21,  8.164027339531330e-24,  1.354714057919760e-27, -9.449317447127850e-29,  7.730852185166533e-01,
 -2.459070470151015e-03,  2.436352811472595e-06,  8.012092108466783e-09, -2.678261196886517e-11, -2.563074487682792e-14,  2.784618831565844e-16, -1.834927818494888e-19,
 -2.570663522947022e-21,  6.150724367163343e-24,  1.844886020567826e-26, -1.013425738314022e-28,  8.371598656709532e-01, -2.538149887911288e-03,  1.901842135957759e-06,
  9.692894193779505e-09, -2.289719898008397e-11, -5.286491915920120e-14,  2.712285205071590e-16,  1.888052877446855e-19, -3.074285042278183e-21,  1.894981235976170e-24,
  3.232553323889237e-26, -6.501734630515707e-29,  9.023029404559021e-01, -2.597399760876244e-03,  1.298820314208470e-06,  1.104989886911895e-08, -1.708160184754465e-11,
 -7.717940960282452e-14,  2.240496329284755e-16,  5.740059328637144e-19, -2.904929092970357e-21, -3.651914456525718e-24,  3.688807701958333e-26,  7.504777998966883e-30,
  9.682527197290911e-01, -2.635282445484191e-03,  6.423388607447873e-07,  1.198914098779839e-08, -9.652499955718105e-12, -9.541991492181660e-14,  1.397409098877978e-16,
  8.937604783378359e-19, -2.004034809489747e-21, -8.912546421369352e-24,  2.858392182520290e-26,  8.993390502910821e-29,  1.034734629448086e+00, -2.650562836756659e-03,
 -4.968068688984172e-08,  1.243456187971931e-08, -1.104831382835259e-12, -1.048677763682327e-13,  2.792640073672341e-17,  1.073100536379325e-18, -5.095650444066664e-22,
 -1.212740439914046e-23,  8.508247597345544e-27,  1.455206364445973e-28,  1.101461740241272e+00, -2.642354095101129e-03, -7.569157597176915e-07,  1.233485531952607e-08,
  7.917838607673451e-12, -1.036777242412026e-13, -9.579297142824231e-17,  1.058995742957362e-18,  1.251291563080658e-21, -1.196454394364303e-23, -1.712223503919480e-26,
  1.437398883534273e-28,  1.168135453103597e+00, -2.610161316293956e-03, -1.457271396137889e-06,  1.166937197834479e-08,  1.667319919355872e-11, -9.124871362520574e-14,
 -2.120066834545074e-16,  8.365557175914951e-19,  2.831151062979151e-21, -8.088382246503519e-24, -3.875976104389817e-26,  7.749521506004494e-29,  1.234446398491158e+00,
 -2.553921574678352e-03, -2.127663406748770e-06,  1.045245727935127e-08,  2.438784865942583e-11, -6.845539812751413e-14, -3.007830524239671e-16,  4.379717437614237e-19,
  3.782905726928076e-21, -1.445286127984332e-24, -4.724444602891797e-26, -2.885084884036618e-29,  1.300075571057575e+00, -2.474038554971577e-03, -2.744940755880767e-06,
  8.735608799918047e-09,  3.033743264904066e-11, -3.767702682003783e-14, -3.455581750090738e-16, -5.970487212418595e-20,  3.800387277459485e-21,  5.913651401764422e-24,
 -3.803733859513844e-26, -1.274241375670111e-28,  1.364695720172663e+00, -2.371409810856213e-03, -3.286920068637713e-06,  6.606916864222768e-09,  3.393121495896026e-11,
 -2.584284164113086e-15, -3.368500643042609e-16, -5.493671996685042e-19,  2.833366898280036e-21,  1.148958232893173e-23, -1.393596958826988e-26, -1.695291590220776e-28,
  1.427973012997598e+00, -2.247444572237603e-03, -3.733492368340795e-06,  4.187406756199497e-09,  3.479078112882625e-11,  3.231789892379554e-14, -2.749035032676559e-16,
 -9.190858713725155e-19,  1.130680016845601e-21,  1.327573018174446e-23,  1.541612721196577e-26, -1.323698333638574e-28,  1.489568982091082e+00, -2.104069993963663e-03,
 -4.067749212608124e-06,  1.624136917376203e-09,  3.281136876590059e-11,  6.234646552156648e-14, -1.704601127850166e-16, -1.081874996926965e-18, -8.165083477892711e-22,
  1.061027097896938e-23,  3.752424426395854e-26, -3.418645611269026e-29,  1.549142763163309e+00, -1.943723824258595e-03, -4.277063540024624e-06, -9.197822216048785e-10,
  2.819466671230545e-11,  8.340152156176245e-14, -4.317869396343651e-17, -1.001473636389448e-18, -2.425090621800196e-21,  4.541154045314369e-24,  4.294113777054272e-26,
  7.340219276037389e-29,  1.606353620624494e+00, -1.769331696950693e-03, -4.354051258472054e-06, -3.277719945570956e-09,  2.144420430189771e-11,  9.269975708233816e-14,
  8.222883496727406e-17, -7.053970947866432e-19, -3.218574022147930e-21, -2.533095172147678e-24,  3.009631434995127e-26,  1.339849549799762e-28,  1.660863749036141e+00,
 -1.584267638735189e-03, -4.297334572316484e-06, -5.293696221942833e-09,  1.331876725167209e-11,  8.932914357625088e-14,  1.814407651135437e-16, -2.793903330751141e-19,
 -3.000617022119979e-21, -7.860266631557017e-24,  6.236580165638141e-27,  1.196081965747637e-28,  1.712341327634354e+00, -1.392296943282188e-03, -4.112028930062958e-06,
 -6.836929804652835e-09,  4.745338938814456e-12,  7.448771551864952e-14,  2.362805920813903e-16,  1.569454807439465e-19, -1.930051097215500e-21, -9.544942183653431e-24,
 -1.640578240045892e-26,  4.710864734985289e-29,  1.760463793071295e+00, -1.197501296895759e-03, -3.809883702314092e-06, -7.815241812351049e-09, -3.299878311451708e-12,
  5.131871576954376e-14,  2.392326993341768e-16,  4.867895001826803e-19, -4.574026790213178e-22, -7.384136039910636e-24, -2.728723203538430e-26, -3.440334597007327e-29,
  1.804921282891086e+00, -1.004186927452469e-03, -3.409023157913411e-06, -8.185686365419363e-09, -9.926947192453929e-12,  2.433506987031365e-14,  1.953221525883291e-16,
  6.330274642291674e-19,  8.591696957353368e-22, -2.879614262396629e-24, -2.318762718043478e-26, -7.704108321674627e-29,  1.845420189663349e+00, -8.167775512823202e-04,
 -2.933259038143146e-06, -7.960877659991454e-09, -1.446357414549158e-11, -1.476824821400171e-15,  1.205956090800307e-16,  5.820324005220223e-19,  1.582941508579002e-21,
  1.605992266051328e-24, -9.330357956075496e-27, -6.493707284262736e-29,  1.881686753945981e+00, -6.396949522635876e-04, -2.410977984313379e-06, -7.209814063767601e-09,
 -1.655969988735880e-11, -2.169411818100082e-14,  3.742682496567153e-17,  3.847265775461743e-19,  1.569659703519389e-21,  4.101072722959655e-24,  4.669994437411769e-27,
 -2.014544333139626e-29,  1.913470614318166e+00, -4.772310649231461e-04, -1.873643973661678e-06, -6.052558187403062e-09, -1.624473956083945e-11, -3.339950102554201e-14,
 -3.207899491307519e-17,  1.337452295394721e-19,  9.995983362862079e-22,  3.982339032455008e-24,  1.121694230721107e-26,  1.923949653630833e-29,  1.940548225930763e+00,
 -3.334163542726997e-04, -1.353994301359821e-06, -4.648868252449310e-09, -1.392352408866931e-11, -3.579245871211213e-14, -7.256627177819977e-17, -7.464246094273921e-20,
  2.560892751590466e-22,  2.097100651224100e-24,  9.067539782603233e-27,  2.954573384611643e-29,  1.962726058036427e+00, -2.118899812582171e-04, -8.840431261856802e-07,
 -3.181698318697778e-09, -1.030736771310176e-11, -3.029922113233633e-14, -7.967035732533853e-17, -1.782559465614049e-19, -2.849055685207861e-22,  2.299395461482350e-26,
  2.770784286226812e-27,  1.548438847205251e-29,  1.979843496736308e+00, -1.157775624923323e-04, -4.930342015972764e-07, -1.837267385591470e-09, -6.289026109390670e-12,
 -2.013095595750841e-14, -6.054202351242851e-17, -1.703186035916608e-19, -4.413864747052304e-22, -1.015246337096030e-24, -1.865398914343643e-27, -1.518724606888193e-30,
  1.991775496396340e+00, -4.758171275177596e-05, -2.054976182481039e-07, -7.839944427128170e-10, -2.782019986694843e-12, -9.385486322914278e-15, -3.042236239650518e-17,
 -9.522888425153324e-20, -2.883668180201933e-22, -8.440633605416309e-25, -2.379958166567354e-27, -6.419228170514967e-30,  1.998436635093381e+00, -9.080852565659417e-06,
 -3.952554022212493e-08, -1.527480332003310e-10, -5.526109156201147e-13, -1.915944327710036e-15, -6.445113380956078e-18, -2.118886708614368e-20, -6.838943477923478e-23,
 -2.173548781165458e-25, -6.815825723850248e-28, -2.111629794229575e-30,  4.562310920231323e-04, -2.193016663777020e-06,  7.904397127915673e-09, -2.531806210001022e-11,
  7.599980344774261e-14, -2.189232875819173e-16,  6.128090784416739e-19, -1.679456861176714e-21,  4.527921319860137e-24, -1.204861628843251e-26,  3.171550934688075e-29,
 -8.272535877811367e-32,  4.104493275946954e-03, -1.970009016509592e-05,  7.078617042796127e-08, -2.255382385783452e-10,  6.716100053813641e-13, -1.912731489347542e-15,
  5.272388292333284e-18, -1.416219071800211e-20,  3.721859874318489e-23, -9.592499574657843e-26,  2.427604352083250e-28, -6.035143939495492e-31,  1.139254803957237e-02,
 -5.451676275380389e-05,  1.946722313864920e-07, -6.136880178561814e-10,  1.797763452592909e-12, -5.000692732480118e-15,  1.334256060870128e-17, -3.430201059770248e-20,
  8.504742733652913e-23, -2.029385118201434e-25,  4.634171338123419e-28, -1.001548074804028e-30,  2.230341784689683e-02, -1.062489448749201e-04,  3.758428136946248e-07,
 -1.165691661327120e-09,  3.329090820850268e-12, -8.918480608615794e-15,  2.254187964811158e-17, -5.362877194504203e-20,  1.187491433291762e-22, -2.382752594174803e-25,
  4.047514960318212e-28, -4.496570003509244e-31,  3.681154073684705e-02, -1.743076748405053e-04,  6.088062789733709e-07, -1.846687880087866e-09,  5.089210032630357e-12,
 -1.290403601070825e-14,  2.996080671389645e-17, -6.216676505360582e-20,  1.075207612724433e-22, -1.173320019244596e-25, -1.313487504700695e-28,  1.394136399953950e-30,
  5.488265599970656e-02, -2.579117944748017e-04,  8.864047052152706e-07, -2.612500994508383e-09,  6.864065768428580e-12, -1.609056457339097e-14,  3.259932097466196e-17,
 -5.111756598107063e-20,  3.083438918825316e-23,  1.879568412674360e-25, -1.090772299930993e-27,  3.897478411287384e-30,  7.647365255613950e-02, -3.560916306663848e-04,
  1.199954566371100e-06, -3.411549031008330e-09,  8.418616698505111e-12, -1.761715774988167e-14,  2.796266179281512e-17, -1.554494197524536e-20, -1.114281633799954e-22,
  6.184072862591939e-25, -2.105526983187781e-27,  5.486694603808896e-30,  1.015323808053249e-01, -4.676937802931712e-04,  1.539422284919616e-06, -4.187141523967048e-09,
  9.515955255045520e-12, -1.674655556704224e-14,  1.462735694949926e-17,  4.352244738934191e-20, -2.937104204857161e-22,  1.026845969494500e-24, -2.582750214827011e-27,
  4.317429991520578e-30,  1.299974289915412e-01, -5.913871198280868e-04,  1.893634222392599e-06, -4.880106370384853e-09,  9.937752797598978e-12, -1.297818103608252e-14,
 -7.313335983991355e-18,  1.180979973407831e-19, -4.666699318943462e-22,  1.213427884894768e-24, -1.937940321518293e-27, -6.281055175618019e-31,  1.617978654842533e-01,
 -7.256701841276882e-04,  2.250520344875767e-06, -5.431670850002474e-09,  9.504760915709302e-12, -6.144007855087032e-15, -3.600745054882417e-17,  1.937237843099375e-19,
 -5.669249672401935e-22,  9.916355733832001e-25,  9.903844611282601e-29, -8.516993454347361e-30,  1.968529487898630e-01, -8.688800810134363e-04,  2.597390337203929e-06,
 -5.786506989011140e-09,  8.095978252399290e-12,  3.524778000981773e-15, -6.786917022045499e-17,  2.515617480945283e-19, -5.333741657599671e-22,  2.678487036336789e-25,
  3.225791388885649e-27, -1.631914581166616e-29,  2.350718076291234e-01, -1.019203128652311e-03,  2.921240316651440e-06, -5.895836097989780e-09,  5.665024621983608e-12,
  1.537087545427728e-14, -9.790348346218353e-17,  2.719094825690596e-19, -3.267966284738106e-22, -8.911282996294774e-25,  6.488689149269836e-27, -1.956921642830094e-29,
  2.763530940388785e-01, -1.174687420582192e-03,  3.209087491153816e-06, -5.720472054694200e-09,  2.252265208522589e-12,  2.833162786916148e-14, -1.203241245461803e-16,
  2.386388596602520e-19,  5.211541027332590e-23, -2.230166701632226e-24,  8.474770123910336e-27, -1.422384389639590e-29,  3.205846132069062e-01, -1.333257537392455e-03,
  3.448329097887975e-06, -5.233668487222964e-09, -2.008686613354235e-12,  4.101153290894156e-14, -1.294130847363162e-16,  1.437713371541068e-19,  5.517723327765450e-22,
 -3.338445345419203e-24,  7.776049309131872e-27,  9.756813199375295e-31,  3.676429346410065e-01, -1.492731633135061e-03,  3.627120729744099e-06, -4.423622498286792e-09,
 -6.891272558069227e-12,  5.180570265127579e-14, -1.205238635946421e-16, -8.782374897266270e-21,  1.070575083473481e-21, -3.748125852629618e-24,  3.611812078605053e-27,
  2.269416557512170e-29,  4.173929903244408e-01, -1.650841126727804e-03,  3.734767702310089e-06, -3.295478342450944e-09, -1.208398121345050e-11,  5.906773693606005e-14,
 -9.108982671896350e-17, -2.013200856545486e-19,  1.472398261873984e-21, -3.083125601596647e-24, -3.609538334009660e-27,  4.289808692664365e-29,  4.696876667344113e-01,
 -1.805253221756569e-03,  3.762121437158187e-06, -1.872670255685124e-09, -1.720648234014913e-11,  6.130926763708498e-14, -4.147078559817974e-17, -4.031130165267672e-19,
  1.616011925610666e-21, -1.219895398409055e-24, -1.205253897737178e-26,  5.114491344733913e-29,  5.243673990109236e-01, -1.953596459621875e-03,  3.701970960546288e-06,
 -1.974464997106152e-10, -2.183380009197368e-11,  5.741231572925584e-14,  2.453723168866620e-17, -5.742759003731097e-19,  1.393675363829886e-21,  1.593412907097366e-24,
 -1.875154858062593e-26,  3.896875669615909e-29,  5.812597771683334e-01, -2.093489477945049e-03,  3.549417585719366e-06,  1.669571051129894e-09, -2.552774293089207e-11,
  4.683031408305960e-14,  9.968533143701727e-17, -6.725917454531244e-19,  7.702157417065225e-22,  4.714377378412188e-24, -2.049175775630910e-26,  4.863660592366460e-30,
  6.401791760430157e-01, -2.222573095237078e-03,  3.302218737905799e-06,  3.650913319189945e-09, -2.787403230331146e-11,  2.975007834047834e-14,  1.738544604273171e-16,
 -6.624281821152189e-19, -1.886480896462821e-22,  7.217346563728977e-24, -1.508410632413443e-26, -4.250642040008848e-29,  7.009264226607473e-01, -2.338545770469577e-03,
  2.961084807808503e-06,  5.654959572739552e-09, -2.852274356209279e-11,  7.186135901418967e-15,  2.352617888019680e-16, -5.241725899084788e-19, -1.309968586217419e-21,
  8.137681875784175e-24, -2.604171679562846e-27, -8.519026606993409e-29,  7.632885168671064e-01, -2.439202388717429e-03,  2.529911040786776e-06,  7.579830600660401e-09,
 -2.722885933057427e-11, -1.901839930185802e-14,  2.722066804917817e-16, -2.620775220992789e-19, -2.337032901584366e-21,  6.799102378540117e-24,  1.396585332124597e-26,
 -1.019219966036147e-28,  8.270384233578809e-01, -2.522476197989162e-03,  2.015924994435333e-06,  9.318435903342812e-09, -2.388903146067052e-11, -4.630304089137123e-14,
  2.751497900919278e-16,  9.176339015768967e-20, -2.983517472560599e-21,  3.126800667644471e-24,  2.917232836152236e-26, -7.779794694513067e-29,  8.919349556181592e-01,
 -2.586483564800758e-03,  1.429729289308759e-06,  1.076454196884086e-08, -1.857017104793622e-11, -7.161996792963271e-14,  2.388026588398106e-16,  4.792297399307912e-19,
 -3.009816896637649e-21, -2.176127729143006e-24,  3.674648679971116e-26, -1.373428590933342e-29,  9.577227746474021e-01, -2.629571025123492e-03,  7.852195486508968e-07,
  1.181962439877336e-08, -1.152537206714711e-11, -9.177336454598617e-14,  1.638217773616611e-16,  8.247257964214181e-19, -2.303405686533493e-21, -7.695927333933018e-24,
  3.209818558430701e-26,  6.951037167334573e-29,  1.024132527602722e+00, -2.650363882907549e-03,  9.935892490521703e-08,  1.240015232702766e-08, -3.193062007069259e-12,
 -1.038392243074010e-13,  5.767983730592016e-17,  1.049887148049016e-18, -9.385026690509137e-22, -1.166128684201212e-23,  1.473355976246205e-26,  1.367301090474101e-28,
  1.090881153489435e+00, -2.647815352822766e-03, -6.082061875732055e-07,  1.244483754523816e-08,  5.823717291107216e-12, -1.056168107201413e-13, -6.564613393061466e-17,
  1.092025873049401e-18,  8.097927402959857e-22, -1.251987223515693e-23, -1.057659109044091e-26,  1.530136347469083e-28,  1.157672384585786e+00, -2.621254962951809e-03,
 -1.315699402746254e-06,  1.192127505919095e-08,  1.479929235381533e-11, -9.604583344126528e-14, -1.873606345106170e-16,  9.222015360618809e-19,  2.512952084248351e-21,
 -9.563132270143182e-24, -3.479733736565707e-26,  1.022482951111408e-28,  1.224197473189255e+00, -2.570434637066840e-03, -1.999939125012276e-06,  1.083132218794890e-08,
  2.294761652747825e-11, -7.551341506093429e-14, -2.868355360208596e-16,  5.578255245410787e-19,  3.696628583014268e-21, -3.352176615418603e-24, -4.789170994011771e-26,
 -2.578931693823057e-31,  1.290136173262242e+00, -2.495570580213006e-03, -2.637227384175461e-06,  9.214528471412916e-09,  2.950089455727723e-11, -4.597655571030995e-14,
 -3.454974889926273e-16,  6.500944515115840e-20,  3.984583069551130e-21,  4.284757924871100e-24, -4.328092634755616e-26, -1.100726314288510e-28,  1.355158005354604e+00,
 -2.397378816912468e-03, -3.204382811949011e-06,  7.148958524821721e-09,  3.379749385204252e-11, -1.084264965186433e-14, -3.509016679258739e-16, -4.522037310618525e-19,
  3.235146176178588e-21,  1.078148264134887e-23, -2.149611837995391e-26, -1.732396348527965e-28,  1.418923830495106e+00, -2.277102005816461e-03, -3.679883427374908e-06,
  4.748862973475237e-09,  3.536910079842396e-11,  2.541593610065346e-14, -3.000587342831291e-16, -8.751500837661242e-19,  1.618239480171710e-21,  1.376902152380646e-23,
  9.082062083897599e-27, -1.551950977221301e-28,  1.481087754284858e+00, -2.136525011129034e-03, -4.045069277813892e-06,  2.158861624179275e-09,  3.401492023302423e-11,
  5.788932353671915e-14, -2.010589397707868e-16, -1.101605494712868e-18, -4.079586556819287e-22,  1.207288424498560e-23,  3.539737570003779e-26, -6.287579880969693e-29,
  1.541299375939555e+00, -1.977976686819548e-03, -4.285339402487735e-06, -4.553893055186533e-10,  2.985001827935281e-11,  8.202013169732076e-14, -7.227942099513453e-17,
 -1.076123297303695e-18, -2.229957417377960e-21,  6.318456439629769e-24,  4.579291768609591e-26,  5.540463798896664e-29,  1.599206388331020e+00, -1.804315463186207e-03,
 -4.391263743886681e-06, -2.919680414969789e-09,  2.331627404822864e-11,  9.442452166660366e-14,  6.102380961608879e-17, -8.096065946516688e-19, -3.286667001971120e-21,
 -1.210476931312132e-24,  3.604873456726996e-26,  1.359122555125708e-28,  1.654457524102472e+00, -1.618896652724227e-03, -4.359520609427777e-06, -5.066069542519798e-09,
  1.514820507160161e-11,  9.357873707413514e-14,  1.722314240522788e-16, -3.798788315752451e-19, -3.277779397206286e-21, -7.500221044748012e-24,  1.189666198465839e-26,
  1.375765472399794e-28,  1.706705829765693e+00, -1.425519941391134e-03, -4.193566371467960e-06, -6.748776872806938e-09,  6.292119111367335e-12,  8.020388242101793e-14,
  2.397578676251001e-16,  8.956370619217256e-20, -2.284928850322043e-21, -1.015388247863130e-23, -1.389204400051516e-26,  6.758990493712183e-29,  1.755612234624368e+00,
 -1.228356315634062e-03, -3.903948498925153e-06, -7.859512310112112e-09, -2.214993727547563e-12,  5.722195462970477e-14,  2.526164077260861e-16,  4.676858915833563e-19,
 -7.432189242453701e-22, -8.503189202073513e-24, -2.859252682940340e-26, -2.438682899933521e-29,  1.800849364937526e+00, -1.031854687116735e-03, -3.508187478443975e-06,
 -8.340363128207657e-09, -9.391917146290479e-12,  2.923850316495850e-14,  2.134149301059230e-16,  6.586765204921213e-19,  7.379799060331403e-22, -3.876175155481940e-24,
 -2.666913484391961e-26, -8.097554767357627e-29,  1.842105536731257e+00, -8.406296810024705e-04, -3.030178523100372e-06, -8.192368237030457e-09, -1.446281784738454e-11,
  1.618807304175100e-15,  1.376098188732090e-16,  6.335337706596912e-19,  1.633321713624172e-21,  1.172428509557904e-24, -1.242871997372888e-26, -7.604104948609037e-29,
  1.879088844141331e+00, -6.593333840908998e-04, -2.499099634037700e-06, -7.478187749822391e-09, -1.698369733586907e-11, -2.066079270072515e-14,  4.892481800258085e-17,
  4.373520852156057e-19,  1.720425771009141e-21,  4.267779614481331e-24,  3.603891011931897e-27, -2.858716767183732e-29,  1.911531245455226e+00, -4.925152091070188e-04,
 -1.947856342441416e-06, -6.317858431538297e-09, -1.692010595191749e-11, -3.412070835352022e-14, -2.786412911298710e-17,  1.681144393731761e-19,  1.151240432969406e-21,
  4.447681049926832e-24,  1.204209744383019e-26,  1.812909662716931e-29,  1.939192537871723e+00, -3.444752965810236e-04, -1.411141310143901e-06, -4.877466750697997e-09,
 -1.465695336610413e-11, -3.755813075805829e-14, -7.452966906712944e-17, -6.516706711512701e-20,  3.384364077836660e-22,  2.486857998968975e-24,  1.044690590171308e-26,
  3.319439822855951e-29,  1.961864107592693e+00, -2.191178981293017e-04, -9.232333520054231e-07, -3.351569683148388e-09, -1.093288262416853e-11, -3.227223236111348e-14,
 -8.478887659515803e-17, -1.873369034743172e-19, -2.819104183149293e-22,  1.483603774505283e-25,  3.520984881988512e-27,  1.870509199935324e-29,  1.979372355850807e+00,
 -1.198117666748538e-04, -5.156987033917211e-07, -1.941193353679101e-09, -6.706569990600443e-12, -2.164282191522353e-14, -6.551428345846797e-17, -1.850422766732023e-19,
 -4.792933664526165e-22, -1.091068060198072e-24, -1.922140645385315e-27, -1.031063621105337e-30,  1.991581820912429e+00, -4.926409666870322e-05, -2.151789509274645e-07,
 -8.300490367772660e-10, -2.977252569818635e-12, -1.014869140770296e-14, -3.322266182287493e-17, -1.049617427861482e-19, -3.205368947438106e-22, -9.451488362729473e-25,
 -2.680390197378266e-27, -7.253445709064518e-30,  1.998399667449512e+00, -9.404542071057327e-06, -4.141285957792465e-08, -1.619049696321694e-10, -5.925259951789229e-13,
 -2.078001227208139e-15, -7.070255045200858e-18, -2.350797458642878e-20, -7.672820152896249e-23, -2.465715942171941e-25, -7.817025790232581e-28, -2.448067573317246e-30,
  4.475836003009980e-04, -2.130976409437835e-06,  7.607734419994323e-09, -2.413630956673017e-11,  7.176468581515032e-14, -2.047641864456246e-16,  5.677492932255402e-19,
 -1.541265480967234e-21,  4.116155881722515e-24, -1.084986925729904e-26,  2.829189237975507e-29, -7.310458978699463e-32,  4.026808607227876e-03, -1.914444682254639e-05,
  6.814294563067686e-08, -2.150917727791845e-10,  6.345893111767548e-13, -1.790821209068454e-15,  4.892014805094610e-18, -1.302462496670231e-20,  3.393387153476038e-23,
 -8.672549516758827e-26,  2.176988436630782e-28, -5.370098097513037e-31,  1.117754978443019e-02, -5.298836042552380e-05,  1.874773154863084e-07, -5.857068358603661e-10,
  1.700875576708733e-12, -4.691695846678101e-15,  1.241913227163037e-17, -3.169389245491123e-20,  7.806493382717019e-23, -1.852555247699396e-25,  4.214014119327910e-28,
 -9.096576187778162e-31,  2.188434822058575e-02, -1.032972634200230e-04,  3.621683141205851e-07, -1.113824273400813e-09,  3.156011815692488e-12, -8.395073182769946e-15,
  2.109220615601524e-17, -4.996296023104183e-20,  1.104578413880877e-22, -2.224857389359020e-25,  3.846244579242808e-28, -4.634388344931196e-31,  3.612391251838287e-02,
 -1.695245007250505e-04,  5.871261968657765e-07, -1.767286681318587e-09,  4.838180904467536e-12, -1.220547982386314e-14,  2.826766503451456e-17, -5.879458274752927e-20,
  1.032162959576009e-22, -1.214381672079872e-25, -7.583638082315851e-29,  1.136335904683384e-30,  5.386499535091594e-02, -2.509441140388113e-04,  8.557031601971802e-07,
 -2.505208407586805e-09,  6.549962981049154e-12, -1.532523891574710e-14,  3.118280201756472e-17, -5.003069686939791e-20,  3.685542099150667e-23,  1.476042438481295e-25,
 -9.304958249798855e-28,  3.397850408287035e-30,  7.506822922655106e-02, -3.466534851671058e-04,  1.159812655570983e-06, -3.279633600740342e-09,  8.072947329252447e-12,
 -1.695165989051176e-14,  2.748071722342163e-17, -1.877023199183303e-20, -9.062465496827499e-23,  5.388660147972054e-25, -1.875163153534947e-27,  4.988826773851256e-30,
  9.968592183868036e-02, -4.555768217959959e-04,  1.490079128482827e-06, -4.037546219047000e-09,  9.184628071801796e-12, -1.638190406147734e-14,  1.571982049307774e-17,
  3.469560933903732e-20, -2.585578636272904e-22,  9.273233069739872e-25, -2.393806839402540e-27,  4.259538697500109e-30,  1.276618115617204e-01, -5.764696078692970e-04,
  1.836018376725534e-06, -4.723187276734250e-09,  9.676693270702563e-12, -1.311566782354691e-14, -4.209200019539103e-18,  1.038484940129761e-19, -4.243862415528448e-22,
  1.135603473490506e-24, -1.947534872443098e-27,  1.612123527349087e-31,  1.589307839034182e-01, -7.079241659094524e-04,  2.186248549534270e-06, -5.280622862532334e-09,
  9.373667881342946e-12, -6.945112481883174e-15, -3.083179888271917e-17,  1.761534301536927e-19, -5.312403769786657e-22,  9.886166823623072e-25, -2.376843691150575e-28,
 -6.828084218837161e-30,  1.934185500518827e-01, -8.483765037507685e-04,  2.528731513382492e-06, -5.656493513599336e-09,  8.150745826855249e-12,  1.978523748035045e-15,
 -6.106277370904112e-17,  2.346715910377446e-19, -5.215765075426931e-22,  3.831307872011399e-25,  2.553193428203858e-27, -1.427632547175057e-29,  2.310412890811806e-01,
 -9.961146428180496e-04,  2.851043864093696e-06, -5.802861463151965e-09,  5.949555759170446e-12,  1.311134384785837e-14, -9.044089813610851e-17,  2.609871309412065e-19,
 -3.544095574562827e-22, -6.484320997592423e-25,  5.655525779977502e-27, -1.827900396028165e-29,  2.717052559209081e-01, -1.149288648639472e-03,  3.140676240796404e-06,
 -5.680057379252146e-09,  2.790561876500159e-12,  2.552414811046130e-14, -1.136304991493208e-16,  2.390861624928227e-19, -2.222187713280690e-23, -1.903937308956624e-24,
  7.831552475221550e-27, -1.493204894321141e-29,  3.153063578735763e-01, -1.305922605811418e-03,  3.385358766920398e-06, -5.259412979235564e-09, -1.219179174019963e-12,
  3.795581235041020e-14, -1.251579327912254e-16,  1.595651586967531e-19,  4.371877783410680e-22, -3.027591466295634e-24,  7.742036771131941e-27, -2.403975977575504e-30,
  3.617297033011158e-01, -1.463928797879709e-03,  3.573409380205782e-06, -4.525751125457242e-09, -5.884084669114963e-12,  4.891392661228904e-14, -1.203102276949454e-16,
  2.334684411368181e-20,  9.384686156475109e-22, -3.585331839445566e-24,  4.488099163400232e-27,  1.723170741356078e-29,  4.108491271215522e-01, -1.621124365910534e-03,
  3.694100494938103e-06, -3.479491807191778e-09, -1.092491754945803e-11,  5.681915827443212e-14, -9.608401832897746e-17, -1.560034913223108e-19,  1.359247148323692e-21,
 -3.191362645045899e-24, -1.842113903704622e-27,  3.743623856544006e-29,  4.625266989825493e-01, -1.775250725774654e-03,  3.738037850495460e-06, -2.138222301266118e-09,
 -1.599113422020324e-11,  6.018432251140356e-14, -5.204121685367651e-17, -3.521919763755030e-19,  1.563954366968788e-21, -1.657643617511972e-24, -9.852701775683412e-27,
  4.870074029821549e-29,  5.166122214329751e-01, -1.923996020715289e-03,  3.697543538796155e-06, -5.375747099263710e-10, -2.068094104817829e-11,  5.781334002934719e-14,
  9.089484254486130e-18, -5.289018259651199e-19,  1.437960102321041e-21,  8.786928489706113e-25, -1.696138654850546e-26,  4.213872177160108e-29,  5.729427271175446e-01,
 -2.065020869399884e-03,  3.567033086719130e-06,  1.268743653147743e-09, -2.456872256906580e-11,  4.899970748793428e-14,  8.122220883801750e-17, -6.453869651769428e-19,
  9.252570139518697e-22,  3.901839502940182e-24, -2.006743091338500e-26,  1.415872142097791e-29,  6.313419859890940e-01, -2.195987636569631e-03,  3.343374142793907e-06,
  3.209909205531877e-09, -2.723881057524219e-11,  3.369956319816608e-14,  1.552601669670837e-16, -6.644276090097763e-19,  5.989971917137169e-23,  6.580371533142018e-24,
 -1.667180711848302e-26, -2.976517149671399e-29,  6.916200357768691e-01, -2.314593399242911e-03,  3.026211862062527e-06,  5.200047166976699e-09, -2.832377017338906e-11,
  1.265182979091800e-14,  2.200419465819634e-16, -5.614315346519828e-19, -1.019762722705756e-21,  7.961603978623196e-24, -6.122023142728996e-27, -7.453004178393980e-29,
  7.535727514649093e-01, -2.418606701386867e-03,  2.618243627979681e-06,  7.141478220910797e-09, -2.754453480651032e-11, -1.258171792518585e-14,  2.638590338694893e-16,
 -3.328472220421392e-19, -2.083286488122606e-21,  7.268534559845990e-24,  9.522874476869144e-27, -9.957747963947275e-29,  8.169814723037253e-01, -2.505908078972875e-03,
  2.125423482403718e-06,  8.929162389657237e-09, -2.474890349533518e-11, -3.967928993684962e-14,  2.764010373702853e-16, -1.689804640989253e-21, -2.850801816381516e-21,
  4.222171994856484e-24,  2.552634199321309e-26, -8.739359472773054e-29,  8.816127078608778e-01, -2.574534190375671e-03,  1.557074808030385e-06,  1.045627580150501e-08,
 -1.994422739316480e-11, -6.573862870302582e-14,  2.508629303078062e-16,  3.819442935697669e-19, -3.061899815462328e-21, -7.242762865165532e-25,  3.570285770670609e-26,
 -3.338999849320033e-29,  9.472179477432792e-01, -2.622725199733602e-03,  9.258887483653767e-07,  1.162075602931819e-08, -1.331969575304351e-11, -8.757311013348311e-14,
  1.858423230320710e-16,  7.468373624693564e-19, -2.556668912171353e-21, -6.357174636443833e-24,  3.468061822202803e-26,  4.771638043117881e-29,  1.013533602791913e+00,
 -2.648974830007076e-03,  2.477859557803911e-07,  1.233253420247813e-08, -5.253641357272530e-12, -1.021059233027968e-13,  8.659399546247686e-17,  1.013263466966705e-18,
 -1.346282474951407e-21, -1.095514055619596e-23,  2.047964314336624e-26,  1.238176991975197e-28,  1.080281108610810e+00, -2.652082227111974e-03, -4.583790160338419e-07,
  1.252104317303067e-08,  3.698116075817619e-12, -1.068228880827419e-13, -3.477488521645272e-17,  1.110659418329505e-18,  3.531005121362497e-22, -1.280662290176832e-23,
 -3.728758946369753e-27,  1.574296831270319e-28,  1.147167225048946e+00, -2.631204459096168e-03, -1.171287527258611e-06,  1.214246102390881e-08,  1.283554626369199e-11,
 -1.002238696056156e-13, -1.604668069142726e-16,  9.968482092248894e-19,  2.144771023729325e-21, -1.085833132212447e-23, -2.980200959605242e-26,  1.242847292061459e-28,
  1.213884567453002e+00, -2.585908122033347e-03, -1.867811322931795e-06,  1.118603342186895e-08,  2.136984140720488e-11, -8.219679625644427e-14, -2.695811072299867e-16,
  6.738175619193499e-19,  3.541545055148453e-21, -5.259316035499221e-24, -4.724691684431265e-26,  2.970283095359595e-29,  1.280112406839932e+00, -2.516218150483750e-03,
 -2.523852758230383e-06,  9.678736886507219e-09,  2.849866651159986e-11, -5.423211366574980e-14, -3.418713774661040e-16,  1.946408875275748e-19,  4.106560902717530e-21,
  2.462878083760205e-24, -4.765052542317578e-26, -8.776441209325607e-29,  1.345517776235549e+00, -2.422661555954710e-03, -3.115359399844943e-06,  7.687521936753013e-09,
  3.349546081812614e-11, -1.940417951425715e-14, -3.620569470381933e-16, -3.426497793108549e-19,  3.605965771102885e-21,  9.769319465352648e-24, -2.909827179621635e-26,
 -1.713414665797560e-28,  1.409756918880004e+00, -2.306303471368106e-03, -3.619486153444953e-06,  5.318435639171556e-09,  3.580345277710211e-11,  1.792678778548190e-14,
 -3.237630267203943e-16, -8.153790802712989e-19,  2.118761149374006e-21,  1.398957065613782e-23,  1.798606759772307e-27, -1.753301589538010e-28,  1.472477110380911e+00,
 -2.168772601699036e-03, -4.015860177008234e-06,  2.712089950229450e-09,  3.512194823230163e-11,  5.269270557611669e-14, -2.320194063252108e-16, -1.107438864392334e-18,
  5.140372376472626e-23,  1.342454861515084e-23,  3.196282099926592e-26, -9.348076657012512e-29,  1.533318880778191e+00, -2.012273017514335e-03, -4.287884672755717e-06,
  3.522956870832741e-11,  3.147059246945732e-11,  7.991600756704531e-14, -1.033731525373219e-16, -1.143484590563233e-18, -1.968992265593219e-21,  8.192522162834260e-24,
  4.774280385319600e-26,  3.239909800761984e-29,  1.591918653505941e+00, -1.839579231767547e-03, -4.423998990183945e-06, -2.531440453371609e-09,  2.521751245318147e-11,
  9.560515066751221e-14,  3.687789884383337e-17, -9.151871971321241e-19, -3.302850862402039e-21,  3.506791660456074e-25,  4.199061973476905e-26,  1.333657362009950e-28,
  1.647911806146797e+00, -1.654011724945918e-03, -4.418796737180775e-06, -4.808504906511535e-09,  1.706019148874388e-11,  9.757255360876085e-14,  1.600865052840419e-16,
 -4.889839099525141e-19, -3.537716292134867e-21, -6.898187046640807e-24,  1.832881973548959e-26,  1.545563978578682e-28,  1.700936142610608e+00, -1.459390578251629e-03,
 -4.273893701244942e-06, -6.634957001942172e-09,  7.953897630992280e-12,  8.597956090475353e-14,  2.411863214560703e-16,  1.049630889066619e-20, -2.659694366797866e-21,
 -1.064348239370560e-23, -1.042015050783120e-26,  9.062399429177855e-29,  1.750635748129751e+00, -1.259965673555210e-03, -3.998436440461593e-06, -7.885462884897832e-09,
 -1.008881103945650e-12,  6.343891260521724e-14,  2.653310465236132e-16,  4.387824329644838e-19, -1.070145626324577e-21, -9.664638713720314e-24, -2.938145456398940e-26,
 -1.085657052037727e-29,  1.796665177776220e+00, -1.060323032694008e-03, -3.609153243906442e-06, -8.485671032087449e-09, -8.754420404560857e-12,  3.458430886222627e-14,
  2.321660013321523e-16,  6.798462952210226e-19,  5.783696206640057e-22, -5.015000110395765e-24, -3.028846140177693e-26, -8.321021717221296e-29,  1.838693906981919e+00,
 -8.652682730923114e-04, -3.129873706045099e-06, -8.423328732252792e-09, -1.439594781419453e-11,  5.140251798798358e-15,  1.560861147729225e-16,  6.863726847904097e-19,
  1.665742812788654e-21,  6.049147650191733e-25, -1.603358309640922e-26, -8.792974242510689e-29,  1.876410950105958e+00, -6.796897847096503e-04, -2.590481739794743e-06,
 -7.753164558722531e-09, -1.738414656187683e-11, -1.933328281433986e-14,  6.196470763748102e-17,  4.948891435076125e-19,  1.876331615831233e-21,  4.383909792753583e-24,
  2.128306386804443e-27, -3.879350032634262e-29,  1.909529532194092e+00, -5.084059714113679e-04, -2.025317606599367e-06, -6.594074097657696e-09, -1.760880407200084e-11,
 -3.472864680573431e-14, -2.261642656005563e-17,  2.076104924132335e-19,  1.320214797994207e-21,  4.944787162884661e-24,  1.279814955350585e-26,  1.605718226980408e-29,
  1.937791682032628e+00, -3.560025898802849e-04, -1.471103083494799e-06, -5.118085089450296e-09, -1.542614421428238e-11, -3.936742948592081e-14, -7.618867668625516e-17,
 -5.282109775345198e-20,  4.358472947489912e-22,  2.935072257479447e-24,  1.199207670916634e-26,  3.707490316168187e-29,  1.960972605283432e+00, -2.266676638152631e-04,
 -9.645234076736963e-07, -3.531771728722162e-09, -1.159910672559956e-11, -3.437112403913231e-14, -9.015959940360885e-17, -1.962437259727714e-19, -2.738262802681660e-22,
  3.067349634360114e-25,  4.425451510332369e-27,  2.251072230754172e-29,  1.978884707454754e+00, -1.240323912310020e-04, -5.396514202391711e-07, -2.052048548914177e-09,
 -7.155578645802316e-12, -2.327910887381525e-14, -7.091620174938268e-17, -2.010230363948958e-19, -5.199650194777723e-22, -1.168674311759157e-24, -1.953151193393921e-27,
 -3.408247160826489e-31,  1.991381257414849e+00, -5.102619615510759e-05, -2.254321968657040e-07, -8.793532113692744e-10, -3.188444016394721e-12, -1.098249369342962e-14,
 -3.631045751770252e-17, -1.157846619576283e-19, -3.565714829680521e-22, -1.059016319637056e-24, -3.019837008528423e-27, -8.194559180676782e-30,  1.998361374138926e+00,
 -9.743780772886549e-06, -4.341400367835441e-08, -1.717273142587122e-10, -6.358376665249123e-13, -2.255871899982252e-15, -7.764231290874584e-18, -2.611155430044742e-20,
 -8.619457204296189e-23, -2.801055646639318e-25, -8.978682261144250e-28, -2.842602628265382e-30,  4.391796112077029e-04, -2.071253863445908e-06,  7.324855329385066e-09,
 -2.302011092805403e-11,  6.780224174564359e-14, -1.916415378443238e-16,  5.263806996093186e-19, -1.415585740809161e-21,  3.745179018906230e-24, -9.779964144855942e-27,
  2.526472608176065e-29, -6.467699525274097e-32,  3.951305000238007e-03, -1.860945773551158e-05,  6.562160331951048e-08, -2.052186178296933e-10,  5.999180528287535e-13,
 -1.677669248730171e-15,  4.542070041860384e-18, -1.198705946774540e-20,  3.096296567454955e-23, -7.847228542868734e-26,  1.953895489523007e-28, -4.782434723468803e-31,
  1.096855210992115e-02, -5.151620021923819e-05,  1.806090726381380e-07, -5.592276001450686e-10,  1.609951802917259e-12, -4.404009585163045e-15,  1.156569651832471e-17,
 -2.929934530436615e-20,  7.168972854228309e-23, -1.691747535075717e-25,  3.832468657999449e-28, -8.259338514033217e-31,  2.147687040459387e-02, -1.004525346211183e-04,
  3.490999470367173e-07, -1.064644260377330e-09,  2.993061198735108e-12, -7.905255669704931e-15,  1.974154522775955e-17, -4.655353180094996e-20,  1.027203519405752e-22,
 -2.075104575314706e-25,  3.641086490873809e-28, -4.677244716443619e-31,  3.545507605454475e-02, -1.649110232412190e-04,  5.663752843294022e-07, -1.691792355645228e-09,
  4.600724113180649e-12, -1.154644167081605e-14,  2.666699676725347e-17, -5.556210136726867e-20,  9.880135702949952e-23, -1.235383663229487e-25, -3.075660705861443e-29,
  9.188932468864120e-31,  5.287472223428880e-02, -2.442169802034043e-04,  8.262594715152962e-07, -2.402820849576860e-09,  6.250829314274815e-12, -1.459352405209744e-14,
  2.979920300733815e-17, -4.877320244824575e-20,  4.153402005852056e-23,  1.132404947087300e-25, -7.909084648117640e-28,  2.956088548820906e-30,  7.369992610255093e-02,
 -3.375302360283166e-04,  1.121220982786776e-06, -3.153143058563253e-09,  7.740465313309175e-12, -1.629873975609711e-14,  2.691736646139440e-17, -2.137388946720395e-20,
 -7.252397584683004e-23,  4.681093347707170e-25, -1.666090019641962e-27,  4.519408997506138e-30,  9.788715245827698e-02, -4.438475175335549e-04,  1.442499553355856e-06,
 -3.893192462031999e-09,  8.860836733723358e-12, -1.599387539532277e-14,  1.658035266493887e-17,  2.693778055871916e-20, -2.268528716289091e-22,  8.352885471784792e-25,
 -2.208789672063866e-27,  4.141921275630255e-30,  1.253849541515651e-01, -5.620055617508840e-04,  1.780260420474176e-06, -4.570463218544316e-09,  9.413597462022604e-12,
 -1.318329287293504e-14, -1.485528391104430e-18,  9.090723257938912e-20, -3.849032521901412e-22,  1.058037131884423e-24, -1.926290389081815e-27,  7.783650809597965e-31,
  1.561336694744868e-01, -6.906851085825072e-04,  2.123776237792559e-06, -5.131793956253015e-09,  9.227755727397692e-12, -7.627776262047412e-15, -2.613216448660490e-17,
  1.597207857007491e-19, -4.958896289074964e-22,  9.735461137653407e-25, -5.052170345507027e-28, -5.368668763447842e-30,  1.900650769807998e-01, -8.284159438285099e-04,
  2.461637116738159e-06, -5.525842442115123e-09,  8.176183780623997e-12,  5.899942323316059e-16, -5.472342835139558e-17,  2.182203423925461e-19, -5.060916826501298e-22,
  4.732646999133517e-25,  1.967318804065357e-27, -1.237946872715800e-29,  2.271020085042170e-01, -9.735831918010967e-04,  2.781988962086060e-06, -5.705686229640944e-09,
  6.190662030212767e-12,  1.102715237664532e-14, -8.329524097900384e-17,  2.493146398574634e-19, -3.738712839248680e-22, -4.378910971479832e-25,  4.881706074004318e-27,
 -1.688193535703791e-29,  2.671579215833694e-01, -1.124435084589155e-03,  3.072799818361948e-06, -5.631470425836868e-09,  3.274315090064836e-12,  2.287720752421442e-14,
 -1.069559225387272e-16,  2.373375620621613e-19, -8.528426359767120e-23, -1.603921747243870e-24,  7.167330490725583e-27, -1.519362916302188e-29,  3.101364330817872e-01,
 -1.279092462475644e-03,  3.322153296354212e-06, -5.273008575755000e-09, -4.897311865362251e-13,  3.500711814873342e-14, -1.205102088779139e-16,  1.718707852650744e-19,
  3.337355140495715e-22, -2.720866924452050e-24,  7.574543352286856e-27, -5.102605248077206e-30,  3.559308165398474e-01, -1.435560286031869e-03,  3.518567270324184e-06,
 -4.612226854641969e-09, -4.934610604238219e-12,  4.603760120108489e-14, -1.192552307612777e-16,  5.134873052985641e-20,  8.127972906841757e-22, -3.392122041222169e-24,
  5.136889720520208e-27,  1.235763120048844e-29,  4.044234667421150e-01, -1.591741463591270e-03,  3.651334892104551e-06, -3.645326114309045e-09, -9.811923414755778e-12,
  5.446553311122093e-14, -9.986052821852222e-17, -1.143569025558423e-19,  1.243414166436503e-21, -3.233702844065938e-24, -3.142620937428116e-28,  3.203342550504362e-29,
  4.554853361596024e-01, -1.745453316206617e-03,  3.710883526908001e-06, -2.384522070789361e-09, -1.480070744980199e-11,  5.882259430537723e-14, -6.121143007788400e-17,
 -3.031721636530472e-19,  1.497693580250326e-21, -2.009793756218191e-24, -7.778264128242989e-27,  4.548337719785501e-29,  5.089753493655003e-01, -1.894447013278296e-03,
  3.689145453602942e-06, -8.592127208734334e-10, -1.952366534083860e-11,  5.785900093952831e-14, -5.071717623675384e-18, -4.825082534054938e-19,  1.457833266494111e-21,
  2.379119887766450e-25, -1.506556442488683e-26,  4.380205814165202e-29,  5.647398032584861e-01, -2.036430312565903e-03,  3.579932079440440e-06,  8.835838767187580e-10,
 -2.357068100491860e-11,  5.073566049398713e-14,  6.358590897034312e-17, -6.136848386709989e-19,  1.051446673796725e-21,  3.113978497027677e-24, -1.926973499798246e-26,
  2.183183518352026e-29,  6.226117629916491e-01, -2.169093924234569e-03,  3.379301007708037e-06,  2.779676307001017e-09, -2.652906176171033e-11,  3.720299035462619e-14,
  1.367177105689169e-16, -6.588515761551008e-19,  2.845065343520161e-22,  5.890892485280803e-24, -1.771501523749420e-26, -1.780641524104886e-29,  6.824104659246173e-01,
 -2.290141785079699e-03,  3.085902611038152e-06,  4.749172663871289e-09, -2.801921477726407e-11,  1.774077104114904e-14,  2.039077249827398e-16, -5.895315350591228e-19,
 -7.383127898336882e-22,  7.654481027842030e-24, -9.150177292596658e-27, -6.301159640253814e-29,  7.439407487102352e-01, -2.397325470426962e-03,  2.701289892918439e-06,
  6.699093360203457e-09, -2.773363579195302e-11, -6.368226744829618e-15,  2.536458114694141e-16, -3.952606945127822e-19, -1.815807432950525e-21,  7.563092319535463e-24,
  5.240762398512122e-27, -9.467597086575333e-29,  8.069925157997464e-01, -2.488482880992371e-03,  2.230172515044325e-06,  8.527191474612329e-09, -2.547620953232774e-11,
 -3.305639401056822e-14,  2.751007747809477e-16, -9.029408015062950e-20, -2.681370941786592e-21,  5.164216893857801e-24,  2.152971244861532e-26, -9.373663500081416e-29,
  8.713402711856392e-01, -2.561581213282970e-03,  1.680593153423912e-06,  1.012698054458534e-08, -2.119798390167146e-11, -5.960067123790559e-14,  2.601836664827940e-16,
  2.838187469723434e-19, -3.062670523373144e-21,  6.691338922826285e-25,  3.384026303043888e-26, -5.087304270846959e-29,  9.367427390535427e-01, -2.614764047916574e-03,
  1.064002135690807e-06,  1.139387847898899e-08, -1.502491061226190e-11, -8.287140374019414e-14,  2.055759071586705e-16,  6.616336734275447e-19, -2.760110871121351e-21,
 -4.934519690152834e-24,  3.628945735721314e-26,  2.539475188294398e-29,  1.002942603098740e+00, -2.646402164129423e-03,  3.952050186395891e-07,  1.223226146567853e-08,
 -7.272705867163341e-12, -9.969243754458899e-14,  1.143041363604763e-16,  9.640407545576543e-19, -1.724650787805253e-21, -1.003160666440853e-23,  2.557702670312554e-26,
  1.073495949117382e-28,  1.069666398443084e+00, -2.655147405893201e-03, -3.078420998755957e-07,  1.256308661268609e-08,  1.555836105616191e-12, -1.072834536447186e-13,
 -3.587668574274176e-18,  1.114566801110766e-18, -1.089508902683471e-22, -1.281704904730295e-23,  3.202994558831596e-27,  1.568185739036182e-28,  1.136624594165510e+00,
 -2.639988583568596e-03, -1.024412581840473e-06,  1.233159432109568e-08,  1.079485620933618e-11, -1.037327456270568e-13, -1.316545415629414e-16,  1.059007455202356e-18,
  1.733784048155239e-21, -1.193533256920748e-23, -2.391393361735708e-26,  1.426868815971313e-28,  1.203511908160701e+00, -2.600307997605935e-03, -1.731582787613572e-06,
  1.151445450599338e-08,  1.966279962932123e-11, -8.842772181550492e-14, -2.491586497711284e-16,  7.837559814693587e-19,  3.318588044543381e-21, -7.114140837879507e-24,
 -4.527415800665677e-26,  5.991253046424270e-29,  1.270007899009039e+00, -2.535936726860609e-03, -2.405009275158755e-06,  1.012559473328639e-08,  2.733249359580909e-11,
 -6.235670946807262e-14, -3.345710284779534e-16,  3.270944860066526e-19,  4.160053869171061e-21,  4.871944418853538e-25, -5.093888361815833e-26, -6.103464206246145e-29,
  1.335777881332489e+00, -2.447206351912090e-03, -3.019907916791756e-06,  8.219869495505620e-09,  3.301977516771820e-11, -2.819532082477309e-14, -3.699844831107394e-16,
 -2.218710266904245e-19,  3.934910089797221e-21,  8.456505740873890e-24, -3.648426307353208e-26, -1.633534542642601e-28,  1.400474211198135e+00, -2.334994312677991e-03,
 -3.552217351068194e-06,  5.893729364054737e-09,  3.608247769735228e-11,  9.890634679612405e-15, -3.455687143586632e-16, -7.395222468252131e-19,  2.621774428623683e-21,
  1.390211629983645e-23, -6.289925333039229e-27, -1.915956549653045e-28,  1.463737985920003e+00, -2.200759671552636e-03, -3.979909622225468e-06,  3.282158867862563e-09,
  3.611760890200738e-11,  4.675278140851244e-14, -2.629303020831324e-16, -1.097823250455409e-18,  5.566252785912930e-22,  1.461154812423713e-23,  2.715741261678545e-26,
 -1.250050430969361e-28,  1.525201197474506e+00, -2.046565723333930e-03, -4.284388463182154e-06,  5.513998003912789e-10,  3.304147404922282e-11,  7.704400696166618e-14,
 -1.362258500377995e-16, -1.201402551937667e-18, -1.639414155958935e-21,  1.012287163675456e-23,  4.857111186966051e-26,  4.455870826402980e-30,  1.584489370081011e+00,
 -1.875085728079261e-03, -4.451892163579756e-06, -2.112624268420778e-09,  2.713632888663383e-11,  9.617079776986180e-14,  9.777255146541876e-18, -1.020340893838154e-18,
 -3.258595524871083e-21,  2.145767337601204e-24,  4.770671586435912e-26,  1.255176844092913e-28,  1.641224699801173e+00, -1.689588117064313e-03, -4.474795956865006e-06,
 -4.519726369474151e-09,  1.904888723961724e-11,  1.012373146918580e-13,  1.447738131521493e-16, -6.060091082644131e-19, -3.771173173735869e-21, -6.024424118303760e-24,
  2.546890038868300e-26,  1.695831270629749e-28,  1.695029696970823e+00, -1.493897909605486e-03, -4.352691845967903e-06, -6.493623480803349e-09,  9.731346155276695e-12,
  9.176158520490997e-14,  2.402305462769553e-16, -8.081676738497772e-20, -3.049335153701492e-21, -1.097324897900500e-23, -5.884069556597985e-27,  1.158938991463261e-28,
  1.745531310899882e+00, -1.292331843017565e-03, -4.093115845988817e-06, -7.891104661466995e-09,  3.245503651854532e-13,  6.995008936068192e-14,  2.770836032040464e-16,
  3.987434661303773e-19, -1.439298801950523e-21, -1.084460569390039e-23, -2.948961042789382e-26,  6.625520874887470e-30,  1.792365490992670e+00, -1.089605897489812e-03,
 -3.711797896567382e-06, -8.619899017133458e-09, -8.005462425943007e-12,  4.038663727752031e-14,  2.514319573820192e-16,  6.952244812715996e-19,  3.751377319745311e-22,
 -6.299928569914688e-24, -3.395737350936451e-26, -8.311795710834254e-29,  1.835182110221232e+00, -8.907154890491999e-04, -3.232331591833093e-06, -8.652631277851175e-09,
 -1.425409421936720e-11,  9.122978606561893e-15,  1.760531491422879e-16,  7.398933221164083e-19,  1.675010146224347e-21, -1.174387026012516e-25, -2.017474895645643e-26,
 -1.003717319798726e-28,  1.873650147305211e+00, -7.007905478524239e-04, -2.685201077626094e-06, -8.034318591700186e-09, -1.775478259419052e-11, -1.767291593628279e-14,
  7.668602275095103e-17,  5.574697762902798e-19,  2.035242367012579e-21,  4.431468527249121e-24,  1.609276722254621e-28, -5.097551318072152e-29,  1.907462995245504e+00,
 -5.249298703845387e-04, -2.106159951789061e-06, -6.881398973637655e-09, -1.830830870676034e-11, -3.519674197192108e-14, -1.618440318603764e-17,  2.528056965797384e-19,
  1.507604291121519e-21,  5.469969803434400e-24,  1.343692355345248e-26,  1.274868397105372e-29,  1.936343739045957e+00, -3.680213390301034e-04, -1.534027320040135e-06,
 -5.371302008849858e-09, -1.623188931292513e-11, -4.121202856895692e-14, -7.745584435265539e-17, -3.708754244444479e-20,  5.505480878563129e-22,  3.448564449221947e-24,
  1.371206897247943e-26,  4.112877125419967e-29,  1.960050229315086e+00, -2.345565840939485e-04, -1.008041253587299e-06, -3.722976270206902e-09, -1.230861766037062e-11,
 -3.660187099853946e-14, -9.577518269037117e-17, -2.047933109170445e-19, -2.593473494812685e-22,  5.048292501385744e-25,  5.511894242494693e-27,  2.699261954157459e-29,
  1.978379784716254e+00, -1.284500832353428e-04, -5.649786074495704e-07, -2.170356887463208e-09, -7.638646515981541e-12, -2.505056106385838e-14, -7.678422356027864e-17,
 -2.183501660036652e-19, -5.634448608163584e-22, -1.246841876044346e-24, -1.948321701077529e-27,  6.083862737285355e-31,  1.991173477637469e+00, -5.287274694753227e-05,
 -2.362979309175533e-07, -9.321739893857027e-10, -3.417077815868023e-12, -1.189417376116554e-14, -3.971807385788148e-17, -1.278289791732836e-19, -3.969599909806213e-22,
 -1.187323979283387e-24, -3.403265740763455e-27, -9.254685710902400e-30,  1.998321691091733e+00, -1.009951215720429e-05, -4.553729422999024e-08, -1.822720352959893e-10,
 -6.828793923047300e-13, -2.451308184230664e-15, -8.535536784418877e-18, -2.903830533894036e-20, -9.695616384294634e-23, -3.186527811377491e-25, -1.032866497064503e-27,
 -3.306043667169803e-30,  4.310100695683072e-04, -2.013741830827191e-06,  7.054998717228450e-09, -2.196526454257530e-11,  6.409260044256750e-14, -1.794708137780487e-16,
  4.883705689010362e-19, -1.301183658424938e-21,  3.410625653934415e-24, -8.824044987391360e-27,  2.258505033339847e-29, -5.728557712922992e-32,  3.877901745388393e-03,
 -1.809417473703628e-05,  6.321548365559518e-08, -1.958825453402827e-10,  5.674281457655661e-13, -1.572577814997308e-15,  4.219889613917723e-18, -1.103997640238662e-20,
  2.827371692237898e-23, -7.106179703238653e-26,  1.755133069776572e-28, -4.262711981359933e-31,  1.076533516242642e-02, -5.009773925352575e-05,  1.740500382655905e-07,
 -5.341582055007226e-10,  1.524582243700505e-12, -4.136023742071344e-15,  1.077653696343785e-17, -2.709982968247313e-20,  6.586682687563253e-23, -1.545487496181250e-25,
  3.486081797895318e-28, -7.497432449347931e-31,  2.108056608599959e-02, -9.771003570758833e-05,  3.366064145117584e-07, -1.017994815724212e-09,  2.839590363494929e-12,
 -7.446735937258669e-15,  1.848296181586430e-17, -4.338323588157437e-20,  9.550717698489121e-23, -1.933572813184168e-25,  3.435724984583500e-28, -4.646855399371256e-31,
  3.480436713373052e-02, -1.604599929299647e-04,  5.465079361364932e-07, -1.619993949314163e-09,  4.376071173079354e-12, -1.092474946472876e-14,  2.515485109567644e-17,
 -5.247177780601153e-20,  9.434105943003292e-23, -1.240161689666023e-25,  5.534752417843316e-30,  7.359679584014117e-31,  5.191089422202311e-02, -2.377205615384799e-04,
  7.980161938184204e-07, -2.305104147808781e-09,  5.966000815728704e-12, -1.389457723422580e-14,  2.845273134403703e-17, -4.738474583151635e-20,  4.507148670959391e-23,
  8.408723556451252e-26, -6.695917457516366e-28,  2.566448791261782e-30,  7.236750799525181e-02, -3.287097381733375e-04,  1.084115706717902e-06, -3.031868519667988e-09,
  7.420900919260885e-12, -1.566015171376205e-14,  2.628885073514515e-17, -2.343750688356474e-20, -5.682490145396450e-23,  4.053113905147781e-25, -1.477003283441931e-27,
  4.080601247318641e-30,  9.613454986905735e-02, -4.324920083663014e-04,  1.396621398881501e-06, -3.753956231536354e-09,  8.544995481630342e-12, -1.558768895290722e-14,
  1.723738149575010e-17,  2.014291685941168e-20, -1.983292940567899e-22,  7.505371026017777e-25, -2.029957457842619e-27,  3.980816697472203e-30,  1.231650723044760e-01,
 -5.479803201700650e-04,  1.726309862265203e-06, -4.421956082298539e-09,  9.149774209699372e-12, -1.318975786963114e-14,  8.930579709688550e-19,  7.918496300872922e-20,
 -3.481912202974148e-22,  9.818190558032070e-25, -1.881179529947898e-27,  1.250213637937780e-30,  1.534045229715231e-01, -6.739387266487012e-04,  2.063075434230656e-06,
 -4.985402896464512e-09,  9.069281599114971e-12, -8.203042929045015e-15, -2.187690257818769e-17,  1.444087409884949e-19, -4.612591456954571e-22,  9.489955006229161e-25,
 -7.132089446588339e-28, -4.118268236018961e-30,  1.867903825755933e-01, -8.089858629664825e-04,  2.396112084917689e-06, -5.394998417158440e-09,  8.175335577059891e-12,
 -6.518597807056429e-16, -4.883732426383299e-17,  2.023121628667305e-19, -4.877641652690555e-22,  5.415874047088049e-25,  1.461495106983895e-27, -1.063874741556403e-29,
  2.232517563266904e-01, -9.515994531160802e-04,  2.714121963392980e-06, -5.604977560792307e-09,  6.391772621588949e-12,  9.110471139451040e-15, -7.648403486646336e-17,
  2.371347926873093e-19, -3.862956926693388e-22, -2.570547154855848e-25,  4.170667755214410e-27, -1.543346997191952e-29,  2.627089193524093e-01, -1.100122072130578e-03,
  3.005551160834517e-06, -5.575558248473714e-09,  3.706726287635357e-12,  2.038965100924408e-14, -1.003569716606279e-16,  2.337386307369807e-19, -1.380260737064968e-22,
 -1.330593343348051e-24,  6.499814744340655e-27, -1.509531263901028e-29,  3.050728168167960e-01, -1.252768421525265e-03,  3.258852779434581e-06, -5.275398624365441e-09,
  1.818843896080368e-13,  3.217374007922760e-14, -1.155626245507975e-16,  1.810410985958447e-19,  2.411778178024774e-22, -2.423031639517098e-24,  7.302031398495306e-27,
 -7.189267468218489e-30,  3.502445201389036e-01, -1.407634408002922e-03,  3.462776707993020e-06, -4.683969576652189e-09, -4.042348660696815e-12,  4.319555651842425e-14,
 -1.174714027782893e-16,  7.544502315505496e-20,  6.944985735160710e-22, -3.177072847443698e-24,  5.584455477569096e-27,  8.085495612401338e-30,  3.981146415415374e-01,
 -1.562708347014579e-03,  3.606684556743078e-06, -3.793733630940179e-09, -8.746815860392411e-12,  5.203484511425397e-14, -1.025229745307109e-16, -7.643002441410361e-20,
  1.127100123721233e-21, -3.219635090099286e-24,  9.796975504640620e-28,  2.682421108265023e-29,  4.485627102412676e-01, -1.715884641965354e-03,  3.680886950845035e-06,
 -2.612004384243688e-09, -1.363960620368698e-11,  5.725700089161862e-14, -6.904056669567315e-17, -2.564598077483004e-19,  1.420213223177119e-21, -2.281975131010987e-24,
 -5.858271131101374e-27,  4.171540037765713e-29,  5.014565149582584e-01, -1.864980314416753e-03,  3.676998782274869e-06, -1.162345038272812e-09, -1.836876960026807e-11,
  5.758043231779683e-14, -1.792835914312208e-17, -4.358330747431129e-19,  1.456017273272614e-21, -3.259731970012911e-25, -1.312616549940312e-26,  4.415259854113535e-29,
  5.566514191250445e-01, -2.007754777501349e-03,  3.588306038911684e-06,  5.146478297423671e-10, -2.254207894432164e-11,  5.205942454811717e-14,  4.688958529819648e-17,
 -5.783916609819805e-19,  1.149924698276070e-21,  2.364300821951747e-24, -1.817000094109504e-26,  2.789437263038590e-29,  6.139896572550498e-01, -2.141933249939206e-03,
  3.410135447844057e-06,  2.361335825868066e-09, -2.575367784898170e-11,  4.026406108521977e-14,  1.184282239426735e-16, -6.464923065914936e-19,  4.836651837200129e-22,
  5.169917630897005e-24, -1.825421926732361e-26, -6.892927896952339e-30,  6.732996234415135e-01, -2.265234196464517e-03,  3.140215393157652e-06,  4.303963989338110e-09,
 -2.761681128669939e-11,  2.243405606861247e-14,  1.871109699120162e-16, -6.088244170043515e-19, -4.699760121048395e-22,  7.236515524949929e-24, -1.166131503958606e-26,
 -5.110305923443396e-29,  7.343951659381149e-01, -2.375401145901228e-03,  2.779013442016275e-06,  6.254663147614705e-09, -2.780105464496156e-11, -4.198479970989791e-16,
  2.418062035572107e-16, -4.489777679069500e-19, -1.540749379385271e-21,  7.691338695400682e-24,  1.222836232192601e-27, -8.764258223687525e-29,  7.970749052563900e-01,
 -2.470239173130261e-03,  2.330032438666457e-06,  8.114640798681504e-09, -2.607156737307139e-11, -2.649383254034673e-14,  2.714003729992396e-16, -1.729652928805480e-19,
 -2.480962650922013e-21,  5.941761495935886e-24,  1.732454277189268e-26, -9.689406360723813e-29,  8.611215972168100e-01, -2.547656227217197e-03,  1.800043682981026e-06,
  9.778618477346855e-09, -2.232696665263813e-11, -5.327194327526481e-14,  2.667639721955521e-16,  1.864553021700199e-19, -3.014798183069663e-21,  1.973401281981623e-24,
  3.126490518843873e-26, -6.572398494940890e-29,  9.263015668974031e-01, -2.605709335632102e-03,  1.199232476019832e-06,  1.114049467276471e-08, -1.663155212503397e-11,
 -7.772540769382803e-14,  2.228404228281819e-16,  5.707497906907712e-19, -2.911415428474055e-21, -3.467125418467192e-24,  3.691974554477171e-26,  3.368903955020308e-30,
  9.923642443831640e-01, -2.642655504124976e-03,  5.412286870737271e-07,  1.210010549565731e-08, -9.236968800763039e-12, -9.663178332477767e-14,  1.404718025537938e-16,
  9.032800915839444e-19, -2.066284631258007e-21, -8.919563699828410e-24,  2.988431543489779e-26,  8.802978962104577e-29,  1.059041838522966e+00, -2.657006854395989e-03,
 -1.570064935277854e-07,  1.257082055761227e-08, -5.881700112159810e-13, -1.069958823410727e-13,  2.750228011520632e-17,  1.103735905612083e-18, -5.664067026229612e-22,
 -1.255221827819976e-23,  9.997833201891370e-27,  1.512333488730363e-28,  1.126049190367095e+00, -2.647589190233676e-03, -8.754661357049217e-07,  1.248755329301975e-08,
  8.691036728897064e-12, -1.065307620646704e-13, -1.012914353278720e-16,  1.107441731315262e-18,  1.288448316301759e-21, -1.276186392642084e-23, -1.731063898560136e-26,
  1.566814341710261e-28,  1.193083853314911e+00, -2.613602754292157e-03, -1.591581098619853e-06,  1.181459363579151e-08,  1.783628564413173e-11, -9.413243638931564e-14,
 -2.257677160229980e-16,  8.855092176541895e-19,  3.030596510132436e-21, -8.863659102249517e-24, -4.198840163485650e-26,  8.918689922232267e-29,  1.259826451865558e+00,
 -2.554683435676548e-03, -2.280920778470342e-06,  1.055250466132782e-08,  2.600588197016914e-11, -7.026146562352971e-14, -3.235488736088930e-16,  4.600988491432676e-19,
  4.140348499189879e-21, -1.595365894870419e-24, -5.296784702038619e-26, -3.066824502555227e-29,  1.325941374727384e+00, -2.470962126132625e-03, -2.918119761303202e-06,
  8.743190334369381e-09,  3.236664396328974e-11, -3.713499756645606e-14, -3.743903540020386e-16, -9.137845817634390e-20,  4.211376770324735e-21,  6.857136083949136e-24,
 -4.337995204845318e-26, -1.490382072379668e-28,  1.391077860265000e+00, -2.363119325971261e-03, -3.478023631516930e-06,  6.472174023369948e-09,  3.619572761347969e-11,
  1.358446687736958e-15, -3.650259869142941e-16, -6.476831235207003e-19,  3.115655692897245e-21,  1.347820280238825e-23, -1.498780287294257e-26, -2.028448259763503e-28,
  1.454871532083896e+00, -2.232431512130197e-03, -3.937026707594068e-06,  3.867167785436528e-09,  3.698708388567706e-11,  4.007609156092681e-14, -2.933394775705886e-16,
 -1.071396648261687e-18,  1.100784385036582e-21,  1.557858009537163e-23,  2.096650484338957e-26, -1.562435709801289e-28,  1.516946439112943e+00, -2.080805260672443e-03,
 -4.274549441940080e-06,  1.092201248222209e-09,  3.454690604381659e-11,  7.336533731436475e-14, -1.705421211635427e-16, -1.247658226613100e-18, -1.240056097604810e-21,
  1.206037420496420e-23,  4.806688627358017e-26, -2.809207663678426e-29,  1.576917646947753e+00, -1.910794744057964e-03, -4.474575080251204e-06, -1.663052853641781e-09,
  2.905971670517937e-11,  9.605091907957609e-14, -2.023784045085168e-17, -1.123001098661931e-18, -3.145700301911646e-21,  4.160863526699473e-24,  5.294697180533405e-26,
  1.116240869784802e-28,  1.634394414617563e+00, -1.725598095210044e-03, -4.527136568330970e-06, -4.198563435275876e-09,  2.110693352066368e-11,  1.044944375838053e-13,
  1.260849558398138e-16, -7.299452719322312e-19, -3.967881676050912e-21, -4.852651171663373e-24,  3.320701795839798e-26,  1.815457712871228e-28,  1.688983972670766e+00,
 -1.529028349865953e-03, -4.429619543716560e-06, -6.322927800495498e-09,  1.162399135804370e-11,  9.748857110317270e-14,  2.365419236220759e-16, -1.847510672764229e-19,
 -3.447308512821488e-21, -1.109878483527187e-23, -1.961034178739646e-28,  1.428777436873959e-28,  1.740295894218108e+00, -1.325455345841489e-03, -4.187730597494779e-06,
 -7.874354826604525e-09,  1.790928109373692e-12,  7.672850028408586e-14,  2.875433053350706e-16,  3.462126805926197e-19, -1.850811951669102e-21, -1.201226552897675e-23,
 -2.873457811161959e-26,  2.843348341248875e-29,  1.787947020533601e+00, -1.119716149750185e-03, -3.815977473799799e-06, -8.741190046546882e-09, -7.135803154898980e-12,
  4.665573706860427e-14,  2.710302990726028e-16,  7.033308613861910e-19,  1.230153512719489e-22, -7.730690165319021e-24, -3.755791191875169e-26, -7.997535531050667e-29,
  1.831566867906221e+00, -9.169933298049669e-04, -3.337524775889781e-06, -8.879000382830051e-09, -1.402767254835554e-11,  1.360290548602004e-14,  1.975187695833247e-16,
  7.932613919302489e-19,  1.655158302946751e-21, -1.016478688241464e-24, -2.486945116337598e-26, -1.130232885521937e-28,  1.870803404435944e+00, -7.226626592529555e-04,
 -2.783328685234539e-06, -8.321117339779023e-09, -1.808853326606661e-11, -1.563763476927421e-14,  9.323093044729734e-17,  6.251466731454209e-19,  2.194313866944987e-21,
  4.388986010138450e-24, -2.389581464287379e-27, -6.532983418663372e-29,  1.905329047117333e+00, -5.421144906333610e-04, -2.190517628503938e-06, -7.179981988967321e-09,
 -1.901552547982521e-11, -3.549458774966027e-14, -8.400087929989516e-18,  3.043044907741193e-19,  1.714321278363489e-21,  6.017357057794505e-24,  1.389698891250575e-26,
  7.875226076220252e-30,  1.934846694717300e+00, -3.805558584608340e-04, -1.600068733507934e-06, -5.637707480598728e-09, -1.707479261199730e-11, -4.308132087912086e-14,
 -7.822821079587658e-17, -1.737416095435807e-20,  6.850162874536381e-22,  4.034455872032765e-24,  1.561264276871889e-26,  4.526496410685096e-29,  1.959095586571563e+00,
 -2.428030213836188e-04, -1.053923163281607e-06, -3.925897309244787e-09, -1.306411036510928e-11, -3.897020536248978e-14, -1.016225336122213e-16, -2.127566816067330e-19,
 -2.369052592057483e-22,  7.505464846601983e-25,  6.812260576909712e-27,  3.225201298639533e-29,  1.977856776794196e+00, -1.330762056752295e-04, -5.917730636406598e-07,
 -2.296685564002123e-09, -8.158591876699635e-12, -2.696882751272988e-14, -8.315730624682568e-17, -2.371135507173735e-19, -6.097243704343460e-22, -1.323889681512234e-24,
 -1.894767302316104e-27,  1.886830462094999e-30,  1.990958133701136e+00, -5.480882261331314e-05, -2.478200795727088e-07, -9.888033378813799e-10, -3.664791134413786e-12,
 -1.289183393265105e-14, -4.348174117612924e-17, -1.412426874133281e-19, -4.422552279936313e-22, -1.331939552185415e-24, -3.836192786016346e-27, -1.044664322654708e-29,
  1.998280550326491e+00, -1.047274911163320e-05, -4.779176976354285e-08, -1.936017281131577e-10, -7.340218016520750e-13, -2.666279423096814e-15, -9.393828785690595e-18,
 -3.233271394592433e-20, -1.092077768465059e-22, -3.630308307106163e-25, -1.190005860596514e-27, -3.851353933606900e-30,  4.230663371214059e-04, -1.958339009318859e-06,
  6.797452011179882e-09, -2.096787359956242e-11,  6.061750453352644e-14, -1.681750724205328e-16,  4.534188461397580e-19, -1.196956741845954e-21,  3.108631876303090e-24,
 -7.969082743365741e-27,  2.021032027609395e-29, -5.079515936395519e-32,  3.806521821890661e-03, -1.759770124459401e-05,  6.091834585415202e-08, -1.870499080133808e-10,
  5.369648428284474e-13, -1.474909974823393e-15,  3.923061765305671e-18, -1.017482993705273e-20,  2.583746936127102e-23, -6.440243591971435e-26,  1.577897161621106e-28,
 -3.802688082223746e-31,  1.056768898726540e-02, -4.873057005161571e-05,  1.677838147446522e-07, -5.104128545662975e-10,  1.444387884765703e-12, -3.886259269541519e-15,
  1.004643247279880e-17, -2.507848331447928e-20,  6.054631039072694e-23, -1.412433269210586e-25,  3.171673695225725e-28, -6.804780780417572e-31,  2.069503535386966e-02,
 -9.506528693854665e-05,  3.246582395105700e-07, -9.737291527525846e-10,  2.694994920293342e-12, -7.017382604978034e-15,  1.730999065605604e-17, -4.043576750163467e-20,
  8.878877873764612e-23, -1.800211242887648e-25,  3.232981585064671e-28, -4.560849341276652e-31,  3.417114982823229e-02, -1.561645152540433e-04,  5.274810061465466e-07,
 -1.551692461980098e-09,  4.163496087606230e-12, -1.033832654073546e-14,  2.372723559360860e-17, -4.952419400993180e-20,  8.988783368112460e-23, -1.231942758962110e-25,
  3.444274381105693e-29,  5.825134480515919e-31,  5.097260731045556e-02, -2.314454751157389e-04,  7.709186286609487e-07, -2.211834612889486e-09,  5.694831311472778e-12,
 -1.322746736045489e-14,  2.714656996087570e-17, -4.589897867468121e-20,  4.764278171870100e-23,  5.945789842416366e-26, -5.643719286683306e-28,  2.223557160310702e-30,
  7.106978729038065e-02, -3.201803473053219e-04,  1.048435465695923e-06, -2.915605675225795e-09,  7.113953046707778e-12, -1.503728669410212e-14,  2.560925723540766e-17,
 -2.503350299803697e-20, -4.325497951908955e-23,  3.497000209803186e-25, -1.306531267963978e-27,  3.673360245583952e-30,  9.442664572752625e-02, -4.214969263819436e-04,
  1.352384029098877e-06, -3.619707677344911e-09,  8.237420755818226e-12, -1.516791652166618e-14,  1.771648379054929e-17,  1.421335692722850e-20, -1.727298082742459e-22,
  6.727873944111670e-25, -1.858923189513888e-27,  3.789418931270518e-30,  1.210004394000247e-01, -5.343796264625227e-04,  1.674116068139967e-06, -4.277668160052797e-09,
  8.886366607426005e-12, -1.314294524740971e-14,  2.959457990029792e-18,  6.859396344133425e-20, -3.141858993423809e-22,  9.077832361278701e-25, -1.818062781776175e-27,
  1.600475445284533e-30,  1.507414018471958e-01, -6.576709683165528e-04,  2.004115747775229e-06, -4.841634060062471e-09,  8.900289316141241e-12, -8.681203804894718e-15,
 -1.803500717465714e-17,  1.301892290669539e-19, -4.276495004399868e-22,  9.171686411214538e-25, -8.704008584095367e-28, -3.056182057809495e-30,  1.835923700347192e-01,
 -7.900737039150303e-04,  2.332156304797541e-06, -5.264359134846929e-09,  8.151027230117039e-12, -1.757724034926491e-15, -4.338809569935798e-17,  1.870260598205506e-19,
 -4.673231924649809e-22,  5.911620201024984e-25,  1.028749151187375e-27, -9.057927699461730e-30,  2.194883609592412e-01, -9.301537645586524e-04,  2.647481538785170e-06,
 -5.501349026352125e-09,  6.556156446428894e-12,  7.353127315829419e-15, -7.001849033500792e-17,  2.246561619935611e-19, -3.927065290656877e-22, -1.033802238520701e-25,
  3.523663625573191e-27, -1.397769984343465e-29,  2.583560976032196e-01, -1.076344251257224e-03,  2.939013346895455e-06, -5.513116933538248e-09,  4.090960993013950e-12,
  1.805907826810390e-14, -9.388097660163560e-17,  2.286042592860530e-19, -1.814068152328999e-22, -1.083790609132683e-24,  5.843103464707123e-27, -1.471449212857814e-29,
  3.001134839779674e-01, -1.226950721017548e-03,  3.195586208120323e-06, -5.267489631192677e-09,  7.980389349066168e-13,  2.946186039793701e-14, -1.103981414040507e-16,
  1.874188453217382e-19,  1.591253607816362e-22, -2.137768879096917e-24,  6.949850953467065e-27, -8.735811674523984e-30,  3.446690294855849e-01, -1.380158059731720e-03,
  3.406209022538181e-06, -4.741888286809866e-09, -3.206447021690842e-12,  4.040399956153544e-14, -1.150646900244512e-16,  9.588272326008947e-20,  5.842201787904586e-22,
 -2.947704329599562e-24,  5.857189305445069e-27,  4.408079225604112e-30,  3.919212235270333e-01, -1.534039270687763e-03,  3.560353966975358e-06, -3.925491455104639e-09,
 -7.730877205349591e-12,  4.955258205934941e-14, -1.041754321655835e-16, -4.220754686973668e-20,  1.012169655410379e-21, -3.158312378853854e-24,  2.050643390501981e-27,
  2.191077218793887e-29,  4.417578622286697e-01, -1.686566546107944e-03,  3.648270987581024e-06, -2.821169342350270e-09, -1.251159135948145e-11,  5.551891484957193e-14,
 -7.559783783162727e-17, -2.123691089556064e-19,  1.334275685556853e-21, -2.480789666288803e-24, -4.112479819425033e-27,  3.759583768062041e-29,  4.940553304044526e-01,
 -1.835625025675569e-03,  3.661325156180671e-06, -1.447059915868477e-09, -1.722242507837392e-11,  5.700896237157263e-14, -2.948185415454764e-17, -3.895258241178816e-19,
  1.435298363458601e-21, -8.123152673732901e-25, -1.119648530987302e-26,  4.339422004845901e-29,  5.486778434735329e-01, -1.979029678039157e-03,  3.592352315708810e-06,
  1.623597880594741e-10, -2.149092693971500e-11,  5.299466681701959e-14,  3.122159491575263e-17, -5.403700168557378e-19,  1.222266212042290e-21,  1.663486314178265e-24,
 -1.683783912858508e-26,  3.241123578384084e-29,  6.054766560764849e-01, -2.114545765062911e-03,  3.436026182466000e-06,  1.955867539473403e-09, -2.492143034796940e-11,
  4.289103290057509e-14,  1.005700936835098e-16, -6.281784859836591e-19,  6.565930566042153e-22,  4.436626787412144e-24, -1.833980048161612e-26,  2.787949049535838e-30,
  6.642892466452731e-01, -2.239913359164358e-03,  3.189227328076248e-06,  3.865922626893772e-09, -2.712461211982163e-11,  2.671869230094858e-14,  1.698918347263038e-16,
 -6.197896295481215e-19, -2.183675040504302e-22,  6.728603524888140e-24, -1.364773761123053e-26, -3.922592453167673e-29,  7.249384902500894e-01, -2.352876375032079e-03,
  2.851401230918512e-06,  5.810090041680242e-09, -2.775246410483801e-11,  5.227329006595234e-15,  2.285862201856093e-16, -4.938494945779222e-19, -1.263887926623599e-21,
  7.665583982594524e-24, -2.447097521234923e-27, -7.893502322334596e-29,  7.872318357338984e-01, -2.451216540309061e-03,  2.424888913366423e-06,  7.693608808137699e-09,
 -2.653674572840926e-11, -2.004710886612614e-14,  2.654789354870465e-16, -2.488082560773509e-19, -2.255615733069037e-21,  6.549220932945056e-24,  1.304731815254659e-26,
 -9.705113204667383e-29,  8.509605075044178e-01, -2.532792655706676e-03,  1.915209687618929e-06,  9.413212940048364e-09, -2.332801531521828e-11, -4.681778634297608e-14,
  2.706464580546006e-16,  9.135392088905472e-20, -2.921976247056840e-21,  3.162435730711750e-24,  2.810012124989051e-26, -7.762456253334350e-29,  9.158987574122185e-01,
 -2.595585372090343e-03,  1.331271439985244e-06,  1.086224960020055e-08, -1.813133897772904e-11, -7.219609843458337e-14,  2.375003706587559e-16,  4.758723659105536e-19,
 -3.009671278975123e-21, -1.993642858935051e-24,  3.660161179948271e-26, -1.759569501857910e-29,  9.818031978945794e-01, -2.637747527668208e-03,  6.854800435570400e-07,
  1.193704454582862e-08, -1.113388243855066e-11, -9.296471790915579e-14,  1.647913638387458e-16,  8.322592310085261e-19, -2.364994698591365e-21, -7.652894466123214e-24,
  3.329340853893803e-26,  6.666075443361645e-29,  1.048412253943928e+00, -2.657659829288432e-03, -6.283583660164541e-09,  1.254433682463156e-08, -2.718996183525274e-12,
 -1.059674349386977e-13,  5.808582757672354e-17,  1.078470857179122e-18, -1.009508441280672e-21, -1.202191999029598e-23,  1.644209464664384e-26,  1.409452788293547e-28,
  1.115445778324893e+00, -2.653991315531496e-03, -7.248518658240947e-07,  1.260944349590587e-08,  6.538645481765452e-12, -1.085854260127945e-13, -6.977578295331695e-17,
  1.141201278683041e-18,  8.182472323498413e-22, -1.331338261657177e-23, -1.019969398526693e-26,  1.656826647054758e-28,  1.182604881567416e+00, -2.625763596068270e-03,
 -1.448156749119354e-06,  1.208462723849174e-08,  1.590151634246666e-11, -9.924267807045069e-14, -1.996659849699865e-16,  9.770668570393060e-19,  2.682293721365849e-21,
 -1.045652587977607e-23, -3.745706585293636e-26,  1.163364975985453e-28,  1.249572035222780e+00, -2.572417317596368e-03, -2.151841884488296e-06,  1.095693967929153e-08,
  2.452412152843621e-11, -7.785714161933635e-14, -3.088227916712049e-16,  5.912600881105089e-19,  4.044540016169624e-21, -3.731509191449763e-24, -5.359888574090068e-26,
  2.323890679096361e-30,  1.316011513139511e+00, -2.493878666980071e-03, -2.810120371704810e-06,  9.254626240003282e-09,  3.153396270618055e-11, -4.613562507512132e-14,
 -3.750276035445224e-16,  4.698791616881925e-20,  4.425470022445513e-21,  4.996398649220309e-24, -4.950686802878891e-26, -1.284417846241398e-28,  1.381570240366186e+00,
 -2.390623006489795e-03, -3.396883415027706e-06,  7.051041065215143e-09,  3.613388147648809e-11, -7.608088549250881e-15, -3.816932832742825e-16, -5.403519885609868e-19,
  3.587909782366467e-21,  1.269818793988794e-23, -2.405083363833969e-26, -2.080336533501448e-28,  1.445879121792966e+00, -2.263731982870269e-03, -3.887044750643514e-06,
  4.464980666185480e-09,  3.771579710512307e-11,  3.268045891172210e-14, -3.227600475582523e-16, -1.027050405508909e-18,  1.674971257802042e-21,  1.627087096412956e-23,
  1.343247331217188e-26, -1.858166186821296e-28,  1.508554921697621e+00, -2.114939723778404e-03, -4.258078855865314e-06,  1.656455858855590e-09,  3.597043156848316e-11,
  6.884904357126658e-14, -2.059641973501252e-16, -1.280025210181820e-18, -7.716673874896826e-22,  1.394783933129184e-23,  4.604025415888053e-26, -6.461464189868968e-29,
  1.569202759729356e+00, -1.946663121221964e-03, -4.491678703269240e-06, -1.182766523149415e-09,  3.097327289302613e-11,  9.517666094006411e-14, -5.306565808429662e-17,
 -1.220848815959494e-18, -2.956653354932863e-21,  6.371425573343572e-24,  5.743161176602387e-26,  9.108907078207534e-29,  1.627419277276580e+00, -1.762010817851486e-03,
 -4.575423584637701e-06, -3.843976183337091e-09,  2.322535234374607e-11,  1.072607151892029e-13,  1.038445337063835e-16, -8.594404669922767e-19, -4.116718559606677e-21,
 -3.361997875299317e-24,  4.138164747982455e-26,  1.892137460819902e-28,  1.682796509477582e+00, -1.564765494847507e-03, -4.504313437898056e-06, -6.121039304546293e-09,
  1.363004783720437e-11,  1.030906665133029e-13,  2.297644957304801e-16, -3.014465680622375e-19, -3.845416441191245e-21, -1.097271132275904e-23,  6.703390885729501e-27,
  1.708174143301676e-28,  1.734926471538784e+00, -1.359334553441435e-03, -4.281999062217915e-06, -7.833045289995195e-09,  3.395257406452878e-12,  8.373876709844424e-14,
  2.963415210239661e-16,  2.798486876357234e-19, -2.303573836088535e-21, -1.312919616384488e-23, -2.691968943790409e-26,  5.483308347823455e-29,  1.783406433320858e+00,
 -1.150665414355123e-03, -3.921524835535871e-06, -8.847537855267999e-09, -6.136044817975394e-12,  5.339696055067459e-14,  2.907347289999554e-16,  7.025177441317383e-19,
 -1.831638287314463e-22, -9.301632639841969e-24, -4.093829513417354e-26, -7.297040391086075e-29,  1.827844814029346e+00, -9.441235131696704e-04, -3.445409603919039e-06,
 -9.101001455226358e-09, -1.370638005476858e-11,  1.861583591487737e-14,  2.204646720531543e-16,  8.454390254226063e-19,  1.599426970581963e-21, -2.114400440273250e-24,
 -3.011688346213431e-26, -1.254040086711366e-28,  1.867867581158748e+00, -7.453336453974087e-04, -2.884928502927899e-06, -8.612908224454162e-09, -1.837745108148628e-11,
 -1.318196332609764e-14,  1.117416776389136e-16,  6.978684224118077e-19,  2.349861267596728e-21,  4.231173892715050e-24, -5.622579846380389e-27, -8.202116034074581e-29,
  1.903124987820948e+00, -5.599884970278877e-04, -2.278526356537780e-06, -7.489917473292321e-09, -1.972671019269683e-11, -3.558754055347946e-14,  9.217879697040011e-19,
  3.627366238797758e-19,  1.941018871758973e-21,  6.578313948563184e-24,  1.410119692732809e-26,  1.049957382745313e-30,  1.933298435074061e+00, -3.936317287785478e-04,
 -1.669389167814433e-06, -5.917899302394056e-09, -1.795521981768723e-11, -4.496202002825014e-14, -7.838508329000625e-17,  6.994704774278964e-21,  8.419888369994986e-22,
  4.700006374609621e-24,  1.769465548764739e-26,  4.934983319599924e-29,  1.958107208251409e+00, -2.514264633045101e-04, -1.102314240747308e-06, -4.141292864245333e-09,
 -1.386839072684664e-11, -4.148146214658498e-14, -1.076814007679644e-16, -2.198498658191838e-19, -2.046230245070814e-22,  1.053159701875667e-24,  8.363160265016013e-27,
  3.839943560025014e-29,  1.977314825866528e+00, -1.379228919369139e-04, -6.201346721759950e-07, -2.431648781115008e-09, -8.718475537280725e-12, -2.904652233533722e-14,
 -9.007691029028112e-17, -2.574017290170972e-19, -6.587244446396086e-22, -1.397554669718407e-24, -1.776149542263400e-27,  3.581801317303773e-30,  1.990734856706768e+00,
 -5.683986260406113e-05, -2.600462355979844e-07, -1.049560763631439e-09, -3.933392226170167e-12, -1.398449784588964e-14, -4.764209168538869e-17, -1.561925890686905e-19,
 -4.930813509290955e-22, -1.494962866497954e-24, -4.324709626132126e-27, -1.178370237712614e-29,  1.998237879660687e+00, -1.086457994050784e-05, -5.018725687629688e-08,
 -2.057852462700229e-10, -7.896773329599272e-13, -2.903002413872994e-15, -1.035010205329459e-17, -3.604599759314044e-20, -1.231761702717868e-22, -4.142017793043424e-25,
 -1.373220804479878e-27, -4.494108920513767e-30,  4.153401697027855e-04, -1.904949615041474e-06,  6.551547697458058e-09, -2.002432147657185e-11,  5.736016589949983e-14,
 -1.576842163772344e-16,  4.212546833449476e-19, -1.101918956669528e-21,  2.835773569848242e-24, -7.203636908082647e-27,  1.810351828958033e-29, -4.508919654838783e-32,
  3.737091697933011e-03, -1.711918902800933e-05,  5.872433845265214e-08, -1.786894356620682e-10,  5.083855755572328e-13, -1.384083906553616e-15,  3.649401666227626e-18,
 -9.383940565024957e-21,  2.362867101983107e-23, -5.841313056452500e-26,  1.419722925274799e-28, -3.395163561691216e-31,  1.037541300368058e-02, -4.741241230034325e-05,
  1.617949985888179e-07, -4.879115842128103e-10,  1.369018077034499e-12, -3.653356937335856e-15,  9.370612401484210e-18, -2.321996642741912e-20,  5.568286876912566e-23,
 -1.291364926618343e-25,  2.886325214926237e-28, -6.175617055765262e-31,  2.031989575552967e-02, -9.251403750483518e-05,  3.132276497966926e-07, -9.317098222649565e-10,
  2.558711591826035e-12, -6.615214086847327e-15,  1.621660983253781e-17, -3.769576193656184e-20,  8.253598792377880e-23, -1.674870616350658e-25,  3.034978726830264e-28,
 -4.433481584993822e-31,  3.355481511300223e-02, -1.520180314876664e-04,  5.092536678812613e-07, -1.486700182184664e-09,  3.962313434934689e-12, -9.785192068500680e-15,
  2.238016335768065e-17, -4.671842959873181e-20,  8.548345313272272e-23, -1.213434157417893e-25,  5.716598492053900e-29,  4.541777052646125e-31,  5.005899416921506e-02,
 -2.253827650316747e-04,  7.449147004644192e-07, -2.122798741391357e-09,  5.436693940359459e-12, -1.259119763525771e-14,  2.588303432843370e-17, -4.434433302595452e-20,
  4.939965856898611e-23,  3.874825139753421e-26, -4.733030524799443e-28,  1.922436899866757e-30,  6.980562198447428e-02, -3.119309002978449e-04,  1.014121319992355e-06,
 -2.804155238865544e-09,  6.819295998302160e-12, -1.443122090795512e-14,  2.489076338328526e-17, -2.622601220569630e-20, -3.156856046124331e-23,  3.005584875658597e-25,
 -1.153281133053536e-27,  3.297734902100502e-30,  9.276202420164348e-02, -4.108493824437315e-04,  1.309728393716102e-06, -3.490312585244742e-09,  7.938343482538698e-12,
 -1.473854793922147e-14,  1.804061551178295e-17,  9.059500218443093e-21, -1.498082571977122e-22,  6.017041426709633e-25, -1.696777740392113e-27,  3.578338355820070e-30,
  1.188893850345464e-01, -5.211896288464121e-04,  1.623628481306430e-06, -4.137584673483677e-09,  8.624367798321206e-12, -1.304997708194034e-14,  4.744147362360727e-18,
  5.904900503021389e-20, -2.827969952742130e-22,  8.365492285515763e-25, -1.741823008416513e-27,  1.849904086374660e-30,  1.481424192618343e-01, -6.418680332327207e-04,
  1.946864764374804e-06, -4.700640729293749e-09,  8.722624244147939e-12, -9.071816514456653e-15, -1.457638136838599e-17,  1.170257683335548e-19, -3.952880040201465e-22,
  8.799378370462998e-25, -9.846298748290358e-28, -2.162123833438838e-30,  1.804689927546611e-01, -7.716669286663235e-04,  2.269765155216579e-06, -5.134278762747052e-09,
  8.105875132637896e-12, -2.737867486740369e-15, -3.835747521071043e-17,  1.724194153218137e-19, -4.453927754078093e-22,  6.247709690481035e-25,  6.620550964216803e-28,
 -7.635863265375796e-30,  2.158096900346665e-01, -9.092361831330114e-04,  2.582099304575905e-06, -5.395363213806106e-09,  6.686916725195518e-12,  5.746745495812291e-15,
 -6.390442271818998e-17,  2.120560311600618e-19, -3.940355379687175e-22,  2.568944631351885e-26,  2.940230081819535e-27, -1.254878739893619e-29,  2.540973274209848e-01,
 -1.053095634688285e-03,  2.873260204303805e-06, -5.444892361855779e-09,  4.430126061110549e-12,  1.588205542408812e-14, -8.756687875413106e-17,  2.222188295924275e-19,
 -2.163708267199402e-22, -8.628534197619628e-25,  5.208099951691451e-27, -1.411899775223909e-29,  2.952564105083364e-01, -1.201638609932661e-03,  3.132471927687984e-06,
 -5.250149276059432e-09,  1.361208333770251e-12,  2.687578392202453e-14, -1.050903171198990e-16,  1.913323814981553e-19,  8.707370513328367e-23, -1.867811267486359e-24,
  6.540185699329326e-27, -9.813884358290695e-30,  3.392025350559805e-01, -1.353136809898838e-03,  3.349024727371726e-06, -4.786875894012095e-09, -2.425754586314329e-12,
  3.767667970864247e-14, -1.121338718175738e-16,  1.129254302470229e-19,  4.823579784460642e-22, -2.710492232210083e-24,  5.980798435745195e-27,  1.302191851485048e-30,
  3.858417308999360e-01, -1.505746890904786e-03,  3.512538169027209e-06, -4.041393259331942e-09, -6.764904922779575e-12,  4.704174551015980e-14, -1.049207608747961e-16,
 -1.161967145292921e-20,  9.001667238160808e-22, -3.058371501571318e-24,  2.913294542780398e-27,  1.736608289772714e-29,  4.350697492771594e-01, -1.657519113749982e-03,
  3.613252160543330e-06, -3.012572293325188e-09, -1.141981361582283e-11,  5.363795188455033e-14, -8.096005138797756e-17, -1.711298096492834e-19,  1.242393504687278e-21,
 -2.613461991932420e-24, -2.552459113013048e-27,  3.329756243152515e-29,  4.867712950281937e-01, -1.806408481415887e-03,  3.642344575858156e-06, -1.713539342767557e-09,
 -1.609017822327408e-11,  5.617567721469678e-14, -3.975055455618779e-17, -3.441468968746840e-19,  1.398449882989235e-21, -1.222418424229131e-24, -9.320807348859225e-27,
  4.173125738403347e-29,  5.408192065917593e-01, -1.950288830984599e-03,  3.592272598676195e-06, -1.729802474687092e-10, -2.042474291997048e-11,  5.356689124102025e-14,
  1.664690220438749e-17, -5.004264664667359e-19,  1.270381503803621e-21,  1.019500653193258e-24, -1.533904284007523e-26,  3.548909630700774e-29,  5.970735885982474e-01,
 -2.086970386573453e-03,  3.457132852282740e-06,  1.564112426868651e-09, -2.404088469802018e-11,  4.509616394501705e-14,  8.329825351951802e-17, -6.047531997442648e-19,
  8.031599497976095e-22,  3.708041015795302e-24, -1.802879676712611e-26,  1.112004583977211e-29,  6.553809042954550e-01, -2.214221312125759e-03,  3.233032772645513e-06,
  3.436419450922637e-09, -2.655087306139426e-11,  3.058727737554623e-14,  1.524755419449197e-16, -6.230102451643389e-19,  1.365109896035257e-23,  6.151594463234985e-24,
 -1.511905363657464e-26, -2.774393898453009e-29,  7.155730380924389e-01, -2.329793819674508e-03,  2.918462477413111e-06,  5.367180284661925e-09, -2.759419942300237e-11,
  1.054314878959033e-14,  2.142335254794368e-16, -5.299040480138741e-19, -9.905000574483475e-22,  7.501083738501298e-24, -5.705645300733838e-27, -6.901970470637748e-29,
  7.774663422820789e-01, -2.431455382008991e-03,  2.514652574946229e-06,  7.266157011024200e-09, -2.687457847437429e-11, -1.376714904680826e-14,  2.575379027431351e-16,
 -3.171232052521829e-19, -2.011474006792713e-21,  6.986276395253029e-24,  8.824145467888008e-27, -9.449065135985361e-29,  8.408606865918883e-01, -2.517025558071336e-03,
  2.025898998822686e-06,  9.032827453190551e-09, -2.419926283324356e-11, -4.030202951588125e-14,  2.719139446648034e-16, -1.176765396045824e-22, -2.788745622311683e-21,
  4.215318187105025e-24,  2.448007956012231e-26, -8.640049867444226e-29,  9.055385346933125e-01, -2.584418852018126e-03,  1.459831192327787e-06,  1.056091083504799e-08,
 -1.951723806843602e-11, -6.634713565335542e-14,  2.494676786330287e-16,  3.786952465554365e-19, -3.055328964740013e-21, -5.508688650800580e-25,  3.539697351956500e-26,
 -3.682446098431502e-29,  9.712640782200826e-01, -2.631693877469134e-03,  8.275950860292025e-07,  1.174425072596673e-08, -1.295178454884633e-11, -8.873888313805710e-14,
  1.869955509865357e-16,  7.524337028654346e-19, -2.615880604474571e-21, -6.269080183323367e-24,  3.573288738646353e-26,  4.410005363484717e-29,  1.037782466203263e+00,
 -2.657108869884803e-03,  1.439177693332764e-07,  1.248396403631768e-08, -4.821978856953719e-12, -1.042150543142615e-13,  8.776666325849289e-17,  1.039380791489192e-18,
 -1.429000444044744e-21, -1.124419046528168e-23,  2.233856452195879e-26,  1.264269522804191e-28,  1.104819176043176e+00, -2.659183264245568e-03, -5.729827652204066e-07,
  1.269660807960284e-08,  4.352792421131390e-12, -1.098740877087030e-13, -3.752810273987978e-17,  1.159652294886060e-18,  3.333926492927061e-22, -1.357410113217750e-23,
 -2.809687209834926e-27,  1.693252316931098e-28,  1.172079581012053e+00, -2.636764615234899e-03, -1.301680994419614e-06,  1.232292177865735e-08,  1.387100754617111e-11,
 -1.036970259798742e-13, -1.711650375695379e-16,  1.056598583329656e-18,  2.280190318079740e-21, -1.184512709824709e-23, -3.179885102017951e-26,  1.402302679592630e-28,
  1.239248778467635e+00, -2.589099569936806e-03, -2.018056966841507e-06,  1.133647166634996e-08,  2.289427720773779e-11, -8.505573907574260e-14, -2.904786961752723e-16,
  7.181230373260033e-19,  3.871730704428889e-21, -5.863348282732597e-24, -5.274221506379913e-26,  3.674480787877185e-29,  1.305991751909825e+00, -2.515906903956320e-03,
 -2.696069628114441e-06,  9.751299644515665e-09,  3.052143350625374e-11, -5.510434485059852e-14, -3.717050775702430e-16,  1.910880698621176e-19,  4.568400025935325e-21,
  2.910490195725651e-24, -5.459530562577941e-26, -1.019194605458203e-28,  1.371953947940768e+00, -2.417449810245697e-03, -3.308808716716325e-06,  7.627463241234551e-09,
  3.588895661688556e-11, -1.693689642352344e-14, -3.951484603029216e-16, -4.184283068508141e-19,  4.025520892082872e-21,  1.155306937439439e-23, -3.319249992502834e-26,
 -2.062944385033532e-28,  1.436762355028860e+00, -2.294603716214829e-03, -3.829824086800882e-06,  5.073231752602971e-09,  3.828964813241802e-11,  2.459573006684964e-14,
 -3.506783695381477e-16, -9.639920842082599e-19,  2.268349780566353e-21,  1.663659684745190e-23,  4.661322170518492e-27, -2.122217514587485e-28,  1.500027173379806e+00,
 -2.148914957941779e-03, -4.234703687156133e-06,  2.242717803633149e-09,  3.729506552906833e-11,  6.347350053311883e-14, -2.420726260192893e-16, -1.296335423546710e-18,
 -2.371853659677131e-22,  1.572112884806755e-23,  4.233603086141178e-26, -1.041629149127400e-28,  1.561344162578793e+00, -1.982644754750524e-03, -4.502835907115935e-06,
 -6.720469006861567e-10,  3.286124717253167e-11,  9.348241666201880e-14, -8.853631920931567e-17, -1.311341015250314e-18, -2.685033591280771e-21,  8.741255038305652e-24,
  6.085919035965313e-26,  6.353548843614663e-29,  1.620297744220173e+00, -1.798792236215205e-03, -4.619250457304780e-06, -3.455081869142287e-09,  2.539346275973790e-11,
  1.094492259397159e-13,  7.792008791180504e-17, -9.927761490293959e-19, -4.205938845714382e-21, -1.539164098732143e-24,  4.977524278609123e-26,  1.912797134763905e-28,
  1.676464918727164e+00, -1.601089946235200e-03, -4.576388423048721e-06, -5.886167544198466e-09,  1.574624756156047e-11,  1.084894605651790e-13,  2.195423174788097e-16,
 -4.307532301132626e-19, -4.233721084507286e-21, -1.054600661505605e-23,  1.483502520101667e-26,  1.986934752755458e-28,  1.729420027503350e+00, -1.393965478796953e-03,
 -4.375613134747654e-06, -7.764934030779570e-09,  5.141744481182995e-12,  9.093621900585410e-14,  3.030727762142329e-16,  1.983693279462937e-19, -2.794945989511625e-21,
 -1.414891822361979e-23, -2.383991814515662e-26,  8.592911272685381e-29,  1.778740352607102e+00, -1.182463880201028e-03, -4.028247861807822e-06, -8.936785268602504e-09,
 -4.996740739347934e-12,  6.060965682721009e-14,  3.102705392500207e-16,  6.909766149658342e-19, -5.482445316638425e-22, -1.100029522307335e-23, -4.390935569546448e-26,
 -6.121943777666186e-29,  1.824012496523352e+00, -9.721273360020232e-04, -3.555924193932626e-06, -9.317029364776563e-09, -1.327920479898344e-11,  2.419676016759315e-14,
  2.448403437387200e-16,  8.951592896035260e-19,  1.500262896700766e-21, -3.432898353167783e-24, -3.589162911351256e-26, -1.368714418016016e-28,  1.864839426057962e+00,
 -7.688315107385976e-04, -2.990055846499260e-06, -8.908904046376701e-09, -1.861264507456211e-11, -1.025704316131935e-14,  1.323572784924125e-16,  7.754503508013820e-19,
  2.497216182977384e-21,  3.928638891262623e-24, -9.643553747270784e-27, -1.011589321787584e-28,  1.900848000531060e+00, -5.785816436516655e-04, -2.370322604533243e-06,
 -7.811234058484359e-09, -2.043737987148766e-11, -3.543629669972134e-14,  1.198436766068724e-17,  4.287471406565258e-19,  2.187979510371790e-21,  7.140761004169518e-24,
  1.395401783966104e-26, -8.176236013261252e-30,  1.931696741186171e+00, -4.072758541131573e-04, -1.742157666259194e-06, -6.212478833413173e-09, -1.887324035760069e-11,
 -4.683770584343836e-14, -7.778558526633830e-17,  3.678647088791695e-20,  1.024463097942857e-21,  5.452377293654894e-24,  1.995192409320294e-26,  5.319476165889197e-29,
  1.957083545222329e+00, -2.604475954647927e-04, -1.153368958989037e-06, -4.369966672175640e-09, -1.472436579211692e-11, -4.414038781215268e-14, -1.139226883884206e-16,
 -2.257231942562889e-19, -1.602622775204216e-22,  1.423506048162733e-24,  1.020624644069886e-26,  4.555326934746658e-29,  1.976753023931638e+00, -1.430031048073490e-04,
 -6.501709891905686e-07, -2.575911787494716e-09, -9.321620738853092e-12, -3.129728408104846e-14, -9.758692661878185e-17, -2.792992705546814e-19, -7.102717676632902e-22,
 -1.464837588639816e-24, -1.571845360534718e-27,  5.801451739089641e-30,  1.990503255210999e+00, -5.897170295576017e-05, -2.730280055655636e-07, -1.114796203873186e-09,
 -4.224879960041183e-12, -1.518222268610853e-14, -5.224471939402892e-17, -1.728667172248663e-19, -5.501426376337820e-22, -1.678749138685588e-24, -4.875494604590230e-27,
 -1.327918675128065e-29,  1.998193602395970e+00, -1.127617498156032e-05, -5.273444951323714e-08, -2.188984118681735e-10, -8.503055198479461e-13, -3.163975890212113e-15,
 -1.141689245444960e-17, -4.023721596441022e-20, -1.391257437237949e-22, -4.732996680540976e-25, -1.587198697291910e-27, -5.253057170902353e-30,  4.078236958720843e-04,
 -1.853483035090042e-06,  6.316660095236910e-09, -1.913124928949796e-11,  5.430513553975719e-14, -1.479343293086063e-16,  3.916333674305043e-19, -1.015187526520214e-21,
  2.589013015069370e-24, -6.517649991206205e-27,  1.623239530914935e-29, -4.006707202401212e-32,  3.669541143323875e-03, -1.665783520575052e-05,  5.662797191920697e-08,
 -1.707720488808606e-10,  4.815589045165091e-13, -1.299567733899725e-15,  3.396928491335194e-18, -8.660401588034243e-21,  2.162451841459573e-23, -5.302206283393006e-26,
  1.278441908257352e-28, -3.033844825660225e-31,  1.018831551165653e-02, -4.614110516955563e-05,  1.560691130841518e-07, -4.665798302974766e-10,  1.298148245039291e-12,
 -3.436067016394581e-15,  8.744715963633535e-18, -2.151032111522357e-20,  5.123537927875292e-23, -1.181174330780483e-25,  2.627363503504926e-28, -5.604516789292520e-31,
  1.995478140741987e-02, -9.005225232787575e-05,  3.022884697322206e-07, -8.918080781551408e-10,  2.430215321553610e-12, -6.238388265206515e-15,  1.519721466573542e-17,
 -3.514877776085336e-20,  7.672031104866503e-23, -1.557328474850282e-25,  2.843274743938582e-28, -4.276227167138552e-31,  3.295477955867883e-02, -1.480143006901798e-04,
  4.917872828898791e-07, -1.424840053473419e-09,  3.771876455819083e-12, -9.263460451753384e-15,  2.110969056830659e-17, -4.405237449467206e-20,  8.116076345022039e-23,
 -1.186900177871634e-25,  7.472523632375549e-29,  3.472145154577901e-31,  4.916922247432284e-02, -2.195238819082164e-04,  7.199548361797803e-07, -2.037792897419533e-09,
  5.190982271133365e-12, -1.198472471581351e-14,  2.466370864005806e-17, -4.274471825801576e-20,  5.047346780097697e-23,  2.142764092445026e-26, -3.946492009875482e-28,
  1.658517563508663e-30,  6.857391379855823e-02, -3.039506960666888e-04,  9.811166893877286e-07, -2.697323292282923e-09,  6.536585334094763e-12, -1.384275899239750e-14,
  2.414385708546393e-17, -2.707171021256481e-20, -2.154479589049148e-23,  2.572255956261066e-25, -1.015873394637570e-27,  2.953104224453085e-30,  9.113932008139239e-02,
 -4.005369533180304e-04,  1.268597072642154e-06, -3.365633655479466e-09,  7.647920102059790e-12, -1.430305132720681e-14,  1.823033221555906e-17,  4.599422545852042e-21,
 -1.293312328717621e-22,  5.369171014753555e-25, -1.544194374870507e-27,  3.356009819186495e-30,  1.168302934040855e-01, -5.083968790253021e-04,  1.574796813080132e-06,
 -4.001676054574919e-09,  8.364635606628474e-12, -1.291727232326670e-14,  6.275258922646252e-18,  5.046806924283871e-20, -2.539152131654558e-22,  7.685587128211735e-25,
 -1.656491131388255e-27,  2.016509117798349e-30,  1.456057430475969e-01, -6.265163872261582e-04,  1.891288401564164e-06, -4.562548150889391e-09,  8.537947732835422e-12,
 -9.383729376422360e-15, -1.147204186030064e-17,  1.048756229138859e-19, -3.643399940657226e-22,  8.388795307499190e-25, -1.062858188147927e-27, -1.416672778610175e-30,
  1.774182541840632e-01, -7.537530524856573e-04,  2.208930009477638e-06, -5.005071224845217e-09,  8.042294801390782e-12, -3.602103559252973e-15, -3.372585353704222e-17,
  1.585311916867078e-19, -4.225017937849290e-22,  6.449178086898621e-25,  3.545220744548265e-28, -6.367754678380532e-30,  2.122136514220260e-01, -8.888365390857441e-04,
  2.518000418389928e-06, -5.287534405133128e-09,  6.786988159498847e-12,  4.282866984314317e-15, -5.814308703942071e-17,  1.994833342457021e-19, -3.911230818850307e-22,
  1.326653653560732e-25,  2.418592893487873e-27, -1.117237064387937e-29,  2.499305049657553e-01, -1.030369679483633e-03,  2.808356906083183e-06, -5.371581302126714e-09,
  4.727250950800802e-12,  1.385430616948472e-14, -8.144607574171288e-17,  2.148369634406969e-19, -2.438315256874366e-22, -6.667424207333742e-25,  4.602930839132955e-27,
 -1.336726590698606e-29,  2.904995771835563e-01, -1.176830431457811e-03,  3.069618111480075e-06, -5.224205028694303e-09,  1.873937648029882e-12,  2.441815850293970e-14,
 -9.970375500270832e-17,  1.930925123014990e-19,  2.443525609104374e-23, -1.615066547367359e-24,  6.092114025858611e-27, -1.049267197136238e-29,  3.338432075522794e-01,
 -1.326574985604009e-03,  3.291373740168899e-06, -4.819804815916662e-09, -1.698868368780016e-12,  3.502506542684648e-14, -1.087702029860767e-16,  1.268458776262411e-19,
  3.890929464461775e-22, -2.470908145535356e-24,  5.979698430173641e-27, -1.267025275221047e-30,  3.798746342965616e-01, -1.477842341868907e-03,  3.463422623245277e-06,
 -4.142241928839684e-09, -5.849260954949332e-12,  4.452289714846659e-14, -1.048592202558591e-16,  1.544795174839021e-20,  7.923356668551560e-22, -2.927804066410471e-24,
  3.585004801652917e-27,  1.323754892898757e-29,  4.284972516226424e-01, -1.628760725288989e-03,  3.576040045729993e-06, -3.186814360234170e-09, -1.036685026627049e-11,
  5.164181596095699e-14, -8.520936208934190e-17, -1.328954873067870e-19,  1.146812562266055e-21, -2.687535329791491e-24, -1.182767456146700e-27,  2.896631557523876e-29,
  4.796038023202578e-01, -1.777356266191587e-03,  3.620274345942004e-06, -1.962049106554943e-09, -1.497695938464082e-11,  5.511104419586404e-14, -4.876727025122326e-17,
 -3.001690168795549e-19,  1.348168495178988e-21, -1.559180032559984e-24, -7.534559276781641e-27,  3.936079830574619e-29,  5.330755067472970e-01, -1.921564427237750e-03,
  3.588271472033711e-06, -4.911884050498751e-10, -1.935052093622183e-11,  5.380289705603276e-14,  3.208783215063095e-18, -4.593023506646123e-19,  1.296421476793305e-21,
  4.377813924122988e-25, -1.373400432551190e-26,  3.726495142130800e-29,  5.887811309096619e-01, -2.059244716255833e-03,  3.473624376192470e-06,  1.186776575385008e-09,
 -2.312032590370593e-11,  4.689514757505125e-14,  6.674406138271125e-17, -5.770543448099238e-19,  9.238062977402835e-22,  2.998817139910734e-24, -1.738191311461180e-26,
  1.805155573883353e-29,  6.465759986065456e-01, -2.188199275893422e-03,  3.271741737704479e-06,  3.016692346836829e-09, -2.590394526298403e-11,  3.403760870036200e-14,
  1.350698181776653e-16, -6.191490037606904e-19,  2.239581347474066e-22,  5.525651955618578e-24, -1.609947577996063e-26, -1.695642399990075e-29,  7.063009555462925e-01,
 -2.306195983008505e-03,  2.980227447153015e-06,  4.927634252271796e-09, -2.733313968131775e-11,  1.550337179032347e-14,  1.989927164378108e-16, -5.573292285880766e-19,
 -7.252728392572930e-22,  7.215221056759113e-24, -8.509732974670122e-27, -5.835061664591367e-29,  7.677812970784770e-01, -2.410996714517952e-03,  2.599258492509229e-06,
  6.834293694139010e-09, -2.708886819012783e-11, -7.699831640932186e-15,  2.477955613086427e-16, -3.774062139853642e-19, -1.754605187766394e-21,  7.257380872010216e-24,
  4.766966766282460e-27, -8.956969889583725e-29,  8.308256758680894e-01, -2.500391431518658e-03,  2.131944347818252e-06,  8.639545318235627e-09, -2.494009584078500e-11,
 -3.378607169868839e-14,  2.706854087192825e-16, -8.674807989831175e-20, -2.620302231377324e-21,  5.116608184413285e-24,  2.054352807599269e-26, -9.201648374632264e-29,
  8.952250115886448e-01, -2.572238686165241e-03,  1.584645741507549e-06,  1.023834819637327e-08, -2.078350679824686e-11, -6.024372647138567e-14,  2.587013052100919e-16,
  2.808772018923372e-19, -3.050112275739744e-21,  8.274373216824622e-25,  3.339494392919605e-26, -5.375937991408140e-29,  9.607514316453578e-01, -2.624513048895465e-03,
  9.672249647874564e-07,  1.152307478449861e-08, -1.468002649402785e-11, -8.400782980007298e-14,  2.068598386324261e-16,  6.653937832306464e-19, -2.815433551992400e-21,
 -4.807697834752231e-24,  3.716945942819809e-26,  2.121585034439940e-29,  1.027157280129809e+00, -2.655359766649234e-03,  2.931940433916118e-07,  1.239026221085771e-08,
 -6.882886897460348e-12, -1.017649573129369e-13,  1.161695707288613e-16,  9.873591579261755e-19, -1.816412848117702e-21, -1.024448534267263e-23,  2.751475104014646e-26,
  1.083240460675052e-28,  1.094174241655115e+00, -2.663156672491645e-03, -4.202782454048800e-07,  1.274863502345329e-08,  2.148938326418958e-12, -1.103843653990753e-13,
 -4.982011847028672e-18,  1.162495058411735e-18, -1.555030542747914e-22, -1.353762725252826e-23,  4.619957519967244e-27,  1.674841037490161e-28,  1.161512637314151e+00,
 -2.646582949049894e-03, -1.152543451559402e-06,  1.252805337805912e-08,  1.175842469234861e-11, -1.074421270766364e-13, -1.406245362697974e-16,  1.122508834479047e-18,
  1.832413864413636e-21, -1.298756088604269e-23, -2.517978673109373e-26,  1.598578983761623e-28,  1.228860961466159e+00, -2.604693779498856e-03, -1.879878800722745e-06,
  1.168879948497245e-08,  2.112514771671480e-11, -9.177214777128394e-14, -2.686713298271764e-16,  8.382377347716566e-19,  3.623158338279644e-21, -7.930501079716141e-24,
 -5.036383384217065e-26,  7.126588286888235e-29,  1.295885739884570e+00, -2.536999183665832e-03, -2.576161908025067e-06,  1.023034329946900e-08,  2.933065650790965e-11,
 -6.394446024794530e-14, -3.642952699553759e-16,  3.385235974613344e-19,  4.632869613124708e-21,  6.459895306397106e-25, -5.839818353895955e-26, -7.014413951892893e-29,
  1.362231801190702e+00, -2.443544429058125e-03, -3.213846675688201e-06,  8.198457653359719e-09,  3.545451088748661e-11, -2.654612039595080e-14, -4.050004235000434e-16,
 -2.832309517791066e-19,  4.415364016383520e-21,  1.004600101877963e-23, -4.209331632822111e-26, -1.970078025668351e-28,  1.427523063292943e+00, -2.324988344631195e-03,
 -3.765254772337158e-06,  5.689335132399786e-09,  3.869525833350116e-11,  1.586430443683622e-14, -3.765637411992690e-16, -8.818049036129631e-19,  2.868310635669914e-21,
  1.662951747796098e-23, -5.173380961972597e-27, -2.339030951396032e-28,  1.491363943181445e+00, -2.182674698359057e-03, -4.204169910968744e-06,  2.849266599745724e-09,
  3.850349584915935e-11,  5.722786554150424e-14, -2.783889194625586e-16, -1.294552836728589e-18,  3.580428513745322e-22,  1.731082770399325e-23,  3.684791236077253e-26,
 -1.454649214959993e-28,  1.553341499914749e+00, -2.018690620718935e-03, -4.507684500300660e-06, -1.314378653742915e-10,  3.470662378529359e-11,  9.090753303008945e-14,
 -1.264060764409141e-16, -1.391752396287774e-18, -2.325943378058142e-21,  1.122184431980661e-23,  6.291781822862850e-26,  2.887768530884490e-29,  1.613028414652973e+00,
 -1.835905009806565e-03, -4.658201128169911e-06, -3.031182706409562e-09,  2.759881771682298e-11,  1.109704895351870e-13,  4.823259996153858e-17, -1.127852066084293e-18,
 -4.223489344875533e-21,  6.192882045822327e-25,  5.811212576006074e-26,  1.864201382345400e-28,  1.669986895645010e+00, -1.637979139939926e-03, -4.645438275299976e-06,
 -5.616587366989773e-09,  1.796766938862343e-11,  1.135980876884053e-13,  2.055283629208716e-16, -5.721746993133670e-19, -4.600516504836823e-21, -9.769802113427506e-24,
  2.416851521694405e-26,  2.252106135333274e-28,  1.723773567802930e+00, -1.429341561354611e-03, -4.468237432853875e-06, -7.667719416582043e-09,  7.033601976730200e-12,
  9.826603416905667e-14,  3.072971412872277e-16,  1.006052335198195e-19, -3.320468501559811e-21, -1.501671957774829e-23, -1.929026296526489e-26,  1.216051870554676e-28,
  1.773945364130892e+00, -1.215120093114077e-03, -4.135927641308410e-06, -9.006624444931870e-09, -3.708527381316080e-12,  6.828595730095322e-14,  3.293102913600687e-16,
  6.667526429720345e-19, -9.764771800864784e-22, -1.280585765385158e-23, -4.624197250971048e-26, -4.379590819246066e-29,  1.820066379249950e+00, -1.001025520010636e-03,
 -3.668986322386880e-06, -9.525297270169716e-09, -1.273445017655456e-11,  3.037900249586776e-14,  2.705562981707341e-16,  9.409013060970236e-19,  1.349357425083650e-21,
 -4.992031536364891e-24, -4.213597935848609e-26, -1.465962826871065e-28,  1.861715574878403e+00, -7.931846619763362e-04, -3.098755698988585e-06, -9.208167354192401e-09,
 -1.878421425743552e-11, -6.810759427677985e-15,  1.552093199548453e-16,  8.575406436837976e-19,  2.630575160809369e-21,  3.447694670965655e-24, -1.456104793011623e-26,
 -1.227671308243400e-28,  1.898495147222178e+00, -5.979247764308501e-04, -2.466042727534630e-06, -8.143882089191097e-09, -2.114221524784611e-11, -3.499645974200248e-14,
  2.500891121514065e-17,  5.029823888751953e-19,  2.454977057860412e-21,  7.688383600841390e-24,  1.333875975360217e-26, -2.031612201473133e-29,  1.930039283756652e+00,
 -4.215165197989068e-04, -1.818550483664142e-06, -6.522045725240563e-09, -1.982855964799099e-11, -4.868830818776058e-14, -7.626597136888954e-17,  7.286852892360389e-20,
  1.235687613302008e-21,  6.298297252639590e-24,  2.236848671307607e-26,  5.654116632758898e-29,  1.956022963075816e+00, -2.698883786337162e-04, -1.207251717931809e-06,
 -4.612769700761090e-09, -1.563502971724329e-11, -4.695090456700000e-14, -1.203064461724783e-16, -2.299487957914260e-19, -1.011632510733910e-22,  1.874194733795911e-24,
  1.238850683437973e-26,  5.383704052789961e-29,  1.976170409364006e+00, -1.483307003795332e-04, -6.819978820238437e-07, -2.730195243886316e-09, -9.971634215475312e-12,
 -3.373583236450274e-14, -1.057335190422395e-16, -3.028833023700320e-19, -7.640689908989029e-22, -1.521811957532890e-24, -1.255931026318029e-27,  8.679398189948782e-30,
  1.990262913573229e+00, -6.121060991333374e-05, -2.868213940212270e-07, -1.184893248187526e-09, -4.541465731157243e-12, -1.649622570073672e-14, -5.734081187391048e-17,
 -1.914770511609226e-19, -6.142331025136387e-22, -1.885932332393778e-24, -5.495802702631442e-27, -1.494586141776751e-29,  1.998147636975590e+00, -1.170879389244380e-05,
 -5.544499730348944e-08, -2.330248162712127e-10, -9.164190182703648e-13, -3.452020285760681e-15, -1.260851438362533e-17, -4.497458060238951e-20, -1.573653057575863e-22,
 -5.416636132290721e-25, -1.837534032911099e-27, -6.150808643709055e-30,  4.005093968791354e-04, -1.803853504886746e-06,  6.092202388369182e-09, -1.828553542252771e-11,
  5.143818599597418e-14, -1.388670820348384e-16,  3.643335948555629e-19, -9.359713294879324e-22,  2.365652371503306e-24, -5.902270090104789e-27,  1.456882172521966e-29,
 -3.564180697917394e-32,  3.603803053725911e-03, -1.621287945168898e-05,  5.462409339945540e-08, -1.632706887137322e-10,  4.563635676467091e-13, -1.220874879858184e-15,
  3.163844963922065e-18, -7.997996273369348e-21,  1.980464384018152e-23, -4.816555855550528e-26,  1.152144847033291e-28, -2.713226053253624e-31,  1.000621322841569e-02,
 -4.491460015015398e-05,  1.505925459339442e-07, -4.463480274845581e-10,  1.231477792208471e-12, -3.233239891748455e-15,  8.164755357052217e-18, -1.993684358790424e-20,
  4.716652169466699e-23, -1.080855589132526e-25,  2.392346558926713e-28, -5.086412638605219e-31,  1.959934215707128e-02, -8.767609969444257e-05,  2.918160194195896e-07,
 -8.539032876556186e-10,  2.309016582390729e-12, -5.885192784638225e-15,  1.424659219932405e-17, -3.278127141864856e-20,  7.131415614952222e-23, -1.447309418632457e-25,
  2.658974995662742e-28, -4.098274884666512e-31,  3.237048409465964e-02, -1.441473827029109e-04,  4.750452765381016e-07, -1.365945070965057e-09,  3.591575161791001e-12,
 -8.771339925394550e-15,  1.991194603186307e-17, -4.152299041441906e-20,  7.694515553857544e-23, -1.154228170743013e-25,  8.798828604254871e-29,  2.584045610876074e-31,
  4.830249332138922e-02, -2.138606633405141e-04,  6.959918488660143e-07, -1.956622979197892e-09,  4.957111067756962e-12, -1.140697481442901e-14,  2.348956369310750e-17,
 -4.112013316763849e-20,  5.097765890689005e-23,  7.030947175523486e-27, -3.268666720746273e-28,  1.427631093895865e-30,  6.737360636731544e-02, -2.962294769561374e-04,
  9.493672871277943e-07, -2.594921543803976e-09,  6.265462913987163e-12, -1.327247214080943e-14,  2.337753476612484e-17, -2.762057583756884e-20, -1.298565520169583e-23,
  2.190946298065320e-25, -8.929670633096208e-28,  2.638367269236244e-30,  8.955721694145750e-02, -3.905476685040951e-04,  1.228934306197122e-06, -3.245531614108325e-09,
  7.366242444055315e-12, -1.386442816891746e-14,  1.830399811071767e-17,  7.584510095576353e-22, -1.110790566387578e-22,  4.780359575390318e-25, -1.401516436122812e-27,
  3.129049758077692e-30,  1.148216016958171e-01, -4.959883293691662e-04,  1.527571207824145e-06, -3.869900001242689e-09,  8.107906045553644e-12, -1.275060188279946e-14,
  7.578680128049720e-18,  4.277285977764352e-20, -2.274180758105682e-22,  7.041072256145304e-25, -1.565361613904712e-27,  2.115797052278026e-30,  1.431295946191082e-01,
 -6.116027743587022e-04,  1.837351227688291e-06, -4.427456368338950e-09,  8.347751021722858e-12, -9.625110016862093e-15, -8.694267868975236e-18,  9.369162206429418e-20,
 -3.349188660625468e-22,  7.953084406861135e-25, -1.111218327166291e-27, -8.015771687981575e-31,  1.744382075495307e-01, -7.363196740779835e-04,  2.149638699292222e-06,
 -4.877013341099199e-09,  7.962510269733835e-12, -4.359763793012777e-15, -2.947275423812703e-17,  1.453848163973402e-19, -3.990939020143176e-22,  6.538355216727835e-25,
  9.953120496312263e-29, -5.246193982732686e-30,  2.086981940339396e-01, -8.689444853025969e-04,  2.455204142615296e-06, -5.178331280749834e-09,  6.859136298271830e-12,
  2.953050051767651e-15, -5.273193117072440e-17,  1.870615443162691e-19, -3.847206537997341e-22,  2.199672841497969e-25,  1.956012718368207e-27, -9.866891255175292e-30,
  2.458535535603106e-01, -1.008159353946588e-03,  2.744360551912345e-06, -5.293832774496145e-09,  4.985272619943199e-12,  1.197088294031173e-14, -7.554323894512204e-17,
  2.066847097920208e-19, -2.646596569788874e-22, -4.941419443008555e-25,  4.033350291061367e-27, -1.250879289365445e-29,  2.858409730753997e-01, -1.152523702416267e-03,
  3.007123249010986e-06, -5.190443295503188e-09,  2.338810085426979e-12,  2.209018376028426e-14, -9.429462836316523e-17,  1.929902824105885e-19, -2.943324720140497e-23,
 -1.380739107081649e-24,  5.621755034055209e-27, -1.083728161497301e-29,  3.285892027012115e-01, -1.300475756083325e-03,  3.233395651470525e-06, -4.841523303844384e-09,
 -1.024177293923855e-12,  3.245852718488252e-14, -1.050572490303351e-16,  1.379196237672328e-19,  3.044262650559718e-22, -2.233480300165337e-24,  5.876583968891842e-27,
 -3.342368186930254e-30,  3.740183627226610e-01, -1.450335312707137e-03,  3.413183133757513e-06, -4.228842979624957e-09, -4.983919791304132e-12,  4.201423508585781e-14,
 -1.040873529191566e-16,  3.914502593934036e-20,  6.896460606502070e-22, -2.773872493242707e-24,  4.084721372901963e-27,  9.550825239539143e-30,  4.220391792860298e-01,
 -1.600308114028028e-03,  3.536836776176028e-06, -3.344533578654525e-09, -9.354744549640696e-12,  4.955619559700583e-14, -8.843125967921627e-17, -9.775221921202904e-20,
  1.049505374876006e-21, -2.710614937987413e-24, -2.143539046403358e-30,  2.472103636517846e-29,  4.725521468880473e-01, -1.748492240172320e-03,  3.595328128260287e-06,
 -2.192929052744825e-09, -1.388709846173499e-11,  5.384459403626848e-14, -5.657685683913420e-17, -2.579805403957240e-19,  1.287023109087603e-21, -1.826744618102587e-24,
 -5.864767069308152e-27,  3.646683254870319e-29,  5.254466167288089e-01, -1.892887014060394e-03,  3.580555072885183e-06, -7.921883803156195e-10, -1.827471030908944e-11,
  5.373028097484002e-14, -9.069253766048715e-18, -4.176675033969760e-19,  1.302690817283494e-21, -7.852251306893732e-26, -1.207661787726021e-26,  3.789550248471313e-29,
  5.805998114461295e-01, -2.031404972880266e-03,  3.485677361671681e-06,  8.244361865662567e-10, -2.216769546667660e-11,  4.830655026749016e-14,  5.101568736631625e-17,
 -5.458977539502857e-19,  1.019456080368043e-21,  2.321155286203256e-24, -1.646087274775655e-26,  2.358649039277205e-29,  6.378757687618958e-01, -2.161887533779969e-03,
  3.305478286412747e-06,  2.607845493645388e-09, -2.519217561353604e-11,  3.707223943287168e-14,  1.178629904616622e-16, -6.089251356992132e-19,  4.111374030980595e-22,
  4.869727377566255e-24, -1.662491472465480e-26, -7.095664627518814e-30,  6.971242192908506e-01, -2.282125046376697e-03,  3.036746134937314e-06,  4.493038693451455e-09,
 -2.697659056062795e-11,  2.008954931500996e-14,  1.831011280671212e-16, -5.764525162712211e-19, -4.722412809206584e-22,  6.826710171506894e-24, -1.083565865841064e-26,
 -4.735174521678856e-29,  7.581794073476724e-01, -2.389881978275418e-03,  2.678665440207107e-06,  6.399959251494673e-09, -2.718428160698191e-11, -1.885648773391525e-15,
  2.364816194056486e-16, -4.293441253964121e-19, -1.490840025446921e-21,  7.371134322206993e-24,  9.708241724374159e-28, -8.269538207752650e-29,  8.208588682152028e-01,
 -2.482928011333272e-03,  2.233203484342224e-06,  8.235449993009927e-09, -2.555109774726436e-11, -2.732806858537740e-14,  2.671113427029938e-16, -1.674999703498446e-19,
 -2.422297932950654e-21,  5.856407750201149e-24,  1.642791642421755e-26, -9.456441823054986e-29,  8.849621811914918e-01, -2.559075821999879e-03,  1.705472041935694e-06,
  9.896512913832790e-09, -2.192571283544568e-11, -5.395151299087247e-14,  2.652057045973506e-16,  1.840031282830585e-19, -2.996890604326331e-21,  2.111533573572427e-24,
  3.070628851637917e-26, -6.797643744599422e-29,  9.502697249996594e-01, -2.616226260463402e-03,  1.104038025129341e-06,  1.127502900249665e-08, -1.630908087162787e-11,
 -7.882995159581066e-14,  2.242055854909872e-16,  5.728190507089417e-19, -2.961584333830956e-21, -3.308898594423363e-24,  3.760747315378111e-26, -1.155822633284996e-30,
  1.016541470982165e+00, -2.652421507513591e-03,  4.411497839975395e-07,  1.226401438965133e-08, -8.888101378985277e-12, -9.865203604118023e-14,  1.429479977124114e-16,
  9.235545055918884e-19, -2.164309145219260e-21, -9.054548832193134e-24,  3.182970634467925e-26,  8.741790483470515e-29,  1.083515860013479e+00, -2.665906547234094e-03,
 -2.671611715673726e-07,  1.276536109275355e-08, -5.731293678288085e-14, -1.101143463281240e-13,  2.742525608482570e-17,  1.149771271006342e-18, -6.377704308706032e-22,
 -1.320718325074355e-23,  1.184973258184913e-26,  1.602802281858556e-28,  1.150908821253269e+00, -2.655198916258591e-03, -1.001149478580676e-06,  1.269882485830456e-08,
  9.578410498828324e-12, -1.104337655922217e-13, -1.084449609626560e-16,  1.173484900094047e-18,  1.348470571113479e-21, -1.384940721136180e-23, -1.780664091169328e-26,
  1.743866531471855e-28,  1.218413004561440e+00, -2.619166143218465e-03, -1.737646874843487e-06,  1.201177616960021e-08,  1.922719130535396e-11, -9.792578800581452e-14,
 -2.436231517573993e-16,  9.492287538740261e-19,  3.302244607958503e-21, -9.872419067151432e-24, -4.648990093749690e-26,  1.044928438515462e-28,  1.285697313196430e+00,
 -2.557109544777753e-03, -2.450625778002164e-06,  1.068893117318031e-08,  2.796519082078250e-11, -7.255704510997645e-14, -3.527408337382826e-16,  4.866912575945666e-19,
  4.613428379398466e-21, -1.741325114095563e-24, -6.070484485959868e-26, -3.409498625066521e-29,  1.352406838567437e+00, -2.468852076662780e-03, -3.112080788630755e-06,
  8.760951922793405e-09,  3.482582989885371e-11, -3.634500806656073e-14, -4.109008518860043e-16, -1.364944656990649e-19,  4.744663496142003e-21,  8.193373438073888e-24,
 -5.041321740312720e-26, -1.798674424511397e-28,  1.418163313114233e+00, -2.354826748730671e-03, -3.693259148585543e-06,  6.310498314211475e-09,  3.892022513435082e-11,
  6.541411243796896e-15, -3.998796792675854e-16, -7.805007417163539e-19,  3.460721311413507e-21,  1.621170193284011e-23, -1.582996005942582e-26, -2.493356524292859e-28,
  1.482566209110677e+00, -2.216160735332369e-03, -4.166245815295359e-06,  3.474103679289482e-09,  3.957831294411808e-11,  5.011344207836222e-14, -3.143803575037131e-16,
 -1.272853216168131e-18,  1.006108997642269e-21,  1.864448007666066e-23,  2.953239376338336e-26, -1.869429550003847e-28,  1.545194617998683e+00, -2.054748828495048e-03,
 -4.505870490324978e-06,  4.382350911035600e-10,  3.649123867332186e-11,  8.739813847717484e-14, -1.663529595506210e-16, -1.459231284129432e-18, -1.876455909367719e-21,
  1.375223634356064e-23,  6.329954264479474e-26, -1.260883383333218e-29,  1.605610043846589e+00, -1.873308439694064e-03, -4.691852419886636e-06, -2.571794460794991e-09,
  2.982716658156385e-11,  1.117338785360445e-13,  1.476726102125325e-17, -1.262182525357687e-18, -4.157405521890092e-21,  3.104617320322568e-24,  6.605943945399296e-26,
  1.733739522956395e-28,  1.663360232341600e+00, -1.675407180747811e-03, -4.711036600165695e-06, -5.310666704243330e-09,  2.028757292961987e-11,  1.183215644078879e-13,
  1.873950104261709e-16, -7.248122333904552e-19, -4.932373779215687e-21, -8.597662115992722e-24,  3.461049456733291e-26,  2.487984417298163e-28,  1.717984129913023e+00,
 -1.465453446238052e-03, -4.559508684374548e-06, -7.539057768716907e-09,  9.072837955555134e-12,  1.056624575355251e-13,  3.085442496645243e-16, -1.443716440228188e-20,
 -3.873566173874613e-21, -1.566986998966626e-23, -1.307690833179219e-26,  1.614581429598624e-28,  1.769018023129040e+00, -1.248640734321541e-03, -4.244316676359223e-06,
 -9.054599430866675e-09, -2.262281673168334e-12,  7.640946341660969e-14,  3.474700331658115e-16,  6.277688250209252e-19, -1.471187836053820e-21, -1.468751589054035e-23,
 -4.766607840970769e-26, -1.977364190537832e-29,  1.816002844639949e+00, -1.030838040116091e-03, -3.784491179193247e-06, -9.723825984261483e-09, -1.205977818214691e-11,
  3.719319776741810e-14,  2.974766370546490e-16,  9.808672859296919e-19,  1.137730659690103e-21, -6.808760940459561e-24, -4.875121361237215e-26, -1.535404323915357e-28,
  1.858492549093514e+00, -8.184218179037143e-04, -3.211060808583225e-06, -9.509593774517815e-09, -1.888118467567017e-11, -2.787979536699508e-15,  1.804167499297364e-16,
  9.435815345342989e-19,  2.742843932246851e-21,  2.750325309608711e-24, -2.048209849768871e-26, -1.467462358329951e-28,  1.896063364309328e+00, -6.180498282322658e-04,
 -2.565821943819238e-06, -8.487719403680780e-09, -2.183495456280867e-11, -3.421810721307581e-14,  4.023458015524181e-17,  5.860711366231955e-19,  2.741108428094141e-21,
  8.199729832139272e-24,  1.211480346847946e-26, -3.594374883829026e-29,  1.928323617481695e+00, -4.363834498798293e-04, -1.898751028429148e-06, -6.847191482903187e-09,
 -2.082044037460286e-11, -5.048952362662238e-14, -7.363671853052873e-17,  1.162159525637318e-19,  1.479138701649443e-21,  7.243604381236367e-24,  2.491514069108190e-26,
  5.904256404176495e-29,  1.954923736864059e+00, -2.797721304463936e-04, -1.264137418960699e-06, -4.870601395434417e-09, -1.660344449268743e-11, -4.991582199662492e-14,
 -1.267794809627420e-16, -2.320060504240359e-19, -2.417709928619620e-23,  2.419823778389375e-24,  1.496239943327303e-26,  6.337495814326573e-29,  1.975565963203677e+00,
 -1.539204972806963e-04, -7.157402221025913e-07, -2.895279934828925e-09, -1.067242834159916e-11, -3.637801943319019e-14, -1.145648549694433e-16, -3.282189625523878e-19,
 -8.196572521709891e-22, -1.563388081352842e-24, -7.959441111733037e-28,  1.238022699033475e-29,  1.990013390161780e+00, -6.356331678936495e-05, -3.014872285048990e-07,
 -1.260272732056475e-09, -4.885598060601310e-12, -1.793902682476716e-14, -6.298786249575513e-17, -2.122625528673316e-19, -6.862469385307646e-22, -2.119447490856085e-24,
 -6.193422311304132e-27, -1.679502876264135e-29,  1.998099896611217e+00, -1.216379368408395e-05, -5.833160411128860e-08, -2.482567239434152e-10, -9.885904889786199e-13,
 -3.770323661500644e-15, -1.394133807158714e-17, -5.033700146750306e-20, -1.782561527912830e-22, -6.208777257837116e-25, -2.130916318411941e-27, -7.214681213588313e-30,
  3.933900878749189e-04, -1.755979808328435e-06,  5.877623891844010e-09, -1.748427684773266e-11,  4.874620502564190e-14, -1.304292003126637e-16,  3.391550512607465e-19,
 -8.635606857527239e-22,  2.163293103424302e-24, -5.349697517297795e-27,  1.308823126242931e-29, -3.173811518908957e-32,  3.539813285671491e-03, -1.578360139595977e-05,
  5.270786341905864e-08, -1.561601608310537e-10,  4.326876168096442e-13, -1.147559884827329e-15,  2.948519085430091e-18, -7.391124406396869e-21,  1.815084004153063e-23,
 -4.378711696875225e-26,  1.039149307874691e-28, -2.428486945071436e-31,  9.828930852593993e-03, -4.373095437232502e-05,  1.453524915104699e-07, -4.271512411266070e-10,
  1.168728185326003e-12, -3.043817518877734e-15,  7.627082297402356e-18, -1.848796820550876e-20,  4.344242645772237e-23, -9.894961361307061e-26,  2.179047405237961e-28,
 -4.616597807659006e-31,  1.925324279297297e-02, -8.538193967070956e-05,  2.817870206683280e-07, -8.178823831259130e-10,  2.194658873456018e-12, -5.554035948869939e-15,
  1.335989649003324e-17, -3.058056565609321e-20,  6.629099307729312e-23, -1.344501340268901e-25,  2.482823163595064e-28, -3.906937301171125e-31,  3.180139283824444e-02,
 -1.404116221112535e-04,  4.589930208576095e-07, -1.309857707928891e-09,  3.420834477937086e-12, -8.307130526340675e-15,  1.878315402655132e-17, -3.912652884637655e-20,
  7.285581778811380e-23, -1.116985308035685e-25,  9.769156671409742e-29,  1.849856707033168e-31,  4.745803971518200e-02, -2.083853152599053e-04,  6.729808253330551e-07,
 -1.879104075838165e-09,  4.734516759636687e-12, -1.085685716869110e-14,  2.236105870969699e-17, -3.948720251125426e-20,  5.101000538885224e-23, -4.848753692642161e-27,
 -2.685865319248829e-28,  1.225998807160280e-30,  6.620368350163522e-02, -2.887574106647168e-04,  9.188210512366821e-07, -2.496767512119094e-09,  6.005561223419665e-12,
 -1.272073172900936e-14,  2.259947894991349e-17, -2.791659013721033e-20, -5.713996694251832e-24,  1.856114387495582e-25, -7.832773261748274e-28,  2.352093393194796e-30,
  8.801444535698574e-02, -3.808699968729027e-04,  1.190686012898718e-06, -3.129866174902938e-09,  7.093346550635123e-12, -1.342526351543739e-14,  1.827798285282595e-17,
 -2.531284503161987e-21, -9.484628243768199e-23,  4.246620212997151e-25, -1.268830378471032e-27,  2.902565866743791e-30,  1.128617984932325e-01, -4.839513288709341e-04,
  1.481902384482346e-06, -3.742203325517733e-09,  7.854805747815406e-12, -1.255514122870342e-14,  8.678162434722918e-18,  3.588914569291362e-20, -2.031746805052669e-22,
  6.433714891005081e-25, -1.471097141008049e-27,  2.161019503663646e-30,  1.407122478407926e-01, -5.971142265540824e-04,  1.785016748454499e-06, -4.295442836427845e-09,
  8.153368541872705e-12, -9.803476980421195e-15, -6.216703408277034e-18,  8.342367786803893e-20, -3.070949110332257e-22,  7.503096567588183e-25, -1.135069076574020e-27,
 -2.999411997668374e-31,  1.715269554679543e-01, -7.193545021909922e-04,  2.091875941967765e-06, -4.750347813083149e-09,  7.868563899710995e-12, -5.019681954155690e-15,
 -2.557723193695176e-17,  1.329907557676359e-19, -3.755370488617570e-22,  6.534994271881098e-25, -1.091690310038587e-28, -4.262016745255185e-30,  2.052613084451079e-01,
 -8.495495423274463e-04,  2.393724375410099e-06, -5.068179618511091e-09,  6.905958734698474e-12,  1.748953068924628e-15, -4.766526947086257e-17,  1.748914578156083e-19,
 -3.754947866146820e-22,  2.898909942450703e-25,  1.549074428454009e-27, -8.644816969058919e-30,  2.418644255196039e-01, -9.864571999448747e-04,  2.681320731812402e-06,
 -5.212249629469235e-09,  5.207023650582946e-12,  1.022631890853687e-14, -6.987709305470720e-17,  1.979610519096752e-19, -2.796749604694585e-22, -3.435472198071498e-25,
  3.503119715583475e-27, -1.158478028142395e-29,  2.812785987054050e-01, -1.128715188758693e-03,  2.945076641468121e-06, -5.149609030150562e-09,  2.758420012414308e-12,
  1.989180658343334e-14, -8.891125510480136e-17,  1.912955773511285e-19, -7.520749507985567e-23, -1.165444408762878e-24,  5.142473558600647e-27, -1.090766149550483e-29,
  3.234386657221803e-01, -1.274841214112857e-03,  3.175220033303495e-06, -4.852852438986346e-09, -3.999023085553836e-13,  2.998452232690760e-14, -1.010708825662275e-16,
  1.464198280298786e-19,  2.282119714820117e-22, -2.001868418666307e-24,  5.692150947297517e-27, -4.971423556513483e-30,  3.682713091791691e-01, -1.423234124744445e-03,
  3.361985852555915e-06, -4.301998732224479e-09, -4.168514772643600e-12,  3.953169398123725e-14, -1.026971136654676e-16,  5.964824574968120e-20,  5.928198971619624e-22,
 -2.603064294199061e-24,  4.432111650258563e-27,  6.313606697975431e-30,  4.156942785399242e-01, -1.572176427349032e-03,  3.495836648929972e-06, -3.486396677994701e-09,
 -8.385046611356241e-12,  4.740470551533131e-14, -9.071280141081907e-17, -6.572732323168332e-20,  9.521727695750267e-22, -2.690158577523173e-24,  9.953405714604797e-28,
  2.065519068363212e-29,  4.656155312894427e-01, -1.719838571678943e-03,  3.567715110115682e-06, -2.406583642347746e-09, -1.282434633813261e-11,  5.240465957925135e-14,
 -6.323391685086869e-17, -2.178901989327056e-19,  1.217415879708012e-21, -2.030180658470349e-24, -4.330727915025070e-27,  3.321613376199592e-29,  5.179322904374828e-01,
 -1.864285487666976e-03,  3.569329853148145e-06, -1.076002618124301e-09, -1.720320425867138e-11,  5.337698726884213e-14, -2.018140914878904e-17, -3.761165971985501e-19,
  1.291570466182918e-21, -5.282763227820846e-25, -1.041362537115203e-26,  3.754771072001134e-29,  5.725300166344699e-01, -2.003485936830471e-03,  3.493474580920946e-06,
  4.775435019182873e-10, -2.119053942960471e-11,  4.935126419149823e-14,  3.619893482516012e-17, -5.120631405906471e-19,  1.091428215769815e-21,  1.684804517812519e-24,
 -1.532616841869219e-26,  2.777515256185857e-29,  6.292812948773362e-01, -2.135325325857064e-03,  3.334378933238352e-06,  2.210850167286650e-09, -2.442381639539991e-11,
  3.969799641707408e-14,  1.010227134045241e-16, -5.930925698003022e-19,  5.744268135236699e-22,  4.201150902121965e-24, -1.674003796182097e-26,  1.672179978449659e-30,
  6.880446381976129e-01, -2.257622717012558e-03,  3.088086864024271e-06,  4.064860820570766e-09, -2.653217057071915e-11,  2.428880471431771e-14,  1.667852206286643e-16,
 -5.877195847299014e-19, -2.347540018777669e-22,  6.354852273846622e-24, -1.267745822780212e-26, -3.640345869209397e-29,  7.486632140384727e-01, -2.368152851717676e-03,
  2.752855003166222e-06,  5.965013232808116e-09, -2.716623956619173e-11,  3.640504876394416e-15,  2.238319930413170e-16, -4.728047149198587e-19, -1.225635646230097e-21,
  7.339570708959578e-24, -2.487815889125911e-27, -7.430115192330927e-29,  8.109635034562720e-01, -2.464674071041702e-03,  2.329559065896822e-06,  7.822606501623936e-09,
 -2.603397671202917e-11, -2.098223623982381e-14,  2.613687059371255e-16, -2.415215386147524e-19, -2.200643233707091e-21,  6.430202221211685e-24,  1.226415786352511e-26,
 -9.424633654133873e-29,  8.747539090663922e-01, -2.544963056589990e-03,  1.822090845018888e-06,  9.537416652351528e-09, -2.294073208451325e-11, -4.753550922149389e-14,
  2.690282679438552e-16,  8.954985918376095e-20, -2.899520190867797e-21,  3.276439827954934e-24,  2.745730388405790e-26, -7.919443739907978e-29,  9.398233350501746e-01,
 -2.606857308836015e-03,  1.237721635105455e-06,  1.100176853963954e-08, -1.783062718480360e-11, -7.326735912868831e-14,  2.389018888355051e-16,  4.764322759494445e-19,
 -3.053697349426166e-21, -1.811942152053271e-24,  3.708663994785340e-26, -2.224944779119023e-29,  1.005939771804597e+00, -2.648306202811456e-03,  5.874002160858386e-07,
  1.210621549367804e-08, -1.082478165087812e-11, -9.491908815028768e-14,  1.677907037056603e-16,  8.493340481969838e-19, -2.466488533412741e-21, -7.711045116664911e-24,
  3.517904857910040e-26,  6.458166524930736e-29,  1.072848929170922e+00, -2.667431281950604e-03, -1.140548703247945e-07,  1.274687245162670e-08, -2.250423890567453e-12,
 -1.090725589278776e-13,  5.926238443646316e-17,  1.121860366379706e-18, -1.103026550383909e-21, -1.259539436272331e-23,  1.865072567208357e-26,  1.480716141907129e-28,
  1.140272975762978e+00, -2.662596131888652e-03, -8.479173665070363e-07,  1.283427986491918e-08,  7.346393088705821e-12, -1.126377428855823e-13, -7.505911414480694e-17,
  1.208536430264854e-18,  8.389486361537291e-22, -1.440518642862953e-23, -9.918026280095424e-27,  1.832085756617313e-28,  1.207909457718011e+00, -2.632485674030488e-03,
 -1.591725385328181e-06,  1.230343466697382e-08,  1.721241911244155e-11, -1.034422028649285e-13, -2.156212745710677e-16,  1.048864715854819e-18,  2.914557292533024e-21,
 -1.163083020317642e-23, -4.120802350684223e-26,  1.350393784183932e-28,  1.275430487953134e+00, -2.576193989024464e-03, -2.319723309851898e-06,  1.112431005757322e-08,
  2.643058184299064e-11, -8.084268943882194e-14, -3.370594415437082e-16,  6.328470611398278e-19,  4.506774459161706e-21, -4.188194602478977e-24, -6.135389970483555e-26,
  4.974778196839054e-30,  1.342482316096406e+00, -2.493318783384550e-03, -3.003631812037572e-06,  9.311813197765847e-09,  3.400009373654756e-11, -4.623507569526764e-14,
 -4.125556076169490e-16,  1.964987440660652e-20,  5.001480885222280e-21,  6.025345196292453e-24, -5.780652718846314e-26, -1.549317741931430e-28,  1.408685408524969e+00,
 -2.384059325179823e-03, -3.613794218707883e-06,  6.933739900691010e-09,  3.895337900522486e-11, -3.304900977553932e-15, -4.200965556462159e-16, -6.605635697684908e-19,
  4.030273700428551e-21,  1.535619835485844e-23, -2.700205685681926e-26, -2.571206914685269e-28,  1.473635185563254e+00, -2.249313106127870e-03, -4.120725339106513e-06,
  4.114952841051864e-09,  4.050226513109927e-11,  4.214490083732018e-14, -3.494670780449912e-16, -1.229707322523824e-18,  1.696482551773589e-21,  1.964935986535237e-23,
  2.042138916197776e-26, -2.267556896388801e-28,  1.536903576248646e+00, -2.090764700149971e-03, -4.497051568460863e-06,  1.035847679846934e-09,  3.819593413352249e-11,
  8.290905535581201e-14, -2.079741868797651e-16, -1.510869803892278e-18, -1.336056552079374e-21,  1.625951847512975e-23,  6.171760858727931e-26, -6.022728547927779e-29,
  1.598041556670346e+00, -1.910958422298110e-03, -4.719776772167323e-06, -2.076675403353183e-09,  3.206244847717880e-11,  1.116492881619293e-13, -2.241584448183066e-17,
 -1.392906680141579e-18, -3.996290229908611e-21,  5.893696585592274e-24,  7.323194328391312e-26,  1.510381929413494e-28,  1.656582831451838e+00, -1.713344685930288e-03,
 -4.772738129460399e-06, -4.966896948628095e-09,  2.269724179284019e-11,  1.225573963812242e-13,  1.648460646707435e-16, -8.873114781666727e-19, -5.214276880820007e-21,
 -6.988344558329966e-24,  4.599279648062390e-26,  2.676328014557559e-28,  1.712048794719739e+00, -1.502288759454830e-03, -4.649035345639338e-06, -7.376584422669287e-09,
  1.126003036959894e-11,  1.130481373308514e-13,  3.063192104653456e-16, -1.475034399127689e-19, -4.445271144033002e-21, -1.603834079839926e-23, -5.031329533510816e-27,
  2.047305009137205e-28,  1.763954862263528e+00, -1.283030384730301e-03, -4.353137134525766e-06, -9.078111448304164e-09, -6.493054319930896e-13,  8.495385296801867e-14,
  3.643063483739762e-16,  5.718616310772822e-19, -2.034389455030199e-21, -1.660286101622517e-23, -4.787193591688291e-26,  1.171294121456659e-29,  1.811818197056655e+00,
 -1.061583934356015e-03, -3.902308999972133e-06, -9.910434205160802e-09, -1.124227497615106e-11,  4.466608222783524e-14,  3.254110151887006e-16,  1.012963169300810e-18,
  8.558747896335824e-22, -8.895119900638047e-24, -5.558803401942519e-26, -1.564411006750958e-28,  1.855166754865854e+00, -8.445719032197009e-04, -3.326989580616011e-06,
 -9.811894380164234e-09, -1.889145257862849e-11,  1.869069493503283e-15,  2.080795090548608e-16,  1.032765528007861e-18,  2.825484060559246e-21,  1.794367407105516e-24,
 -2.750580522065784e-26, -1.728266043008519e-28,  1.893549458325892e+00, -6.389898050640566e-04, -2.669793130619481e-06, -8.842495346699249e-09, -2.250827880330582e-11,
 -3.304536952227423e-14,  5.791761279853868e-17,  6.785997609463930e-19,  3.044590781646223e-21,  8.647201351558343e-24,  1.011505676208507e-26, -5.568650782569278e-29,
  1.926547175182159e+00, -4.519078638202554e-04, -1.982949719365514e-06, -7.188491669201049e-09, -2.184761139172822e-11, -5.221215979132466e-14, -6.967941442312885e-17,
  1.679181633924905e-19,  1.758477879916354e-21,  8.292633360268460e-24,  2.754512288194073e-26,  6.024349239433368e-29,  1.953784045500743e+00, -2.901236117590554e-04,
 -1.324212052372650e-06, -5.144410568478034e-09, -1.763271429253719e-11, -5.303648623587004e-14, -1.332725296054550e-16, -2.312647510231411e-19,  7.440962912343269e-23,
  3.077197597717196e-24,  1.798574126005214e-26,  7.428502851177117e-29,  1.974938605157369e+00, -1.597883516758125e-04, -7.515326365235593e-07, -3.072011842610790e-09,
 -1.142824423521004e-11, -3.924087360093863e-14, -1.241306906881853e-16, -3.553535085415972e-19, -8.763692470912258e-22, -1.583022404199562e-24, -1.513809498059793e-28,
  1.710603274701994e-29,  1.989754215405534e+00, -6.603706440238618e-05, -3.170916301526800e-07, -1.341396747794693e-09, -5.259990225663853e-12, -1.952460945852499e-14,
 -6.925047248303137e-17, -2.354925501532663e-19, -7.671897214760931e-22, -2.382550435296312e-24, -6.976583836791665e-27, -1.883522249514287e-29,  1.998050288875978e+00,
 -1.264263758776669e-05, -6.140813812525168e-08, -2.646960941330375e-10, -1.067460468749392e-12, -4.122494838747040e-15, -1.543411404426767e-17, -5.641591654232323e-20,
 -2.022217298714976e-22, -7.128193460695586e-25, -2.475359373311423e-27, -8.477743540120451e-30,  3.864589002795672e-04, -1.709784998933921e-06,  5.672407532543355e-09,
 -1.672477206379214e-11,  4.621709936147734e-14, -1.225719874113006e-16,  3.159162596740252e-19, -7.973183593757608e-22,  1.979800546356661e-24, -4.853052050228399e-27,
  1.176914386485946e-29, -2.829074888901731e-32,  3.477510501613514e-03, -1.536931820495120e-05,  5.087473437586485e-08, -1.494169928758434e-10,  4.104276337483446e-13,
 -1.079214639502201e-15,  2.749467803217459e-18, -6.834737118659963e-21,  1.664681760064814e-23, -3.983656103221694e-26,  9.379715185768028e-29, -2.175404150305758e-31,
  9.656300654246691e-03, -4.258832436859740e-05,  1.403368973457787e-07, -4.089288284699322e-10,  1.109641202088579e-12, -2.866825645529005e-15,  7.128357646556930e-18,
 -1.715316226954982e-20,  4.003235379764161e-23, -9.062684485138082e-26,  1.985438314638329e-28, -4.190720961789833e-31,  1.891616229931926e-02, -8.316631324291703e-05,
  2.721795093059417e-07, -7.836393524683806e-10,  2.086716393027864e-12, -5.243438199586139e-15,  1.253262484484917e-17, -2.853481369264189e-20,  6.162546149682347e-23,
 -1.248568345419209e-25,  2.315276093657935e-28, -3.707990781331786e-31,  3.124699198609851e-02, -1.368016331169329e-04,  4.435977240997872e-07, -1.256429371725424e-09,
  3.259112431271235e-12, -7.869221584961844e-15,  1.771965157633504e-17, -3.685871206472424e-20,  6.890679881768173e-23, -1.076467289095378e-25,  1.044588905275993e-28,
  1.245914274360481e-31,  4.663512513197161e-02, -2.030903941791553e-04,  6.508790179401444e-07, -1.805060118612846e-09,  4.522657665706706e-12, -1.033327524039108e-14,
  2.127822909251374e-17, -3.785964643175579e-20,  5.065457806284447e-23, -1.456684288813659e-26, -2.185978853626688e-28,  1.050212288450024e-30,  6.506316752234796e-02,
 -2.815250727281224e-04,  8.894280740190664e-07, -2.402684645961151e-09,  5.756507067606566e-12, -1.218773890739662e-14,  2.181621712228945e-17, -2.799837503346431e-20,
  4.282811272814932e-25,  1.562719346669270e-25, -6.855873592943978e-28,  2.092639864978605e-30,  8.650978117300695e-02, -3.714928332075401e-04,  1.153799796520713e-06,
 -3.018496867856238e-09,  6.829220541458353e-12, -1.298777162085731e-14,  1.816684561409489e-17, -5.331309727417079e-21, -8.044182864242821e-23,  3.763972561617765e-25,
 -1.146026143841725e-27,  2.680423399722315e-30,  1.109494221996273e-01, -4.722736180561865e-04,  1.437741757093591e-06, -3.618523611108402e-09,  7.605863371231524e-12,
 -1.233552025727685e-14,  9.595438293151669e-18,  2.974696727320649e-20, -1.810495447371248e-22,  5.864327704207859e-25, -1.375822414858802e-27,  2.163418426859264e-30,
  1.383520278600817e-01, -5.830380710564416e-04,  1.734247663365837e-06, -4.166564828124395e-09,  7.955990564126096e-12, -9.925733317139278e-15, -4.014420858262772e-18,
  7.402003816651643e-20, -2.809030397694742e-22,  7.047683626555738e-25, -1.139057550988639e-27,  1.036782104416218e-31,  1.686826494590317e-01, -7.028453789413168e-04,
  2.035623732717972e-06, -4.625286050591802e-09,  7.762326422067947e-12, -5.590186869589065e-15, -2.201820268973689e-17,  1.213487920843157e-19, -3.521324721546229e-22,
  6.456432086608023e-25, -2.774011001685575e-28, -3.404984911417320e-30,  2.019010273390480e-01, -8.306411392623224e-04,  2.333570149488173e-06, -4.957464961110240e-09,
  6.929887810402450e-12,  6.624023947492132e-16, -4.293488037381535e-17,  1.630538371646796e-19, -3.640319419514900e-22,  3.445862203919385e-25,  1.193925290957458e-27,
 -7.513742179272075e-30,  2.379611037398178e-01, -9.652553908008690e-04,  2.619280069844129e-06, -5.127390293506257e-09,  5.395223230469572e-12,  8.614761798764180e-15,
 -6.446115014192456e-17,  1.888396337582031e-19, -2.896407121608381e-22, -2.133370025342849e-25,  3.014356279350578e-27, -1.062889664799587e-29,  2.768104689045061e-01,
 -1.105400977078842e-03,  2.883558899421856e-06, -5.102405745416771e-09,  3.135349736334516e-12,  1.782190245340785e-14, -8.359470167037477e-17,  1.882564041684372e-19,
 -1.135763323614866e-22, -9.693144029791486e-25,  4.665122588454721e-27, -1.075796515960358e-29,  3.183897354749327e-01, -1.249672454809750e-03,  3.116966780117947e-06,
 -4.854583740855930e-09,  1.758671942727488e-13,  2.760877839191392e-14, -9.687941183018616e-17,  1.526130265888757e-19,  1.601867415823756e-22, -1.778947083836963e-24,
  5.444944400799379e-27, -6.203991238594418e-30,  3.626318359793481e-01, -1.396545808478066e-03,  3.309987349118482e-06, -4.362503209265002e-09, -3.402382202401409e-12,
  3.708906334804766e-14, -1.007752204189735e-16,  7.715382496654649e-20,  5.023598188119357e-22, -2.421077991647499e-24,  4.646853228190482e-27,  3.519235650460970e-30,
  4.094612381249330e-01, -1.544379290647040e-03,  3.453225826691036e-06, -3.613091525309523e-09, -7.458855227345996e-12,  4.520886778963055e-14, -9.214108745774958e-17,
 -3.679793305513865e-20,  8.562522886399853e-22, -2.633311706220695e-24,  1.819201369416709e-27,  1.683881018679527e-29,  4.587930727239148e-01, -1.691415775925670e-03,
  3.537639283655293e-06, -2.603472891243287e-09, -1.179190100119562e-11,  5.081816798624160e-14, -6.880064954544373e-17, -1.801329094417875e-19,  1.141554319832899e-21,
 -2.175187443178417e-24, -2.944829474976329e-27,  2.975569062391478e-29,  5.105321694889667e-01, -1.835787095294412e-03,  3.554801448105325e-06, -1.342743381715788e-09,
 -1.614133703184403e-11,  5.277090822431592e-14, -3.013746386026096e-17, -3.351678072809519e-19,  1.265450343118689e-21, -9.120668611480088e-25, -8.784347265791842e-27,
  3.639074562121921e-29,  5.645719967358388e-01, -1.975520906625049e-03,  3.497203522750014e-06,  1.464334735657915e-10, -2.019596714140078e-11,  5.005198388996920e-14,
  2.235841547439974e-17, -4.762828592934242e-19,  1.141349672367353e-21,  1.097149893889484e-24, -1.403524218247209e-26,  3.070428709040570e-29,  6.207935023633059e-01,
 -2.108550755692243e-03,  3.358591060935661e-06,  1.826546910878283e-09, -2.360694483869171e-11,  4.192547469555692e-14,  8.469528144546905e-17, -5.724199976074972e-19,
  7.136544101610771e-22,  3.535338490790241e-24, -1.649543422918310e-26,  9.243298068569201e-30,  6.790638555108766e-01, -2.232730087227214e-03,  3.134334825289526e-06,
  3.644444180430869e-09, -2.600770247454046e-11,  2.809353517311261e-14,  1.502575799406367e-16, -5.916721317680321e-19, -1.546438160961109e-23,  5.818867483887895e-24,
 -1.404476183273109e-26, -2.583298147289612e-29,  7.392350912304790e-01, -2.345851072867121e-03,  2.821830538677389e-06,  5.531223179731040e-09, -2.704080398308408e-11,
  8.849421728138717e-15,  2.100839248374623e-16, -5.078229016539556e-19, -9.639655226933320e-22,  7.177398398468279e-24, -5.551731820835692e-27, -6.482491553161447e-29,
  8.011426645989329e-01, -2.445669224334786e-03,  2.420918331276396e-06,  7.403044101546459e-09, -2.639148092452668e-11, -1.479827898117372e-14,  2.536556431587033e-16,
 -3.081517205107988e-19, -1.961319309837354e-21,  6.838507777711769e-24,  8.172230388584479e-27, -9.135361174902571e-29,  8.646039262355911e-01, -2.529934843680948e-03,
  1.934307299384788e-06,  9.163110735737559e-09, -2.382672608225255e-11, -4.105911030900032e-14,  2.702558820266858e-16, -1.142563488021809e-21, -2.762663029082309e-21,
  4.302432928481210e-24,  2.378349424972529e-26, -8.727547152597368e-29,  9.294165385041887e-01, -2.596432410116563e-03,  1.367983781949182e-06,  1.070507159158726e-08,
 -1.923761465180975e-11, -6.738472481166780e-14,  2.508661583523543e-16,  3.779543260532457e-19, -3.092513889298935e-21, -3.538541790600641e-25,  3.567820218705837e-26,
 -4.140196425808672e-29,  9.953568611240905e-01, -2.643028989895693e-03,  7.315737068208748e-07,  1.191805865424930e-08, -1.268101450178821e-11, -9.061590050425909e-14,
  1.904273044170897e-16,  7.662415769221700e-19, -2.718135860318446e-21, -6.254028702398239e-24,  3.749796798730947e-26,  4.073302396422298e-29,  1.062178346845454e+00,
 -2.667732648386328e-03,  3.861984983413673e-08,  1.269350194113803e-08, -4.415130089074976e-12, -1.072777186771359e-13,  9.011325155598229e-17,  1.079465027416535e-18,
 -1.541503414799106e-21, -1.172366209479776e-23,  2.481459807277110e-26,  1.314306094044129e-28,  1.129610002557386e+00, -2.668761598956222e-03, -6.932753807970982e-07,
  1.293371379207701e-08,  5.078378640409876e-12, -1.140305412657553e-13, -4.092266011660082e-17,  1.227024683681327e-18,  3.151759489680586e-22, -1.463942417074184e-23,
 -1.773706472187574e-27,  1.859746228979618e-28,  1.197354988876790e+00, -2.644624389479666e-03, -1.442500931999377e-06,  1.256201161990993e-08,  1.509425755943825e-11,
 -1.082545538356785e-13, -1.850124852537212e-16,  1.135125180970929e-18,  2.467684352731583e-21, -1.315216740224879e-23, -3.466522806886138e-26,  1.616034537927963e-28,
  1.265089451855418e+00, -2.594210745207615e-03, -2.183749016055017e-06,  1.153383132718557e-08,  2.473435265519005e-11, -8.870333915344960e-14, -3.173467263319642e-16,
  7.741789303584407e-19,  4.311985585189105e-21, -6.626076720366054e-24, -6.024420016858168e-26,  4.559032812012789e-29,  1.332461703510659e+00, -2.516891696592089e-03,
 -2.888658301150833e-06,  9.847879627777778e-09,  3.297651770177499e-11, -5.611153841386809e-14, -4.097353948470895e-16,  1.827087893318784e-19,  5.175210665587760e-21,
  3.585735087381151e-24, -6.393880951636000e-26, -1.226569234078757e-28,  1.399091892427937e+00, -2.412626272707805e-03, -3.526853787774871e-06,  7.555911354802161e-09,
  3.878503711060690e-11, -1.359409139568345e-14, -4.367052797862521e-16, -5.229802606768368e-19,  4.560924310140814e-21,  1.404948062840130e-23, -3.832639650204317e-26,
 -2.560865442174721e-28,  1.464572329903261e+00, -2.282070313446315e-03, -4.067431379778781e-06,  4.769264974188365e-09,  4.125853656933333e-11,  3.335130254205065e-14,
 -3.830315088604667e-16, -1.163964374617553e-18,  2.416057942948159e-21,  2.025570119369879e-23,  9.632419474902377e-27, -2.628667314463562e-28,  1.528468658178456e+00,
 -2.126680878526872e-03, -4.480900784626843e-06,  1.659962413194175e-09,  3.980075217155289e-11,  7.740574918233957e-14, -2.507857357169610e-16, -1.543787755902651e-18,
 -7.070533844215123e-22,  1.866005537482493e-23,  5.792602228500054e-26, -1.128163133081961e-28,  1.590322061260873e+00, -1.948807426458694e-03, -4.741545324960347e-06,
 -1.545855089616222e-09,  3.428682154927261e-11,  1.106290572374209e-13, -6.317156938608346e-17, -1.516815360910735e-18, -3.729867324143903e-21,  8.947089554835894e-24,
  7.920133689751225e-26,  1.185775242034332e-28,  1.649652720376929e+00, -1.751758640729245e-03, -4.830080397344015e-06, -4.583925726526445e-09,  2.518584197078355e-11,
  1.261964912606926e-13,  1.376301924447948e-16, -1.057815270402970e-18, -5.429866093512873e-21, -4.909004577285681e-24,  5.806221697192666e-26,  2.796825936583700e-28,
  1.705964699049632e+00, -1.539831881123837e-03, -4.736397494680862e-06, -7.177938494799042e-09,  1.359408984818136e-11,  1.203336286885889e-13,  3.001106621954069e-16,
 -2.990106302029087e-19, -5.023982286071147e-21, -1.604614774173040e-23,  4.972677975602349e-27,  2.502460614462688e-28,  1.758752400518819e+00, -1.318291275524377e-03,
 -4.462079182312947e-06, -9.074427358691669e-09,  1.138461722886890e-12,  9.388142903103168e-14,  3.793145870332658e-16,  4.968300077772744e-19, -2.666336386888523e-21,
 -1.849636761503881e-23, -4.651447280480374e-26,  5.138971048343280e-29,  1.807508666958241e+00, -1.093281094399017e-03, -4.022282588206719e-06, -1.008273000051239e-08,
 -1.026854260544339e-11,  5.281908549722711e-14,  3.541061379397825e-16,  1.034784980578829e-18,  4.939703066060085e-22, -1.125599073740651e-23, -6.243650792271508e-26,
 -1.538051072653100e-28,  1.851734482467421e+00, -8.716639246165814e-04, -3.446543752803516e-06, -1.011357721819412e-08, -1.880173676729701e-11,  7.220255597466412e-15,
  2.382708693880722e-16,  1.123986874456549e-18,  2.868371291832104e-21,  5.339929420186936e-25, -3.571465703453426e-26, -2.005129606194835e-28,  1.890950101677155e+00,
 -6.607787618428814e-04, -2.778085416708240e-06, -9.207832880059867e-09, -2.315368877474106e-11, -3.141603774887114e-14,  7.832970843220938e-17,  7.810803466582590e-19,
  3.362520662937263e-21,  8.995951500256338e-24,  7.143921564827953e-27, -8.020933363403315e-29,  1.924707261711152e+00, -4.681225316699930e-04, -2.071343739789700e-06,
 -7.546496542402947e-09, -2.290816274753004e-11, -5.382140300132492e-14, -6.414348190697674e-17,  2.291838459011475e-19,  2.077483877506009e-21,  9.447410184845500e-24,
  3.018879198071898e-26,  5.955523769537065e-29,  1.952601965806983e+00, -3.009691177390612e-04, -1.387673292791594e-06, -5.435195817773707e-09, -1.872595208928270e-11,
 -5.631235535126441e-14, -1.396969253355119e-16, -2.269657243902599e-19,  1.989581895148206e-22,  3.865533184701123e-24,  2.152122536788014e-26,  8.666887976732352e-29,
  1.974287189287152e+00, -1.659512385336707e-04, -7.895203227682568e-07, -3.261307597223914e-09, -1.224367561582248e-11, -4.234263056872143e-14, -1.344817689947545e-16,
 -3.843087441183402e-19, -9.332706829685187e-22, -1.572360675250136e-24,  7.281186335281063e-28,  2.310411491724836e-29,  1.989484889675973e+00, -6.863964548027614e-05,
 -3.337065351921526e-07, -1.428773124368362e-09, -5.667651306031056e-12, -2.126860167259474e-14, -7.620125281324247e-17, -2.614704888102249e-19, -8.581902423931941e-22,
 -2.678832508998998e-24, -7.853799390148949e-27, -2.107035326880083e-29,  1.997998715260179e+00, -1.314690485420551e-05, -6.468975499997625e-08, -2.824557374377184e-10,
 -1.153746386479857e-12, -4.512624970509048e-15, -1.710835341279018e-17, -6.331746022758120e-20, -2.297592046553561e-22, -8.197174362857641e-25, -2.880481694935833e-27,
 -9.980102204822995e-30,  3.797092652267334e-04, -1.665196140351757e-06,  5.476067525800900e-09, -1.600450550090055e-11,  4.383970752264837e-14, -1.152508954318962e-16,
  2.944526654852116e-19, -7.366716210433550e-22,  1.813272925921965e-24, -4.406257885315385e-27,  1.059275580898238e-29, -2.524309024004935e-32,  3.416836024322684e-03,
 -1.496938232671740e-05,  4.912043067106981e-08, -1.430193037726167e-10,  3.894880176126590e-13, -1.015464988694955e-15,  2.565342398897153e-18, -6.324279011183805e-21,
  1.527799097478601e-23, -3.626929296960277e-26,  8.473018312491141e-29, -1.950274505191964e-31,  9.488162088971071e-03, -4.148496024917457e-05,  1.355344145247948e-07,
 -3.916241266932645e-10,  1.053977327169987e-12, -2.701366728234598e-15,  6.665523847438342e-18, -1.592283061741994e-20,  3.690840155229876e-23, -8.304223852926673e-26,
  1.809675392338761e-28, -3.804775186524373e-31,  1.858779315282907e-02, -8.102593213571131e-05,  2.629727533859361e-07, -7.510747654439590e-10,  1.984791876303988e-12,
 -4.952024153159608e-15,  1.176059510320733e-17, -2.663296062563009e-20,  5.729343741683916e-23, -1.159160961185888e-25,  2.156564999432848e-28, -3.505957145337679e-31,
  3.070678876450038e-02, -1.333122852682161e-04,  4.288283266459694e-07, -1.205519888310733e-09,  3.105898393032437e-12, -7.456088859080091e-15,  1.671790110723578e-17,
 -3.471488280163937e-20,  6.510790773612007e-23, -1.033740069805683e-25,  1.088176521748987e-28,  7.519733970856807e-32,  4.583304215119059e-02, -1.979687902865277e-04,
  6.296457405933923e-07, -1.734323530324495e-09,  4.321014014566860e-12, -9.835135959118071e-15,  2.024076188562587e-17, -3.624869044447377e-20,  4.998349067300951e-23,
 -2.243316122484646e-26, -1.758320776969003e-28,  8.972104802113794e-31,  6.395111766289237e-02, -2.745234295709127e-04,  8.611405304619600e-07, -2.312502389209421e-09,
  5.517924710640829e-12, -1.167355058842599e-14,  2.103326352238609e-17, -2.789977430511420e-20,  5.581990903547630e-24,  1.306192156670588e-25, -5.987555715124821e-28,
  1.858242822785579e-30,  8.504204382774590e-02, -3.624054847248202e-04,  1.118224943934972e-06, -2.911283748915569e-09,  6.573811609278176e-12, -1.255383731403274e-14,
  1.798350630443686e-17, -7.697263892151407e-21, -6.768882560255444e-23,  3.328511152222756e-25, -1.032846695467173e-27,  2.465472443167124e-30,  1.090830594837568e-01,
 -4.609433230052733e-04,  1.395041536477652e-06, -3.498790696299430e-09,  7.361520035354589e-12, -1.209587030042580e-14,  1.035034230627246e-17,  2.428073158560203e-20,
 -1.609056758887915e-22,  5.332967026827886e-25, -1.281207356002966e-27,  2.132461494990304e-30,  1.360473099147134e-01, -5.693619359495310e-04,  1.685006094463664e-06,
 -4.040861644540437e-09,  7.756675163046227e-12, -9.998201300945491e-15, -2.063952757057980e-18,  6.542830894888480e-20, -2.563494825820784e-22,  6.593970115055497e-25,
 -1.127183959929227e-27,  4.232426135938177e-31,  1.659034893705525e-01, -6.867803001351936e-04,  1.980861704021144e-06, -4.502010836867750e-09,  7.645507045274371e-12,
 -6.079102457912946e-15, -1.877471453583093e-17,  1.104500225691683e-19, -3.291230789131849e-22,  6.317768527887458e-25, -4.105234769268624e-28, -2.664323642752123e-30,
  1.986154257990090e-01, -8.122086508043476e-04,  2.274746099197967e-06, -4.846535230104676e-09,  6.933194539871453e-12, -3.145532082516790e-16, -3.853053228174682e-17,
  1.516118859312885e-19, -3.508440346625089e-22,  3.860431093482045e-25,  8.864675371712667e-28, -6.477360181367420e-30,  2.341416030644221e-01, -9.445457849183141e-04,
  2.558274746077622e-06, -5.039770638443170e-09,  5.552470638738701e-12,  7.130090684692772e-15, -5.930439332034329e-17,  1.794706218769766e-19, -2.952606372562560e-22,
 -1.018329528995157e-25,  2.567846461842510e-27, -9.668096383473821e-30,  2.724346153945529e-01, -1.082576542154175e-03,  2.822642438281405e-06, -5.049495868322173e-09,
  3.472149767803167e-12,  1.587844209459974e-14, -7.837939905109336e-17,  1.840987301007472e-19, -1.452260980066086e-22, -7.920927975646363e-25,  4.198305557682754e-27,
 -1.043626998669221e-29,  3.134405482976473e-01, -1.224969651600656e-03,  3.058746475046662e-06, -4.847477329403948e-09,  7.051405775065686e-13,  2.533547203458598e-14,
 -9.254381457638460e-17,  1.567558123549513e-19,  9.999658869623752e-23, -1.566893081598527e-24,  5.151307974176689e-27, -7.090038512133445e-30,  3.570982797595186e-01,
 -1.370276179761737e-03,  3.257334737106523e-06, -4.411137719087963e-09, -2.684602952422590e-12,  3.469811903079623e-14, -9.840270169572936e-17,  9.187093071110703e-20,
  4.185773864110548e-22, -2.232834340365207e-24,  4.748076553405067e-27,  1.150018246349210e-30,  4.033386952060289e-01, -1.516928873300005e-03,  3.409182126108754e-06,
 -3.725320237807322e-09, -6.576859558379566e-12,  4.298812673574974e-14, -9.280197183238267e-17, -1.089921769207552e-20,  7.629317741605418e-22, -2.546783848858165e-24,
  2.481566493062853e-27,  1.332098939660776e-29,  4.520838095578162e-01, -1.663242759099758e-03,  3.505298831332308e-06, -2.784103757966080e-09, -1.079243731523314e-11,
  4.911048249402858e-14, -7.334487434568102e-17, -1.448763146042163e-19,  1.061433351594668e-21, -2.267836556996963e-24, -1.713452117291515e-27,  2.621146570718032e-29,
  5.032457897896007e-01, -1.807417445894617e-03,  3.537173652147359e-06, -1.592603837046397e-09, -1.509388850786047e-11,  5.193953589035290e-14, -3.896064230546382e-17,
 -2.952634584759431e-19,  1.226672718159855e-21, -1.231905758518968e-24, -7.220735297151773e-27,  3.458942081610661e-29,  5.567258718399110e-01, -1.947541666693152e-03,
  3.497055028129162e-06, -1.686689874317471e-10, -1.919062018289580e-11,  5.043271462894227e-14,  9.539000835471747e-18, -4.392333832980876e-19,  1.171072921567613e-21,
  5.633637014318977e-25, -1.264109534520320e-26,  3.248745663559644e-29,  6.124131666349001e-01, -2.081600709624632e-03,  3.378271370953026e-06,  1.455648910508159e-09,
 -2.274939290649169e-11,  4.376852197392969e-14,  6.900546922438577e-17, -5.476731321055516e-19,  8.291658435161491e-22,  2.885608292353235e-24, -1.594499447529507e-26,
  1.557027779348005e-29,  6.701833515678413e-01, -2.207487505452115e-03,  3.175590577050707e-06,  3.233006211065781e-09, -2.541111134620310e-11,  3.150104896681634e-14,
  1.337145388998157e-16, -5.889257940388058e-19,  1.836558754423322e-22,  5.237319766203748e-24, -1.496031895319004e-26, -1.590881081603180e-29,  7.298972462368690e-01,
 -2.323018269737052e-03,  2.885616014310811e-06,  5.100255278771874e-09, -2.681456415637233e-11,  1.371755881170635e-14,  1.954715340990382e-16, -5.345838795810860e-19,
 -7.102370448886662e-22,  6.901232303032577e-24, -8.182710617669205e-27, -5.468990259076314e-29,  7.913992748649501e-01, -2.425953730409997e-03,  2.507212574587106e-06,
  6.978740390809571e-09, -2.662730371814139e-11, -8.820945115612645e-15,  2.441861385803799e-16, -3.669196523256223e-19, -1.710205657189165e-21,  7.086362051117853e-24,
  4.257744409583393e-27, -8.624408306387895e-29,  8.545158229452113e-01, -2.514027096961066e-03,  2.041951304599535e-06,  8.775665885733028e-09, -2.458310046611041e-11,
 -3.458319333859964e-14,  2.690107669965081e-16, -8.689358664763191e-20, -2.591592493958749e-21,  5.175290409325066e-24,  1.982339715231257e-26, -9.221783733468143e-29,
  9.190535026700896e-01, -2.584980029338156e-03,  1.494554425128833e-06,  1.038681872754273e-08, -2.052430187691251e-11, -6.124812890498275e-14,  2.600634597670164e-16,
  2.790616249834686e-19, -3.080050165520304e-21,  1.031737070783108e-24,  3.347986628675769e-26, -5.807677351838229e-29,  9.847973510672463e-01, -2.636607918749047e-03,
  8.733140506504817e-07,  1.170091931057176e-08, -1.444594376428364e-11, -8.579821441296397e-14,  2.106325790129977e-16,  6.759514752958610e-19, -2.915914838330815e-21,
 -4.725336366944928e-24,  3.876213978406690e-26,  1.678684344528093e-29,  1.051508996966282e+00, -2.666815764657962e-03,  1.904476258101624e-07,  1.260582310370267e-08,
 -6.536639492215249e-12, -1.047582573199341e-13,  1.195856599854798e-16,  1.023586629943768e-18, -1.944346902528533e-21, -1.062116209326276e-23,  3.016229075119473e-26,
  1.111091710101749e-28,  1.118924848438931e+00, -2.673685776036653e-03, -5.376586920041354e-07,  1.299668129611327e-08,  2.790733091707788e-12, -1.145997521980309e-13,
 -6.504003741032989e-18,  1.228680294138552e-18, -2.111525199847163e-22, -1.454726288122562e-23,  6.357264749050532e-27,  1.826132576167572e-28,  1.186754371594187e+00,
 -2.655557480799914e-03, -1.290379943432098e-06,  1.278596871720188e-08,  1.288738217603834e-11, -1.123049749839143e-13, -1.521964625220675e-16,  1.206262134135582e-18,
  1.971022865774690e-21, -1.438984907699051e-23, -2.706261147317151e-26,  1.830410160338956e-28,  1.254678554778401e+00, -2.611120523168345e-03, -2.043028406143560e-06,
  1.191498226299177e-08,  2.288595808248577e-11, -9.604418125220851e-14, -2.937770966486933e-16,  9.078854061008788e-19,  4.030663730959478e-21, -8.983731338542651e-24,
 -5.734310147383832e-26,  8.612561062458263e-29,  1.322348679176498e+00, -2.539519383917156e-03, -2.767356758689710e-06,  1.036599384732353e-08,  3.175646197767467e-11,
 -6.586498279643535e-14, -4.022852255284810e-16,  3.498773983251370e-19,  5.257059659859307e-21,  9.312178823970447e-25, -6.850467212742011e-26, -8.390643082303533e-29,
  1.389385546787287e+00, -2.440467894121158e-03, -3.432470317574691e-06,  8.173722754084043e-09,  3.840724707375811e-11, -2.423379095571490e-14, -4.492316337148516e-16,
 -3.692559700267110e-19,  5.036415891919429e-21,  1.229349566652243e-23, -4.939497923421060e-26, -2.453877252797007e-28,  1.455379348117497e+00, -2.314369570049246e-03,
 -4.006219016523072e-06,  5.434227379505612e-09,  4.183104320519755e-11,  2.377686663850937e-14, -4.144300972245747e-16, -1.074932069785964e-18,  3.149324590507437e-21,
  2.040026832952900e-23, -2.624794441973730e-27, -2.931392040472336e-28,  1.519890381844783e+00, -2.162437465344506e-03, -4.457110375234608e-06,  2.308817608455447e-09,
  4.128516674596297e-11,  7.086625857193790e-14, -2.942244373323987e-16, -1.555228763586703e-18,  5.071133593677676e-24,  2.086153585672694e-23,  5.174051009658382e-26,
 -1.687310973550813e-28,  1.582450862731929e+00, -1.986804496538902e-03, -4.756731342856717e-06, -9.796623501008391e-10,  3.648073301969490e-11,  1.085901221267808e-13,
 -1.072605434606051e-16, -1.630396649164389e-18, -3.349596667136821e-21,  1.220759747884131e-23,  8.351061433956952e-26,  7.554228412497770e-29,  1.642568066074967e+00,
 -1.790612268860623e-03, -4.882585822569461e-06, -4.160591772197153e-09,  2.774030181116858e-11,  1.291244088834021e-13,  1.055555530556652e-16, -1.233926149655885e-18,
 -5.561803551627512e-21, -2.338757826650128e-24,  7.047298160112992e-26,  2.827864548688655e-28,  1.699729049106359e+00, -1.578063719102426e-03, -4.821147044710196e-06,
 -6.940791512573712e-09,  1.607201467834009e-11,  1.274171184513223e-13,  2.894011811708005e-16, -4.689599044873278e-19, -5.595285876068136e-21, -1.561342925863747e-23,
  1.699932599154899e-26,  2.963554235757553e-28,  1.753407153122708e+00, -1.354423025898434e-03, -4.570799441835350e-06, -9.040691767903060e-09,  3.108200129124649e-12,
  1.031416445527316e-13,  3.919286755901667e-16,  4.004994680418240e-19, -3.365028471921361e-21, -2.029813101105336e-23, -4.322153433565933e-26,  9.974386842311684e-29,
  1.803070415938321e+00, -1.125946035854265e-03, -4.144224744978860e-06, -1.023810399579413e-08, -9.124820951401461e-12,  6.166671478014628e-14,  3.832369861129099e-16,
  1.043613460829139e-18,  4.218952972923807e-23, -1.388647816113244e-23, -6.901607763031462e-26, -1.439185831540054e-28,  1.848191906234252e+00, -8.997268273705818e-04,
 -3.569705844640008e-06, -1.041292817327453e-08, -1.859754380226811e-11,  1.332679555188133e-14,  2.710283540398223e-16,  1.215788861693365e-18,  2.859678146165779e-21,
 -1.079409483701490e-24, -4.516322516702600e-26, -2.290203953830918e-28,  1.888261828514726e+00, -6.834517660090863e-04, -2.890822548259100e-06, -9.583208666068483e-09,
 -2.376137479424583e-11, -2.926122184219592e-14,  1.017554042809098e-16,  8.939104286965749e-19,  3.690592200151236e-21,  9.202718953620164e-24,  2.976180732773612e-27,
 -1.101881849511188e-28,  1.922801047645635e+00, -4.850618267831741e-04, -2.164136668694516e-06, -7.921719892853639e-09, -2.399942526592183e-11, -5.527600589598519e-14,
 -5.674280098070580e-17,  3.013431799327127e-19,  2.439951567520999e-21,  1.070661195940115e-23,  3.274717612642195e-26,  5.622859541522888e-29,  1.951375466183341e+00,
 -3.123365737285767e-04, -1.454731096108754e-06, -5.744005338912814e-09, -1.988623693063679e-11, -5.974048789773414e-14, -1.459406831943752e-16, -2.181986758795141e-19,
  3.545677960278874e-22,  4.806636810230194e-24,  2.563539781366126e-26,  1.005971848823882e-28,  1.973610499360591e+00, -1.724273396787919e-04, -8.298599311254841e-07,
 -3.464160312196387e-09, -1.312369312600088e-11, -4.570274751995172e-14, -1.456689765154674e-16, -4.150713526849896e-19, -9.890874947639120e-22, -1.520801365051477e-24,
  1.904952754502840e-27,  3.067593977429079e-29,  1.989204880982903e+00, -7.137945345937877e-05, -3.514102732994516e-07, -1.522960434158447e-09, -6.111921079260811e-12,
 -2.318848036233359e-14, -8.392183655071089e-17, -2.905380704967628e-19, -9.605127338812250e-22, -3.012227074169061e-24, -8.833605320743089e-27, -2.349710960705921e-29,
  1.997945070685778e+00, -1.367830159580596e-05, -6.819303578427036e-08, -3.016606269961413e-10, -1.248252907122520e-12, -4.945359012266747e-15, -1.898877439584147e-17,
 -7.116503801983374e-20, -2.614533597959288e-22, -9.442234049719863e-25, -3.357849910148681e-27, -1.177049320729166e-29,  3.731348980099065e-04, -1.622144064730050e-06,
  5.288147231006973e-09, -1.532113325452982e-11,  4.160372075744227e-14, -1.084251400289754e-16,  2.746149303848175e-19, -6.811052389883512e-22,  1.662014237574044e-24,
 -4.003943811587614e-27,  9.542587101089936e-30, -2.254595028282390e-32,  3.357733699994889e-03, -1.458317938925726e-05,  4.744093034245523e-08, -1.369466839109527e-10,
  3.697803370290166e-13, -9.559676671381793e-16,  2.394915405265644e-18, -5.855636714054638e-21,  1.403128964683306e-23, -3.304564152085993e-26,  7.659833327571107e-29,
 -1.749848473496187e-31,  9.324361434557124e-03, -4.041920025957456e-05,  1.309343516725353e-07, -3.751841655110917e-10,  1.001514283550468e-12, -2.546613479371069e-15,
  6.235779903377707e-18, -1.478822913717003e-20,  3.404523946607039e-23, -7.612781333229403e-26,  1.650083741757703e-28, -3.455082927427463e-31,  1.826784065901844e-02,
 -7.895766926265954e-05,  2.541471768776359e-07, -7.200953333388913e-10,  1.888514587062763e-12, -4.678515169433792e-15,  1.103992402446116e-17, -2.486470324897239e-20,
  5.327206709156539e-23, -1.075924129223744e-25,  2.006745375265558e-28, -3.304336673288776e-31,  3.018031043504175e-02, -1.299386899985691e-04,  4.146554029368364e-07,
 -1.156997014390388e-09,  2.960711381016955e-12, -7.066291411385654e-15,  1.577449929440509e-17, -3.269012739417499e-20,  6.146547529273794e-23, -9.896755637781700e-26,
  1.112128153403601e-28,  3.507379684156305e-32,  4.505111115307938e-02, -1.930137113550512e-04,  6.092422689470470e-07, -1.666734875737210e-09,  4.129087796961301e-12,
 -9.361357286431371e-15,  1.924806050609273e-17, -3.466342290084225e-20,  4.905844055019791e-23, -2.871740032459493e-26, -1.393479561639102e-28,  7.642546715961950e-31,
  6.286662853862669e-02, -2.677438221332979e-04,  8.339126061400486e-07, -2.226056199746340e-09,  5.289438527594171e-12, -1.117810222003127e-14,  2.025524543678839e-17,
 -2.765038024191663e-20,  9.872299861898832e-24,  1.082404716731939e-25, -5.217193384539476e-28,  1.647086612809164e-30,  8.361009472976189e-02, -3.535976576463883e-04,
  1.083912415081662e-06, -2.808088004187621e-09,  6.327032228109748e-12, -1.212505341411599e-14,  1.773940407480881e-17, -9.679349138413337e-21, -5.642425041253581e-23,
  2.936455861261659e-25, -9.289283303534729e-28,  2.259740497910322e-30,  1.072613437509218e-01, -4.499489486303537e-04,  1.353754815097781e-06, -3.382927997227024e-09,
  7.122138847198297e-12, -1.183986820369988e-14,  1.096093379074501e-17,  1.942922060005243e-20, -1.426069848301909e-22,  4.839099810535394e-25, -1.188540252209218e-27,
  2.076063068466734e-30,  1.337965181214502e-01, -5.560737539488413e-04,  1.637253789676218e-06, -3.918356639055957e-09,  7.556359481059152e-12, -1.002665759097622e-14,
 -3.432978238142971e-19,  5.759627750137821e-20, -2.334175575166775e-22,  6.147599014675167e-25, -1.102866483147474e-27,  6.712531458543549e-31,  1.631877227279506e-01,
 -6.711474328394386e-04,  1.927567453965128e-06, -4.380678832423616e-09,  7.519663503375381e-12, -6.493753611584744e-15, -1.582616573220711e-17,  1.002786007358487e-19,
 -3.067011598631266e-22,  6.132055518073545e-25, -5.134165193899489e-28, -2.029134174202110e-30,  1.954026214580150e-01, -7.942414306703720e-04,  2.217252896643600e-06,
 -4.735703269106755e-09,  6.917993502482606e-12, -1.189599968845955e-15, -3.444044269119590e-17,  1.406135408382467e-19, -3.363743150596019e-22,  4.160856037451289e-25,
  6.225109788793395e-28, -5.536307476778099e-30,  2.304039714439323e-01, -9.243199753246093e-04,  2.498334995577786e-06, -4.949865937327429e-09,  5.681240907716697e-12,
  5.766017012572937e-15, -5.441190719576141e-17,  1.699826341826751e-19, -2.971777438730177e-22, -7.347200365459530e-27,  2.163323180229534e-27, -8.723450376619995e-30,
  2.681490891075627e-01, -1.060236810545003e-03,  2.762391967701768e-06, -4.991501385192698e-09,  3.771322268197672e-12,  1.405864334160178e-14, -7.329375679819850e-17,
  1.790267695523379e-19, -1.708282034174494e-22, -6.332196731578682e-25,  3.748644727071032e-27, -9.984569377916440e-30,  3.085892415471360e-01, -1.200732129180538e-03,
  3.000660775187489e-06, -4.832260583605464e-09,  1.189996677571029e-12,  2.316740131070651e-14, -8.811805344955891e-17,  1.590923187263085e-19,  4.722040210945402e-23,
 -1.367273110254129e-24,  4.825412635455994e-27, -7.678134519950828e-30,  3.516689561874015e-01, -1.344429914775481e-03,  3.204165850152833e-06, -4.448667083500884e-09,
 -2.014041344967896e-12,  3.236876343791697e-14, -9.565461534094225e-17,  1.040160117016450e-19,  3.416205760450818e-22, -2.042507027137707e-24,  4.753945787796978e-27,
 -8.198176333656992e-31,  3.973252410621519e-01, -1.489835956012933e-03,  3.363874884739196e-06, -3.823792959440195e-09, -5.739380315572109e-12,  4.075989203194793e-14,
 -9.277899674773806e-17,  1.206789762244033e-20,  6.731667268559822e-22, -2.436761780532438e-24,  2.996313253880668e-27,  1.013262696082802e-29,  4.454867076641637e-01,
 -1.635336866952447e-03,  3.470885611759739e-06, -2.949022030667126e-09, -9.828139500275080e-12,  4.730528935548676e-14, -7.693824409400588e-17, -1.122277556159992e-19,
  9.788260049460194e-22, -2.314350206581981e-24, -6.379009054934622e-28,  2.268824465891533e-29,  4.960725880541662e-01, -1.779200528594904e-03,  3.516647500840512e-06,
 -1.825849263756758e-09, -1.406509525858451e-11,  5.090966470344458e-14, -4.668551721178953e-17, -2.567723142957362e-19,  1.177486163325895e-21, -1.490940136670384e-24,
 -5.747681194153710e-27,  3.229911324951202e-29,  5.489916379666911e-01, -1.919578465710115e-03,  3.493222015385335e-06, -4.676413422705595e-10, -1.818065075937956e-11,
  5.051831815217024e-14, -2.232523780064826e-18, -4.015293265544928e-19,  1.182599734988682e-21,  8.660398401114396e-26, -1.119130893987927e-26,  3.325606506349221e-29,
  6.041409181203043e-01, -2.054510788257068e-03,  3.393584380750082e-06,  1.098746411932321e-09, -2.185868739020641e-11,  4.524372494752492e-14,  5.405683536152334e-17,
 -5.195993734198143e-19,  9.217470507091149e-22,  2.263096085375002e-24, -1.514358946916496e-26,  2.065468178029652e-29,  6.614044470103921e-01, -2.181934459373220e-03,
  3.211968525111202e-06,  2.831637368684616e-09, -2.475033040493000e-11,  3.451315298745473e-14,  1.173344083405448e-16, -5.801488075613490e-19,  3.612843031200904e-22,
  4.627644668514878e-24, -1.545735833718338e-26, -6.838722347925067e-30,  7.206517203663034e-01, -2.299695800449355e-03,  2.944254744747182e-06,  4.673666824033391e-09,
 -2.649452455554379e-11,  1.822691442031253e-14,  1.802218720031345e-16, -5.534040499416567e-19, -4.682363702106636e-22,  6.528851347478970e-24, -1.036054269404090e-26,
 -4.428892694307664e-29,  7.817360954887957e-01, -2.405568304258028e-03,  2.588396437932816e-06,  6.551606997520175e-09, -2.674598107731286e-11, -3.089710182330310e-15,
  2.331847594782697e-16, -4.175389289152526e-19, -1.452928305699398e-21,  7.182697826978108e-24,  6.095335834154174e-28, -7.931866649159962e-29,  8.444930432224977e-01,
 -2.497276991457260e-03,  2.144877626316238e-06,  8.377152763812491e-09, -2.521044650532449e-11, -2.816532494946806e-14,  2.654457666612288e-16, -1.666985299478267e-19,
 -2.391994545772043e-21,  5.886295505098318e-24,  1.571286522827070e-26, -9.414261722864297e-29,  9.087382768204797e-01, -2.572530700129834e-03,  1.617186598399870e-06,
  1.004897177645902e-08, -2.168627369400313e-11, -5.492393519417018e-14,  2.665047190501406e-16,  1.813475060868071e-19, -3.019457339504425e-21,  2.315542898258122e-24,
  3.060987037804873e-26, -7.187898996972874e-29,  9.742657759700319e-01, -2.629063820111275e-03,  1.012282551788486e-06,  1.145633740437275e-08, -1.610987829620330e-11,
 -8.052660322583236e-14,  2.282294567490661e-16,  5.802206804252735e-19, -3.058003209857302e-21, -3.166983664609213e-24,  3.898660430867533e-26, -6.389377403705300e-30,
  1.040845736393549e+00, -2.664689040280016e-03,  3.410213766546675e-07,  1.248464110396889e-08, -8.600820389875474e-12, -1.015516518787841e-13,  1.473192500706579e-16,
  9.554917615467944e-19, -2.303873763340739e-21, -9.323527301632282e-24,  3.455098565635559e-26,  8.799478009046537e-29,  1.108222491385476e+00, -2.677362619979802e-03,
 -3.815062374694550e-07,  1.302300026113086e-08,  4.999577419419852e-13, -1.143442569951831e-13,  2.772615868098950e-17,  1.213608854139177e-18, -7.283606524219042e-22,
 -1.413458745625374e-23,  1.420885451603628e-26,  1.733322156201223e-28,  1.176112472047656e+00, -2.665263460416452e-03, -1.135785862625674e-06,  1.297401117747604e-08,
  1.060752610520690e-11, -1.155457445263114e-13, -1.176173791462190e-16,  1.260853450389115e-18,  1.435490476301406e-21, -1.530628282753392e-23, -1.864690529007915e-26,
  1.984317357377437e-28,  1.244202298362535e+00, -2.626886754720345e-03, -1.897916172847336e-06,  1.226541633928417e-08,  2.089670103827077e-11, -1.027755216608368e-13,
 -2.666022976822737e-16,  1.031257437066514e-18,  3.666981526418291e-21, -1.119006964587700e-23, -5.269130266291374e-26,  1.248876582605915e-28,  1.312147123806440e+00,
 -2.561152136029352e-03, -2.639961372388613e-06,  1.086303793483065e-08,  3.034350569553951e-11, -7.538324797240427e-14, -3.901322645501708e-16,  5.181043598882535e-19,
  5.240484637898703e-21, -1.870193013593262e-24, -7.124542422647445e-26, -3.993451171608394e-29,  1.379569391583655e+00, -2.467524911855712e-03, -3.330716449468245e-06,
  8.783772320092203e-09,  3.781401399453267e-11, -3.512081371086136e-14, -4.572507936819731e-16, -2.014117482582090e-19,  5.440862963008661e-21,  1.010713806653084e-23,
 -5.977144941761038e-26, -2.245943162581485e-28,  1.446058199440603e+00, -2.346147068643620e-03, -3.936978593091037e-06,  6.106777932811706e-09,  4.220474109822256e-11,
  1.348143232447502e-14, -4.430071842985742e-16, -9.624490643532446e-19,  3.878669139764537e-21,  2.003009897765648e-23, -1.604642528525043e-26, -3.154534983165303e-28,
  1.511169509679830e+00, -2.197972190385252e-03, -4.425395699433039e-06,  2.980320412672409e-09,  4.262835388390355e-11,  6.328304138941744e-14, -3.376529094633524e-16,
 -1.542666332912488e-18,  7.913973881260322e-22,  2.276586592522507e-23,  4.305963848637871e-26, -2.258560244820251e-28,  1.574427476814926e+00, -2.024895284244830e-03,
 -4.764913967198612e-06, -3.787518038536670e-10,  3.862303440252921e-11,  1.054563729359611e-13, -1.543415716721084e-16, -1.729901847050882e-18, -2.849329828994209e-21,
  1.559948570021442e-23,  8.569366149697104e-26,  2.198728926078356e-29,  1.635327190333483e+00, -1.829864921380576e-03, -4.929764219855126e-06, -3.695961502962139e-09,
  3.034522058072562e-11,  1.312229737449024e-13,  6.850529497868002e-17, -1.412682670870098e-18, -5.592271583876445e-21,  7.275318401112886e-25,  8.278329891479392e-26,
  2.747621502131251e-28,  1.693339134807137e+00, -1.616961485762558e-03, -4.902808324812458e-06, -6.662879994733174e-09,  1.868864298031792e-11,  1.341844296909529e-13,
  2.736802031974116e-16, -6.568448476193688e-19, -6.141865776531255e-21, -1.465935489082185e-23,  3.102913508262691e-26,  3.408999099690554e-28,  1.747915642539920e+00,
 -1.391422369093812e-03, -4.678919616973963e-06, -8.973943242638340e-09,  5.265938441548938e-12,  1.126696457487998e-13,  4.015229499477465e-16,  2.808027043975421e-19,
 -4.125676721026598e-21, -2.192302744030471e-23, -3.760691769782167e-26,  1.569058063617548e-28,  1.798499542726880e+00, -1.159593647727687e-03, -4.267915629775151e-06,
 -1.037372478378207e-08, -7.797144105872565e-12,  7.121472785656144e-14,  4.123980412690812e-16,  1.036420002003026e-18, -5.088982747366397e-22, -1.676889748175229e-23,
 -7.496644816241498e-26, -1.248782762242237e-28,  1.844535085136928e+00, -9.287893306008351e-04, -3.696436374343798e-06, -1.070799140608581e-08, -1.826315043481995e-11,
  2.025027283433785e-14,  3.063431338001251e-16,  1.306307950204055e-18,  2.785797073742552e-21, -3.095842585906964e-24, -5.586387799815161e-26, -2.572033436072428e-28,
  1.885481030784190e+00, -7.070448470768212e-04, -3.008121002984815e-06, -9.967931015175048e-09, -2.432008027420079e-11, -2.650508635912243e-14,  1.284881926549289e-16,
  1.017323038974389e-18,  4.022772831142630e-21,  9.214644074082238e-24, -2.642650349666916e-27, -1.462693657300460e-28,  1.920825562773951e+00, -5.027617750166099e-04,
 -2.261537965848981e-06, -8.314625818492969e-09, -2.511783306732903e-11, -5.652739364492298e-14, -4.715231950012259e-17,  3.858461875650981e-19,  2.849548509126123e-21,
  1.206424387859169e-23,  3.508426764477959e-26,  4.932431380079572e-29,  1.950102399888878e+00, -3.242556358623227e-04, -1.525608289712151e-06, -6.071935966583333e-09,
 -2.111655999603294e-11, -6.331492974957346e-14, -1.518639238157736e-16, -2.038770565333113e-19,  5.471712320232773e-22,  5.925025378934915e-24,  3.039687117525028e-26,
  1.160892772831759e-28,  1.972907243834129e+00, -1.792361391894768e-04, -8.727205194841943e-07, -3.681645810628486e-09, -1.407366870919513e-11, -4.934189346514449e-14,
 -1.577421952653707e-16, -4.475806323496611e-19, -1.042115674834517e-21, -1.414963549154185e-24,  3.456162370826284e-27,  4.018743277711504e-29,  1.988913622465339e+00,
 -7.426553616061381e-05, -3.702882095265886e-07, -1.624573592076551e-09, -6.596509251922702e-12, -2.530380113305014e-14, -9.250401253713511e-17, -3.230797833797373e-19,
 -1.075569114883938e-21, -3.387003148223513e-24, -9.924169329922265e-27, -2.610135179820741e-29,  1.997889242975168e+00, -1.423867279821932e-05, -7.193614162582620e-08,
 -3.224493872256896e-10, -1.351883818310286e-12, -5.425978827065606e-15, -2.110382755983757e-17, -8.010238933500484e-20, -2.979933001230646e-22, -1.089497175811068e-24,
 -3.921400303453385e-27, -1.390825331261148e-29,  3.667297834619918e-04, -1.580563147577599e-06,  5.108217171066081e-09, -1.467247002462423e-11,  3.949961129745426e-14,
 -1.020573538171475e-16,  2.562674109286698e-19, -6.301552828820012e-22,  1.524510478451408e-24, -3.641356485303165e-27,  8.604177752576321e-30, -2.015654344934972e-32,
  3.300149769480478e-03, -1.421012624014791e-05,  4.583244807519122e-08, -1.311800852222568e-10,  3.512227404274125e-13, -9.004075326596716e-16,  2.237068882376922e-18,
 -5.425093129159150e-21,  1.289499130273239e-23, -3.013028916311300e-26,  6.929931851764807e-29, -1.571272402621219e-31,  9.164751448692787e-03, -3.938946569296670e-05,
  1.265266322532514e-07, -3.595594022750729e-10,  9.520456870912374e-13, -2.401802986591740e-15,  5.836558663763004e-18, -1.374138638972323e-20,  3.141986783277322e-23,
 -6.982197321741699e-26,  1.505143353018780e-28, -3.138278382995662e-31,  1.795602232548277e-02, -7.695854976664515e-05,  2.456842884520177e-07, -6.906134996036720e-10,
  1.797538452853533e-12, -4.421722425607674e-15,  1.036700681155261e-17, -2.322044921080873e-20,  4.953977550526376e-23, -9.985033949065610e-26,  1.865737575072770e-28,
 -3.105800615926724e-31,  2.966710335264018e-02, -1.266761879269198e-04,  4.010510690950818e-07, -1.110735976226032e-09,  2.823098426219905e-12, -6.698468313263508e-15,
  1.488618278350487e-17, -3.077937652667398e-20,  5.798299609168622e-23, -9.449821446216322e-26,  1.120189648436002e-28,  2.745070519165178e-33,  4.428867907912476e-02,
 -1.882186674334484e-04,  5.896317447806979e-07, -1.602142515497597e-09,  3.946402481726559e-12, -8.910874341186400e-15,  1.829930012842896e-17, -3.311110614471505e-20,
  4.793206553067605e-23, -3.365392661198095e-26, -1.083182542033563e-28,  6.489026470127088e-31,  6.180882868047861e-02, -2.611779500749028e-04,  8.077004251348353e-07,
 -2.143187529364633e-09,  5.070675230295006e-12, -1.070122769911518e-14,  1.948601546633830e-17, -2.727600951401705e-20,  1.341025986802219e-23,  8.876379659465542e-26,
 -4.534960826166324e-28,  1.457355714114603e-30,  8.221283568859983e-02, -3.450594438774350e-04,  1.050814826260950e-06, -2.708772460596737e-09,  6.088765650116548e-12,
 -1.170275449153470e-14,  1.744464342564430e-17, -1.132276563960499e-20, -4.649840713402255e-23,  2.584187836225226e-25, -8.338332038721751e-28,  2.064594562570757e-30,
  1.054829536422064e-01, -4.392793713345292e-04,  1.313835636929860e-06, -3.270853685635080e-09,  6.888013574793331e-12, -1.157077746832098e-14,  1.144361857074726e-17,
  1.513553114575058e-20, -1.260201488196239e-22,  4.381743224594444e-25, -1.098791554150487e-27,  2.000788048585432e-30,  1.315981242527333e-01, -5.431617646610940e-04,
  1.590952302935833e-06, -3.799059066843670e-09,  7.355870289685224e-12, -1.001636828092383e-14,  1.168093611799681e-18,  5.047256463093277e-20, -2.120726002296163e-22,
  5.712951862379147e-25, -1.069004392215796e-27,  8.588069865106387e-31,  1.605336440186391e-01, -6.559351304431263e-04,  1.875716845506244e-06, -4.261422919308248e-09,
  7.386211937631319e-12, -6.840976758879811e-15, -1.315247758319107e-17,  9.081324184542478e-20, -2.850154173820772e-22,  5.910488393155269e-25, -5.904841605705903e-28,
 -1.488703018080528e-30,  1.922607745219974e-01, -7.767288416533212e-04,  2.161087657783498e-06, -4.625249302462729e-09,  6.886248481528776e-12, -1.970126772258134e-15,
 -3.065167580614787e-17,  1.300935728312939e-19, -3.210033884187328e-22,  4.363702142325834e-25,  3.978911995180898e-28, -4.688885436337189e-30,  2.267462909053325e-01,
 -9.045693353161281e-04,  2.439485583567383e-06, -4.858112874304864e-09,  5.783882358276279e-12,  4.516171144646915e-15, -4.978545402993152e-17,  1.604846807642717e-19,
 -2.959746782999264e-22,  7.178045085190077e-26,  1.799706730335210e-27, -7.810955480647238e-30,  2.639519622583499e-01, -1.038376220313612e-03,  2.702864971758502e-06,
 -4.929004728064058e-09,  4.035307387991341e-12,  1.235910840835858e-14, -6.836076387756204e-17,  1.732236218911749e-19, -1.910295641755458e-22, -4.919054212050935e-25,
  3.321045199212714e-27, -9.438968324751261e-30,  3.038339568534675e-01, -1.176958433332511e-03,  2.942802810283937e-06, -4.809627241434981e-09,  1.632557886589598e-12,
  2.110614963036392e-14, -8.364945173991646e-17,  1.598524063990777e-19,  1.390364085308216e-24, -1.181129091872410e-24,  4.479344788750677e-27, -8.014305776856903e-30,
  3.463421643736641e-01, -1.319010623418375e-03,  3.150609459277771e-06, -4.475836464889051e-09, -1.389381174912245e-12,  3.010917071753270e-14, -9.259991394405456e-17,
  1.138079857460401e-19,  2.714998993273011e-22, -1.853567646793305e-24,  4.681361265509011e-27, -2.421556464220183e-30,  3.914194265047626e-01, -1.463109998938761e-03,
  3.317464898762962e-06, -3.909222287925852e-09, -4.946409824905912e-12,  3.853960488567713e-14, -9.215253496412871e-17,  3.222960959889811e-20,  5.877001994129313e-22,
 -2.308854724463042e-24,  3.378329897672654e-27,  7.289237866063889e-30,  4.390006665604347e-01, -1.607713937122615e-03,  3.434584739735407e-06, -3.098804749561942e-09,
 -8.900735459170419e-12,  4.542452529278770e-14, -7.965465656489594e-17, -8.224142212901972e-20,  8.952814262228617e-22, -2.320916691179090e-24,  2.846754044649683e-28,
  1.927033937910304e-29,  4.890119082357697e-01, -1.751158738083407e-03,  3.493420457213512e-06, -2.042808487976071e-09, -1.305866705940721e-11,  4.970714346969241e-14,
 -5.335599765056130e-17, -2.199931756950963e-19,  1.120009647111313e-21, -1.693179693087310e-24, -4.383517676116516e-27,  2.966208564127309e-29,  5.413691732351771e-01,
 -1.891660004758203e-03,  3.485898299205631e-06, -7.504554803441457e-10, -1.717170876892847e-11,  5.033409987120287e-14, -1.294567091851145e-17, -3.637197830877973e-19,
  1.178012741134872e-21, -3.317553866793609e-25, -9.727439191160757e-27,  3.315132891234558e-29,  5.959772475195751e-01, -2.027315249742145e-03,  3.404700979528904e-06,
  7.563120140964761e-10, -2.094200017216602e-11,  4.636990778936099e-14,  3.993242062475581e-17, -4.889149801813316e-19,  9.925454823081676e-22,  1.676756791552991e-24,
 -1.414509473211943e-26,  2.453878511515279e-29,  6.527283064399974e-01, -2.156109471241772e-03,  3.243595401088024e-06,  2.441301693168661e-09, -2.403321547535053e-11,
  3.713570484811928e-14,  1.012762884577264e-16, -5.660419577406991e-19,  5.167001486707166e-22,  4.005783469149226e-24, -1.557693012074052e-26,  1.229137015365967e-30,
  7.115003903036212e-01, -2.275924603789023e-03,  2.997808048836492e-06,  4.252900450657382e-09, -2.608799597776543e-11,  2.236481667001233e-14,  1.645515314330264e-16,
 -5.647106074531615e-19, -2.410991236920227e-22,  6.078508908998045e-24, -1.208140558045220e-26, -3.397237743320867e-29,  7.721557242627178e-01, -2.384553933266464e-03,
  2.664447042401456e-06,  6.123476953148208e-09, -2.675278405534315e-11,  2.361416103309809e-15,  2.208816250424637e-16, -4.598973820051934e-19, -1.194732068403866e-21,
  7.139640802162009e-24, -2.701739622198298e-27, -7.099882850597846e-29,  8.345388802278676e-01, -2.479722764926456e-03,  2.242965784040717e-06,  7.969623568980059e-09,
 -2.571046794814110e-11, -2.185908676998012e-14,  2.597392688004647e-16, -2.397386482213010e-19, -2.169772714311971e-21,  6.432026783561255e-24,  1.158005089466445e-26,
 -9.327541042859289e-29,  8.984747842926467e-01, -2.559116836582586e-03,  1.735657257608117e-06,  9.693552620940117e-09, -2.272043603967236e-11, -4.847772221689768e-14,
  2.702439119672577e-16,  8.628853944407628e-20, -2.914852041893339e-21,  3.473308213502768e-24,  2.720057742487612e-26, -8.256179069410632e-29,  9.637665815469577e-01,
 -2.620420157828719e-03,  1.148159883418681e-06,  1.118599802984474e-08, -1.766437690647537e-11, -7.486529446163577e-14,  2.430906513570536e-16,  4.808404301580899e-19,
 -3.144071452405049e-21, -1.619643967891527e-24,  3.822280015244018e-26, -2.801453925121356e-29,  1.030193381902581e+00, -2.661364098982819e-03,  4.899450138161087e-07,
  1.233098076025637e-08, -1.059437408767207e-11, -9.770357587462758e-14,  1.729923684508537e-16,  8.766713248690894e-19, -2.613776681387312e-21, -7.871293509466903e-24,
  3.787898031970641e-26,  6.306024775612980e-29,  1.097507926516980e+00, -2.679789603389745e-03, -2.252575570457121e-07,  1.301275215898575e-08, -1.777536246322126e-12,
 -1.132741562499341e-13,  6.130527197520512e-17,  1.182284171157269e-18, -1.225172801393350e-21, -1.341766188308167e-23,  2.153006746474425e-26,  1.586034678641263e-28,
  1.165434235497592e+00, -2.673724286099874e-03, -9.791561299892552e-07,  1.312510299311722e-08,  8.271267307812555e-12, -1.179402380013146e-13, -8.175414685660224e-17,
  1.297846043255968e-18,  8.731714545298392e-22, -1.587447729327172e-23, -9.699412919739254e-27,  2.071319477428367e-28,  1.233665324672116e+00, -2.641475818643910e-03,
 -1.748794024059994e-06,  1.258298187425697e-08,  1.877961184240987e-11, -1.088146009927463e-13, -2.361476770712265e-16,  1.141759983279829e-18,  3.227623537641033e-21,
 -1.317711987287917e-23, -4.640376823253387e-26,  1.602094247436800e-28,  1.301861112967953e+00, -2.581742265615908e-03, -2.506743327190717e-06,  1.133596924609886e-08,
  2.874348165162956e-11, -8.455347160860367e-14, -3.732916640602267e-16,  6.841700076068352e-19,  5.121562837054827e-21, -4.741346348015786e-24, -7.196538937657766e-26,
  7.658344316745841e-30,  1.369646682485047e+00, -2.493738794233820e-03, -3.221706151826043e-06,  9.382579399436902e-09,  3.700150377191846e-11, -4.614251370947578e-14,
 -4.604015155975942e-16, -2.196270053016729e-20,  5.759377724484852e-21,  7.526996072426845e-24, -6.901102924725072e-26, -1.937632452522960e-28,  1.436611099852517e+00,
 -2.377338275663809e-03, -3.859638600678150e-06,  6.783624236486442e-09,  4.236594047962888e-11,  2.540563458045441e-15, -4.681107532653922e-16, -8.269456221859122e-19,
  4.584812527891761e-21,  1.910621453556927e-23, -3.023822621786363e-26, -3.278426292702956e-28,  1.502307057583864e+00, -2.233220612431694e-03, -4.385499231929193e-06,
  3.672044437155897e-09,  4.380949729102983e-11,  5.466466603622304e-14, -3.803675593757881e-16, -1.503916492822949e-18,  1.639424964474195e-21,  2.427288480650891e-23,
  3.188457092909819e-26, -2.816547877587000e-28,  1.566251643310166e+00, -2.063022111700033e-03, -4.765682273704337e-06,  2.558718576933441e-10,  4.069114550657665e-11,
  1.011611675993289e-13, -2.039661764043590e-16, -1.811432713580159e-18, -2.225978283699757e-21,  1.902859655444882e-23,  8.529991626671829e-26, -4.141868217117976e-29,
  1.627928585443553e+00, -1.869471987420509e-03, -4.971115757807243e-06, -3.189366778977679e-09,  3.298281304153012e-11,  1.323722654226707e-13,  2.645347186613086e-17,
 -1.590553862283793e-18, -5.503608645594082e-21,  4.275432944051051e-24,  9.445746269060583e-26,  2.535492576227665e-28,  1.686792345000235e+00, -1.656498481043652e-03,
 -4.980879075335532e-06, -6.342041978195689e-09,  2.143640828391745e-11,  1.405093673879642e-13,  2.524595365961031e-16, -8.615587150238358e-19, -6.643534261004049e-21,
 -1.310592579068023e-23,  4.693623396246515e-26,  3.812038203382281e-28,  1.742274410582197e+00, -1.429282868298282e-03, -4.786025341158555e-06, -8.871135102923629e-09,
  7.616253493166573e-12,  1.223848885365513e-13,  4.074164888400236e-16,  1.358776731687315e-19, -4.940149446548133e-21, -2.327050466057410e-23, -2.928897833025166e-26,
  2.225146861610584e-28,  1.793792090235880e+00, -1.194236920589659e-03, -4.393100082461333e-06, -1.048653713971038e-08, -6.271535371782897e-12,  8.145809904188212e-14,
  4.410948754775449e-16,  1.009887346938424e-18, -1.167807191320788e-21, -1.986943377110120e-23, -7.984045552681692e-26, -9.465147586872127e-29,  1.840759964056066e+00,
 -9.588797393217698e-04, -3.826670840072334e-06, -1.099654968213307e-08, -1.778160835355716e-11,  2.805138200307910e-14,  3.441478334813096e-16,  1.393216367665299e-18,
  2.631324777232301e-21, -5.564672969098863e-24, -6.776926807995603e-26, -2.834805308070042e-28,  1.882603954506482e+00, -7.315949300012827e-04, -3.130087826394957e-06,
 -1.036111561423994e-08, -2.481696107191136e-11, -2.306469738601875e-14,  1.588250877705538e-16,  1.151325701190196e-18,  4.350937147873122e-21,  8.968140161172750e-24,
 -9.993798365501397e-27, -1.890106959238892e-28,  1.918777689395860e+00, -5.212600991353889e-04, -2.363762284402261e-06, -8.725613153306864e-09, -2.625876740685501e-11,
 -5.751868993600314e-14, -3.500478205247409e-17,  4.842556652350620e-19,  3.309617995964074e-21,  1.350798156428002e-23,  3.701798847695509e-26,  3.768250377232117e-29,
  1.948780497908385e+00, -3.367577963455016e-04, -1.600541145609499e-06, -6.420131248540828e-09, -2.241975723264802e-11, -6.702598230840461e-14, -1.572935501100313e-16,
 -1.827098164512080e-19,  7.836333081645311e-22,  7.247956302501146e-24,  3.587348190726305e-26,  1.330852082074779e-28,  1.972176050439099e+00, -1.863985267396512e-04,
 -9.182845851675051e-07, -3.914929238108861e-09, -1.509939948926380e-11, -5.328190755847841e-14, -1.707487673645908e-16, -4.817130180438544e-19, -1.090109958240892e-21,
 -1.238041146136458e-24,  5.476518267297049e-27,  5.208058786265700e-29,  1.988610509656977e+00, -7.730765488079376e-05, -3.904334573409866e-07, -1.734290120682915e-09,
 -7.125539571030291e-12, -2.763645696000109e-14, -1.020509913677988e-16, -3.595278175782234e-19, -1.204930681943988e-21, -3.807739780787869e-24, -1.113271052386655e-26,
 -2.885314899542115e-29,  1.997831112269329e+00, -1.483001564435713e-05, -7.593898753901203e-08, -3.449759867581133e-10, -1.465655712412369e-12, -5.960499988880493e-15,
 -2.348631479299149e-17, -9.029723796896803e-20, -3.401925838951924e-22, -1.259311984444033e-24, -4.587957144885676e-27, -1.646576621092576e-29,  3.604881622047235e-04,
 -1.540391097861446e-06,  4.935873201918982e-09, -1.405647714919983e-11,  3.751856719211776e-14, -9.611327429351239e-17,  2.392868003985612e-19, -5.834036406120022e-22,
  1.399408793117641e-24, -3.314284996702521e-27,  7.764825814943132e-30, -1.803761083971016e-32,  3.244032747091293e-03, -1.384966911697170e-05,  4.429141947688688e-08,
 -1.257017202634615e-10,  3.337394189918957e-13, -8.484950659416887e-16,  2.090783903083297e-18, -5.029286695248023e-21,  1.185857434455920e-23, -2.749176912070361e-26,
  6.274263352908874e-29, -1.412038401180283e-31,  9.009191046356235e-03, -3.839425613175750e-05,  1.223017549229795e-07, -3.447034776902592e-10,  9.053798134422442e-13,
 -2.266231351920347e-15,  5.465506199564828e-18, -1.277503259228679e-20,  2.901139845217751e-23, -6.406891474714995e-26,  1.373475801261924e-28, -2.851288459502609e-31,
  1.765206726990840e-02, -7.502574261082416e-05,  2.375666150053396e-07, -6.625470592470831e-10,  1.711540333887622e-12, -4.180540467818347e-15,  9.738497778934230e-18,
 -2.169127622640853e-20,  4.607625530282404e-23, -9.265496323874038e-26,  1.733359683910897e-28, -2.912350041344264e-31,  2.916673207290700e-02, -1.235203368752418e-04,
  3.879888959277961e-07, -1.066619034041762e-09,  2.692633006556549e-12, -6.351335242932214e-15,  1.404983136314767e-17, -2.897748708964168e-20,  5.466166925583587e-23,
 -9.002306718942134e-26,  1.115506750861626e-28, -2.304632764522359e-32,  4.354511825223083e-02, -1.835774562855213e-04,  5.707790844983396e-07, -1.540402265511276e-09,
  3.772502621844378e-12, -8.482644295432089e-15,  1.739347493922046e-17, -3.159744692301916e-20,  4.664913673977947e-23, -3.744608346576530e-26, -8.201711449888400e-29,
  5.489829005057904e-31,  6.077687913062934e-02, -2.548178565536371e-04,  7.824619783958927e-07, -2.063743771106186e-09,  4.861265720729509e-12, -1.024267674510162e-14,
  1.872875113677217e-17, -2.679913192003589e-20,  1.629422244883558e-23,  7.185499865891655e-26, -3.931823865810180e-28,  1.287272739520637e-30,  8.084920739842245e-02,
 -3.367813078421420e-04,  1.018886427802836e-06, -2.613202013808359e-09,  5.858870761366494e-12, -1.128804726657801e-14,  1.710812838251021e-17, -1.266812825716146e-20,
 -3.777429945925503e-23,  2.268273756747888e-25, -7.470753209521021e-28,  1.880876646166781e-30,  1.037466115641114e-01, -4.289238311662572e-04,  1.275239054004506e-06,
 -3.162481734279094e-09,  6.659376526964074e-12, -1.129148649662462e-14,  1.181326832810757e-17,  1.134696282017169e-20, -1.110160156757008e-22,  3.959580474777841e-25,
 -1.012669104637441e-27,  1.912037280003467e-30,  1.294506465070435e-01, -5.306145154887503e-04,  1.546063153092686e-06, -3.682965770996874e-09,  7.155933854670631e-12,
 -9.972123396657601e-15,  2.489350349461848e-18,  4.400713132887650e-20, -1.922661462624902e-22,  5.293344181221821e-25, -1.028038127978513e-27,  9.956775820012668e-31,
  1.579395939207137e-01, -6.411319454350509e-04,  1.825284278537976e-06, -4.144354389168075e-09,  7.246436528724917e-12, -7.127134092710028e-15, -1.073422816262965e-17,
  8.202851445180459e-20, -2.641773088104147e-22,  5.662594127333363e-25, -6.456672641705570e-28, -1.032725809982057e-30,  1.891880876790132e-01, -7.596602825461936e-04,
  2.106244319585954e-06, -4.515423299032570e-09,  6.839778659166787e-12, -2.663201683882284e-15, -2.715048401843158e-17,  1.200754956680194e-19, -3.050552009287867e-22,
  4.483889184966589e-25,  2.085585381085481e-28, -3.931667832777154e-30,  2.231666783463657e-01, -8.852850603992494e-04,  2.381746256289568e-06, -4.764911580826798e-09,
  5.862615732171740e-12,  3.374175724309940e-15, -4.542399590967839e-17,  1.510680736703643e-19, -2.921752546626793e-22,  1.371542530433484e-25,  1.475311017489126e-27,
 -6.942299704256657e-30,  2.598413301858904e-01, -1.016988776948053e-03,  2.644112177262200e-06, -4.862549858486406e-09,  4.266472207880521e-12,  1.077594698331901e-14,
 -6.359856776510029e-17,  1.668521748611801e-19, -2.064455059586665e-22, -3.671943397240459e-25,  2.918946970145342e-27, -8.830022656299249e-30,  2.991728431017471e-01,
 -1.153646397521860e-03,  2.885257589824526e-06, -4.780236888799557e-09,  2.034967419744103e-12,  1.915224015482694e-14, -7.917911121684002e-17,  1.592504551554420e-19,
 -3.799062974887815e-23, -1.009059062245908e-24,  4.123236615948273e-27, -8.141250973139856e-30,  3.411161909936025e-01, -1.294020920819266e-03,  3.096785525018143e-06,
 -4.493368746322881e-09, -8.091588065608029e-13,  2.792593363913062e-14, -8.930143356070637e-17,  1.214642350928976e-19,  2.081127164196609e-22, -1.668840439714597e-24,
  4.545766051083900e-27, -3.689828527002956e-30,  3.856197670233245e-01, -1.436759210040792e-03,  3.270104423779845e-06, -3.982318331163224e-09, -4.197650578353107e-12,
  3.634082246466784e-14, -9.099912237747834e-17,  4.973277775568469e-20,  5.070841605544113e-22, -2.168066634705920e-24,  3.642899634913217e-27,  4.793702644874916e-30,
  4.326245253309128e-01, -1.580388354465965e-03,  3.396574253860797e-06, -3.234053188216515e-09, -8.011532190612343e-12,  4.348834067061821e-14, -8.156886611934238e-17,
 -5.492546665105193e-20,  8.121288774016366e-22, -2.293541813069593e-24,  1.060410970765863e-27,  1.602292267879879e-29,  4.820630078418096e-01, -1.723312906097840e-03,
  3.467685699110395e-06, -2.243865616396735e-09, -1.207780788643948e-11,  4.835667430441515e-14, -5.902343246183790e-17, -1.851594757701730e-19,  1.056206057783657e-21,
 -1.843246676617110e-24, -3.140652773050556e-27,  2.680507851745134e-29,  5.338582440610897e-01, -1.863813434551124e-03,  3.475277505946132e-06, -1.017169631965153e-09,
 -1.616893669067104e-11,  4.990543996620416e-14, -2.260438952232747e-17, -3.262867200333342e-19,  1.159415617709764e-21, -6.918771989057748e-25, -8.284741754531035e-27,
  3.231738377987520e-29,  5.879225112675877e-01, -2.000046964355561e-03,  3.411797051934485e-06,  4.287066792414290e-10, -2.000610832327684e-11,  4.716765142027447e-14,
  2.669577012098528e-17, -4.562947462329537e-19,  1.042992716935210e-21,  1.133437602742958e-24, -1.300078691112566e-26,  2.729703869216129e-29,  6.441559424670900e-01,
 -2.130050005308731e-03,  3.270608755437331e-06,  2.062838669178198e-09, -2.326746864642819e-11,  3.937814301508472e-14,  8.567941850362687e-17, -5.473202405377146e-19,
  6.497255720808512e-22,  3.385921898020922e-24, -1.536535323236618e-26,  8.202657749203823e-30,  7.024449700664328e-01, -2.251745060749749e-03,  3.046353847753759e-06,
  3.839280071703553e-09, -2.560249170048926e-11,  2.612363763771864e-14,  1.486638378870754e-16, -5.690205726809401e-19, -3.130464157229376e-23,  5.568317358416399e-24,
 -1.335580275451989e-26, -2.403999442100239e-29,  7.626605948005725e-01, -2.362951701352144e-03,  2.735362977965199e-06,  5.696093811563722e-09, -2.665360851307361e-11,
  7.503966031754843e-15,  2.075077148013549e-16, -4.940431838073277e-19, -9.403788408594614e-22,  6.971770873824599e-24, -5.624027447914162e-27, -6.170605191506539e-29,
  8.246564723982298e-01, -2.461403521007296e-03,  2.336119725517014e-06,  7.555094907234308e-09, -2.608589561607383e-11, -1.571352544953694e-14,  2.520899296935697e-16,
 -3.053851116699063e-19, -1.930864063713654e-21,  6.813964309286661e-24,  7.541271672176524e-27, -8.992484402329811e-29,  8.882668153535286e-01, -2.544772539347837e-03,
  1.849767875204634e-06,  9.322622240202065e-09, -2.362499019844039e-11, -4.197329262045953e-14,  2.713743901225772e-16, -4.783367495007568e-21, -2.771126563597290e-21,
  4.486246261836843e-24,  2.339197710390605e-26, -9.002433701635769e-29,  9.533041146790980e-01, -2.610702867280346e-03,  1.280647707328300e-06,  1.089171091490991e-08,
 -1.910230944010659e-11, -6.888096879924552e-14,  2.551389619414093e-16,  3.795895416123961e-19, -3.175209260413873e-21, -1.212784414386697e-25,  3.655403943216018e-26,
 -4.742543439371139e-29,  1.019556697519267e+00, -2.656855680468660e-03,  6.368359917739829e-07,  1.214607195738177e-08, -1.250498906502591e-11, -9.326690013288283e-14,
  1.963277082288592e-16,  7.887940075052057e-19, -2.869270410223634e-21, -6.308195101289285e-24,  4.008828465424646e-26,  3.731096803535324e-29,  1.086786152042819e+00,
 -2.680967706834142e-03, -6.934964605783388e-08,  1.296627882610479e-08, -4.025649452845350e-12, -1.114104525163337e-13,  9.378899748757497e-17,  1.135529612575836e-18,
 -1.691073879924216e-21, -1.242230314539176e-23,  2.809595277639555e-26,  1.391326855481458e-28,  1.154724672301957e+00, -2.680925460311646e-03, -8.209390044153838e-07,
  1.323847863006858e-08,  5.895799136093504e-12, -1.194636341503081e-13, -4.510961975221246e-17,  1.316586848222792e-18,  2.969132122555939e-22, -1.607916958163571e-23,
 -5.229733511170128e-28,  2.088108587145425e-28,  1.223072403990631e+00, -2.654857246996044e-03, -1.596068183764049e-06,  1.286574846480069e-08,  1.654929230398462e-11,
 -1.140872935809568e-13, -2.028062081755618e-16,  1.237110033209522e-18,  2.721621112252734e-21, -1.488294707693803e-23, -3.866649422058125e-26,  1.905447223123401e-28,
  1.291494908410026e+00, -2.601244399132733e-03, -2.368009685480318e-06,  1.178185646900989e-08,  2.696446888791648e-11, -9.326424839918325e-14, -3.518700567754672e-16,
  8.447749533416837e-19,  4.899272052602698e-21, -7.598759263127139e-24, -7.054567136105449e-26,  5.699637632381706e-29,  1.359620907196912e+00, -2.519052089264878e-03,
 -3.105595453128460e-06,  9.966620462631213e-09,  3.596821594564709e-11, -5.717847271182180e-14, -4.583994256273820e-16,  1.661241528571980e-19,  5.978707789536890e-21,
  4.607244576471001e-24, -7.668304357404877e-26, -1.534835676101596e-28,  1.427040524356263e+00, -2.407878247112096e-03, -3.774168300857111e-06,  7.461267791690533e-09,
  4.230261800061702e-11, -8.954743164478894e-15, -4.891096600100731e-16, -6.694881803632545e-19,  5.247376496539994e-21,  1.760706030943915e-23, -4.472541475158514e-26,
 -3.286370040678301e-28,  1.493304303150053e+00, -2.268116352173674e-03, -4.337194553776767e-06,  4.381232540871941e-09,  4.480812560880132e-11,  4.503727242629003e-14,
 -4.216097840418394e-16, -1.437252744437705e-18,  2.533076362735968e-21,  2.528481525195969e-23,  1.833572520382476e-26, -3.332615423029823e-28,  1.557923339219093e+00,
 -2.101124068098122e-03, -4.758639604075337e-06,  9.228326194042347e-10,  4.266126981914394e-11,  9.564994523634897e-14, -2.555758796220856e-16, -1.871049818590804e-18,
 -1.480158671788296e-21,  2.238353967517945e-23,  8.192342365670666e-26, -1.133046986858575e-28,  1.620370930180734e+00, -1.909384830409876e-03, -5.006134373899240e-06,
 -2.640443210552278e-09,  3.563289765579700e-11,  1.324529904202721e-13, -2.051919164385765e-17, -1.763456204081067e-18, -5.279079638072838e-21,  8.267345953429574e-24,
  1.048749235799671e-25,  2.173825382434145e-28,  1.680086183531469e+00, -1.696643885287656e-03, -5.054831904770277e-06, -5.976257379325367e-09,  2.430510595077751e-11,
  1.462544673414831e-13,  2.252914364617648e-16, -1.081305038399001e-18, -7.077415987361805e-21, -1.088267935136208e-23,  6.446613900988091e-26,  4.141058150242460e-28,
  1.736480031671533e+00, -1.467994624409795e-03, -4.891665304365616e-06, -8.729161231585275e-09,  1.016194375765091e-11,  1.321898939295732e-13,  4.088804417381026e-16,
 -3.581663234320177e-20, -5.796425710658096e-21, -2.422523870013922e-23, -1.791540654292790e-26,  2.955736461626577e-28,  1.788944053735117e+00, -1.229886653289018e-03,
 -4.519484943936037e-06, -1.057326369262215e-08, -4.534244905867604e-12,  9.237879224844021e-14,  4.687365719349905e-16,  9.604488934568969e-19, -1.941490274414129e-21,
 -2.313457855688147e-23, -8.310033751819796e-26, -5.117197384311345e-29,  1.836862375859393e+00, -9.900257314043065e-04, -3.960316466420424e-06, -1.127610499385038e-08,
 -1.713477710011850e-11,  3.678836115648487e-14,  3.843027358575881e-16,  1.473665511255896e-18,  2.379132929002685e-21, -8.531836977967375e-24, -8.075151609928461e-26,
 -3.057609144389836e-28,  1.879626696362296e+00, -7.571397500325323e-04, -3.256818163213892e-06, -1.076165898759254e-08, -2.523744322704435e-11, -1.885002171548791e-14,
  1.930593144487725e-16,  1.295627083430787e-18,  4.664462604853565e-21,  8.387923799164006e-24, -1.937963824851369e-26, -2.388001153383022e-28,  1.916654155457190e+00,
 -5.405962569278869e-04, -2.471028580981026e-06, -9.154997237162345e-09, -2.741638026709042e-11, -5.818366760099472e-14, -1.988775444931746e-17,  5.982327862230334e-19,
  3.822915600413039e-21,  1.501712524389260e-23,  3.830982507993785e-26,  1.989320274286157e-29,  1.947407361389503e+00, -3.498764932047764e-04, -1.679779923465588e-06,
 -6.789778317452163e-09, -2.379842601208380e-11, -7.085933310452258e-14, -1.620170889429874e-16, -1.531700148007494e-19,  1.071848028773993e-21,  8.805316392309224e-24,
  4.212801336034251e-26,  1.514081051994447e-28,  1.971415460337359e+00, -1.939369095192221e-04, -9.667491783797209e-07, -4.165272048876864e-09, -1.620713041058217e-11,
 -5.754571494210995e-14, -1.847314728343272e-16, -5.172626447584753e-19, -1.130146911574901e-21, -9.690230989206337e-25,  8.082145456083346e-27,  6.688624732132113e-29,
  1.988294897503386e+00, -8.051634950138516e-05, -4.119476712573229e-07, -1.852857164171295e-09, -7.703599423870116e-12, -3.021096892465806e-14, -1.126788140646834e-16,
 -4.003673350353041e-19, -1.350338403372480e-21, -4.279272367539549e-24, -1.246466294987642e-26, -3.169999425199745e-29,  1.997770550389764e+00, -1.545449431368304e-05,
 -8.022343786797237e-08, -3.694116666198799e-10, -1.590713761882030e-12, -6.555784744341104e-15, -2.617412010803414e-17, -1.019456513428853e-19, -3.890135273602594e-22,
 -1.458182226333645e-24, -5.377871240169224e-27, -1.953150307627845e-29,  3.544045177092844e-04, -1.501568762191128e-06,  4.770734819606062e-09, -1.347125163237905e-11,
  3.565243307088979e-14, -9.056146258601869e-17,  2.235609152446600e-19, -5.404731608965505e-22,  1.285499155225895e-24, -3.018995182508909e-27,  7.013361138312356e-30,
 -1.615666975083118e-32,  3.189333306481876e-03, -1.350128193884127e-05,  4.281448651368636e-08, -1.204949695068140e-10,  3.172601171820998e-13, -7.999641094572953e-16,
  1.955131115715242e-18, -4.665175095015830e-21,  1.091258738962784e-23, -2.510202332747449e-26,  5.684812809699449e-29, -1.269940809712130e-31,  8.857544995625589e-03,
 -3.743214499495765e-05,  1.182507566985732e-07, -3.305729904292770e-10,  8.613384673752458e-13, -2.139248802743197e-15,  5.120463072330385e-18, -1.188253527988337e-20,
  2.680085598518457e-23, -5.881808593134474e-26,  1.253831798956597e-28, -2.591313114514118e-31,  1.735571566068507e-02, -7.315655268358462e-05,  2.297776395880309e-07,
 -6.358188049210474e-10,  1.630218416350229e-12, -3.953941213043870e-15,  9.151292155186880e-18, -2.026889189339735e-20,  4.286244091635679e-23, -8.597225859739954e-26,
  1.609354034116778e-28, -2.725446731474011e-31,  2.867877850608558e-02, -1.204669005616303e-04,  3.754438270078667e-07, -1.024535070943284e-09,  2.568913549206271e-12,
 -6.023681033077507e-15,  1.326246907397422e-17, -2.727930815940569e-20,  5.150085249769206e-23, -8.558766689925846e-26,  1.100714162996614e-28, -4.337056726365414e-32,
  4.281982525369415e-02, -1.790841495453090e-04,  5.526508916740621e-07, -1.481377063346768e-09,  3.606953373326095e-12, -8.075650222882103e-15,  1.652943833199968e-17,
 -3.012683101125840e-20,  4.524760520955466e-23, -4.027001681525346e-26, -5.980873306105046e-29,  4.625695506715859e-31,  5.976997209794056e-02, -2.486559135746679e-04,
  7.581570529009189e-07, -1.987578179600381e-09,  4.660846619931761e-12, -9.802130021880979e-15,  1.798604312114619e-17, -2.623925568176392e-20,  1.861113999710742e-23,
  5.721447621458797e-26, -3.399516866546829e-28,  1.135125389316949e-30,  7.951818797391264e-02, -3.287540735170352e-04,  9.880830770485331e-07, -2.521243983153127e-09,
  5.637186360885572e-12, -1.088183792542110e-14,  1.673768529821619e-17, -1.375186191343345e-20, -3.012693337545503e-23,  1.985480821661145e-25, -6.681410823192793e-28,
  1.709016320508814e-30,  1.020510822503978e-01, -4.188719235695211e-04,  1.237921171136037e-06, -3.057722842218435e-09,  6.436405696561659e-12, -1.100454401546780e-14,
  1.208333624455321e-17,  8.014867225038359e-21, -9.747062885059405e-23,  3.571056106800947e-25, -9.306656237132244e-28,  1.814214164835689e-30,  1.273526482780629e-01,
 -5.184208613415161e-04,  1.502547963519435e-06, -3.570062716290202e-09,  6.957185119617747e-12, -9.898270500338380e-15,  3.638223473486315e-18,  3.815166240205496e-20,
 -1.739394521254043e-22,  4.891197635171332e-25, -9.820054955824040e-28,  1.090409589767587e-30,  1.554039584847355e-01, -6.267266401070675e-04,  1.776242936617712e-06,
 -4.029564979632235e-09,  7.101498815112100e-12, -7.358130597130620e-15, -8.552752613563903e-18,  7.389593968189003e-20, -2.442667239459370e-22,  5.396412460150527e-25,
 -6.824652521162382e-28, -6.514619335508517e-31,  1.861828059066261e-01, -7.430252121605544e-04,  2.052713989428135e-06, -4.406447233521920e-09,  6.780265203153401e-12,
 -3.275556048764076e-15, -2.392259860903836e-17,  1.105732852628159e-19, -2.888028633629684e-22,  4.534751163317977e-25,  5.064266357346184e-29, -3.260004654147739e-30,
  2.196632861691194e-01, -8.664582067223552e-04,  2.325132167398916e-06, -4.670627674664209e-09,  5.919534670655801e-12,  2.333707144484722e-15, -4.132416426927745e-17,
  1.418082729916395e-19, -2.862468617424228e-22,  1.903018387105537e-25,  1.188017379680246e-27, -6.125568217568784e-30,  2.558153129783963e-01, -9.960681055942592e-04,
  2.586178008084480e-06, -4.792643509321828e-09,  4.467102005004668e-12,  9.304885753450802e-15, -5.902102539898146e-17,  1.600562002887227e-19, -2.176547823136384e-22,
 -2.580184765433218e-25,  2.544559818127330e-27, -8.183172600995892e-30,  2.946040591540661e-01, -1.130793206214674e-03,  2.828102414192720e-06, -4.744714788045914e-09,
  2.399369567866033e-12,  1.730527981979026e-14, -7.474235641842990e-17,  1.574846675797305e-19, -7.143436072851150e-23, -8.512922483977385e-25,  3.765424183524624e-27,
 -8.097854338180116e-30,  3.359893141270017e-01, -1.269462496713489e-03,  3.042805477914378e-06, -4.501962417735130e-09, -2.717933387609139e-13,  2.582420948639478e-14,
 -8.581598397847362e-17,  1.271973469567088e-19,  1.512654611467182e-22, -1.490562975826405e-24,  4.361039236429787e-27, -4.660830470961124e-30,  3.799247476577097e-01,
 -1.410790613221819e-03,  3.221937231283965e-06, -4.043784366146845e-09, -3.492551950444623e-12,  3.417531625363477e-14, -8.939096177492844e-17,  6.473916037575938e-20,
  4.317014422198050e-22, -2.018790739750048e-24,  3.805202390493176e-27,  2.638855655518738e-30,  4.263570683229173e-01, -1.553373108716028e-03,  3.357024864966190e-06,
 -3.355386405590931e-09, -7.161451621536735e-12,  4.151509361841913e-14, -8.275529201404080e-17, -3.024891200100484e-20,  7.304864711948325e-22, -2.237933908658918e-24,
  1.697918365402693e-27,  1.299379427531209e-29,  4.752250641132055e-01, -1.695682338224666e-03,  3.439631503593910e-06, -2.429452136045946e-09, -1.112524049061532e-11,
  4.688165545813933e-14, -6.374485287522851e-17, -1.524445827815272e-19,  9.878642484076881e-22, -1.946153017587151e-24, -2.026285197819908e-27,  2.383800461462672e-29,
  5.264585113489675e-01, -1.836064360947021e-03,  3.461552086243198e-06, -1.267920255884513e-09, -1.517697140172401e-11,  4.925746949382123e-14, -3.122518391586726e-17,
 -2.896451403937633e-19,  1.128882323045027e-21, -9.952080684207615e-25, -6.892172535781644e-27,  3.089561324435035e-29,  5.799769371571413e-01, -1.972737379781237e-03,
  3.415052177394404e-06,  1.161863059555117e-10, -1.905736354796636e-11,  4.765884050330427e-14,  1.439221035089290e-17, -4.223640999006521e-19,  1.074730772712210e-21,
  6.380077665483490e-25, -1.175811308028337e-26,  2.902772268615815e-29,  6.356882201067697e-01, -2.103792387205623e-03,  3.293155479829589e-06,  1.696966232860264e-09,
 -2.246057144335949e-11,  4.125300727387843e-14,  7.066301235370635e-17, -5.246965363966723e-19,  7.606592336323834e-22,  2.780327203609729e-24, -1.487186435047741e-26,
  1.404030041231285e-29,  6.934870134928320e-01, -2.227196867461505e-03,  3.089985224166684e-06,  3.434008427385484e-09, -2.504562997790180e-11,  2.950044712708493e-14,
  1.327466268464944e-16, -5.669199781524870e-19,  1.593091899803598e-22,  5.015721203068736e-24, -1.420622103284310e-26, -1.473625480394413e-29,  7.532529764881790e-01,
 -2.340802621666538e-03,  2.801163173425004e-06,  5.271102538465043e-09, -2.645486442658727e-11,  1.231498249571277e-14,  1.932906076942478e-16, -5.201681234184178e-19,
 -6.940726027849147e-22,  6.695382974999635e-24, -8.123496645942988e-27, -5.184413265314332e-29,  8.148488003712201e-01, -2.442359035775007e-03,  2.424267304086056e-06,
  7.135532108614642e-09, -2.634039227055946e-11, -9.772729987789334e-15,  2.427113673020041e-16, -3.631973538112138e-19, -1.681072078963250e-21,  7.037949915329086e-24,
  3.697861862883933e-27, -8.445948937948417e-29,  8.781180208482150e-01, -2.529533397977277e-03,  1.959344786386194e-06,  8.938260318569395e-09, -2.439938817655989e-11,
 -3.547177936938512e-14,  2.700245128517674e-16, -9.070259483704071e-20, -2.593748032438464e-21,  5.341217530082414e-24,  1.932544717450254e-26, -9.430225709734850e-29,
  9.428826138727429e-01, -2.599940181846405e-03,  1.409470042245242e-06,  1.057538911723927e-08, -2.041789387517333e-11, -6.264156723518507e-14,  2.643463057614451e-16,
  2.781907939325978e-19, -3.153806274852706e-21,  1.294027828410020e-24,  3.408978965820612e-26, -6.409933696583350e-29,  1.008940382288046e+00, -2.651181522503425e-03,
  7.813276695095882e-07,  1.193133275972924e-08, -1.432147390373616e-11, -8.830057433066252e-14,  2.170965901692802e-16,  6.936560727270687e-19, -3.067175244485184e-21,
 -4.679403307993666e-24,  4.116490635804184e-26,  1.173317212005253e-29,  1.076062155290287e+00, -2.680901386091705e-03,  8.578613203518458e-08,  1.288417575832332e-08,
 -6.228807089708589e-12, -1.087844987214266e-13,  1.247606098766138e-16,  1.074488485718373e-18, -2.116632146215835e-21, -1.118264576814786e-23,  3.371697010065568e-26,
  1.158156681477793e-28,  1.143988843585192e+00, -2.686856103619971e-03, -6.615902664004578e-07,  1.331365095821303e-08,  3.498689443266707e-12, -1.201033527629674e-13,
 -8.199116300011159e-18,  1.316840348755793e-18, -2.801080488873870e-22, -1.591740494358911e-23,  8.572249020503147e-27,  2.034673870180558e-28,  1.212428421832795e+00,
 -2.667003910204032e-03, -1.440166591800553e-06,  1.311203066329969e-08,  1.422172743126251e-11, -1.185296375480184e-13, -1.670304184348080e-16,  1.315347687236705e-18,
  2.160085440359547e-21, -1.625436093191142e-23, -2.972917722034999e-26,  2.145583719873867e-28,  1.281052948243369e+00, -2.619615757872016e-03, -2.224101836807920e-06,
  1.219791521047609e-08,  2.501674147041220e-11, -1.014078417084815e-13, -3.260664588288400e-16,  9.966359371906999e-19,  4.575660610575522e-21, -1.035590454320660e-23,
 -6.695426959831742e-26,  1.060227177072538e-28,  1.349495780468086e+00, -2.543408762538362e-03, -2.982582727655873e-06,  1.053236758148180e-08,  3.471511970117793e-11,
 -6.810249042607997e-14, -4.510488470166978e-16,  3.594921844653201e-19,  6.087853444497971e-21,  1.418606450439779e-24, -8.239474122093896e-26, -1.048891899247291e-28,
  1.417349207952357e+00, -2.437701964138032e-03, -3.680580028735289e-06,  8.136033097017160e-09,  4.200471892083864e-11, -2.089877588119999e-14, -5.054118398393172e-16,
 -4.918038936885960e-19,  5.845565294617336e-21,  1.553142246655935e-23, -5.896894449432018e-26, -3.166081278967780e-28,  1.484162792894165e+00, -2.302591356814208e-03,
 -4.280290276473307e-06,  5.104805228003553e-09,  4.560447594326520e-11,  3.444572570056925e-14, -4.605803622775235e-16, -1.341518207967737e-18,  3.452871838825057e-21,
  2.571128760422246e-23,  2.664501370013404e-27, -3.776135812408088e-28,  1.549442791419089e+00, -2.139137141965715e-03, -4.743408130208806e-06,  1.620365757869157e-09,
  4.450866255163801e-11,  8.888286604392165e-14, -3.085027999411367e-16, -1.904900628140534e-18, -6.167734387865454e-22,  2.553811296111278e-23,  7.523506344814238e-26,
 -1.915438526141293e-28,  1.612653105983574e+00, -1.949550753457037e-03, -5.034311648639801e-06, -2.049168254347403e-09,  3.827293595795119e-11,  1.313492237837488e-13,
 -7.221037352123919e-17, -1.926797245682019e-18, -4.903767401950585e-21,  1.263942600797262e-23,  1.133475510776788e-25,  1.649894029319406e-28,  1.673218286112875e+00,
 -1.737362565728740e-03, -5.124116252816473e-06, -5.563691948211763e-09,  2.728167911129503e-11,  1.512722080702484e-13,  1.917890728778466e-16, -1.313516996453032e-18,
 -7.418316878258565e-21, -7.932241107536857e-24,  8.321597479247183e-26,  4.360401973308634e-28,  1.730529127284224e+00, -1.507543978145720e-03, -4.995350721964964e-06,
 -8.544887296768053e-09,  1.290367995108948e-11,  1.419692201492351e-13,  4.051488382698430e-16, -2.353675011320844e-19, -6.678091802407832e-21, -2.465891016068747e-23,
 -3.194435041146110e-27,  3.743041903154584e-28,  1.783951390243852e+00, -1.266551138380619e-03, -4.646736421155123e-06, -1.063041076477987e-08, -2.572033617532670e-12,
  1.039433677974314e-13,  4.946295542206115e-16,  8.843506909236588e-19, -2.834565331218583e-21, -2.648751401081392e-23, -8.411915217404917e-26,  7.520808082894001e-30,
  1.832838044384490e+00, -1.022254117590358e-03, -4.097248722637926e-06, -1.154385997868572e-08, -1.630339177337545e-11,  4.651507462484065e-14,  4.265804488547302e-16,
  1.544233389320859e-18,  2.010555234480660e-21, -1.203615062103531e-23, -9.457829298278853e-26, -3.213782517905162e-28,  1.876545200658654e+00, -7.837177465081589e-04,
 -3.388392456706558e-06, -1.116820969201598e-08, -2.556508261134957e-11, -1.376412763151241e-14,  2.314707570671527e-16,  1.449550205566114e-18,  4.949795279928032e-21,
  7.386348245496562e-24, -3.111393724545898e-26, -2.957471456674312e-28,  1.914451527547726e+00, -5.608114712769078e-04, -2.583558989385004e-06, -9.602988691502636e-09,
 -2.858339628719056e-11, -5.844563369025260e-14, -1.341181034866667e-18,  7.295130116664522e-19,  4.391264302321124e-21,  1.656011447245532e-23,  3.865325396833102e-26,
 -5.728468660522725e-30,  1.945980453632421e+00, -3.636472242093520e-04, -1.763589367500184e-06, -7.182103281806784e-09, -2.525482284809036e-11, -7.479502770510419e-14,
 -1.657756112211526e-16, -1.134604209608410e-19,  1.420828249065881e-21,  1.062930314052264e-23,  4.921200295495419e-26,  1.707142727476132e-28,  1.970623921810891e+00,
 -2.018753334033573e-04, -1.018327101596143e-06, -4.434039337930444e-09, -1.740357466295241e-11, -6.215718700479996e-14, -1.997258974009295e-16, -5.539170513494998e-19,
 -1.158457200674488e-21, -5.817570595578352e-25,  1.141472955015511e-26,  8.523769306762407e-29,  1.987966097105545e+00, -8.390301028894113e-05, -4.349419285967474e-07,
 -1.981099344356636e-09, -8.335795602773548e-12, -3.305481256499795e-14, -1.245179125776181e-16, -4.461420307996235e-19, -1.513710600527562e-21, -4.806598867578406e-24,
 -1.392248949150572e-26, -3.455758002497268e-29,  1.997707420137959e+00, -1.611445644223111e-05, -8.481352648008485e-08, -3.959471398880685e-10, -1.728349939591178e-12,
 -7.219674070750084e-15, -2.921107412088163e-17, -1.152772563383292e-19, -4.455966057033567e-22, -1.691519729492219e-24, -6.315808046387007e-27, -2.321380827265897e-29,
  3.484735641139137e-04, -1.464039942035463e-06,  4.612443593488081e-09, -1.291501607676752e-11,  3.389365624989871e-14, -8.537304975923778e-17,  2.089876096715240e-19,
 -5.010233459331189e-22,  1.181698258696075e-24, -2.752172360524903e-27,  6.339949726850703e-30, -1.448537051814423e-32,  3.136004173138404e-03, -1.316446471011546e-05,
  4.139848401335111e-08, -1.155442961115178e-10,  3.017196862910263e-13, -7.545698211655476e-16,  1.829262266814674e-18, -4.330002894220041e-21,  1.004853370269943e-23,
 -2.293601366694648e-26,  5.154476242868169e-29, -1.143038379260086e-31,  8.709683630726548e-03, -3.650177536967878e-05,  1.143651787259708e-07, -3.171272890787662e-10,
  8.197559455438766e-13, -2.020255231428390e-15,  4.799447318522943e-18, -1.105784102124979e-20,  2.477099791535297e-23, -5.402369312607724e-26,  1.145079615034538e-28,
 -2.355805697704253e-31,  1.706671818813164e-02, -7.134841338351502e-05,  2.223017434302046e-07, -6.103561977761449e-10,  1.553290721397496e-12, -3.740968374345833e-15,
  8.602508997442817e-18, -1.894559451952851e-20,  3.988047171975200e-23, -7.976934589086875e-26,  1.493408487621091e-28, -2.546120905874577e-31,  2.820284111493712e-02,
 -1.175118379293987e-04,  3.633921015468557e-07, -9.843792052463405e-10,  2.451562002128618e-12, -5.714364212466662e-15,  1.252126366219662e-17, -2.567973365878163e-20,
  4.849844244605823e-23, -8.122791980528278e-26,  1.078011934094707e-28, -5.913727704735627e-32,  4.211221985418406e-02, -1.747330795560025e-04,  5.352153735523299e-07,
 -1.424936642902739e-09,  3.449339946261273e-12, -7.688904057882824e-15,  1.570593698140011e-17, -2.870252646526935e-20,  4.375951868793408e-23, -4.227806826824469e-26,
 -4.113708350033953e-29,  3.879583819937092e-31,  5.878732967085874e-02, -2.426848079018958e-04,  7.347471619088901e-07, -1.914549769248221e-09,  4.469061514758420e-12,
 -9.379212267274426e-15,  1.725997324018154e-17, -2.561327287988793e-20,  2.043775642639185e-23,  4.457420679487022e-26, -2.930509794508407e-28,  9.992847143154489e-31,
  7.821879153758474e-02, -3.209689116963978e-04,  9.583622074660420e-07, -2.432768402300260e-09,  5.423534921979986e-12, -1.048485661917827e-14,  1.634017490392421e-17,
 -1.460657393587123e-20, -2.344257953085242e-23,  1.732784447787892e-25, -5.965053229776488e-28,  1.549123574652048e-30,  1.003951713575780e-01, -4.091135908186931e-04,
  1.201839180210793e-06, -2.956485251335338e-09,  6.219231222623204e-12, -1.071219177828196e-14,  1.226596801237917e-17,  5.094469536845860e-21, -8.526594188327680e-23,
  3.214453727246080e-25, -8.530992703326775e-28,  1.710872854889108e-30,  1.253027369271107e-01, -5.065699633021802e-04,  1.460368584170372e-06, -3.460326381319219e-09,
  6.760176228697094e-12, -9.798747142081117e-15,  4.631138762464754e-18,  3.285984691992832e-20, -1.570264360508339e-22,  4.508190568731354e-25, -9.325934889795808e-28,
  1.150421603730057e-30,  1.529251682764974e-01, -6.127081953788590e-04,  1.728565010139780e-06, -3.917128764449033e-09,  6.952446649160328e-12, -7.539433131614599e-15,
 -6.590215114811758e-18,  6.638491908959887e-20, -2.253370275340058e-22,  5.118667183916947e-25, -7.039632734977728e-28, -3.358339113653060e-31,  1.832432161886336e-01,
 -7.268131706565701e-04,  2.000485268000751e-06, -4.298517240245274e-09,  6.709258105614862e-12, -3.813575011058103e-15, -2.095347488124676e-17,  1.015929165613167e-19,
 -2.724742189598206e-22,  4.528117523609859e-25, -7.950294421251666e-29, -2.668433521982579e-30,  2.162343027665502e-01, -8.480797261943537e-04,  2.269654279968846e-06,
 -4.575594282023936e-09,  5.956607313917788e-12,  1.388546358398204e-15, -3.748067890345827e-17,  1.327666452979084e-19, -2.786034962981805e-22,  2.326598953985644e-25,
  9.354188142447806e-28, -5.365881689203231e-30,  2.518720568966353e-01, -9.756074997153782e-04,  2.529101023813954e-06, -4.719756549466202e-09,  4.639393579988991e-12,
  7.941365089848101e-15, -5.463822149870657e-17,  1.529615799815335e-19, -2.251963664377831e-22, -1.632424771637421e-25,  2.199077787286128e-27, -7.519230922196310e-30,
  2.901257763247597e-01, -1.108395454904204e-03,  2.771407286072185e-06, -4.703651999967442e-09,  2.727892722546680e-12,  1.556409251209542e-14, -7.036919228925907e-17,
  1.547367982973093e-19, -9.945526196199215e-23, -7.077574686201942e-25,  3.412621451352755e-27, -7.918940431561306e-30,  3.309598068251252e-01, -1.245336182482198e-03,
  2.988772521563565e-06, -4.502289921544363e-09,  2.243861191930347e-13,  2.380786276679909e-14, -8.219452062449058e-17,  1.312125296155394e-19,  1.006936225368504e-22,
 -1.320449649341639e-24,  4.139459474548500e-27, -5.370907031293252e-30,  3.743328275993084e-01, -1.385210115802922e-03,  3.173098713774012e-06, -4.094313069015609e-09,
 -2.830344841268790e-12,  3.205318046354002e-14, -8.739557814794332e-17,  7.742035228854752e-20,  3.617875513145355e-22, -1.864821801476333e-24,  3.879925627979221e-27,
  8.098461594762331e-31,  4.201970306088399e-01, -1.526679853858008e-03,  3.316099778472361e-06, -3.463435370853018e-09, -6.351066286557534e-12,  3.952137046749066e-14,
 -8.328701562716656e-17, -8.148219072297504e-21,  6.512734853328076e-22, -2.159419417844934e-24,  2.207568040489632e-27,  1.021540538143023e-29,  4.684971800471717e-01,
 -1.668284855250735e-03,  3.409440723696103e-06, -2.600039430150725e-09, -1.020323370583644e-11,  4.530406448016288e-14, -6.758137049294934e-17, -1.219675549811105e-19,
  9.165885788829117e-22, -2.007106937713676e-24, -1.043156270683519e-27,  2.085356217959370e-29,  5.191695366470251e-01, -1.808436857972158e-03,  3.444912424594288e-06,
 -1.502914005256197e-09, -1.419995202181008e-11,  4.841479140952824e-14, -3.883525872707307e-17, -2.541447252316171e-19,  1.088415372084342e-21, -1.244230265823218e-24,
 -5.572610910315000e-27,  2.902020600032559e-29,  5.721406300806242e-01, -1.945416496478591e-03,  3.414648410975001e-06, -1.810912796372478e-10, -1.810167036618621e-11,
  4.786624348021607e-14,  3.050315237635913e-18, -3.876934777515071e-19,  1.089543889812719e-21,  1.935303943094171e-25, -1.045981629958390e-26,  2.984515028059613e-29,
  6.273258614735939e-01, -2.077371734984607e-03,  3.311390371703937e-06,  1.344284771017230e-09, -2.161972759384990e-11,  4.277546048955972e-14,  5.632652069445679e-17,
 -4.988674855667072e-19,  8.502056467831206e-22,  2.199274034786711e-24, -1.414653741700620e-26,  1.874436257364401e-29,  6.846279172141942e-01, -2.202318919736448e-03,
  3.128808961117099e-06,  3.038166136264594e-09, -2.442504394863102e-11,  3.249662001415311e-14,  1.169705945637564e-16, -5.590438143581342e-19,  3.295138558590058e-22,
  4.437067007386658e-24, -1.466465798589147e-26, -6.249008054669006e-30,  7.439349750841245e-01, -2.318147478748843e-03,  2.861885667616474e-06,  4.850042161466639e-09,
 -2.616336680637779e-11,  1.677689119022902e-14,  1.784507190342872e-16, -5.385889044736738e-19, -4.594105624611567e-22,  6.327778534430683e-24, -1.018342202916834e-26,
 -4.178484461353786e-29,  8.051186846736993e-01, -2.422629569203701e-03,  2.507359577238283e-06,  6.712835127114747e-09, -2.647845029304387e-11, -4.075535286884982e-15,
  2.318269724933075e-16, -4.129164049854381e-19, -1.425921003280247e-21,  7.113541984037620e-24,  1.340469209578151e-28, -7.728469404009015e-29,  8.680319066430975e-01,
 -2.513436291458901e-03,  2.064239295392746e-06,  8.542545705108648e-09, -2.504427129359030e-11, -2.903086332316650e-14,  2.663527642158744e-16, -1.704849530003410e-19,
 -2.388555522612998e-21,  6.030669378014458e-24,  1.513807257095884e-26, -9.555206285333027e-29,  9.325062004324373e-01, -2.588162449461273e-03,  1.534374373748292e-06,
  1.023902731590644e-08, -2.160670989163252e-11, -5.621513564143099e-14,  2.707315891375088e-16,  1.782717521654761e-19, -3.083395244791184e-21,  2.596983882137058e-24,
  3.095917020845433e-26, -7.766707065434121e-29,  9.983490585479899e-01, -2.644362224961446e-03,  9.230714573274316e-07,  1.168835058151606e-08, -1.603386693519685e-11,
 -8.286842290880727e-14,  2.351218101666951e-16,  5.931294916912169e-19, -3.205937402822160e-21, -3.029797544277335e-24,  4.113694234740290e-26, -1.275355076500541e-29,
  1.065340898912917e+00, -2.679598515079810e-03,  2.397270324820168e-07,  1.276728209968805e-08, -8.372158677336713e-12, -1.054372321298193e-13,  1.538394271179509e-16,
  1.000584868739621e-18, -2.493771259860595e-21, -9.739573183453350e-24,  3.824621210368187e-26,  8.968510422506563e-29,  1.133231846666721e+00, -2.691509001426070e-03,
 -5.015698493661997e-07,  1.335041527255881e-08,  1.097633722514509e-12, -1.198592127478010e-13,  2.846135245614191e-17,  1.298791979962919e-18, -8.448322021458155e-22,
 -1.539853922310339e-23,  1.728326621696978e-26,  1.914265305141444e-28,  1.201738365262745e+00, -2.677892178674153e-03, -1.281535838566982e-06,  1.332040840816181e-08,
  1.181406863331634e-11, -1.220891483255937e-13, -1.293224611845571e-16,  1.374897203574339e-18,  1.555849343563237e-21, -1.724925386767432e-23, -1.989414689892056e-26,
  2.312048283447328e-28,  1.270539836023834e+00, -2.636816424936753e-03, -2.075393526950208e-06,  1.258154240972416e-08,  2.291267303804739e-11, -1.088823841739539e-13,
 -2.961704309687225e-16,  1.136585153485917e-18,  4.155892767181571e-21, -1.292681398675731e-23, -6.125164249756340e-26,  1.526110348539841e-28,  1.339275237743564e+00,
 -2.566754535521610e-03, -2.852908507755407e-06,  1.107632874933235e-08,  3.324574738420364e-11, -7.878483546176587e-14, -4.382526126932156e-16,  5.544764374366893e-19,
  6.078630328007647e-21, -1.953639527215259e-24, -8.581487442928745e-26, -4.963464557797058e-29,  1.407540145236371e+00, -2.466744685565378e-03, -3.578931118469609e-06,
  8.804101443337754e-09,  4.146444052327013e-11, -3.317226888817998e-14, -5.164828812244147e-16, -2.962818223735395e-19,  6.358939177108022e-21,  1.290057060770093e-23,
 -7.238785695318096e-26, -2.910991945573671e-28,  1.474884348363838e+00, -2.336576195564582e-03, -4.214633829690117e-06,  5.839375026745937e-09,  4.617987676365530e-11,
  2.295438765117078e-14, -4.964568808991280e-16, -1.216229202435019e-18,  4.376292042884155e-21,  2.547470463009412e-23, -1.474168553214469e-26, -4.116220642070649e-28,
  1.540810488734986e+00, -2.176994390696631e-03, -4.719633599556376e-06,  2.346305165912175e-09,  4.620795103873638e-11,  8.083739181228439e-14, -3.619740813164014e-16,
 -1.909364523182403e-18,  3.545193387701950e-22,  2.835504697884360e-23,  6.501614898280833e-26, -2.732468287056974e-28,  1.604774213205729e+00, -1.989912997537074e-03,
 -5.055141131244371e-06, -1.415898221976931e-09,  4.087813022536355e-11,  1.289514909755340e-13, -1.282828642152865e-16, -2.075549372771103e-18, -4.365560424804400e-21,
  1.729937467244556e-23,  1.191459178081418e-25,  9.580031673744379e-29,  1.666186437930610e+00, -1.778614900853528e-03, -5.188160900561837e-06, -5.102744426622843e-09,
  3.035003392710834e-11,  1.554067395183426e-13,  1.516490604016806e-16, -1.554791932414936e-18, -7.639306096943391e-21, -4.216579429787516e-24,  1.026195463600526e-25,
  4.431775306261787e-28,  1.724418381592483e+00, -1.547913209498028e-03, -5.096555212408038e-06, -8.315187713897047e-09,  1.583963798026920e-11,  1.515887404957254e-13,
  3.954333268752371e-16, -4.632609874914436e-19, -7.563925652926975e-21, -2.443335430217410e-23,  1.506777305548596e-26,  4.560134924182657e-28,  1.778810029222343e+00,
 -1.304235826834284e-03, -4.774477551087051e-06, -1.065427914377236e-08, -3.725062568720228e-13,  1.161004648829643e-13,  5.179735177213448e-16,  7.777402707018357e-19,
 -3.848413159477176e-21, -2.982469037322580e-23, -8.218937818310918e-26,  8.309371140617771e-29,  1.828682588438564e+00, -1.055590572782598e-03, -4.237307625695579e-06,
 -1.179670074770304e-08, -1.526717287483109e-11,  5.727871082096187e-14,  4.706492062291545e-16,  1.600880364553004e-18,  1.505725210697106e-21, -1.610461001176787e-23,
 -1.088864046287846e-25, -3.270450797395337e-28,  1.873355256767357e+00, -8.113679328201220e-04, -3.524873289045633e-06, -1.157913731156241e-08, -2.578143109138019e-11,
 -7.703645671518254e-15,  2.743137807655739e-16,  1.611931452208536e-18,  5.189999893299913e-21,  5.863231528610168e-24, -4.550664651557898e-26, -3.595429450853315e-28,
  1.912166203798528e+00, -5.819487501460310e-04, -2.701577419830584e-06, -1.006966884458705e-08, -2.975089186864159e-11, -5.821626534966874e-14,  2.114421491260338e-17,
  8.798694428164218e-19,  5.015111571976373e-21,  1.809156043387874e-23,  3.766126560145394e-26, -4.115744029317265e-29,  1.944497091616338e+00, -3.781076645165590e-04,
 -1.852249137548412e-06, -7.598364806251520e-09, -2.679073877363346e-11, -7.880625983466659e-14, -1.682556507342980e-16, -6.147648256920341e-20,  1.840778832197591e-21,
  1.275381012277869e-23,  5.715703020060929e-26,  1.904280624346666e-28,  1.969799783446962e+00, -2.102396140741446e-04, -1.073248198794955e-06, -4.722707473898995e-09,
 -1.869593062158466e-11, -6.714092966546117e-14, -2.157570395568002e-16, -5.912269439428757e-19, -1.170220977259223e-21, -4.383275826296046e-26,  1.564632713444005e-26,
  1.078843615876773e-28,  1.987623372161439e+00, -8.747995714237269e-05, -4.595377110935006e-07, -2.119927563203431e-09, -9.027816984156761e-12, -3.619878357071940e-14,
 -1.377148288648383e-16, -4.974598760863233e-19, -1.697146293105361e-21, -5.394729567701106e-24, -1.550402162745317e-26, -3.729731675473253e-29,  1.997641574525311e+00,
 -1.681245145491955e-05, -8.973570519539009e-08, -4.247951051798170e-10, -1.880024100202029e-12, -7.961142345847726e-15, -3.264797863539819e-17, -1.305614924011615e-19,
 -5.112960897400709e-22, -1.965825143215769e-24, -7.431722163169006e-27, -2.764562038543586e-29,  3.426902347483240e-04, -1.427751223004608e-06,  4.460661715267603e-09,
 -1.238610943890878e-11,  3.223523766145290e-14, -8.052150777920018e-17,  1.954738039126609e-19, -4.647465280014101e-22,  1.087035336146012e-24, -2.510871351990372e-27,
  5.735924330136605e-30, -1.299894472068941e-32,  3.084000023043129e-03, -1.283874202811798e-05,  4.004042714953927e-08, -1.108351675217951e-10,  2.870576769656680e-13,
 -7.120868211931188e-16,  1.712402580235839e-18, -4.021272664336341e-21,  9.258768766091651e-24, -2.097137982246426e-26,  4.676951774045699e-29, -1.029621396034397e-31,
  8.565482581221761e-03, -3.560185610677281e-05,  1.106370344484038e-07, -3.043282799896415e-10,  7.804780844964656e-13, -1.908696124372367e-15,  4.500638987764790e-18,
 -1.029542262071239e-20,  2.290615144900119e-23, -4.964425253618226e-26,  1.046194350723139e-28, -2.142453730344225e-31,  1.678483556447890e-02, -6.959887965276692e-05,
  2.151241517773753e-07, -5.860910613031248e-10,  1.480493721636315e-12, -3.540732283145198e-15,  8.089475184835372e-18, -1.771423526308385e-20,  3.711364728715648e-23,
 -7.401467397418556e-26,  1.385173413573792e-28, -2.375059766719159e-31,  2.773853415410506e-02, -1.146512930749656e-04,  3.518111817850806e-07, -9.460524251087236e-10,
  2.340222474503301e-12, -5.422309577057272e-15,  1.182352471922158e-17, -2.417374387774585e-20,  4.565119224918409e-23, -7.697169039321356e-26,  1.049230881363669e-28,
 -7.111870131173112e-32,  4.142174399605597e-02, -1.705188268613964e-04,  5.184422613977411e-07, -1.370957218289344e-09,  3.299267004420459e-12, -7.321448801689123e-15,
  1.492163961918217e-17, -2.732685941223542e-20,  4.221182344334179e-23, -4.360177789824486e-26, -2.551666555488974e-29,  3.236442795897746e-31,  5.782820258556564e-02,
 -2.368975275221979e-04,  7.121954765463469e-07, -1.844523194460293e-09,  4.285561960032559e-12, -8.973503662350033e-15,  1.655218330771711e-17, -2.493576849619030e-20,
  2.184169197764689e-23,  3.369488187003198e-26, -2.517968801469332e-28,  8.782166057747055e-31,  7.695006685751932e-02, -3.134173275177255e-04,  9.296827946230194e-07,
 -2.347648253527012e-09,  5.217725889638926e-12, -1.009767939614853e-14,  1.592159426840954e-17, -1.526140246960814e-20, -1.761801849529876e-23,  1.507370319053645e-25,
 -5.316436443936561e-28,  1.401064878960114e-30,  9.877772409515619e-02, -3.996391132165738e-04,  1.166951385276474e-06, -2.858675464548662e-09,  6.007941224715577e-12,
 -1.041639466515808e-14,  1.237210756891903e-17,  2.544671390911404e-21, -7.429028073832171e-23,  2.887958751428317e-25, -7.801480740579442e-28,  1.604848862956297e-30,
  1.232995625627659e-01, -4.950512863805348e-04,  1.419487197731886e-06, -3.353725019398080e-09,  6.565384413487551e-12, -9.677111969702871e-15,  5.483255712639915e-18,
  2.808757283745430e-20, -1.414561130187217e-22,  4.145388731578947e-25, -8.811855227800528e-28,  1.182111450724483e-30,  1.505016974879220e-01, -5.990658179256376e-04,
  1.682221897673762e-06, -3.807103903462989e-09,  6.800222756341999e-12, -7.676090948437795e-15, -4.829657035513728e-18,  5.946351079888637e-20, -2.074195056137715e-22,
  4.834925824351597e-25, -7.128627544305657e-28, -7.748349969988074e-32,  1.803676471514799e-01, -7.110137983913126e-04,  1.949544547029345e-06, -4.191805656257329e-09,
  6.628183155978132e-12, -4.283293420142231e-15, -1.822849670946306e-17,  9.313372723080354e-20, -2.562570909968328e-22,  4.474408805869542e-25, -1.852727948493051e-28,
 -2.151010224414345e-30,  2.128779528748143e-01, -8.301404984836948e-04,  2.215319744419019e-06, -4.480114026474005e-09,  5.975678820103788e-12,  5.326202134745480e-16,
 -3.388671917300098e-17,  1.239921178172633e-19, -2.696092148314872e-22,  2.655650687046937e-25,  7.149376791751782e-28, -4.665963398240921e-30,  2.480097356095244e-01,
 -9.555999663090375e-04,  2.472914341456579e-06, -4.644325440532678e-09,  4.785450396136832e-12,  6.680623715750399e-15, -5.045695135289672e-17,  1.456776100714767e-19,
 -2.295677083159751e-22, -8.170029172968225e-26,  1.882871578306667e-27, -6.854894537505036e-30,  2.857361806221271e-01, -1.086449206856266e-03,  2.715235318844329e-06,
 -4.657605756699737e-09,  3.022634954549791e-12,  1.392684121342623e-14, -6.608476437265351e-17,  1.511722299819508e-19, -1.225607282026706e-22, -5.781444157286889e-25,
  3.070100723392802e-27, -7.635218470055708e-30,  3.260259404145130e-01, -1.221642015695073e-03,  2.934781952999911e-06, -4.494996412106862e-09,  6.811159790929113e-13,
  2.187960299736011e-14, -7.848238021556952e-17,  1.337056311796419e-19,  5.607942843192299e-23, -1.159755482878324e-24,  3.891723599168507e-27, -5.855459182752922e-30,
  3.688424445241779e-01, -1.360022574989668e-03,  3.123716031850051e-06, -4.134583281641334e-09, -2.210074079635420e-12,  2.998294709079740e-14, -8.507560606246921e-17,
  8.795341076089881e-20,  2.974517842754536e-22, -1.709381939851754e-24,  3.880973292962248e-27, -7.137673921576014e-31,  4.141431032082776e-01, -1.500318968651401e-03,
  3.273954583846817e-06, -3.558837654547079e-09, -5.580634372648503e-12,  3.752202809505312e-14, -8.323495564642295e-17,  1.146658270733249e-20,  5.752252194445640e-22,
 -2.062885449758235e-24,  2.600859880164032e-27,  7.706998658500061e-30,  4.618783902467709e-01, -1.641136838349278e-03,  3.377290352286436e-06, -2.756131747593450e-09,
 -9.313631722582224e-12,  4.364437786531233e-14, -7.059674008808550e-17, -9.379912452552037e-20,  8.437948766478167e-22, -2.031349748202930e-24, -1.903020664249104e-28,
  1.792758130212332e-29,  5.119907882362785e-01, -1.780953487584862e-03,  3.425546044417773e-06, -1.722419861351505e-09, -1.324153289667927e-11,  4.740124541738350e-14,
 -4.547072715420489e-17, -2.200726701674618e-19,  1.039912841953173e-21, -1.442226031958114e-24, -4.343252376540261e-27,  2.681488334327193e-29,  5.644135778512412e-01,
 -1.918112852462056e-03,  3.410769149955500e-06, -4.630590488342590e-10, -1.714447233132723e-11,  4.781312944239848e-14, -7.316499896964661e-18, -3.527947762559461e-19,
  1.089297047022211e-21, -1.985373917130275e-25, -9.143387208400275e-27,  2.987267828640547e-29,  6.190694507295647e-01, -2.050821901435325e-03,  3.325474751992857e-06,
  1.005281959968345e-09, -2.075181526555306e-11,  4.396282114803343e-14,  4.275025676227881e-17, -4.705016513567142e-19,  9.194032870401313e-22,  1.651047371417890e-24,
 -1.323851679694155e-26,  2.235354269167656e-29,  6.758689240663752e-01, -2.177149209325416e-03,  3.162944077900008e-06,  2.652712123134178e-09, -2.374829974752638e-11,
  3.511741062044755e-14,  1.014881938005138e-16, -5.460572308518331e-19,  4.786444370394753e-22,  3.847272564053369e-24, -1.477015217255256e-26,  1.289118449777794e-30,
  7.347085339317766e-01, -2.295026680832791e-03,  2.917586302788788e-06,  4.434340140306222e-09, -2.578623003241476e-11,  2.087728893728947e-14,  1.631980792575138e-16,
 -5.497272778276951e-19, -2.393588695159450e-22,  5.886612753643089e-24, -1.180252843304875e-26, -3.185722140639217e-29,  7.954687841521475e-01, -2.402255682888831e-03,
  2.585369945961890e-06,  6.288826118452827e-09, -2.650528466367049e-11,  1.344652510317418e-15,  2.196649685862902e-16, -4.544539507353840e-19, -1.170534690495675e-21,
  7.053305317826056e-24, -3.084185335326599e-27, -6.882063339273382e-29,  8.580118288671157e-01, -2.496519188822757e-03,  2.164327553711113e-06,  8.137537974485887e-09,
 -2.556139432801438e-11, -2.270411236398683e-14,  2.605425362618622e-16, -2.433364101727843e-19, -2.161563249166354e-21,  6.552363579914575e-24,  1.095775428087253e-26,
 -9.403111076268319e-29,  9.221788703839150e-01, -2.575401941330966e-03,  1.655132503127183e-06,  9.884680067672514e-09, -2.266568992806867e-11, -4.966873298879733e-14,
  2.743575562941419e-16,  8.133108759834173e-20, -2.968466934751475e-21,  3.763742099880699e-24,  2.730408281851247e-26, -8.791664744376750e-29,  9.877872607855748e-01,
 -2.636421097627589e-03,  1.061738727999068e-06,  1.141886179857577e-08, -1.763352124023700e-11, -7.703789008909054e-14,  2.502790345114008e-16,  4.891104003906358e-19,
 -3.285589039787731e-21, -1.402352986352873e-24,  4.007072636972544e-26, -3.533673339017253e-29,  1.054627307374050e+00, -2.677070305420976e-03,  3.920617773176097e-07,
  1.261666756961206e-08, -1.044176047030410e-11, -1.014182200786575e-13,  1.806880307524682e-16,  9.154766903026019e-19, -2.815981250096235e-21, -8.138909024747407e-24,
  4.158414391430328e-26,  6.185162577685830e-29,  1.122458800356659e+00, -2.694880623615282e-03, -3.413384464801393e-07,  1.334884935471150e-08, -1.289792090789636e-12,
 -1.187433081408008e-13,  6.436675147105340e-17,  1.263037406457101e-18, -1.384749800206319e-21, -1.454367039562236e-23,  2.532816488430537e-26,  1.733157794240037e-28,
  1.191007308616305e+00, -2.687502058958185e-03, -1.120637876184866e-06,  1.348974378891395e-08,  9.344393165455514e-12, -1.247258747560562e-13, -9.022265067280213e-17,
  1.414615326597820e-18,  9.230336507176852e-22, -1.783843207372279e-23, -9.502204202696444e-27,  2.397893172240934e-28,  1.259960328802052e+00, -2.652809594825204e-03,
 -1.922288484615970e-06,  1.293034887560939e-08,  2.066659800640994e-11, -1.155940007613403e-13, -2.625574580422699e-16,  1.261668920910365e-18,  3.648161598111561e-21,
 -1.522980255134841e-23, -5.359111034426060e-26,  1.946870848152278e-28,  1.328963427470177e+00, -2.589037220398414e-03, -2.716854804812260e-06,  1.159508932540033e-08,
  3.156624083561120e-11, -8.909470251435773e-14, -4.200193620766443e-16,  7.472015822420232e-19,  5.946143778267379e-21, -5.412561281395280e-24, -8.669536562381873e-26,
  1.016760933663314e-29,  1.397616588558265e+00, -2.494942314125828e-03, -3.469325396879912e-06,  9.461549033389692e-09,  4.067648786895724e-11, -4.564400627008945e-14,
 -5.218642759697538e-16, -8.594831705205738e-20,  6.768247617480650e-21,  9.759398013083783e-24, -8.438685849022621e-26, -2.521299354777454e-28,  1.465471071006513e+00,
 -2.370000384645943e-03, -4.140115039265472e-06,  6.581267094223234e-09,  4.651714181981586e-11,  1.064743660573889e-14, -5.284138694262752e-16, -1.061664107248433e-18,
  5.278335516119345e-21,  2.451564781146701e-23, -3.336258565368917e-26, -4.323729317701160e-28,  1.532027193255677e+00, -2.214626148566352e-03, -4.686990200149795e-06,
  3.098076209183875e-09,  4.773350534787035e-11,  7.151070986105999e-14, -4.151205706223125e-16, -1.881210436938836e-18,  1.418995035548872e-21,  3.069108239592898e-23,
  5.119105076588329e-26, -3.548143393832558e-28,  1.596733587303346e+00, -2.030410776030034e-03, -5.068123097945368e-06, -7.414032162120521e-10,  4.342158579015016e-11,
  1.251601402884329e-13, -1.882537948948096e-16, -2.204356231845069e-18, -3.656198883573299e-21,  2.212546865390695e-23,  1.215348422416730e-25,  1.015622418176332e-29,
  1.658988591911585e+00, -1.820356627153767e-03, -5.246377063053564e-06, -4.592096355204014e-09,  3.349089497151304e-11,  1.584961721544082e-13,  1.046755257379521e-16,
 -1.800848199483470e-18, -7.712532276277719e-21,  2.762854488078797e-25,  1.219400299767976e-25,  4.316310310015715e-28,  1.718144558307222e+00, -1.589080238084962e-03,
 -5.194715154107131e-06, -8.036988575358428e-09,  1.896512132751144e-11,  1.608953258999045e-13,  3.789422109494992e-16, -7.192232093782720e-19, -8.427622912856996e-21,
 -2.340531575302816e-23,  3.692450629605762e-26,  5.369927034145694e-28,  1.773515884644168e+00, -1.342942973066907e-03, -4.902285827586304e-06, -1.064098059123536e-08,
  2.075504388931129e-12,  1.287782196091772e-13,  5.378602702507103e-16,  6.367862209097902e-19, -4.980160897868629e-21, -3.301292815467097e-23, -7.654093301250181e-26,
  1.766796750917522e-28,  1.824391526933473e+00, -1.090059336968057e-03, -4.380293849430280e-06, -1.203118186222767e-08, -1.400498629821531e-11,  6.911706582193840e-14,
  5.160551072892958e-16,  1.638918620416977e-18,  8.441025780630575e-22, -2.074660347567391e-23, -1.231540361553630e-25, -3.188404873225558e-28,  1.870052497136531e+00,
 -8.401297395806881e-04, -3.666301837126341e-06, -1.199249940156556e-08, -2.586591506682076e-11, -5.595572394897358e-16,  3.218020234027612e-16,  1.781005217313869e-18,
  5.364316162933777e-21,  3.706426046971977e-24, -6.284178204893265e-26, -4.292857385691003e-28,  1.909794406723664e+00, -6.040528941184553e-04, -2.825307841317390e-06,
 -1.055496143445655e-08, -3.090805070648812e-11, -5.739442132467571e-14,  4.812728946151656e-17,  1.051060193188421e-18,  5.692970511576191e-21,  1.954877027061968e-23,
  3.485356545290577e-26, -8.865682101381980e-29,  1.942954437048976e+00, -3.932977874219695e-04, -1.946054150287728e-06, -8.039845493482900e-09, -2.840734849563368e-11,
 -8.285795486346901e-14, -1.690800571686898e-16,  5.232620278851435e-21,  2.343140670554665e-21,  1.521340139717879e-23,  6.596274339314976e-26,  2.096581908872792e-28,
  1.968941286777592e+00, -2.190574788267401e-04, -1.131760737754942e-06, -5.032871964355204e-09, -2.009189366588050e-11, -7.252197928828911e-14, -2.328349730150908e-16,
 -6.285687302262308e-19, -1.159319459634807e-21,  6.847389070719663e-25,  2.098476175273820e-26,  1.357045015613794e-28,  1.987265935074274e+00, -9.126052713321370e-05,
 -4.858679983978291e-07, -2.270348869026467e-09, -9.786004947109198e-12, -3.967740667267421e-14, -1.524340953669243e-16, -5.549988678908062e-19, -1.902921797557174e-21,
 -6.048458265857146e-24, -1.720015909062526e-26, -3.972951546912973e-29,  1.997572855925540e+00, -1.755125101192553e-05, -9.501912450828508e-08, -4.561931235888693e-10,
 -2.047388415710466e-12, -8.790478844161901e-15, -3.654382337218530e-17, -1.481151232080805e-19, -5.877233272401094e-22, -2.288922787561123e-24, -8.762064432068661e-27,
 -3.299036863166785e-29,  3.370496713184583e-04, -1.392651815309211e-06,  4.315070654381358e-09, -1.188297853445299e-11,  3.067068713945205e-14, -7.598244256464519e-17,
  1.829346134682856e-19, -4.313644723511787e-22,  1.000639660176118e-24, -2.292472818540004e-27,  5.193637554532044e-30, -1.167573130733618e-32,  3.033277387113489e-03,
 -1.252366168732672e-05,  3.873749982898235e-08, -1.063539832977568e-10,  2.732179670286099e-13, -6.723075120740144e-16,  1.603843900716609e-18, -3.736719194027341e-21,
  8.536409416469917e-24, -1.918813794148898e-26,  4.246644183737194e-29, -9.281830971562255e-32,  8.424822516322568e-03, -3.473115816215542e-05,  1.070587799916339e-07,
 -2.921402497274669e-10,  7.433613865138639e-13, -1.804058844963593e-15,  4.222366088728109e-18, -9.590231289039400e-21,  2.119206580927959e-23, -4.564218294329650e-26,
  9.562480454615049e-29, -1.949160437982634e-31,  1.650983805087489e-02, -6.790562142940477e-05,  2.082308832706128e-07, -5.629592965028191e-10,  1.411581057402043e-12,
 -3.352405083101918e-15,  7.609710451073915e-18, -1.656818179782795e-20,  3.454637720949063e-23, -6.867814226354444e-26,  1.284275129507296e-28, -2.212680205038099e-31,
  2.728548694863337e-02, -1.118815857394493e-04,  3.406796846378467e-07, -9.094612443694308e-10,  2.234559945213090e-12, -5.146504818609174e-15,  1.116670079264691e-17,
 -2.275643770637058e-20,  4.295497589314282e-23, -7.284016355243285e-26,  1.015888531845819e-28, -7.996970345176875e-32,  4.074786082444819e-02, -1.664362083195337e-04,
  5.023027345792337e-07, -1.319321177633031e-09,  3.156358027254555e-12, -6.972360094379342e-15,  1.417516123156625e-17, -2.600136584405313e-20,  4.062706439478545e-23,
 -4.435453638404474e-26, -1.252421294987910e-29,  2.683002045836313e-31,  5.689186904718692e-02, -2.312873486509763e-04,  6.904667589198130e-07, -1.777368615592611e-09,
  4.110008269143052e-12, -8.584549648457810e-15,  1.586393579368946e-17, -2.421929636100028e-20,  2.288242782172855e-23,  2.436320774189448e-26, -2.155712951373614e-28,
  7.704880614582496e-31,  7.571109603443514e-02, -3.060911482697793e-04,  9.020053196509119e-07, -2.265759652609160e-09,  5.019558562986557e-12, -9.720747801372700e-15,
  1.548716934035950e-17, -1.574234070927759e-20, -1.255978675670757e-23,  1.306632128461911e-25, -4.730417215904683e-28,  1.264525019729028e-30,  9.719762389142615e-02,
 -3.904391001246496e-04,  1.133217219553588e-06, -2.764198875358185e-09,  5.802587060198887e-12, -1.011886831300768e-14,  1.241159713676898e-17,  3.278423299904694e-22,
 -6.443860370323861e-23,  2.589708478671214e-25, -7.118789860812297e-28,  1.498373232581203e-30,  1.213418168310808e-01, -4.838545964765156e-04,  1.379866411379017e-06,
 -3.250219798166632e-09,  6.373219272184895e-12, -9.536574364899569e-15,  6.208530988029641e-18,  2.379305087133638e-20, -1.271545920640012e-22,  3.803358035764723e-25,
 -8.289040467755148e-28,  1.190960243045363e-30,  1.481320630225400e-01, -5.857889457768426e-04,  1.637184387111045e-06, -3.699534258983267e-09,  6.645672874202482e-12,
 -7.772757120544306e-15, -3.255025264924236e-18,  5.309907232125872e-20, -1.905272595084072e-22,  4.549746712196853e-25, -7.115136513505175e-28,  1.312054671528845e-31,
  1.775544686298866e-01, -6.956168524814627e-04,  1.899876283149281e-06, -4.086462952516516e-09,  6.538348949684269e-12, -4.690396206354101e-15, -1.573314520248631e-17,
  8.518961912798487e-20, -2.403041690460600e-22,  4.382740873644844e-25, -2.697941583749376e-28, -1.701569551410937e-30,  2.095924978034976e-01, -8.126313600886904e-04,
  2.162132252843210e-06, -4.384460971419735e-09,  5.978474625611312e-12, -2.399655806548773e-16, -3.053425048273814e-17,  1.155227177800073e-19, -2.595818339196640e-22,
  2.902490953243014e-25,  5.239200119909471e-28, -4.026635219935027e-30,  2.442265512554888e-01, -9.360382678221214e-04,  2.417646039243054e-06, -4.566753758378258e-09,
  4.907279299099192e-12,  5.517772231046890e-15, -4.648116649300456e-17,  1.382983414268269e-19, -2.312241802285880e-22, -1.222463805638715e-26,  1.595658356099584e-27,
 -6.203256081434988e-30,  2.814334747696707e-01, -1.064950046609085e-03,  2.659643139205302e-06, -4.607100046417314e-09,  3.285651924997001e-12,  1.239113915797880e-14,
 -6.190981285530798e-17,  1.469403255432377e-19, -1.412435018222835e-22, -4.619577187181389e-25,  2.741872230390899e-27, -7.273370441090433e-30,  3.211859875478189e-01,
 -1.198379302036882e-03,  2.880921495702701e-06, -4.480698884943296e-09,  1.100176400337226e-12,  2.004111623092225e-14, -7.471956430430721e-17,  1.348616877168293e-19,
  1.706725633160576e-23, -1.009338313388066e-24,  3.627006824198879e-27, -6.148139272345561e-30,  3.634520186629140e-01, -1.335231863014984e-03,  3.073908297077290e-06,
 -4.165257278021480e-09, -1.630628483554450e-12,  2.797170468530758e-14, -8.248869019958459e-17,  9.651714010743940e-20,  2.386972238386894e-22, -1.555156340060344e-24,
  3.821260671911572e-27, -1.956207834418334e-30,  4.081939380666949e-01, -1.474299617791587e-03,  3.230737204433019e-06, -3.642232672684307e-09, -4.850133732607674e-12,
  3.553025405942409e-14, -8.266720797676696e-17,  2.870626875150128e-20,  5.029094898651369e-22, -1.952745595530924e-24,  2.889889305056204e-27,  5.476749681198681e-30,
  4.553676665832677e-01, -1.614253277425554e-03,  3.343351167449060e-06, -2.898259651784711e-09, -8.457884637281012e-12,  4.192152317356294e-14, -7.285609091995204e-17,
 -6.796772240842474e-20,  7.707117364029671e-22, -2.024022253070383e-24,  5.362225145162718e-28,  1.511992555288421e-29,  5.049216471284862e-01, -1.753635325425276e-03,
  3.403636906114062e-06, -1.926761510324761e-09, -1.230490086153619e-11,  4.623971475673867e-14, -5.117491218364561e-17, -1.876574452389488e-19,  9.851435477153691e-22,
 -1.593060156546541e-24, -3.216121290398645e-27,  2.439069350431532e-29,  5.567956570675466e-01, -1.890853516795646e-03,  3.403598088779680e-06, -7.297333339903880e-10,
 -1.619074552123484e-11,  4.752292423389956e-14, -1.670831143738310e-17, -3.181196519867619e-19,  1.075882006832251e-21, -5.381282493771274e-25, -7.840802285863944e-27,
  2.923668538694050e-29,  6.109194392411180e-01, -2.024175427215380e-03,  3.335575145192787e-06,  6.803382947428345e-10, -1.986334847700195e-11,  4.483411463285372e-14,
  2.999632141336532e-17, -4.402299692246033e-19,  9.695539986797729e-22,  1.142009489474364e-24, -1.219458393085614e-26,  2.493529151647760e-29,  6.672111268925213e-01,
 -2.151724731845241e-03,  3.192520378653410e-06,  2.278485287750549e-09, -2.302282335326360e-11,  3.737150672436014e-14,  8.643303377208610e-17, -5.286383738053534e-19,
  6.065436827000169e-22,  3.259592925049205e-24, -1.456642606337044e-26,  7.797096723128695e-30,  7.255754357407763e-01, -2.271480122848259e-03,  2.968337360417152e-06,
  4.025308389812686e-09, -2.533076715039455e-11,  2.460866144240976e-14,  1.477296764012735e-16, -5.540897593546296e-19, -3.625052805198110e-23,  5.389316566733468e-24,
 -1.299294093517540e-26, -2.234044812094723e-29,  7.859015951174957e-01, -2.381278065221784e-03,  2.658293155393063e-06,  5.865238751798079e-09, -2.642672360546374e-11,
  6.459916201685532e-15,  2.064538276411447e-16, -4.878779293567562e-19, -9.195416074042410e-22,  6.872074573797120e-24, -5.909294225251231e-27, -5.948262061064523e-29,
  8.480609899472614e-01, -2.478820951584547e-03,  2.259510224704931e-06,  7.725260300360839e-09, -2.595353771358599e-11, -1.654044795734207e-14,  2.527967543497359e-16,
 -3.086557149053775e-19, -1.918776871351065e-21,  6.908926790830885e-24,  6.899266783154359e-27, -9.007480477853327e-29,  9.119044871740970e-01, -2.561692654899412e-03,
  1.771541136883048e-06,  9.514440376629825e-09, -2.359308923202787e-11, -4.306742582546108e-14,  2.753267812286228e-16, -1.128885817836914e-20, -2.814266620934430e-21,
  4.776272065083617e-24,  2.327237707532229e-26, -9.478820375824394e-29,  9.772594251252511e-01, -2.627383993710023e-03,  1.197022475921202e-06,  1.112473020227300e-08,
 -1.911316433036996e-11, -7.087876852642400e-14,  2.624967783594304e-16,  3.834697319063759e-19, -3.307653390634970e-21,  1.632846676802061e-25,  3.806538805842232e-26,
 -5.534248914126350e-29,  1.043926253796641e+00, -2.673331203900333e-03,  5.423932297138321e-07,  1.243361663285482e-08, -1.242473717507834e-11, -9.678454889339060e-14,
  2.050180878715525e-16,  8.210031315507066e-19, -3.078461590682440e-21, -6.429471465536304e-24,  4.368070043616655e-26,  3.344334810404186e-29,  1.111674830227123e+00,
 -2.696971117126750e-03, -1.813541403386431e-07,  1.330930961410599e-08, -3.646373568915980e-12, -1.167796092197575e-13,  9.903419917917366e-17,  1.210558325241039e-18,
 -1.888306508626513e-21, -1.338454039845465e-23,  3.245856306805975e-26,  1.500236438252888e-28,  1.180240398732397e+00, -2.695817302871474e-03, -9.579465522269308e-07,
  1.361919380882971e-08,  6.831445305482606e-12, -1.264131654210221e-13, -5.029684724792480e-17,  1.433824798765505e-18,  2.765584461760416e-22, -1.800683245708106e-23,
  1.083757909957961e-27,  2.400068661564824e-28,  1.249319324215107e+00, -2.667561802508140e-03, -1.765217672407830e-06,  1.324218927045803e-08,  1.829463164093469e-11,
 -1.214587882129973e-13, -2.256816248573628e-16,  1.369241427388995e-18,  3.063468827774802e-21, -1.719110064917689e-23, -4.421385178269422e-26,  2.303513868342081e-28,
  1.318564702076949e+00, -2.610207047477259e-03, -2.574743930090766e-06,  1.208535381877069e-08,  2.968534706211550e-11, -9.890281014703741e-14, -3.964678994588898e-16,
  9.336932194306721e-19,  5.689143852153391e-21, -8.853276493505156e-24, -8.488939513016430e-26,  7.204659618789747e-29,  1.387582044695866e+00, -2.522231772744949e-03,
 -3.351914196209778e-06,  1.010438891328574e-08,  3.963829316263669e-11, -5.817285272126358e-14, -5.211906022787312e-16,  1.355846944654730e-19,  7.056282693834973e-21,
  6.176376821857112e-24, -9.438772188348320e-26, -2.004637699615392e-28,  1.455925345681822e+00, -2.402792739818336e-03, -4.056669419998896e-06,  7.326546148202502e-09,
  4.660096543462289e-11, -2.371323584105831e-15, -5.556451441688421e-16, -8.789313120960582e-19,  6.132266334743409e-21,  2.279797332361633e-23, -5.255758053931896e-26,
 -4.373457071674856e-28,  1.523093950740437e+00, -2.251960273905171e-03, -4.645185474209993e-06,  3.872694887501215e-09,  4.905985492222680e-11,  6.092189480070377e-14,
 -4.669900191280742e-16, -1.817761270847329e-18,  2.556757105377837e-21,  3.240328691973156e-23,  3.385605900833684e-26, -4.320566390843828e-28,  1.588530814805587e+00,
 -2.070979348953232e-03, -5.072769711686568e-06, -2.689891764629439e-11,  4.587454312345434e-11,  1.198889342186399e-13, -2.514873174009925e-16, -2.307672895619656e-18,
 -2.772327907861367e-21,  2.696718751392997e-23,  1.198176265457853e-25, -9.050730785881695e-29,  1.651622887549779e+00, -1.862538713045972e-03, -5.298162091826275e-06,
 -4.030763796595530e-09,  3.668171224977179e-11,  1.603754550187467e-13,  5.080498146618698e-17, -2.046512027476597e-18, -7.610284165492435e-21,  5.525481565684030e-24,
  1.402732312543618e-25,  3.977302475632716e-28,  1.711704518710325e+00, -1.631018328521396e-03, -5.289230593846806e-06, -7.707316646464939e-09,  2.227218201955823e-11,
  1.697170384867188e-13,  3.549040232242938e-16, -1.002055956930216e-18, -9.237725838977913e-21, -2.143298351947813e-23,  6.224249428618826e-26,  6.124683633004407e-28,
  1.768064868524974e+00, -1.382671261890406e-03, -5.029691064960022e-06, -1.058646091213482e-08,  4.781501672277752e-12,  1.418816991464215e-13,  5.532763907868310e-16,
  4.578318024140266e-19, -6.221576714234359e-21, -3.588746760616251e-23, -6.637088760704124e-26,  2.885869569800250e-28,  1.819960285280386e+00, -1.125682884341547e-03,
 -4.525964670637653e-06, -1.224351432836562e-08, -1.249506196848000e-11,  8.205539254854392e-14,  5.622037703543037e-16,  1.653002020461343e-18,  5.228006503993002e-24,
 -2.594701651515606e-23, -1.366735285513145e-25, -2.922498464597133e-28,  1.866632395988766e+00, -8.700428278164927e-04, -3.812693920636883e-06, -1.240600663640263e-08,
 -2.579573370082102e-11,  7.781611449675514e-15,  3.740897631990855e-16,  1.954274866657877e-18,  5.447753538271799e-21,  7.934370841802784e-25, -8.334683747691892e-26,
 -5.032705432339199e-28,  1.907332176061526e+00, -6.271704887682157e-04, -2.954972200176991e-06, -1.105860021031131e-08, -3.204189559496074e-11, -5.586496468843757e-14,
  8.021509284750618e-17,  1.244755777018366e-18,  6.420726740630475e-21,  2.084776822769941e-23,  2.964441017403896e-26, -1.507489932294953e-28,  1.941349486928353e+00,
 -4.092599873823974e-04, -2.045314801591898e-06, -8.507840613672604e-09, -3.010502893520248e-11, -8.690512056086717e-14, -1.677977451694349e-16,  8.950363876226649e-20,
  2.940588220918433e-21,  1.804172709360935e-23,  7.558073175546825e-26,  2.270919983320312e-28,  1.968046558329069e+00, -2.283587198141460e-04, -1.194132887651518e-06,
 -5.366255455544306e-09, -2.159966078570169e-11, -7.832538096458931e-14, -2.509493413808359e-16, -6.650983007713543e-19, -1.118034947408762e-21,  1.653073056304287e-24,
  2.767952020771982e-26,  1.697148686036045e-28,  1.986892942692254e+00, -9.525917128727838e-05, -5.140784870114539e-07, -2.433477517317831e-09, -1.061743243402622e-11,
 -4.352939157495952e-14, -1.688602735722173e-16, -6.195125186552401e-19, -2.133477239368664e-21, -6.772025064035938e-24, -1.899170880888148e-26, -4.158081442347962e-29,
  1.997501095140611e+00, -1.833387184585953e-05, -1.006959513033965e-07, -4.904069172912764e-10, -2.232315750811003e-12, -9.719501123432367e-15, -4.096723375456848e-17,
 -1.683112784592284e-19, -6.767994141667774e-22, -2.670249386349630e-24, -1.035127977249862e-26, -3.944934773438157e-29,  3.315472137085258e-04, -1.358693404580529e-06,
  4.175369911170977e-09, -1.140417022675101e-11,  2.919398264226757e-14, -7.173340683891695e-17,  1.712925680912439e-19, -4.006253559934632e-22,  9.217295156019910e-25,
 -2.094645078053917e-27,  4.706334322384760e-30, -1.049676931034845e-32,  2.983794561044014e-03, -1.221879337310016e-05,  3.748704391004241e-08, -1.020880086410670e-10,
  2.601484213061269e-13, -6.350405551974262e-16,  1.502938520401627e-18, -3.474286441793595e-21,  7.875253171811446e-24, -1.756841507482562e-26,  3.858581207196464e-29,
 -8.373948150490490e-32,  8.287588903374787e-03, -3.388851116675744e-05,  1.036232865982621e-07, -2.805297009325781e-10,  7.082722165207821e-13, -1.705869238295098e-15,
  3.963091810220360e-18, -8.937653313775308e-21,  1.961577849899547e-23, -4.198343641242403e-26,  8.744005746273761e-29, -1.774027256283668e-31,  1.624150500979224e-02,
 -6.626641749138469e-05,  2.016087026245272e-07, -5.409006168458087e-10,  1.346322345647901e-12, -3.175216271189354e-15,  7.160913411327961e-18, -1.550128364434801e-20,
  3.216412741223752e-23, -6.373117499762351e-26,  1.190326439625375e-28, -2.059188464858508e-31,  2.684334320945051e-02, -1.091992023309185e-04,  3.299773173498373e-07,
 -8.745173785167292e-10,  2.134259037992748e-12, -4.885997232550759e-15,  1.054837570607670e-17, -2.142305715264278e-20,  4.040500730681310e-23, -6.884899970943824e-26,
  9.792368787024476e-29, -8.624503484278034e-32,  4.009005376473249e-02, -1.624802658091564e-04,  4.867693482664463e-07, -1.269916787310706e-09,  3.020254645931685e-12,
 -6.640747254591162e-15,  1.346508330610235e-17, -2.472692247193401e-20,  3.902399551658412e-23, -4.463392349655577e-26, -1.791291251660242e-30,  2.207577678877874e-31,
  5.597763360191859e-02, -2.258478232661718e-04,  6.695272969066490e-07, -1.712961553727055e-09,  3.942070122254561e-12, -8.211869377599783e-15,  1.519616718731947e-17,
 -2.347462511418044e-20,  2.361219666466643e-23,  1.638938379346330e-26, -1.838169105979023e-28,  6.747694694358331e-31,  7.450099323693132e-02, -2.989825115010446e-04,
  8.752917307545653e-07, -2.186981990610546e-09,  4.828824607231720e-12, -9.354386361400862e-15,  1.504143874827024e-17, -1.607253719953074e-20, -8.183436925600287e-24,
  1.128166104551473e-25, -4.202021609909230e-28,  1.139056936251720e-30,  9.565379109537356e-02, -3.815044808860876e-04,  1.100597255379242e-06, -2.672960317565059e-09,
  5.603188052419231e-12, -9.821104415612740e-15,  1.239327133369653e-17, -1.590394394208203e-21, -5.561260076253196e-23,  2.317831506334642e-25, -6.482722446930173e-28,
  1.393171571324097e-30,  1.194282317193247e-01, -4.729699566620563e-04,  1.341469335536242e-06, -3.149765827388177e-09,  6.184029471560030e-12, -9.380022521856126e-15,
  6.819784503022344e-18,  1.993688063716065e-20, -1.140466972460690e-22,  3.482261172783149e-25, -7.766486609193244e-28,  1.181632483037365e-30,  1.458148235613528e-01,
 -5.728672525410711e-04,  1.593422818182037e-06, -3.594450885388139e-09,  6.489553457358877e-12, -7.833710446940644e-15, -1.851184210009237e-18,  4.725878698644533e-20,
 -1.746585937493652e-22,  4.266813031313340e-25, -7.019471340814913e-28,  2.971091401060173e-31,  1.748020911704701e-01, -6.806122212658049e-04,  1.851463249278676e-06,
 -3.982619553178037e-09,  6.440953851542988e-12, -5.040222418271147e-15, -1.345313585759531e-17,  7.775010950644660e-20, -2.247375116371239e-22,  4.261033121516741e-25,
 -3.359219744934585e-28, -1.313926959040876e-30,  2.063762355550886e-01, -7.955431306655166e-04,  2.110092370360872e-06, -4.288882505551572e-09,  5.966604289810941e-12,
 -9.349008159112976e-16, -2.741430933706560e-17,  1.073869912352356e-19, -2.487967429230507e-22,  3.078372927892941e-25,  3.597095440630069e-28, -3.447245186957190e-30,
  2.405207353425073e-01, -9.169149609089090e-04,  2.363319541909656e-06, -4.487413755920108e-09,  5.006788603119077e-12,  4.447856392061060e-15, -4.271238273743125e-17,
  1.309039221046951e-19, -2.305794660569573e-22,  4.632988148290444e-26,  1.336649374867193e-27, -5.574298290708483e-30,  2.772158800197280e-01, -1.043893130283408e-03,
  2.604681281677566e-06, -4.552626374254374e-09,  3.518946911669543e-12,  1.095415023717902e-14, -5.786111362232194e-17,  1.421749942000471e-19, -1.559758769476428e-22,
 -3.585639320430289e-25,  2.430857405504525e-27, -6.856243733955867e-30,  3.164382250123278e-01, -1.175546674533907e-03,  2.827271641048863e-06, -4.459985633679465e-09,
  1.483372075912586e-12,  1.829318934318172e-14, -7.094105690648059e-17,  1.348539292352131e-19, -1.672314326881250e-23, -8.697179371852228e-25,  3.353052798268130e-27,
 -6.280292064701946e-30,  3.581599566130735e-01, -1.310840930695889e-03,  3.023786784846036e-06, -4.186978492541039e-09, -1.090768529541685e-12,  2.602521832821446e-14,
 -7.968748117216972e-17,  1.032889941971671e-19,  1.854393210669659e-22, -1.404335657454502e-24,  3.712582558144797e-27, -2.943955723039057e-30,  4.023481527889872e-01,
 -1.448629813253670e-03,  3.186587901127537e-06, -3.714257464618716e-09, -4.159294549844729e-12,  3.355764074750403e-14, -8.164853564724449e-17,  4.369733627809940e-20,
  4.347439933184302e-22, -1.832925231960619e-24,  3.086906003151763e-27,  3.523823684837161e-30,  4.489639236599129e-01, -1.587647821993402e-03,  3.307787453514476e-06,
 -3.026973964389822e-09, -7.637079668426671e-12,  4.015285958265877e-14, -7.442482548162644e-17, -4.446539035458113e-20,  6.983861187192472e-22, -1.990059195035310e-24,
  1.142668548883062e-27,  1.247578668688860e-29,  4.979614129504339e-01, -1.726501991819693e-03,  3.379364794827806e-06, -2.116310024930082e-09, -1.139279596998645e-11,
  4.495197241372986e-14, -5.599676305757135e-17, -1.570732280318170e-19,  9.257296553566836e-22, -1.700984721932730e-24, -2.198659581857220e-27,  2.184474004925014e-29,
  5.492866389878445e-01, -1.863664091089682e-03,  3.393318263648864e-06, -9.812063408473409e-10, -1.524499850423141e-11,  4.701890694322821e-14, -2.513699597510191e-17,
 -2.840594223182350e-19,  1.051171271420249e-21, -8.263429328582365e-25, -6.578504233369717e-27,  2.806159482217213e-29,  6.028761509029068e-01, -1.997463504265042e-03,
  3.341862029197601e-06,  3.697331651950575e-10, -1.896044724063418e-11,  4.540964966015260e-14,  1.810976443079605e-17, -4.086384058711528e-19,  1.002155763342631e-21,
  6.767175594214042e-25, -1.105805761339544e-26,  2.657835492241673e-29,  6.586554726911011e-01, -2.126081406218024e-03,  3.217677027699076e-06,  1.916207272021514e-09,
 -2.225583646188655e-11,  3.927057472840912e-14,  7.191973444626760e-17, -5.074631301681599e-19,  7.134993132823507e-22,  2.685477002551130e-24, -1.409972659234374e-26,
  1.324023199619787e-29,  7.165373048944335e-01, -2.247547060500334e-03,  3.014226158761450e-06,  3.624140865702646e-09, -2.480439540470498e-11,  2.796804407442345e-14,
  1.322273644068490e-16, -5.522475975449895e-19,  1.481974226676402e-22,  4.852605826203075e-24, -1.377789806116782e-26, -1.346014566633592e-29,  7.764194511724987e-01,
 -2.359737365042516e-03,  2.726144177725843e-06,  5.443709274985094e-09, -2.624909909063815e-11,  1.124778285643017e-14,  1.924181285888462e-16, -5.133955137575011e-19,
 -6.770063020809113e-22,  6.586225805882214e-24, -8.311593220793729e-27, -4.966441765603790e-29,  8.381824354276753e-01, -2.460381139669620e-03,  2.349711951483805e-06,
  7.307683811967996e-09, -2.622441035939424e-11, -1.058374093774852e-14,  2.433325087047721e-16, -3.660314277906181e-19, -1.666028571877756e-21,  7.107263813030407e-24,
  3.061348651809758e-27, -8.407269388012856e-29,  9.016867751670414e-01, -2.547070113117729e-03,  1.883422222585793e-06,  9.130418898449312e-09, -2.438843682024962e-11,
 -3.647338742268460e-14,  2.737769841933447e-16, -9.842283392914269e-20, -2.626581974363042e-21,  5.622467806120532e-24,  1.901140826139438e-26, -9.836146781874312e-29,
  9.667698795108474e-01, -2.617279131128247e-03,  1.328638712829095e-06,  1.080792470144271e-08, -2.046693251725196e-11, -6.446194467650587e-14,  2.717550517998526e-16,
  2.780076604275565e-19, -3.275002831789833e-21,  1.631982068685276e-24,  3.524625007324662e-26, -7.225673670142703e-29,  1.033242547264758e+00, -2.668398769330377e-03,
  6.903408636015001e-07,  1.221961026687454e-08, -1.430942017049262e-11, -9.159959120101658e-14,  2.265946468753408e-16,  7.191285813948289e-19, -3.278193358288180e-21,
 -4.661096404036031e-24,  4.453476534632660e-26,  5.547956944919036e-30,  1.100885053966793e+00, -2.697784271810884e-03, -2.206910187255699e-08,  1.323242343618211e-08,
 -5.955489143574039e-12, -1.140033049118206e-13,  1.320132928770417e-16,  1.142686051587372e-18, -2.345259517961169e-21, -1.196197973434501e-23,  3.846990918677232e-26,
  1.226436993002801e-28,  1.169442839804294e+00, -2.702825488339654e-03, -7.939440155914739e-07,  1.370821890050120e-08,  4.294365297650457e-12, -1.271381227575991e-13,
 -1.012312884099986e-17,  1.432331660894349e-18, -3.683773508107114e-22, -1.775405728684555e-23,  1.149630892098913e-26,  2.319563860842469e-28,  1.238621846708106e+00,
 -2.681043129126448e-03, -1.604636196523953e-06,  1.351518890879624e-08,  1.581445250691167e-11, -1.264045881339544e-13, -1.860657851459804e-16,  1.457049386407031e-18,
  2.415278784674430e-21, -1.874818008167158e-23, -3.343864876604587e-26,  2.579937335954184e-28,  1.308083607667845e+00, -2.630216981165811e-03, -2.426936816313159e-06,
  1.254398718287233e-08,  2.761436116377596e-11, -1.080840646200299e-13, -3.678282978426437e-16,  1.109998279544368e-18,  5.310235154951393e-21, -1.216728193526239e-23,
 -8.036439792253672e-26,  1.333036820050743e-28,  1.377440270010279e+00, -2.548551386861031e-03, -3.226896844061517e-06,  1.072861606709908e-08,  3.835019051319625e-11,
 -7.061017620913168e-14, -5.142048795323043e-16,  3.641984555681623e-19,  7.208707661133850e-21,  2.242211452418947e-24, -1.018626254197109e-25, -1.376273240597733e-28,
  1.446249842713376e+00, -2.434881753852341e-03, -3.964281107538902e-06,  8.071049663191785e-09,  4.641830847416053e-11, -1.597921077449085e-14, -5.773876931828265e-16,
 -6.700104221486363e-19,  6.910533894837672e-21,  2.031321503872001e-23, -7.158787810258528e-26, -4.246339598443932e-28,  1.514012099958024e+00, -2.288922435503962e-03,
 -4.593965200455619e-06,  4.666773989573195e-09,  5.016214491668030e-11,  4.911369805157777e-14, -5.165648991158158e-16, -1.717057832556257e-18,  3.742878444775616e-21,
  3.335640090870984e-23,  1.330144212471684e-26, -5.003833105739352e-28,  1.580165748903334e+00, -2.111550139928224e-03, -5.068610538579948e-06,  7.259259247504760e-10,
  4.820668316655612e-11,  1.130687656491802e-13, -3.171916747730772e-16, -2.379939014620192e-18, -1.716494547894088e-21,  3.164776093137323e-23,  1.133874549336394e-25,
 -2.035228355304090e-28,  1.644087670173670e+00, -1.905107264914703e-03, -5.342903805028674e-06, -3.418150053248921e-09,  3.989663175907106e-11,  1.608798510926976e-13,
 -9.868944147202225e-18, -2.285742197052889e-18, -7.306290651286410e-21,  1.147087540082550e-23,  1.565642804522327e-25,  3.383565903915964e-28,  1.705095240847031e+00,
 -1.673695805510880e-03, -5.379466779302260e-06, -7.323354362641345e-09,  2.574925149877814e-11,  1.778639461862883e-13,  3.225956970511492e-16, -1.309474147675695e-18,
 -9.957820895070097e-21, -1.838438805872045e-23,  9.065538412313255e-26,  6.766319553480338e-28,  1.762452905975701e+00, -1.423415419597932e-03, -5.156173581883136e-06,
 -1.048653040275627e-08,  7.752838952347787e-12,  1.552904553649840e-13,  5.631106934097270e-16,  2.375848030655417e-19, -7.557918875916478e-21, -3.825147604019812e-23,
 -5.088695507558675e-26,  4.179658173982592e-28,  1.815384203173631e+00, -1.162481559485989e-03, -4.674029794245379e-06, -1.242955761784628e-08, -1.071527990827009e-11,
  9.610280918630920e-14,  6.083420791885609e-16,  1.637144296626833e-18, -1.030254916787369e-21, -3.165830280128915e-23, -1.485274394708758e-25, -2.422781915517177e-28,
  1.863090268832404e+00, -9.011468688485571e-04, -3.964035623002252e-06, -1.281698654552333e-08, -2.554578580095251e-11,  1.743610348992794e-14,  4.312495023201567e-16,
  2.128371918896802e-18,  5.410768545534366e-21, -3.005540044172565e-24, -1.071521976341446e-25, -5.787457501673524e-28,  1.904775361682523e+00, -6.513498787499328e-04,
 -3.090787923322321e-06, -1.158009205695919e-08, -3.313699719832002e-11, -5.349764585376670e-14,  1.180591184697466e-16,  1.462441935439012e-18,  7.190793687463757e-21,
  2.187886646849927e-23,  2.133254849167636e-26, -2.301463535468974e-28,  1.939679063609838e+00, -4.260392042247904e-04, -2.150357035085112e-06, -9.003643652913281e-09,
 -3.188314223304958e-11, -9.089093856545163e-14, -1.638723434399037e-16,  1.945977935336046e-19,  3.646957201867722e-21,  2.126919358112563e-23,  8.589319688723719e-26,
  2.408642741066949e-28,  1.967113601034245e+00, -2.381753594973078e-04, -1.260654292788868e-06, -5.724715730699568e-09, -2.322792532134190e-11, -8.457561799937692e-14,
 -2.700624156033850e-16, -6.996942733790613e-19, -1.036690802459030e-21,  2.921200913149645e-24,  3.602795839849409e-26,  2.110745070199763e-28,  1.986503491640856e+00,
 -9.949156167093729e-05, -5.443289498524498e-07, -2.610547372202707e-09, -1.152999263128685e-11, -4.779813959619673e-14, -1.872001382395987e-16, -6.918346936283103e-19,
 -2.391388391787000e-21, -7.568630764606168e-24, -2.084507071961482e-26, -4.246398796612538e-29,  1.997426110369947e+00, -1.916360130705495e-05, -1.068017290259522e-07,
 -5.277341582763092e-10, -2.436932674992299e-12, -1.076180639643437e-14, -4.599819711038095e-17, -1.915903596890431e-19, -7.808194216032314e-22, -3.121209720415189e-24,
 -1.225366890138697e-26, -4.727095388358519e-29,  3.261783903603859e-04, -1.325830012301049e-06,  4.041275859996278e-09, -1.094832423892926e-11,  2.779953303779299e-14,
 -6.775373074971292e-17,  1.604769106261719e-19, -3.723010783369215e-22,  8.496024586460639e-25, -1.915310681153705e-27,  4.268040965333022e-30, -9.445447592569361e-33,
  2.935511520205732e-03, -1.192372743855490e-05,  3.628654918728494e-08, -9.802531312742540e-11,  2.478005804964884e-13, -6.001094879582254e-16,  1.409093615942056e-18,
 -3.232106923452777e-21,  7.269706541338816e-24, -1.609621500901587e-26,  3.508340036329748e-29, -7.560843686365679e-32,  8.153671779635812e-03, -3.307280020933645e-05,
  1.003238149568069e-07, -2.694652005026387e-10,  6.750860639317645e-13, -1.613688528483758e-15,  3.721402897535405e-18, -8.333470803330055e-21,  1.816549422089744e-23,
 -3.863716390029700e-26,  7.998912927157832e-29, -1.615337461543479e-31,  1.597962448132200e-02, -6.467914966670478e-05,  1.952450763742781e-07, -5.198583015943254e-10,
  1.284502074736955e-12, -3.008448562671112e-15,  6.740948535437347e-18, -1.450783925435687e-20,  2.995336449835055e-23, -5.914675826574014e-26,  1.102934790948725e-28,
 -1.914629112865335e-31,  2.641176038375894e-02, -1.066007874461822e-04,  3.196848169224571e-07, -8.411374397321144e-10,  2.039022861485732e-12, -4.639890521652561e-15,
  9.966264284599593e-18, -2.016900547885513e-20,  3.799602114399842e-23, -6.500931341208272e-26,  9.403030714884733e-29, -9.041424219129355e-32,  3.944782564400430e-02,
 -1.586462555005702e-04,  4.718159646109244e-07, -1.222637906948475e-09,  2.890615963152916e-12, -6.325753875168303e-15,  1.278997067581426e-17, -2.350385933952265e-20,
  3.741811118540648e-23, -4.452376712443439e-26,  7.002284632710019e-30,  1.799893939384367e-31,  5.508482605798549e-02, -2.205727671568271e-04,  6.493448407415718e-07,
 -1.651182737005207e-09,  3.781427017775730e-12, -7.854962961588714e-15,  1.454953485898395e-17, -2.271095708430564e-20,  2.407678583364841e-23,  9.604762259897088e-27,
 -1.560326496575923e-28,  5.898338949360468e-31,  7.331890348366998e-02, -2.920838534422621e-04,  8.495054032503139e-07, -2.111198038172530e-09,  4.645310235366911e-12,
 -8.998818156108025e-15,  1.458832952004173e-17, -1.627257282621681e-20, -4.412822081990680e-24,  9.697632023392407e-26, -3.726493934711865e-28,  1.024121485982275e-30,
  9.414518171500601e-02, -3.728264956943190e-04,  1.069053207991891e-06, -2.584864543268512e-09,  5.409735734999700e-12, -9.524393837243312e-15,  1.232504526050996e-17,
 -3.241377109058067e-21, -4.772066761222551e-23,  2.070478227632352e-25, -5.892416911167876e-28,  1.290549319390666e-30,  1.175575783757858e-01, -4.623877228804090e-04,
  1.304259650929816e-06, -3.052313083921781e-09,  5.998108903325853e-12, -9.210049923202516e-15,  7.328766680858749e-18,  1.648207019492732e-20, -1.020572671923915e-22,
  3.181939849630918e-25, -7.251299476009803e-28,  1.158070384891516e-30,  1.435485786142848e-01, -5.602906504003080e-04,  1.550907227823324e-06, -3.491873398965185e-09,
  6.332538942643950e-12, -7.862877480965354e-15, -6.039145000243575e-19,  4.191008942888353e-20, -1.597999448840934e-22,  3.989053869372696e-25, -6.859077583579405e-28,
  4.263837830806965e-31,  1.721089654813958e-01, -6.659899368421775e-04,  1.804286764825080e-06, -3.880387544288324e-09,  6.337092847726168e-12, -5.337772214403692e-15,
 -1.137452823927392e-17,  7.080124439450972e-20, -2.096526577062847e-22,  4.116117096685055e-25, -3.862415125144610e-28, -9.820307261701604e-31,  2.032275008442980e-01,
 -7.788666367948223e-04,  2.059197844228169e-06, -4.193601163034026e-09,  5.941565787225918e-12, -1.557651527955668e-15, -2.451725038098931e-17,  9.960529952662124e-20,
 -2.374907221297778e-22,  3.193496527217732e-25,  2.197043280714894e-28, -2.926031082586470e-30,  2.368905494991687e-01, -8.982224321824072e-04,  2.309953987081640e-06,
 -4.406647946966536e-09,  5.085787347975236e-12,  3.465911047203481e-15, -3.915005093861199e-17,  1.235619151279242e-19, -2.280066816792019e-22,  9.506914084388937e-26,
  1.104676453231716e-27, -4.975359420373561e-30,  2.730816377721152e-01, -1.023273232775605e-03,  2.550394573097355e-06, -4.494644667309373e-09,  3.724462738936819e-12,
  9.612679028722206e-15, -5.395190111050325e-17,  1.369954172755094e-19, -1.672054727113978e-22, -2.672317866520064e-25,  2.139051999741236e-27, -6.403115429618774e-30,
  3.117809363070659e-01, -1.153142150027725e-03,  2.773905994518350e-06, -4.433415994948215e-09,  1.832515425869493e-12,  1.663582640853744e-14, -6.717716435174741e-17,
  1.338431754846939e-19, -4.568548257736289e-23, -7.411312242846425e-25,  3.076283587839186e-27, -6.280601352368062e-30,  3.529646549009370e-01, -1.286851869185654e-03,
  2.973455171915393e-06, -4.200369671769713e-09, -5.891516280493693e-13,  2.414804873505244e-14, -7.671970998265953e-17,  1.084425482681043e-19,  1.375228712852861e-22,
 -1.258662437155721e-24,  3.565542351074795e-27, -3.704500551342196e-30,  3.966043351280349e-01, -1.423316475413004e-03,  3.141639323637858e-06, -3.775542981078173e-09,
 -3.507630408998493e-12,  3.161427011975585e-14, -8.023999320767064e-17,  5.657748214328791e-20,  3.710139034128749e-22, -1.706862705334103e-24,  3.203960124056703e-27,
  1.840286169264315e-30,  4.426660240682054e-01, -1.561332834001347e-03,  3.270756791761387e-06, -3.142840210244624e-09, -6.851972510631549e-12,  3.835418290796784e-14,
 -7.536768073757016e-17, -2.325345785514018e-20,  6.276922769578919e-22, -1.934109486544023e-24,  1.636980855938691e-27,  1.002723022279031e-29,  4.911093096949543e-01,
 -1.699571687337359e-03,  3.352904793944588e-06, -2.291476900485772e-09, -1.050753492905781e-11,  4.355856379147130e-14, -5.998940263491066e-17, -1.284447853674328e-19,
  8.631358888597742e-22, -1.770468272130632e-24, -1.294353577742826e-27,  1.925969635338692e-29,  5.418861953838844e-01, -1.836568718281817e-03,  3.380111186777066e-06,
 -1.217638706676958e-09, -1.431127796994666e-11,  4.632394686537762e-14, -3.262455545817825e-17, -2.509463121023181e-19,  1.016979983425544e-21, -1.065231893097961e-24,
 -5.377578137776394e-27,  2.646594886736685e-29,  5.949397875883936e-01, -1.970715948924136e-03,  3.344508660637275e-06,  7.365134364074203e-11, -1.804881588299464e-11,
  4.571062481257414e-14,  7.119921950624051e-18, -3.762626941467933e-19,  1.018840416028994e-21,  2.580787997532796e-25, -9.868012283076719e-27,  2.738581978692627e-29,
  6.502027670636205e-01, -2.100254005358107e-03,  3.238561163945301e-06,  1.566486180396044e-09, -2.145430145856175e-11,  4.082880622473383e-14,  5.804417925747484e-17,
 -4.831919445317606e-19,  8.001776568052823e-22,  2.134505554398798e-24, -1.341692329161498e-26,  1.762380905521608e-29,  7.075956102382175e-01, -2.223265995658637e-03,
  3.055353630291087e-06,  3.231912605036129e-09, -2.421454901275623e-11,  3.095663909760707e-14,  1.168563221035895e-16, -5.448175556751439e-19,  3.128507356903756e-22,
  4.292084310869379e-24, -1.418936945885093e-26, -5.387671843791208e-30,  7.670245236859873e-01, -2.337674034628101e-03,  2.788956998369430e-06,  5.025769319245371e-09,
 -2.597913919456827e-11,  1.569108568270024e-14,  1.777749186689395e-16, -5.313343139397126e-19, -4.463865017469148e-22,  6.212985420958392e-24, -1.027799736043282e-26,
 -3.972499187356470e-29,  8.283790515553821e-01, -2.441239822317896e-03,  2.434880646624916e-06,  6.886713563289237e-09, -2.637854566434053e-11, -4.872534563756432e-15,
  2.323758396436395e-16, -4.152340340376246e-19, -1.408835099817467e-21,  7.157875507195442e-24, -4.751586811225475e-28, -7.644495988525038e-29,  8.915293139466310e-01,
 -2.531571162010180e-03,  1.990623040464532e-06,  8.734724067109805e-09, -2.505246958896967e-11, -2.994511553170966e-14,  2.698758621407440e-16, -1.790966384623319e-19,
 -2.411531571679293e-21,  6.296010235093903e-24,  1.466228221703978e-26, -9.883734702753836e-29,  9.563228346224484e-01, -2.606136903713160e-03,  1.456327593454955e-06,
  1.047049667296981e-08, -2.169038061494569e-11, -5.785819141392714e-14,  2.780827999721541e-16,  1.744132160559425e-19, -3.191679308661500e-21,  2.974021419896754e-24,
  3.175752500716573e-26, -8.573580751463031e-29,  1.022580920655710e+00, -2.662293530569594e-03,  8.355430020617145e-07,  1.197630571994705e-08, -1.608546017168070e-11,
 -8.593168917158500e-14,  2.452388422934611e-16,  6.118854124606556e-19, -3.413941200891678e-21, -2.882730880532176e-24,  4.419122535511193e-26, -2.083905197373230e-29,
  1.090094566924204e+00, -2.697327460307211e-03,  1.360735971921088e-07,  1.311907794724140e-08, -8.201325916785909e-12, -1.104599108613523e-13,  1.628952637934969e-16,
  1.061054670126810e-18, -2.746971170460720e-21, -1.032399266868386e-23,  4.320907985901512e-26,  9.240854778966656e-29,  1.158619877965548e+00, -2.708518071157936e-03,
 -6.291170464543168e-07,  1.375658704936645e-08,  1.752412442592126e-12, -1.269017333720772e-13,  2.972178688867739e-17,  1.410425727299038e-18, -9.968229344963436e-22,
 -1.709420186173947e-23,  2.138108734668760e-26,  2.161290013785540e-28,  1.227873032984347e+00, -2.693227381741783e-03, -1.441019916886363e-06,  1.374776680518717e-08,
  1.324505200229729e-11, -1.303724970474303e-13, -1.442895325583107e-16,  1.523303792934856e-18,  1.719061182078552e-21, -1.985257340376601e-23, -2.164693730319481e-26,
  2.763906681913857e-28,  1.297524872480601e+00, -2.649023020555474e-03, -2.273830850943194e-06,  1.296805477030077e-08,  2.536701599637018e-11, -1.165202091462641e-13,
 -3.344395616568399e-16,  1.272309555275822e-18,  4.815922913565958e-21, -1.524718001732494e-23, -7.320875951016398e-26,  1.911664871071495e-28,  1.367195264067657e+00,
 -2.573841268455173e-03, -3.094520597080775e-06,  1.133025490076981e-08,  3.681553874958149e-11, -8.280260975077962e-14, -5.007713560405117e-16,  5.953716097718638e-19,
  7.214812976994068e-21, -1.932843097037866e-24, -1.063671743016456e-25, -6.587571994673826e-29,  1.436447518386430e+00, -2.466195995758755e-03, -3.862985355459395e-06,
  8.810427091027322e-09,  4.595876356520669e-11, -3.003599537909412e-14, -5.929462804098343e-16, -4.377616841443367e-19,  7.585832918057125e-21,  1.708390939525954e-23,
 -8.964809776039199e-26, -3.931483675623446e-28,  1.504783280802701e+00, -2.325436437656323e-03, -4.533118157645035e-06,  5.476536810643309e-09,  5.101662368000627e-11,
  3.615385544219883e-14, -5.627847065638086e-16, -1.578013866473797e-18,  4.947820883590899e-21,  3.343087812916908e-23, -9.976342545455967e-27, -5.550599377671701e-28,
  1.571638524479807e+00, -2.152050898510270e-03, -5.055198362477013e-06,  1.514887485073160e-09,  5.038650727779731e-11,  1.046513826559561e-13, -3.844215499825331e-16,
 -2.415781997038836e-18, -4.980147517428339e-22,  3.596887332939661e-23,  1.017833395766383e-25, -3.249257033682137e-28,  1.636381510516197e+00, -1.948003470329831e-03,
 -5.379985450592907e-06, -2.754098268299481e-09,  4.310654140987888e-11,  1.598489929842166e-13, -7.707208422367490e-17, -2.511699847959817e-18, -6.777235811901816e-21,
  1.800764050395208e-23,  1.696402079436030e-25,  2.513264781711473e-28,  1.698313839829103e+00, -1.717075783936616e-03, -5.464756386299456e-06, -6.882500564066564e-09,
  2.938079491142898e-11,  1.851296670642529e-13,  2.813751524311567e-16, -1.637954796617388e-18, -1.054707157222698e-20, -1.414760450305695e-23,  1.215207149399147e-25,
  7.227735741985533e-28,  1.756675951838001e+00, -1.465165812118793e-03, -5.281162798936078e-06, -1.033690245662241e-08,  1.099418677843584e-11,  1.688563255597540e-13,
  5.661675228774732e-16, -2.665585952403221e-20, -8.966802015552178e-21, -3.987759712708160e-23, -2.936628846090599e-26,  5.624496078532227e-28,  1.810658543897109e+00,
 -1.200473179854542e-03, -4.824147112645924e-06, -1.258481686414095e-08, -8.643532455336702e-12,  1.112482795978182e-13,  6.535409407155479e-16,  1.584774681102624e-18,
 -2.279276484018435e-21, -3.779172437449293e-23, -1.575716559086272e-25, -1.636615095288663e-28,  1.859421272926151e+00, -9.334812873820553e-04, -4.120278471352041e-06,
 -1.322234637990619e-08, -2.508863612264591e-11,  2.852065904070859e-14,  4.932454817755560e-16,  2.298906985854935e-18,  5.219083349577275e-21, -7.822736997837836e-24,
 -1.342392499299070e-25, -6.516447383868714e-28,  1.902119616643284e+00, -6.766411200636547e-04, -3.232964950313792e-06, -1.211867528675281e-08, -3.417516161899067e-11,
 -5.014611146394405e-14,  1.623484281053531e-16,  1.705292809982789e-18,  7.991102061000850e-21,  2.250191000545761e-23,  9.095403904416285e-27, -3.296246185964194e-28,
  1.937939804376451e+00, -4.436830471478584e-04, -2.261522215137404e-06, -9.528528069223431e-09, -3.373977777437471e-11, -9.474457082985815e-14, -1.566698110138669e-16,
  3.242354808231025e-19,  4.477071596034118e-21,  2.491965693893664e-23,  9.668524150924021e-26,  2.483979619478670e-28,  1.966140284957240e+00, -2.485418290666275e-04,
 -1.331637741399517e-06, -6.110253523297600e-09, -2.498585849131041e-11, -9.129585434384245e-14, -2.901003909513038e-16, -7.308886376432847e-19, -9.032225020882097e-22,
  4.562108791022534e-24,  4.638146536947604e-26,  2.610781877947304e-28,  1.986096613204032e+00, -1.039747099740922e-04, -5.767947534946697e-07, -2.802925810740838e-09,
 -1.253249831734238e-11, -5.253230423826761e-14, -2.076849815697142e-16, -7.728832312911975e-19, -2.679317581676504e-21, -8.439749372216088e-24, -2.270638413192151e-26,
 -4.183770712645601e-29,  1.997347706071407e+00, -2.004402598145624e-05, -1.133757866595747e-07, -5.685088278495176e-10, -2.663657942344360e-12, -1.193306824060673e-14,
 -5.173012504216944e-17, -2.184732214006205e-19, -9.025308704320531e-22, -3.655615528231398e-24, -1.453570603898260e-26, -5.676226454006984e-29,  3.209389091932332e-04,
 -1.294017865155047e-06,  3.912520675139932e-09, -1.051416653519211e-11,  2.648214411374281e-14, -6.402436844720709e-17,  1.504229669619114e-19, -3.461848651050572e-22,
  7.836267030994951e-25, -1.752617130700518e-27,  3.873468624234828e-30, -8.507203585102007e-33,  2.888389839282368e-03, -1.163807375870829e-05,  3.513364408228303e-08,
 -9.415471420296277e-11,  2.361293764056001e-13, -5.673514677428971e-16,  1.321766231856673e-18, -3.008483264313741e-21,  6.714721258424949e-24, -1.475721168261827e-26,
  3.191982691900980e-29, -6.832172901580189e-32,  8.022965536520994e-03, -3.228296281756470e-05,  9.715399128372887e-08, -2.589172391040225e-10,  6.436868638479145e-13,
 -1.527110482194089e-15,  3.495999075490977e-18, -7.773826119322263e-21,  1.683047525140343e-23, -3.557541288604982e-26,  7.320313700471939e-29, -1.471541030480302e-31,
  1.572399278193723e-02, -6.314179738603312e-05,  1.891281314792948e-07, -4.997789661625558e-10,  1.225918578881730e-12, -2.851434057863430e-15,  6.347834017669687e-18,
 -1.358256489145967e-20,  2.790149929594277e-23, -5.489944845098576e-26,  1.021708473116528e-28, -1.778925293515693e-31,  2.599040903839120e-02, -1.040831358628341e-04,
  3.097838930913847e-07, -8.092426499876836e-10,  1.948571912163643e-12, -4.407341707760952e-15,  9.418207648358972e-18, -1.898986008646634e-20,  3.572242111382290e-23,
 -6.132850165111935e-26,  8.999240049628899e-29, -9.287454589405860e-32,  3.882069785440974e-02, -1.549296376635646e-04,  4.574176872817201e-07, -1.177383715377707e-09,
  2.767117864851868e-12, -6.026558050531139e-15,  1.214838543742994e-17, -2.233205656959915e-20,  3.582210795681818e-23, -4.409595423897246e-26,  1.413428215814458e-29,
  1.450920170084681e-31,  5.421280045340264e-02, -2.154562484714690e-04,  6.298885414859177e-07, -1.591917940839487e-09,  3.627768589609319e-12, -7.513317667237928e-15,
  1.392445814083692e-17, -2.193612278209617e-20,  2.431625937152933e-23,  3.859688380586068e-27, -1.317692123566722e-28,  5.145541421358290e-31,  7.216400147122227e-02,
 -2.853878977530893e-04,  8.246110985520746e-07, -2.038294017291598e-09,  4.468798095988702e-12, -8.654178663748058e-15,  1.413122536295563e-17, -1.636071539097475e-20,
 -1.179411359993367e-24,  8.293996610674553e-26, -3.299330086348714e-28,  9.191187823506964e-31,  9.267078619223428e-02, -3.643966864531672e-04,  1.038547933972688e-06,
 -2.499816636539255e-09,  5.222197654512738e-12, -9.229847684312958e-15,  1.221399658793287e-17, -4.653618570566581e-21, -4.067778363974805e-23,  1.845843916009687e-25,
 -5.346516111669828e-28,  1.191464620050134e-30,  1.157286659477807e-01, -4.520985391518111e-04,  1.268201665114275e-06, -2.957807242341052e-09,  5.815702327148213e-12,
 -9.028980199633749e-15,  7.746225719883450e-18,  1.339401849279924e-20, -9.111218196925512e-23,  2.901984302186335e-25, -6.748993034502084e-28,  1.123581245463838e-30,
  1.413319675618841e-01, -5.480492920050303e-04,  1.509607479789670e-06, -3.391811235028155e-09,  6.175228574907537e-12, -7.863854394701815e-15,  5.000989741758063e-19,
  3.702100407848601e-20, -1.459283974145288e-22,  3.718752617135813e-25, -6.648844593315975e-28,  5.244984184996643e-31,  1.694735818354404e-01, -6.517401858429353e-04,
  1.758326906040562e-06, -3.779862274100866e-09,  6.227764233600842e-12, -5.587716194789219e-15, -9.483811866717971e-18,  6.432638663045735e-20, -1.951223504205445e-22,
  3.953842843688927e-25, -4.230767986292302e-28, -7.000733021317598e-31,  2.001446650271217e-01, -7.625927333616235e-04,  2.009443891530498e-06, -4.098816372248536e-09,
  5.904750128447416e-12, -2.113446245500243e-15, -2.183295884152132e-17,  9.219099462421937e-20, -2.258656844659594e-22,  3.257038968477532e-25,  1.013986741307242e-28,
 -2.460425610993892e-30,  2.333342860884657e-01, -8.799529311107644e-04,  2.257564572613403e-06, -4.324770693778164e-09,  5.145985548625071e-12,  2.567005612863440e-15,
 -3.579189142301632e-17,  1.163285711861297e-19, -2.238400441542060e-22,  1.350465109477893e-25,  8.982987523837565e-28, -4.411562220768927e-30,  2.690290110100772e-01,
 -1.003084791920370e-03,  2.496822505525011e-06, -4.433584294910335e-09,  3.904075408500537e-12,  8.363250934989823e-15, -5.019226915482637e-17,  1.315068872989227e-19,
 -1.753523410387950e-22, -1.871661639322160e-25,  1.867676494959320e-27, -5.930001448527875e-30,  3.072124139995666e-01, -1.131163182871496e-03,  2.720891623422644e-06,
 -4.401520344023828e-09,  2.149412035581631e-12,  1.506835675508226e-14, -6.345386734236275e-17,  1.319775581465482e-19, -7.021767386330525e-23, -6.235825744057915e-25,
  2.801921390686794e-27, -6.174904139111452e-30,  3.478645033001960e-01, -1.263265969743594e-03,  2.923009793787168e-06, -4.206031411729557e-09, -1.243550401269711e-13,
  2.234366878226125e-14, -7.362832591929279e-17,  1.121454867897011e-19,  9.473728040310391e-23, -1.119479347481267e-24,  3.389530407315852e-27, -4.265347034407175e-30,
  3.909610472298665e-01, -1.398365493585798e-03,  3.096016603358432e-06, -3.826710855318234e-09, -2.894467591437986e-12,  2.970880601371225e-14, -7.849866988767105e-17,
  6.749164051142888e-20,  3.118891895651914e-22, -1.577523038695288e-24,  3.252628554406629e-27,  4.128273165480781e-31,  4.364727834299111e-01, -1.535319442074964e-03,
  3.232409914776711e-06, -3.246433561962236e-09, -6.103018375677370e-12,  3.653975127991802e-14, -7.574794392018104e-17, -4.267892185072287e-21,  5.593431318916419e-22,
 -1.860479523595566e-24,  2.028257043240530e-27,  7.794871989497518e-30,  4.843644913218141e-01, -1.672861232231585e-03,  3.324426839834850e-06, -2.452707482724693e-09,
 -9.651036543434003e-12,  4.207872256982046e-14, -6.320881538493098e-17, -1.018526068341194e-19,  7.986644325517210e-22, -1.806050284395260e-24, -5.033676854986644e-28,
  1.670395443807716e-29,  5.345939043461441e-01, -1.809590097988718e-03,  3.364156069241269e-06, -1.439252188434121e-09, -1.339317922245242e-11,  4.546028011081733e-14,
 -3.920149314578124e-17, -2.190557954015824e-19,  9.750355233919104e-22, -1.257587078508889e-24, -4.254077996471690e-27,  2.455948834601593e-29,  5.871104346896828e-01,
 -1.943961184129508e-03,  3.343689979895523e-06, -2.078102417944385e-10, -1.713372890247726e-11,  4.575876872064916e-14, -2.958125713354786e-18, -3.435849662300922e-19,
  1.021317437508116e-21, -1.124690206691431e-25, -8.658787009671727e-27,  2.746888384306568e-29,  6.418536789177218e-01, -2.074276097750970e-03,  3.255326564919190e-06,
  1.229821108607059e-09, -2.062487536871932e-11,  4.206247481373980e-14,  4.488410698358468e-17, -4.564587812297845e-19,  8.675563526912067e-22,  1.614399447577463e-24,
 -1.256390047100786e-26,  2.098615873798677e-29,  6.987516683038917e-01, -2.198674573150161e-03,  3.091832895710318e-06,  2.849580099211260e-09, -2.356859992160053e-11,
  3.357940224411614e-14,  1.017640334137177e-16, -5.324439657610949e-19,  4.571122076140487e-22,  3.721941858084828e-24, -1.426570048470273e-26,  1.758041690870993e-30,
  7.577188228752391e-01, -2.315128182708345e-03,  2.846783325990246e-06,  4.612840399610897e-09, -2.562386404232333e-11,  1.977774501817068e-14,  1.627306167532926e-16,
 -5.421225939081024e-19, -2.305140555606033e-22,  5.769799832779327e-24, -1.181026728045462e-26, -2.997888463401391e-29,  8.186535636100168e-01, -2.421437395315831e-03,
  2.514986623668292e-06,  6.464176203589998e-09, -2.642119322381811e-11,  5.601104128018695e-16,  2.201568034629005e-16, -4.562039186709764e-19, -1.152281462987171e-21,
  7.074122541940935e-24, -3.648169801630284e-27, -6.762055220821762e-29,  8.814355334289775e-01, -2.515233768442251e-03,  2.093016063338303e-06,  8.329443394161018e-09,
 -2.558705204778728e-11, -2.353677814180711e-14,  2.638156219924439e-16, -2.525344346621851e-19, -2.175362294171731e-21,  6.796016923006935e-24,  1.035500715008646e-26,
 -9.651541708782779e-29,  9.459223755647609e-01, -2.593989684489873e-03,  1.579854269246902e-06,  1.011455734660306e-08, -2.278046819703544e-11, -5.113703497954411e-14,
  2.815542973282831e-16,  7.423010905712810e-20, -3.062687590871924e-21,  4.165705284449022e-24,  2.775477323836675e-26, -9.560682773755622e-29,  1.011946019074327e+00,
 -2.655038827634199e-03,  9.776588028778881e-07,  1.170551468032613e-08, -1.774391303924019e-11, -7.985279201590244e-14,  2.608290065816500e-16,  5.013177651877042e-19,
 -3.486189316762003e-21, -1.140687393698980e-24,  4.273593694500872e-26, -4.485709327398179e-29,  1.079308427941582e+00, -2.695611553018463e-03,  2.926430169600173e-07,
  1.297040548051306e-08, -1.036907554736298e-11, -1.062041745134359e-13,  1.913206995931788e-16,  9.675459456605398e-19, -3.086628901453271e-21, -8.523598504485695e-24,
  4.657894091388667e-26,  6.061866256758017e-29,  1.147776785727802e+00, -2.712890407267474e-03, -4.639533633505134e-07,  1.376437348350152e-08, -7.753111690659480e-13,
 -1.257186742203507e-13,  6.867589953280502e-17,  1.368864432320846e-18, -1.594583871372849e-21, -1.605499554646628e-23,  3.041334730141229e-26,  1.933719163410527e-28,
  1.217078116792369e+00, -2.704092244932274e-03, -1.274861805684103e-06,  1.393865448932208e-08,  1.060645673019218e-11, -1.333180653869780e-13, -1.009753817141535e-16,
  1.566735547783172e-18,  9.917441380231264e-22, -2.047201630037368e-23, -9.264087097958746e-27,  2.847783100871841e-28,  1.286893394180860e+00, -2.666584480788400e-03,
 -2.115857242339719e-06,  1.335486010259221e-08,  2.295931969222966e-11, -1.241023752015377e-13, -2.967438078013787e-16,  1.417088947311960e-18,  4.216485746643303e-21,
 -1.799153332477840e-23, -6.363143157112267e-26,  2.429548244669821e-28,  1.356851261729578e+00, -2.598043697242502e-03, -2.955079994917898e-06,  1.190540823354674e-08,
  3.504078618221912e-11, -9.459508243906577e-14, -4.808850559931505e-16,  8.243068268683443e-19,  7.068152530143262e-21, -6.222936647069473e-24, -1.075706527709203e-25,
  1.189854089392877e-29,  1.426521613811789e+00, -2.496664528015186e-03, -3.752870527610520e-06,  9.540184679901303e-09,  4.521488778959641e-11, -4.438582095102020e-14,
 -6.017178227072085e-16, -1.858998379326593e-19,  8.132258342993292e-21,  1.316548778225968e-23, -1.059060351575207e-25, -3.427821170862764e-28,  1.495409441035092e+00,
 -2.361424582516210e-03, -4.462480675943464e-06,  6.297838848535281e-09,  5.160115069379092e-11,  2.213580923997452e-14, -6.045723726978058e-16, -1.400552958031006e-18,
  6.138150051642653e-21,  3.253117155903258e-23, -3.527501473880484e-26, -5.915206172880640e-28,  1.562949572397314e+00, -2.192405909981798e-03, -5.032115224724869e-06,
  2.337291521991030e-09,  5.238179063563805e-11,  9.461298571279760e-14, -4.520864635433654e-16, -2.410244786029807e-18,  8.663697590520832e-22,  3.971763727936835e-23,
  8.474691581204008e-26, -4.494844361231710e-28,  1.628503224428480e+00, -1.991163583475150e-03, -5.408791293432296e-06, -2.038942613009214e-09,  4.627920349514642e-11,
  1.571314716588011e-13, -1.503289711302634e-16, -2.716869612449123e-18, -6.004441898005692e-21,  2.498247529373458e-23,  1.782599984201068e-25,  1.357978060630705e-28,
  1.691357589177263e+00, -1.761115919777190e-03, -5.544402506918553e-06, -6.382436470719911e-09,  3.314700443427050e-11,  1.912937441852538e-13,  2.307178146679112e-16,
 -1.982609232147069e-18, -1.096114776048576e-20, -8.642523189414596e-24,  1.538855108549382e-25,  7.435435649557328e-28,  1.750730008946350e+00, -1.507908033954898e-03,
 -5.404036351953192e-06, -1.013324102779371e-08,  1.450695981356055e-11,  1.824016324383010e-13,  5.611868911922935e-16, -3.367386330638343e-19, -1.041716533192854e-20,
 -4.051216970095845e-23, -1.230143219944769e-27,  7.177981509274330e-28,  1.805778505288697e+00, -1.239672604297589e-03, -4.975918468879654e-06, -1.270444651905845e-08,
 -6.258170857700211e-12,  1.274562036927038e-13,  6.966802414410692e-16,  1.488841036496334e-18, -3.754692702152752e-21, -4.420813666263109e-23, -1.624304171221560e-25,
 -5.120083732306738e-29,  1.855620408851274e+00, -9.670849642479332e-04, -4.281334169266317e-06, -1.361853583889398e-08, -2.439453381463458e-11,  4.114955687834428e-14,
  5.599029707791886e-16,  2.460318143344987e-18,  4.833720348913894e-21, -1.378561361361164e-23, -1.643764177354948e-25, -7.163087419760639e-28,  1.899360390482581e+00,
 -7.030959064878193e-04, -3.381702234313549e-06, -1.267327278427930e-08, -3.513510010066402e-11, -4.564712470565220e-14,  2.137987472798688e-16,  1.974009007508393e-18,
  8.803915487426553e-21,  2.254142187291351e-23, -8.009524561028459e-27, -4.518176243330969e-28,  1.936128150516690e+00, -4.622419167583439e-04, -2.379166754665592e-06,
 -1.008372455351565e-08, -3.567144729557629e-11, -9.837865793840415e-14, -1.454451787618015e-16,  4.826233098995675e-19,  5.446429897785089e-21,  2.900585919704051e-23,
  1.076095059864173e-25,  2.462156366641532e-28,  1.965124337277179e+00, -2.594951605826569e-04, -1.407420925890995e-06, -6.525019901509583e-09, -2.688307351443063e-11,
 -9.850694323120896e-14, -3.109425384971250e-16, -7.567824519918224e-19, -7.026709592831389e-22,  6.664013465821391e-24,  5.915099628396090e-26,  3.211330067103279e-28,
  1.985671267705702e+00, -1.087270989263672e-04, -6.116685521759972e-07, -3.012129309524018e-09, -1.363479298237114e-11, -5.778640806952431e-14, -2.305729926899293e-16,
 -8.636615479063220e-19, -2.999935171521709e-21, -9.384167410353780e-24, -2.449362603003322e-26, -3.895309565878613e-29,  1.997265671700901e+00, -2.097906380052120e-05,
 -1.204617039170699e-07, -6.131062421063581e-10, -2.915247431952863e-12, -1.325138753245539e-14, -5.827232253472311e-17, -2.495771351340423e-19, -1.045229805359099e-21,
 -4.290228124919536e-24, -1.727892860612222e-26, -6.830357047605771e-29,  3.158246490291826e-04, -1.263215272663232e-06,  3.788851332972136e-09, -1.010050322221142e-11,
  2.523698751045491e-14, -6.052775900843117e-17,  1.410715793685364e-19, -3.220891317513005e-22,  7.232334941065514e-25, -1.604911213067397e-27,  3.517928953013034e-30,
 -7.669264264059853e-33,  2.842392616345215e-03, -1.136146065645805e-05,  3.402608698593563e-08, -9.046572504227467e-11,  2.250928711396094e-13, -5.366161303402223e-16,
  1.240458752947808e-18, -2.801871677737661e-21,  6.205737504406994e-24, -1.353856687709847e-26,  2.905999097201584e-29, -6.178805390193168e-32,  7.895368715553396e-03,
 -3.151798612389775e-05,  9.410778502798220e-08, -2.488581011036729e-10,  6.139663725233367e-13, -1.445758814444968e-15,  3.285683419842952e-18, -7.255189648586467e-21,
  1.560094216357766e-23, -3.277285436065214e-26,  6.701967671716065e-29, -1.341240805326176e-31,  1.547441412440077e-02, -6.165243255575671e-05,  1.832466165866989e-07,
 -4.806123482881183e-10,  1.170383086406854e-12, -2.703550689771574e-15,  5.979730492512212e-18, -1.272056531880462e-20,  2.599683050773087e-23, -5.096535919830959e-26,
  9.462612072942476e-29, -1.651911952930607e-31,  2.557897227430666e-02, -1.016431849739988e-04,  3.002571746436559e-07, -7.787585712089274e-10,  1.862643037854895e-12,
 -4.187558160305714e-15,  8.902168207500442e-18, -1.788138110587559e-20,  3.357840085024789e-23, -5.781094462929987e-26,  8.587756325821884e-29, -9.396198684184504e-32,
  3.820820955621403e-02, -1.513260669860830e-04,  4.435507992233478e-07, -1.134058447623032e-09,  2.649452330476247e-12, -5.742372300905550e-15,  1.153889835809222e-17,
 -2.121102733340416e-20,  3.424628517697547e-23, -4.341202250680527e-26,  1.984519752997200e-29,  1.152722162541330e-31,  5.336093406857083e-02, -2.104925767509908e-04,
  6.111288914409058e-07, -1.535057823987755e-09,  3.480794809929977e-12, -7.186413188425550e-15,  1.332115427366782e-17, -2.115675349675221e-20,  2.436560555210366e-23,
 -9.784841505461271e-28, -1.106247826425771e-28,  4.478981844948300e-31,  7.103549044626681e-02, -2.788876445998258e-04,  8.005749224684839e-07, -1.968159645020390e-09,
  4.299068900039546e-12, -8.320528050382627e-15,  1.367302811690405e-17, -1.635315285158092e-20,  1.578358387211612e-24,  7.052264823708310e-26, -2.916298696784318e-28,
  8.234124937556710e-31,  9.122962821425815e-02, -3.562068876682995e-04,  1.009045425074248e-06, -2.417722369516569e-09,  5.040520770940095e-12, -8.938416477953200e-15,
  1.206644174995797e-17, -5.853013702571946e-21, -3.440531818405918e-23,  1.642185680556259e-25, -4.843306191732525e-28,  1.096590100599318e-30,  1.139403404396838e-01,
 -4.420933323653107e-04,  1.233260359557117e-06, -2.866190419154806e-09,  5.637010532550311e-12, -8.838890384528665e-15,  8.081973944204934e-18,  1.064046873204348e-20,
 -8.113916027681074e-23,  2.641791622646537e-25, -6.263750927917116e-28,  1.080917194028354e-30,  1.391636686914228e-01, -5.361335713909320e-04,  1.469493379821519e-06,
 -3.294264799300658e-09,  6.018152799122422e-12, -7.839928451347062e-15,  1.473287428406336e-18,  3.256040914887990e-20, -1.330138314425510e-22,  3.457643284254813e-25,
 -6.401399167744521e-28,  5.962755428976981e-31,  1.668944694331986e-01, -6.378533186025822e-04,  1.713562697808533e-06, -3.681123847984496e-09,  6.113876096036459e-12,
 -5.794406542221122e-15, -7.767971647591458e-18,  5.830689078682971e-20, -1.811998853146788e-22,  3.779181001044675e-25, -4.485031880737490e-28, -4.625695533673897e-31,
  1.971261359488563e-01, -7.467123227163214e-04,  1.960823466341910e-06, -4.004706128667652e-09,  5.857446207673845e-12, -2.607266956719581e-15, -1.935103171737174e-17,
  8.515147678024748e-20, -2.140922800862996e-22,  3.277199577543848e-25,  2.412831751723278e-30, -2.047309271507243e-30,  2.298502686954391e-01, -8.620986002110303e-04,
  2.206162884930502e-06, -4.242069783782770e-09,  5.188995276953340e-12,  1.746281943929149e-15, -3.263419360789154e-17,  1.092500412348450e-19, -2.183769357249446e-22,
  1.672537856659759e-25,  7.158915604995950e-28, -3.886202430501975e-30,  2.650562855654744e-01, -9.833219497207327e-04,  2.443999596351907e-06, -4.369845178480632e-09,
  4.059589238656523e-12,  7.202182992458603e-15, -4.658954722007058e-17,  1.258017212235555e-19, -1.808071925554588e-22, -1.175363334948421e-25,  1.617312327560480e-27,
 -5.449989288717365e-30,  3.027309618734108e-01, -1.109606715848015e-03,  2.668289403357536e-06, -4.364800306616608e-09,  2.435848170146925e-12,  1.358953450868996e-14,
 -5.979317690721230e-17,  1.293925113179921e-19, -9.071429400945572e-23, -5.168893824433442e-25,  2.534115380870238e-27, -5.986137825235465e-30,  3.428578879157801e-01,
 -1.240083781381710e-03,  2.872539917508852e-06, -4.204541043382948e-09,  3.051034990681797e-13,  2.061457610170725e-14, -7.045168421465779e-17,  1.145580519792833e-19,
  5.683008914575282e-23, -9.877774745024167e-25,  3.192740957297434e-27, -4.653251424599885e-30,  3.854168296383792e-01, -1.373781785679556e-03,  3.049837482242411e-06,
 -3.868370627937108e-09, -2.318972471716601e-12,  2.784859134242055e-14, -7.647753603049500e-17,  7.658856486686247e-20,  2.574412631198677e-22, -1.447421130884910e-24,
  3.243812533670415e-27, -7.757220904057541e-31,  4.303829752201551e-01, -1.509617596690094e-03,  3.192890618520491e-06, -3.338334276115807e-09, -5.390402343722390e-12,
  3.472232788758040e-14, -7.562681275315071e-17,  1.257574418773967e-20,  4.939033154785112e-22, -1.773096646148593e-24,  2.326281374950663e-27,  5.789588402894660e-30,
  4.777260471942040e-01, -1.646386109134469e-03,  3.294095352970850e-06, -2.600474814553096e-09, -8.824848539329878e-12,  4.053031631466394e-14, -6.571268065060810e-17,
 -7.733812248880851e-20,  7.334546192205307e-22, -1.812220703291443e-24,  1.768397166083651e-28,  1.423226153008758e-29,  5.274092560158216e-01, -1.782749507727168e-03,
  3.345629130425898e-06, -1.646322552448802e-09, -1.249386075729666e-11,  4.444932430164801e-14, -4.490526764416819e-17, -1.886097929365721e-19,  9.269543388597118e-22,
 -1.406749088912160e-24, -3.219461156778589e-27,  2.244115126065737e-29,  5.793880667115623e-01, -1.917226230043914e-03,  3.339581598534048e-06, -4.746355631916646e-10,
 -1.622002366694982e-11,  4.557601616609657e-14, -1.212202615396065e-17, -3.110320782107907e-19,  1.011324534503487e-21, -4.347626761367614e-25, -7.459750018464686e-27,
  2.694148676886758e-29,  6.336087453829550e-01, -2.048179999490626e-03,  3.268132369274816e-06,  9.066073391594525e-10, -1.977387250699155e-11,  4.298951059388310e-14,
  3.249998266502048e-17, -4.278622233450092e-19,  9.168584364884455e-22,  1.131086062273118e-24, -1.158425902933139e-26,  2.339158316084857e-29,  6.900066469237162e-01,
 -2.173809488921098e-03,  3.123787849790175e-06,  2.477982867542553e-09, -2.287378703804753e-11,  3.584461066638467e-14,  8.707974804581446e-17, -5.157824023611081e-19,
  5.808667332117788e-22,  3.154744467431235e-24, -1.404938361434240e-26,  7.906652062740602e-30,  7.485041994552680e-01, -2.292139438037110e-03,  2.899691246390857e-06,
  4.206230041282906e-09, -2.519048683345543e-11,  2.350048169596625e-14,  1.474784758237473e-16, -5.462692275054045e-19, -3.159721305347472e-23,  5.273782776376470e-24,
 -1.292290794787349e-26, -2.069011754943467e-29,  8.090085349498307e-01, -2.401014405738589e-03,  2.590021591136417e-06,  6.041809399125112e-09, -2.635820859262217e-11,
  5.686656695107588e-15,  2.069049231065939e-16, -4.890360487561468e-19, -9.009315182351755e-22,  6.871473320019111e-24, -6.414306679430831e-27, -5.801793679701501e-29,
  8.714087097801244e-01, -2.498096819884139e-03,  2.190498600252028e-06,  7.916626149738164e-09, -2.599508429356511e-11, -1.729769217771592e-14,  2.558073977299487e-16,
 -3.181598174594360e-19, -1.924262579360870e-21,  7.126518558074963e-24,  6.204692573061911e-27, -9.176913169321546e-29,  9.355724543542974e-01, -2.580871623210870e-03,
  1.699009472756742e-06,  9.742255585930089e-09, -2.373552413163607e-11, -4.436571918298544e-14,  2.822846804541257e-16, -2.117053977567121e-20, -2.893772163193336e-21,
  5.189662166646911e-24,  2.339755063714764e-26, -1.018589267510701e-28,  1.001342388952876e+00, -2.646660637994596e-03,  1.116369974782512e-06,  1.140918029137698e-08,
 -1.927729819757883e-11, -7.343708540057006e-14,  2.733002457047833e-16,  3.894283437666339e-19, -3.497018637444336e-21,  5.228659946538782e-25,  4.028905070053889e-26,
 -6.581217659550840e-29,  1.068531645576135e+00, -2.692650809572841e-03,  4.472231895338299e-07,  1.278776609275517e-08, -1.244510651439568e-11, -1.012988140896619e-13,
  2.169856377474714e-16,  8.642284683318018e-19, -3.359384941267836e-21, -6.616553405842506e-24,  4.853975877842379e-26,  2.857120351978302e-29,  1.136918846388455e+00,
 -2.715941745578018e-03, -2.989379603162882e-07,  1.373195599139254e-08, -3.270129887021026e-12, -1.236168054532150e-13,  1.062046084556478e-16,  1.308841031572669e-18,
 -2.148687965939396e-21, -1.467631928855727e-23,  3.831243301162391e-26,  1.648310398071753e-28,  1.206242413166213e+00, -2.713619402430670e-03, -1.106668107519142e-06,
  1.408691020574543e-08,  7.919430323674823e-12, -1.352121481879118e-13, -5.677364734976943e-17,  1.586632494871451e-18,  2.511042431512518e-22, -2.059178564319001e-23,
  3.261873338530202e-27,  2.828949151178961e-28,  1.276194226075790e+00, -2.682864251588797e-03, -1.953477949927050e-06,  1.370197964087212e-08,  2.040934382788185e-11,
 -1.307334533902350e-13, -2.552770789757588e-16,  1.541183859921624e-18,  3.525675716475876e-21, -2.030955698031150e-23, -5.195421204849413e-26,  2.862460352068982e-28,
  1.346412723732726e+00, -2.621103494330560e-03, -2.808915622112305e-06,  1.245030682944361e-08,  3.303547275113986e-11, -1.058340348882751e-13, -4.546775188694158e-16,
  1.046075285343020e-18,  6.767016806696633e-21, -1.049169300613695e-23, -1.052810704710326e-25,  9.231016251563614e-29,  1.416475652092460e+00, -2.526217337492777e-03,
 -3.634079522072214e-06,  1.025573527774347e-08,  4.418249119757384e-11, -5.885969679979431e-14, -6.032145093551863e-16,  8.106975819910135e-20,  8.526498096224922e-21,
  8.646448242759508e-24, -1.195485156147619e-25, -2.745192569916634e-28,  1.485892841502636e+00, -2.396808067686072e-03, -4.381940878813908e-06,  7.126197706552314e-09,
  5.189571231721100e-11,  7.178753164669539e-15, -6.408641439385057e-16, -1.185717820087882e-18,  7.277544840497600e-21,  3.059371706426938e-23, -6.170148049226505e-26,
 -6.057172653216381e-28,  1.554099632847195e+00, -2.232536254071456e-03, -4.998978602124841e-06,  3.189925857100517e-09,  5.416010504255433e-11,  8.295754469297175e-14,
 -5.189658023255118e-16, -2.359030206432624e-18,  2.352125931288770e-21,  4.267577928405977e-23,  6.227542710508767e-26, -5.708461682627399e-28,  1.620451892558588e+00,
 -2.034518957688391e-03, -5.428712801058503e-06, -1.273556594695910e-09,  4.937948361037935e-11,  1.525898765642164e-13, -2.289462375598261e-16, -2.893236361203521e-18,
 -4.975648123106966e-21,  3.219218023055003e-23,  1.811824237331552e-25, -7.334945094237428e-30,  1.684223943107019e+00, -1.805768188173408e-03, -5.617682457013695e-06,
 -5.821196135452089e-09,  3.702354913367567e-11,  1.961249360985023e-13,  1.702562291630874e-16, -2.337092072295966e-18, -1.115360047865933e-20, -1.833724338431747e-24,
  1.864665424853523e-25,  7.313597904580717e-28,  1.744611148044752e+00, -1.551622492460660e-03, -5.524119831042081e-06, -9.871217522580442e-09,  1.828871320231378e-11,
  1.957179588214842e-13,  5.468723714333367e-16, -6.933678447241880e-19, -1.186845012866277e-20, -3.988273771764653e-23,  3.386653632635059e-26,  8.775837037413416e-28,
  1.800739232497873e+00, -1.280091267999000e-03, -5.128885509541190e-06, -1.278326187892800e-08, -3.538543405868205e-12,  1.446616876704449e-13,  7.364374798659228e-16,
  1.341971042330352e-18, -5.463305721307322e-21, -5.070890969366522e-23, -1.615091593139044e-25,  9.975850748509408e-29,  1.851682523359931e+00, -1.001995895227164e-03,
 -4.447068886100505e-06, -1.400151060699278e-08, -2.343149774608988e-11,  5.543086832748692e-14,  6.308733686093256e-16,  2.605725073074186e-18,  4.211344898880513e-21,
 -2.100685956266252e-23, -1.970432815276396e-25, -7.652280252571558e-28,  1.896492922871192e+00, -7.307674656798680e-04, -3.537183648603378e-06, -1.324243975739009e-08,
 -3.599208614485470e-11, -3.982010618649580e-14,  2.731364697741398e-16,  2.268614999263883e-18,  9.604474813706391e-21,  2.178201340562402e-23, -3.103205560340092e-26,
 -5.989088009115645e-28,  1.934240335922006e+00, -4.817691229513798e-04, -2.503661439088314e-06, -1.067039299447903e-08, -3.767272672049771e-11, -1.016864914327986e-13,
 -1.293287011512533e-16,  6.744681819976975e-19,  6.570699528498769e-21,  3.352327580516493e-23,  1.181418931630804e-25,  2.297235904512141e-28,  1.964063331474651e+00,
 -2.710751935418560e-04, -1.488368287559250e-06, -6.971322905004847e-09, -2.892956710001781e-11, -1.062261452131173e-13, -3.324077565214724e-16, -7.749439760593414e-19,
 -4.165902555469179e-22,  9.332831363438534e-24,  7.481104002031801e-26,  3.927088122808766e-28,  1.985226338337258e+00, -1.137688280447051e-04, -6.491621799304778e-07,
 -3.239840911001942e-09, -1.484787485870180e-11, -6.362151693658953e-14, -2.561516412284566e-16, -9.652571102574022e-19, -3.355800158165851e-21, -1.039665538523161e-23,
 -2.608599443426484e-26, -3.278300917364888e-29,  1.997179780315714e+00, -2.197300012665121e-05, -1.281078412936527e-07, -6.619488559798200e-10, -3.194846737648902e-12,
 -1.473770837074747e-14, -6.575295020092183e-17, -2.856351640718250e-19, -1.212878647197482e-21, -5.045430429937275e-24, -2.058354501450303e-26, -8.236662533948638e-29,
  3.108316514928051e-04, -1.233382512515587e-06,  3.670028684405617e-09, -9.706214926058135e-12,  2.405957230391292e-14, -5.724770027041982e-17,  1.323685963766206e-19,
 -2.998435767569504e-22,  6.679103479744528e-25, -1.470716484465283e-27,  3.197260395635698e-30, -6.920423732083759e-33,  2.797484401089417e-03, -1.109353389538980e-05,
  3.296175820218664e-08, -8.694850640246915e-11,  2.146520180791125e-13, -5.077645516621665e-16,  1.164714814837954e-18, -2.610867159785642e-21,  5.738633302319035e-24,
 -1.242876931161128e-26,  2.647256825122794e-29, -5.592684105059834e-32,  7.770783815303006e-03, -3.077690420372947e-05,  9.117948807810072e-08, -2.392617440906837e-10,
  5.858235924758578e-13, -1.369284815023901e-15,  3.089353588046845e-18, -6.774330600098042e-21,  1.446798388695357e-23, -3.020653674109982e-26,  6.138217881129785e-29,
 -1.223180028200624e-31,  1.523070025757694e-02, -6.020921473091264e-05,  1.775898657716000e-07, -4.623111088773994e-10,  1.117718836416180e-12, -2.564218932901495e-15,
  5.634930546058528e-18, -1.191730627917791e-20,  2.422848912640196e-23, -4.732213277655282e-26,  8.762154009178495e-29, -1.533363481901858e-31,  2.517714517051059e-02,
 -9.927800763986692e-05,  2.910881588752304e-07, -7.496148515522235e-10,  1.780988459484705e-12, -3.979794747400520e-15,  8.416224467118453e-18, -1.683951650031752e-20,
  3.155804155039659e-23, -5.445859863634895e-26,  8.173977066351500e-29, -9.396110970408060e-32,  3.760991691861916e-02, -1.478313833783901e-04,  4.301927035037670e-07,
 -1.092571142899589e-09,  2.537326747341511e-12, -5.472443249271356e-15,  1.096009813006452e-17, -2.013998887868401e-20,  3.269889184766695e-23, -4.252455873099708e-26,
  2.434277748921662e-29,  8.983266745412530e-32,  5.252862648179989e-02, -2.056762924303114e-04,  5.930376665441421e-07, -1.480497762181724e-09,  3.340216094768350e-12,
 -6.873726111149944e-15,  1.273966980064280e-17, -2.037843428217461e-20,  2.425531599060927e-23, -5.027210413134625e-27, -9.224096393216410e-29,  3.889234069838685e-31,
  6.993260112080707e-02, -2.725763600684353e-04,  7.773642831239335e-07, -1.900688153029221e-09,  4.135902815992761e-12, -7.997862060492543e-15,  1.321621296154344e-17,
 -1.626420643597853e-20,  3.915691762178157e-24,  5.955582582489028e-26, -2.573452923232616e-28,  7.363482595173386e-31,  8.982076356126187e-02, -3.482492174042443e-04,
  9.805107980903479e-07, -2.338488507068258e-09,  4.864634492500386e-12, -8.650907566994570e-15,  1.188800641574075e-17, -6.863040261679548e-21, -2.883078512497516e-23,
  1.457834381611050e-25, -4.380830450102104e-28,  1.006364777292272e-30,  1.121914835924894e-01, -4.323633067282695e-04,  1.199401428273303e-06, -2.777401838071968e-09,
  5.462195051529023e-12, -8.641632594517981e-15,  8.344952521596992e-18,  8.191439386212236e-21, -7.206836467127917e-23,  2.400614304161319e-25, -5.798654660135352e-28,
  1.032347009063885e-30,  1.370423982310885e-01, -5.245341240278702e-04,  1.430534777595464e-06, -3.199226520432789e-09,  5.861779228491155e-12, -7.794098907495666e-15,
  2.327225033476804e-18,  2.849823722568445e-20, -1.210207442750851e-22,  3.206995442934083e-25, -6.127380176240603e-28,  6.459363792345314e-31,  1.643701957325776e-01,
 -6.243198568611188e-04,  1.669972288106359e-06, -3.584238521476466e-09,  5.996252558653060e-12, -5.961889518883921e-15, -6.214535859341764e-18,  5.272267673180970e-20,
 -1.679221006864282e-22,  3.596319262598756e-25, -4.643627775469722e-28, -2.644086557974086e-31,  1.941703577196194e-01, -7.312163717774129e-04,  1.913327507280621e-06,
 -3.911428588949652e-09,  5.800845789768462e-12, -3.043844081719312e-15, -1.706093094337363e-17,  7.848913962711069e-20, -2.023133208397175e-22,  3.261254383845740e-25,
 -7.948742052311062e-29, -1.683217273968889e-30,  2.264368524991820e-01, -8.446515026915148e-04,  2.155757208578717e-06, -4.158807983302164e-09,  5.216332431733657e-12,
  9.989854131978468e-16, -2.967208263431534e-17,  1.023635184726431e-19, -2.118802345692391e-22,  1.926153296081322e-25,  5.557189037373274e-28, -3.401095392178767e-30,
  2.611617712247251e-01, -9.639785907517022e-04,  2.391955734667516e-06, -4.303798968328894e-09,  4.192733331549600e-12,  6.125645963904141e-15, -4.314865041305823e-17,
  1.199602151732368e-19, -1.839305445334557e-22, -5.749903798592956e-26,  1.388023261307035e-27, -4.973578002461846e-30,  2.983348968776176e-01, -1.088469228329555e-03,
  2.616154360979952e-06, -4.323729154973783e-09,  2.693580194354313e-12,  1.219762961677913e-14, -5.621348748545825e-17,  1.262109779247787e-19, -1.075605942302369e-22,
 -4.207224158917756e-25,  2.276068520298300e-27, -5.734389854601053e-30,  3.379431940415402e-01, -1.217305166280852e-03,  2.822128025944363e-06, -4.196451830340228e-09,
  7.007473603398049e-13,  1.896240069740452e-14, -6.722377134699859e-17,  1.158318974688355e-19,  2.351877839533483e-23, -8.642433294939849e-25,  2.982218070745210e-27,
 -4.893660106466812e-30,  3.799702050637206e-01, -1.349569356686643e-03,  3.003212472410266e-06, -3.901117394313360e-09, -1.780176940645881e-12,  2.603974788939994e-14,
 -7.422537790899262e-17,  8.401792790312004e-20,  2.076586580828590e-22, -1.318651780533126e-24,  3.187597211201814e-27, -1.745091444111692e-30,  4.243953353687489e-01,
 -1.484236125838671e-03,  3.152335726273687e-06, -3.419123607413665e-09, -4.714068717085427e-12,  3.291323745945927e-14, -7.506288846571859e-17,  2.737777118927565e-20,
  4.318032125221337e-22, -1.675489746279510e-24,  2.541133209119305e-27,  4.014184928677484e-30,  4.711930073390032e-01, -1.620160508414705e-03,  3.262068940276304e-06,
 -2.735273919222190e-09, -8.030175207987252e-12,  3.892981833844550e-14, -6.755935152895083e-17, -5.490886584352485e-20,  6.684865193606075e-22, -1.793323437132250e-24,
  7.509366162070090e-28,  1.188670904141833e-29,  5.203316582214299e-01, -1.756066829322541e-03,  3.324702991275726e-06, -1.839172725015205e-09, -1.161606218124130e-11,
  4.331152921905533e-14, -4.977884583290611e-17, -1.597805034340807e-19,  8.742253841564258e-22, -1.516433221826473e-24, -2.281092609713544e-27,  2.019787913748533e-29,
  5.717725528873587e-01, -1.890536702450699e-03,  3.332358870538323e-06, -7.268824818360170e-10, -1.531209921970907e-11,  4.518422124587534e-14, -2.038060111819349e-17,
 -2.789754024688775e-19,  9.905853515748463e-22, -7.097136132569513e-25, -6.295279200683916e-27,  2.591586676349270e-29,  6.254683768983650e-01, -2.021996736278052e-03,
  3.277141864956001e-06,  5.971420675696311e-10, -1.890723540836894e-11,  4.362909830844887e-14,  2.093608864891053e-17, -3.979586333414332e-19,  9.494896751421623e-22,
  6.888114383090877e-25, -1.051832593720188e-26,  2.492349745486550e-29,  6.813615691895245e-01, -2.148706409417881e-03,  3.151351772590221e-06,  2.117846093478257e-09,
 -2.213715419319172e-11,  3.776342322671253e-14,  7.291437369094934e-17, -4.954852186848877e-19,  6.844203633586235e-22,  2.601309703869784e-24, -1.358503264851621e-26,
  1.303111349471025e-29,  7.393823468120354e-01, -2.268746823892070e-03,  2.947763839207569e-06,  3.807129440624097e-09, -2.468632116313274e-11,  2.685647621885679e-14,
  1.321966027929035e-16, -5.443440288179470e-19,  1.487587692508906e-22,  4.741251048301418e-24, -1.364087246843405e-26, -1.206936872034409e-29,  7.994463667418725e-01,
 -2.380011385217802e-03,  2.659997530205293e-06,  5.621253019408828e-09, -2.619594328442814e-11,  1.048502765078727e-14,  1.928451037288407e-16, -5.139622257309342e-19,
 -6.587654055872079e-22,  6.566769864995857e-24, -8.748073144637491e-27, -4.802911701004907e-29,  8.614519621277134e-01, -2.480199927830690e-03,  2.282992241439643e-06,
  7.498267592124213e-09, -2.628040089718579e-11, -1.127193588887237e-14,  2.460757182152894e-16, -3.755912346039785e-19, -1.664196991175958e-21,  7.295805460766846e-24,
  2.308857256230175e-27, -8.502047228569823e-29,  9.252768832241027e-01, -2.566818440269390e-03,  1.813609839468169e-06,  9.355756396449636e-09, -2.455519153021715e-11,
 -3.760828516512208e-14,  2.804248185482568e-16, -1.106102091119606e-19, -2.691188294201026e-21,  6.034868106580418e-24,  1.884261704801169e-26, -1.046268277043676e-28,
  9.907744678714834e-01, -2.637187390258947e-03,  1.251382213178795e-06,  1.108935345025858e-08, -2.067962986158711e-11, -6.675964843316825e-14,  2.826425878175287e-16,
  2.781299578666288e-19, -3.449934765124792e-21,  2.071124154111472e-24,  3.699720489131539e-26, -8.319653123074728e-29,  1.057769164799540e+00, -2.688462748449035e-03,
  5.994157336998638e-07,  1.257272753376228e-08, -1.441710983815698e-11, -9.581313219937507e-14,  2.396459047557529e-16,  7.532936453925466e-19, -3.562413732318400e-21,
 -4.659077341152165e-24,  4.910756767472006e-26, -2.506431946088686e-30,  1.126051338525183e+00, -2.717675191784797e-03, -1.345495256764235e-07,  1.366000602937311e-08,
 -5.714050625314174e-12, -1.206363711969168e-13,  1.418123050322991e-16,  1.231938855874678e-18, -2.647787992138666e-21, -1.300819987525577e-23,  4.485334748448685e-26,
  1.318771766939255e-28,  1.195371302241528e+00, -2.721794627444324e-03, -9.369543582771222e-07,  1.419192822669670e-08,  5.205161958246230e-12, -1.360413826778078e-13,
 -1.234656572302856e-17,  1.582856337274995e-18, -4.848758601604330e-22, -2.021515878239750e-23,  1.548267692483620e-26,  2.709900991591397e-28,  1.265432562345253e+00,
 -2.697829029627743e-03, -1.787182218976459e-06,  1.400729380091377e-08,  1.773696663690509e-11, -1.363302059602339e-13, -2.106570571965456e-16,  1.641931369063366e-18,
  2.760256740925594e-21, -2.212535980555466e-23, -3.859700471391397e-26,  3.190266417200985e-28,  1.335884325797509e+00, -2.642968383599604e-03, -2.656412277535785e-06,
  1.296135844251386e-08,  3.081216682351885e-11, -1.163707223437527e-13, -4.224183100979459e-16,  1.255773196214836e-18,  6.314707195713086e-21, -1.459813967029751e-23,
 -9.946281246461308e-26,  1.716708903977361e-28,  1.406313433747708e+00, -2.554785775309493e-03, -3.506810571510820e-06,  1.095245232353541e-08,  4.286087008725836e-11,
 -7.327851970873076e-14, -5.970846003543802e-16,  3.579529076692403e-19,  8.748998066396380e-21,  3.646618232911497e-24, -1.298304536061880e-25, -1.904697785048098e-28,
  1.476236059704291e+00, -2.431507416164689e-03, -4.291442516660968e-06,  7.956831215560150e-09,  5.188293103300835e-11, -8.573072526210403e-15, -6.706420274238561e-16,
 -9.357428242497975e-19,  8.328079715892908e-21,  2.759400411910351e-23, -8.820254713671941e-26, -5.944793240192531e-28,  1.545089767565694e+00, -2.272360113310765e-03,
 -4.955447622842335e-06,  4.069061726917114e-09,  5.568940390238941e-11,  6.971967207664289e-14, -5.837308013000246e-16, -2.258751324004057e-18,  3.926930784001048e-21,
  4.463078028174619e-23,  3.466555508062269e-26, -6.818083495532460e-28,  1.612226879797617e+00, -2.077996129734894e-03, -5.439155383525804e-06, -4.593968756748972e-10,
  5.236968392571274e-11,  1.461061682827807e-13, -3.120017671685910e-16, -3.032519133133595e-18, -3.686787757122159e-21,  3.938528317413084e-23,  1.772502171073890e-25,
 -1.751009262272569e-28,  1.676910559635863e+00, -1.850978695399750e-03, -5.683852450841994e-06, -5.197240320403458e-09,  4.098140032092078e-11,  1.993854832586048e-13,
  9.982153845004234e-17, -2.693561722806536e-18, -1.107770957798863e-20,  6.256260922550146e-24,  2.176518584351294e-25,  6.789670668114876e-28,  1.738315529365958e+00,
 -1.596283992931655e-03, -5.640687260935349e-06, -9.546577506218521e-09,  2.233252180254979e-11,  2.085656924341346e-13,  5.219274759314518e-16, -1.095790939535984e-18,
 -1.327011533369299e-20, -3.770939615595903e-23,  7.593360079950381e-26,  1.032972460064717e-27,  1.795535832668858e+00, -1.321736684942554e-03, -5.282525730825782e-06,
 -1.281575999081495e-08, -4.656304845881784e-13,  1.627656030552419e-13,  7.712818471435346e-16,  1.136701814043597e-18, -7.403572177914687e-21, -5.702783123953300e-23,
 -1.530319356757049e-25,  2.926875208432061e-28,  1.847602313682311e+00, -1.038250802468575e-03, -4.617297119566819e-06, -1.436669790214507e-08, -2.216548545359338e-11,
  7.146182622222726e-14,  7.055954343947189e-16,  2.726800538028340e-18,  3.305025231748818e-21, -2.957114699723774e-23, -2.313444356781921e-25, -7.888421462858076e-28,
  1.893512237746962e+00, -7.597104199272369e-04, -3.699573232968187e-06, -1.382430595151293e-08, -3.671760776939333e-11, -3.246713182896657e-14,  3.410763579715085e-16,
  2.588210620002846e-18,  1.035948985793648e-20,  1.996460674792076e-23, -6.110036803653761e-26, -7.721918160537536e-28,  1.932272375225862e+00, -5.023209959349642e-04,
 -2.635390377550899e-06, -1.128958824225715e-08, -3.973583809804220e-11, -1.045388510951212e-13, -1.073118761432892e-16,  9.049712858718869e-19,  7.864955530214909e-21,
  3.844199531513501e-23,  1.275273033067717e-25,  1.929753240261557e-28,  1.962954675661919e+00, -2.833247965006433e-04, -1.574872934421100e-06, -7.451633021936770e-09,
 -3.113563182866506e-11, -1.144654869774361e-13, -3.542379907339816e-16, -7.822864025016855e-19, -2.236424538666577e-23,  1.269475236174546e-23,  9.390059648034592e-26,
  4.772493107919351e-28,  1.984760624370419e+00, -1.191217753911852e-04, -6.895087646782696e-07, -3.487929785254010e-09, -1.618403500163645e-11, -7.010597038974132e-14,
 -2.847399568220364e-16, -1.078835233902259e-18, -3.749184494642025e-21, -1.146614615243658e-23, -2.730970654372247e-26, -2.192882516921769e-29,  1.997089787024559e+00,
 -2.303052837260420e-05, -1.363679451049055e-07, -7.155129793269352e-10, -3.506052833404263e-12, -1.641631205301755e-14, -7.432258565941722e-17, -3.275197255045287e-19,
 -1.410251040975960e-21, -5.946060665578924e-24, -2.457294445674164e-26, -9.953757266281675e-29,  };
  constexpr double w[18048] = {  6.611199734704135e-02, -1.827808339464814e-04,  5.278285910382121e-07, -1.576917595695845e-09,  4.824501282383287e-12,
 -1.498350413574845e-14,  4.692275281346493e-17, -1.474860086971515e-19,  4.638662320091613e-22, -1.457133760663297e-24,  4.566575123127105e-27, -1.426947248003276e-29,
  6.589826704350721e-02, -2.523131032213969e-04,  1.124878271742986e-06, -5.092716897909727e-09,  2.254565597756018e-11, -9.715706666700591e-14,  4.087041169655313e-16,
 -1.684253417534452e-18,  6.819508246094553e-21, -2.719212745032130e-23,  1.069677580018514e-25, -4.157109862773525e-28,  6.547374860986856e-02, -3.897411175858421e-04,
  2.521894431702444e-06, -1.520902259488953e-08,  8.610568086902269e-11, -4.644440672452573e-13,  2.410744342711821e-15, -1.212242482705378e-17,  5.933562520968618e-20,
 -2.837140765359613e-22,  1.328906220460660e-24, -6.111024749067658e-27,  6.484423836619917e-02, -5.918493181097601e-04,  5.110299321867449e-06, -3.896468471358539e-08,
  2.724777095507134e-10, -1.786814831788494e-12,  1.113603817573537e-14, -6.655551718004057e-17,  3.839185596720164e-19, -2.147810367047152e-21,  1.169719659081412e-23,
 -6.219833513863869e-26,  6.401821495523785e-02, -8.539550750067755e-04,  9.442237660212931e-06, -8.894780565316921e-08,  7.531033871300904e-10, -5.891041917493800e-12,
  4.329296949065482e-14, -3.022832335637483e-16,  2.021475197377754e-18, -1.302507350613239e-20,  8.123708592114607e-23, -4.922257083389070e-25,  6.300659189102863e-02,
 -1.170069313930952e-03,  1.619141087912545e-05, -1.853478005674194e-07,  1.871120673112063e-09, -1.721229473744781e-11,  1.471829519233228e-13, -1.185616251275000e-15,
  9.082584930452563e-18, -6.663594601335653e-20,  4.707514895898485e-22, -3.215869087365938e-24,  6.182240603768933e-02, -1.533097610978504e-03,  2.610529521073967e-05,
 -3.581057572014354e-07,  4.256816289797823e-09, -4.552788011026766e-11,  4.482370689539962e-13, -4.124573598326771e-15,  3.585675760163983e-17, -2.968626689197099e-19,
  2.355050634992577e-21, -1.798824205112343e-23,  6.048045619726242e-02, -1.935071755233161e-03,  3.995205368799171e-05, -6.487610249251268e-07,  8.984469158358565e-09,
 -1.106574288944413e-10,  1.243343081508220e-12, -1.296173400472769e-14,  1.268801700342532e-16, -1.176619482512431e-18,  1.040755854642932e-20, -8.827550293865290e-23,
  5.899690769414342e-02, -2.367400651039727e-03,  5.846572269827106e-05, -1.111600320076483e-06,  1.776716674031454e-08, -2.499013443738292e-10,  3.180038884064630e-12,
 -3.729136423210502e-14,  4.082821921175340e-16, -4.213949055736203e-18,  4.130672776614471e-20, -3.867838289379064e-22,  5.738887956987752e-02, -2.821129033014201e-03,
  8.229324000798012e-05, -1.813774280575693e-06,  3.317737118058027e-08, -5.289291401615531e-10,  7.570903368131430e-12, -9.923763520124286e-14,  1.208002783037263e-15,
 -1.379867549244012e-17,  1.490920952868580e-19, -1.533275532893981e-21,  5.567403075617620e-02, -3.287192780703683e-03,  1.119465989494618e-04, -2.834147522630748e-06,
  5.887149283028188e-08, -1.056555485182865e-09,  1.690559292158282e-11, -2.462739621822115e-13,  3.315245545776119e-15, -4.169854156496476e-17,  4.942257409930414e-19,
 -5.556478957054747e-21,  5.387016045925118e-02, -3.756660576492074e-03,  1.477629024015360e-04, -4.260778992735875e-06,  9.978830971745664e-08, -2.003317543605851e-09,
  3.562759843712225e-11, -5.737719596561991e-13,  8.499618484670371e-15, -1.171709732736583e-16,  1.516676062469812e-18, -1.856271135318930e-20,  5.199483610910005e-02,
 -4.220953134064584e-03,  1.898744081804477e-04, -6.187073788426266e-06,  1.622855375201121e-07, -3.623005375325545e-09,  7.123352173794317e-11, -1.262019333585507e-12,
  2.047847671496621e-14, -3.080768920412429e-16,  4.337328953695062e-18, -5.756360767350125e-20,  5.006505979043906e-02, -4.672033088482942e-03,  2.381898732872169e-04,
 -8.706788751078864e-06,  2.541776280901485e-07, -6.275371090474211e-09,  1.357234907645252e-10, -2.633058131797103e-12,  4.660105121620331e-14, -7.619763466513195e-16,
  1.162334301992041e-17, -1.666659224027232e-19,  4.809698128784459e-02, -5.102560720366271e-03,  2.923876900016461e-04, -1.190819639495207e-05,  3.846417519720362e-07,
 -1.044728317403177e-08,  2.473786100893186e-10, -5.232354670787632e-12,  1.005938583589778e-13, -1.780913580003179e-15,  2.932839942786962e-17, -4.527909223137229e-19,
  4.610566295950509e-02, -5.506012824011267e-03,  3.519205296129382e-04, -1.586780262065755e-05,  5.639679224449507e-07, -1.676877139788768e-08,  4.327657653974117e-10,
 -9.938462126607490e-12,  2.067551243340212e-13, -3.948912391368942e-15,  6.996606134336318e-17, -1.159229590904475e-18,  4.410489879973688e-02, -5.876764075176307e-03,
  4.160305267124216e-04, -2.064406504081639e-05,  8.031425774927473e-07, -2.601990807170966e-08,  7.287780820187918e-10, -1.810002172938196e-11,  4.059568286232927e-13,
 -8.335789865723941e-15,  1.583788098633958e-16, -2.807341252322238e-18,  4.210708742838229e-02, -6.210132086637165e-03,  4.837734907840571e-04, -2.627156745736590e-05,
  1.113271213917615e-06, -3.912445293412486e-08,  1.184423314567701e-09, -3.169350229398096e-11,  7.636666384024327e-13, -1.680254788932051e-14,  3.412719576489559e-16,
 -6.452289645531913e-18,  4.012315648433788e-02, -6.502388868666723e-03,  5.540502477375855e-04, -3.275607376885455e-05,  1.504862979288791e-06, -5.712675508644585e-08,
  1.861989746740639e-09, -5.348729825163346e-11,  1.379899924426746e-12, -3.242933373563958e-14,  7.019808828729781e-16, -1.411566736344962e-17,  3.816253408566295e-02,
 -6.750742582590575e-03,  6.256430004415391e-04, -4.007081720747181e-05,  1.987016422236437e-06, -8.114957781913050e-08,  2.837169493620706e-09, -8.718906720501883e-11,
  2.400537421271978e-12, -6.007352590940339e-14,  1.381863709857663e-15, -2.947102526708143e-17,  3.623316169088721e-02, -6.953294268109196e-03,  6.972545472796113e-04,
 -4.815428720376023e-05,  2.566558956310828e-06, -1.123322198806449e-07,  4.197720901446634e-09, -1.375449342854556e-10,  4.028818022267272e-12, -1.070403212147826e-13,
  2.609151081029334e-15, -5.885901602189320e-17,  3.434154185610163e-02, -7.108974649162164e-03,  7.675482919439457e-04, -5.690966694441629e-05,  3.247201465258445e-06,
 -1.517503903662751e-07,  6.040318383035998e-09, -2.103532860130667e-10,  6.535109606572538e-12, -1.838106115028355e-13,  4.734838381619730e-15, -1.126853958970892e-16,
  3.249281399777287e-02, -7.217466213190892e-03,  8.351871881118936e-04, -6.620596076000238e-05,  4.028772889319777e-06, -2.003215262537988e-07,  8.465374283016981e-09,
 -3.123543067814638e-10,  1.026239685668012e-11, -3.047234749564031e-13,  8.273155646748884e-15, -2.071950552209277e-16,  3.069085128479964e-02, -7.279115566519494e-03,
  8.988700566428080e-04, -7.588074193354935e-05,  4.906597256456847e-06, -2.587013569091172e-07,  1.156981721510669e-08, -4.509608856643067e-10,  1.562446809685425e-11,
 -4.884598782266513e-13,  1.394135535690319e-14, -3.665095674283167e-16,  2.893837212220667e-02, -7.294840656033520e-03,  9.573640567817244e-04, -8.574435666330490e-05,
  5.871067778680387e-06, -3.271792539346607e-07,  1.543805751234678e-08, -6.338080472076930e-10,  2.309371313860175e-11, -7.581309198692817e-13,  2.269033884532403e-14,
 -6.246646661501440e-16,  2.723706027292384e-02, -7.266036879485916e-03,  1.009532454956300e-03, -9.558534470226528e-05,  6.907460198008328e-06, -4.055810295711907e-07,
  2.013163607056392e-08, -8.681165838356084e-10,  3.317591886440237e-11, -1.140751824682889e-12,  3.571462054893736e-14, -1.027202880319803e-15,  2.558768841339761e-02,
 -7.194485446316022e-03,  1.054357187869231e-03, -1.051767850250461e-04,  7.996011822640625e-06, -4.931882016050627e-07,  2.567830470381516e-08, -1.159890772353802e-09,
  4.637056216811034e-11, -1.665896116088725e-12,  5.442819225619868e-14, -1.631699468766860e-15,  2.399024075939126e-02, -7.082266653923070e-03,  1.090956039283159e-03,
 -1.142832466544719e-04,  9.112275151671338e-06, -5.886822533761920e-07,  3.206148917494031e-08, -1.512997377949857e-09,  6.311684146182419e-11, -2.363384214116136e-12,
  8.039300940378331e-14, -2.506479027437686e-15,  2.244403126632651e-02, -6.931680057599632e-03,  1.118594527112673e-03, -1.226680192889279e-04,  1.022773719792659e-05,
 -6.901211040050756e-07,  3.921120862581020e-08, -1.928200029927247e-09,  8.372792225421708e-11, -3.259971692704059e-12,  1.151899842295453e-13, -3.726778501903391e-15,
  2.094781475228637e-02, -6.745172871775563e-03,  1.136692820383710e-03, -1.301003127274562e-04,  1.131067901301835e-05, -7.949529747711152e-07,  4.699754352340097e-08,
 -2.402245416399012e-09,  1.083183356626215e-10, -4.375159267581650e-12,  1.602290454179274e-13, -5.367788782167346e-15,  1.949988907280792e-02, -6.525277370928097e-03,
  1.144828171109180e-03, -1.363621443207260e-04,  1.232723567753867e-05, -9.000702732977898e-07,  5.522764636762068e-08, -2.927111601936479e-09,  1.367317955186061e-10,
 -5.716432488449539e-12,  2.165048444232444e-13, -7.494397318171973e-15,  1.809818716896469e-02, -6.274557575422983e-03,  1.142733455590487e-03, -1.412546752723042e-04,
  1.324260599499636e-05, -1.001903247044852e-06,  6.364707674083750e-08, -3.489530874128113e-09,  1.684784732015774e-10, -7.274426571741247e-12,  2.843170300822782e-13,
 -1.014805097894041e-14,  1.674035839943869e-02, -5.995565116853859e-03,  1.130292477973387e-03, -1.446038050195464e-04,  1.402235381221781e-05, -1.096550232269880e-06,
  7.194592993678025e-08, -4.070887940672170e-09,  2.026915902909499e-10, -9.018666019182455e-12,  3.629867842088145e-13, -1.333189735813373e-14,  1.542383904829763e-02,
 -5.690803878292936e-03,  1.107532703232447e-03, -1.462648839254346e-04,  1.463373942246120e-05, -1.179938589492079e-06,  7.976984345734373e-08, -4.647568817100173e-09,
  2.381127506702369e-10, -1.089461325679431e-11,  4.506119688032862e-13, -1.699612060436684e-14,  1.414591227546189e-02, -5.362702791187867e-03,  1.074616065510872e-03,
 -1.461264545204105e-04,  1.504701972435384e-05, -1.248008088369382e-06,  8.673554395556742e-08, -5.191798034806698e-09,  2.731135879516478e-10, -1.282274475610169e-11,
  5.439090189171276e-13, -2.102599670936779e-14,  1.290375805421429e-02, -5.013596032892607e-03,  1.031828449591079e-03, -1.441129777340825e-04,  1.523665930239196e-05,
 -1.296906754420541e-06,  9.245017921937870e-08, -5.672955291640190e-09,  3.057581073560953e-10, -1.470023904367154e-11,  6.381882298616043e-13, -2.523547138439086e-14,
  1.169449383097241e-02, -4.645709795530201e-03,  9.795683765247941e-04, -1.401865409723157e-04,  1.518240079017104e-05, -1.323188130908741e-06,  9.653330615958680e-08,
 -6.059312183998888e-09,  3.339058277900575e-10, -1.640560921824546e-11,  7.274989264072859e-13, -2.936885854029027e-14,  1.051520676035653e-02, -4.261154775954237e-03,
  9.183353465677173e-04, -1.343475783551448e-04,  1.487015111392282e-05, -1.323998594415736e-06,  9.864011295492390e-08, -6.320080832788682e-09,  3.553509497648972e-10,
 -1.780626479921829e-11,  8.049622522411481e-13, -3.311249048108876e-14,  9.362978427887676e-03, -3.861923556382013e-03,  8.487182099000618e-04, -1.266346594900251e-04,
  1.429264981012739e-05, -1.297243786700854e-06,  9.848427022207895e-08, -6.427624793066228e-09,  3.679878970936924e-10, -1.876858567405052e-11,  8.632838145541524e-13,
 -3.611685367511122e-14,  8.234902989152701e-03, -3.449892095798738e-03,  7.713838534179282e-04, -1.171234219868012e-04,  1.344989592455674e-05, -1.241724331703252e-06,
  9.585875069709324e-08, -6.359653763368880e-09,  3.699893704892764e-10, -1.916969122601109e-11,  8.954096433477816e-13, -3.802807260515624e-14,  7.128099647817882e-03,
 -3.026824627067848e-03,  6.870664146800061e-04, -1.059247352391202e-04,  1.234932047562027e-05, -1.157232698151991e-06,  9.065303616342860e-08, -6.101211188042829e-09,
  3.599801351167731e-10, -1.890975345198534e-11,  8.952615330192420e-13, -3.852582608945139e-14,  6.039720403170442e-03, -2.594381357473768e-03,  5.965571672909226e-04,
 -9.318219015667826e-05,  1.100570168798490e-05, -1.044605222853116e-06,  8.286533938875401e-08, -5.646270063261461e-09,  3.371886341830897e-10, -1.792349310260866e-11,
  8.584668669907139e-13, -3.736323113465150e-14,  4.966954141127468e-03, -2.154128543592053e-03,  5.006951788580607e-04, -7.906901450568344e-05,  9.440830045077592e-06,
 -9.057258047347365e-07,  7.260879322430259e-08, -4.998777391106477e-09,  3.015594620171913e-10, -1.618945743005215e-11,  7.829879657203862e-13, -3.440324730246812e-14,
  3.907028988707920e-03, -1.707550997684817e-03,  4.003588829408717e-04, -6.378452700005527e-05,  7.682940587653503e-06, -7.434805779986840e-07,  6.011098275071784e-08,
 -4.173030533467388e-09,  2.538127980353729e-10, -1.373583038511898e-11,  6.695598984800457e-13, -2.964600950718852e-14,  2.857220154028890e-03, -1.256069537126943e-03,
  2.964592249077306e-04, -4.755033023985889e-05,  5.765948448137296e-06, -5.616665914035251e-07,  4.570675012203965e-08, -3.193329865280033e-09,  1.954421091938795e-10,
 -1.064187877071562e-11,  5.218650144679820e-13, -2.324234779544625e-14,  1.814918982712581e-03, -8.010874598549014e-04,  1.899401183262834e-04, -3.060726380661542e-05,
  3.728630923411114e-06, -3.648699384702664e-07,  2.982549884744943e-08, -2.092972117707619e-09,  1.286510813432168e-10, -7.034809387873554e-12,  3.464129841730656e-13,
 -1.549088639733426e-14,  7.788305869365151e-04, -3.445380103258572e-04,  8.189844213252325e-05, -1.323135465000209e-05,  1.616009338232107e-06, -1.585376690257888e-07,
  1.299163526102393e-08, -9.139061160079555e-10,  5.631101304471838e-11, -3.086409549684832e-12,  1.523338189594819e-13, -6.827414603363417e-15,  6.538920124604872e-02,
 -1.786326073826673e-04,  5.093590373368580e-07, -1.502063123067886e-09,  4.535766629619131e-12, -1.390528326626835e-14,  4.299331504553226e-17, -1.334475358935441e-19,
  4.145515706650047e-22, -1.286424768883203e-24,  3.983221709695285e-27, -1.229873299074125e-29,  6.490663410358112e-02, -2.435525393341689e-04,  1.065867611876586e-06,
 -4.747014184510413e-09,  2.069690745491981e-11, -8.789029352287765e-14,  3.644586839039777e-16, -1.480900499644072e-18,  5.913397744610466e-21, -2.325775200810632e-23,
  9.025774827432946e-26, -3.460908673962265e-28,  6.395401072359780e-02, -3.702732605604227e-04,  2.347355649534145e-06, -1.390261080382896e-08,  7.736895461816282e-11,
 -4.104538634221178e-13,  2.096433554793787e-15, -1.037734844890845e-17,  5.001732295112917e-20, -2.355668552291671e-22,  1.087077194847712e-24, -4.926119898813631e-27,
  6.255574573266075e-02, -5.527657391254287e-04,  4.667747033205392e-06, -3.487701985668469e-08,  2.392699970031196e-10, -1.540592663746165e-12,  9.433469361699390e-15,
 -5.542205114029991e-17,  3.143992935171870e-19, -1.730374543274692e-21,  9.273940287746120e-24, -4.854227423941067e-26,  6.074698825581348e-02, -7.824904256524261e-04,
  8.443449141284332e-06, -7.778701569753058e-08,  6.450233002529149e-10, -4.946680011215206e-12,  3.566840561407843e-14, -2.445113473432110e-16,  1.606195703596770e-18,
 -1.017062072721692e-20,  6.236274681556392e-23, -3.716085570335041e-25,  5.857197629858374e-02, -1.048950745988152e-03,  1.413609696587693e-05, -1.579826337398300e-07,
  1.559670490501054e-09, -1.404752150652664e-11,  1.177184525813348e-13, -9.299813811716169e-16,  6.991095186121687e-18, -5.035853757283868e-20,  3.494447369831372e-22,
 -2.345732231161569e-24,  5.608203221585920e-02, -1.340352062411141e-03,  2.218842350403085e-05, -2.967337098602019e-07,  3.445111487924851e-09, -3.603565033714187e-11,
  3.473273922232084e-13, -3.131411973400739e-15,  2.669045232715630e-17, -2.167777477765652e-19,  1.687917021342102e-21, -1.265971667579264e-23,  5.333333703605973e-02,
 -1.644310325762014e-03,  3.296133007634290e-05, -5.212090034845680e-07,  7.042540643814380e-09, -8.474998283300579e-11,  9.314206288139859e-13, -9.505983540718150e-15,
  9.116472562047563e-17, -8.287850392666527e-19,  7.190612585165724e-21, -5.985219835055281e-23,  5.038462872835667e-02, -1.948553584791897e-03,  4.667975467511302e-05,
 -8.634932386067465e-07,  1.345484653991502e-08, -1.847635060996444e-10,  2.298079446713733e-12, -2.636524472390634e-14,  2.826283718261042e-16, -2.858045155861754e-18,
  2.746508079796284e-20, -2.522531718889492e-22,  4.729496400423277e-02, -2.241564255499400e-03,  6.339345829162346e-05, -1.358564199220125e-06,  2.421150160550378e-08,
 -3.766240621363355e-10,  5.266256414226092e-12, -6.749880901771286e-14,  8.040987314040289e-16, -8.995142888545050e-18,  9.524106662614064e-20, -9.603512913324437e-22,
  4.412166651968526e-02, -2.513119586098170e-03,  8.295665147803609e-05, -2.041352985665690e-06,  4.129570657550780e-08, -7.228430032880512e-10,  1.129414070501095e-11,
 -1.608211948247095e-13,  2.117917950876278e-15, -2.607960571806800e-17,  3.028115724253898e-19, -3.337071622370453e-21,  4.091855908630926e-02, -2.754700568981688e-03,
  1.050278385754074e-04, -2.943193911219654e-06,  6.711497542110267e-08, -1.313823334090333e-09,  2.281073264789911e-11, -3.589976540880011e-13,  5.201438001739691e-15,
 -7.018436956424336e-17,  8.898092430544306e-19, -1.067305230547203e-20,  3.773454705987558e-02, -2.959753881798012e-03,  1.290887562020683e-04, -4.088100101752751e-06,
  1.044024254532221e-07, -2.272552167456274e-09,  4.361680552708230e-11, -7.550782723689022e-13,  1.198266042887485e-14, -1.764297733221034e-16,  2.432671802245846e-18,
 -3.163893859867950e-20,  3.461258796860919e-02, -3.123805536556834e-03,  1.544791688838718e-04, -5.489353382192838e-06,  1.560460253693980e-07, -3.756666565603592e-09,
  7.931650279236382e-11, -1.503624946241774e-12,  2.602648330015565e-14, -4.165133243733038e-16,  6.222691875936874e-18, -8.744209189828854e-20,  3.158905189573792e-02,
 -3.244437284832535e-03,  1.804428029322741e-04, -7.146865958031526e-06,  2.248551329390470e-07, -5.956537001307869e-09,  1.377136325016108e-10, -2.846760413088044e-12,
  5.353378266541367e-14, -9.277379617820136e-16,  1.496536418329984e-17, -2.264538257609570e-19,  2.869345072952072e-02, -3.321146395573334e-03,  2.061789697762044e-04,
 -9.045666727674273e-06,  3.132853932019984e-07, -9.088350420934759e-09,  2.290838795393849e-10, -5.143035567965992e-12,  1.046814618669289e-13, -1.957587298635793e-15,
  3.398188289158014e-17, -5.519632510136178e-19,  2.594849387972623e-02, -3.355115615648125e-03,  2.308944458295512e-04, -1.115570962000348e-05,  4.231520341107384e-07,
 -1.338179651641917e-08,  3.662231048609040e-10, -8.895205331721444e-12,  1.952656638032388e-13, -3.927085281743733e-15,  7.312705713987996e-17, -1.271141164055567e-18,
  2.337041426578739e-02, -3.348922859348260e-03,  2.538508259779859e-04, -1.343302487956885e-05,  5.553659383128838e-07, -1.906277452547300e-08,  5.641788419071977e-10,
 -1.477129791473237e-11,  3.485136874948143e-13, -7.513748444702067e-15,  1.496302322683374e-16, -2.775389946143770e-18,  2.096950130370924e-02, -3.306219783445619e-03,
  2.744036694541591e-04, -1.582206684706735e-05,  7.097257242434818e-07, -2.633239702455007e-08,  8.395999218369130e-10, -2.361223702193596e-11,  5.968143517816973e-13,
 -1.375057071034626e-14,  2.919853559376485e-16, -5.762846292445052e-18,  1.875077657715193e-02, -3.231405514355045e-03,  2.920310972051124e-04, -1.825897838793408e-05,
  8.847927003945297e-07, -3.534430420155115e-08,  1.209686079182254e-09, -3.641920079119079e-11,  9.830041489579046e-13, -2.413131784407061e-14,  5.448353567039107e-16,
 -1.141131060589886e-17,  1.671475173564442e-02, -3.129317184415913e-03,  3.063508726943890e-04, -2.067540863170334e-05,  1.077865218051865e-06, -4.618276823716712e-08,
  1.690778816520878e-09, -5.431519506477922e-11,  1.560767892932004e-12, -4.070524329514627e-14,  9.745039760354644e-16, -2.160265531768660e-17,  1.485821555037040e-02,
 -3.004953412109466e-03,  3.171262329493024e-04, -2.300249269527602e-05,  1.285056541746872e-06, -5.884416697861297e-08,  2.296696539339270e-09, -7.847803318605643e-11,
  2.393699147456828e-12, -6.613763182431325e-14,  1.674445569404546e-15, -3.918673183576455e-17,  1.317500657715731e-02, -2.863241154608218e-03,  3.242617157845714e-04,
 -2.517462564479478e-05,  1.501467989206671e-06, -7.322411638004583e-08,  3.036969429570778e-09, -1.100457739140935e-10,  3.552641271281354e-12, -1.037082619288938e-13,
  2.769470313089227e-15, -6.825420938129521e-17,  1.165673825750042e-02, -2.708851051214412e-03,  3.277908924918080e-04, -2.713272703177646e-05,  1.721438647300941e-06,
 -8.911192420395479e-08,  3.915162387052035e-09, -1.500000967331610e-10,  5.111102141925360e-12, -1.572199260537106e-13,  4.417256608142070e-15, -1.143659096466951e-16,
  1.029345349312874e-02, -2.546061863295410e-03,  3.278582557249551e-04, -2.882678187594432e-05,  1.938845790129313e-06, -1.061931745063167e-07,  4.927480893479993e-09,
 -1.990373223529713e-10,  7.138791032872145e-12, -2.307950204310931e-13,  6.805504102754957e-15, -1.846655770648474e-16,  9.074194998936812e-03, -2.378671118976927e-03,
  3.246975639386458e-04, -3.021754312950835e-05,  2.147426851423521e-06, -1.240603171937941e-07,  6.061833097520108e-09, -2.574400219199805e-10,  9.693630084146513e-12,
 -3.285503321277564e-13,  1.014322307079282e-14, -2.877899620915117e-16,  7.987485596950625e-03, -2.209946648548895e-03,  3.186087671942796e-04, -3.127737543721541e-05,
  2.341094377594695e-06, -1.422302650128606e-07,  7.297475227945221e-09, -3.249637571579780e-10,  1.281289522135358e-11, -4.541575490240878e-13,  1.464517117903959e-14,
 -4.334914262131835e-16,  7.021718836933573e-03, -2.042612285613198e-03,  3.099353069356665e-04, -3.199029991850775e-05,  2.514219183202984e-06, -1.601673121358497e-07,
  8.605304287310677e-09, -4.007531006722389e-10,  1.650438675656357e-11, -6.103173521063302e-13,  2.050933705125255e-14, -6.319094625303351e-16,  6.165464896886933e-03,
 -1.878860463836197e-03,  2.990431664099331e-04, -3.235135850268948e-05,  2.661862959505205e-06, -1.773092612530703e-07,  9.948791981121553e-09, -4.832987065229912e-10,
  2.073866927055285e-11, -7.981948433383327e-13,  2.788854246231943e-14, -8.924706227322592e-16,  5.407699754505241e-03, -1.720384571304852e-03,  2.863026113154587e-04,
 -3.236545192224993e-05,  2.779948727341039e-06, -1.930945068257824e-07,  1.128548746458672e-08, -5.704431895372012e-10,  2.544342188990900e-11, -1.016879766813357e-12,
  3.685851789216434e-14, -1.222458464152665e-15,  4.737967344374037e-03, -1.568424535200427e-03,  2.720731500727302e-04, -3.204581908018697e-05,  2.865364722183523e-06,
 -2.069879513822459e-07,  1.256896264720654e-08, -6.594385440106016e-10,  3.050079573842029e-11, -1.262943161923701e-12,  4.738596899999454e-14, -1.625367985265276e-15,
  4.146485083668005e-03, -1.423820013642800e-03,  2.566918917932663e-04, -3.141232076960389e-05,  2.916003704578083e-06, -2.185039745882044e-07,  1.375103848492226e-08,
 -7.470525353906343e-10,  3.574840233716575e-11, -1.530160553103376e-12,  5.930095208669896e-14, -2.099229847590249e-15,  3.624203025266144e-03, -1.287066612378211e-03,
  2.404652043513559e-04, -3.048967250398234e-05,  2.930744739689845e-06, -2.272251562286664e-07,  1.478411640831341e-08, -8.297166654771162e-10,  4.098419337603434e-11,
 -1.809459964443808e-12,  7.227811293528096e-14, -2.635143555744200e-15,  3.162826225633859e-03, -1.158371600077131e-03,  2.236633791496618e-04, -2.930574466535239e-05,
  2.909387916630119e-06, -2.328159942646036e-07,  1.562344491437712e-08, -9.037045379918153e-10,  4.597509001918207e-11, -2.089132137467327e-12,  8.583090012051351e-14,
 -3.216281736381622e-15,  2.754808904716453e-03, -1.037706582086263e-03,  2.065178881933903e-04, -2.789001800606500e-05,  2.852554271847884e-06, -2.350313856853602e-07,
  1.622917385178612e-08, -9.653271129447117e-10,  5.046883340438717e-11, -2.355313034152403e-12,  9.932174053001546e-14, -3.817610016964226e-15,  2.393327794189402e-03,
 -9.248554559845585e-04,  1.892207621152958e-04, -2.627225256910131e-05,  2.761563525322180e-06, -2.337200952190080e-07,  1.656808286527175e-08, -1.011130561784060e-09,
  5.420820570766600e-11, -2.592718726723639e-12,  1.119894805397089e-13, -4.406505844031407e-15,  2.072240844701560e-03, -8.194566876949974e-04,  1.719256111779021e-04,
 -2.448140105761652e-05,  2.638301436742512e-06, -2.288237895987695e-07,  1.661491006874285e-08, -1.038083117060632e-09,  5.694654818613028e-11, -2.785584129681895e-12,
  1.229933697829202e-13, -4.944359957324770e-15,  1.786036280182497e-03, -7.210395091268749e-04,  1.547498408991835e-04, -2.254477524265497e-05,  2.485086993034606e-06,
 -2.203724476713036e-07,  1.635324688494621e-08, -1.043739170243388e-09,  5.846339699287456e-11, -2.918733380397409e-12,  1.314707753316228e-13, -5.389118696534820e-15,
  1.529775903745217e-03, -6.290540563916691e-04,  1.377776668235175e-04, -2.048745686499259e-05,  2.304547592155308e-06, -2.084770709721795e-07,  1.577600074892193e-08,
 -1.026371526058358e-09,  5.857906993516106e-11, -2.978693790799473e-12,  1.366039544188150e-13, -5.698591855792113e-15,  1.299035605854936e-03, -5.428957591904870e-04,
  1.210635982016192e-04, -1.833193265191835e-05,  2.099508188157566e-06, -1.933206298375601e-07,  1.488545604209320e-08, -9.850657594767019e-10,  5.716715372004160e-11,
 -2.954758731670994e-12,  1.376898405846921e-13, -5.834229741272202e-15,  1.089845213717490e-03, -4.619244790828756e-04,  1.046361295902499e-04, -1.609792603125307e-05,
  1.872898239686304e-06, -1.751481086268275e-07,  1.369298369425538e-08, -9.197736659688262e-10,  5.416403753608887e-11, -2.839907846520168e-12,  1.342060956744505e-13,
 -5.764983568097528e-15,  8.986291532959857e-04, -3.854790011600410e-04,  8.850144699333031e-05, -1.380239513571216e-05,  1.627678420416875e-06, -1.542563855694642e-07,
  1.221846120878836e-08, -8.313255527695532e-10,  4.957488632133361e-11, -2.631504760545308e-12,  1.258667382262317e-13, -5.470820115920123e-15,  7.221488773365690e-04,
 -3.128875382105586e-04,  7.264701889385436e-05, -1.145966708237381e-05,  1.366787522745847e-06, -1.309845251351893e-07,  1.048946850095428e-08, -7.214034101678462e-10,
  4.347571789837173e-11, -2.331711273315606e-12,  1.126614692272445e-13, -4.945472788605930e-15,  5.574477071270045e-04, -2.434749618394222e-04,  5.704500843141501e-05,
 -9.081682680020458e-06,  1.093109004370358e-06, -1.057049102275265e-07,  8.540323687829926e-09, -5.924788270425590e-10,  3.601152276909573e-11, -1.947580962887109e-12,
  9.487429268557027e-14, -4.198077753391943e-15,  4.017991438566559e-04, -1.765677761545531e-04,  4.165556482605991e-05, -6.678341642262698e-06,  8.094572539980157e-07,
 -7.881562008263904e-08,  6.411027366385585e-09, -4.477214862122213e-10,  2.739066233319894e-11, -1.490823840719357e-12,  7.307910203651996e-14, -3.253462772855554e-15,
  2.526661658282841e-04, -1.115007794405963e-04,  2.643079387567019e-05, -4.258056510210372e-06,  5.185969847366212e-07, -5.073567287033400e-08,  4.146285584361471e-09,
 -2.908925781171103e-10,  1.787647765297126e-11, -9.772862403606648e-13,  4.811341452950348e-14, -2.151061143944847e-15,  1.078186790534116e-04, -4.769120680076628e-05,
  1.133495543237586e-05, -1.831007132065059e-06,  2.235995869223095e-07, -2.193316531252786e-08,  1.797110877898659e-09, -1.264024332732158e-10,  7.787366563063133e-12,
 -4.267710087805122e-13,  2.106116654407815e-14, -9.438172991150218e-16,  6.468270811863754e-02, -1.746286211633473e-04,  4.917607141658039e-07, -1.431660883022665e-09,
  4.267684270367648e-12, -1.291682477661917e-14,  3.943575427279299e-17, -1.208931431621546e-19,  3.709824976152871e-22, -1.137404850332604e-24,  3.480005448583550e-27,
 -1.061866642984317e-29,  6.394912483024275e-02, -2.352479561352017e-04,  1.010833839041650e-06, -4.429464581211231e-09,  1.902332030128109e-11, -7.962023428238653e-14,
  3.255216017152855e-16, -1.304400159670250e-18,  5.137596638307112e-21, -1.993433565648137e-23,  7.632988828912693e-26, -2.888251480280811e-28,  6.250944768224703e-02,
 -3.521413029335637e-04,  2.187689433001328e-06, -1.272774203464741e-08,  6.964038810852547e-11, -3.634529305652303e-13,  1.827058136438844e-15, -8.904494492005303e-18,
  4.227007294754388e-20, -1.961256037779342e-22,  8.918468313584337e-25, -3.983225326018596e-27,  6.041680496508842e-02, -5.170350426931011e-04,  4.271214376493518e-06,
 -3.128340136395670e-08,  2.106021194041131e-10, -1.331729439596277e-12,  8.013625260666888e-15, -4.629035126355033e-17,  2.582986640313587e-19, -1.398840104866534e-21,
  7.379270756577933e-24, -3.802844189124085e-26,  5.774644806912233e-02, -7.185083908555946e-04,  7.568806926464018e-06, -6.821382751946981e-08,  5.541242068117460e-10,
 -4.167307947958002e-12,  2.948987595306574e-14, -1.985201686372426e-16,  1.281275676736306e-18, -7.974776752070985e-21,  4.808243039559319e-23, -2.818259457555800e-25,
  5.459091615296851e-02, -9.430413034083778e-04,  1.238123646584267e-05, -1.351304236246518e-07,  1.304987168219021e-09, -1.151105603586188e-11,  9.455656875595616e-14,
 -7.327648031687637e-16,  5.406754552642741e-18, -3.824588874231500e-20,  2.607355571837349e-22, -1.720196674143771e-24,  5.105434122195023e-02, -1.176202795016607e-03,
  1.893595580318581e-05, -2.469528778338792e-07,  2.801124818421997e-09, -2.866220530119719e-11,  2.705189321164741e-13, -2.390167343589067e-15,  1.997848956261819e-17,
 -1.592158463820952e-19,  1.217030263365456e-21, -8.964834406342907e-24,  4.724640904621268e-02, -1.403843501614636e-03,  2.733067154285646e-05, -4.209586786283341e-07,
  5.551115903663011e-09, -6.528595104978492e-11,  7.019773171081664e-13, -7.015352986051799e-15,  6.592801910633109e-17, -5.876860882558903e-19,  5.002238396755098e-21,
 -4.086786027605759e-23,  4.327648446274898e-02, -1.613166051249675e-03,  3.749662018774492e-05, -6.750149169471258e-07,  1.025622341072621e-08, -1.375343316688806e-10,
  1.672396958209895e-12, -1.877530445979488e-14,  1.971008584496555e-16, -1.953207252674449e-18,  1.840428310220400e-20, -1.658280947649761e-22,  3.924834644752224e-02,
 -1.793572985512786e-03,  4.918702711946854e-05, -1.025166691480408e-06,  1.780368142217701e-08, -2.702807250193677e-10,  3.692643497355481e-12, -4.628901660581067e-14,
  5.397473600076299e-16, -5.914154626999150e-18,  6.137322066779581e-20, -6.068664552761460e-22,  3.525587263270260e-02, -1.937229000493338e-03,  6.199155926071454e-05,
 -1.482952578292882e-06,  2.922087913842074e-08, -4.989516906363130e-10,  7.613969928583500e-12, -1.059919963824088e-13,  1.365760972446803e-15, -1.646712315800486e-17,
  1.873345537725842e-19, -2.023898830362338e-21,  3.137988300859847e-02, -2.039315344048729e-03,  7.537319405105657e-05, -2.052927771230452e-06,  4.558700175006655e-08,
 -8.702905621113289e-10,  1.475332518221855e-11, -2.269334090587842e-13,  3.216301309863312e-15, -4.248375197004061e-17,  5.276109591965279e-19, -6.202934848949286e-21,
  2.768621780963800e-02, -2.097992699350806e-03,  8.872062459841790e-05, -2.730871191694267e-06,  6.790817032149377e-08, -1.441384960776253e-09,  2.700761385495982e-11,
 -4.569013459216977e-13,  7.091761913856403e-15, -1.022043869763184e-16,  1.380281963782163e-18, -1.759363340585937e-20,  2.422500231344123e-02, -2.114119551957897e-03,
  1.014075875746925e-04, -3.503038175064401e-06,  9.697172642072209e-08, -2.276483804862458e-09,  4.692399623146826e-11, -8.692942771449093e-13,  1.471665263775704e-14,
 -2.305235531273084e-16,  3.373254335942706e-18, -4.645595094731140e-20,  2.103095424601914e-02, -2.090792720892460e-03,  1.128504386891203e-04, -4.346627817972504e-06,
  1.332023190879166e-07, -3.441509443241440e-09,  7.768949684801399e-11, -1.569579952074692e-12,  2.887171536795826e-14, -4.897855194054811e-16,  7.739169544443855e-18,
 -1.147834830298956e-19,  1.812452475246262e-02, -2.032784568034213e-03,  1.225566688045212e-04, -5.231413032622724e-06,  1.765447925890717e-07, -4.996663883175397e-09,
  1.230083811787308e-10, -2.699659599355066e-12,  5.376073065440125e-14, -9.843301271711023e-16,  1.674088358969939e-17, -2.665735175390054e-19,  1.551363283557168e-02,
 -1.945948535974453e-03,  1.301593762462385e-04, -6.122283020850256e-06,  2.263957531877462e-07, -6.988014364878198e-09,  1.868510597907258e-10, -4.438182643780060e-12,
  9.534988265181273e-14, -1.878106627881150e-15,  3.427402208046601e-17, -5.842232737625373e-19,  1.319575242125496e-02, -1.836653668446757e-03,  1.354354189881371e-04,
 -6.982312147583211e-06,  2.815978130322554e-07, -9.439291540041566e-09,  2.730817104506306e-10, -6.995014346735651e-12,  1.615908353218218e-13, -3.413353237022781e-15,
  6.664162460169486e-17, -1.212572155784622e-18,  1.116013420781124e-02, -1.711292883761043e-03,  1.383075358477263e-04, -7.775916510317725e-06,  3.404997814211798e-07,
 -1.234524251024223e-08,  3.849984928811258e-10, -1.059873384397671e-11,  2.624246283027917e-13, -5.926849274639680e-15,  1.234431287317617e-16, -2.391081821699633e-18,
  9.389983114145279e-03, -1.575892229576588e-03,  1.388327563900975e-04, -8.471689166366883e-06,  4.010750023512099e-07, -1.566771215947093e-08,  5.248436459386061e-10,
 -1.547717720176030e-11,  4.094711240146675e-13, -9.858984252813731e-15,  2.184510172312580e-16, -4.492650777083105e-18,  7.864458389019058e-03, -1.435831838175681e-03,
  1.371807041328175e-04, -9.044599055575155e-06,  4.610809978403094e-07, -1.933521342697018e-08,  6.933546633911480e-10, -2.183243187191063e-11,  6.153427210997378e-13,
 -1.575034040074694e-14,  3.702772334778753e-16, -8.064654102527365e-18,  6.560410348079941e-03, -1.295675684092466e-03,  1.336059042527607e-04, -9.477369296877788e-06,
  5.182382269300958e-07, -2.324618469897662e-08,  8.894280904627105e-10, -2.981302194749363e-11,  8.925791182298126e-13, -2.422107602381262e-14,  6.025791316436260e-16,
 -1.386441548929638e-17,  5.453810120996275e-03, -1.159097476409970e-03,  1.284180423447023e-04, -9.760988085281356e-06,  5.704047446486625e-07, -2.727554584002474e-08,
  1.109953616645823e-09, -3.948696511897387e-11,  1.252272230873076e-12, -3.593032178799023e-14,  9.435446978051569e-16, -2.287828611894550e-17,  4.520863547880518e-03,
 -1.028884252808055e-03,  1.219534754599403e-04, -9.894425063804686e-06,  6.157264661907073e-07, -3.128367503738360e-08,  1.349850941411329e-09, -5.081967756661227e-11,
  1.702521510557978e-12, -5.151590641223902e-14,  1.424447170755777e-15, -3.631190438143711e-17,  3.738826110428530e-03, -9.069970466406908e-04,  1.145503880424643e-04,
 -9.883711793808360e-06,  6.527484845307176e-07, -3.512662435643431e-08,  1.602310851598679e-09, -6.366025058629267e-11,  2.246912929613855e-12, -7.151849126358524e-14,
  2.077175180906146e-15, -5.554008239478520e-17,  3.086552608522192e-03, -7.946685883153937e-04,  1.065290121754224e-04, -9.740590633144389e-06,  6.804799749592529e-07,
 -3.866631020868647e-08,  1.859211588337539e-09, -7.773850158544157e-11,  2.883236062115440e-12, -9.629783121167677e-14,  2.930813669489023e-15, -8.200873942179764e-17,
  2.544824264620879e-03, -6.925204688642552e-04,  9.817744541026835e-05, -9.480944286640138e-06,  6.984122026718629e-07, -4.177954212639553e-08,  2.111657731563013e-09,
 -9.267364579502225e-11,  3.602636471557771e-12, -1.259515454510407e-13,  4.007543627337262e-15, -1.170882805518453e-16,  2.096498650828239e-03, -6.006856730600643e-04,
  8.974289404187463e-05, -9.123196620565909e-06,  7.064949098634485e-07, -4.436503629617288e-08,  2.350575336802451e-09, -1.079937640865828e-10,  4.389347416286762e-12,
 -1.602478000877332e-13,  5.318304718559682e-15, -1.618868434928504e-16,  1.726526037884279e-03, -5.189261702423700e-04,  8.142768362090911e-05, -8.686834807840983e-06,
  7.050802488455108e-07, -4.634792574851923e-08,  2.567295171712906e-09, -1.231637791855897e-10,  5.221066238762391e-12, -1.985823551195731e-13,  6.858783106797779e-15,
 -2.170412192200066e-16,  1.421871104196857e-03, -4.467388208739060e-04,  7.338910691185215e-05, -8.191154251145492e-06,  6.948452782896212e-07, -4.768165248860521e-08,
  2.754064406701940e-09, -1.376186464620947e-10,  6.069952374921432e-12, -2.399676356256008e-13,  8.606316648867465e-15, -2.825109536941173e-16,  1.171372794668796e-03,
 -3.834459031340293e-04,  6.574208923262102e-05, -7.654279903736140e-06,  6.767040657943439e-07, -4.834744795539557e-08,  2.904443033589167e-09, -1.507980454751265e-10,
  6.904142403886517e-12, -2.830573766011697e-13,  1.051823913926501e-14, -3.574052845224342e-16,  9.655685320675664e-04, -3.282689445246643e-04,  5.856369526592467e-05,
 -7.092476678183343e-06,  6.517190957573134e-07, -4.835183934206655e-08,  3.013560824775059e-09, -1.621790234634452e-10,  7.689616792695438e-12, -3.262057467589188e-13,
  1.253202434714377e-14, -4.398719501545213e-16,  7.965026777721119e-04, -2.803862439518817e-04,  5.189863110648429e-05, -6.519730818277301e-06,  6.210195116663894e-07,
 -4.772274683912403e-08,  3.078230121386799e-09, -1.713036827208554e-10,  8.392221267649280e-12, -3.675555218845995e-13,  1.456736800388918e-14, -5.270713115834513e-16,
  6.575335464610176e-04, -2.389755579641421e-04,  4.576506734910056e-05, -5.947564174853699e-06,  5.857312414517660e-07, -4.650476729959553e-08,  3.096926265615504e-09,
 -1.777999448207177e-10,  8.979644847186820e-12, -4.051465637543137e-13,  1.653010190428146e-14, -6.152494758836449e-16,  5.431486068165579e-04, -2.032440118623819e-04,
  4.016029003838228e-05, -5.385033293530540e-06,  5.469216725195565e-07, -4.475419319232396e-08,  3.069659323894166e-09, -1.813944718386912e-10,  9.423182460311506e-12,
 -4.370340092717865e-13,  1.831761079503679e-14, -6.999118680016505e-16,  4.487937915905063e-04, -1.724475065624308e-04,  3.506585367419898e-05, -4.838863115282912e-06,
  5.055595302571694e-07, -4.253421823942859e-08,  2.997767303711694e-09, -1.819178058047821e-10,  9.699154717063603e-12, -4.614053081248169e-13,  1.982525427271597e-14,
 -7.760860484172839e-16,  3.707200351261969e-04, -1.459018429966973e-04,  3.045205137631291e-05, -4.313668575154162e-06,  4.624891052661490e-07, -3.991065909280781e-08,
  2.883662725193024e-09, -1.793025784019259e-10,  9.789911067829059e-12, -4.766863927909599e-13,  2.095320344737880e-14, -8.386515591977529e-16,  3.058481368213291e-04,
 -1.229875772767293e-04,  2.628162671019848e-05, -3.812224228005065e-06,  4.184169945449129e-07, -3.694839786370112e-08,  2.730562175040466e-09, -1.735761772770168e-10,
  9.684396000241414e-12, -4.816294386819556e-13,  2.161309076472163e-14, -8.827067831016398e-16,  2.516516739467151e-04, -1.031503294041094e-04,  2.251272996246305e-05,
 -3.335750374972274e-06,  3.739090178984329e-07, -3.370863904339838e-08,  2.542223634076946e-09, -1.648495213651817e-10,  9.378303767419667e-12, -4.753773915203176e-13,
  2.173393192977912e-14, -9.039390933844490e-16,  2.060568151937400e-04, -8.589795162223389e-05,  1.910117252055387e-05, -2.884192639008159e-06,  3.293948481919953e-07,
 -3.024698546203229e-08,  2.322710214105071e-09, -1.533036250077504e-10,  8.873880862025030e-12, -4.575032275333789e-13,  2.126689206942644e-14, -8.989650567796976e-16,
  1.673573889157664e-04, -7.079565597777780e-05,  1.600206172053332e-05, -2.456479657284926e-06,  2.851780438869743e-07, -2.661227477682763e-08,  2.076192548511513e-09,
 -1.391754741962667e-10,  8.179455306278994e-12, -4.280243813604852e-13,  2.018861017367929e-14, -8.656115659011048e-16,  1.341433287562286e-04, -5.745992560448697e-05,
  1.317091071157223e-05, -2.050750057798753e-06,  2.414494921899760e-07, -2.284607967254711e-08,  1.806796243202386e-09, -1.227444625140302e-10,  7.308778456445391e-12,
 -3.873946720394092e-13,  1.850294308423657e-14, -8.031155171828194e-16,  1.052405686193670e-04, -4.555180142668675e-05,  1.056431891519011e-05, -1.664545044857758e-06,
  1.983026791388780e-07, -1.898275822553320e-08,  1.518496008453524e-09, -1.043203025393868e-10,  6.280260798354088e-12, -3.364772730269718e-13,  1.624112417963514e-14,
 -7.122278471756197e-16,  7.966053189350188e-05, -3.476995237938034e-05,  8.140313979348458e-06, -1.294966969804221e-06,  1.557496565703763e-07, -1.504994292034887e-08,
  1.215054720523331e-09, -8.423300300108832e-11,  5.116171983613474e-12, -2.765028614485437e-13,  1.346044204380614e-14, -5.952163583241900e-16,  5.655757804645290e-05,
 -2.484383212718062e-05,  5.858446651460572e-06, -9.388086058410868e-07,  1.137371806552686e-07, -1.106938701501290e-08,  9.000048732741379e-10, -6.282530248702228e-11,
  3.841865569807354e-12, -2.090174335553533e-13,  1.024163946757832e-14, -4.557705368461646e-16,  3.519383768587540e-05, -1.552752140788987e-05,  3.679816110701391e-06,
 -5.926753086693490e-07,  7.216476660927269e-08, -7.058291678483492e-09,  5.766838956990907e-10, -4.044876984425412e-11,  2.485137288435013e-12, -1.358274945007243e-13,
  6.685459526026703e-15, -2.988264329082183e-16,  1.493034000654347e-05, -6.603327023960989e-06,  1.569227006548971e-06, -2.534521461593965e-07,  3.094687337374843e-08,
 -3.035199653598624e-09,  2.486574742610791e-10, -1.748732515655274e-11,  1.077210386813137e-12, -5.902655880323055e-14,  2.912582968170926e-15, -1.305052556364117e-16,
  6.399195461250315e-02, -1.707621136673759e-04,  4.749821196441484e-07, -1.365394329680836e-09,  4.018544946008079e-12, -1.200968219372374e-14,  3.621097716556612e-17,
 -1.096508700912629e-19,  3.324329512882191e-22, -1.007110306977271e-24,  3.045168328029432e-27, -9.183747390822161e-30,  6.302397685661486e-02, -2.273688437049043e-04,
  9.594552953210651e-07, -4.137418305655269e-09,  1.750617569282967e-11, -7.222805937255280e-14,  2.911962175030961e-16, -1.150913950786417e-18,  4.471989143655328e-21,
 -1.712074666648993e-23,  6.469328880808812e-26, -2.416020405825319e-28,  6.113494422559371e-02, -3.352323142812449e-04,  2.041409619221909e-06, -1.166934791205550e-08,
  6.279039118518743e-11, -3.224488828447141e-13,  1.595655023601596e-15, -7.658264019012122e-18,  3.581159456411143e-20, -1.637231183705709e-22,  7.337551814018079e-25,
 -3.230497104472050e-27,  5.841470497119695e-02, -4.843116056290899e-04,  3.915185106797493e-06, -2.811681885328495e-08,  1.857904509538516e-10, -1.154066555821044e-12,
  6.826030670166100e-15, -3.877667554059481e-17,  2.128736817677102e-19, -1.134590566878859e-21,  5.892328775350371e-24, -2.990199537479877e-26,  5.498853590170728e-02,
 -6.610875709061499e-04,  6.800806091666158e-06, -5.997796451280638e-08,  4.774282395993320e-10, -3.521873187138552e-12,  2.446467562378683e-14, -1.617645810912437e-16,
  1.026010025768969e-18, -6.278307978249728e-21,  3.722935760173517e-23, -2.146823396527324e-25,  5.100705982602526e-02, -8.501394444871261e-04,  1.087773401233727e-05,
 -1.159757359264865e-07,  1.095893606984731e-09, -9.469560282356291e-12,  7.626793059259345e-14, -5.799046398738140e-16,  4.200719692513683e-18, -2.918650091536316e-20,
  1.955213460764120e-22, -1.268041094788755e-24,  4.663475786414433e-02, -1.035848363408292e-03,  1.622359568233411e-05, -2.063895962454167e-07,  2.287736404900519e-09,
 -2.290558333948056e-11,  2.117457018485208e-13, -1.833889262911672e-15,  1.503556613762034e-17, -1.175974526849081e-19,  8.826279284617943e-22, -6.386592553663120e-24,
  4.203834082730206e-02, -1.203987844798157e-03,  2.277177827179122e-05, -3.417339325208965e-07,  4.399114487210250e-09, -5.057550878379895e-11,  5.321588413578151e-13,
 -5.208809046414666e-15,  4.797783024368259e-17, -4.194335758197269e-19,  3.503163487193443e-21, -2.809707490640829e-23,  3.737614464264639e-02, -1.342999834694061e-03,
  3.029687094171603e-05, -5.309067329673139e-07,  7.867754794076035e-09, -1.030528142638117e-10,  1.225354763240419e-12, -1.346418718581007e-14,  1.384474420352278e-16,
 -1.344723922777589e-18,  1.242627352992481e-20, -1.098597797914143e-22,  3.278946614228523e-02, -1.444823764490580e-03,  3.843026796356750e-05, -7.791454180471991e-07,
  1.318862762413322e-08, -1.954396621888132e-10,  2.609448180544585e-12, -3.199759570935704e-14,  3.652643711875444e-16, -3.920916973116126e-18,  3.988554268859052e-20,
 -3.868179337750797e-22,  2.839641365211262e-02, -1.505228743708427e-03,  4.670162849090335e-05, -1.086248898147590e-06,  2.085218247315238e-08, -3.473911967058588e-10,
  5.178317303269706e-12, -7.048447983714900e-14,  8.887901244657228e-16, -1.049443196417610e-17,  1.169905082591453e-19, -1.239251712411947e-21,  2.428847688517194e-02,
 -1.523678446410622e-03,  5.459690314763431e-05, -1.445511829847168e-06,  3.126190369850635e-08, -5.821100045438256e-10,  9.636384109156860e-12, -1.448896254557495e-13,
  2.008994141073189e-15, -2.598055945861830e-17,  3.161012833543680e-19, -3.642935694655853e-21,  2.052968295723076e-02, -1.502820455861525e-03,  6.162125844824070e-05,
 -1.843672546255842e-06,  4.464542592690601e-08, -9.241304507431825e-10,  1.690636606747908e-11, -2.795302479627109e-13,  4.243988715742571e-15, -5.987263110356339e-17,
  7.920520313585165e-19, -9.895312960323116e-21,  1.715794461007745e-02, -1.447728602584141e-03,  6.735563827158766e-05, -2.261947133394343e-06,  6.097783232781856e-08,
 -1.396002762924528e-09,  2.809402033782357e-11, -5.086395705345494e-13,  8.422620120851655e-15, -1.291440667307344e-16,  1.851057651258042e-18, -2.498552266139254e-20,
  1.418804652165221e-02, -1.365036446612597e-03,  7.149836891374340e-05, -2.677978703883806e-06,  7.993527915450854e-08, -2.014318108143949e-09,  4.439985410368371e-11,
 -8.767216913809350e-13,  1.577523995246161e-14, -2.619742435231559e-16,  4.054961262110233e-18, -5.894909695728393e-20,  1.161565819252797e-02, -1.262086383202978e-03,
  7.388716614007547e-05, -3.068341025679677e-06,  1.008915988781331e-07, -2.785783122054396e-09,  6.697898714722290e-11, -1.437000395621879e-12,  2.799726509388154e-14,
 -5.018955377886557e-16,  8.362973961618767e-18, -1.305491148835799e-19,  9.421792529588118e-03, -1.146189339118824e-03,  7.450105252687191e-05, -3.411144079701856e-06,
  1.229615427786774e-07, -3.704159752329543e-09,  9.676430107439014e-11, -2.247508842230430e-12,  4.725432809422221e-14, -9.115476824537874e-16,  1.630214444764124e-17,
 -2.724839043849120e-19,  7.577222645335873e-03, -1.024053336951779e-03,  7.344513590321467e-05, -3.688307347936100e-06,  1.450844082104944e-07, -4.748785449476034e-09,
  1.342806445570015e-10, -3.364833247966196e-12,  7.609957221763056e-14, -1.574855638491731e-15,  3.014221122260385e-17, -5.379776754535443e-19,  6.046496881039650e-03,
 -9.014031602639160e-04,  7.092338962089415e-05, -3.887175070970925e-06,  1.661336628080174e-07, -5.885097809719171e-09,  1.794850021372073e-10, -4.836114467503750e-12,
  1.172851955136942e-13, -2.596278176701539e-15,  5.303352885711394e-17, -1.008057138525144e-18,  4.791327398042126e-03, -7.827835964122891e-04,  6.720536991198889e-05,
 -4.001306924445418e-06,  1.850337871466570e-07, -7.067184789499863e-09,  2.316664238238055e-10, -6.690464831484846e-12,  1.734708817529795e-13, -4.095951494243192e-15,
  8.905405594204867e-17, -1.798135844806248e-18,  3.773250809195647e-03, -6.715182311780867e-04,  6.259239429226492e-05, -4.030443046518563e-06,  2.008656125106439e-07,
 -8.241976084163216e-09,  2.894298979357299e-10, -8.931300044298652e-12,  2.468569977388989e-13, -6.200138927440316e-15,  1.431094301687724e-16, -3.061901039505176e-18,
  2.955557890003643e-03, -5.697850159435291e-04,  5.738747669180209e-05, -3.979777396135839e-06,  2.129453577672446e-07, -9.354386847777054e-09,  3.507725893611799e-10,
 -1.153109424961727e-11,  3.387936525249298e-13, -9.027327016259915e-15,  2.206438151046187e-16, -4.990174968360699e-18,  2.304558413739817e-03, -4.787675110830624e-04,
  5.187171499163571e-05, -3.858756663741811e-06,  2.208688986196181e-07, -1.035258809659990e-08,  4.132430957899757e-10, -1.442971391820541e-11,  4.494308551114978e-13,
 -1.267137861844185e-14,  3.271492622228383e-16, -7.802641881097123e-18,  1.790287388094898e-03, -3.988445241448237e-04,  4.628824336972064e-05, -3.679648786092534e-06,
  2.245197407650345e-07, -1.119262320467737e-08,  4.741591034514730e-10, -1.753685344071666e-11,  5.774751638367812e-13, -1.718408134487307e-14,  4.675031070803772e-16,
 -1.173121897147526e-17,  1.386774966784922e-03, -3.297882580702014e-04,  4.083356247051219e-05, -3.456104322084550e-06,  2.240451411223978e-07, -1.184178284011818e-08,
  5.308495331073042e-10, -2.073834197510078e-11,  7.201033911332932e-13, -2.255993720941008e-14,  6.452068800842113e-16, -1.699533633790763e-17,  1.072000358324018e-03,
 -2.709498046826976e-04,  3.565517473461221e-05, -3.201881893473015e-06,  2.198088223513507e-07, -1.228042687502396e-08,  5.808855160067398e-10, -2.390540309875239e-11,
  8.730573970957259e-13, -2.872595127109868e-14,  8.616345972108918e-16, -2.377119677687656e-17,  8.276366295355039e-04, -2.214191860002968e-04,  3.085399243088154e-05,
 -2.929843600073805e-06,  2.123304240982659e-07, -1.250222904022297e-08,  6.222697992784600e-10, -2.690548120113058e-11,  1.030912241050614e-12, -3.553847997196448e-14,
  1.115412835860682e-15, -3.215877718895863e-17,  6.386740364731645e-04, -1.801541416020972e-04,  2.648988468264799e-05, -2.651263002516128e-06,  2.022214731766550e-07,
 -1.251305862478668e-08,  6.535643200480800e-10, -2.961308499209924e-11,  1.187480519933698e-12, -4.278804828738016e-14,  1.402044343393812e-15, -4.215144876374111e-17,
  4.929887025412628e-04, -1.460770474280858e-04,  2.258888132108772e-05, -2.375437018390980e-06,  1.901258351844122e-07, -1.232886773693692e-08,  6.739478275962472e-10,
 -3.191923823466975e-11,  1.336295008916569e-12, -5.021171020425888e-14,  1.713852440372835e-15, -5.361329086847268e-17,  3.809039609370236e-04, -1.181427239841518e-04,
  1.915084530690984e-05, -2.109558494794168e-06,  1.766700512766005e-07, -1.197301341974812e-08,  6.832068201085297e-10, -3.373849944720733e-11,  1.471103356123753e-12,
 -5.751131349305066e-14,  2.040272816469697e-15, -6.626834206383424e-17,  2.947750768651730e-04, -9.538170708149772e-05,  1.615676846016513e-05, -1.858788375289960e-06,
  1.624263124004639e-07, -1.147342354804268e-08,  6.816717056058782e-10, -3.501300484379103e-11,  1.586312839240757e-12, -6.437518761281262e-14,  2.368463985301282e-15,
 -7.970432616800551e-17,  2.286149794871304e-04, -7.692418673314861e-05,  1.357517115928067e-05, -1.626462415101884e-06,  1.478885415341119e-07, -1.085993881614395e-08,
  6.701150415233804e-10, -3.571348668211226e-11,  1.677337457129916e-12, -7.050043979669932e-14,  2.684159624630445e-15, -9.339118489968092e-17,  1.777690202426322e-04,
 -6.200965669037953e-05,  1.136735727138553e-05, -1.414373134873984e-06,  1.334603886297926e-07, -1.016205865917167e-08,  6.496299790987133e-10, -3.583763057197639e-11,
  1.740819580725159e-12, -7.561322367217000e-14,  2.972654501801718e-15, -1.067125198278334e-16,  1.386402089334415e-04, -4.998669450755241e-05,  9.491475829139455e-06,
 -1.223078897517412e-06,  1.194529496997887e-07, -9.407211572283481e-09,  6.215053630248922e-10, -3.540640695910294e-11,  1.774719355248772e-12, -7.948493037120966e-14,
  3.219805159643729e-15, -1.190062454998096e-16,  1.084622714922562e-04, -4.030646744653415e-05,  7.905472094416846e-06, -1.052205116218517e-06,  1.060896245108923e-07,
 -8.619577621386622e-09,  5.871103828155531e-10, -3.445913101209469e-11,  1.778283151617589e-12, -8.194307146751896e-14,  3.412936374411011e-15, -1.296096946717326e-16,
  8.511561132264045e-05, -3.251270848139177e-05,  6.569083210694822e-06, -9.007151705183620e-07,  9.351558002319354e-08, -7.819422332819983e-09,  5.477973307243019e-10,
 -3.304799051039482e-11,  1.751915178236953e-12, -8.287649060482952e-14,  3.541569840849537e-15, -1.379042116796869e-16,  6.698028881520649e-05, -2.623013359631447e-05,
  5.445061995921010e-06, -7.671391816953904e-07,  8.180962446751026e-08, -7.022858826564776e-09,  5.048267838581687e-10, -3.123267088420793e-11,  1.696983041775527e-12,
 -8.223530101585675e-14,  3.597925573724766e-15, -1.433548444700015e-16,  5.282001037708068e-05, -2.115262671320347e-05,  4.499810926842908e-06, -6.497567940086911e-07,
  7.099677261603529e-08, -6.241936250462458e-09,  4.593159857030436e-10, -2.907554380176304e-11,  1.615589068181425e-12, -8.002649952466383e-14,  3.577181853984525e-15,
 -1.455418808768467e-16,  4.169149628144756e-05, -1.703201521748057e-05,  3.703589266645883e-06, -5.467355357636800e-07,  6.106028441619662e-08, -5.484951846846340e-09,
  4.122086385505868e-10, -2.663770976428647e-11,  1.510335892845101e-12, -7.630651573152479e-14,  3.477510215946395e-15, -1.441823842158348e-16,  3.287423171512778e-05,
 -1.366788825169885e-05,  3.030428896096862e-06, -4.562295500217833e-07,  5.195241421387793e-08, -4.756895164488685e-09,  3.642627684429353e-10, -2.397602504829782e-11,
  1.384108871159049e-12, -7.117203161748469e-14,  3.299924185659416e-15, -1.391412872318423e-16,  2.581633477466882e-05, -1.089865170916484e-05,  2.457865081098118e-06,
 -3.764449919691272e-07,  4.360347874645223e-08, -4.059950411041971e-09,  3.160526587010427e-10, -2.114111616190292e-11,  1.239890844123533e-12, -6.475029996282249e-14,
  3.047992811984444e-15, -1.304327828155035e-16,  2.009299821043223e-05, -8.593844591051768e-06,  1.966561003030952e-06, -3.056787034307979e-07,  3.592912790102174e-08,
 -3.394002369946443e-09,  2.679808557642000e-10, -1.817629724142417e-11,  1.080617983010561e-12, -5.718996333202760e-14,  2.727473036832289e-15, -1.182135741835823e-16,
  1.537462250006334e-05, -6.647638460966731e-06,  1.539881376858284e-06, -2.423363480009557e-07,  2.883588948061423e-08, -2.757109799803014e-09,  2.202967072159998e-10,
 -1.511725626651616e-11,  9.090796717174888e-13, -4.865309256764837e-14,  2.345910536439864e-15, -1.027699777129184e-16,  1.140233145378331e-05, -4.973386155970830e-06,
  1.163451700695389e-06, -1.849353985879612e-07,  2.222517609625555e-08, -2.145926450281671e-09,  1.731186164209254e-10, -1.199235990712069e-11,  7.278611619138131e-13,
 -3.930888176910900e-14,  1.912249566866302e-15, -8.450095336206257e-17,  7.969050225911015e-06, -3.499066338345754e-06,  8.247265300786979e-07, -1.320976314501836e-07,
  1.599602774593320e-08, -1.556065148666981e-09,  1.264581973491093e-10, -8.823447320738138e-12,  5.393258178971144e-13, -2.932923003041219e-14,  1.436482958733595e-15,
 -6.389903760967082e-17,  4.904834632451948e-06, -2.163520283034867e-06,  5.125928784340489e-07, -8.253700112464066e-08,  1.004714822379054e-08, -9.824357587392141e-10,
  8.024738929124660e-11, -5.627152092922485e-12,  3.456413952941955e-13, -1.888673479543633e-14,  9.293859036579930e-16, -4.153187510250731e-17,  2.068109206146340e-06,
 -9.145636999630063e-07,  2.173085349513435e-07, -3.509339047111108e-08,  4.284344171428604e-09, -4.201393929234469e-10,  3.441492056305595e-11, -2.419961148028087e-12,
  1.490479410959680e-13, -8.166088101901564e-15,  4.028902560187190e-16, -1.805008338468210e-17,  6.331640362121298e-02, -1.670267205468558e-04,  4.589753917666181e-07,
 -1.302972963251933e-09,  3.786799321826489e-12, -1.117629203572399e-14,  3.328439542448415e-17, -9.957037014430032e-20,  2.982755588744399e-22, -8.930100224985284e-25,
  2.668784429254920e-27, -7.955985338745121e-30,  6.212954490339828e-02, -2.198871431140947e-04,  9.114403987605551e-07, -3.868506937095186e-09,  1.612897254398660e-11,
 -6.561043867712636e-14,  2.608848644273693e-16, -1.017192478681940e-18,  3.899769991848552e-21, -1.473359589615914e-23,  5.494840416203747e-26, -2.025640180855479e-28,
  5.982581413385610e-02, -3.194445639974929e-04,  1.907199051868480e-06, -1.071428338492210e-08,  5.670764864375200e-11, -2.866020944984322e-13,  1.396419987732023e-15,
 -6.601199554989395e-18,  3.041333150823357e-20, -1.370286132217607e-22,  6.053568654242844e-25, -2.627696927174165e-27,  5.653803373361808e-02, -4.542908952061679e-04,
  3.594885336731655e-06, -2.532027691606026e-08,  1.642632454514686e-10, -1.002537207655792e-12,  5.829820763215762e-15, -3.257520625558847e-17,  1.759719850355566e-19,
 -9.232392649788305e-22,  4.721110329534139e-24, -2.359678242708653e-26,  5.244861671693339e-02, -6.094353573543174e-04,  6.124678478221447e-06, -5.287218628002902e-08,
  4.125137397929065e-10, -2.985562824555023e-12,  2.036288853855631e-14, -1.322786591566082e-16,  8.246662297428546e-19, -4.962160416871405e-21,  2.894491097619397e-23,
 -1.642403660423327e-25,  4.777213426427455e-02, -7.684000985818477e-04,  9.585288760724725e-06, -9.986237381280801e-08,  9.235660523379325e-10, -7.819707581797081e-12,
  6.176472681124926e-14, -4.608863445172432e-16,  3.278298715282768e-18, -2.237719813457304e-20,  1.473328936725270e-22, -9.394687389518688e-25,  4.273609107870266e-02,
 -9.153771397156040e-04,  1.395227449796292e-05, -1.731911189862804e-07,  1.876549676096982e-09, -1.838918577382390e-11,  1.665418712750597e-13, -1.414187434970177e-15,
  1.137518728963743e-17, -8.733326815866791e-20,  6.437379018276096e-22, -4.576494828394622e-24,  3.756235942164575e-02, -1.037092888673357e-03,  1.906202572598348e-05,
 -2.787928832569936e-07,  3.504349596564608e-09, -3.939341038965608e-11,  4.057159421098872e-13, -3.890313911900299e-15,  3.512842742350656e-17, -3.012414515770242e-19,
  2.469294040596615e-21, -1.944625686175606e-23,  3.245137336961768e-02, -1.124115221793686e-03,  2.461812591340552e-05, -4.200329571010868e-07,  6.072656142302163e-09,
 -7.770916238564621e-11,  9.037371509715850e-13, -9.721219679323507e-15,  9.792967798567704e-17, -9.324651966773300e-19,  8.451929720704205e-21, -7.333095394888265e-23,
  2.757053920437929e-02, -1.171469676489684e-03,  3.022788477396836e-05, -5.962774244641740e-07,  9.839841587797934e-09, -1.423634902918675e-10,  1.857950358584318e-12,
 -2.229014858247100e-14,  2.491488128030327e-16, -2.620550042151417e-18,  2.613568462222811e-20, -2.486398686287376e-22,  2.304753234643412e-02, -1.178571144333263e-03,
  3.545934284808166e-05, -8.020614087131857e-07,  1.500253387591523e-08, -2.438997559104156e-10,  3.552003757247651e-12, -4.728173680319492e-14,  5.835426505974471e-16,
 -6.748628545570199e-18,  7.373310509255537e-20, -7.658971926060283e-22,  1.896838775268721e-02, -1.148594072254591e-03,  3.990493864872151e-05, -1.027152047406401e-06,
  2.163799732857709e-08, -3.930393308272532e-10,  6.354632793393325e-12, -9.340898466067945e-14,  1.267276652378961e-15, -1.604726730010859e-17,  1.913020289105755e-19,
 -2.161415591641602e-21,  1.537967959531896e-02, -1.087476735044708e-03,  4.323797704879797e-05, -1.257569248394176e-06,  2.965796364764971e-08, -5.987459476785205e-10,
  1.069590483848253e-11, -1.728562494101149e-13,  2.567377849098275e-15, -3.545902652887430e-17,  4.595384229226143e-19, -5.627642779677644e-21,  1.229370327658962e-02,
 -1.002776891871667e-03,  4.525142952432186e-05, -1.477372352957139e-06,  3.878762245982080e-08, -8.660265758264077e-10,  1.701715601913542e-11, -3.011197817207657e-13,
  4.877560950878267e-15, -7.321192076479484e-17,  1.027942773917679e-18, -1.360010882509672e-20,  9.695434563877269e-03, -9.025733110166060e-04,  4.587394841593329e-05,
 -1.670829372186508e-06,  4.857801085891341e-08, -1.193966003008059e-09,  2.569799750471410e-11, -4.959684784480147e-13,  8.729909023997190e-15, -1.419247540483663e-16,
  2.152000104794361e-18, -3.066576894327186e-20,  7.550113060452181e-03, -7.945550528284205e-04,  4.516355032618379e-05, -1.824512164462387e-06,  5.845173393796384e-08,
 -1.574519201092962e-09,  3.697189764605466e-11, -7.754124144824813e-13,  1.478068278574217e-14, -2.594273809261015e-16,  4.235210674483916e-18, -6.481339443267986e-20,
  5.810515731316652e-03, -6.853757970764004e-04,  4.328379056216503e-05, -1.928914752367074e-06,  6.777354192833694e-08, -1.992450295474951e-09,  5.084805048558425e-11,
 -1.154831773566866e-12,  2.376119511176706e-14, -4.488795173502129e-16,  7.866886089747627e-18, -1.289345076808673e-19,  4.423276558157161e-03, -5.802896038816387e-04,
  4.046963075282583e-05, -1.979340450187696e-06,  7.593143705376930e-08, -2.426544515473817e-09,  6.705890777991339e-11, -1.643709778544702e-12,  3.639168866117248e-14,
 -7.377770931449003e-16,  1.384209532660722e-17, -2.423213402503864e-19,  3.333904369239948e-03, -4.830378726075759e-04,  3.699051836145085e-05, -1.975991019514657e-06,
  8.241226810099535e-08, -2.851912030701309e-09,  8.504873834725913e-11, -2.242628632571836e-12,  5.326620943680958e-14, -1.155589431122285e-15,  2.314816992595775e-17,
 -4.317355074772240e-19,  2.490404946267509e-03, -3.959294052412613e-04,  3.311690919113332e-05, -1.923361536468918e-06,  8.685826779781671e-08, -3.242946163027718e-09,
  1.040097834245842e-10, -2.941239031292278e-12,  7.472668001688844e-14, -1.730068719800148e-15,  3.690476716977434e-17, -7.315046185405531e-19,  1.845600209731849e-03,
 -3.200456720722999e-04,  2.909429372130877e-05, -1.829158772752756e-06,  8.909645980374198e-08, -3.576366535005821e-09,  1.229616235161724e-10, -3.717764994070236e-12,
  1.007511949929111e-13, -2.482648915352582e-15,  5.625246058096404e-17, -1.182118686310233e-18,  1.358350904695504e-03, -2.555075306811597e-04,  2.512645326980135e-05,
 -1.703003872066054e-06,  8.913939415268852e-08, -3.833797164660888e-09,  1.408595796360269e-10, -4.540289706029835e-12,  1.308821937020927e-13, -3.423691708875484e-15,
  8.219703652959669e-17, -1.826993576003689e-18,  9.939380937036139e-04, -2.017523297503409e-04,  2.136770647413716e-05, -1.555159459307788e-06,  8.716141189905393e-08,
 -4.003477567362507e-09,  1.567121083192941e-10, -5.369675992973253e-12,  1.642137694101292e-13, -4.548523016684291e-15,  1.154300182377774e-16, -2.707437719709665e-18,
  7.238588119523656e-04, -1.577863799545482e-04,  1.792258899694586e-05, -1.395458524285097e-06,  8.345835479200767e-08, -4.080924473966931e-09,  1.696865208279934e-10,
 -6.163621504878197e-12,  1.994454790825561e-13, -5.835155477143090e-15,  1.561562532345830e-16, -3.856324224731551e-18,  5.252602851237175e-04, -1.223932840074730e-04,
  1.485078329543374e-05, -1.232532962969259e-06,  7.839991474033651e-08, -4.068585727480900e-09,  1.791865507198531e-10, -6.881129852561856e-12,  2.349959771810982e-13,
 -7.244305401039530e-15,  2.039629816678198e-16, -5.291403534263528e-18,  3.801910602699578e-04, -9.429124529830352e-05,  1.217506263929385e-05, -1.073365133438658e-06,
  7.238297621703611e-08, -3.974701615230825e-09,  1.848925764275353e-10, -7.486641987606920e-12,  2.691575465947037e-13, -8.721859360786298e-15,  2.577598611764624e-16,
 -7.009451760784491e-18,  2.747982627251132e-04, -7.224130143043000e-05,  9.890340840850517e-06, -9.231297181766516e-07,  6.579209155012597e-08, -3.811683139503978e-09,
  1.867633935522602e-10, -7.953206076403368e-12,  3.002652890402188e-13, -1.020345071912927e-14,  3.158068398845235e-16, -8.982438022669101e-18,  1.985556299621668e-04,
 -5.511356884582848e-05,  7.972429064146562e-06, -7.852604990245098e-07,  5.897049839281163e-08, -3.594329525370774e-09,  1.850052824518988e-10, -8.264312308566511e-12,
  3.268537878954197e-13, -1.162040185678967e-14,  3.758298138280753e-16, -1.115659207167010e-17,  1.435708404478880e-04, -4.192073657307754e-05,  6.385636567924196e-06,
 -6.616655647982110e-07,  5.220254851254418e-08, -3.338156873563639e-09,  1.800184556538245e-10, -8.414304317084693e-12,  3.477789492601068e-13, -1.290606974966473e-14,
  4.352071785966866e-16, -1.345473150248625e-17,  1.039939881053891e-04, -3.182811874284988e-05,  5.088813387145942e-06, -5.530193914511960e-07,  4.570650319963242e-08,
 -3.058024101946270e-09,  1.723324474842024e-10, -8.407529895773260e-12,  3.622914689176962e-13, -1.400163533576270e-14,  4.911978928964415e-16, -1.578160060041949e-17,
  7.553112376693468e-05, -2.414842841867505e-05,  4.039773897131820e-06, -4.590744594299086e-07,  3.963551739594109e-08, -2.767148560569601e-09,  1.625410430835883e-10,
 -8.256563450284559e-12,  3.700583448897900e-13, -1.486057215243076e-14,  5.411761585606599e-16, -1.803143358132429e-17,  5.505599168465014e-05, -1.832775200029323e-05,
  3.198255492344729e-06, -3.789526780827635e-07,  3.408422099612082e-08, -2.476522367688517e-09,  1.512447918180639e-10, -7.979904757223067e-12,  3.711376688670525e-13,
 -1.545134415896178e-14,  5.828397857177343e-16, -2.009660698887158e-17,  4.030758733112070e-05, -1.392744902260690e-05,  2.527674915862694e-06, -3.113936539972863e-07,
  2.909842937916555e-08, -2.194682620123284e-09,  1.390059598141029e-10, -7.599543329519685e-12,  3.659180084126583e-13, -1.575822808620350e-14,  6.143672956100002e-16,
 -2.187615013169679e-17,  2.965924693056376e-05, -1.060514421349416e-05,  1.995974795343478e-06, -2.549504087921838e-07,  2.468595874945469e-08, -1.927756640826438e-09,
  1.263177338979429e-10, -7.138701536844078e-12,  3.550364682833687e-13, -1.578045492553550e-14,  6.345101537362522e-16, -2.328302859403630e-17,  2.194526351000707e-05,
 -8.096734193042232e-06,  1.575833678224394e-06, -2.081327005714352e-07,  2.082709232800621e-08, -1.679693848023206e-09,  1.135870923458916e-10, -6.619964154739067e-12,
  3.392892994637003e-13, -1.553006936056043e-14,  6.426182995923755e-16, -2.424943767758023e-17,  1.633248716773725e-05, -6.200418131198890e-06,  1.244468309785593e-06,
 -1.695038427217909e-07,  1.748380144019849e-08, -1.452602225506325e-09,  1.011292071453797e-10, -6.063894898462397e-12,  3.195465604226519e-13, -1.502899904292823e-14,
  6.386069611159354e-16, -2.472974551724363e-17,  1.222631893188373e-05, -4.763142967014745e-06,  9.832041923002568e-07, -1.377395947307092e-07,  1.460729036320115e-08,
 -1.247122834066500e-09,  8.917050675785375e-11, -5.488150713070828e-12,  2.966788609931365e-13, -1.430581915969555e-14,  6.228792121747265e-16, -2.470111639286346e-17,
  9.202523645726414e-06, -3.669469376162107e-06,  7.769401699840004e-07, -1.116582366524237e-07,  1.214377380743898e-08, -1.062794514348215e-09,  7.785743840919903e-11,
 -4.907041393219531e-12,  2.715005641895305e-13, -1.339262007483786e-14,  5.962215017577008e-16, -2.416215376804264e-17,  6.958136200147583e-06, -2.832651606535273e-06,
  6.135902631216589e-07, -9.023017583072363e-08,  1.003861320108592e-08, -8.983788408309433e-10,  6.726830470445068e-11, -4.331446637782275e-12,  2.447306462605259e-13,
 -1.232227065054257e-14,  5.596889378839772e-16, -2.313009379290864e-17,  5.276314196028045e-06, -2.187627336899057e-06,  4.835529976260089e-07, -7.257403420704252e-08,
  8.239053137480256e-09, -7.521302249972274e-10,  5.742610284839481e-11, -3.768990746612731e-12,  2.169700710870011e-13, -1.112624733942673e-14,  5.144944092603535e-16,
 -2.163714985417204e-17,  4.001274344388999e-06, -1.685589376797818e-06,  3.792346718791929e-07, -5.794458333070616e-08,  6.695839749866626e-09, -6.220069943914649e-10,
  4.831090402780246e-11, -3.224380224323551e-12,  1.886931048451439e-13, -9.833090963018904e-15,  4.619117606059970e-16, -1.972657751848322e-17,  3.020458071878446e-06,
 -1.289827820440071e-06,  2.946369465944532e-07, -4.571640584436807e-08,  5.363994830432771e-09, -5.058264141339600e-10,  3.987087011882920e-11, -2.699824710277471e-12,
  1.602493804468945e-13, -8.467471148860322e-15,  4.031991551944650e-16, -1.744892954998650e-17,  2.251841915121700e-06, -9.725679784315992e-07,  2.250090796799178e-07,
 -3.536590227890463e-08,  4.202984941870556e-09, -4.013706138678737e-10,  3.203146104832277e-11, -2.195481174808296e-12,  1.318735257307875e-13, -7.049786164220644e-15,
  3.395451412228159e-16, -1.485883733952253e-17,  1.634883990732540e-06, -7.125728194546315e-07,  1.665593947385059e-07, -2.645327577413521e-08,  3.176479692259554e-09,
 -3.064521000440676e-10,  2.470272641684620e-11, -1.709881326106477e-12,  1.036995907755111e-13, -5.596201479143367e-15,  2.720371913853085e-16, -1.201251876380796e-17,
  1.124021721138620e-06, -4.933216938450394e-07,  1.162178980954154e-07, -1.860542540541306e-08,  2.251850734440314e-09, -2.189480464631967e-10,  1.778483097169384e-11,
 -1.240321806816267e-12,  7.577825214037864e-14, -4.119033273868192e-15,  2.016509744587873e-16, -8.966105076844181e-18,  6.839577520775407e-07, -3.016221097506950e-07,
  7.144274241866901e-08, -1.150046270342130e-08,  1.399558036361311e-09, -1.368154148800018e-10,  1.117239303275790e-11, -7.832315648555764e-13,  4.809671207304060e-14,
 -2.627462500465937e-15,  1.292610321664960e-16, -5.774935788623015e-18,  2.865555703217226e-07, -1.267054371113785e-07,  3.010206272171895e-08, -4.860505542557107e-09,
  5.933036078223274e-10, -5.817319750563244e-11,  4.764460961929795e-12, -3.349758784815930e-13,  2.062861061924933e-14, -1.130049977960438e-15,  5.574561256932726e-17,
 -2.497148691324152e-18,  6.265554275143183e-02, -1.634164468161505e-04,  4.436960106389049e-07, -1.244129906855423e-09,  3.571041361163415e-12, -1.040987261055624e-14,
  3.062536256062638e-17, -9.051998826657565e-20,  2.679673063219013e-22, -7.929384035561063e-25,  2.342458229210194e-27, -6.903612237229942e-30,  6.126429143556374e-02,
 -2.127770187411767e-04,  8.665244701058967e-07, -3.620610288816446e-09,  1.487713999840739e-11, -5.967735238797190e-14,  2.340737601315451e-16, -9.004790169666763e-19,
  3.406866914486871e-21, -1.270395365040488e-23,  4.676918167306996e-26, -1.702144193703904e-28,  5.857775799307676e-02, -3.046862568134648e-04,  1.783888159543276e-06,
 -9.851057331704920e-09,  5.129632564313770e-11, -2.552004397025771e-13,  1.224502027993681e-15, -5.702445079488146e-18,  2.588967606147071e-20, -1.149764990004803e-22,
  5.007726974655610e-25, -2.143485984764134e-27,  5.477652510552955e-02, -4.267039821623042e-04,  3.306173415287230e-06, -2.284516790461007e-08,  1.455409405461812e-10,
 -8.729599200505968e-13,  4.991802416401013e-15, -2.744137879939255e-17,  1.458984847464242e-19, -7.536256622518046e-22,  3.795296723060832e-24, -1.868640047320660e-26,
  5.010500448915929e-02, -5.628679623151009e-04,  5.527925787114931e-06, -4.672431097009377e-08,  3.574043074836287e-10, -2.538474544632507e-12,  1.700319622082401e-14,
 -1.085374919872424e-16,  6.652377078343419e-19, -3.936914524302415e-21,  2.259424621220972e-23, -1.261774471624250e-25,  4.484464856196558e-02, -6.962713561066636e-04,
  8.470691008002410e-06, -8.626011249845247e-08,  7.810083929816030e-10, -6.481063226912028e-12,  5.021514557220573e-14, -3.678088304268635e-16,  2.569540291302580e-18,
 -1.723450114822614e-20,  1.115471580795611e-22, -6.994642363474779e-25,  3.928534182918105e-02, -8.115883005097031e-04,  1.204266136707424e-05, -1.459041818663150e-07,
  1.545729501546485e-09, -1.482895182451195e-11,  1.316013336879414e-13, -1.095884512409666e-15,  8.649931739484610e-18, -6.520250869728439e-20,  4.720926224922349e-22,
 -3.298102847850221e-24,  3.369906286144594e-02, -8.970821739462716e-04,  1.602854682084385e-05, -2.285320542105729e-07,  2.805646295972259e-09, -3.084572706004236e-11,
  3.110211657310205e-13, -2.922212896313363e-15,  2.587302936911638e-17, -2.176818676046027e-19,  1.751552495862325e-21, -1.354651481728892e-23,  2.831906527683485e-02,
 -9.457909303242323e-04,  2.011299640168253e-05, -3.342120021644002e-07,  4.715028590194624e-09, -5.896051882182639e-11,  6.708000234032134e-13, -7.065150247556485e-15,
  6.974113219806428e-17, -6.511167879323104e-19,  5.789961210971303e-21, -4.930779687637784e-23,  2.332650139082210e-02, -9.557931210743567e-04,  2.393052545795829e-05,
 -4.593923933356515e-07,  7.392236659689853e-09, -1.044417023791783e-10,  1.332585822179233e-12, -1.564467966334251e-14,  1.712565690608836e-16, -1.765263672984343e-18,
  1.726381612944405e-20, -1.611345560760426e-22,  1.884494814018771e-02, -9.296573849566273e-04,  2.712773462137434e-05, -5.968278612320501e-07,  1.087980649951050e-08,
 -1.726338955804880e-10,  2.456724507431968e-12, -3.198636368917948e-14,  3.864451004351926e-16, -4.378056134546277e-18,  4.688654576442188e-20, -4.776580739374956e-22,
  1.494201107264627e-02, -8.733200117023213e-04,  2.942155260713888e-05, -7.363571034818787e-07,  1.511206715153965e-08, -2.678163534286629e-10,  4.229614556258201e-12,
 -6.079053997600425e-14,  8.070864405792014e-16, -1.000845697737370e-17,  1.169180748183799e-19, -1.295229692711409e-21,  1.163629873147125e-02, -7.946962950411993e-04,
  3.064019286833664e-05, -8.663862388847391e-07,  1.990142385032244e-08, -3.919040115723564e-10,  6.836948616742416e-12, -1.080109781328680e-13,  1.569566279312736e-15,
 -2.122490666270613e-17,  2.694976476357129e-19, -3.235423981263324e-21,  8.907662882561451e-03, -7.023143301602553e-04,  3.073974426056701e-05, -9.757222359692540e-07,
  2.495003338426699e-08, -5.433319485122386e-10,  1.042517218025520e-11, -1.803126302828038e-13,  2.857262616869903e-15, -4.198697456217748e-17,  5.775316628062829e-19,
 -7.490060243182313e-21,  6.708650896011499e-03, -6.041867578653467e-04,  2.979636072558089e-05, -1.055314363774838e-06,  2.988643467569913e-08, -7.164785790582621e-10,
  1.505850014014519e-11, -2.840730567005502e-13,  4.891552334705461e-15, -7.785393842397334e-17,  1.156485081929369e-18, -1.615441696835190e-20,  4.975490973345427e-03,
 -5.070375011267254e-04,  2.797968223974966e-05, -1.099516537812930e-06,  3.431942293288493e-08, -9.018707410914382e-10,  2.068237759249227e-11, -4.240398946350824e-13,
  7.908163167104073e-15, -1.359018944564704e-16,  2.173711272134342e-18, -3.261169675897652e-20,  3.637470703147604e-03, -4.159056254882723e-04,  2.551614215569112e-05,
 -1.106644354447504e-06,  3.789670191681231e-08, -1.087206945238669e-09,  2.710456394389308e-11, -6.019088325389636e-13,  1.211930766220364e-14, -2.242088936258780e-16,
  3.850565404304085e-18, -6.188029467576156e-20,  2.624128451863459e-03, -3.340768335515881e-04,  2.265102652436447e-05, -1.078800882684617e-06,  4.035511174766762e-08,
 -1.259006199451574e-09,  3.400146510925438e-11, -8.151801014081741e-13,  1.766692884478567e-14, -3.508511057810383e-16,  6.452350873980001e-18, -1.107862218599478e-19,
  1.870150284676812e-03, -2.632529893557166e-04,  1.961623417097354e-05, -1.021117773427021e-06,  4.155237738699621e-08, -1.404520067381952e-09,  4.095092222483319e-11,
 -1.056638087598552e-12,  2.457675321498192e-14, -5.224913493921407e-16,  1.026283784451505e-17, -1.878011423370764e-19,  1.318198420202345e-03, -2.038596996819442e-04,
  1.660772488504647e-05, -9.406591462802906e-07,  4.147587248654508e-08, -1.513489719165001e-09,  4.748556762566292e-11, -1.314669265439482e-12,  3.272483026545354e-14,
 -7.427944561481002e-16,  1.554372440983596e-17, -3.024160668952089e-19,  9.200820187492758e-04, -1.554034059764362e-04,  1.377367412449487e-05, -8.452537383951969e-07,
  4.022979446081800e-08, -1.579396409612165e-09,  5.315551040678868e-11, -1.574425680141850e-12,  4.182669781820329e-14, -1.011015127142878e-15,  2.248415587218852e-17,
 -4.640116715950011e-19,  6.367398703095418e-04, -1.168126566643655e-04,  1.121208297694129e-05, -7.424722133019369e-07,  3.800663096328439e-08, -1.600008184911550e-09,
  5.758718526573950e-11, -1.819623666595666e-12,  5.145441717814112e-14, -1.321123484055954e-15,  3.114972865882699e-17, -6.803237108728709e-19,  4.374746981273916e-04,
 -8.672433947111377e-05,  8.975312178991223e-06, -6.388820794851247e-07,  3.505092614636723e-08, -1.577208997341170e-09,  6.052701196505136e-11, -2.034611824741329e-12,
  6.107994938162424e-14, -1.661742172820587e-15,  4.144259153607662e-17, -9.557466943126323e-19,  2.987993269042560e-04, -6.369854546417865e-05,  7.078661463520637e-06,
 -5.396237460032990e-07,  3.162312218547897e-08, -1.516251667017970e-09,  6.186309003445991e-11, -2.206294014213281e-12,  7.013688246381584e-14, -2.016988562815405e-15,
  5.308321993413216e-17, -1.289819595072616e-18,  2.031580882879151e-04, -4.636239079003406e-05,  5.510439396225785e-06, -4.482803887165637e-07,  2.796933358972654e-08,
 -1.424666857005323e-09,  6.162377282828134e-11, -2.325557147156431e-12,  7.808837934647386e-14, -2.368101661199022e-15,  6.562020211462504e-17, -1.676251376744300e-18,
  1.376945037847378e-04, -3.349302554389867e-05,  4.241645276988393e-06, -3.669718038580293e-07,  2.430025681733882e-08, -1.311077661346146e-09,  5.995689844152715e-11,
 -2.387997645580133e-12,  8.448847933288634e-14, -2.695552386438933e-15,  7.846812784175572e-17, -2.102756859708788e-18,  9.316037605386053e-05, -2.405426106672631e-05,
  3.234140004708712e-06, -2.965878770361180e-07,  2.077987797425801e-08, -1.184127834303746e-09,  5.709654365340839e-11, -2.393912607366415e-12,  8.902641800916581e-14,
 -2.981239885537665e-15,  9.096730683617705e-17, -2.551805660409985e-18,  6.300592538607609e-05, -1.720145436912587e-05,  2.446836970546742e-06, -2.370837074806515e-07,
  1.752276058476878e-08, -1.051657446304316e-09,  5.332505486339550e-11, -2.347671446953157e-12,  9.154829925248564e-14, -3.210385749441174e-15,  1.024544326101130e-16,
 -3.002187451018465e-18,  4.265443546704447e-05, -1.226721373960815e-05,  1.839913772009208e-06, -1.877766047233746e-07,  1.459766609315303e-08, -9.201797601559456e-10,
  4.893713926000513e-11, -2.256677856120474e-12,  9.205568336082272e-14, -3.372837517879804e-15,  1.123316199212592e-16, -3.431123751259643e-18,  2.894436406017260e-05,
 -8.737495475904937e-06,  1.377321555649703e-06, -1.476069139058678e-07,  1.203500055164500e-08, -7.946470806149446e-10,  4.421070805679327e-11, -2.130160513862965e-12,
  9.068502277068519e-14, -3.463643554828380e-15,  1.201226350137694e-16, -3.816556193526194e-18,  1.971264277834828e-05, -6.224649452482595e-06,  1.027985003326346e-06,
 -1.153442971967678e-07,  9.835862462274609e-09, -6.784508452510471e-10,  3.938675189416829e-11, -1.978004169908307e-12,  8.767451289231894e-14, -3.482916649500975e-15,
  1.255088391813917e-16, -4.139233671127904e-18,  1.349091159714731e-05, -4.441422712722350e-06,  7.660924248373918e-07, -8.973587425572458e-08,  7.981027647613951e-09,
 -5.735829382590155e-10,  3.465841845281589e-11, -1.809771885952487e-12,  8.332563380258190e-14, -3.435125475905752e-15,  1.283420919515215e-16, -4.384296643838303e-18,
  9.288539944143788e-06, -3.178017748752883e-06,  5.708201926337812e-07, -6.960189536633780e-08,  6.438830471726117e-09, -4.808860318445753e-10,  3.016799417941259e-11,
 -1.633997545525520e-12,  7.796578463777388e-14, -3.328020909213443e-15,  1.286363011258096e-16, -4.542185192290939e-18,  6.440258140575373e-06, -2.283007845828235e-06,
  4.257559845179928e-07, -5.388913622024310e-08,  5.171446400592837e-09, -4.003333712626095e-10,  2.600973913758993e-11, -1.457763516937690e-12,  7.191658825313919e-14,
 -3.171416523840068e-15,  1.265425174339313e-16, -4.608839056490960e-18,  4.500669760017990e-06, -1.648125701848080e-06,  3.182049886110741e-07, -4.169328804727507e-08,
  4.139483693805500e-09, -3.312959108595832e-10,  2.223637536859357e-11, -1.286531959223636e-12,  6.547032914818782e-14, -2.976011643547592e-15,  1.223140430458402e-16,
 -4.585278594220181e-18,  3.172071905663537e-06, -1.196527070269396e-06,  2.384949714639395e-07, -3.226062657591778e-08,  3.305043046673419e-09, -2.727719961678377e-10,
  1.886728798932945e-11, -1.124172492100072e-12,  5.887509356842707e-14, -2.752389776280162e-15,  1.162680471676124e-16, -4.476734242328181e-18,  2.255533689714986e-06,
 -8.739627206717028e-07,  1.793443661733273e-07, -2.497727666852569e-08,  2.633526990531953e-09, -2.235689579001800e-10,  1.589696195328782e-11, -9.731212115676343e-13,
  5.232779547452556e-14, -2.510263484558666e-15,  1.087490794408650e-16, -4.291522847288195e-18,  1.617986173105577e-06, -6.422702873739942e-07,  1.353218638646642e-07,
 -1.935219675863688e-08,  2.094512255137849e-09, -1.824359666157430e-10,  1.330268499408005e-11, -8.346110410165543e-13,  4.597347477533793e-14, -2.257982356103098e-15,
  1.000981854459239e-16, -4.039858777117197e-18,  1.170208190746774e-06, -4.746523308683745e-07,  1.024036109479371e-07, -1.499801837558867e-08,  1.661974041028914e-09,
 -1.481534596975992e-10,  1.105099629531784e-11, -7.089254504087362e-13,  3.990897596307384e-14, -2.002281160475578e-15,  9.062955199737192e-17, -3.732749698519511e-18,
  8.521584335538152e-07, -3.522930083532248e-07,  7.762158427187127e-08, -1.161227993434704e-08,  1.314099990839311e-09, -1.195872026149465e-10,  9.102702690858521e-12,
 -5.956419112962662e-13,  3.418921242871160e-14, -1.748222313128560e-15,  8.061509058507288e-17, -3.381076510965124e-18,  6.232245602464086e-07, -2.619568962719058e-07,
  5.879085144737659e-08, -8.960425093669332e-09,  1.032873249695827e-09, -9.571557809985091e-11,  7.416511321592452e-12, -4.938448813025451e-13,  2.883453662341589e-14,
 -1.499278369519067e-15,  7.027628157049622e-17, -2.994906939540699e-18,  4.557449629049460e-07, -1.942963710091414e-07,  4.430168248066973e-08, -6.861146283697059e-09,
  8.035498253133661e-10, -7.563791616726182e-11,  5.951454733930377e-12, -4.022989401794859e-13,  2.383813545680990e-14, -1.257502487641037e-15,  5.978198075888864e-17,
 -2.583051076801198e-18,  3.306993403607128e-07, -1.426631792050795e-07,  3.296303052135336e-08, -5.174162833758813e-09,  6.141107998842542e-10, -5.857028185878774e-11,
  4.668336409841395e-12, -3.195804192968672e-13,  1.917276122491659e-14, -1.023743361386889e-15,  4.925066978508980e-17, -2.152838564740073e-18,  2.348314056219868e-07,
 -1.022745690723727e-07,  2.388553452151329e-08, -3.790247283663142e-09,  4.547361581412760e-10, -4.383359706236214e-11,  3.530427845065195e-12, -2.441707368661995e-13,
  1.479644078242750e-14, -7.978725096827482e-16,  3.875570771098737e-17, -1.710081509378486e-18,  1.587137834887238e-07, -6.962603650196081e-08,  1.639419558979679e-08,
 -2.623184069876346e-09,  3.173235527070791e-10, -3.083759436884048e-11,  2.503627373279239e-12, -1.745174884435372e-13,  1.065707376974474e-14, -5.790041777267411e-16,
  2.833243433339367e-17, -1.259184139710358e-18,  9.543128543968986e-08, -4.207440348301725e-08,  9.963037403765922e-09, -1.603339493437598e-09,  1.950644227700489e-10,
 -1.906340790716065e-11,  1.556294633560156e-12, -1.090731395081326e-13,  6.696178399902813e-15, -3.657077317977937e-16,  1.798677124958583e-17, -8.033837132547450e-19,
  3.971728470007668e-08, -1.755942566508990e-08,  4.171072556092412e-09, -6.733917564647844e-10,  8.218604838466542e-11, -8.057108230642543e-12,  6.597900940464617e-13,
 -4.638120315878165e-14,  2.855851753560631e-15, -1.564232508255099e-16,  7.715305014223268e-18, -3.455624327482474e-19,  6.200888289720472e-02, -1.599256412110750e-04,
  4.291025282595554e-07, -1.188619733870684e-09,  3.369993594786606e-12, -9.704335399546381e-15,  2.820668642976991e-17, -8.238426064700642e-20,  2.410374184565907e-22,
 -7.050393083257357e-25,  2.059075189768805e-27, -6.000009852576661e-30,  6.042677818141431e-02, -2.060146544602943e-04,  8.244669308536553e-07, -3.391827549251861e-09,
  1.373779028682968e-11, -5.435023389279471e-14,  2.103203620424868e-16, -7.984298420959580e-19,  2.981469402507510e-21, -1.097470464305190e-23,  3.988886141664486e-26,
 -1.433440817029635e-28,  5.738682569513295e-02, -2.908744274819986e-04,  1.670436514449227e-06, -9.069604091779296e-09,  4.647373227606835e-11, -2.276384863006527e-13,
  1.075836418217967e-15, -4.936513060819556e-18,  2.208946124433058e-20, -9.671092173983578e-23,  4.153452696869109e-25, -1.753374247197689e-27,  5.312092590880940e-02,
 -4.013128616316521e-04,  3.045447570913769e-06, -2.064992919414914e-08,  1.292201615408041e-10, -7.618734559442104e-13,  4.284927648549418e-15, -2.317895111668606e-17,
  1.213134602088012e-19, -6.170595650024187e-22,  3.060933499720899e-24, -1.484839366392269e-26,  4.793856073641593e-02, -5.207938283631310e-04,  4.999938574657423e-06,
 -4.139081742680585e-08,  3.104813187709985e-10, -2.164585912967714e-12,  1.424204978876883e-14, -8.935342532005252e-17,  5.385223160787430e-19, -3.135110099700468e-21,
  1.770580297023061e-23, -9.733154081150264e-26,  4.218882585976825e-02, -6.324433216828746e-04,  7.506471890325135e-06, -7.473880920429185e-08,  6.626502672805935e-10,
 -5.390735969780038e-12,  4.098018705587574e-14, -2.947062482775396e-16,  2.022510580583499e-18, -1.333233030763157e-20,  8.484265670443511e-23, -5.232694133691174e-25,
  3.622114767800944e-02, -7.218514465616739e-04,  1.043094278301837e-05, -1.233834306354285e-07,  1.278402218143144e-09, -1.200950414954550e-11,  1.044632888497032e-13,
 -8.532648309849451e-16,  6.610255934074634e-18, -4.893129421860405e-20,  3.480695503416840e-22, -2.389988730803014e-24,  3.035084119060507e-02, -7.791045843104778e-04,
  1.353638763438125e-05, -1.881976826803349e-07,  2.257203715814706e-09, -2.427631063573819e-11,  2.397022776605430e-13, -2.207224373011210e-15,  1.916602072865945e-17,
 -1.582379487916603e-19,  1.250073753819264e-21, -9.496406929310848e-24,  2.483400857237855e-02, -7.997309008270263e-04,  1.651884120539205e-05, -2.673934901323961e-07,
  3.682003370853237e-09, -4.500318459097027e-11,  5.009916793669824e-13, -5.167703805182722e-15,  4.999472130438339e-17, -4.577483892116697e-19,  3.994062601341361e-21,
 -3.339165099987016e-23,  1.985394618039213e-02, -7.845372222972155e-04,  1.906378709529498e-05, -3.562280911322409e-07,  5.590708650526036e-09, -7.715126821592172e-11,
  9.625796142909522e-13, -1.106072179974276e-14,  1.185981099023886e-16, -1.198241709836386e-18,  1.149290656560027e-20, -1.052606810729034e-22,  1.551885981341597e-02,
 -7.385669439170452e-04,  2.090592520656407e-05, -4.474499269941968e-07,  7.950845344229390e-09, -1.231561805501318e-10,  1.712900215688316e-12, -2.181740076715040e-14,
  2.580719437272006e-16, -2.864527951543168e-18,  3.007497139915045e-20, -3.005367765354910e-22,  1.186882093018716e-02, -6.695561709657960e-04,  2.187566931872409e-05,
 -5.324294156662268e-07,  1.064675392618940e-08, -1.841160129833543e-10,  2.840730526141648e-12, -3.992691964606754e-14,  5.188148597028384e-16, -6.301382435138790e-18,
  7.214446061707037e-20, -7.837341395788696e-22,  8.888835252776259e-03, -5.862905953832447e-04,  2.192173518378819e-05, -6.026872355202086e-07,  1.348582867291286e-08,
 -2.590713836013868e-10,  4.414299283235384e-12, -6.817993228067824e-14,  9.694494500372243e-16, -1.283714759620767e-17,  1.597122509917809e-19, -1.879881145478963e-21,
  6.524680252946767e-03, -4.971900018547914e-04,  2.110743855281341e-05, -6.514075222642381e-07,  1.622448950182154e-08, -3.446328846675640e-10,  6.457642469998863e-12,
 -1.091804372739357e-13,  1.692646519415896e-15, -2.435297134822623e-17,  3.281874968551944e-19, -4.172544512025861e-21,  4.698628059556674e-03, -4.093155634378205e-04,
  1.958572754369969e-05, -6.745481323126896e-07,  1.860810976827485e-08, -4.351371724493272e-10,  8.930931033177414e-12, -1.646875776906561e-13,  2.774349876356321e-15,
 -4.323178420632812e-17,  6.291584423647570e-19, -8.615336351484985e-21,  3.323022493374445e-03, -3.278557132585439e-04,  1.756236899378389e-05, -6.713101658405350e-07,
  2.041464104106256e-08, -5.233587663274968e-10,  1.172173441295572e-11, -2.349360526890869e-13,  4.286801836147388e-15, -7.213071540245772e-17,  1.130374376320419e-18,
 -1.662585431533376e-20,  2.310633104873131e-03, -2.560359880449468e-04,  1.525747830168708e-05, -6.439336566163521e-07,  2.149085096291175e-08, -6.016292734162070e-10,
  1.465172880879096e-11, -3.181345281851624e-13,  6.268267025241736e-15, -1.135610901731143e-16,  1.911147685813143e-18, -3.011469613911248e-20,  1.581542879715340e-03,
 -1.953344335532277e-04,  1.287345293779673e-05, -5.969670305850967e-07,  2.177294487496247e-08, -6.630886866635331e-10,  1.749893397264946e-11, -4.103248570596607e-13,
  8.704460538514454e-15, -1.693249002443771e-16,  3.052209551358837e-18, -5.139738090322807e-20,  1.066917626346848e-03, -1.458666001978156e-04,  1.057377112417466e-05,
 -5.362609117514981e-07,  2.128843899047451e-08, -7.027614610277975e-10,  2.003082717194912e-11, -5.056976165412961e-13,  1.151736637295323e-14, -2.399240231926296e-16,
  4.620646276095610e-18, -8.295261432711800e-20,  7.103269682599614e-04, -1.068207821508295e-04,  8.473488195388017e-06, -4.679479673709588e-07,  2.014142938231163e-08,
 -7.182180286196006e-10,  2.204045090949479e-11, -5.973298352483488e-13,  1.456583002603410e-14, -3.240994063518269e-16,  6.652470842218478e-18, -1.270284639003288e-19,
  4.673791663277724e-04, -7.685872894540340e-05,  6.639582900446125e-06, -3.976098890818594e-07,  1.848711643390996e-08, -7.097157170639155e-10,  2.337703234738269e-11,
 -6.781868097985503e-13,  1.765930130933153e-14, -4.186492231000666e-16,  9.136903401747334e-18, -1.851500567856137e-19,  3.043666798026641e-04, -5.443512204720306e-05,
  5.097944648283222e-06, -3.297377305993584e-07,  1.650278117232960e-08, -6.798580143151584e-10,  2.396467381093056e-11, -7.421570198638019e-13,  2.058242259499495e-14,
 -5.186137114331638e-16,  1.200682343459147e-17, -2.576303260639462e-19,  1.964714999976247e-04, -3.802108351150454e-05,  3.843620154787552e-06, -2.674992146568414e-07,
  1.436154654393692e-08, -6.329197734116886e-10,  2.380636857806354e-11, -7.848903353187491e-13,  2.312513420511225e-14, -6.178184837905673e-16,  1.513877744240617e-17,
 -3.432085976518691e-19,  1.259091024122755e-04, -2.623864764493453e-05,  2.851552395748884e-06, -2.127601868063572e-07,  1.221302974514603e-08, -5.740329479963363e-10,
  2.297451420387663e-11, -8.042779260111644e-13,  2.511163803521599e-14, -7.096708965255088e-16,  1.836362756578201e-17, -4.389270896202730e-19,  8.023607375793836e-05,
 -1.792440456225195e-05,  2.085996501179708e-06, -1.662752148821387e-07,  1.017241130776124e-08, -5.084138280878624e-10,  2.159199701390119e-11, -8.005172088210388e-13,
  2.642224937412977e-14, -7.880391310561708e-16,  2.148616300999488e-17, -5.403036284670109e-19,  5.092756627287905e-05, -1.214369047864152e-05,  1.507734328635031e-06,
 -1.279600302629701e-07,  8.317306328325358e-09, -4.407583607374808e-10,  1.980917240846763e-11, -7.758087645475800e-13,  2.700443983406668e-14, -8.480307047504984e-16,
  2.430970564465361e-17, -6.417858300523504e-19,  3.225033797854788e-05, -8.174769340364312e-06,  1.078932005868079e-06, -9.717536336774937e-08,  6.690521231200845e-09,
 -3.748633726919946e-10,  1.778171267316179e-11, -7.338043042633745e-13,  2.687231379374415e-14, -8.865255492389901e-16,  2.666065048597059e-17, -7.374017527550485e-19,
  2.041022194236109e-05, -5.478129325344424e-06,  7.659309617261162e-07, -7.297632871299884e-08,  5.306339530924122e-09, -3.134706018040330e-10,  1.565286059373127e-11,
 -6.789521459002815e-13,  2.609639329479926e-14, -9.023904688062392e-16,  2.840823673288981e-17, -8.214769997628280e-19,  1.293087836156450e-05, -3.661227630391472e-06,
  5.404627165184618e-07, -5.430522859998170e-08,  4.158187172807872e-09, -2.582899349794412e-10,  1.354179918547807e-11, -6.158730034057109e-13,  2.478723937061591e-14,
 -8.963807168476900e-16,  2.947637482439157e-17, -8.892805002927601e-19,  8.214925348140142e-06, -2.444846437942479e-06,  3.798025297415120e-07, -4.012373869249200e-08,
  3.226085089456767e-09, -2.101407035473193e-10,  1.153820457440923e-11, -5.488589234184224e-13,  2.307689602444847e-14, -8.707974085255281e-16,  2.984645049944165e-17,
 -9.374891199102359e-19,  5.241895670627240e-06, -1.634102813755771e-06,  2.663030185369595e-07, -2.949158277121912e-08,  2.482940776767949e-09, -1.691509201359550e-10,
  9.701923693147717e-12, -4.815396399801511e-13,  2.110159643746314e-14, -8.290033259541530e-16,  2.955201585160705e-17, -9.644121026218562e-19,  3.364895597059424e-06,
 -1.095098997653156e-06,  1.866366094184440e-07, -2.160384575046250e-08,  1.899289139254627e-09, -1.349666123805944e-10,  8.066189686959852e-12, -4.167177860900048e-13,
  1.898803649839322e-14, -7.749028966944501e-16,  2.866766259223846e-17, -9.699726274047888e-19,  2.176235921692107e-06, -7.370148579490880e-07,  1.309640015566031e-07,
 -1.579980914117955e-08,  1.446487780253013e-09, -1.069398269449257e-10,  6.642754612607962e-12, -3.563452316929100e-13,  1.684424490394255e-14, -7.124721616470956e-16,
  2.729494832162893e-17, -9.554899489503627e-19,  1.420014219058957e-06, -4.988794596750624e-07,  9.215413327697117e-08, -1.155448328449049e-08,  1.098596885497803e-09,
 -8.427935295245767e-11,  5.427599104350301e-12, -3.015989515701978e-13,  1.475499800004700e-14, -6.453927915852411e-16,  2.554808273776330e-17, -9.233325837695852e-19,
  9.359715078390155e-07, -3.400836849783644e-07,  6.511522209575029e-08, -8.461323069028863e-09,  8.332621469347059e-10, -6.616006741505010e-11,  4.406290406346315e-12,
 -2.530135832421026e-13,  1.278101190682729e-14, -5.768114571375969e-16,  2.354142176501276e-17, -8.765191940615502e-19,  6.238094898283571e-07, -2.337348866670586e-07,
  4.625428339586703e-08, -6.211890853581467e-09,  6.319170916754385e-10, -5.179433376721325e-11,  3.558468007299830e-12, -2.106346418094371e-13,  1.096081506115426e-14,
 -5.092195100111764e-16,  2.137995769364623e-17, -8.183334347582433e-19,  4.206970713440040e-07, -1.620897322689570e-07,  3.305883660529555e-08, -4.575951900834136e-09,
  4.795712164807692e-10, -4.047261362869859e-11,  2.861263663123705e-12, -1.741666892360820e-13,  9.314184787369398e-15, -4.444312585566465e-16,  1.915317929330167e-17,
 -7.519991402456817e-19,  2.871776219809470e-07, -1.134625236914362e-07,  2.378350298765492e-08, -3.383808585133765e-09,  3.643837368966418e-10, -3.158143469589805e-11,
  2.291684005867632e-12, -1.431012128038889e-13,  7.846206707953011e-15, -3.836319704023387e-16,  1.693205853637352e-17, -6.804399272097768e-19,  1.983764319564997e-07,
 -8.015706930743061e-08,  1.722098839065268e-08, -2.511567475727641e-09,  2.771585642840618e-10, -2.460618867796462e-11,  1.828106509690516e-12, -1.168175861871697e-13,
  6.551275738610690e-15, -3.274669274559497e-16,  1.476855247493814e-17, -6.061278410871857e-19,  1.385280368853273e-07, -5.709571034331579e-08,  1.253794337864116e-08,
 -1.869373290231856e-09,  2.108434299796818e-10, -1.912479460878116e-11,  1.451086562767932e-12, -9.465653492396913e-14,  5.416620656450004e-15, -2.761475282473834e-16,
  1.269686894363146e-17, -5.310118586373948e-19,  9.757215586114356e-08, -4.091637727490565e-08,  9.159060323195836e-09, -1.392304091327769e-09,  1.600773709351351e-10,
 -1.479664834435361e-11,  1.143671387656697e-12, -7.596910059444848e-14,  4.425153662205324e-15, -2.295569760860003e-16,  1.073577289969580e-17, -4.565094492840793e-19,
  6.903415506663665e-08, -2.938032542214007e-08,  6.686129516219754e-09, -1.033487853330362e-09,  1.208049089019939e-10, -1.134982087901007e-11,  8.913884333612616e-13,
 -6.014570873497685e-14,  3.557603943778603e-15, -1.873446334475249e-16,  8.891336770268647e-18, -3.835420870129934e-19,  4.870159966523362e-08, -2.098429434797780e-08,
  4.841927865032725e-09, -7.589846521980175e-10,  8.995951001015250e-11, -8.568306464936480e-12,  6.820380782122895e-13, -4.663022398027623e-14,  2.793991516123847e-15,
 -1.490035989848143e-16,  7.159703494938425e-18, -3.125970132199377e-19,  3.379374497047713e-08, -1.470623523578995e-08,  3.431460765479223e-09, -5.440221360472791e-10,
  6.521038920369356e-11, -6.280277761868599e-12,  5.053831637594465e-13, -3.492339133542868e-14,  2.114546448718341e-15, -1.139300876836299e-16,  5.529594185244226e-18,
 -2.438010711002417e-19,  2.243607487829689e-08, -9.837767871528901e-09,  2.315158555864305e-09, -3.702384121560814e-10,  4.476295144328738e-11, -4.347743981770081e-12,
  3.527965108248469e-13, -2.457927081742970e-14,  1.500195607150576e-15, -8.146591189483288e-17,  3.984435640930039e-18, -1.769969590636936e-19,  1.332351420362832e-08,
 -5.872662781076828e-09,  1.390218194228361e-09, -2.236600620101801e-10,  2.720277828208533e-11, -2.657721351157935e-12,  2.169083584628429e-13, -1.519776985121403e-14,
  9.327574610312264e-16, -5.092811775952926e-17,  2.504151234163420e-18, -1.118192652919417e-19,  5.506674468847690e-09, -2.434237275868146e-09,  5.781425775753409e-10,
 -9.332285483292759e-11,  1.138809901659492e-11, -1.116260783080398e-12,  9.139579823930734e-14, -6.423876073945757e-15,  3.954816066207707e-16, -2.165849258883061e-17,
  1.068112799882435e-18, -4.783311239695339e-20,  6.137595691263920e-02, -1.565489726094205e-04,  4.151563230160111e-07, -1.136216517411019e-09,  3.182494051051791e-12,
 -9.054207342129882e-15,  2.600420663385408e-17, -7.506177185560974e-20,  2.170770889226696e-22, -6.277190675580186e-25,  1.812595131084626e-27, -5.222830984485291e-30,
  5.961565842416610e-02, -1.995780709243577e-04,  7.850488250571839e-07, -3.180452095992455e-09,  1.269950586467171e-11, -4.956039098799423e-14,  1.892427557449970e-16,
 -7.090482280763623e-19,  2.613643195476574e-21, -9.498411270312650e-24,  3.408864767212934e-26, -1.209735340228240e-28,  5.624938308045447e-02, -2.779339726312667e-04,
  1.565916921541564e-06, -8.361089241135521e-09,  4.216836684112056e-11, -2.034003111394103e-13,  9.470087475628608e-16, -4.282294287330215e-18,  1.888922191843515e-20,
 -8.154242854034739e-23,  3.453734573771990e-25, -1.438160685703786e-27,  5.156288036697636e-02, -3.779064525918328e-04,  2.809568234655740e-06, -1.869893184305630e-08,
  1.149606881787470e-10, -6.664043620850250e-13,  3.687087276166378e-15, -1.962993693854182e-17,  1.011543837284705e-19, -5.067496941095422e-22,  2.476464701586826e-24,
 -1.183794575573139e-26,  4.593235377203567e-02, -4.826998016810033e-04,  4.531684261108221e-06, -3.675169533929035e-08,  2.704146774103628e-10, -1.850951771166549e-12,
  1.196537275466799e-14, -7.379780108228716e-17,  4.374380212216639e-19, -2.505633273624364e-21,  1.392773104046459e-23, -7.537875689221794e-26,  3.977372004942096e-02,
 -5.758066286775668e-04,  6.669828458997799e-06, -6.494816400427032e-08,  5.640383955753526e-10, -4.499340519062560e-12,  3.356676363491901e-14, -2.370528618986484e-16,
  1.598464443404400e-18, -1.035797206748141e-20,  6.482054309856716e-23, -3.932840396178890e-25,  3.349172774262516e-02, -6.439959916497988e-04,  9.065562004961087e-06,
 -1.047220086650946e-07,  1.061465079521064e-09, -9.766715951395025e-12,  8.328648130493890e-14, -6.674269647545610e-16,  5.075908202337714e-18, -3.690491480091372e-20,
  2.579655944298303e-22, -1.741258355006475e-24,  2.743752258479785e-02, -6.792679813103018e-04,  1.147964258299988e-05, -1.556738912457040e-07,  1.824537097621952e-09,
 -1.920071682939427e-11,  1.856943329876048e-13, -1.676168178663192e-15,  1.427713116880241e-17, -1.156930696766875e-19,  8.975051628327356e-22, -6.698186972185310e-24,
  2.188039328976001e-02, -6.794779459150166e-04,  1.363587873694501e-05, -2.150747813820688e-07,  2.891330814473769e-09, -3.454914318715287e-11,  3.764205132712210e-13,
 -3.803363290697901e-15,  3.606930992204044e-17, -3.239321800138259e-19,  2.773900297689321e-21, -2.277043061882164e-23,  1.699574644134168e-02, -6.477148092301879e-04,
  1.527863393898980e-05, -2.779638153681927e-07,  4.255674768901376e-09, -5.737380611009894e-11,  7.001101732666947e-13, -7.875377314284767e-15,  8.272914988331538e-17,
 -8.194175791083181e-19,  7.709416272979846e-21, -6.929657322297006e-23,  1.286790406545672e-02, -5.908081615237437e-04,  1.622522984115058e-05, -3.378998246054707e-07,
  5.853782714419427e-09, -8.853161698110911e-11,  1.203643039481847e-12, -1.500051166942824e-14,  1.737522739478596e-16, -1.889863001409367e-18,  1.945510966681749e-20,
 -1.907272723421767e-22,  9.503889873076708e-03, -5.174690597579396e-04,  1.639812456885888e-05, -3.881844559079428e-07,  7.564528358649673e-09, -1.276691393614962e-10,
  1.924714182217360e-12, -2.645863926898998e-14,  3.365419653040170e-16, -4.004046917677262e-18,  4.493416468684194e-20, -4.787385576517507e-22,  6.853319247781203e-03,
 -4.365369304442861e-04,  1.583015400659999e-05, -4.232002218529309e-07,  9.225654303761960e-09, -1.729177627491579e-10,  2.878033968840909e-12, -4.346434229595135e-14,
  6.047978296712551e-16, -7.842973119517559e-18,  9.562224974045516e-20, -1.103603571503519e-21,  4.829734967413150e-03, -3.556588727713168e-04,  1.464532276538072e-05,
 -4.394750175878953e-07,  1.066254275435633e-08, -2.209411432579070e-10,  4.043272701314413e-12, -6.683003889008973e-14,  1.013747695905528e-15, -1.428154134916162e-17,
  1.885779882010727e-19, -2.350579118206347e-21,  3.329831911024022e-03, -2.805395031334361e-04,  1.302417583675008e-05, -4.361985737626947e-07,  1.172160094234086e-08,
 -2.673789719111060e-10,  5.359373975350879e-12, -9.660939057295298e-14,  1.592315560568897e-15, -2.429430799949319e-17,  3.464045811588978e-19, -4.650296563305355e-21,
  2.248481171240663e-03, -2.147331351565532e-04,  1.116504718504069e-05, -4.151138023982463e-07,  1.229880884169591e-08, -3.075940793535059e-10,  6.728437122934859e-12,
 -1.318358181696423e-13,  2.353656585845084e-15, -3.877738293232702e-17,  5.954125323100474e-19, -8.585806553433398e-21,  1.488856490185295e-03, -1.598433463665959e-04,
  9.250820030081787e-06, -3.798993870455985e-07,  1.235599577778079e-08, -3.375227697375394e-10,  8.029401393407977e-12, -1.704639243512819e-13,  3.286658488231948e-15,
 -5.830970123856622e-17,  9.616043742476381e-19, -1.485713832748200e-20,  9.680084521400176e-04, -1.159559515441330e-04,  7.426875827004071e-06, -3.352801601198925e-07,
  1.192181513375313e-08, -3.543961425032713e-10,  9.138443319831484e-12, -2.095684866926936e-13,  4.351376959534133e-15, -8.290964663937734e-17,  1.464807724945039e-18,
 -2.419082168604533e-20,  6.188300336764290e-04, -8.214617429628808e-05,  5.791567278707646e-06, -2.861234461806019e-07,  1.107918857929571e-08, -3.571519059349350e-10,
  9.950727308748338e-12, -2.457745876804779e-13,  5.480594235929845e-15, -1.118616688724717e-16,  2.112127481669487e-18, -3.719758358976176e-20,  3.895554743380317e-04,
 -5.694568842956166e-05,  4.397239543934591e-06, -2.367201907302770e-07,  9.944398498622562e-09, -3.464637687458694e-10,  1.039783078554170e-11, -2.758161808892115e-13,
  6.587940728038377e-15, -1.436800968583613e-16,  2.892507831874283e-18, -5.420230806116573e-20,  2.418513113603716e-04, -3.870750192910174e-05,  3.258139633306303e-06,
 -1.903507703691060e-07,  8.644140265674929e-09, -3.244317934530262e-10,  1.045679593563065e-11, -2.970799813949573e-13,  7.580956166305770e-15, -1.762426832389795e-16,
  3.774248887524942e-18, -7.508812550304510e-20,  1.483265295580720e-04, -2.585089270043596e-05,  2.361373884201236e-06, -1.491391694914000e-07,  7.295878446562230e-09,
 -2.940598352464954e-10,  1.014952770198651e-11, -3.080012811405976e-13,  8.375912137221061e-15, -2.070761799098399e-16,  4.706684165359413e-18, -9.920234770999429e-20,
  9.001677111532208e-05, -1.699788445918826e-05,  1.677872749969000e-06, -1.141331507945895e-07,  5.994654564295850e-09, -2.586746339068460e-10,  9.534017730014167e-12,
 -3.082303652084704e-13,  8.910761786784199e-15, -2.337297403497769e-16,  5.626075125259947e-18, -1.253610925736769e-19,  5.415467504055404e-05, -1.102695792375990e-05,
  1.171503646352454e-06, -8.552035390359083e-08,  4.807099455034732e-09, -2.214191827336964e-10,  8.690695255832892e-12, -2.985589938761046e-13,  9.153322498752565e-15,
 -2.541468860816079e-16,  6.464538584180541e-18, -1.519641116197998e-19,  3.235624978071477e-05, -7.072473294745803e-06,  8.055814261245811e-07, -6.289433442877315e-08,
  3.771573230727019e-09, -1.849010033407885e-10,  7.707702206208556e-12, -2.806589869780851e-13,  9.103347246850678e-15, -2.669512352985563e-16,  7.159956931631764e-18,
 -1.772003151693039e-19,  1.923607847181128e-05, -4.494331803002828e-06,  5.468241584277408e-07, -4.550700313923597e-08,  2.902410983226795e-09, -1.510181996339169e-10,
  6.668234065123416e-12, -2.567206904823411e-13,  8.788863093333445e-15, -2.715909300978724e-16,  7.664626276364064e-18, -1.992991213802974e-19,  1.140139404566271e-05,
 -2.835757855150944e-06,  3.672396140743891e-07, -3.247158458880717e-08,  2.196126197761845e-09, -1.209409352041603e-10,  5.641792068039280e-12, -2.290830694980541e-13,
  8.258466822222176e-15, -2.683285466908596e-16,  7.950886985597823e-18, -2.167718129583565e-19,  6.750636917033832e-06, -1.780413263839762e-06,  2.445704018241701e-07,
 -2.290409809824482e-08,  1.637835679014654e-09, -9.520136699182665e-11,  4.679818764039715e-12, -1.999263512372327e-13,  7.571852173242736e-15, -2.581019296088269e-16,
  8.012912694129818e-18, -2.285932187066766e-19,  4.000815365170936e-06, -1.114701776110327e-06,  1.618803346582272e-07, -1.600745808950680e-08,  1.206800633206843e-09,
 -7.384006922944300e-11,  3.815140152609906e-12, -1.710655017397419e-13,  6.790704598892810e-15, -2.423057480171275e-16,  7.864847407834871e-18, -2.342933763439349e-19,
  2.378168846597860e-06, -6.974552951101891e-07,  1.067314821502053e-07, -1.111041870558581e-08,  8.805843789138056e-10, -5.656536869076279e-11,  3.064077959756173e-12,
 -1.438509324626040e-13,  5.971472080264512e-15, -2.225498306566824e-16,  7.536256939363239e-18, -2.339534850018574e-19,  1.420671583707790e-06, -4.370336146304596e-07,
  7.025121219694056e-08, -7.675640880474235e-09,  6.377773966497759e-10, -4.289639047608665e-11,  2.429988300093541e-12, -1.191598255909706e-13,  5.160718524467581e-15,
 -2.004414182291215e-16,  7.066230143918729e-18, -2.281222100842229e-19,  8.545749545717563e-07, -2.748227152991678e-07,  4.625999069299307e-08, -5.289584097991952e-09,
  4.595030866443211e-10, -3.227511374129523e-11,  1.907180530330243e-12, -9.745002825951167e-14,  4.393053854626590e-15, -1.774210666930635e-16,  6.497426954560158e-18,
 -2.176817504093600e-19,  5.185968101086683e-07, -1.737774824259472e-07,  3.053771790619895e-08, -3.643807597431760e-09,  3.300216242073307e-10, -2.414402210478192e-11,
  1.484504000868549e-12, -7.884708942910302e-14,  3.691159787324804e-15, -1.546631157252022e-16,  5.871045837865702e-18, -2.036964370183405e-19,  3.180559279944341e-07,
 -1.107008477094435e-07,  2.024799796048234e-08, -2.513992791743655e-09,  2.367474150475692e-10, -1.799296566240256e-11,  1.148228459583285e-12, -6.324012238063359e-14,
  3.067221574832868e-15, -1.330365067328457e-16,  5.223239968172433e-18, -1.872717917622676e-19,  1.974579586951797e-07, -7.116531001170736e-08,  1.350840736065788e-08,
 -1.740280525466976e-09,  1.699390943894935e-10, -1.338208765980722e-11,  8.841106670773376e-13, -5.037000970524530e-14,  2.525081748645997e-15, -1.131125932818294e-16,
  4.583094539353511e-18, -1.694425052085997e-19,  1.242663432107196e-07, -4.623738195446110e-08,  9.081684713423534e-09, -1.210576996866800e-09,  1.222475864211878e-10,
 -9.948222339048880e-12,  6.787108958500003e-13, -3.990119719591245e-14,  2.062566845581408e-15, -9.520332393757391e-17,  3.971975241506027e-18, -1.510973876816795e-19,
  7.936379518354522e-08, -3.039784951826161e-08,  6.160274257674731e-09, -8.472671010995951e-10,  8.823967856139434e-11, -7.401209945748685e-12,  5.201072334682377e-13,
 -3.147438625818303e-14,  1.673620956629642e-15, -7.941426269484332e-17,  3.403896779667714e-18, -1.329406884234459e-19,  5.147399032616578e-08, -2.023747590868762e-08,
  4.219452765246508e-09, -5.971153384282570e-10,  6.396153776278282e-11, -5.515015216706623e-12,  3.981768631718990e-13, -2.474135414118793e-14,  1.350053089615235e-15,
 -6.570039416916942e-17,  2.886522346693388e-18, -1.154835537666739e-19,  3.390867710334766e-08, -1.364662229270388e-08,  2.919015869848202e-09, -4.238484757817906e-10,
  4.657022104069586e-11, -4.116955282968558e-12,  3.045975326256249e-13, -1.938512133793385e-14,  1.082838772632871e-15, -5.391685460805620e-17,  2.422450287360675e-18,
 -9.905688217144273e-20,  2.267255857732817e-08, -9.315077282906864e-09,  2.038388663519514e-09, -3.028483531231537e-10,  3.403906040121303e-11, -3.077028974636158e-12,
  2.326899972281851e-13, -1.512926669158540e-14,  8.630022270907956e-16, -4.386052092555829e-17,  2.010530453772339e-18, -8.383675996416389e-20,  1.535816642145131e-08,
 -6.424632575975858e-09,  1.434245130089825e-09, -2.174295310682935e-10,  2.493104511861269e-11, -2.298379247899959e-12,  1.771869877576528e-13, -1.173992008752840e-14,
  6.821495249099932e-16, -3.530124409561025e-17,  1.647046641562656e-18, -6.987508465314802e-20,  1.049965306450711e-08, -4.460476742037750e-09,  1.013030776401417e-09,
 -1.562672159873049e-10,  1.822935838429239e-11, -1.709289639181516e-12,  1.339834748942121e-13, -9.023291695746143e-15,  5.327368379998191e-16, -2.800333112157061e-17,
  1.326682618155456e-18, -5.713003422075889e-20,  7.193212163964089e-09, -3.095432095609962e-09,  7.132240803505626e-10, -1.116385975721242e-10,  1.321321039472033e-11,
 -1.256743594923824e-12,  9.989940428354366e-14, -6.820828684344155e-15,  4.081530204815623e-16, -2.173881359386541e-17,  1.043248914178473e-18, -4.549309672714208e-20,
  4.872639218263851e-09, -2.118686922736162e-09,  4.938969582756150e-10, -7.822769879275239e-11,  9.368089963827216e-12, -9.013842192397963e-13,  7.246968978021088e-14,
 -5.003394075161793e-15,  3.026819033831318e-16, -1.629434178588526e-17,  7.901853035323382e-19, -3.481108944940220e-20,  3.175360583664735e-09, -1.391637211293560e-09,
  3.273146625187485e-10, -5.231397579538035e-11,  6.321327078534460e-12, -6.136353843403416e-13,  4.976590399899830e-14, -3.465312309081329e-15,  2.113935479829015e-16,
 -1.147347297375288e-17,  5.608743291236389e-19, -2.490287711133562e-20,  1.861331740879940e-09, -8.202093030426818e-10,  1.941072290718719e-10, -3.121863275860652e-11,
  3.795823028008261e-12, -3.707412909379703e-13,  3.024882997619643e-14, -2.118776122083280e-15,  1.300017057325533e-16, -7.096027201128530e-18,  3.488170707114465e-19,
 -1.557169443968508e-20,  7.637345484290048e-10, -3.375646844953021e-10,  8.016074656947707e-11, -1.293736672747639e-11,  1.578483691746255e-12, -1.546984528821358e-13,
  1.266422564334689e-14, -8.899844938061599e-16,  5.478293168123060e-17, -2.999727051325982e-18,  1.479128861279169e-19, -6.622987712032753e-21,  6.075631837512080e-02,
 -1.532814083253251e-04,  4.018213763818181e-07, -1.086712077011965e-09,  3.007484643619909e-12, -8.454562578563915e-15,  2.399642756490913e-17, -6.846331508552706e-20,
  1.957307614641335e-22, -5.596070460702175e-25,  1.597880691910723e-27, -4.553277974984727e-30,  5.882966998658106e-02, -1.934469615202780e-04,  7.480706239285381e-07,
 -2.984949476224204e-09,  1.175215572136991e-11, -4.524766091868893e-14,  1.705107297638858e-16, -6.306296294721584e-19,  2.295014114559691e-21, -8.235582945375616e-24,
  2.918864617905067e-26, -1.023073176041572e-28,  5.516208221279588e-02, -2.657968010896681e-04,  1.469501661317481e-06, -7.717744094462343e-09,  3.831827230343691e-11,
 -1.820452687287537e-13,  8.351438875244393e-16, -3.722260305347895e-18,  1.618784023384640e-20, -6.891399676690753e-23,  2.879070542654764e-25, -1.182742636000436e-27,
  5.009482937722168e-02, -3.562971687352881e-04,  2.595792530751618e-06, -1.696155807398086e-08,  1.024748024392306e-10, -5.841603494029928e-13,  3.180154302525903e-15,
 -1.666673997061248e-17,  8.457572003249354e-20, -4.173699254586308e-22,  2.009765026609060e-24, -9.468467374623553e-27,  4.407136863814733e-02, -4.481395716282172e-04,
  4.115450786255912e-06, -3.270628506602884e-08,  2.361077926920262e-10, -1.587076768190779e-12,  1.008217666815095e-14, -6.114167280535163e-17,  3.565124144402729e-19,
 -2.009592350521228e-21,  1.099634955277131e-23, -5.860341997413561e-26,  3.757248264870466e-02, -5.254186598506890e-04,  5.941764473014606e-06, -5.660183009513178e-08,
  4.815984451485072e-10, -3.767935365887873e-12,  2.759271912936175e-14, -1.913997597781092e-16,  1.268359012723201e-18, -8.080786194398041e-21,  4.973949136906700e-23,
 -2.969305165630974e-25,  3.105322277744372e-02, -5.762236035862478e-04,  7.904687719047343e-06, -8.919867511050722e-08,  8.846956887221534e-10, -7.974901321269456e-12,
  6.668617927173074e-14, -5.244043933546532e-16,  3.915973695289358e-18, -2.797024861558902e-20,  1.921555473170137e-22, -1.275274648940091e-24,  2.489295775859120e-02,
 -5.944346008369206e-04,  9.774781881747483e-06, -1.293263422357604e-07,  1.481539190062876e-09, -1.525923349121328e-11,  1.445778977219850e-13, -1.279548535040689e-15,
  1.069313365235657e-17, -8.506330811893499e-20,  6.481212591124985e-22, -4.752803608790263e-24,  1.936535472583988e-02, -5.799775598966689e-04,  1.131124311326496e-05,
 -1.738844912497409e-07,  2.282693824050383e-09, -2.667260983162735e-11,  2.844743009194610e-13, -2.816133233124568e-15,  2.618489283519054e-17, -2.307071443497955e-19,
  1.939204219680942e-21, -1.563274528449252e-23,  1.462974634187551e-02, -5.377520856857241e-04,  1.231651086569647e-05, -2.182098052341102e-07,  3.259801408701269e-09,
 -4.294340823317928e-11,  5.126196933227810e-13, -5.646006333673793e-15,  5.811666032243178e-17, -5.644210273095284e-19,  5.209820707149296e-21, -4.596598928351796e-23,
  1.074067717771336e-02, -4.757583219907563e-04,  1.267868376875568e-05, -2.569670660187867e-07,  4.341002184436740e-09, -6.411394257368941e-11,  8.522244666542801e-13,
 -1.039382304346589e-14,  1.179122055699970e-16, -1.256942746707907e-18,  1.268926719636246e-20, -1.220579542750752e-22,  7.669549653506776e-03, -4.030382834849742e-04,
  1.238933515288421e-05, -2.853008209156692e-07,  5.418834971297015e-09, -8.927090363894732e-11,  1.315226487574408e-12, -1.768615754604473e-14,  2.202389169416163e-16,
 -2.567152854743153e-18,  2.824219091425639e-20, -2.951429457985359e-22,  5.331515284353355e-03, -3.279402887277720e-04,  1.153440256946891e-05, -2.998811729947101e-07,
  6.369734510297024e-09, -1.164986895158796e-10,  1.894295054408329e-12, -2.797578605517611e-14,  3.809967992470006e-16, -4.839165866230780e-18,  5.782383149921743e-20,
 -6.544410431690458e-22,  3.611715783821464e-03, -2.569953662734758e-04,  1.026489234955715e-05, -2.995283703652579e-07,  7.079638398765456e-09, -1.431193994158991e-10,
  2.558212543485013e-12, -4.134143440702648e-14,  6.136518208573857e-16, -8.465783909189371e-18,  1.095388058474882e-19, -1.338734006677162e-21,  2.386926977073859e-03,
 -1.944605426556491e-04,  8.758950051746197e-06, -2.852705857626729e-07,  7.467807834877430e-09, -1.661785147672859e-10,  3.253159708229117e-12, -5.732977489840829e-14,
  9.245447846460195e-16, -1.381226529593240e-17,  1.929716869431528e-19, -2.539813040199842e-21,  1.540811947263301e-03, -1.424091458989998e-04,  7.186682269817129e-06,
 -2.598910286082360e-07,  7.501804465477894e-09, -1.830397789651915e-10,  3.910541436696504e-12, -7.490846750050257e-14,  1.308521669348300e-15, -2.110958235103595e-17,
  3.175932138882470e-19, -4.490037936108869e-21,  9.727689857164183e-04, -1.011634027463640e-04,  5.685385363574083e-06, -2.271682224596465e-07,  7.200048466958426e-09,
 -1.919112485403855e-10,  4.459593131512337e-12, -9.256984093266902e-14,  1.746531917628864e-15, -3.034363266348115e-17,  4.903603540471708e-19, -7.428650800355615e-21,
  6.014878200849400e-04, -6.986178706507200e-05,  4.347867874441245e-06, -1.910617024957991e-07,  6.622754609510189e-09, -1.921537875997799e-10,  4.841197619006441e-12,
 -1.085738996160617e-13,  2.206464596525445e-15, -4.117756876281886e-17,  7.130263405695629e-19, -1.154800369958076e-20,  3.647972856760722e-04, -4.700290836141794e-05,
  3.222371327181620e-06, -1.550507136630310e-07,  5.855432728258462e-09, -1.843055220753300e-10,  5.018931199258733e-12, -1.212686317350244e-13,  2.647500376632744e-15,
 -5.294120903817612e-17,  9.799762673670259e-19, -1.692979614860111e-20,  2.173590731196224e-04, -3.087548581886445e-05,  2.320251722081517e-06, -1.217366268545428e-07,
  4.990459969968161e-09, -1.698513216590174e-10,  4.984455936241275e-12, -1.293977494387204e-13,  3.027042405841074e-15, -6.470317007112654e-17,  1.277425038191966e-18,
 -2.348899547195233e-20,  1.274506536568793e-04, -1.984483289583091e-05,  1.627126593209726e-06, -9.271895524754883e-08,  4.111488511625572e-09, -1.508362839149406e-10,
  4.756396657517012e-12, -1.323123866426861e-13,  3.308378901794982e-15, -7.541439876793335e-17,  1.584488568150436e-18, -3.094516857266245e-20,  7.367556717557147e-05,
 -1.250770286680847e-05,  1.114030677237184e-06, -6.868392675719002e-08,  3.283449656376910e-09, -1.294459084107455e-10,  4.373875775725416e-12, -1.300389169187052e-13,
  3.467009069220834e-15, -8.408742639661677e-17,  1.876065110696321e-18, -3.883531959650296e-20,  4.206707066440216e-05, -7.747679189813168e-06,  7.464959149320606e-07,
 -4.961511424027149e-08,  2.548691157541091e-09, -1.076557433275793e-10,  3.887171040203626e-12, -1.232027657977537e-13,  3.494085033199523e-15, -8.996413376046992e-17,
  2.126870017794256e-18, -4.657037877272981e-20,  2.377159155981005e-05, -4.727325701936066e-06,  4.907759160550199e-07, -3.504097789766791e-08,  1.928121736088105e-09,
 -8.700819922485987e-11,  3.348211192888362e-12, -1.128483390871589e-13,  3.396412525273516e-15, -9.263021048626004e-17,  2.315598182306342e-18, -5.352375518524560e-20,
  1.332197583387231e-05, -2.847834680473657e-06,  3.173542491022158e-07, -2.425906484234854e-08,  1.425451491084515e-09, -6.852606808368073e-11,  2.803004625034912e-12,
 -1.002151835882865e-13,  3.193482494316151e-15, -9.205331737619435e-17,  2.428182328237187e-18, -5.913035251667220e-20,  7.420017489164920e-06, -1.697831287778914e-06,
  2.023486069390448e-07, -1.650603144252655e-08,  1.032616641676078e-09, -5.273704686488279e-11,  2.287049657438891e-12, -8.652810606864338e-14,  2.912706059785299e-15,
 -8.854566230114361e-17,  2.459447004187271e-18, -6.297193103285952e-20,  4.116508821332986e-06, -1.004148977441034e-06,  1.275410394213231e-07, -1.106675449812324e-08,
  7.349545673489717e-10, -3.976727168602566e-11,  1.823759220225818e-12, -7.284081563259853e-14,  2.584231645273451e-15, -8.267123567836843e-17,  2.412968856561137e-18,
 -6.483008879784579e-20,  2.279966162284715e-06, -5.905875783794605e-07,  7.967096504402933e-08, -7.330722599650461e-09,  5.153230999433129e-10, -2.946215877427306e-11,
  1.425241907061037e-12, -5.994894803346898e-14,  2.236491370879726e-15, -7.512768250463767e-17,  2.299440649554132e-18, -6.469865128815521e-20,  1.263600166995805e-06,
 -3.462761652200335e-07,  4.944941779504128e-08, -4.810173763428334e-09,  3.569060072387402e-10, -2.150312590638339e-11,  1.094499085416256e-12, -4.836791219257975e-14,
  1.893146694439721e-15, -6.663193730460312e-17,  2.134145064269614e-18, -6.275859579742881e-20,  7.024109062186453e-07, -2.029024960941917e-07,  3.057331639486159e-08,
 -3.134689984336191e-09,  2.448107247843415e-10, -1.550218127446879e-11,  8.281480487029213e-13, -3.835859969107154e-14,  1.571596632092555e-15, -5.783039341764008e-17,
  1.934218595561595e-18, -5.932700385470087e-20,  3.925489708682981e-07, -1.191104096161800e-07,  1.887751392553126e-08, -2.034077897034148e-09,  1.667400062315265e-10,
 -1.106812994231382e-11,  6.190186429901747e-13, -2.998011537331815e-14,  1.282829191008664e-15, -4.924316296865412e-17,  1.716264003588123e-18, -5.479501834233007e-20,
  2.210696483559578e-07, -7.022098099188014e-08,  1.166944356471702e-08, -1.317578987037337e-09,  1.130542103772683e-10, -7.846092113792206e-12,  4.582568672129861e-13,
 -2.315107744638798e-14,  1.032198542679741e-15, -4.124196087943566e-17,  1.494642738372398e-18, -4.956858364874205e-20,  1.257435291043080e-07, -4.167439474766072e-08,
  7.239521157841893e-09, -8.540519278134918e-10,  7.649595770500674e-11, -5.536020396266609e-12,  3.368121421457192e-13, -1.770656418351505e-14,  8.206799616555616e-16,
 -3.405459965236867e-17,  1.280541709170632e-18, -4.402150880196215e-20,  7.239549829715587e-08, -2.495420489486592e-08,  4.517810655564951e-09, -5.552680381270012e-10,
  5.177372987743201e-11, -3.896900768886227e-12,  2.463467556336884e-13, -1.344378210186704e-14,  6.462336428166883e-16, -2.778643664307669e-17,  1.081727631268235e-18,
 -3.846518270483061e-20,  4.227589928023156e-08, -1.510818015335314e-08,  2.842110798655444e-09, -3.628888034177844e-10,  3.512701149688010e-11, -2.742558035217888e-12,
  1.796869719115443e-13, -1.015438258572245e-14,  5.050332453466305e-16, -2.244953508825082e-17,  9.028029859315736e-19, -3.313475364376986e-20,  2.508565866427433e-08,
 -9.266253866808996e-09,  1.805885507593966e-09, -2.388589413035536e-10,  2.393735497006962e-11, -1.933498047890006e-12,  1.309558821219740e-13, -7.644477353048488e-15,
  3.924370375110793e-16, -1.799245931348366e-17,  7.457538318293751e-19, -2.818864189739976e-20,  1.514882025066122e-08, -5.766611730407984e-09,  1.160876827184912e-09,
 -1.586054737912557e-10,  1.641051756408063e-11, -1.367678045195255e-12,  9.551315628099031e-14, -5.744916483265543e-15,  3.036727804568481e-16, -1.432630707293066e-17,
  6.106073383212550e-19, -2.371700792980199e-20,  9.320626929903214e-09, -3.645722971786756e-09,  7.558899704289660e-10, -1.063733937046181e-10,  1.133193274138371e-11,
 -9.718348953430855e-13,  6.979702029126191e-14, -4.314740836677686e-15,  2.342649626562569e-16, -1.134497392573915e-17,  4.960688281009884e-19, -1.975488190661249e-20,
  5.846121181771687e-09, -2.342955728321078e-09,  4.988671314722073e-10, -7.210441138647184e-11,  7.886624352312582e-12, -6.941136376457678e-13,  5.113238635669160e-14,
 -3.240396480532060e-15,  1.802593881774832e-16, -8.939369702919075e-18,  4.000628998607214e-19, -1.629652292382772e-20,  3.737075577301840e-09, -1.530286106240554e-09,
  3.336420844358209e-10, -4.938760459791891e-11,  5.530833453701836e-12, -4.981908196002148e-13,  3.754284248886925e-14, -2.432695868678644e-15,  1.383048973546727e-16,
 -7.006318105219426e-18,  3.201482687434469e-19, -1.330871377350964e-20,  2.431009063725952e-09, -1.014336694587676e-09,  2.257996535105559e-10, -3.413306365150160e-11,
  3.902737547206443e-12, -3.587944800274812e-13,  2.758525411365274e-14, -1.822880682252004e-15,  1.056446616922257e-16, -5.453301370291796e-18,  2.538066787347029e-19,
 -1.074176176500057e-20,  1.603741127575671e-09, -6.800114938866053e-10,  1.541129477375742e-10, -2.372233065574801e-11,  2.761495203691203e-12, -2.583976494739470e-13,
  2.021356636579629e-14, -1.358610997375226e-15,  8.005731749460407e-17, -4.200256021178989e-18,  1.986232712469911e-19, -8.537792946471809e-21,  1.065689059215526e-09,
 -4.579830565836743e-10,  1.053671827063690e-10, -1.646788541314986e-11,  1.946178245088802e-12, -1.848344676221887e-13,  1.467148630672175e-14, -1.000315109088531e-15,
  5.977572603387169e-17, -3.179460555516472e-18,  1.523823622657523e-19, -6.636454688388904e-21,  7.040101404435726e-10, -3.058450565331607e-10,  7.122686506450899e-11,
 -1.127029731071894e-11,  1.348332876356462e-12, -1.296087339621836e-13,  1.041039331248108e-14, -7.180761189075810e-16,  4.340062805870121e-17, -2.334311865624627e-18,
  1.131024737152897e-19, -4.978418336341072e-21,  4.499621752908646e-10, -1.970980692365848e-10,  4.633039282852780e-11, -7.400458499927575e-12,  8.936994001866777e-13,
 -8.670411857946006e-14,  7.027679123085971e-15, -4.890778108793208e-16,  2.981863868774550e-17, -1.617545256592188e-18,  7.903099801255520e-20, -3.507173668557201e-21,
  2.602056877106063e-10, -1.146298254844250e-10,  2.711930113861825e-11, -4.360256468588076e-12,  5.299880904694877e-13, -5.174814365164310e-14,  4.220832720257556e-15,
 -2.955579370638640e-16,  1.812912844467884e-17, -9.892721916379662e-19,  4.861532992047454e-20, -2.169646685329038e-21,  1.059602198846355e-10, -4.682704155614661e-11,
  1.111814105226759e-11, -1.794094713993234e-12,  2.188610909441953e-13, -2.144588088834178e-14,  1.755362113815291e-15, -1.233393028576930e-16,  7.590950218486188e-18,
 -4.155902159348865e-19,  2.048911364621803e-20, -9.172881324186484e-22,  6.014954043190712e-02, -1.501181941089663e-04,  3.890640695823438e-07, -1.039914400656509e-09,
  2.844000840265680e-12, -7.900962411687356e-15,  2.216419926056977e-17, -6.251030994205279e-20,  1.766887147712375e-22, -4.995224704665058e-25,  1.410554627349198e-27,
 -3.975509066713317e-30,  5.806762883825815e-02, -1.876025448784416e-04,  7.133502778921948e-07, -2.803938122158253e-09,  1.088673656551547e-11, -4.135926229356030e-14,
  1.538382524684583e-16, -5.617160511069931e-19,  2.018508131394040e-21, -7.153270704846814e-24,  2.504059430929059e-26, -8.669778696377813e-29,  5.412183484456808e-02,
 -2.544010867508167e-04,  1.380450569744661e-06, -7.132724364373275e-09,  3.486965244772546e-11, -1.631961749988201e-13,  7.378150649600169e-16, -3.241819123937702e-18,
  1.390227797927050e-20, -5.837431776742285e-23,  2.405873847136991e-25, -9.752037488221785e-28,  4.870992251702975e-02, -3.363179718780182e-04,  2.401718881371844e-06,
 -1.541143330736265e-08,  9.151855591145186e-11, -5.131441931669089e-13,  2.749222772983837e-15, -1.418598599304330e-17,  7.090239530591589e-20, -3.447287560431488e-22,
  1.635909829444977e-24, -7.597210884541264e-27,  4.234225947562231e-02, -4.167239754407014e-04,  3.744635293614744e-06, -2.916990521019258e-08,  2.066536999172361e-10,
 -1.364422913617499e-12,  8.519628722229782e-15, -5.081070607066747e-17,  2.915002308813698e-19, -1.617273767917707e-21,  8.713208469654145e-24, -4.573326796347843e-26,
  3.556175216846810e-02, -4.804759393530495e-04,  5.306400889606140e-06, -4.946488664937468e-08,  4.124505062435544e-10, -3.165689717544008e-12,  2.276061398453887e-14,
 -1.551069835478792e-16,  1.010323607412861e-18, -6.329849945759867e-21,  3.832919763049664e-23, -2.251744613788081e-25,  2.886834869137632e-02, -5.170385816871660e-04,
  6.914239598861137e-06, -7.623731851216543e-08,  7.400824144635547e-10, -6.537352694947264e-12,  5.361581051472850e-14, -4.138238480517136e-16,  3.034862712613485e-18,
 -2.129926855274529e-20,  1.438401128824686e-22, -9.387651378310547e-25,  2.266232686730464e-02, -5.220630584934861e-04,  8.355601455429107e-06, -1.078861831818734e-07,
  1.208339646025919e-09, -1.218328616883818e-11,  1.131141361157209e-13, -9.817434714014434e-16,  8.051137145978739e-18, -6.288509407460559e-20,  4.706792830561253e-22,
 -3.392094176988920e-24,  1.721403513872111e-02, -4.972514366602670e-04,  9.427296165479658e-06, -1.412832525319463e-07,  1.811587094266029e-09, -2.070393332544904e-11,
  2.162042325203615e-13, -2.097382662501697e-15,  1.912434009187983e-17, -1.653372123867244e-19,  1.364380391381247e-21, -1.080319005912240e-23,  1.266038909558813e-02,
 -4.488685867861364e-04,  9.984618534239103e-06, -1.723056681385497e-07,  2.512168178939417e-09, -3.234487303769303e-11,  3.777784882541815e-13, -4.074809405650919e-15,
  4.110719665627195e-17, -3.915181992383269e-19,  3.546071542004588e-21, -3.071528146175030e-23,  9.022520324505774e-03, -3.855732134218387e-04,  9.972846779266105e-06,
 -1.967497424969939e-07,  3.241722098142591e-09, -4.676506159158486e-11,  6.078614532502439e-13, -7.256295520286801e-15,  8.063624495905426e-17, -8.425850423238274e-19,
  8.342945341394250e-21, -7.875234972673598e-23,  6.235858035295126e-03, -3.162694490336902e-04,  9.432142377119970e-06, -2.113228167466116e-07,  3.912738994779870e-09,
 -6.292981758294073e-11,  9.062063792428305e-13, -1.192227317424621e-14,  1.453694904155949e-16, -1.660316489435061e-18,  1.790879597951096e-20, -1.835988396908805e-22,
  4.183744831742261e-03, -2.484890545212954e-04,  8.477763132317852e-06, -2.143785089151645e-07,  4.437433372896018e-09, -7.920409016763066e-11,  1.258353530248659e-12,
 -1.817572001654884e-14,  2.422967497363104e-16, -3.014591735580215e-18,  3.530807344003401e-20, -3.919188387239375e-22,  2.727665308123023e-03, -1.875255994229232e-04,
  7.265557695335747e-06, -2.061743301533916e-07,  4.747833552520919e-09, -9.364805571501694e-11,  1.635172600780385e-12, -2.583850973815952e-14,  3.753410203456121e-16,
 -5.071233539869953e-18,  6.430434992376587e-20, -7.706344584067828e-22,  1.730113741640675e-03, -1.362782015049907e-04,  5.955317768972875e-06, -1.886231357221302e-07,
  4.810478022458644e-09, -1.044334783999625e-10,  1.996845453861904e-12, -3.440488715149162e-14,  5.429214187584868e-16, -7.942663193988911e-18,  1.087362147050973e-19,
 -1.403208311752401e-21,  1.068962237168876e-03, -9.559828019628519e-05,  4.682113412125443e-06, -1.646853793127188e-07,  4.631411271302450e-09, -1.102476558963460e-10,
  2.300545568750700e-12, -4.308403517111290e-14,  7.364177688789453e-16, -1.163333042799234e-17,  1.715004595846685e-19, -2.377260175835926e-21,  6.442397432069184e-04,
 -6.488385967376940e-05,  3.540587090388094e-06, -1.376372927250955e-07,  4.250979790173001e-09, -1.105573481354972e-10,  2.509548618978044e-12, -5.093264011487085e-14,
  9.403535369791044e-16, -1.599893390073967e-17,  2.533584983992267e-19, -3.763486858431073e-21,  3.792899670960829e-04, -4.270407983824369e-05,  2.582026209237454e-06,
 -1.104351805796861e-07,  3.731387390288429e-09, -1.056623476484051e-10,  2.600916054844867e-12, -5.704311335024915e-14,  1.134575766015822e-15, -2.073825967625163e-17,
  3.519470388580400e-19, -5.589865934281285e-21,  2.184862000286591e-04, -2.731642137503336e-05,  1.820658451476309e-06, -8.531038615913666e-08,  3.141712218728151e-09,
 -9.654684179499061e-11,  2.569487658634012e-12, -6.073066457709780e-14,  1.297971043234829e-15, -2.542740222628507e-17,  4.614061061431897e-19, -7.818780310544897e-21,
  1.233517163696593e-04, -1.702077293421386e-05,  1.244503140493220e-06, -6.362514808856003e-08,  2.544804422083993e-09, -8.460034016760809e-11,  2.427350189923033e-12,
 -6.166324141056387e-14,  1.412658003124160e-15, -2.959132381696524e-17,  5.728867593274678e-19, -1.033589079205405e-20,  6.837930137467823e-05, -1.035445934059199e-05,
  8.267551668407771e-07, -4.593928977339161e-08,  1.988798689740146e-09, -7.130596926073314e-11,  2.199511352561484e-12, -5.990091128781678e-14,  1.467418943397628e-15,
 -3.279371457533377e-17,  6.759107880052035e-19, -1.295707414364824e-20,  3.729084795982074e-05, -6.164230561735174e-06,  5.351670321582461e-07, -3.220028769920827e-08,
  1.503905107912646e-09, -5.798092791358845e-11,  1.917549226542489e-12, -5.584386105274767e-14,  1.459439766977471e-15, -3.471935439004163e-17,  7.602479691386410e-19,
 -1.545410853315160e-20,  2.004784017325472e-05, -3.599715278549899e-06,  3.384246280566186e-07, -2.197094244535383e-08,  1.103528523681440e-09, -4.561688705954168e-11,
  1.613232079466601e-12, -5.011622839904511e-14,  1.394049110789567e-15, -3.522642843780821e-17,  8.177902935778571e-19, -1.759330332657480e-20,  1.064777952005606e-05,
 -2.067078993579503e-06,  2.096228202825367e-07, -1.463361721082956e-08,  7.879916288321636e-10, -3.482723148346124e-11,  1.313626335604811e-12, -4.342651275899534e-14,
  1.282794282191488e-15, -3.435743052419476e-17,  8.439149220758508e-19, -1.917675816778482e-20,  5.599667025086707e-06, -1.170136893530600e-06,  1.275208562650378e-07,
 -9.540697970731159e-09,  5.491373504550834e-10, -2.587836844345524e-11,  1.038393585328901e-12, -3.644261887707246e-14,  1.140611997176836e-15, -3.231103089476014e-17,
  8.380204771362579e-19, -2.007527411366059e-20,  2.922855548347570e-06, -6.546779451282153e-07,  7.639622001092560e-08, -6.106021443263337e-09,  3.745550018186945e-10,
 -1.876956390929616e-11,  7.992020866332299e-13, -2.970582870301920e-14,  9.829402422470736e-16, -2.938798328879206e-17,  8.031993096696921e-19, -2.024515909694587e-20,
  1.517980194481813e-06, -3.629775290637950e-07,  4.519728738860634e-08, -3.847015525513885e-09,  2.507769965795654e-10, -1.332752727416702e-11,  6.006827903392933e-13,
 -2.359105102442023e-14,  8.234250445655610e-16, -2.592855298682755e-17,  7.452550700484478e-19, -1.972662488263410e-20,  7.864059413620502e-07, -1.999717347449320e-07,
  2.648030329734321e-08, -2.392913957124925e-09,  1.652978060902521e-10, -9.291917555034633e-12,  4.421983622514946e-13, -1.830707789106895e-14,  6.725455339792543e-16,
 -2.225703525595080e-17,  6.714087332736448e-19, -1.862683828384962e-20,  4.074632696946595e-07, -1.097721838357860e-07,  1.540773907303838e-08, -1.473762080838614e-09,
  1.075792788116740e-10, -6.379768877996404e-12,  3.197861192120520e-13, -1.392336275502673e-14,  5.371611061631148e-16, -1.864304055510822e-17,  5.890376733892015e-19,
 -1.709411254339333e-20,  2.117158419177511e-07, -6.020947090068269e-08,  8.929051028138497e-09, -9.013410414850625e-10,  6.933422661475712e-11, -4.326420732230626e-12,
  2.278523560997964e-13, -1.040879965818676e-14,  4.207704973270774e-16, -1.528240936075497e-17,  5.046957532365767e-19, -1.529050074560480e-20,  1.106158207371185e-07,
 -3.309084757888316e-08,  5.168558142782539e-09, -5.490025099756347e-10,  4.438061766371845e-11, -2.906347548620846e-12,  1.604232093674736e-13, -7.670987922443240e-15,
  3.241892597023937e-16, -1.229525533725662e-17,  4.235264773060015e-19, -1.336861506670963e-20,  5.827168635909964e-08, -1.827427789331072e-08,  2.996888432124408e-09,
 -3.339894803645282e-10,  2.829561360646371e-11, -1.939605537587387e-12,  1.119302617532304e-13, -5.589009843085553e-15,  2.463729757810455e-16, -9.735772436274032e-18,
  3.490591776025443e-19, -1.145591792172134e-20,  3.103406549820309e-08, -1.016865459307348e-08,  1.745528554437791e-09, -2.035117360868470e-10,  1.801981653132610e-11,
 -1.289577725774869e-12,  7.760826232401207e-14, -4.036960501275395e-15,  1.851907734568190e-16, -7.607941761612028e-18,  2.833001218192644e-19, -9.647125696050873e-21,
  1.675302263551960e-08, -5.716690121637732e-09,  1.024043326601948e-09, -1.245453874235748e-10,  1.149391493412413e-11, -8.564935065555155e-13,  5.361827368971331e-14,
 -2.898425413689684e-15,  1.380432470986485e-16, -5.882336744535937e-18,  2.270016077984970e-19, -8.003472681551670e-21,  9.189648848303159e-09, -3.255316710487625e-09,
  6.066860260535781e-10, -7.674804969708614e-11,  7.361851704652735e-12, -5.697040838826548e-13,  3.700467388036672e-14, -2.073662897607315e-15,  1.022928154302375e-16,
 -4.510929131132844e-18,  1.800010083243706e-19, -6.556653628171308e-21,  5.133920878039000e-09, -1.882054398977121e-09,  3.638262006612753e-10, -4.773499721566060e-11,
  4.746013758388124e-12, -3.803943115255544e-13,  2.557034323432337e-14, -1.481714278348367e-15,  7.552210367944934e-17, -3.438445328551733e-18,  1.415507544104598e-19,
 -5.315169508621941e-21,  2.926939498557758e-09, -1.107029040055501e-09,  2.213150059918875e-10, -3.002861137018954e-11,  3.085915584125084e-12, -2.554796477792468e-13,
  1.772622852065316e-14, -1.059468713570444e-15,  5.565845294560668e-17, -2.610046852009563e-18,  1.105938203739076e-19, -4.271231322514802e-21,  1.705635269041006e-09,
 -6.635801985630608e-10,  1.367847188334337e-10, -1.913727612355992e-11,  2.027029170918961e-12, -1.728665122075446e-13,  1.234738929890930e-14, -7.592261897679119e-16,
  4.100716914768755e-17, -1.975825270195974e-18,  8.596757853155391e-20, -3.407010198422045e-21,  1.016971386502880e-09, -4.057907974138577e-10,  8.598899049941407e-11,
 -1.236898123759763e-11,  1.346506507574925e-12, -1.179602027307407e-13,  8.650373502304503e-15, -5.457805093324003e-16,  3.023053245351138e-17, -1.492894025221955e-18,
  6.653797851461452e-20, -2.699626427240700e-21,  6.205259951038156e-10, -2.532134405993436e-10,  5.499572769180993e-11, -8.109459742320084e-12,  9.047183356445275e-13,
 -8.118956121733897e-14,  6.096063911308133e-15, -3.936092441768706e-16,  2.230012629924206e-17, -1.125870777052916e-18,  5.127606009668651e-20, -2.124726049982959e-21,
  3.870561282487262e-10, -1.610654092347013e-10,  3.574795393563850e-11, -5.387682754802970e-12,  6.142022388670952e-13, -5.630249964600041e-14,  4.316445505155312e-15,
 -2.844482560030333e-16,  1.644056853811650e-17, -8.464107310108136e-19,  3.929205112564691e-20, -1.658773321948439e-21,  2.460512705020342e-10, -1.041221162135272e-10,
  2.354525427365101e-11, -3.616185163623606e-12,  4.200276947765986e-13, -3.921752324936924e-14,  3.061346559016718e-15, -2.053352004198474e-16,  1.207505042845897e-17,
 -6.322721218679619e-19,  2.984139410881258e-20, -1.280316883539082e-21,  1.583899175004635e-10, -6.797333607556181e-11,  1.561401376900770e-11, -2.436463101564346e-12,
  2.874912866014782e-13, -2.726195917987673e-14,  2.160697465714479e-15, -1.471013914708918e-16,  8.777673220096767e-18, -4.662265265896786e-19,  2.231420409281622e-20,
 -9.705133748830182e-22,  1.019345517243870e-10, -4.424310922312350e-11,  1.029296377745826e-11, -1.626967507722490e-12,  1.944427568252045e-13, -1.867185693401934e-14,
  1.498261631413845e-15, -1.032446183517715e-16,  6.234169972749521e-18, -3.349935239805062e-19,  1.621637007055795e-20, -7.131600179805215e-22,  6.384397417610537e-11,
 -2.795047258615701e-11,  6.566065844236015e-12, -1.048157291418282e-12,  1.264998411374667e-13, -1.226515391652898e-14,  9.935387447806872e-16, -6.910279334724290e-17,
  4.210711262711523e-18, -2.282860297805854e-19,  1.114758490519058e-20, -4.944322689262001e-22,  3.640067457069209e-11, -1.603117137403997e-11,  3.791441827549366e-12,
 -6.093877122676844e-13,  7.404644615271315e-14, -7.227550096433425e-15,  5.893250580244498e-16, -4.125363386927813e-17,  2.529657812041566e-18, -1.379966002945059e-19,
  6.779474115913584e-21, -3.024717147796496e-22,  1.470601611598191e-11, -6.498099633622448e-12,  1.542589788526845e-12, -2.488803311370731e-13,  3.035572798202736e-14,
 -2.974016494095041e-15,  2.433852945534436e-16, -1.709850265154438e-17,  1.052161986364782e-18, -5.759470638733101e-20,  2.839044103818864e-21, -1.270830359954661e-22,
  5.955521472358590e-02, -1.470548356999069e-04,  3.768529982427131e-07, -9.956462228948225e-10,  2.691162459310723e-12, -7.389402422273482e-15,  2.049043941146740e-17,
 -5.713343946187257e-20,  1.596807447822627e-22, -4.464464747513454e-25,  1.246880858330876e-27, -3.476148922462403e-30,  5.732842326312627e-02, -1.820274320816088e-04,
  6.807214855344903e-07, -2.636172433197370e-09,  1.009523526497447e-11, -3.784881311730281e-14,  1.389771173994116e-16, -5.010579792040350e-19,  1.778137159351268e-21,
 -6.223923072170642e-24,  2.152201396331644e-26, -7.361634354257432e-29,  5.312578869022185e-02, -2.436906103739328e-04,  1.298100688860522e-06, -6.599989184287824e-09,
  3.177570391876785e-11, -1.465294714065597e-13,  6.529691997213952e-16, -2.828793251910412e-18,  1.196416501842396e-20, -4.955671986631713e-23,  2.015231928902575e-25,
 -8.061129475908751e-28,  4.740194100601668e-02, -3.178198339185967e-04,  2.225240042386725e-06, -1.402578507769684e-08,  8.188458965461526e-11, -4.516839860470091e-13,
  2.382000158549122e-15, -1.210366961276801e-17,  5.959370160861523e-20, -2.855164782143967e-22,  1.335492938416943e-24, -6.114567262327386e-27,  4.073313753456090e-02,
 -3.881128428068494e-04,  3.413569376579056e-06, -2.607110950202090e-08,  1.812999415801289e-10, -1.176021642692986e-12,  7.219226085081132e-15, -4.235072876983180e-17,
  2.390955502021990e-19, -1.305885303645873e-21,  6.928329418005675e-24, -3.582077317348802e-26,  3.372114376512625e-02, -4.402914863512093e-04,  4.750420401932606e-06,
 -4.334392255084498e-08,  3.542655010805953e-10, -2.668098035710835e-12,  1.883798879077050e-14, -1.261450636369342e-16,  8.078145251429915e-19, -4.977904794321359e-21,
  2.965848990973952e-23, -1.714941214006852e-25,  2.690529980205353e-02, -4.651922550985453e-04,  6.066341200762203e-06, -6.537581216100406e-08,  6.213184499982326e-10,
 -5.379314701500514e-12,  4.328056216894937e-14, -3.279422102280133e-16,  2.362416161565084e-18, -1.629419688616938e-20,  1.081896336691835e-22, -6.944875813087337e-25,
  2.070000564681914e-02, -4.600857199142461e-04,  7.169380356271498e-06, -9.036342179058294e-08,  9.897367550335275e-10, -9.771268571804530e-12,  8.891620272149144e-14,
 -7.569683658819835e-16,  6.093026870599881e-18, -4.673672537138322e-20,  3.436981482943411e-22, -2.434694047165957e-24,  1.536578495449953e-02, -4.281516443762421e-04,
  7.893006438152863e-06, -1.153473478771533e-07,  1.444975937891458e-09, -1.615574370258378e-11,  1.652204512116984e-13, -1.570969451583898e-15,  1.404982020001638e-17,
 -1.192087804158484e-19,  9.659431829246048e-22, -7.513565317682820e-24,  1.101247707677541e-02, -3.766251467877196e-04,  8.138266880119462e-06, -1.368298093996886e-07,
  1.947412198456017e-09, -2.451078805581956e-11,  2.801618157503092e-13, -2.959959993847786e-15,  2.927027132801680e-17, -2.734437742187500e-19,  2.430591691378298e-21,
 -2.067196299138505e-23,  7.625997235859791e-03, -3.144189343454426e-04,  7.894580994256680e-06, -1.516361191015148e-07,  2.437246207340365e-09, -3.434880373418635e-11,
  4.366728531325257e-13, -5.103076919883626e-15,  5.555876744532288e-17, -5.691581308880791e-19,  5.528285684897138e-21, -5.121694573300155e-23,  5.107019390510783e-03,
 -2.499800435579692e-04,  7.233896848446379e-06, -1.577107750978430e-07,  2.847091578395546e-09, -4.471174294095490e-11,  6.294237612634957e-13, -8.102936576465892e-15,
  9.675556834998616e-17, -1.082970461561904e-18,  1.145464172430319e-20, -1.152159507742380e-22,  3.310697759511719e-03, -1.898606646829267e-04,  6.283817752339492e-06,
 -1.545698011218276e-07,  3.118269375381796e-09, -5.432580924810478e-11,  8.434312755815935e-13, -1.191657184561979e-14,  1.555180255061909e-16, -1.895604943980807e-18,
  2.176480934576850e-20, -2.369657879337382e-22,  2.079794153192796e-03, -1.381357159085828e-04,  5.191739290759631e-06, -1.432839798384528e-07,  3.215070380584382e-09,
 -6.188087556760683e-11,  1.055590320859214e-12, -1.631176980070020e-14,  2.319142990404619e-16, -3.069035623006975e-18,  3.814146944053032e-20, -4.482583437384159e-22,
  1.267608086048752e-03, -9.652443503510279e-05,  4.092337864317049e-06, -1.260562826226856e-07,  3.132146433000963e-09, -6.634296136450824e-11,  1.239102363241227e-12,
 -2.087457677747671e-14,  3.223572121221313e-16, -4.618403140818461e-18,  6.195999573323905e-20, -7.840250882967543e-22,  7.505466492734962e-04, -6.493647110177391e-05,
  3.086443072789501e-06, -1.055892923273137e-07,  2.893151939648861e-09, -6.719216637872181e-11,  1.369520342647190e-12, -2.507641512158197e-14,  4.194225716012277e-16,
 -6.488335852105642e-18,  9.373126889168861e-20, -1.273937586077093e-21,  4.323281999842555e-04, -4.215845333255505e-05,  2.233474928325021e-06, -8.446823097686806e-08,
  2.542155292681537e-09, -6.451075774032708e-11,  1.430393894733441e-12, -2.838490661849632e-14,  5.128341057496473e-16, -8.544623321602687e-18,  1.325994227460913e-19,
 -1.931365108303151e-21,  2.426388923986642e-04, -2.647481759283206e-05,  1.554942709895530e-06, -6.472457012469648e-08,  2.131581007991533e-09, -5.890764708409596e-11,
  1.416660248386568e-12, -3.038338721363866e-14,  5.914485212237117e-16, -1.058824811744756e-17,  1.761097991515647e-19, -2.742995196202821e-21,  1.329046879347450e-04,
 -1.611905064113539e-05,  1.044272992223782e-06, -4.764329055052986e-08,  1.710797801464202e-09, -5.132455107990517e-11,  1.334867185148011e-12, -3.086008781333552e-14,
  6.456543390474241e-16, -1.239067720900537e-17,  2.204024824258546e-19, -3.663305477606853e-21,  7.117557852135477e-05, -9.537176805748992e-06,  6.783120611730107e-07,
 -3.378541083766599e-08,  1.318244291513297e-09, -4.280039429895375e-11,  1.200526040685588e-12, -2.984061002205820e-14,  6.694196418284847e-16, -1.374074418427031e-17,
  2.608408292472692e-19, -4.617137486444356e-21,  3.733939387731763e-05, -5.496788398116865e-06,  4.272816602253325e-07, -2.314643081759857e-08,  9.781008376313753e-10,
 -3.426688428024398e-11,  1.033804520116069e-12, -2.755952715453677e-14,  6.613697335818145e-16, -1.448864508991110e-17,  2.929158221520446e-19, -5.510978676388809e-21,
  1.922833338112487e-05, -3.093630979893875e-06,  2.617181694207798e-07, -1.536392240012564e-08,  7.008876923702954e-10, -2.641989124228524e-11,  8.550569278498924e-13,
 -2.438775589808006e-14,  6.246585778648264e-16, -1.457379781610931e-17,  3.131567181771335e-19, -6.250307489091357e-21,  9.741032848759764e-06, -1.704480546550003e-06,
  1.563051186625776e-07, -9.909003345434831e-09,  4.864979759799636e-10, -1.967618087567828e-11,  6.813825607696119e-13, -2.074332778147414e-14,  5.658243013515831e-16,
 -1.402969333923584e-17,  3.197780345017697e-19, -6.758014892231915e-21,  4.865936259554008e-06, -9.217429029422402e-07,  9.127280792319005e-08, -6.227742194004197e-09,
  3.280820496879485e-10, -1.419818345592964e-11,  5.247786087285687e-13, -1.701208220731514e-14,  4.931054442915936e-16, -1.296711693762827e-17,  3.128972033657262e-19,
 -6.988560763798295e-21,  2.402660010811684e-06, -4.905587884089679e-07,  5.226077675425863e-08, -3.825495763637619e-09,  2.156098641537299e-10, -9.957393596178828e-12,
  3.918370062603466e-13, -1.349509436648474e-14,  4.147562543173538e-16, -1.154357951638789e-17,  2.943117697590277e-19, -6.934217241537826e-21,  1.175722711579687e-06,
 -2.576591200134297e-07,  2.942688986715604e-08, -2.303606866419521e-09,  1.385075043015464e-10, -6.808185468826108e-12,  2.845397750792894e-13, -1.038737019937404e-14,
  3.377673165471031e-16, -9.929297881250939e-18,  2.669602358101742e-19, -6.622594122000314e-21,  5.717147297366983e-07, -1.339439307089497e-07,  1.634353185979265e-08,
 -1.364030921332386e-09,  8.724682523421247e-11, -4.552570052876158e-12,  2.015874564514180e-13, -7.782611085250369e-15,  2.671737305042479e-16, -8.278591674607901e-18,
  2.342582458570801e-19, -6.107346418187106e-21,  2.770384034449043e-07, -6.912127970051949e-08,  8.980689633368990e-09, -7.966929611804787e-10,  5.405922203118147e-11,
 -2.986778160897199e-12,  1.397824705018879e-13, -5.694049073727785e-15,  2.059231322258923e-16, -6.711718317660260e-18,  1.994923263286798e-19, -5.455536687097685e-21,
  1.341696968933334e-07, -3.551684987314566e-08,  4.897699874976947e-09, -4.604536775557121e-10,  3.305391010829208e-11, -1.928700092663967e-12,  9.517118077878021e-14,
 -4.081174031966455e-15,  1.551451022512271e-16, -5.307978326980178e-18,  1.653904559712850e-19, -4.735251326907889e-21,  6.513684051616524e-08, -1.822814898039393e-08,
  2.659329386070651e-09, -2.641821118180735e-10,  2.000831111576996e-11, -1.229829526407499e-12,  6.382956303235133e-14, -2.874822169357309e-15,  1.146246091494968e-16,
 -4.107878722421502e-18,  1.339093153725304e-19, -4.006081400820797e-21,  3.179708275107625e-08, -9.373640058124130e-09,  1.442258727012400e-09, -1.509550445548636e-10,
  1.202929182064410e-11, -7.768710308307434e-13,  4.230591235970143e-14, -1.996589179825174e-15,  8.331111587515814e-17, -3.120789004470468e-18,  1.062131054224112e-19,
 -3.313625334232417e-21,  1.565601380873408e-08, -4.845216781698083e-09,  7.837965644223635e-10, -8.618326385551522e-11,  7.206352163849306e-12, -4.877249316626794e-13,
  2.779918265911714e-14, -1.371498285476543e-15,  5.975526563922116e-17, -2.334622724617314e-18,  8.278330413020984e-20, -2.687860927608505e-21,  7.799243075407651e-09,
 -2.525423083487880e-09,  4.281947961778834e-10, -4.931969086870293e-11,  4.315426113098730e-12, -3.052821394882321e-13,  1.816691336559254e-14, -9.347220103212821e-16,
  4.242607608594843e-17, -1.725011010949231e-18,  6.359208635716683e-20, -2.144414279119208e-21,  3.942980449507437e-09, -1.331448164603067e-09,  2.358949178883757e-10,
 -2.837918919645573e-11,  2.591299901319965e-12, -1.911040580607965e-13,  1.184337816109908e-14, -6.339582257059861e-16,  2.990643872501601e-17, -1.262587900383000e-18,
  4.828473393739186e-20, -1.687479326087817e-21,  2.028972541218461e-09, -7.121790436735539e-10,  1.314454208939304e-10, -1.646903421671303e-11,  1.564926434846261e-12,
 -1.199950188895392e-13,  7.724697254148675e-15, -4.291183202550957e-16,  2.098932636732108e-17, -9.179755358177578e-19,  3.633671340733864e-20, -1.313275225730261e-21,
  1.065636032467924e-09, -3.875751389466570e-10,  7.429356248420241e-11, -9.666008650695553e-12,  9.531532361690249e-13, -7.578371142406396e-14,  5.054461337092007e-15,
 -2.906614318607457e-16,  1.470510182287131e-17, -6.646776154691388e-19,  2.717048311622273e-20, -1.013265671602985e-21,  5.726729549366542e-10, -2.151453006361755e-10,
  4.270150552099921e-11, -5.752222952199188e-12,  5.869603232841327e-13, -4.825865288805318e-14,  3.325855294599457e-15, -1.974774781854424e-16,  1.030804169709872e-17,
 -4.803748892336677e-19,  2.023108077505461e-20, -7.767304972787929e-22,  3.155584504087575e-10, -1.220814134496786e-10,  2.501222130575313e-11, -3.478196270559892e-12,
  3.662157929411979e-13, -3.104901345109418e-14,  2.205122597674823e-15, -1.348375878226211e-16,  7.243402882367588e-18, -3.471634548205776e-19,  1.502729261824218e-20,
 -5.925724238244188e-22,  1.785611131632674e-10, -7.092321907790462e-11,  1.495391515040795e-11, -2.140263676765388e-12,  2.318443611540371e-13, -2.021265743818469e-14,
  1.475270081286827e-15, -9.265168909372905e-17,  5.108922382013643e-18, -2.511940290852744e-19,  1.114792956695354e-20, -4.504256954507444e-22,  1.038289708984931e-10,
 -4.221422702639999e-11,  9.131825600095994e-12, -1.341126177928856e-12,  1.490270094447634e-13, -1.332172855123032e-14,  9.964536074506859e-16, -6.410020643824615e-17,
  3.618489439409643e-18, -1.820426106589897e-19,  8.262310336727793e-21, -3.412186314416165e-22,  6.200303188673973e-11, -2.572865958526938e-11,  5.692623058031996e-12,
 -8.552655283004657e-13,  9.719990773855539e-14, -8.883084826594695e-15,  6.790053915698358e-16, -4.461605342852616e-17,  2.571436200132861e-18, -1.320203477342349e-19,
  6.112154973388925e-21, -2.573582716717925e-22,  3.792598851071050e-11, -1.601574248566603e-11,  3.613254414444150e-12, -5.536413068516938e-13,  6.415797021221494e-14,
 -5.976769676796917e-15,  4.655150627372390e-16, -3.115599039157575e-17,  1.828294537524657e-18, -9.553493433188364e-20,  4.499868002641241e-21, -1.926832744268697e-22,
  2.361993383189269e-11, -1.012166265627777e-11,  2.321212052411399e-12, -3.616095067604592e-13,  4.259830198874217e-14, -4.032970267138165e-15,  3.191367753712220e-16,
 -2.169351022802152e-17,  1.292522099728226e-18, -6.855139643353147e-20,  3.276245823177745e-21, -1.422947107683848e-22,  1.479228315034984e-11, -6.414187603485075e-12,
  1.490621374435875e-12, -2.353591203695371e-13,  2.809789488269596e-14, -2.695301438854581e-15,  2.160501317914627e-16, -1.487274209860130e-17,  8.971577857700873e-19,
 -4.816182552347867e-20,  2.329196586709617e-21, -1.023377979823296e-22,  9.070898636203367e-12, -3.968910543585962e-12,  9.317672560492098e-13, -1.486431040366846e-13,
  1.792778649030939e-14, -1.737130450914243e-15,  1.406281066779249e-16, -9.774989048603435e-18,  5.952714461212488e-19, -3.225398532865209e-20,  1.574108922767848e-21,
 -6.977773184811130e-23,  5.095819175308642e-12, -2.243569719317797e-12,  5.304336995109868e-13, -8.522563097666339e-14,  1.035216885914654e-14, -1.010114786570703e-15,
  8.233592236431417e-17, -5.761744695603439e-18,  3.531941686856040e-19, -1.926117084101552e-20,  9.459658052450552e-22, -4.219221045991408e-23,  2.041754829896338e-12,
 -9.020496634889934e-13,  2.141021272681347e-13, -3.453709701183224e-14,  4.211730706442919e-15, -4.125613540504277e-16,  3.375712976924324e-17, -2.371134312645161e-18,
  1.458842871225096e-19, -7.984307860333644e-21,  3.935107543524277e-22, -1.761176902779015e-23,  5.897295037845867e-02, -1.440870817974307e-04,  3.651588032485303e-07,
 -9.537437421094404e-10,  2.548165460008397e-12, -6.916265820190476e-15,  1.895989084673314e-17, -5.227147407468784e-20,  1.444707726476670e-22, -3.994984995054985e-25,
  1.103665124981862e-27, -3.043884194143024e-30,  5.661100853163962e-02, -1.767055069461373e-04,  6.500321529835253e-07, -2.480527909883218e-09,  9.370509483730195e-12,
 -3.467548928216633e-14,  1.257115644423280e-16, -4.475825509580333e-19,  1.568822112061732e-21, -5.424452313076934e-24,  1.853149654706972e-26, -6.263051370047023e-29,
  5.217130617560427e-02, -2.336141786758806e-04,  1.221857263162159e-06, -6.114197337525557e-09,  2.899562818373960e-11, -1.317670172274797e-13,  5.788654364432961e-16,
 -2.472995665393187e-18,  1.031706410787771e-20, -4.216248927711626e-23,  1.691936909466416e-25, -6.679837710199475e-28,  4.616523011460374e-02, -3.006695455909334e-04,
  2.064503186432949e-06, -1.278490642090222e-08,  7.339621353544837e-11, -3.983764658347302e-13,  2.068320740350517e-15, -1.035132256467231e-17,  5.021519742397795e-20,
 -2.371110799895432e-22,  1.093352844045871e-24, -4.936070801888695e-27,  3.923338920614277e-02, -3.620081157981853e-04,  3.117374111313119e-06, -2.334944819121201e-08,
  1.594203621443335e-10, -1.016167092308863e-12,  6.133817237699413e-15, -3.540131084477679e-17,  1.967143366712306e-19, -1.057875683703762e-21,  5.527906255228732e-24,
 -2.815728093327223e-26,  3.203282129313757e-02, -4.042761728712761e-04,  4.262618287141038e-06, -3.807915587272825e-08,  3.051529831262377e-10, -2.255607738792994e-12,
  1.564243825650585e-14, -1.029472904744239e-16,  6.482628008584382e-19, -3.929771140525503e-21,  2.304157456688630e-23, -1.311586292502856e-25,  2.513685192899246e-02,
 -4.196383906421105e-04,  5.338102320383619e-06, -5.624194444015115e-08,  5.234176709388768e-10, -4.442740859458811e-12,  3.507398424679139e-14, -2.609514307876249e-16,
  1.846879593421585e-18, -1.252122324784714e-20,  8.175501180746645e-23, -5.162616495927207e-25,  1.896786661722712e-02, -4.068130461766918e-04,  6.173941790359873e-06,
 -7.598191892202016e-08,  8.140420668102517e-10, -7.871053419108173e-12,  7.021559468750153e-14, -5.864547514083210e-16,  4.634152177539471e-18, -3.491489785011480e-20,
  2.523182008135088e-22, -1.757173137938567e-24,  1.377122425313658e-02, -3.701744598035878e-04,  6.637552284487661e-06, -9.461129428572176e-08,  1.158197671246303e-09,
 -1.267120838770107e-11,  1.269321096100868e-13, -1.183184339515791e-15,  1.038083189993171e-17, -8.645733120767961e-20,  6.880171246819738e-22, -5.258286955534605e-24,
  9.626491208918560e-03, -3.175921618981265e-04,  6.668194369688021e-06, -1.092539941509783e-07,  1.518232797066080e-09, -1.868407626109221e-11,  2.090402757496042e-13,
 -2.163696555025463e-15,  2.097715148551786e-17, -1.922518294735915e-19,  1.677394509815515e-21, -1.400996450279071e-23,  6.483981899500404e-03, -2.579266271400062e-04,
  6.287972955850683e-06, -1.176117621431166e-07,  1.844461006093126e-09, -2.539989768067616e-11,  3.158772591316939e-13, -3.614404238113113e-15,  3.855990328274560e-17,
 -3.873322235342982e-19,  3.691140601686223e-21, -3.356816750758089e-23,  4.211865506683075e-03, -1.989675653622986e-04,  5.587640705851882e-06, -1.185616976980381e-07,
  2.087207033073715e-09, -3.201138289055132e-11,  4.406043142763826e-13, -5.551171507106062e-15,  6.492381442523160e-17, -7.122485109486850e-19,  7.388344022967918e-21,
 -7.292299642580054e-23,  2.641145786630870e-03, -1.462372582976284e-04,  4.695754349558069e-06, -1.123738669063429e-07,  2.209809012511455e-09, -3.758259087346715e-11,
  5.702696088181857e-13, -7.882326430551304e-15,  1.007198578193224e-16, -1.202884998402583e-18,  1.354085942985174e-20, -1.446228947127762e-22,  1.600550506684093e-03,
 -1.026907633696466e-04,  3.744205084604187e-06, -1.005087158296315e-07,  2.197735729036073e-09, -4.128130407157720e-11,  6.880437958695319e-13, -1.039854340164952e-14,
  1.447153213294789e-16, -1.875952842815039e-18,  2.285234066738271e-20, -2.634069822534465e-22,  9.384893818442319e-04, -6.907574128136196e-05,  2.841299660212478e-06,
 -8.512059060115100e-08,  2.060757826356065e-09, -4.259077887562705e-11,  7.770907437829115e-13, -1.280128586141911e-14,  1.934694297798008e-16, -2.714734894470291e-18,
  3.569379370386139e-20, -4.429093819353774e-22,  5.331486769472120e-04, -4.461788801310310e-05,  2.057960014909934e-06, -6.847772487646798e-08,  1.828128648161835e-09,
 -4.142515866252830e-11,  8.247531374199556e-13, -1.476574501660594e-14,  2.416816355498269e-16, -3.661426130742384e-18,  5.183395184327145e-20, -6.907999804042039e-22,
  2.938710850484864e-04, -2.774081852147948e-05,  1.426702638197377e-06, -5.249040602892377e-08,  1.539356564475570e-09, -3.811559122904419e-11,  8.255581894844549e-13,
 -1.601840297674409e-14,  2.832128235890470e-16, -4.621208262529976e-18,  7.027796475813037e-20, -1.003737457003204e-21,  1.574136510846312e-04, -1.664109701999498e-05,
  9.492779023185215e-07, -3.845202098911797e-08,  1.234235269013483e-09, -3.328681510777980e-11,  7.820670826726467e-13, -1.640216842159313e-14,  3.124840824525417e-16,
 -5.478986148983609e-18,  8.931237617872945e-20, -1.364170192479010e-21,  8.208270590317633e-05, -9.654416614831225e-06,  6.078423302628134e-07, -2.699830904639440e-08,
  9.451999649794900e-10, -2.768037121943426e-11,  7.034972076515231e-13, -1.590730162171975e-14,  3.257810575203761e-16, -6.124369035960805e-18,  1.067841870327768e-19,
 -1.740802620146833e-21,  4.174388819569508e-05, -5.429955214886208e-06,  3.755784845436372e-07, -1.822182960322279e-08,  6.934883359568937e-10, -2.198743388267479e-11,
  6.028624333497927e-13, -1.466081128226137e-14,  3.220283185379543e-16, -6.476768321080219e-18,  1.205465482450997e-19, -2.093349561338053e-21,  2.074616795984995e-05,
 -2.967994714322225e-06,  2.245474869252357e-07, -1.185624079324481e-08,  4.889463304608576e-10, -1.673555660355049e-11,  4.937501347649618e-13, -1.288285866997463e-14,
  3.028214741684051e-16, -6.502353270717944e-18,  1.289312211998819e-19, -2.380512869858791e-21,  1.009773110956108e-05, -1.580633491363537e-06,  1.302623867083388e-07,
 -7.458895828323055e-09,  3.322851662461649e-10, -1.224409724013424e-11,  3.877189490623030e-13, -1.082858536016457e-14,  2.717926818481210e-16, -6.218010227118535e-18,
  1.310956075243203e-19, -2.568760687432832e-21,  4.824525144719644e-06, -8.223287362433068e-07,  7.353031361742642e-08, -4.550579871738867e-09,  2.183344984995546e-10,
 -8.637724355794454e-12,  2.928442639686867e-13, -8.734640930398163e-15,  2.335996972252410e-16, -5.682507716254483e-18,  1.271441868978935e-19, -2.639149825014156e-21,
  2.268306844583226e-06, -4.190797203533251e-07,  4.050580456291843e-08, -2.700483674363868e-09,  1.391390142134547e-10, -5.894364907348885e-12,  2.134344563270794e-13,
 -6.783363267335242e-15,  1.928921631900781e-16, -4.979320574651703e-18,  1.180116095066404e-19, -2.590239595029971e-21,  1.052216088363455e-06, -2.098092594224857e-07,
  2.184121501961189e-08, -1.563679536437397e-09,  8.627183943731277e-11, -3.903361261076291e-12,  1.505961053318376e-13, -5.088562787103887e-15,  1.535306637491308e-16,
 -4.197367663963155e-18,  1.051748028892632e-19, -2.436646858287596e-21,  4.829148936130153e-07, -1.034953683749491e-07,  1.156356439661657e-08, -8.862749370990736e-10,
  5.221435534515064e-11, -2.516675999677861e-12,  1.032088584669897e-13, -3.699420267313008e-15,  1.181830707486052e-16, -3.415097163036672e-18,  9.030236427403098e-20,
 -2.204256323935968e-21,  2.199230789272697e-07, -5.045788539348675e-08,  6.030478944434079e-09, -4.933136836671803e-10,  3.094921033408007e-11, -1.585081877817277e-12,
  6.893325700003392e-14, -2.615272716393360e-15,  8.827756129931830e-17, -2.690918907309760e-18,  7.494367642967556e-20, -1.923938278752883e-21,  9.968730256002921e-08,
 -2.439179749943993e-08,  3.108061813846330e-09, -2.705626302207314e-10,  1.802674917770203e-11, -9.785606844324623e-13,  4.502217785436196e-14, -1.803932261116608e-15,
  6.420232136060888e-17, -2.060314387775785e-18,  6.032193247242750e-20, -1.625649049239999e-21,  4.512004032743904e-08, -1.173027361263779e-08,  1.588468204090315e-09,
 -1.467212852263492e-10,  1.035362997149127e-11, -5.942056723930647e-13,  2.885418962254260e-14, -1.218249845060229e-15,  4.561851805461820e-17, -1.538070946532683e-18,
  4.724797684354981e-20, -1.334197939307663e-21,  2.045983679808068e-08, -5.631291118198491e-09,  8.078447730625249e-10, -7.894424133818553e-11,  5.884375796902664e-12,
 -3.561409615011712e-13,  1.820928178983365e-14, -8.083005900612565e-16,  3.177733626087754e-17, -1.123341359981769e-18,  3.613490483191892e-20, -1.067147120442330e-21,
  9.326567069243559e-09, -2.708097970843534e-09,  4.102762429773649e-10, -4.229559139160526e-11,  3.321126124259045e-12, -2.114374409441552e-13,  1.135552421971325e-14,
 -5.287446308743112e-16,  2.177614386673570e-17, -8.054239250793239e-19,  2.707532704514711e-20, -8.346186389113098e-22,  4.288857673442954e-09, -1.309249837992010e-09,
  2.088243744756195e-10, -2.264521301587041e-11,  1.868108762496273e-12, -1.247848009197735e-13,  7.022371132352962e-15, -3.421932919890155e-16,  1.473091381779652e-17,
 -5.688443689064561e-19,  1.994261251270341e-20, -6.403968386373060e-22,  1.996587332732192e-09, -6.386119927286683e-10,  1.069065632083884e-10, -1.215973588612912e-11,
  1.050998293338712e-12, -7.346822487077334e-14,  4.321599234978775e-15, -2.198632156173054e-16,  9.870658650418580e-18, -3.970810262804946e-19,  1.448737266797451e-20,
 -4.836397152776162e-22,  9.442386818428258e-10, -3.153934371877985e-10,  5.524510981140114e-11, -6.571737375204117e-12,  5.934920495959106e-13, -4.330213889091545e-14,
  2.655730882892351e-15, -1.407221788365929e-16,  6.573256137540061e-18, -2.748574333032392e-19,  1.041351238018775e-20, -3.606464648406768e-22,  4.552073945693887e-10,
 -1.582627710636369e-10,  2.891737712490208e-11, -3.587108651143394e-12,  3.375404843620043e-13, -2.563641700220439e-14,  1.635110515909817e-15, -9.001654222109484e-17,
  4.364441009877984e-18, -1.892552096381794e-19,  7.429285985855439e-21, -2.663441635477920e-22,  2.244357406692006e-10, -8.095746788932596e-11,  1.538289122954807e-11,
 -1.984008040810819e-12,  1.939740942005035e-13, -1.529435720995775e-14,  1.011807015882200e-15, -5.772585150816486e-17,  2.898022727098750e-18, -1.300120569266903e-19,
  5.275867363918336e-21, -1.953585113305123e-22,  1.135118713561232e-10, -4.234648709464787e-11,  8.341726746309203e-12, -1.115288959691199e-12,  1.129690587297288e-13,
 -9.221449046284737e-15,  6.310715326486917e-16, -3.721537033856631e-17,  1.929689429917705e-18, -8.934556115621032e-20,  3.739089748579847e-21, -1.426748739480361e-22,
  5.904730371407313e-11, -2.271019856781890e-11,  4.623453518596685e-12, -6.388722059748209e-13,  6.684820363400099e-14, -5.633178306998038e-15,  3.977001348732785e-16,
 -2.417776757129768e-17,  1.291499403383256e-18, -6.155942961934550e-20,  2.650399208510423e-21, -1.039695867410378e-22,  3.165637438036351e-11, -1.251345275301657e-11,
  2.624646712356121e-12, -3.736863796359005e-13,  4.027138517967770e-14, -3.493264182022895e-15,  2.537110390753302e-16, -1.585746222081718e-17,  8.703109476953850e-19,
 -4.259616684429160e-20,  1.882008037624408e-21, -7.571285548877821e-23,  1.751245219744348e-11, -7.092908534001784e-12,  1.527911733117880e-12, -2.234491521276137e-13,
  2.472687465548236e-14, -2.201390841974124e-15,  1.640086310864324e-16, -1.050954135991003e-17,  5.910277518370395e-19, -2.962447611485801e-20,  1.339726323755518e-21,
 -5.513495358063965e-23,  9.995861094809199e-12, -4.135616689156894e-12,  9.120468687440845e-13, -1.365774637529735e-13,  1.547164471865360e-14, -1.409466903135017e-15,
  1.074028194565728e-16, -7.035854910063356e-18,  4.043119927545862e-19, -2.069799776982146e-20,  9.555627575242879e-22, -4.012486422876463e-23,  5.874360436282624e-12,
 -2.475246650315709e-12,  5.570727682080626e-13, -8.514822067640652e-14,  9.843387899557038e-15, -9.148027269685252e-16,  7.108601285663985e-17, -4.746842573640783e-18,
  2.779365952520638e-19, -1.449176485942327e-20,  6.811474042069423e-22, -2.910665498360765e-23,  3.534697114523728e-12, -1.512361831156539e-12,  3.462347835166834e-13,
 -5.384439291729994e-14,  6.332077328239784e-15, -5.984747469099997e-16,  4.728028092867268e-17, -3.208718173065411e-18,  1.908774174394925e-19, -1.010796784133815e-20,
  4.823595403246051e-22, -2.091930836982023e-23,  2.151623217847461e-12, -9.320393955977801e-13,  2.163555287188214e-13, -3.412196429336918e-14,  4.068966512532454e-15,
 -3.898822927313797e-16,  3.121809179434685e-17, -2.146736861622155e-18,  1.293608801642699e-19, -6.937352935633395e-21,  3.351690544746688e-22, -1.471200868828460e-23,
  1.290607670213363e-12, -5.643586631259422e-13,  1.324031255995118e-13, -2.110757933977352e-14,  2.544050361093804e-15, -2.463437137319419e-16,  1.992951257306423e-17,
 -1.384401692266443e-18,  8.425352507697028e-20, -4.562359227058396e-21,  2.225254779372986e-22, -9.858415732308520e-24,  7.139100482001754e-13, -3.142195818836924e-13,
  7.426273945043594e-14, -1.192761561311453e-14,  1.448302121410045e-15, -1.412683851639175e-16,  1.151098594009152e-17, -8.052463568828130e-19,  4.934493877078560e-20,
 -2.690102674362599e-21,  1.320752447453181e-22, -5.888994918840137e-24,  2.835785142325047e-13, -1.252661376705038e-13,  2.972681531136213e-14, -4.794415198794284e-15,
  5.845649834631025e-16, -5.725108372834297e-17,  4.683650388936861e-18, -3.289272340845996e-19,  2.023382088195894e-20, -1.107218589833264e-21,  5.456076136823804e-23,
 -2.441494448493571e-24,  5.840237307243124e-02, -1.412109083245874e-04,  3.539540162410897e-07, -9.140554619758612e-10,  2.414274610271672e-12, -6.478282239500074e-15,
  1.755890965539797e-17, -4.787025524936878e-20,  1.308522348853253e-22, -3.579163305253883e-25,  9.781718535477734e-28, -2.669128686160677e-30,  5.591440202828390e-02,
 -1.716218179458272e-04,  6.211430207563158e-07, -2.335988069734878e-09,  8.706183926988295e-12, -3.180330206632533e-14,  1.138537177882738e-16, -4.003668829124821e-19,
  1.386246411771064e-21, -4.735470556492593e-24,  1.598489118934604e-26, -5.338563500103258e-29,  5.125594537441212e-02, -2.241251107278555e-04,  1.151185891563602e-06,
 -5.670618058058566e-09,  2.649379380917573e-11, -1.186692239708258e-13,  5.140244090671051e-16, -2.165884398359159e-18,  8.914271735683145e-21, -3.594763172211284e-23,
  1.423725856046125e-25, -5.548560435436539e-28,  4.499463973762648e-02, -2.847478203233252e-04,  1.917875892391764e-06, -1.167170552454182e-08,  6.590251041493539e-11,
 -3.520408299708101e-13,  1.799754677267335e-15, -8.872978578243040e-18,  4.241675759304825e-20, -1.974286945553284e-22,  8.976045093604304e-25, -3.996403349970912e-27,
  3.783351941516877e-02, -3.381480283133884e-04,  2.851839435741509e-06, -2.095363529316240e-08,  1.404923785037455e-10, -8.801727213260604e-13,  5.225274114639910e-15,
 -2.967542286002120e-17,  1.623294591184182e-19, -8.596780873816969e-22,  4.425239076301082e-24, -2.221060956153108e-26,  3.048113729810868e-02, -3.719233251457014e-04,
  3.833537895726670e-06, -3.353814714003582e-08,  2.635731113944341e-10, -1.912560020771622e-12,  1.303027366181903e-14, -8.429925018003596e-17,  5.220785510229461e-19,
 -3.113946646226706e-21,  1.797105604469078e-23, -1.007199221656080e-25,  2.353962606473682e-02, -3.794972834884863e-04,  4.710656517211838e-06, -4.853473299511033e-08,
  4.424215979381274e-10, -3.682361595398864e-12,  2.853123638542564e-14, -2.084742536464162e-16,  1.449887189747902e-18, -9.663925850693907e-21,  6.206012650425372e-23,
 -3.855835714747068e-25,  1.743392041083406e-02, -3.608586201979955e-04,  5.335393936874512e-06, -6.413034905297942e-08,  6.722245784478950e-10, -6.367266184164462e-12,
  5.569506083879811e-14, -4.564667480048533e-16,  3.541674621335527e-18, -2.621465516517051e-20,  1.861990016519519e-22, -1.275016186345665e-24,  1.238995743646768e-02,
 -3.213185920564226e-04,  5.605547665146088e-06, -7.795262904777863e-08,  9.327361979093728e-10, -9.987547255322366e-12,  9.802105344475021e-14, -8.959074247566006e-16,
  7.712611515305109e-18, -6.306401056190230e-20,  4.929559895258501e-22, -3.702336018501210e-24,  8.455058038656755e-03, -2.691045651393826e-04,  5.491395117310926e-06,
 -8.769844436109216e-08,  1.190180152544038e-09, -1.432421858781779e-11,  1.568998497049800e-13, -1.591332159111224e-15,  1.512860676631734e-17, -1.360444517813758e-19,
  1.165301942891012e-21, -9.559641801124569e-24,  5.544605010179885e-03, -2.128026076017870e-04,  5.038182079759839e-06, -9.178452184321299e-08,  1.404745551548427e-09,
 -1.890578333415535e-11,  2.300401027226688e-13, -2.577754161769309e-15,  2.695213856255460e-17, -2.655088111743771e-19,  2.482807603501725e-21, -2.216761297800933e-23,
  3.497128545664125e-03, -1.594348516067356e-04,  4.345870955099733e-06, -8.976256643545801e-08,  1.541254067445193e-09, -2.308910676499890e-11,  3.107756635430350e-13,
 -3.832565016026071e-15,  4.390985571397538e-17, -4.722162531448711e-19,  4.804730775892837e-21, -4.654061475551306e-23,  2.123567321677997e-03, -1.135167428877344e-04,
  3.536823610559971e-06, -8.235547102683522e-08,  1.578869924382655e-09, -2.621694101700317e-11,  3.888558295736101e-13, -5.258920122176142e-15,  6.580329591187663e-17,
 -7.701147486344007e-19,  8.500555760717058e-21, -8.907393071952076e-23,  1.242824060955793e-03, -7.702113124810011e-05,  2.724494310594666e-06, -7.114306463763861e-08,
  1.516117185704887e-09, -2.779548660238707e-11,  4.527019564138523e-13, -6.692222262314221e-15,  9.117533691642676e-17, -1.157885519188763e-18,  1.382718544753410e-20,
 -1.563292602299563e-22,  7.018916373287579e-04, -4.992931835362893e-05,  1.992552811447928e-06, -5.806001229189128e-08,  1.369676126024602e-09, -2.762356727444747e-11,
  4.924005997286762e-13, -7.932513038592855e-15,  1.173402600023380e-16, -1.612724737291548e-18,  2.078296928031907e-20, -2.529113213334411e-22,  3.830271843810092e-04,
 -3.100050567852682e-05,  1.387521440739142e-06, -4.490649098534691e-08,  1.168124960415731e-09, -2.582728680074989e-11,  5.023116642730836e-13, -8.793565640623255e-15,
  1.408579877115905e-16, -2.089965957558407e-18,  2.899623054575504e-20, -3.789469277359590e-22,  2.022684805084445e-04, -1.847966205302305e-05,  9.225506045666848e-07,
 -3.301853206299770e-08,  9.435536574786343e-10, -2.279654844917404e-11,  4.823310947657921e-13, -9.150995168516435e-15,  1.583358674250406e-16, -2.530241909542484e-18,
  3.770979336623576e-20, -5.281368753077218e-22,  1.035300859605853e-04, -1.060152919723214e-05,  5.872920283474634e-07, -2.314826449440027e-08,  7.241424899637054e-10,
 -1.905862110262820e-11,  4.374563217483278e-13, -8.971719096962830e-15,  1.672811966980656e-16, -2.872663540947595e-18,  4.589328156748662e-20, -6.874204950993229e-22,
  5.145281434547729e-05, -5.867290570662201e-06,  3.589364238079046e-07, -1.551919861769827e-08,  5.296743111896059e-10, -1.514084719335188e-11,  3.760066742513912e-13,
 -8.315458150571934e-15,  1.666963860814136e-16, -3.069647569098610e-18,  5.246212246610197e-20, -8.388083100955434e-22,  2.487638070929660e-05, -3.140276298840038e-06,
  2.111898459857888e-07, -9.978958652642852e-09,  3.703879631170374e-10, -1.146646624211541e-11,  3.072938371807733e-13, -7.310767224751096e-15,  1.572220965020037e-16,
 -3.098148952791444e-18,  5.653321712517324e-20, -9.630650822675811e-22,  1.172470389326132e-05, -1.629513509458690e-06,  1.199584844276206e-07, -6.172339794971436e-09,
  2.483731378528604e-10, -8.304396977346181e-12,  2.395645528125777e-13, -6.117148897864235e-15,  1.408249000101547e-16, -2.963610951466557e-18,  5.762901536761871e-20,
 -1.044099902673667e-21,  5.399169114216775e-06, -8.219543183828551e-07,  6.596738700807723e-08, -3.683542205032804e-09,  1.602141532260693e-10, -5.769917341077953e-12,
  1.787367935568891e-13, -4.887431670307401e-15,  1.201934975066580e-16, -2.696008607554611e-18,  5.576373264583028e-20, -1.072585088349124e-21,  2.435068173503384e-06,
 -4.041340209340149e-07,  3.522425772106767e-08, -2.127467608877656e-09,  9.972762263388051e-11, -3.858452903652761e-12,  1.280412600235932e-13, -3.741090172446795e-15,
  9.807851745440622e-17, -2.340301010895495e-18,  5.139451630470291e-20, -1.047651469537272e-21,  1.078401050067577e-06, -1.942380481190096e-07,  1.831831389688466e-08,
 -1.192908362377144e-09,  6.009620607079335e-11, -2.491502705482333e-12,  8.836299307832491e-14, -2.752673665008907e-15,  7.677536661314780e-17, -1.945112250263007e-18,
  4.527049389917379e-20, -9.762981866580741e-22,  4.702607153283079e-07, -9.153285659526914e-08,  9.307340833227413e-09, -6.514849973676323e-10,  3.517461703324579e-11,
 -1.558713452111332e-12,  5.894407914347496e-14, -1.953546238305757e-15,  5.785009902463596e-17, -1.553184574429239e-18,  3.824129629201363e-20, -8.709949368961214e-22,
  2.025207137935136e-07, -4.242472707491945e-08,  4.635327036138170e-09, -3.477017973040237e-10,  2.006485239609152e-11, -9.480143580992301e-13,  3.813766210173636e-14,
 -1.341849893750208e-15,  4.210374629571800e-17, -1.195657061579292e-18,  3.108613937530191e-20, -7.464683509799079e-22,  8.640402318958707e-08, -1.940397084004516e-08,
  2.270509594803718e-09, -1.819764279605141e-10,  1.119394878989831e-11, -5.625126006062389e-13,  2.401819644914332e-14, -8.952070706363947e-16,  2.970277418342873e-17,
 -8.904631222917886e-19,  2.440239543163039e-20, -6.167053101064180e-22,  3.664122066815122e-08, -8.787930599860941e-09,  1.097701586071301e-09, -9.373013201888015e-11,
  6.129601100629742e-12, -3.268006099664025e-13,  1.477619702981403e-14, -5.821587817371008e-16,  2.038379804695916e-17, -6.438646399216617e-19,  1.856365187039785e-20,
 -4.928760284862290e-22,  1.549842444101192e-08, -3.955166847416351e-09,  5.257121777723193e-10, -4.768680770174807e-11,  3.306641268993327e-12, -1.865822373903130e-13,
  8.912903121717981e-15, -3.703800449870297e-16,  1.365727506420234e-17, -4.536377535823016e-19,  1.373449772265995e-20, -3.824109336848278e-22,  6.562413472491575e-09,
 -1.775584688097326e-09,  2.503518297785409e-10, -2.405563285876655e-11,  1.763976941582409e-12, -1.050834324010220e-13,  5.291029793616051e-15, -2.313981020037603e-16,
  8.966795416415630e-18, -3.125699051604782e-19,  9.918610652008929e-21, -2.890733462390661e-22,  2.792111901534291e-09, -7.981488113845149e-10,  1.190072918480409e-10,
 -1.207866259277135e-11,  9.341773486801302e-13, -5.860636723087315e-14,  3.103004953702635e-15, -1.425012655930219e-16,  5.790649305568371e-18, -2.114031813934800e-19,
  7.017139983041500e-21, -2.136645345606909e-22,  1.198329250654935e-09, -3.606620655606761e-10,  5.669339894731556e-11, -6.060638077285467e-12,  4.930618951826080e-13,
 -3.249326872059734e-14,  1.804763566642994e-15, -8.683185191611297e-17,  3.692047439734885e-18, -1.408681053840023e-19,  4.881208756716194e-21, -1.549765642775340e-22,
  5.208406307719293e-10, -1.644846503311089e-10,  2.717468286010717e-11, -3.051022808209302e-12,  2.603912537107770e-13, -1.797959068284141e-14,  1.045039901656088e-15,
 -5.255293553878160e-17,  2.332860593279961e-18, -9.282314123623788e-20,  3.350668939808404e-21, -1.107033429085655e-22,  2.301652207903025e-10, -7.601494321879501e-11,
  1.315855563028125e-11, -1.547133848846341e-12,  1.381386207316917e-13, -9.967678817607415e-15,  6.047645595030608e-16, -3.171119860881670e-17,  1.466237878167932e-18,
 -6.070525069542728e-20,  2.277860598593434e-21, -7.815225678806203e-23,  1.038207156772622e-10, -3.573893588621050e-11,  6.462172945172553e-12, -7.933519603274478e-13,
  7.390055275707109e-14, -5.557662910214326e-15,  3.510832183791582e-16, -1.914814795522565e-17,  9.199935376090488e-19, -3.954231722741719e-20,  1.538940925427817e-21,
 -5.471220361876191e-23,  4.798312761088022e-11, -1.716007565021488e-11,  3.230969267997399e-12, -4.129514737045868e-13,  4.001663650773292e-14, -3.127981278414234e-15,
  2.051940537974459e-16, -1.161098425883738e-17,  5.782654567331800e-19, -2.574116040103729e-20,  1.036684249593204e-21, -3.810531895982847e-23,  2.280370257775757e-11,
 -8.444960181171784e-12,  1.650538825849025e-12, -2.189584728794024e-13,  2.200913184268781e-14, -1.783159603490239e-15,  1.211433785410132e-16, -7.093424008047975e-18,
  3.652703287167291e-19, -1.679856126097166e-20,  6.984147422953903e-22, -2.648031659875203e-23,  1.117959544920632e-11, -4.273476844724361e-12,  8.642688687847067e-13,
 -1.186379094982079e-13,  1.233323297390234e-14, -1.032719508148187e-15,  7.245932632287083e-17, -4.378576315193789e-18,  2.325180447832562e-19, -1.101967340273668e-20,
  4.718035375705517e-22, -1.840769838311299e-23,  5.668866623483083e-12, -2.229606326259308e-12,  4.650993577217066e-13, -6.585736748771277e-14,  7.059186034301367e-15,
 -6.091180015954172e-16,  4.401251711871266e-17, -2.737115147577745e-18,  1.494897959200309e-19, -7.281810845878553e-21,  3.202394064457419e-22, -1.282517244504872e-23,
  2.978450780609923e-12, -1.201501688744592e-12,  2.576842063571613e-13, -3.751905911032025e-14,  4.133852716540290e-15, -3.664671451903417e-16,  2.718941660082843e-17,
 -1.735227223856898e-18,  9.719943700616687e-20, -4.853253319083852e-21,  2.186587613221221e-22, -8.965846470835590e-24,  1.622250758603410e-12, -6.690990630533153e-13,
  1.470552860868583e-13, -2.194563052909199e-14,  2.477603387879032e-15, -2.249604607808490e-16,  1.708660822103869e-17, -1.115782919293137e-18,  6.391986677458187e-20,
 -3.262400194814294e-21,  1.501724701027724e-22, -6.287845987880530e-24,  9.145213159251600e-13, -3.844605099256193e-13,  8.630486858865672e-14, -1.315772915257886e-14,
  1.517211853972496e-15, -1.406522670907331e-16,  1.090297611199926e-17, -7.263269193196868e-19,  4.242914763347139e-20, -2.207271088094697e-21,  1.035178899679596e-22,
 -4.414002530705226e-24,  5.309090552927113e-13, -2.267880858590209e-13,  5.182630458305036e-14, -8.045032286619262e-15,  9.443880759122907e-16, -8.910080455231964e-17,
  7.026901109872339e-18, -4.760806450440461e-19,  2.827391391054239e-20, -1.494840205277843e-21,  7.122265215591959e-23, -3.084105691617214e-24,  3.137350320210780e-13,
 -1.357596721314920e-13,  3.147663798605899e-14, -4.958295764539743e-15,  5.905626993225358e-16, -5.652075783718229e-17,  4.520472479169469e-18, -3.105061756826615e-19,
  1.869043443525642e-20, -1.001258480313937e-21,  4.832402778184072e-23, -2.118994536056032e-24,  1.838994018106342e-13, -8.036532622764399e-14,  1.884103342757527e-14,
 -3.001468372858578e-15,  3.615035992190238e-16, -3.498041474704934e-17,  2.828020314022811e-18, -1.963163653579490e-19,  1.193980545731616e-20, -6.461296393246580e-22,
  3.149467224819915e-23, -1.394435595808539e-24,  1.000948219034533e-13, -4.404125464878019e-14,  1.040487833341842e-14, -1.670538914160500e-15,  2.027682719351014e-16,
 -1.977087299239484e-17,  1.610408519593114e-18, -1.126154064404798e-19,  6.898585652895663e-21, -3.759565181543552e-22,  1.845204003006287e-23, -8.224729299636354e-25,
  3.940118372502166e-14, -1.740207440069579e-14,  4.128929721991108e-15, -6.658014394054476e-16,  8.116370618800390e-17, -7.947552113561553e-18,  6.500632393156941e-19,
 -4.564502165345923e-20,  2.807339681850991e-21, -1.535942524869258e-22,  7.567415993207509e-24, -3.385710286806030e-25,  5.784312414946128e-02, -1.384225038745979e-04,
  3.432129183374857e-07, -8.764411439136168e-10,  2.288816929869847e-12, -6.072491293175180e-15,  1.627527980410714e-17, -4.388181577143663e-20,  1.186441356776181e-22,
 -3.210391857486195e-25,  8.680544597836877e-28, -2.343745587270055e-30,  5.523767879037261e-02, -1.667624805201097e-04,  5.939264381136654e-07, -2.201632913269639e-09,
  8.096559999282745e-12, -2.920047666484698e-14,  1.032397090046811e-16, -3.586156749949801e-19,  1.226734436614328e-21, -4.140663405305978e-24,  1.381221551759468e-26,
 -4.559018619799557e-29,  5.037744287996060e-02, -2.151807830726881e-04,  1.085605673648266e-06, -5.265054199347318e-09,  2.423902461720426e-11, -1.070292989205297e-13,
  4.571862592696885e-16, -1.900280433320024e-18,  7.717045006001312e-21, -3.071233423222094e-23,  1.200683615266288e-25, -4.619711613078848e-28,  4.388547204077441e-02,
 -2.699476498295262e-04,  1.783917097973192e-06, -1.067132680362853e-08,  5.927427671437599e-11, -3.116809872972222e-13,  1.569292982589486e-15, -7.622761492336069e-18,
  3.591536922321061e-20, -1.648079696469590e-22,  7.389007848552647e-25, -3.244880936977729e-27,  3.652501649591559e-02, -3.163021683495141e-04,  2.613323490850965e-06,
 -1.884004341918494e-08,  1.240786025704703e-10, -7.641775219484999e-13,  4.462666224310037e-15, -2.494371514383254e-17,  1.343450292746174e-19, -7.007667451467332e-22,
  3.554023062361765e-24, -1.757950051974685e-26,  2.905232921833934e-02, -3.427959617059033e-04,  3.455173785172049e-06, -2.961076532820183e-08,  2.282673204073073e-10,
 -1.626368993441530e-12,  1.088787428076785e-14, -6.925585817115371e-17,  4.219144984788704e-19, -2.476484329997480e-21,  1.406984905747313e-23, -7.765326089510663e-26,
  2.209348159870268e-02, -3.440267248169500e-04,  4.168397147536683e-06, -4.200985485709192e-08,  3.751748343634985e-10, -3.062721597877700e-12,  2.329443839564715e-14,
 -1.671964986963395e-16,  1.142861831546760e-18, -7.490361172221276e-21,  4.731825364321931e-23, -2.893061678959271e-25,  1.607122426988295e-02, -3.210801074442208e-04,
  4.626384825673992e-06, -5.432501786777279e-08,  5.572734680230752e-10, -5.171974058804342e-12,  4.436843463784636e-14, -3.568983289985318e-16,  2.719506561447344e-18,
 -1.977877570658714e-20,  1.381031699889865e-22, -9.300090271550520e-25,  1.118878658350345e-02, -2.799766237169307e-04,  4.753458898777704e-06, -6.450709086473090e-08,
  7.546140902777500e-10, -7.910147256571182e-12,  7.607498543759357e-14, -6.819204209447365e-16,  5.761184607331322e-18, -4.625727411381996e-20,  3.552304662671427e-22,
 -2.622237919665011e-24,  7.460266928910667e-03, -2.290797154930107e-04,  4.544440695448037e-06, -7.075705971710597e-08,  9.380072322887039e-10, -1.104282776331856e-11,
  1.184435610320570e-13, -1.177345302977865e-15,  1.097762223641131e-17, -9.687753983031816e-20,  8.147896720652265e-22, -6.566273820690071e-24,  4.767533718964588e-03,
 -1.765476202001067e-04,  4.060054197421934e-06, -7.205643961371423e-08,  1.076461718197978e-09, -1.416167838551270e-11,  1.686269546272386e-13, -1.850810031061665e-15,
  1.896880806198658e-17, -1.832882219996581e-19,  1.682107418043660e-21, -1.474699433533327e-23,  2.922649799227758e-03, -1.285898988009516e-04,  3.402661224085281e-06,
 -6.842532528069181e-08,  1.146124293880022e-09, -1.677392915417684e-11,  2.208227506558251e-13, -2.666021799653567e-15,  2.992658330942733e-17, -3.155386426156678e-19,
  3.149602189813123e-21, -2.994500024118367e-23,  1.720388125639758e-03, -8.878255160115175e-05,  2.684341655045068e-06, -6.082728526915633e-08,  1.137058269292818e-09,
 -1.843690123363716e-11,  2.673449896679117e-13, -3.538149860761916e-15,  4.335886464787945e-17, -4.973274394664998e-19,  5.383438208743633e-21, -5.535143805692807e-23,
  9.734555312262953e-04, -5.826636765686337e-05,  1.999731171807557e-06, -5.080038089115652e-08,  1.055231302758508e-09, -1.888454448160928e-11,  3.005893907653178e-13,
 -4.346961372970396e-15,  5.798409905602520e-17, -7.214851305316244e-19,  8.447000471807789e-21, -9.368381398878942e-23,  5.301180780179631e-04, -3.644138689442935e-05,
  1.410980560402168e-06, -3.999139318399035e-08,  9.193744724645007e-10, -1.809538096826289e-11,  3.151595929512520e-13, -4.965630654368519e-15,  7.189997908772295e-17,
 -9.680095121734382e-19,  1.222777069595101e-20, -1.459429869691998e-22,  2.782143083479146e-04, -2.177349889308214e-05,  9.456508257882706e-07, -2.976921188190045e-08,
  7.545543030929027e-10, -1.627935987227328e-11,  3.093101878339385e-13, -5.295111009703556e-15,  8.301347679392721e-17, -1.206385039256830e-18,  1.640417359972311e-20,
 -2.102407235772270e-22,  1.409225396750109e-04, -1.245845873748384e-05,  6.036856146604538e-07, -2.101796226692160e-08,  5.852640895886808e-10, -1.379757716569958e-11,
  2.851827193584271e-13, -5.290697193939991e-15,  8.958952961354884e-17, -1.402156654428168e-18,  2.048016527919679e-20, -2.812762299753351e-22,  6.900545030267254e-05,
 -6.842989624087686e-06,  3.680900442051666e-07, -1.411655918023286e-08,  4.303742017273594e-10, -1.105349413543834e-11,  2.478630745511631e-13, -4.970923548212613e-15,
  9.071012864743645e-17, -1.525675728469105e-18,  2.388820554290765e-20, -3.508952060101982e-22,  3.272380952572099e-05, -3.616830981869974e-06,  2.149572800059313e-07,
 -9.046129518594638e-09,  3.009689337500082e-10, -8.397144317799593e-12,  2.037573899349900e-13, -4.407028687108015e-15,  8.647381556625233e-17, -1.559780953863150e-18,
  2.612905722470118e-20, -4.097382925209134e-22,  1.505806507110616e-05, -1.844135808208001e-06,  1.205615832837277e-07, -5.547226361624797e-09,  2.007800358526664e-10,
 -6.068605295831221e-12,  1.589493445134998e-13, -3.699192743179932e-15,  7.788348579002266e-17, -1.503606632359415e-18,  2.689788803498220e-20, -4.494835714131423e-22,
  6.737864818215755e-06, -9.094094081054344e-07,  6.512571134156993e-08, -3.264876976318697e-09,  1.281718913307930e-10, -4.185639048426569e-12,  1.180516634359558e-13,
 -2.949674543903340e-15,  6.649954042869437e-17, -1.371448707119127e-18,  2.615145325161095e-20, -4.648904566653400e-22,  2.938499578686910e-06, -4.349058298478115e-07,
  3.398173687272793e-08, -1.849952483486761e-09,  7.854303959170851e-11, -2.764097419427584e-12,  8.374983917816670e-14, -2.241821803900512e-15,  5.401056670129338e-17,
 -1.187661229414264e-18,  2.409721928405749e-20, -4.549288606369163e-22,  1.252173836330712e-06, -2.022665600136424e-07,  1.717888734569714e-08, -1.012320420458205e-09,
  4.635149867940257e-11, -1.753436097092420e-12,  5.694325716493112e-14, -1.629496556498463e-15,  4.187029558819842e-17, -9.798658696468681e-19,  2.111721033575955e-20,
 -4.226765603513980e-22,  5.227703550481457e-07, -9.175580409542465e-08,  8.440335194051543e-09, -5.367155188141397e-10,  2.643001724501454e-11, -1.072087259470171e-12,
  3.723247104673394e-14, -1.136627703010587e-15,  3.108831706660143e-17, -7.728695904690275e-19,  1.766101716678663e-20, -3.741633968502455e-22,  2.144495719920075e-07,
 -4.072684923908825e-08,  4.043497521237147e-09, -2.766274965649724e-10,  1.461134821611148e-11, -6.339751404015266e-13,  2.349265181321504e-14, -7.635054826931825e-16,
  2.218572996095755e-17, -5.848382019355023e-19,  1.414589881078594e-20, -3.166867221082623e-22,  8.670789258063966e-08, -1.774587592913053e-08,  1.895262185445526e-09,
 -1.390864438325426e-10,  7.859137940678226e-12, -3.638817602270084e-13,  1.435565712694470e-14, -4.956647063388894e-16,  1.527173589545735e-17, -4.260949357138516e-19,
  1.089003868673952e-20, -2.571926440758040e-22,  3.467002205032663e-08, -7.617149398628282e-09,  8.722599075511961e-10, -6.846786890051576e-11,  4.127995400477286e-12,
 -2.034644556934369e-13,  8.526888603247279e-15, -3.121327418877270e-16,  1.017724955491600e-17, -2.999861733338741e-19,  8.087014946777828e-21, -2.011478086004655e-22,
  1.375768462282793e-08, -3.232614177237396e-09,  3.956462609708975e-10, -3.312371967926262e-11,  2.125342308797714e-12, -1.112510368979817e-13,  4.941722309904866e-15,
 -1.913830174932857e-16,  6.590650075470489e-18, -2.048511787702495e-19,  5.814518350557542e-21, -1.520529175994409e-22,  5.438191134663909e-09, -1.361594776246015e-09,
  1.775591290156932e-10, -1.581041078837126e-11,  1.076831976680686e-12, -5.971827267166535e-14,  2.805297082261792e-15, -1.146995891714297e-16,  4.163423033173391e-18,
 -1.361984666128672e-19,  4.062979069397643e-21, -1.115114446562373e-22,  2.149746846697290e-09, -5.714995144591220e-10,  7.916107665297847e-11, -7.475874656643334e-12,
  5.390841907176489e-13, -3.159729496765056e-14,  1.566143908171327e-15, -6.745887292078416e-17,  2.575754728046492e-18, -8.850976551025500e-20,  2.769810183925913e-21,
 -7.964134852553442e-23,  8.533474228530198e-10, -2.400314879760184e-10,  3.520734592939606e-11, -3.516536111538582e-12,  2.677727069485348e-13, -1.654742777710266e-14,
  8.634128244551547e-16, -3.909286507182016e-17,  1.566864547811272e-18, -5.644354251173530e-20,  1.849377673513852e-21, -5.560631494482733e-23,  3.415994184813990e-10,
 -1.013151681353516e-10,  1.568848325497320e-11, -1.652605913094459e-12,  1.325351827132165e-13, -8.613617623912686e-15,  4.720141902831479e-16, -2.241452519474944e-17,
  9.410199205915852e-19, -3.546359008706350e-20,  1.214187363361685e-21, -3.810333598605732e-23,  1.385024690138892e-10, -4.316671298268492e-11,  7.035049816698682e-12,
 -7.793379769869103e-13,  6.565003055581696e-14, -4.475866737158851e-15,  2.569676493070393e-16, -1.276865768965402e-17,  5.602579018168320e-19, -2.204185708827212e-20,
  7.869580594343109e-22, -2.572443891505594e-23,  5.713103332938891e-11, -1.864794650618959e-11,  3.188779319008488e-12, -3.704258512883442e-13,  3.268680370704611e-14,
 -2.331709056776636e-15,  1.399037377365974e-16, -7.256958558589304e-18,  3.320297466839674e-19, -1.360679208090094e-20,  5.055157476491748e-22, -1.717712906976856e-23,
  2.408166899659548e-11, -8.204608506828514e-12,  1.467503611137349e-12, -1.782386830908792e-13,  1.642950712898448e-14, -1.223006442733246e-15,  7.649398221848314e-17,
 -4.131840897828161e-18,  1.966602624304796e-19, -8.375683545023646e-21,  3.230824983142263e-22, -1.138725315550629e-23,  1.041815740083470e-11, -3.692572149959491e-12,
  6.886782383448777e-13, -8.719454999526809e-14,  8.371895266453686e-15, -6.485456543593084e-16,  4.217331680175239e-17, -2.366143188232736e-18,  1.168686720594701e-19,
 -5.160532741080583e-21,  2.062062215121794e-22, -7.521878003214121e-24,  4.645052889873889e-12, -1.707097260038257e-12,  3.309273582020175e-13, -4.354453107785152e-14,
  4.342190029268365e-15, -3.490707860670054e-16,  2.353571179486326e-17, -1.367964338028784e-18,  6.993740971933711e-20, -3.193936033514712e-21,  1.318883786871887e-22,
 -4.967510402403263e-24,  2.142605086722201e-12, -8.137846350380796e-13,  1.634453799421848e-13, -2.228182142216633e-14,  2.300710153851289e-15, -1.913784696918892e-16,
  1.334143707574173e-17, -8.011450503638240e-19,  4.228399214599089e-20, -1.992042271755478e-21,  8.479473766683777e-23, -3.289696875825891e-24,  1.025799635268517e-12,
 -4.013349130232956e-13,  8.324151781905035e-14, -1.171963820108276e-14,  1.249170636816262e-15, -1.071963766180318e-16,  7.704147061180458e-18, -4.766175089717417e-19,
  2.589854036269218e-20, -1.255298302892474e-21,  5.493910744005198e-23, -2.189918901507344e-24,  5.109756070614793e-13, -2.052606875942836e-13,  4.381962474092243e-14,
 -6.350786061398257e-15,  6.965565038867565e-16, -6.147582380796603e-17,  4.541329052613881e-18, -2.886023773700867e-19,  1.609956606979750e-20, -8.006372590662366e-22,
  3.593077414467107e-23, -1.467692941579249e-24,  2.651149049623736e-13, -1.089913126818191e-13,  2.386840764848558e-14, -3.549154934512224e-15,  3.992686232927945e-16,
 -3.612665817123080e-17,  2.734642552820082e-18, -1.779849761686795e-19,  1.016328641510763e-20, -5.170891071138333e-22,  2.372918041287895e-23, -9.905935256706164e-25,
  1.431326818604018e-13, -6.002694016533462e-14,  1.343894068422607e-14, -2.043327897442282e-15,  2.349882576387965e-16, -2.172762826092635e-17,  1.679970973922595e-18,
 -1.116365231639652e-19,  6.505523742241589e-21, -3.376318794951670e-22,  1.579786842430549e-23, -6.721071272680304e-25,  8.004946736211334e-14, -3.413653084921140e-14,
  7.786193806666701e-15, -1.206344492914475e-15,  1.413424537575469e-16, -1.331060693510412e-17,  1.047832160192633e-18, -7.086606016357301e-20,  4.201379417199418e-21,
 -2.217517687031912e-22,  1.054810949824135e-23, -4.560256472477841e-25,  4.586453253983047e-14, -1.982445337112838e-14,  4.590679068428050e-15, -7.222263908168341e-16,
  8.591424220452171e-17, -8.212493776997556e-18,  6.560394467778087e-19, -4.500979585249018e-20,  2.706192023862506e-21, -1.448103090648610e-22,  6.981390307431276e-24,
 -3.058064898605132e-25,  2.624453337409325e-14, -1.146149852518394e-14,  2.685069849282612e-15, -4.274237386319783e-16,  5.144159896133286e-17, -4.974037630727796e-18,
  4.018418100638389e-19, -2.787559398899664e-20,  1.694207269083977e-21, -9.162146356966569e-23,  4.463026271894122e-24, -1.974753117495555e-25,  1.404535997320934e-14,
 -6.177788644008653e-15,  1.458958741352365e-15, -2.341491068060859e-16,  2.840971410321428e-17, -2.769019244809777e-18,  2.254614296472334e-19, -1.576061208699994e-20,
  9.651114786278946e-22, -5.257754051651662e-23,  2.579617502361664e-24, -1.149434596968756e-25,  5.476671771279631e-15, -2.418452870351029e-15,  5.737112433410853e-16,
 -9.249495364783420e-17,  1.127334099169739e-17, -1.103677723542465e-18,  9.025754859098683e-20, -6.336382833503928e-21,  3.896405115942548e-22, -2.131406858141035e-23,
  1.049934883512396e-24, -4.696661309189459e-26,  5.729485979803697e-02, -1.357182562389467e-04,  3.329114108151512e-07, -8.407708588485654e-10,  2.171175819962919e-12,
 -5.696210295136529e-15,  1.509805070632562e-17, -4.026361712013962e-20,  1.076876606701149e-22, -2.882933600790159e-25,  7.712968092602969e-28, -2.060816596636298e-30,
  5.457996741884335e-02, -1.621145886574268e-04,  5.682652675443229e-07, -2.076628740908988e-09,  7.536537010107385e-12, -2.683891666143472e-14,  9.372637596464884e-17,
 -3.216423660806423e-19,  1.087150440947485e-21, -3.626275105467532e-24,  1.195514594393336e-26, -3.900400601685921e-29,  4.953369839239977e-02, -2.067422261694475e-04,
  1.024683213187366e-06, -4.893775923812609e-09,  2.220399350350127e-11, -9.666840752199611e-14,  4.072758134981264e-16, -1.670136696149847e-18,  6.693168138499847e-21,
 -2.629255239976757e-23,  1.014772023834031e-25, -3.855192566385561e-28,  4.283343524721959e-02, -2.561728749401296e-04,  1.661352233328252e-06, -9.770831276555228e-09,
  5.340064750505886e-11, -2.764546185341220e-13,  1.371092913316651e-15, -6.562962632395846e-18,  3.048160316166215e-20, -1.379203569817493e-22,  6.098669666595680e-25,
 -2.642043693612690e-27,  3.530023531607210e-02, -2.962672780135046e-04,  2.398668380376131e-06, -1.697146387821487e-08,  1.098119348574263e-10, -6.649911947721418e-13,
  3.820823414726260e-15, -2.102232283004523e-17,  1.115003178277629e-19, -5.729457653689309e-22,  2.863359803260344e-24, -1.396022516642754e-26,  2.773426224165392e-02,
 -3.165161824533111e-04,  3.120729113201973e-06, -2.620514233839889e-08,  1.982035068752923e-10, -1.386882989803661e-12,  9.125062575944446e-15, -5.707877610362821e-17,
  3.421187665370153e-19, -1.976511111929478e-21,  1.105648890178838e-23, -6.010162973824461e-26,  2.078101447357846e-02, -3.125984387123105e-04,  3.698368495955687e-06,
 -3.646823744330126e-08,  3.191522121076636e-10, -2.555937201485757e-12,  1.908686770644506e-14, -1.345975901368334e-16,  9.044182054245002e-19, -5.829688030773989e-21,
  3.623368671063919e-23, -2.180400931730016e-25,  1.485700137808922e-02, -2.865325530024326e-04,  4.024747898175467e-06, -4.618153060854478e-08,  4.637211286966349e-10,
 -4.217837425253922e-12,  3.549373922744221e-14, -2.802757302721261e-16,  2.097773294204769e-18, -1.499406993600302e-20,  1.029365472634533e-22, -6.818208147548185e-25,
  1.014030758629500e-02, -2.448514475459102e-04,  4.046900527607158e-06, -5.360582306852971e-08,  6.132240215500503e-10, -6.294086389606652e-12,  5.933019834058988e-14,
 -5.216751403526164e-16,  4.326119631998557e-18, -3.411394042132754e-20,  2.574183598572043e-22, -1.867955774090918e-24,  6.611620845950318e-03, -1.958812253554695e-04,
  3.778587720685944e-06, -5.737187937388056e-08,  7.430991636337197e-10, -8.559086122704721e-12,  8.991333866613777e-14, -8.760974845831787e-16,  8.013112731553630e-18,
 -6.941025762551894e-20,  5.733006390181080e-22, -4.539363304542719e-24,  4.121214495798695e-03, -1.472532780011453e-04,  3.290037485269435e-06, -5.689549055151066e-08,
  8.298311942652417e-10, -1.067357465471509e-11,  1.243960604199711e-13, -1.337567796733228e-15,  1.343985186714348e-17, -1.273997758419647e-19,  1.147653544487542e-21,
 -9.880972444725043e-24,  2.457941167536912e-03, -1.043650229176404e-04,  2.681382276128867e-06, -5.250677236371651e-08,  8.581143334368405e-10, -1.227143850999467e-11,
  1.580330403540999e-13, -1.868170218544816e-15,  2.054940449021112e-17, -2.124597858931768e-19,  2.080740097571065e-21, -1.942014042231683e-23,  1.403986856889772e-03,
 -6.994416381228048e-05,  2.052447057482066e-06, -4.526669987866638e-08,  8.252036626458609e-10, -1.306782141700497e-11,  1.852808422757446e-13, -2.399907257748227e-15,
  2.880765983734463e-17, -3.238829696215156e-19,  3.438645680938790e-21, -3.469578790450770e-23,  7.688952690339016e-04, -4.444626270124187e-05,  1.480130076630505e-06,
 -3.658413540575987e-08,  7.408126133264667e-10, -1.294316090164604e-11,  2.013687005517126e-13, -2.849131412268246e-15,  3.721382766977626e-17, -4.537366387186468e-19,
  5.208766412831569e-21, -5.667603428446158e-23,  4.042087484421290e-04, -2.684811141037557e-05,  1.008613330895923e-06, -2.780867129011149e-08,  6.230614911631027e-10,
 -1.196912425075934e-11,  2.037008562453522e-13, -3.139293124512811e-15,  4.449866125951738e-17, -5.869172897373266e-19,  7.267832956689663e-21, -8.508532336363155e-23,
  2.042484108702014e-04, -1.545432983070730e-05,  6.512938710250719e-07, -1.994318183045045e-08,  4.925884602959302e-10, -1.037090864868255e-11,  1.925159645362000e-13,
 -3.223057884299019e-15,  4.945726454402854e-17, -7.040085093434928e-19,  9.383015945281018e-21, -1.179395678102166e-22,  9.935016499340142e-05, -8.497428731740426e-06,
  3.996288398142807e-07, -1.353455623456729e-08,  3.672522331736580e-10, -8.448446074432087e-12,  1.705916764587509e-13, -3.094798655154260e-15,  5.128958272670245e-17,
 -7.862202438366415e-19,  1.125498616818438e-20, -1.515898747093987e-22,  4.659557132808572e-05, -4.473716796785135e-06,  2.336425290143041e-07, -8.717930184107940e-09,
  2.590190417917870e-10, -6.491837943653053e-12,  1.422165853268103e-13, -2.789098680475162e-15,  4.981218368151434e-17, -8.205735747333925e-19,  1.259223540912391e-20,
 -1.813945785104023e-22,  2.110898567741014e-05, -2.260748390669775e-06,  1.305128869552830e-07, -5.345399309787580e-09,  1.733522339306765e-10, -4.720499308293018e-12,
  1.119158429918746e-13, -2.367310362159262e-15,  4.546575523654681e-17, -8.032919549322334e-19,  1.318957282338271e-20, -2.028497061139745e-22,  9.255361267000915e-06,
 -1.099331780595850e-06,  6.985058273016972e-08, -3.129176785822159e-09,  1.104334911759583e-10, -3.258573293719100e-12,  8.340886378128079e-14, -1.898774552010364e-15,
  3.913602836145469e-17, -7.401934166934420e-19,  1.298054298803579e-20, -2.127719700436250e-22,  3.936046528659365e-06, -5.157407710823176e-07,  3.592035951112807e-08,
 -1.754164791614986e-09,  6.717421802581967e-11, -2.142311230214177e-12,  5.906655127559745e-14, -1.444033641237087e-15,  3.187852452930002e-17, -6.442338702003305e-19,
  1.204546547321797e-20, -2.100881129963075e-22,  1.627388658004527e-06, -2.340711107455360e-07,  1.780105254503498e-08, -9.445856508593809e-10,  3.913973340405536e-11,
 -1.345763849789581e-12,  3.987697661258054e-14, -1.044797757035974e-15,  2.465667134640794e-17, -5.314625685837667e-19,  1.057656282372168e-20, -1.959628064494899e-22,
  6.558439759549459e-07, -1.030692798445822e-07,  8.527409749729735e-09, -4.901477012192729e-10,  2.191626569841300e-11, -8.104626435694452e-13,  2.575261999689259e-14,
 -7.216432347421128e-16,  1.817123003461486e-17, -4.170078878988954e-19,  8.818181598563447e-21, -1.732865758033515e-22,  2.583432178107171e-07, -4.416716238401467e-08,
  3.961393034579505e-09, -2.459032919385832e-10,  1.183356041658848e-11, -4.695291194632634e-13,  1.596400762346282e-14, -4.774880376167398e-16,  1.280475198148305e-17,
 -3.123122708457325e-19,  7.005901775085443e-21, -1.457866365050635e-22,  9.976751533500628e-08, -1.847830051217750e-08,  1.790605131251228e-09, -1.196883328392099e-10,
  6.182816123305039e-12, -2.625998753726708e-13,  9.533024103015379e-15, -3.037423640066550e-16,  8.658690568439622e-18, -2.240611685343802e-19,  5.323048113899892e-21,
 -1.171098182572150e-22,  3.789549989693697e-08, -7.573664338414697e-09,  7.903330104530779e-10, -5.672258198103851e-11,  3.137352311404869e-12, -1.423058601674240e-13,
  5.504099574866330e-15, -1.864451444777088e-16,  5.639316043946674e-18, -1.545515495665822e-19,  3.882048545603998e-21, -9.015301726439192e-23,  1.420719256050000e-08,
 -3.052188071859394e-09,  3.418983821836524e-10, -2.627345723289283e-11,  1.552023058161587e-12, -7.500731913764821e-14,  3.084357488853717e-15, -1.108541896389710e-16,
  3.550917507316529e-18, -1.028842512553681e-19,  2.727703035936253e-21, -6.675764831602018e-23,  5.276825123274796e-09, -1.214090156713896e-09,  1.455336223929417e-10,
 -1.194135077798819e-11,  7.514750088747050e-13, -3.860644689254485e-14,  1.684160404334610e-15, -6.409404030396531e-17,  2.170168481357899e-18, -6.635599729265510e-20,
  1.853715061654769e-21, -4.773274825310968e-23,  1.949430269338397e-09, -4.786219771742310e-10,  6.120653690208830e-11, -5.347637525845931e-12,  3.576099089466203e-13,
 -1.948419308447761e-14,  8.997532225507349e-16, -3.618391561541973e-17,  1.292521920029300e-18, -4.162974468721348e-20,  1.223257732780119e-21, -3.308476773341077e-23,
  7.193528204321292e-10, -1.878005552118495e-10,  2.554314116128928e-11, -2.369837493211311e-12,  1.679783018306100e-13, -9.683451816629779e-15,  4.723112941108503e-16,
 -2.002958301137295e-17,  7.533217523529425e-19, -2.550970021442164e-20,  7.870208364215609e-22, -2.231917437924214e-23,  2.663175785288144e-10, -7.367365574769605e-11,
  1.062545543161051e-11, -1.043935653142611e-12,  7.823202713619052e-14, -4.760208215282813e-15,  2.446815364895204e-16, -1.091861105052920e-17,  4.314971670938773e-19,
 -1.533262791780726e-20,  4.957394629547423e-22, -1.471451908987905e-23,  9.937828144294967e-11, -2.903131287377380e-11,  4.426343166270709e-12, -4.592453633024037e-13,
  3.629145338841443e-14, -2.325139699208970e-15,  1.256599539354759e-16, -5.887489551499521e-18,  2.439664124699313e-19, -9.078370538738519e-21,  3.070154066756779e-22,
 -9.520112852733322e-24,  3.755761588045127e-11, -1.154659983464407e-11,  1.855471465858946e-12, -2.027231498282233e-13,  1.684854250355243e-14, -1.133765684003195e-15,
  6.427028811218057e-17, -3.154452026350952e-18,  1.367628180032964e-19, -5.318352302184793e-21,  1.877457393449267e-22, -6.070100835025646e-24,  1.444610754845997e-11,
 -4.658163204262478e-12,  7.865085977284246e-13, -9.023122197137949e-14,  7.865735366960574e-15, -5.544967962397146e-16,  3.288958115766953e-17, -1.687060598146844e-18,
  7.635499845533001e-20, -3.096224536711706e-21,  1.138554364571283e-22, -3.830366088237499e-24,  5.683337640601210e-12, -1.915612573011623e-12,  3.387937542829631e-13,
 -4.069325621707632e-14,  3.710407020995565e-15, -2.732925877238393e-16,  1.691825831843259e-17, -9.047446164141225e-19,  4.264556646500568e-20, -1.799155614000429e-21,
  6.876458979640341e-23, -2.402082105263207e-24,  2.298230548012334e-12, -8.070016590123934e-13,  1.490290595217418e-13, -1.868493028057696e-14,  1.776910287475946e-15,
 -1.363728726364042e-16,  8.787793307242458e-18, -4.887034337195236e-19,  2.393148034047530e-20, -1.047935109569204e-21,  4.153437321770721e-23, -1.503138635822006e-24,
  9.598263198191496e-13, -3.499360201211029e-13,  6.726052315231885e-14, -8.775685988662206e-15,  8.678611410531252e-16, -6.920495944023992e-17,  4.629405208883613e-18,
 -2.670165834653283e-19,  1.354965014760580e-20, -6.143087066930197e-22,  2.518795219031828e-23, -9.421896689706600e-25,  4.158507837645066e-13, -1.568876664190949e-13,
  3.128352686669976e-14, -4.234168828639235e-15,  4.341223977650827e-16, -3.586314227580419e-17,  2.483355561787381e-18, -1.481510609640627e-19,  7.769658283571244e-21,
 -3.637724999694568e-22,  1.539134012448330e-23, -5.936273396201357e-25,  1.876447539647227e-13, -7.301035670004118e-14,  1.505287447290108e-14, -2.106675382931753e-15,
  2.232307705852503e-16, -1.904666609545984e-17,  1.361230333729572e-18, -8.375437315506184e-20,  4.526939896825439e-21, -2.182872791494192e-22,  9.505469530299744e-24,
 -3.770441484030616e-25,  8.845728386516772e-14, -3.537702809499398e-14,  7.516038235877977e-15, -1.084049232924251e-15,  1.183348424548428e-16, -1.039537872099708e-17,
  7.644467161660307e-19, -4.836619259807049e-20,  2.686476143409306e-21, -1.330391787260244e-22,  5.946099655894307e-24, -2.419204302037119e-25,  4.364178887542784e-14,
 -1.788029559374038e-14,  3.900961488360051e-15, -5.778724309844969e-16,  6.476721413802233e-17, -5.838948711847794e-18,  4.404142594140650e-19, -2.856512151930473e-20,
  1.625611183757399e-21, -8.243562182033877e-23,  3.770818823796416e-24, -1.569245025030629e-25,  2.252697859590961e-14, -9.423371586927850e-15,  2.103790218793585e-15,
 -3.189665416017103e-16,  3.657965424050979e-17, -3.373001383370230e-18,  2.601020931152881e-19, -1.723908399310968e-20,  1.002037364492761e-21, -5.187599408923910e-23,
  2.421418265080969e-24, -1.027749443108931e-25,  1.211845756296591e-14, -5.158591817215773e-15,  1.174278930933124e-15, -1.815701755501954e-16,  2.123164914316962e-17,
 -1.995554022696969e-18,  1.567944075597395e-19, -1.058448490980997e-20,  6.263764169335057e-22, -3.300212368303712e-23,  1.567110467951358e-24, -6.763709099020412e-26,
  6.722990106745531e-15, -2.902542083026123e-15,  6.712513001523517e-16, -1.054645740767326e-16,  1.252938793601315e-17, -1.196138759095415e-18,  9.543114393159934e-20,
 -6.539330007161592e-21,  3.927021914526078e-22, -2.098916021559041e-23,  1.010742496618620e-24, -4.422436563359289e-26,  3.751474451697603e-15, -1.637210696200084e-15,
  3.832491802068389e-16, -6.095965757276766e-17,  7.330942396057090e-18, -7.083070503960056e-19,  5.717963543804696e-20, -3.963611802123442e-21,  2.407250545345098e-22,
 -1.300908526618399e-23,  6.332579830785381e-25, -2.800098836023595e-26,  1.972525616180726e-15, -8.672979696609839e-16,  2.047404044114391e-16, -3.284547337361881e-17,
  3.983579749605243e-18, -3.881134829750189e-19,  3.158887066286922e-20, -2.207329663189502e-21,  1.351161107696163e-22, -7.358151366398597e-24,  3.608824732125170e-25,
 -1.607460840442411e-26,  7.615548628070375e-16, -3.362396607033556e-16,  7.974827558905324e-17, -1.285466461749506e-17,  1.566427054525139e-18, -1.533258313864597e-19,
  1.253640663333936e-20, -8.799307934990224e-22,  5.409908529280815e-23, -2.958775711005037e-24,  1.457233284415982e-25, -6.517460106500886e-27,  5.675725027954411e-02,
 -1.330947399260311e-04,  3.230268966323199e-07, -8.069241279429231e-10,  2.060785800880148e-12, -5.347005636169782e-15,  1.401739470254699e-17, -3.697788736817042e-20,
  9.784326774673215e-23, -2.591800205400096e-25,  6.861639595897375e-28, -1.814449662209489e-30,  5.394044632593711e-02, -1.576661347745927e-04,  5.440519042219889e-07,
 -1.960219149041550e-09,  7.021543338776033e-12, -2.469374174318514e-14,  8.518844679056439e-17, -2.888532459668678e-19,  9.648143209524909e-22, -3.180684450348307e-24,
  1.036497390574551e-26, -3.342880827689371e-29,  4.872276082902504e-02, -1.987737657848043e-04,  9.680273622427294e-07, -4.553463360501916e-09,  2.036470514827088e-11,
 -8.743159881848785e-14,  3.633736290004730e-16, -1.470348419934291e-18,  5.815790451017794e-21, -2.255327563939502e-23,  8.594576658030922e-26, -3.224417288351794e-28,
  4.183460276611233e-02, -2.433369408961150e-04,  1.549051885551215e-06, -8.958926303818802e-09,  4.818628340163277e-11, -2.456477474964767e-13,  1.200271588128235e-15,
 -5.662503514879734e-18,  2.592894169146404e-20, -1.157002785648026e-22,  5.046663997904419e-25, -2.157070022425860e-27,  3.415229594158842e-02, -2.778636717719319e-04,
  2.205129474665157e-06, -1.531608227322026e-08,  9.738343558188855e-11, -5.799700450419567e-13,  3.279200642582556e-15, -1.776337176059906e-17,  9.279600910316732e-20,
 -4.698109211695030e-22,  2.314033918024389e-24, -1.112200058176643e-26,  2.651621101186489e-02, -2.927563183908953e-04,  2.824416710358715e-06, -2.324441037124963e-08,
  1.725325326677063e-10, -1.185885673562663e-12,  7.670009035054152e-15, -4.718900532575159e-17,  2.783265231207975e-19, -1.582932373701481e-21,  8.719989881707711e-24,
 -4.669312199982178e-26,  1.958714065718316e-02, -2.846788861918447e-04,  3.289778598632783e-06, -3.174708764637003e-08,  2.723251628460550e-10, -2.139991154070706e-12,
  1.569365494821415e-14, -1.087521245185454e-16,  7.184800968174365e-19, -4.555478166039554e-21,  2.786222317378948e-23, -1.650460668182817e-25,  1.377192731576323e-02,
 -2.564312742632064e-04,  3.512445936679358e-06, -3.939310057331334e-08,  3.872843979160753e-10, -3.453046519981543e-12,  2.851001638027990e-14, -2.210440794839554e-16,
  1.625398327850395e-18, -1.141956146771618e-20,  7.709375816506882e-23, -5.023520345129293e-25,  9.221801631087196e-03, -2.148916138261946e-04,  3.458583747920107e-06,
 -4.472862473995633e-08,  5.004746597797606e-10, -5.030868730400773e-12,  4.649006013214836e-14, -4.010520129683181e-16,  3.265120175365703e-18, -2.529146420038283e-20,
  1.875565712576261e-22, -1.338119564784410e-24,  5.884462194369004e-03, -1.682165382813414e-04,  3.156171889345134e-06, -4.674234677721109e-08,  5.916501513583228e-10,
 -6.668719121479082e-12,  6.862626282266975e-14, -6.555955576416073e-16,  5.883108983679673e-18, -5.002777401899762e-20,  4.058612022533035e-22, -3.157893634217522e-24,
  3.580816446100245e-03, -1.234534773778734e-04,  2.680403482493984e-06, -4.517566154884214e-08,  6.434154219300221e-10, -8.092834394827481e-12,  9.233428876173481e-14,
 -9.728009201187807e-16,  9.584669775656895e-18, -8.914599921659052e-20,  7.883787292624496e-22, -6.666963363041573e-24,  2.079699186507520e-03, -8.521827957967299e-05,
  2.126202802542606e-06, -4.055083140447601e-08,  6.467324858641303e-10, -9.038575881904320e-12,  1.138860936218989e-13, -1.318438053440448e-15,  1.421348969629389e-17,
 -1.441206774810536e-19,  1.385060193417755e-21, -1.269199292999563e-23,  1.153901623204780e-03, -5.549133320964753e-05,  1.580565876458003e-06, -3.393378869993627e-08,
  6.033675189681615e-10, -9.333175133909834e-12,  1.294096783337091e-13, -1.640797649072604e-15,  1.929490038701555e-17, -2.126659807495624e-19,  2.214811267328964e-21,
 -2.193316218050120e-23,  6.122724348918781e-04, -3.417785262534502e-05,  1.104477879151589e-06, -2.656433737636509e-08,  5.244523295663538e-10, -8.946822689925441e-12,
  1.360698949052138e-13, -1.883851640401009e-15,  2.409690737928684e-17, -2.879346807613770e-19,  3.241388497457016e-21, -3.460559758224040e-23,  3.110579325886890e-04,
 -1.996115300498147e-05,  7.276087900658659e-07, -1.951634423787779e-08,  4.262028006335001e-10, -7.991883850983854e-12,  1.329208887875800e-13, -2.003885462959814e-15,
  2.780950269714698e-17, -3.593730464020195e-19,  4.362904057282947e-21, -5.010479388248552e-23,  1.515063655393490e-04, -1.108154055137630e-05,  4.531558694672645e-07,
 -1.349781338805236e-08,  3.248977874324699e-10, -6.675694867321712e-12,  1.210801128780433e-13, -1.982570500129794e-15,  2.977918777053701e-17, -4.152448542388124e-19,
  5.424967296836873e-21, -6.688054360496657e-23,  7.085163647362378e-05, -5.861694288142275e-06,  2.675418407638889e-07, -8.814252922407762e-09,  2.330641848257917e-10,
 -5.231976710201735e-12,  1.032112552484877e-13, -1.831081687695091e-15,  2.970152709673944e-17, -4.459555026562912e-19,  6.257165807190432e-21, -8.265124756299857e-23,
  3.186424693779974e-05, -2.961366549403323e-06,  1.501438561863998e-07, -5.450499065502655e-09,  1.578151645391739e-10, -3.859827496720267e-12,  8.260868877390603e-14,
 -1.584292124311548e-15,  2.769293358274198e-17, -4.468236515490408e-19,  6.720405733682393e-21, -9.494112216422576e-23,  1.380612629897814e-05, -1.432400626058539e-06,
  8.031197382739705e-08, -3.200993777428145e-09,  1.011812528069637e-10, -2.689001958688508e-12,  6.228824440385765e-14, -1.288527929286115e-15,  2.422193384063722e-17,
 -4.191839163180599e-19,  6.746162152607696e-21, -1.017558299964268e-22,  5.774494166652071e-06, -6.650164865384548e-07,  4.105985180073507e-08, -1.790661224921109e-09,
  6.161234659789936e-11, -1.774679057016784e-12,  4.439078770718261e-14, -9.884276872986434e-16,  1.994316805044370e-17, -3.695093097500079e-19,  6.352159552522669e-21,
 -1.021302674502594e-22,  2.336550534917192e-06, -2.971230093567234e-07,  2.012156967120334e-08, -9.570426534147373e-10,  3.574451348303986e-11, -1.113141076287617e-12,
  2.999957626925284e-14, -7.175412931611400e-16,  1.550994922521049e-17, -3.071207894470839e-19,  5.630205594677716e-21, -9.633807206401812e-23,  9.168375750052440e-07,
 -1.281080911673614e-07,  9.479917554718876e-09, -4.902156968890394e-10,  1.982052001222546e-11, -6.657393634003928e-13,  1.928950674470966e-14, -4.946189645389424e-16,
  1.143270012019858e-17, -2.415272911637071e-19,  4.714038479301675e-21, -8.571055582500427e-23,  3.497841789683539e-07, -5.345945216685656e-08,  4.307202470305325e-09,
 -2.414243306105882e-10,  1.053947986489241e-11, -3.809272339463259e-13,  1.184107513449422e-14, -3.248728702475745e-16,  8.015318371890051e-18, -1.803518133104664e-19,
  3.741656379761882e-21, -7.217891924125705e-23,  1.301177543206285e-07, -2.165867984586886e-08,  1.893446760107950e-09, -1.147028372349600e-10,  5.392763814029270e-12,
 -2.092535859149914e-13,  6.963842488750296e-15, -2.040373818582865e-16,  5.363766251009185e-18, -1.283284525637684e-19,  2.825489241745503e-21, -5.774158244085542e-23,
  4.734224577822757e-08, -8.547522119482289e-09,  8.081195928449870e-10, -5.275929994372404e-11,  2.664686349090895e-12, -1.107554977461160e-13,  3.937965213077000e-15,
 -1.229823082218499e-16,  3.438606229425987e-18, -8.732969903034580e-20,  2.037378961467523e-21, -4.404117989956315e-23,  1.690435066302125e-08, -3.297520943962290e-09,
  3.360836332764132e-10, -2.358128559851182e-11,  1.276294509012868e-12, -5.669636350422358e-14,  2.149312518497917e-15, -7.140887362386763e-17,  2.119809975989767e-18,
 -5.705224907342653e-20,  1.408087270138471e-21, -3.214753381534152e-23,  5.945183194158130e-09, -1.248290728370609e-09,  1.367245495284723e-10, -1.028200608937291e-11,
  5.948860713645140e-13, -2.818080951770529e-14,  1.136687679338186e-15, -4.009985416675661e-17,  1.261568928089882e-18, -3.592071454308177e-20,  9.363701060600091e-22,
 -2.254373565270769e-23,  2.067521661537036e-09, -4.655591341976373e-10,  5.463241178517713e-11, -4.391576456438513e-12,  2.709496778489256e-13, -1.365687065984907e-14,
  5.848988995542870e-16, -2.186698168835548e-17,  7.277584230942890e-19, -2.188407442757052e-20,  6.015358454656595e-22, -1.524807594716592e-23,  7.139638729854009e-10,
 -1.718011539164955e-10,  2.153469555643320e-11, -1.845359394325023e-12,  1.211151862211126e-13, -6.480720749758569e-15,  2.940906553372739e-16, -1.162888674556124e-17,
  4.086549980006308e-19, -1.295494671945329e-20,  3.748573605288997e-22, -9.988277760934498e-24,  2.459167026217404e-10, -6.301471973240345e-11,  8.411908893133724e-12,
 -7.663752246872122e-13,  5.337491400195317e-14, -3.025028497621455e-15,  1.451391640140783e-16, -6.057772066962544e-18,  2.243470104201306e-19, -7.484195552902941e-21,
  2.275702555288898e-22, -6.363310933208979e-24,  8.488800893062095e-11, -2.308360704699897e-11,  3.271911703126257e-12, -3.160662295486076e-13,  2.330054204502017e-14,
 -1.395442504997359e-15,  7.063346855686724e-17, -3.105329806487998e-18,  1.209610643587339e-19, -4.238351941421629e-21,  1.351829810364404e-22, -3.959828219661268e-24,
  2.951347431037514e-11, -8.487767045763586e-12,  1.273613737141796e-12, -1.300932707478001e-13,  1.012578443277958e-14, -6.392776089079093e-16,  3.406040654326086e-17,
 -1.573922627804901e-18,  6.435201174755851e-20, -2.363678005065150e-21,  7.893138791242697e-23, -2.417694001184578e-24,  1.038900300030650e-11, -3.149073760162313e-12,
  4.987277485141833e-13, -5.371703572766499e-14,  4.402906553748567e-15, -2.923117655518046e-16,  1.635511943729363e-17, -7.926038513095616e-19,  3.394298068374365e-20,
 -1.304253823201387e-21,  4.550973656434844e-23, -1.454877155643080e-24,  3.722593400880925e-12, -1.185259971636882e-12,  1.975167052498169e-13, -2.236911069680217e-14,
  1.925599485593934e-15, -1.340956526919751e-16,  7.859894659306082e-18, -3.985483756369008e-19,  1.783706127033784e-20, -7.154695253952357e-22,  2.603254872453045e-23,
 -8.668432700638826e-25,  1.365277141332347e-12, -4.550622988274413e-13,  7.954657660738948e-14, -9.444883728847761e-15,  8.515368730120073e-16, -6.203689135068315e-17,
  3.799721761091743e-18, -2.011068877566519e-19,  9.384390574253016e-21, -3.920611015636995e-22,  1.484292143432538e-23, -5.137254400241103e-25,  5.153387424151137e-13,
 -1.792029681580725e-13,  3.275521629209126e-14, -4.065218675468559e-15,  3.827711599328766e-16, -2.909345319184596e-17,  1.857186195022075e-18, -1.023393067431911e-19,
  4.967044503564838e-21, -2.156256526966902e-22,  8.474487186842148e-24, -3.041933725581047e-25,  2.012845066464603e-13, -7.277485386694071e-14,  1.386420892950376e-14,
 -1.793020372907458e-15,  1.757935998039106e-16, -1.390056190758900e-17,  9.222732751544542e-19, -5.277257407699733e-20,  2.657221919210222e-21, -1.195658915528963e-22,
  4.866564193701136e-24, -1.807458276216975e-25,  8.177236555969679e-14, -3.063426826402497e-14,  6.062621355916715e-15, -8.144282617288982e-16,  8.288949631506883e-17,
 -6.798529048765971e-18,  4.674824256723645e-19, -2.769946807615960e-20,  1.443071657278719e-21, -6.712928909352390e-23,  2.822469811900850e-24, -1.081970269153667e-25,
  3.471364315846840e-14, -1.342880930684186e-14,  2.751410390834977e-15, -3.826667193920094e-16,  4.030070300859547e-17, -3.418018576350883e-18,  2.428562367982166e-19,
 -1.485775384250860e-20,  7.986258241894907e-22, -3.830217135452929e-23,  1.659153123362272e-24, -6.547686708109701e-26,  1.545804251192560e-14, -6.153610358833657e-15,
  1.300776852000745e-15, -1.866662542071110e-16,  2.027536311564339e-17, -1.772488333269173e-18,  1.297265783583845e-19, -8.169861845313280e-21,  4.517506430325189e-22,
 -2.227353639014621e-23,  9.912544775595705e-25, -4.016256323845397e-26,  7.238744351479901e-15, -2.955118158151190e-15,  6.421805010249600e-16, -9.475385420306165e-17,
  1.057854052483534e-17, -9.500510009033612e-19,  7.139286209595425e-20, -4.613717190042550e-21,  2.616333835342215e-22, -1.322185520589929e-23,  6.027713862920806e-25,
 -2.500278049279247e-26,  3.566146663637220e-15, -1.487790659787377e-15,  3.311722099082958e-16, -5.006166176705495e-17,  5.724353989157665e-18, -5.263276942501857e-19,
  4.047298387948789e-20, -2.675142516028295e-21,  1.550806725650604e-22, -8.007748812566744e-24,  3.728315669836387e-25, -1.578554992146504e-26,  1.842347280714177e-15,
 -7.827767259102444e-16,  1.778149399699160e-16, -2.743624411859352e-17,  3.201538859987343e-18, -3.002971344180220e-19,  2.354782646859402e-20, -1.586511256546079e-21,
  9.370929544113269e-23, -4.928144501087475e-24,  2.335906532136515e-25, -1.006414192683447e-26,  9.882733850912343e-16, -4.261462988547087e-16,  9.841636182508297e-17,
 -1.544133531343150e-17,  1.831939575029602e-18, -1.746533787911955e-19,  1.391593304181219e-20, -9.523473791328379e-22,  5.711874425827021e-23, -3.049135401297239e-24,
  1.466565282452033e-25, -6.409376436764079e-27,  5.371601800015929e-16, -2.342563715364099e-16,  5.479158585852040e-17, -8.707964482713987e-18,  1.046354766410602e-18,
 -1.010163839249538e-19,  8.148352117016820e-21, -5.643974944217686e-22,  3.425218713813774e-23, -1.849670079837024e-24,  8.997379061070055e-26, -3.975617701956929e-27,
  2.772663879527511e-16, -1.218656789188028e-16,  2.875637104628483e-17, -4.611270991626283e-18,  5.590292246201811e-19, -5.444252350028238e-20,  4.429302212842563e-21,
 -3.093808994140052e-22,  1.893049521029376e-23, -1.030517931869146e-24,  5.052287333755296e-26, -2.249582419809656e-27,  1.059420890715174e-16, -4.676712257872778e-17,
  1.108988075643980e-17, -1.787221153318169e-18,  2.177407768019234e-19, -2.130873720663982e-20,  1.741924265468863e-21, -1.222417817074915e-22,  7.514104503583754e-24,
 -4.108816294489871e-25,  2.023263058901620e-26, -9.047356321434780e-28,  5.622997920472622e-02, -1.305487045877915e-04,  3.135381717728616e-07, -7.747891431207135e-10,
  1.957127789624474e-12, -5.022667367978894e-15,  1.302448183941190e-17, -3.399104551090671e-20,  8.898818366227748e-23, -2.332648123700714e-25,  6.111606392172925e-28,
 -1.599618575744388e-30,  5.331834028833013e-02, -1.534059370263556e-04,  5.211873971950071e-07, -1.851717057008808e-09,  6.547476203651673e-12, -2.274288795335042e-14,
  7.751613311269694e-17, -2.597340335658166e-19,  8.574312715218816e-22, -2.794054657609682e-24,  9.000937681542035e-27, -2.870052712251416e-29,  4.794281578909514e-02,
 -1.912427038138856e-04,  9.152846062895175e-07, -4.241156923473341e-09,  1.870005367883854e-11, -7.918436605272600e-14,  3.246918635789487e-16, -1.296597085358901e-18,
  5.062481961901438e-21, -1.938312104057280e-23,  7.294167069764471e-26, -2.702765566130320e-28,  4.088537697804328e-02, -2.313618110820273e-04,  1.446013452208551e-06,
 -8.225736522997711e-09,  4.354901979603820e-11, -2.186537853308136e-13,  1.052738223698065e-15, -4.895702984118753e-18,  2.210533309704794e-20, -9.729058818856504e-23,
  4.186656196051986e-25, -1.765808852240775e-27,  3.307499557082221e-02, -2.609321742180535e-04,  2.030315920363459e-06, -1.384662969789226e-08,  8.653242561532078e-11,
 -5.069171841720805e-13,  2.820978258656664e-15, -1.504756098099567e-17,  7.743739247127136e-20, -3.863407734077593e-22,  1.875723012207059e-24, -8.888816213226879e-27,
  2.538867378567626e-02, -2.712315272819411e-04,  2.561295437295773e-06, -2.066406164853884e-08,  1.505535830819353e-10, -1.016704877511409e-12,  6.465297984506797e-15,
 -3.913082893488860e-17,  2.271539428600630e-19, -1.271997952409395e-21,  6.901540621313537e-24, -3.640985589214102e-26,  1.849874923708681e-02, -2.598135699521650e-04,
  2.933607937917885e-06, -2.771280954604087e-08,  2.330579779724219e-10, -1.797430305808607e-12,  1.294727534160588e-14, -8.818306066844126e-17,  5.729087968719182e-19,
 -3.573740724432175e-21,  2.151254052705980e-23, -1.254632194358711e-25,  1.279954956736979e-02, -2.301222513691566e-04,  3.074743942146682e-06, -3.371386385020756e-08,
  3.245933811641152e-10, -2.837559102107526e-12,  2.299116333267768e-14, -1.750545313401023e-16,  1.264857358557928e-18, -8.736466694304846e-21,  5.800939838084816e-23,
 -3.719168999437330e-25,  8.414355714691882e-03, -1.892410599081188e-04,  2.966751875681505e-06, -3.746896202903952e-08,  4.101629419085976e-10, -4.038846331360059e-12,
  3.659619268045850e-14, -3.097959272934534e-16,  2.476585468701310e-18, -1.884712828498972e-20,  1.373810192066337e-22, -9.638172530622118e-25,  5.258756899028629e-03,
 -1.450594515245310e-04,  2.647934488865285e-06, -3.825932956937392e-08,  4.733624504199131e-10, -5.222254080259915e-12,  5.265532716721035e-14, -4.932718265573657e-16,
  4.343667051881284e-18, -3.626741373693091e-20,  2.890422854513671e-22, -2.210328540737249e-24,  3.126687427710037e-03, -1.040152347013820e-04,  2.195088291515660e-06,
 -3.606413786015120e-08,  5.016799347134876e-10, -6.171775568380169e-12,  6.894761778957095e-14, -7.118843380196834e-16,  6.878774796776433e-18, -6.278517493890793e-20,
  5.451913134059090e-22, -4.529095977345146e-24,  1.769994825456499e-03, -6.999201838449223e-05,  1.696162543044386e-06, -3.151246100868414e-08,  4.905500013123020e-10,
 -6.701345991347242e-12,  8.262783131718102e-14, -9.369320584866666e-16,  9.900941185252472e-18, -9.847283901790411e-20,  9.288031735937189e-22, -8.357426168921844e-24,
  9.548606581150550e-04, -4.432467490774497e-05,  1.225630579812134e-06, -2.561891628593642e-08,  4.443736586926608e-10, -6.715387017289271e-12,  9.107228568478798e-14,
 -1.130483641751307e-15,  1.302533071364485e-17, -1.407602684134191e-19,  1.438190018563032e-21, -1.398014699358043e-23,  4.913985917604276e-04, -2.648699621117184e-05,
  8.306776305431031e-07, -1.944363763656701e-08,  3.743127900295731e-10, -6.235736761988434e-12,  9.272167514900738e-14, -1.256282212405291e-15,  1.573909958736437e-17,
 -1.843312837465107e-19,  2.035136561482010e-21, -2.132105955220548e-23,  2.415207764002738e-04, -1.497224946550567e-05,  5.295668609313740e-07, -1.381988188268792e-08,
  2.941943658972921e-10, -5.385377687626653e-12,  8.754308395816749e-14, -1.291188266055922e-15,  1.754532642361266e-17, -2.221677129193625e-19,  2.644579170258584e-21,
 -2.979584711314873e-23,  1.135174326935658e-04, -8.025024114037678e-06,  3.184305148369088e-07, -9.226771504331083e-09,  2.164495735894201e-10, -4.340680887225179e-12,
  7.693014765484352e-14, -1.232092246563121e-15,  1.811697473228519e-17, -2.474890157940552e-19,  3.169650086877095e-21, -3.832944404386040e-23,  5.109566188794180e-05,
 -4.088207751131027e-06,  1.810844657031428e-07, -5.803428714436227e-09,  1.495403373016297e-10, -3.276017807630374e-12,  6.314085917137136e-14, -1.095522648712689e-15,
  1.739367296375254e-17, -2.558151264886683e-19,  3.518210010281737e-21, -4.557883701705210e-23,  2.206050873249271e-05, -1.984149179945810e-06,  9.765232100239264e-08,
 -3.448761589142963e-09,  9.731213578753507e-11, -2.322595914206192e-12,  4.856408199855177e-14, -9.108176585222905e-16,  1.558257638279116e-17, -2.462659761819826e-19,
  3.630367864366372e-21, -5.029901162011593e-23,  9.152302124520021e-06, -9.196458828845403e-07,  5.007173335365888e-08, -1.941963050488618e-09,  5.982764318966246e-11,
 -1.551720946380665e-12,  3.511828131124450e-14, -7.104635058882579e-16,  1.307197771202051e-17, -2.215868454780027e-19,  3.495359350776764e-21, -5.170759139827594e-23,
  3.655820744451491e-06, -4.080942323268413e-07,  2.448002136903192e-08, -1.039180925609967e-09,  3.485708819480263e-11, -9.800312354399430e-13,  2.395404366261971e-14,
 -5.216792390815980e-16,  1.030346819682151e-17, -1.870097251363518e-19,  3.151350491438884e-21, -4.969700510159300e-23,  1.409046728203716e-06, -1.738340375179896e-07,
  1.144408296690801e-08, -5.300525972131559e-10,  1.930576666133663e-11, -5.870067303574987e-13,  1.546234234291939e-14, -3.618008981595015e-16,  7.656774755082551e-18,
 -1.485494654283224e-19,  2.669906321378594e-21, -4.481689442880403e-23,  5.252850075158425e-07, -7.127710480900795e-08,  5.130913173761531e-09, -2.585085910664545e-10,
  1.019718998952285e-11, -3.345377839511868e-13,  9.476996131107120e-15, -2.377994844999273e-16,  5.382947058358788e-18, -1.114487885524269e-19,  2.133136250785054e-21,
 -3.805704521502463e-23,  1.899070293163044e-07, -2.821562948907823e-08,  2.213160668715446e-09, -1.209393808453204e-10,  5.153632916827193e-12, -1.820175050687119e-13,
  5.534161947737181e-15, -1.486382943185539e-16,  3.592725040538904e-18, -7.925156944560731e-20,  1.612899941987433e-21, -3.053967970737522e-23,  6.677629309518454e-08,
 -1.081747330514581e-08,  9.214530160973663e-10, -5.445971373094758e-11,  2.500869813979860e-12, -9.487921203722043e-14,  3.089987735823015e-15, -8.867022761198233e-17,
  2.284625275601500e-18, -5.360847953102743e-20,  1.158333934701635e-21, -2.324379251319990e-23,  2.290953570189120e-08, -4.030221284110541e-09,  3.716214090893308e-10,
 -2.368952389412953e-11,  1.169479227880843e-12, -4.755664091385852e-14,  1.655716306582080e-15, -5.067082803095824e-17,  1.389319288467536e-18, -3.462286935455250e-20,
  7.930663342605089e-22, -1.684126967716621e-23,  7.695306937988360e-09, -1.464460046465764e-09,  1.457198116864544e-10, -9.992162668779081e-12,  5.290308195184352e-13,
 -2.300932915459727e-14,  8.546978366063190e-16, -2.784480969860142e-17,  8.110657982203176e-19, -2.143206314230363e-20,  5.196342594839075e-22, -1.166074522086694e-23,
  2.540304778645605e-09, -5.210347021756804e-10,  5.577715624442739e-11, -4.103294981800970e-12,  2.324408492842870e-13, -1.078963908873228e-14,  4.267676546712368e-16,
 -1.477357746314115e-17,  4.563716577172433e-19, -1.276642194193126e-20,  3.271312590939511e-22, -7.745954339436780e-24,  8.274980974718640e-10, -1.822696361813585e-10,
  2.092942616445853e-11, -1.647518711097890e-12,  9.961918891604359e-14, -4.924609379395853e-15,  2.069979269056136e-16, -7.600018399836729e-18,  2.485475028350553e-19,
 -7.348257838706570e-21,  1.986887961304608e-22, -4.956746404154353e-24,  2.671655209341860e-10, -6.297479442213527e-11,  7.733638817480933e-12, -6.497083845859704e-13,
  4.183445515412394e-14, -2.197606177635711e-15,  9.796556745201206e-17, -3.807606533640437e-18,  1.315924855634666e-19, -4.104811010489447e-21,  1.169272041457649e-22,
 -3.068564295133486e-24,  8.589695959800599e-11, -2.159239213028682e-11,  2.827616571574840e-12, -2.528587690997745e-13,  1.729639874715544e-14, -9.633739365269418e-16,
  4.545147696715441e-17, -1.866423069831843e-18,  6.804126641130700e-20, -2.235423067919644e-21,  6.697115082108007e-23, -1.845883870431622e-24,  2.764073321181849e-11,
 -7.384532156121449e-12,  1.028189978583193e-12, -9.761229076313256e-14,  7.075966190381662e-15, -4.169296184545575e-16,  2.077400161943806e-17, -8.994805398940832e-19,
  3.452291173898331e-20, -1.192417651243893e-21,  3.750628185220641e-23, -1.083896363301516e-24,  8.949905688525389e-12, -2.532590299570527e-12,  3.738227475885526e-13,
 -3.757540075368241e-14,  2.879427400380671e-15, -1.790635222368095e-16,  9.401833286280090e-18, -4.283380367634864e-19,  1.727393892766966e-20, -6.260647539769421e-22,
  2.063711055509385e-23, -6.242153015972110e-25,  2.932431421902553e-12, -8.759362494396076e-13,  1.366558068870656e-13, -1.450379110408783e-14,  1.171906272697461e-15,
 -7.673084463729745e-17,  4.235750280377114e-18, -2.026102106477427e-19,  8.567442176514097e-21, -3.251762603935753e-22,  1.121161676789761e-23, -3.542824173652072e-25,
  9.779645922420401e-13, -3.073183503682861e-13,  5.052208964810151e-14, -5.645837312914961e-15,  4.797333492137961e-16, -3.298871499038026e-17,  1.910052666201346e-18,
 -9.570699243115884e-20,  4.234183887228440e-21, -1.679440114236467e-22,  6.044407964479725e-24, -1.991496574507749e-25,  3.339827818515646e-13, -1.100338553390841e-13,
  1.900250511200701e-14, -2.229425117129019e-15,  1.986708359773761e-16, -1.431050503931212e-17,  8.669050388222206e-19, -4.539401751043620e-20,  2.096341427295213e-21,
 -8.670038122709964e-23,  3.250271894655035e-24, -1.114264937231977e-25,  1.175130358282247e-13, -4.045126953655380e-14,  7.315260670269347e-15, -8.983511158747867e-16,
  8.371809902801902e-17, -6.299588371067671e-18,  3.982263407234054e-19, -2.173669576413151e-20,  1.045299989123355e-21, -4.497242831357997e-23,  1.752141836611077e-24,
 -6.236275311794135e-26,  4.285939168595570e-14, -1.536144164387227e-14,  2.899524372146264e-15, -3.715608322258151e-16,  3.610321113670238e-17, -2.829909114376021e-18,
  1.861656240502191e-19, -1.056450922121824e-20,  5.276779872703446e-22, -2.355831966904788e-23,  9.515852093314377e-25, -3.508143309236252e-26,  1.629852842411042e-14,
 -6.061197226104838e-15,  1.190127940430311e-15, -1.586301787928412e-16,  1.602136860036687e-17, -1.304258429029742e-18,  8.903231828559871e-20, -5.238084513571593e-21,
  2.710135046422886e-22, -1.252269979443602e-23,  5.230900035299797e-25, -1.992531985147779e-26,  6.497437566374892e-15, -2.498322440313774e-15,  5.085393253555293e-16,
 -7.026754129015304e-17,  7.352984322712798e-18, -6.197374440270829e-19,  4.376572248135510e-20, -2.661700259761798e-21,  1.422456689611780e-22, -6.783841253184534e-24,
  2.922538368974806e-25, -1.147232115783626e-26,  2.727929567308227e-15, -1.080679404908571e-15,  2.272323334293763e-16, -3.243642435169710e-17,  3.504892516205448e-18,
 -3.048452162184498e-19,  2.220085498829220e-20, -1.391411864937985e-21,  7.657640073309698e-23, -3.758324472841996e-24,  1.665142807472969e-25, -6.717448158964192e-27,
  1.210215557343598e-15, -4.921919932590906e-16,  1.065166708272816e-16, -1.565139975182913e-17,  1.740228092792140e-18, -1.556646499407405e-19,  1.165205366110093e-20,
 -7.501464210371451e-22,  4.238167688912918e-23, -2.134071752589209e-24,  9.694861452582197e-26, -4.007679965353693e-27,  5.679973814019264e-16, -2.363023789262157e-16,
  5.243619763274155e-17, -7.901813325501625e-18,  9.007655287253271e-19, -8.257206208011301e-20,  6.330886043471922e-21, -4.172536213336373e-22,  2.412105354438842e-23,
 -1.242125402341705e-24,  5.767855811701649e-26, -2.435794632915020e-27,  2.813327552481268e-16, -1.192961684265179e-16,  2.703960671256111e-17, -4.162875076979255e-18,
  4.847042461601162e-19, -4.536673768445211e-20,  3.549986732394809e-21, -2.386879725376209e-22,  1.407030453803548e-23, -7.385151302633328e-25,  3.493878683106910e-26,
 -1.502548377281369e-27,  1.457074813614555e-16, -6.274818048786964e-17,  1.447041398980968e-17, -2.267064333227300e-18,  2.685734211013141e-19, -2.556899525467406e-20,
  2.034451127554087e-21, -1.390409094600355e-22,  8.328220891133458e-24, -4.440078273751162e-25,  2.132894393923773e-26, -9.310064217643403e-28,  7.705138945678761e-17,
 -3.357663162882851e-17,  7.846710897889172e-18, -1.245988804899579e-18,  1.495904958691377e-19, -1.442948839589676e-20,  1.162975308512132e-21, -8.048876432877695e-23,
  4.880855345515961e-24, -2.633705794097680e-25,  1.280153817636057e-26, -5.652394457755036e-28,  3.900981172537622e-17, -1.713914378689459e-17,  4.042508355045245e-18,
 -6.479533470149793e-19,  7.851728213989066e-20, -7.643274877462555e-21,  6.215705272747065e-22, -4.339763547536951e-23,  2.654334695449768e-24, -1.444355387700357e-25,
  7.078398048919449e-27, -3.150513424597078e-28,  1.474432297359640e-17, -6.507568480330782e-18,  1.542822382002841e-18, -2.485858350647037e-19,  3.027938035553530e-20,
 -2.962612555283884e-21,  2.421349185975975e-22, -1.698869582713901e-23,  1.044073502410644e-24, -5.708017819129644e-26,  2.810198393358205e-27, -1.256388281889996e-28,
  5.571274285475725e-02, -1.280770642794139e-04,  3.044253255077131e-07, -7.442620592445592e-10,  1.859724856903128e-12, -4.721186607832814e-15,  1.211136970014319e-17,
 -3.127320022375283e-20,  8.101424658667121e-23, -2.101689929252108e-25,  5.449961865876528e-28, -1.412028902434962e-30,  5.271291727755016e-02, -1.493235732785312e-04,
  4.995806607240786e-07, -1.750497636838641e-09,  6.110648877876348e-12, -2.096676143932598e-14,  7.061306943141437e-17, -2.338385166528983e-19,  7.630329234753185e-22,
 -2.458043691458247e-24,  7.828857664781423e-27, -2.468312448377440e-29,  4.719217422514114e-02, -1.841190337507153e-04,  8.661350052259546e-07, -3.954214187313696e-09,
  1.719144366598170e-11, -7.180973720132410e-14,  2.905541196295662e-16, -1.145221683069650e-18,  4.414463906452377e-21, -1.668998213112890e-23,  6.203001924724006e-26,
 -2.270367697627245e-28,  3.998245708857565e-02, -2.201770171447242e-04,  1.351345331127566e-06, -7.562609250618557e-09,  3.941789758909961e-11, -1.949562156513208e-13,
  9.250573852906449e-16, -4.241285613624223e-18,  1.888648803174153e-20, -8.199984218050772e-23,  3.481753644703395e-25, -1.449277057551352e-27,  3.206273182667019e-02,
 -2.453314955669734e-04,  1.872140447679393e-06, -1.253967745652319e-08,  7.703838328759466e-11, -4.440020246867255e-13,  2.432346600981125e-15, -1.277834766368447e-17,
  6.479044348146649e-20, -3.185848886176094e-22,  1.524898904600742e-24, -7.125945629314957e-27,  2.434321377677117e-02, -2.516935805768033e-04,  2.327135142245740e-06,
 -1.840980462258782e-08,  1.316864805264072e-10, -8.739047773749337e-13,  5.464878147584928e-15, -3.254427580720267e-17,  1.859678960730665e-19, -1.025496640485567e-21,
  5.481117701470985e-24, -2.849344741015857e-26,  1.750441253623818e-02, -2.376141559633975e-04,  2.622293967235541e-06, -2.425539119811522e-08,  2.000269416155339e-10,
 -1.514366763746942e-12,  1.071659603995432e-14, -7.175260224288270e-17,  4.584991123006737e-19, -2.814287023815103e-21,  1.667612519179824e-23, -9.576877504344453e-26,
  1.192581340436154e-02, -2.070584021578573e-04,  2.699558502954258e-06, -2.894598653410185e-08,  2.729855149530568e-10, -2.340291137199246e-12,  1.861202740138209e-14,
 -1.391936246250035e-16,  9.884466412222640e-19, -6.713163711200597e-21,  4.384849071594918e-23, -2.766497474021899e-25,  7.702161646126647e-03, -1.671998337779684e-04,
  2.553981230136366e-06, -3.150764474897485e-08,  3.375102381686814e-10, -3.256264774660009e-12,  2.893652316001809e-14, -2.404182936374230e-16,  1.887567854656880e-18,
 -1.411517949537703e-20,  1.011493420833651e-22, -6.979197235620752e-25,  4.718150176305724e-03, -1.255911827943866e-04,  2.231028874743489e-06, -3.145685653743690e-08,
  3.805122379966872e-10, -4.109689951521452e-12,  4.060827075762917e-14, -3.731104011633286e-16,  3.224658189064092e-18, -2.644070083528285e-20,  2.070458952701533e-22,
 -1.556342643308078e-24,  2.743188000791522e-03, -8.805797893654107e-05,  1.806680277996313e-06, -2.894119027743516e-08,  3.932975044724921e-10, -4.733299354881648e-12,
  5.178464532177601e-14, -5.240801489583861e-16,  4.967314828405657e-18, -4.449996764240376e-20,  3.794705329164804e-22, -3.097241906401423e-24,  1.514946178035218e-03,
 -5.781141439665614e-05,  1.361009035036068e-06, -2.463644469841847e-08,  3.744008072122606e-10, -5.000321399196595e-12,  6.034365663914389e-14, -6.703145398055734e-16,
  6.944546581310260e-18, -6.775866771028136e-20,  6.273369021193720e-22, -5.543686444783071e-24,  7.953831026131301e-04, -3.563795462631660e-05,  9.567884998255649e-07,
 -1.947461252743187e-08,  3.295842335035560e-10, -4.866708251674818e-12,  6.456499063052251e-14, -7.847497197146088e-16,  8.860460489944356e-18, -9.389546749063175e-20,
  9.413194347922411e-22, -8.982966646621306e-24,  3.973958940153107e-04, -2.068180495155777e-05,  6.295337024088617e-07, -1.434245104693640e-08,  2.692720300464917e-10,
 -4.381227002566454e-12,  6.370149742050039e-14, -8.447638575986168e-16,  1.036722574791697e-17, -1.190207421317573e-19,  1.288922874697551e-21, -1.325233448628342e-23,
  1.891575806363887e-04, -1.132654884906907e-05,  3.887553385441380e-07, -9.871514909604904e-09,  2.048677314359134e-10, -3.661458141136006e-12,  5.817967950549844e-14,
 -8.396075642628203e-16,  1.117243251093005e-17, -1.386375560150708e-19,  1.618254427613405e-21, -1.788893869495641e-23,  8.588616304381217e-05, -5.867590614699871e-06,
  2.259190935823928e-07, -6.368418702356438e-09,  1.456113831754780e-10, -2.850262294263220e-12,  4.936559207260372e-14, -7.733934685551884e-16,  1.113369591726460e-17,
 -1.490135277209125e-19,  1.871025602346665e-21, -2.219495257028352e-23,  3.725059586593637e-05, -2.881913784217235e-06,  1.238777360493505e-07, -3.862008458525543e-09,
  9.698133230342465e-11, -2.073464727565383e-12,  3.904716794752249e-14, -6.626092610389031e-16,  1.029801440218435e-17, -1.483670680944931e-19,  2.000178673875798e-21,
 -2.541589681676788e-23,  1.545742693844580e-05, -1.345160446378281e-06,  6.425990592076147e-08, -2.207808301652107e-09,  6.070963960378570e-11, -1.414033609747213e-12,
  2.888662356946509e-14, -5.298266185528957e-16,  8.872190272436671e-18, -1.373439485675822e-19,  1.984532406805974e-21, -2.696696815203236e-23,  6.147478898030168e-06,
 -5.981046439660363e-07,  3.161921246668939e-08, -1.193200802373797e-09,  3.582648006818421e-11, -9.068356797287342e-13,  2.005164326835439e-14, -3.967157878055728e-16,
  7.144399217154212e-18, -1.186256420258284e-19,  1.834112779330551e-21, -2.661046692092824e-23,  2.347796063757703e-06, -2.539625136859480e-07,  1.479837758765270e-08,
 -6.114044186520642e-10,  1.999127636894466e-11, -5.486074048304598e-13,  1.310231692554990e-14, -2.790815695883509e-16,  5.395480046425297e-18, -9.592916002752593e-20,
  1.584569029625114e-21, -2.450965931409919e-23,  8.629152990235933e-07, -1.032492599031260e-07,  6.606357021821188e-09, -2.979214753941319e-10,  1.058055630476445e-11,
 -3.140786876193499e-13,  8.085439544966060e-15, -1.850679167720462e-16,  3.834371644569041e-18, -7.288236238550779e-20,  1.284209118222023e-21, -2.114624317724838e-23,
  3.059588061236650e-07, -4.030275038424842e-08,  2.821540529964803e-09, -1.384775311564812e-10,  5.328358175042585e-12, -1.707164065472051e-13,  4.727797588488358e-15,
 -1.160766210884522e-16,  2.573027695742145e-18, -5.220355961961940e-20,  9.797713270454885e-22, -1.715075632542526e-23,  1.049294223346007e-07, -1.514960863701332e-08,
  1.156512131189698e-09, -6.159867145294777e-11,  2.561757834189567e-12, -8.839737536245196e-14,  2.628456880314708e-15, -6.909963990891141e-17,  1.636060758483488e-18,
 -3.537657281367399e-20,  7.061920362747919e-22, -1.312333124246382e-23,  3.490940793530410e-08, -5.501374852938871e-09,  4.564589075440902e-10, -2.631268875718982e-11,
  1.179929004736953e-12, -4.375851311855512e-14,  1.394360428790767e-15, -3.918144689661512e-17,  9.892914602974620e-19, -2.276366458198134e-20,  4.826248383694616e-22,
 -9.508270104796895e-24,  1.130309925122517e-08, -1.936580864937072e-09,  1.740946855688403e-10, -1.083272113764195e-11,  5.225683384225479e-13, -2.078516531035849e-14,
  7.084317464746983e-16, -2.124126751515965e-17,  5.710101000332817e-19, -1.396066922639709e-20,  3.139159585034677e-22, -6.547632852168554e-24,  3.574355555241691e-09,
 -6.632918116213522e-10,  6.441020916532291e-11, -4.314850475974198e-12,  2.234037152888099e-13, -9.510629713667579e-15,  3.460740522330030e-16, -1.105285212582996e-17,
  3.158307114576529e-19, -8.192204384540811e-21,  1.950844315230344e-22, -4.302059448544873e-24,  1.108212158829216e-09, -2.219305541582402e-10,  2.321032462973557e-11,
 -1.669700533690819e-12,  9.257492679338521e-14, -4.209456289118316e-15,  1.632227175985466e-16, -5.543046586014061e-18,  1.680870732711670e-19, -4.618438397834351e-21,
  1.163046324961099e-22, -2.707867212471335e-24,  3.383020104847456e-10, -7.285339313993295e-11,  8.182109042434880e-12, -6.304717241175404e-13,  3.734752640762785e-14,
 -1.810122053436938e-15,  7.464959787103458e-17, -2.690827024305035e-18,  8.644760869123296e-20, -2.512141844370783e-21,  6.679996753098622e-23, -1.639688475117394e-24,
  1.021484673806194e-10, -2.357353591614210e-11,  2.834934697762007e-12, -2.333913594392472e-13,  1.473761797138009e-14, -7.597566784494339e-16,  3.325936495680902e-17,
 -1.270201768274488e-18,  4.315963305496622e-20, -1.324326324175118e-21,  3.712674435083341e-23, -9.593651341219387e-25,  3.065878642865286e-11, -7.556388289324774e-12,
  9.702689168736119e-13, -8.512707661094360e-14,  5.716736181093008e-15, -3.127996452612106e-16,  1.450637252568485e-17, -5.858743278246820e-19,  2.101738622575402e-20,
 -6.798168972712453e-22,  2.006073170289310e-23, -5.448620107945305e-25,  9.195719617320562e-12, -2.412364074512693e-12,  3.297869204897388e-13, -3.075544337641872e-14,
  2.191350361888988e-15, -1.269830615993983e-16,  6.225828663152855e-18, -2.653911475841643e-19,  1.003298815333403e-20, -3.414897851699594e-22,  1.058928456870080e-23,
 -3.018197606100181e-25,  2.772003887182991e-12, -7.714088580177544e-13,  1.119513576792137e-13, -1.106850605677883e-14,  8.347042729361976e-16, -5.110886876443073e-17,
  2.643492509675944e-18, -1.186948553571508e-19,  4.719639783013331e-21, -1.687295014969769e-22,  5.488419100312570e-24, -1.638816760013735e-25,  8.448848482454791e-13,
 -2.485737626511817e-13,  3.818352669740919e-14, -3.991503609313448e-15,  3.177930259198297e-16, -2.051226569663975e-17,  1.116753175658118e-18, -5.270532227627784e-20,
  2.199809051982250e-21, -8.244398388317328e-23,  2.807838449580105e-24, -8.767476806830500e-26,  2.620274700531909e-13, -8.122629953230565e-14,  1.316704532141547e-14,
 -1.451255756027139e-15,  1.216705889200575e-16, -8.258329331492620e-18,  4.721523825203755e-19, -2.336973289762439e-20,  1.021666875762993e-21, -4.005740443674255e-23,
  1.425584564957262e-24, -4.646041634642847e-26,  8.323334920068659e-14, -2.709266192607994e-14,  4.620356693660519e-15, -5.353999481118657e-16,  4.713853719070938e-17,
 -3.355838878203748e-18,  2.009877048432180e-19, -1.040859591328673e-20,  4.755427107904878e-22, -1.946324283616890e-23,  7.222832918944858e-25, -2.451879128232205e-26,
  2.726288287738930e-14, -9.285961922877068e-15,  1.660751075289563e-15, -2.017242805044547e-16,  1.859863164046696e-17, -1.384997655854128e-18,  8.667012203771874e-20,
 -4.684469478143765e-21,  2.231291088056085e-22, -9.511005833008278e-24,  3.672197334487784e-25, -1.295606692544817e-26,  9.270535795409840e-15, -3.292599579452526e-15,
  6.155273747184213e-16, -7.812706720455232e-17,  7.520721358992974e-18, -5.841622547816262e-19,  3.809043290727129e-20, -2.143028730217909e-21,  1.061485061109408e-22,
 -4.700629105363384e-24,  1.883748800303375e-25, -6.891539403867307e-27,  3.294328325866642e-15, -1.215734589978274e-15,  2.367589296095938e-16, -3.130057427838220e-17,
  3.136116801676438e-18, -2.533196787063868e-19,  1.716151682148550e-20, -1.002242690181118e-21,  5.148390708436186e-23, -2.362347967425551e-24,  9.800990711596027e-26,
 -3.708789197745613e-27,  1.230995443624277e-15, -4.703331157605385e-16,  9.508437664468162e-17, -1.304897486521777e-17,  1.356370529084848e-18, -1.135756087828246e-19,
  7.969800646951738e-21, -4.817061234985584e-22,  2.558846010577674e-23, -1.213202752196744e-24,  5.196834985593325e-26, -2.028722598496156e-27,  4.863473173597713e-16,
 -1.916873819694712e-16,  4.008271272406417e-17, -5.689989251837736e-18,  6.114864421583203e-19, -5.290291369729891e-20,  3.832800330221705e-21, -2.390051849823257e-22,
  1.308910118252559e-23, -6.393360867524099e-25,  2.819432767553974e-26, -1.132265327692032e-27,  2.040112962115246e-16, -8.264230022603470e-17,  1.780725708904479e-17,
 -2.605195455874578e-18,  2.884241203523253e-19, -2.569181793002924e-20,  1.915276030774222e-21, -1.228130245833817e-22,  6.911798861038555e-24, -3.467214806242186e-25,
  1.569333352559719e-26, -6.464192918724255e-28,  9.104774847939359e-17, -3.776646558566785e-17,  8.353178990902337e-18, -1.254652276248103e-18,  1.425625939495279e-19,
 -1.302728687361334e-20,  9.957380452619903e-22, -6.542956487977236e-23,  3.771350906871579e-24, -1.936536814255267e-25,  8.967398891637938e-27, -3.776756098506525e-28,
  4.316066904852507e-17, -1.826369599022971e-17,  4.130061505878492e-18, -6.343614027683093e-19,  7.369215055714320e-20, -6.881820195951454e-21,  5.373243301222403e-22,
 -3.605019919222591e-23,  2.120661509431039e-24, -1.110813179159366e-25,  5.244762004605778e-27, -2.251163737592989e-28,  2.154970695429105e-17, -9.267628636278210e-18,
  2.133963579888422e-18, -3.338124837337812e-19,  3.948595587715670e-20, -3.753590749126466e-21,  2.982280832615363e-22, -2.035292488996432e-23,  1.217403159077662e-24,
 -6.481650574679662e-26,  3.109508184398444e-27, -1.355558292808292e-28,  1.107312973647980e-17, -4.821465736830206e-18,  1.125741866599958e-18, -1.785953344071067e-19,
  2.142244146309532e-20, -2.064580759703543e-21,  1.662552794069577e-22, -1.149668474837587e-23,  6.965851184929724e-25, -3.755733980706578e-26,  1.824094392712845e-27,
 -8.047931594745940e-29,  5.493774823176725e-18, -2.412733242169050e-18,  5.688155137873499e-19, -9.113005294318132e-20,  1.103778861857773e-20, -1.073985102985132e-21,
  8.730010456556553e-23, -6.092560067796268e-24,  3.724798087096451e-25, -2.025994707094409e-26,  9.924765484975021e-28, -4.415622430189076e-29,  2.052941292215139e-18,
 -9.059193155117483e-19,  2.147309288835098e-19, -3.459083007889108e-20,  4.212478148922189e-21, -4.120713871592139e-22,  3.367154854919840e-23, -2.361973617144052e-24,
  1.451298469995090e-25, -7.932735802165389e-27,  3.904702975807810e-28, -1.745379387538518e-29,  5.520524954373178e-02, -1.256768874840880e-04,  2.956696487573220e-07,
 -7.152463507037553e-10,  1.768138410722324e-12, -4.440735426380061e-15,  1.127090634935354e-17, -2.879771281073325e-20,  7.382604394484375e-23, -1.895618567512594e-25,
  4.865548937196879e-28, -1.248005722444648e-30,  5.212348554239934e-02, -1.454093210649096e-04,  4.791477656159928e-07, -1.655992034709503e-09,  5.707744360292800e-12,
 -1.934793804247644e-14,  6.439454569151445e-17, -2.107789183948189e-19,  6.799279888926309e-22, -2.165564088113278e-24,  6.820017406158322e-27, -2.126356872999266e-29,
  4.646926219058747e-02, -1.773751866594332e-04,  8.202886173308223e-07, -3.690272386306857e-09,  1.582246475032975e-11, -6.520580864036585e-14,  2.603785704222679e-16,
 -1.013112264417775e-18,  3.855980213755532e-21, -1.439751756458984e-23,  5.285469116784967e-26, -1.911146992625755e-28,  3.912281054240576e-02, -2.097188267635392e-04,
  1.264253267187840e-06, -6.961948791238754e-09,  3.573150952898827e-11, -1.741142513718736e-13,  8.143372166051098e-16, -3.681581888410027e-18,  1.617054258088046e-20,
 -6.926871794583967e-23,  2.902496178362698e-25, -1.192508201244625e-27,  3.111043579427903e-02, -2.309359769267302e-04,  1.728776913360724e-06, -1.137504943446858e-08,
  6.871429200457843e-11, -3.896951400505253e-13,  2.101935312748934e-15, -1.087737295712710e-17,  5.434775100181498e-20, -2.634252274913759e-22,  1.243242872184281e-24,
 -5.729896275413228e-27,  2.337232334439438e-02, -2.339256348653419e-04,  2.118304877055494e-06, -1.643581764309457e-08,  1.154494812501963e-10, -7.530427764216504e-13,
  4.631690109618285e-15, -2.714401032963625e-17,  1.527119230745690e-19, -8.294112670292612e-22,  4.367653532547766e-24, -2.237653913310973e-26,  1.659414309205587e-02,
 -2.177478699955836e-04,  2.349475846938579e-06, -2.128393878514615e-08,  1.721570417950248e-10, -1.279708608101070e-12,  8.898572103482231e-15, -5.858073168019490e-17,
  3.682410460563044e-19, -2.224474082800374e-21,  1.297724216354402e-23, -7.339779603399146e-26,  1.113867316420074e-02, -1.867804953164889e-04,  2.376943827117838e-06,
 -2.492965835748495e-08,  2.303484543834520e-10, -1.937009082739036e-12,  1.512338059618228e-14, -1.111140563147469e-16,  7.756146467380130e-19, -5.180526263679348e-21,
  3.329180971500160e-23, -2.067329673146017e-25,  7.071954803598558e-03, -1.481932633567585e-04,  2.206257598391790e-06, -2.659292181085596e-08,  2.788178190564683e-10,
 -2.636186347252722e-12,  2.297928774493286e-14, -1.874219412269186e-16,  1.445408020681585e-18, -1.062283466964673e-20,  7.484854542142860e-23, -5.080058169456221e-25,
  4.249229479747747e-03, -1.091553010971114e-04,  1.887525681271748e-06, -2.597661089216892e-08,  3.072749376345357e-10, -3.249621710228280e-12,  3.147339371292231e-14,
 -2.836777694200039e-16,  2.406711496935577e-18, -1.938275434192343e-20,  1.491516276608097e-22, -1.102242022622116e-24,  2.417805503674194e-03, -7.489351634068566e-05,
  1.494224422021406e-06, -2.334291499313579e-08,  3.099581274486018e-10, -3.649978737198247e-12,  3.911436177946788e-14, -3.880758780159900e-16,  3.608582438859753e-18,
 -3.173490041342800e-20,  2.657967407411994e-22, -2.131798233178750e-24,  1.303738651908346e-03, -4.801117364158285e-05,  1.098252447245983e-06, -1.937335194285001e-08,
  2.874773931554697e-10, -3.754279739929095e-12,  4.435124502125162e-14, -4.827151347222972e-16,  4.903686967594573e-18, -4.694522841836038e-20,  4.266976221772857e-22,
 -3.703637477568286e-24,  6.667772834610514e-04, -2.883566640031630e-05,  7.517748232769056e-07, -1.490267734739183e-08,  2.461190723008455e-10, -3.551666422753328e-12,
  4.610097345844774e-14, -5.487406831856140e-16,  6.072356347754768e-18, -6.311089490386327e-20,  6.208865168547803e-22, -5.817537215068920e-24,  3.237464418540837e-04,
 -1.626688813006599e-05,  4.806314156210217e-07, -1.065944325682459e-08,  1.951980773788012e-10, -3.102373524452273e-12,  4.411332532531837e-14, -5.726573667977440e-16,
  6.885162852156515e-18, -7.749446677712938e-20,  8.232619831934647e-22, -8.308161582738357e-24,  1.493931429663019e-04, -8.639724275343911e-06,  2.877734396798552e-07,
 -7.110919395555955e-09,  1.438881945160206e-10, -2.511054827265650e-12,  3.900648686091375e-14, -5.508457909615997e-16,  7.178776859497098e-18, -8.730621599955647e-20,
  9.994188622372643e-22, -1.084097379248921e-23,  6.559719462624955e-05, -4.330263658848226e-06,  1.617856062291394e-07, -4.437002958829741e-09,  9.888859435204931e-11,
 -1.889572886182453e-12,  3.198488443132200e-14, -4.902202460645548e-16,  6.909818952706707e-18, -9.061670010751589e-20,  1.115575139486042e-21, -1.298264231225787e-23,
  2.744493899663020e-05, -2.052739038959319e-06,  8.562454016719458e-08, -2.596840267481963e-09,  6.355391567454642e-11, -1.326164751122043e-12,  2.440324270478805e-14,
 -4.050438984321115e-16,  6.162455280319211e-18, -8.697934910205378e-20,  1.149507260953906e-21, -1.432752211298833e-23,  1.095790930958894e-05, -9.224704646366114e-07,
  4.277057658670239e-08, -1.429551601447300e-09,  3.830835116005187e-11, -8.707679019602946e-13,  1.738001286272490e-14, -3.117632336938560e-16,  5.110098171512608e-18,
 -7.748894871913289e-20,  1.097511446676039e-21, -1.462735349237535e-23,  4.182417716667485e-06, -3.939053170740451e-07,  2.021702997261629e-08, -7.422814143409790e-10,
  2.172085548227056e-11, -5.365498348406448e-13,  1.159134725365500e-14, -2.242787354497852e-16,  3.953360951790994e-18, -6.429777379867991e-20,  9.744282992499376e-22,
 -1.386587270846463e-23,  1.528955844815519e-06, -1.602200531459473e-07,  9.067454658472806e-09, -3.645785601954528e-10,  1.161945651198001e-11, -3.112139410746894e-13,
  7.262373612548062e-15, -1.512897252070497e-16,  2.862987399112275e-18, -4.986243564817928e-20,  8.073406240823254e-22, -1.224815964760523e-23,  5.364881729628164e-07,
 -6.223745505163930e-08,  3.869618836110380e-09, -1.698820429785800e-10,  5.882282246247670e-12, -1.704562151438782e-13,  4.288257251027995e-15, -9.600991002558272e-17,
  1.947349473801476e-18, -3.626231005893169e-20,  6.263818636462562e-22, -1.011745976833705e-23,  1.811166275375421e-07, -2.315234552260863e-08,  1.575969825439528e-09,
 -7.533088260527583e-11,  2.827034325072243e-12, -8.844560572407448e-14,  2.394262227458852e-15, -5.751253978387641e-17,  1.248291778593682e-18, -2.481638967097034e-20,
  4.566813878280008e-22, -7.843037930851160e-24,  5.898477764085232e-08, -8.272426114317527e-09,  6.144465519225262e-10, -3.189136829605371e-11,  1.294132222533752e-12,
 -4.362252031807834e-14,  1.268330741175074e-15, -3.263226780518286e-17,  7.567453776793762e-19, -1.603802003589605e-20,  3.139933398424192e-22, -5.726156798963333e-24,
  1.858578585748075e-08, -2.848092452925279e-09,  2.301059314296697e-10, -1.293412248595658e-11,  5.662433779108713e-13, -2.052338344692850e-14,  6.397489803263107e-16,
 -1.760060410217388e-17,  4.354232233652659e-19, -9.823512496913604e-21,  2.043350501484666e-22, -3.951822453722045e-24,  5.684511083111861e-09, -9.481184329182099e-10,
  8.306824547099413e-11, -5.043723705527502e-12,  2.376896294915689e-13, -9.245034948400115e-15,  3.084099753177553e-16, -9.058037145226161e-18,  2.386907665343290e-19,
 -5.724311141688886e-21,  1.263335814271739e-22, -2.587773599465965e-24,  1.693693881018455e-09, -3.063310078026264e-10,  2.901884394021371e-11, -1.898513392884030e-12,
  9.609702013085681e-14, -4.003182834966496e-15,  1.426614736522963e-16, -4.465641919337779e-18,  1.251516717493334e-19, -3.185895493422884e-21,  7.449992008694730e-23,
 -1.614183732547083e-24,  4.935392380903530e-10, -9.645231104686063e-11,  9.850726312008906e-12, -6.926996375410102e-13,  3.757758541594998e-14, -1.673269787698387e-15,
  6.358677141902964e-17, -2.117838026372864e-18,  6.302638478168089e-20, -1.700553718703520e-21,  4.207682259584420e-23, -9.630671861959183e-25,  1.412652866433303e-10,
 -2.972716016486581e-11,  3.263978359452462e-12, -2.460939164194868e-13,  1.427650254067752e-14, -6.781696312689300e-16,  2.743131148329870e-17, -9.704788558973186e-19,
  3.061993919655235e-20, -8.743722228877613e-22,  2.285922360809777e-23, -5.519538479347107e-25,  3.990556241291784e-11, -9.011590905810574e-12,  1.060761432666141e-12,
 -8.554252103226329e-14,  5.295189232640990e-15, -2.677947786098304e-16,  1.150824725133969e-17, -4.317261344909218e-19,  1.441806122844552e-20, -4.350639800815902e-22,
  1.200034657871395e-23, -3.052477140531242e-25,  1.118290224502306e-11, -2.700941362814711e-12,  3.398920517753870e-13, -2.924434988609247e-14,  1.927286327473337e-15,
 -1.035561260222828e-16,  4.719001853301992e-18, -1.873829477705100e-19,  6.612631438750247e-21, -2.105125630602851e-22,  6.116879181869672e-24, -1.636696559452360e-25,
  3.126244035388249e-12, -8.048740578050274e-13,  1.079802763777872e-13, -9.887625400649410e-15,  6.921575401201849e-16, -3.942951452905904e-17,  1.901523848263537e-18,
 -7.977228329265256e-20,  2.969441467031585e-21, -9.956479885797134e-23,  3.042783599492864e-24, -8.551016339498010e-26,  8.770962090278189e-13, -2.399103006734161e-13,
  3.421543462311051e-14, -3.325846132484889e-15,  2.467161723147192e-16, -1.486774161069375e-17,  7.572398282264595e-19, -3.349695257925335e-20,  1.312804416351876e-21,
 -4.627948908966724e-23,  1.485009946070362e-24, -4.375960724983624e-26,  2.485504748440697e-13, -7.198759583358798e-14,  1.088253055947133e-14, -1.119943981914614e-15,
  8.782344953802891e-17, -5.585878765812413e-18,  2.998102594612243e-19, -1.395552138415212e-20,  5.747252302298534e-22, -2.126130877597758e-23,  7.150264732950315e-25,
 -2.205496666796122e-26,  7.162689779696267e-14, -2.189230843356392e-14,  3.497627019950031e-15, -3.800493147820592e-16,  3.142417426230078e-17, -2.104421202236009e-18,
  1.187577357064240e-19, -5.804212199203273e-21,  2.506522819815973e-22, -9.711209134924266e-24,  3.416328031487057e-25, -1.100967372454160e-26,  2.114087800852143e-14,
 -6.795518481573461e-15,  1.143893454178011e-15, -1.308633834231807e-16,  1.137863569599008e-17, -8.002859498129728e-19,  4.736949046002763e-20, -2.425253349008407e-21,
  1.095809325296526e-22, -4.436900802232219e-24,  1.629384487289138e-25, -5.475209452543916e-27,  6.437968514372178e-15, -2.168809038163767e-15,  3.834338745210070e-16,
 -4.604689855811086e-17,  4.198549987543243e-18, -3.092974909524271e-19,  1.915313562949200e-20, -1.024719989421747e-21,  4.832836954730884e-23, -2.040306303599371e-24,
  7.804316371674025e-26, -2.728609454181345e-27,  2.037955382953477e-15, -7.169732371899418e-16,  1.326940066334047e-16, -1.667587011262002e-17,  1.589743564550611e-18,
 -1.223188123761422e-19,  7.902817443745678e-21, -4.406693141233888e-22,  2.163848195823908e-23, -9.501725809563605e-25,  3.776631947605495e-26, -1.370684898068526e-27,
  6.755700678428700e-16, -2.473147969887395e-16,  4.775223410259171e-17, -6.259525357280380e-18,  6.219576239835082e-19, -4.983206760050075e-20,  3.349363939510138e-21,
 -1.941068815359996e-22,  9.896767656496938e-24, -4.508262648386288e-25,  1.857228434387011e-26, -6.979869181896535e-28,  2.361801583688557e-16, -8.964014121225833e-17,
  1.799272250322548e-17, -2.451700399551237e-18,  2.530655250193648e-19, -2.104638046854702e-20,  1.467085143897756e-21, -8.810153025898470e-23,  4.650668069959491e-24,
 -2.191537431521389e-25,  9.331915805691949e-27, -3.621981840295312e-28,  8.763515671996203e-17, -3.435563521201125e-17,  7.142267412886852e-18, -1.008017739829069e-18,
  1.077126702459328e-19, -9.267035759447146e-21,  6.677602604936126e-22, -4.142067747740575e-23,  2.256767049111194e-24, -1.096814617913310e-25,  4.813391743212064e-27,
 -1.923909238989077e-28,  3.468948256582351e-17, -1.399373627233684e-17,  3.001551493423177e-18, -4.371231926121694e-19,  4.817735635134096e-20, -4.272657260532085e-21,
  3.171567239886225e-22, -2.025230936688931e-23,  1.135158767852916e-24, -5.671899056039681e-26,  2.557353662853032e-27, -1.049460556238616e-28,  1.469261504608003e-17,
 -6.075527126457787e-18,  1.339180243930296e-18, -2.004539096017078e-19,  2.269988288091957e-20, -2.067429765584787e-21,  1.575126909839963e-22, -1.031748488585593e-23,
  5.928729567359710e-25, -3.035220550898854e-26,  1.401408886648981e-27, -5.885557371445779e-29,  6.653878054315414e-18, -2.809449855169624e-18,  6.337682874636303e-19,
 -9.710589436190655e-20,  1.125330053733929e-20, -1.048415982486886e-21,  8.167000929868289e-23, -5.467067447368815e-24,  3.208955108894595e-25, -1.677271373059168e-26,
  7.902820022637809e-28, -3.385190851032583e-29,  3.197600364783416e-18, -1.373180992186379e-18,  3.156821132156082e-19, -4.930188439963686e-20,  5.822513478591477e-21,
 -5.526311052604511e-22,  4.384023444036568e-23, -2.987466268216415e-24,  1.784343379143288e-25, -9.486657987863930e-27,  4.544838325308687e-28, -1.978612769836204e-29,
  1.594462663085461e-18, -6.936764930598559e-19,  1.618101802424781e-19, -2.564612896355851e-20,  3.073335246755115e-21, -2.959167851466886e-22,  2.380775802749937e-23,
 -1.644863897230715e-24,  9.957604260071061e-26, -5.364234734436453e-27,  2.603162884497149e-28, -1.147595992161484e-29,  7.744754802214468e-19, -3.399859056108844e-19,
  8.011502795565568e-20, -1.282898029632994e-20,  1.553110139354570e-21, -1.510467414550461e-22,  1.227226251856654e-23, -8.560724871358667e-25,  5.231406247714024e-26,
 -2.844219696028047e-27,  1.392702280950304e-28, -6.193664939347488e-30,  2.859765204339005e-19, -1.261710113832221e-19,  2.989987330337950e-20, -4.815466958015001e-21,
  5.862973561346526e-22, -5.733984248761279e-23,  4.684379772138498e-24, -3.285264655962517e-25,  2.018179384947314e-26, -1.102897477104125e-27,  5.427635761569042e-29,
 -2.425631035557885e-30,  5.470721901963745e-02, -1.233453878409881e-04,  2.872535498215353e-07, -6.876522259693938e-10,  1.681964759889888e-12, -4.179648924428177e-15,
  1.049664472046245e-17, -2.654081559867548e-20,  6.733930274060729e-23, -1.711542536983621e-25,  4.348708787660639e-28, -1.104399472849269e-30,  5.154939092067077e-02,
 -1.416541029242827e-04,  4.598113016432441e-07, -1.567681787830342e-09,  5.335774651346633e-12, -1.787090224010669e-14,  5.878598872353244e-17, -1.902177131103973e-19,
  6.066607976427877e-22, -1.910583412569615e-24,  5.950244163032764e-27, -1.834775368333647e-29,  4.577261154900126e-02, -1.709858040387049e-04,  7.774823435542493e-07,
 -3.447215745995592e-09,  1.457861177591806e-11, -5.928365017421732e-14,  2.336638034008978e-16, -8.976217190407400e-19,  3.373782874530103e-21, -1.244231036715536e-23,
  4.512337910501788e-26, -1.612063269726838e-28,  3.830364755997659e-02, -1.999295131218550e-04,  1.184028537666535e-06, -6.417075048674354e-09,  3.243660830700280e-11,
 -1.557509235174834e-13,  7.181378447971178e-16, -3.201881283808474e-18,  1.387379700331402e-20, -5.864354145548037e-23,  2.425291820510436e-25, -9.836675412585756e-28,
  3.021351344058959e-02, -2.176336487344187e-04,  1.598624297292650e-06, -1.033533118704321e-08,  6.140116347499169e-11, -3.427153996416240e-13,  1.820356680711447e-15,
 -9.280852144623152e-18,  4.570199251810868e-20, -2.183928811452480e-22,  1.016444595626054e-24, -4.620892214436725e-27,  2.246930743223986e-02, -2.177378194659851e-04,
  1.931680088662962e-06, -1.470332188142777e-08,  1.014414097783525e-10, -6.504768249745049e-13,  3.935813677017769e-15, -2.270308665693211e-17,  1.257742175282695e-19,
 -6.729127539523082e-22,  3.491784107597540e-24, -1.763298533816561e-26,  1.575918928174659e-02, -1.999287380094257e-04,  2.109787169284470e-06, -1.872311040163429e-08,
  1.485722460877383e-10, -1.084565007264763e-12,  7.411924040797284e-15, -4.798412234930090e-17,  2.967743907434219e-19, -1.764650445432580e-21,  1.013704155433648e-23,
 -5.647424759127450e-26,  1.042777235740240e-02, -1.689017347038001e-04,  2.098684060141832e-06, -2.153529311977687e-08,  1.949996729162929e-10, -1.608741206909597e-12,
  1.233335964538920e-14, -8.903815083530162e-17,  6.110442616768912e-19, -4.014464379032685e-21,  2.538619363417901e-23, -1.551795224397389e-25,  6.512562827684172e-03,
 -1.317476451840119e-04,  1.912261570473750e-06, -2.252535608545911e-08,  2.312096324112791e-10, -2.142764350190792e-12,  1.832540502393856e-14, -1.467508627390023e-16,
  1.111891429918190e-18, -8.032521243679386e-21,  5.565850959468886e-23, -3.716444012679599e-25,  3.840946265426728e-03, -9.522307976847562e-05,  1.603285918510763e-06,
 -2.154166197030817e-08,  2.492351200738448e-10, -2.581479135810369e-12,  2.451141426098306e-14, -2.167646307452230e-16,  1.805574025497490e-18, -1.428503784304900e-20,
  1.080394182534315e-22, -7.850699592138931e-25,  2.140477073034307e-03, -6.398110629774283e-05,  1.241612097824014e-06, -1.892004897975131e-08,  2.455290543132037e-10,
 -2.829565482283043e-12,  2.970676416145300e-14, -2.889990396752918e-16,  2.636852581681557e-18, -2.276769949506408e-20,  1.873239094862402e-22, -1.476569027156109e-24,
  1.127896936455564e-03, -4.008223345289129e-05,  8.910677388514609e-07, -1.532085972296734e-08,  2.220267175589333e-10, -2.835761663944758e-12,  3.279976516518727e-14,
 -3.498379427484924e-16,  3.485259643245134e-18, -3.274300273852385e-20,  2.922161540385880e-22, -2.491635268899468e-24,  5.624182659103496e-04, -2.347488432438114e-05,
  5.944073784034326e-07, -1.147777741278998e-08,  1.850105917397334e-10, -2.609601870149585e-12,  3.314657036370242e-14, -3.864436887387724e-16,  4.191853918475649e-18,
 -4.273406737761048e-20,  4.126267405836357e-22, -3.796521244662424e-24,  2.656280530157102e-04, -1.288476343915728e-05,  3.695819946398327e-07, -7.980164697649909e-09,
  1.425575231087530e-10, -2.213536924782798e-12,  3.078555274127193e-14, -3.912659807515446e-16,  4.609376093280663e-18, -5.086878420151467e-20,  5.301954491957595e-22,
 -5.252381916377896e-24,  1.189487985865454e-04, -6.643233900168924e-06,  2.147498604445188e-07, -5.164424282573365e-09,  1.019021047182876e-10, -1.736674646850684e-12,
  2.637643107638193e-14, -3.645439185195182e-16,  4.653398419850752e-18, -5.547224505602114e-20,  6.228192657422396e-22, -6.629966910484231e-24,  5.056199909972238e-05,
 -3.224679897713475e-06,  1.169111138164052e-07, -3.119661978246601e-09,  6.777906732805398e-11, -1.264395705582907e-12,  2.091937900903585e-14, -3.136955872546956e-16,
  4.329746445501280e-18, -5.564167489840010e-20,  6.716869710661558e-22, -7.669358814337166e-24,  2.042860157936165e-05, -1.476931047124687e-06,  5.978179750471593e-08,
 -1.763831425413212e-09,  4.207270993484378e-11, -8.569023313568432e-13,  1.540883407251597e-14, -2.501744438271708e-16,  3.726338532605388e-18, -5.152933032376872e-20,
  6.676440772300179e-22, -8.163128967478779e-24,  7.856845138189189e-06, -6.396942722486673e-07,  2.878488966174573e-08, -9.359431193340613e-10,  2.444268724749728e-11,
 -5.422251141222386e-13,  1.057441156104964e-14, -1.855191971246630e-16,  2.976605445204628e-18, -4.421652203345412e-20,  6.138965162154295e-22, -8.025178379081328e-24,
  2.881233021517356e-06, -2.626175097821807e-07,  1.308442441635011e-08, -4.673834936915641e-10,  1.332881446258105e-11, -3.213165367880004e-13,  6.782092457098309e-15,
 -1.283363193977546e-16,  2.214260386459093e-18, -3.527639487330900e-20,  5.240278815175621e-22, -7.313616973569833e-24,  1.009354741252284e-06, -1.024376746882731e-07,
  5.629725541359764e-09, -2.202646188141796e-10,  6.842222147375044e-12, -1.788571600251868e-13,  4.078011650389953e-15, -8.308454338411473e-17,  1.538993664258177e-18,
 -2.625556915619118e-20,  4.167019547011352e-22, -6.200488140405704e-24,  3.384992074225145e-07, -3.806169717956079e-08,  2.299122888745762e-09, -9.824786817902424e-11,
  3.316429195152297e-12, -9.380848290543642e-14,  2.306146629512841e-15, -5.050198115163331e-17,  1.002727037395236e-18, -1.829201553306099e-20,  3.097427559540798e-22,
 -4.907437107041750e-24,  1.089285425135378e-07, -1.350809080482664e-08,  8.938124660824575e-10, -4.160327761737006e-11,  1.522542235493952e-12, -4.650808076066050e-14,
  1.230534363466609e-15, -2.891697954181333e-17,  6.145081888185994e-19, -1.196980923710768e-20,  2.159655348892124e-22, -3.638662748565524e-24,  3.372386926211256e-08,
 -4.592560105887532e-09,  3.318097133741923e-10, -1.677844987341377e-11,  6.642297416970566e-13, -2.186829011965348e-14,  6.216396320979066e-16, -1.565096688411952e-17,
  3.554472245127237e-19, -7.382728012128989e-21,  1.417451072005203e-22, -2.536491106173662e-24,  1.007436101789914e-08, -1.500570110476674e-09,  1.180149266298888e-10,
 -6.466659117861519e-12,  2.763290251015737e-13, -9.786518357165603e-15,  2.983751153763628e-16, -8.035732591431325e-18,  1.947544273564297e-19, -4.307463962212951e-21,
  8.789242640010864e-23, -1.668462568259862e-24,  2.913387626731146e-09, -4.728318169897270e-10,  4.035982391824598e-11, -2.390568165085625e-12,  1.100275652027979e-13,
 -4.183964631542988e-15,  1.365817848724281e-16, -3.928607539669975e-18,  1.014614559334781e-19, -2.386389743751360e-21,  5.168407831848553e-23, -1.039525863974096e-24,
  8.185628222390954e-10, -1.442288809038456e-10,  1.332333737269207e-11, -8.509903521417912e-13,  4.209829056712877e-14, -1.715619484910953e-15,  5.986291569750791e-17,
 -1.836152752230660e-18,  5.045945509264950e-20, -1.260373769527589e-21,  2.893636433885207e-23, -6.158939778774684e-25,  2.243467848021918e-10, -4.276529544355725e-11,
  4.263414285901972e-12, -2.929506471763514e-13,  1.554406001531396e-14, -6.776032491438716e-16,  2.522910830516193e-17, -8.238980268517229e-19,  2.405699038047707e-20,
 -6.372595767879203e-22,  1.548904064801432e-23, -3.484418828386142e-25,  6.024541456176656e-11, -1.238195796763588e-11,  1.328521252518100e-12, -9.797225794009616e-14,
  5.564064507199477e-15, -2.589613258821816e-16,  1.027064227697623e-17, -3.565270907192070e-19,  1.104442558610090e-20, -3.098299371783286e-22,  7.961852402468080e-24,
 -1.890639134557347e-25,  1.592865960208840e-11, -3.517951645943164e-12,  4.051361276898719e-13, -3.198927126650717e-14,  1.940404035758417e-15, -9.623427887616183e-17,
  4.058431685249586e-18, -1.495064857917886e-19,  4.905932936650703e-21, -1.455367764811869e-22,  3.948604572969927e-24, -9.884394328995247e-26,  4.168719001946094e-12,
 -9.861145758788981e-13,  1.215599167143198e-13, -1.025236355666599e-14,  6.627865546849793e-16, -3.495812183310075e-17,  1.564759488414400e-18, -6.106800380391983e-20,
  2.119275236348815e-21, -6.638155453805632e-23,  1.898751152039606e-24, -5.003588432009862e-26,  1.086226933547241e-12, -2.743055267302506e-13,  3.609615709930282e-14,
 -3.243905040030044e-15,  2.230068827249759e-16, -1.248368075877605e-17,  5.919528759789016e-19, -2.443104291019092e-20,  8.951477974025933e-22, -2.955746459735286e-23,
  8.899640047729787e-25, -2.465208699228051e-26,  2.835775102533275e-13, -7.619854240609087e-14,  1.067406696493095e-14, -1.019593698336143e-15,  7.436758206770785e-17,
 -4.408946181298694e-18,  2.210340971377013e-19, -9.629126098848236e-21,  3.718300502212946e-22, -1.292085080276066e-23,  4.088596147575043e-25, -1.188618123218808e-26,
  7.468004243877931e-14, -2.128138705083556e-14,  3.164507567894722e-15, -3.204603353512156e-16,  2.474014088808757e-17, -1.549931038227013e-18,  8.197948736240171e-20,
 -3.762196800851930e-21,  1.528203004020496e-22, -5.578465212683475e-24,  1.851910514381615e-25, -5.640864799742343e-27,  1.998324661885780e-14, -6.018968952947840e-15,
  9.472857472948980e-16, -1.014276920964398e-16,  8.267446602779987e-18, -5.460349244856222e-19,  3.040292467053155e-20, -1.466697763243892e-21,  6.254359750116904e-23,
 -2.393646634987802e-24,  8.321001332570009e-26, -2.650781291051224e-27,  5.474960310783207e-15, -1.737050166720449e-15,  2.884754126386616e-16, -3.256681011723920e-17,
  2.795341743138620e-18, -1.941519683667985e-19,  1.135298702301646e-20, -5.744353097496491e-22,  2.565918897463068e-23, -1.027439347829674e-24,  3.732558670901975e-26,
 -1.241166008269062e-27,  1.548160741507592e-15, -5.155930975457898e-16,  9.006854727292356e-17, -1.068938567041010e-17,  9.634946584530858e-19, -7.018826847359627e-20,
  4.299395115162717e-21, -2.276092011842166e-22,  1.062519224378176e-23, -4.441274843475562e-25,  1.682468696182175e-26, -5.827440263686165e-28,  4.555390055778911e-16,
 -1.586817037405346e-16,  2.906262586332891e-17, -3.614774148951953e-18,  3.411405187644038e-19, -2.599149995040228e-20,  1.663306647585859e-21, -9.189119852034130e-23,
  4.471708800609513e-24, -1.946460422798333e-25,  7.670974964934514e-27, -2.761185861216023e-28,  1.406279434435559e-16, -5.105025919046320e-17,  9.769100304329718e-18,
 -1.269246191352084e-18,  1.250236828689351e-19, -9.932649674200005e-21,  6.621312452955839e-22, -3.806695438913922e-23,  1.925854495512132e-24, -8.706758774291006e-26,
  3.560580378561430e-27, -1.328633017916458e-28,  4.591019605494228e-17, -1.730369479293323e-17,  3.447312961298467e-18, -4.662455618675628e-19,  4.777588757633939e-20,
 -3.945122859475710e-21,  2.731041438325272e-22, -1.629028565480347e-23,  8.543063944382520e-25, -4.000172910157923e-26,  1.692809891974551e-27, -6.530859499983090e-29,
  1.596685385828708e-17, -6.224362601085641e-18,  1.286132842528738e-18, -1.804164691986733e-19,  1.916382482954636e-20, -1.639175981101561e-21,  1.174465793499372e-22,
 -7.244996738445395e-24,  3.926214886434637e-25, -1.898236959218078e-26,  8.288194028006530e-28, -3.296473182004469e-29,  5.951971785185579e-18, -2.390510037940836e-18,
  5.102944532943042e-19, -7.395979908167795e-20,  8.113111570188067e-21, -7.162129392017671e-22,  5.292589629823680e-23, -3.364885594523326e-24,  1.878038702664718e-25,
 -9.344977082651570e-27,  4.196533131294208e-28, -1.715407120810759e-29,  2.387668262370078e-18, -9.840899670531643e-19,  2.161337018698686e-19, -3.223484678091042e-20,
  3.637367744573276e-21, -3.301269726344517e-22,  2.506626730123292e-23, -1.636476676381144e-24,  9.373402084503486e-26, -4.783684816875461e-27,  2.201963057674116e-28,
 -9.220280763128209e-30,  1.031064119870337e-18, -4.343367988100986e-19,  9.772852671140583e-20, -1.493536133056326e-20,  1.726416687626776e-21, -1.604420683139142e-22,
  1.246786061485102e-23, -8.326356346643019e-25,  4.875979786141024e-26, -2.542876905322016e-27,  1.195510286235469e-28, -5.110118081374666e-30,  4.761052675037521e-19,
 -2.041499282792155e-19,  4.685309187668663e-20, -7.304876218236885e-21,  8.612527433564067e-22, -8.160952830298845e-23,  6.463686133537509e-24, -4.397736883099047e-25,
  2.622651185531912e-26, -1.392284610572923e-27,  6.660431593580523e-29, -2.895554195799844e-30,  2.300677526715910e-19, -1.000029892818220e-19,  2.330395276189275e-20,
 -3.689851151324782e-21,  4.417384707057809e-22, -4.249141476546031e-23,  3.415352755709140e-24, -2.357447732624933e-25,  1.425842751991202e-26, -7.674299548223030e-28,
  3.720967601516660e-29, -1.638993987087849e-30,  1.092961772814957e-19, -4.795833109827324e-20,  1.129530908156237e-20, -1.807815955722213e-21,  2.187480326363724e-22,
 -2.126358940854767e-23,  1.726781071426325e-24, -1.203968021949853e-25,  7.353922312848380e-27, -3.996357209262313e-28,  1.955979725163013e-29, -8.694877800744778e-31,
  3.985598062818477e-20, -1.758068963309452e-20,  4.165306454826760e-21, -6.706798641502007e-22,  8.163835733395266e-23, -7.982395688895314e-24,  6.519744401701967e-25,
 -4.571428882908467e-26,  2.807669463363349e-27, -1.534007395027247e-28,  7.547629804116016e-30, -3.372360310504072e-31,  5.421838190111044e-02, -1.210799155202233e-04,
  2.791604768163986e-07, -6.613960943738392e-10,  1.600832016271573e-12, -3.936409241817350e-15,  9.782767000683555e-18, -2.448127829362449e-20,  6.147949609256679e-23,
 -1.546930339050807e-25,  3.891067604288899e-28, -9.785068384737503e-31,  5.099001435972483e-02, -1.380494365808169e-04,  4.414998032176676e-07, -1.485093853041710e-09,
  4.992044903509206e-12, -1.652181992647692e-14,  5.372165529939597e-17, -1.718606606867669e-19,  5.419763965810494e-22, -1.687958136807377e-24,  5.199151769797278e-27,
 -1.585717444925975e-29,  4.510085154377207e-02, -1.649275344367760e-04,  7.374771382876802e-07, -3.223146975063904e-09,  1.344704361641527e-11, -5.396552195279583e-14,
  2.099769177426510e-16, -7.964924936835127e-19,  2.956709561373828e-21, -1.077156394807407e-23,  3.859559760340351e-26, -1.362513522482401e-28,  3.752239841740458e-02,
 -1.907567124704923e-04,  1.110037708116836e-06, -5.922102615452733e-09,  2.948693228549420e-11, -1.395431655191946e-13,  6.343961253315605e-16, -2.789907591724059e-18,
  1.192730365420821e-20, -4.975535661442010e-23,  2.031195375830154e-25, -8.133695208250337e-28,  2.936779425938951e-02, -2.053245550688258e-04,  1.480276097310733e-06,
 -9.405458761154911e-09,  5.496351635515122e-11, -3.019869408299736e-13,  1.579839095348164e-15, -7.936716695119194e-18,  3.852521641036638e-20, -1.815268268906216e-22,
  8.332886132392808e-25, -3.737230393187310e-27,  2.162818327401041e-02, -2.029635025648649e-04,  1.764565340134538e-06, -1.317941154444052e-08,  8.932723683642548e-11,
 -5.632121905465689e-13,  3.353016042193773e-15, -1.904040003990720e-17,  1.038870909141883e-19, -5.476046958032098e-22,  2.800477511531787e-24, -1.394145495067009e-26,
  1.499186292272630e-02, -1.839103262405208e-04,  1.898687071878980e-06, -1.651025794352835e-08,  1.285562865670430e-10, -9.217843763693521e-13,  6.192304266163803e-15,
 -3.943013598913336e-17,  2.399840500940142e-19, -1.404826009905867e-21,  7.947686312737925e-24, -4.361987210377091e-26,  9.784179463905300e-03, -1.530952612323794e-04,
  1.857968614254884e-06, -1.865742378024338e-08,  1.655937935894547e-10, -1.340574705296898e-12,  1.009363652862510e-14, -7.161370062873630e-17,  4.832675346258001e-19,
 -3.123502559415175e-21,  1.943961901133616e-23, -1.169919538175884e-25,  6.014541182860236e-03, -1.174709890949803e-04,  1.662812953872169e-06, -1.914627594482951e-08,
  1.924393103462238e-10, -1.748494907795889e-12,  1.467392391240050e-14, -1.153974504381883e-16,  8.591431663937169e-19, -6.101929961443545e-21,  4.158659767817787e-23,
 -2.732292684090984e-25,  3.484160137379194e-03, -8.336672621826397e-05,  1.367106937950050e-06, -1.793692576789199e-08,  2.030284841971955e-10, -2.059956102621775e-12,
  1.917916798716983e-14, -1.664435626480727e-16,  1.361435953804904e-18, -1.058302606546324e-20,  7.868066593747499e-23, -5.622605411229315e-25,  1.903069431561147e-03,
 -5.489365022198206e-05,  1.036393142755862e-06, -1.540816591046929e-08,  1.954581605943719e-10, -2.204880583140236e-12,  2.268250046550279e-14, -2.164060126047045e-16,
  1.937766471258922e-18, -1.642999988810070e-20,  1.328129209983455e-22, -1.029033359885157e-24,  9.807406074402094e-04, -3.363274967973692e-05,  7.267903474872056e-07,
 -1.218250013137715e-08,  1.724507836372360e-10, -2.154523667523598e-12,  2.440341524662689e-14, -2.551120467115216e-16,  2.492903764121617e-18, -2.298637496032907e-20,
  2.014546851116462e-22, -1.687684506748517e-24,  4.772230827268904e-04, -1.922393872640922e-05,  4.728433068517678e-07, -8.895344502487546e-09,  1.399699722818195e-10,
 -1.930086732987611e-12,  2.399376957031018e-14, -2.740341937725923e-16,  2.914203256279996e-18, -2.914550647697455e-20,  2.762422804737986e-22, -2.496191344651156e-24,
  2.194464321786443e-04, -1.027550084819153e-05,  2.861651439930503e-07, -6.016711176864843e-09,  1.048673846377458e-10, -1.591037749983906e-12,  2.164656030490490e-14,
 -2.693864767078445e-16,  3.109968421389987e-18, -3.365697692394682e-20,  3.442167274446963e-22, -3.347791928236287e-24,  9.545527647368952e-05, -5.147842371542991e-06,
  1.615157777609429e-07, -3.780653459915656e-09,  7.275188551633691e-11, -1.210986841421080e-12,  1.798494260706680e-14, -2.432973624425968e-16,  3.042355848122869e-18,
 -3.555304336218330e-20,  3.915575667706023e-22, -4.090912814421573e-24,  3.932046277741343e-05, -2.422457267939584e-06,  8.522829276815748e-08, -2.212948054288501e-09,
  4.687402880204019e-11, -8.537565706800174e-13,  1.380796253426991e-14, -2.026036007377115e-16,  2.738568975367194e-18, -3.449055308870798e-20,  4.083045389252469e-22,
 -4.574501927270989e-24,  1.535792476533341e-05, -1.073079657063874e-06,  4.214836346666586e-08, -1.209838830845335e-09,  2.812837107264377e-11, -5.592203089576030e-13,
  9.827512279571222e-15, -1.560880918284003e-16,  2.276308007797838e-18, -3.084228869410496e-20,  3.918002204146473e-22, -4.699591311102100e-24,  5.695897003307697e-06,
 -4.484346521120523e-07,  1.958247038935811e-08, -6.194169042980227e-10,  1.576523775944090e-11, -3.413273313025007e-13,  6.504259369966212e-15, -1.116120806400362e-16,
  1.753053401901233e-18, -2.551142315409059e-20,  3.472239260264085e-22, -4.452401700582210e-24,  2.009132596441301e-06, -1.771875566816563e-07,  8.568945663488279e-09,
 -2.977806924105169e-10,  8.276000360161945e-12, -1.947035573411130e-13,  4.015309606645513e-15, -7.430993275342582e-17,  1.254984556063700e-18, -1.958539143998909e-20,
  2.851879861681175e-22, -3.903928227552570e-24,  6.752476983424449e-07, -6.635235755148307e-08,  3.540640746735493e-09, -1.347894790185972e-10,  4.080800518028067e-12,
 -1.041066112755288e-13,  2.319189862196654e-15, -4.621103996297210e-17,  8.378530712435942e-19, -1.400178248323748e-20,  2.178257931044164e-22, -3.179049775410344e-24,
  2.166790507542295e-07, -2.360774092125517e-08,  1.385181159023112e-09, -5.760971752097241e-11,  1.895633876027928e-12, -5.233616288389467e-14,  1.257191853422773e-15,
 -2.692723381199171e-17,  5.233568830894413e-19, -9.352581893930273e-21,  1.552443802329426e-22, -2.412572866720967e-24,  6.653842389362523e-08, -8.001904556607685e-09,
  5.145736278095178e-10, -2.331916005948635e-11,  8.321139678540332e-13, -2.481479701885114e-14,  6.416647987476209e-16, -1.475038072127907e-17,  3.068812851144540e-19,
 -5.856538703419727e-21,  1.035945154774452e-22, -1.712213230989381e-24,  1.960449464740033e-08, -2.591406443296531e-09,  1.820694949509077e-10, -8.967755332257844e-12,
  3.462883600289150e-13, -1.113363146013351e-14,  3.093919167279082e-16, -7.621690373507366e-18,  1.695014014813015e-19, -3.449973977698310e-21,  6.495180151883517e-23,
 -1.140416513822373e-24,  5.558127187610673e-09, -8.043705739669533e-10,  6.156174031505914e-11, -3.287608932784446e-12,  1.370932993282422e-13, -4.743456453571058e-15,
  1.414271943429925e-16, -3.728011516984824e-18,  8.850313312912007e-20, -1.918747355278463e-21,  3.840168565774347e-23, -7.154465171193930e-25,  1.521259699821616e-09,
 -2.401375258217451e-10,  1.996288981473250e-11, -1.153150760369410e-12,  5.182268917284798e-14, -1.926189494907318e-15,  6.151803119854472e-17, -1.732644425314854e-18,
  4.384898437286012e-20, -1.011308959222368e-21,  2.149088132684333e-23, -4.243673187290900e-25,  4.034200469018187e-10, -6.921466950670167e-11,  6.232550322178192e-12,
 -3.885208341741696e-13,  1.877903678819995e-14, -7.484779331252191e-16,  2.556521468444527e-17, -7.682097688799571e-19,  2.069695865433412e-20, -5.071569679396978e-22,
  1.142954046156443e-23, -2.389354136824384e-25,  1.040753428814506e-10, -1.934125741414353e-11,  1.881404494875398e-12, -1.262766170957228e-13,  6.551475570947899e-15,
 -2.795096566557076e-16,  1.019369568299367e-17, -3.263170632773319e-19,  9.346381124823132e-21, -2.430127210632774e-22,  5.800972756392567e-24, -1.282362767498805e-25,
  2.623773946528155e-11, -5.263972201099671e-12,  5.516788708419241e-13, -3.977697383765174e-14,  2.210724850954903e-15, -1.007771648334352e-16,  3.917851373914331e-18,
 -1.334060204410830e-19,  4.056416904440940e-21, -1.117638313956723e-22,  2.822364266642697e-24, -6.589623777859928e-26,  6.496127763128699e-12, -1.402407561304512e-12,
  1.579347040559507e-13, -1.220499581752906e-14,  7.251819235656034e-16, -3.525714789932406e-17,  1.458655814017331e-18, -5.274991094562253e-20,  1.700271135265164e-21,
 -4.957381979727899e-23,  1.322626483265956e-24, -3.257465934908564e-26,  1.588240901981661e-12, -3.677613594110292e-13,  4.438691110438215e-14, -3.667994878670495e-15,
  2.325124364206796e-16, -1.203372063918613e-17,  5.288947558788641e-19, -2.028032877329379e-20,  6.918929966384416e-22, -2.131684050199561e-23,  6.000473275083334e-25,
 -1.556871102029328e-26,  3.857709976059697e-13, -9.550156832619819e-14,  1.232052634960875e-14, -1.086165169272075e-15,  7.329882909814339e-17, -4.030462552034603e-18,
  1.878447507094608e-19, -7.624349322948203e-21,  2.748763289143963e-22, -8.935311284116154e-24,  2.649838996695355e-25, -7.232778246428826e-27,  9.370280332007935e-14,
 -2.472059710645351e-14,  3.399627940705137e-15, -3.189632292748622e-16,  2.286473395387244e-17, -1.333030743877210e-18,  6.575510858984908e-20, -2.820007055300167e-21,
  1.072545166283155e-22, -3.672586010857780e-24,  1.145658327587877e-25, -3.284812227386716e-27,  2.292377150861164e-14, -6.423854043792135e-15,  9.391062367625987e-16,
 -9.353573724634837e-17,  7.105983294341167e-18, -4.383077272648135e-19,  2.283676671250171e-20, -1.032858325166279e-21,  4.136624928013958e-23, -1.489467319663737e-24,
  4.879357931686777e-26, -1.467197673211032e-27,  5.692020195416902e-15, -1.688621107455231e-15,  2.616677110692032e-16, -2.759491958530334e-17,  2.216359773751140e-18,
 -1.443060765136096e-19,  7.924450089346470e-21, -3.771985962449630e-22,  1.587687724081327e-23, -6.000166213330388e-25,  2.060438228079223e-26, -6.486319585865964e-28,
  1.446266160367817e-15, -4.526799322612633e-16,  7.413272542383495e-17, -8.254856844527316e-18,  6.991429463303421e-19, -4.793390439883129e-20,  2.767911286921982e-21,
 -1.383532529948650e-22,  6.107388495489536e-24, -2.417597988804262e-25,  8.685476446328794e-27, -2.857070201414736e-28,  3.792901596489219e-16, -1.248174223267079e-16,
  2.153462759343845e-17, -2.524611215587517e-18,  2.248563451900072e-19, -1.619134809369674e-20,  9.807021478097165e-22, -5.135414968380322e-23,  2.372016863034357e-24,
 -9.813351696173386e-26,  3.680553749584745e-27, -1.262496477591025e-28,  1.035879863677007e-16, -3.571207266792007e-17,  6.469873240858396e-18, -7.961065794113878e-19,
  7.434714208668167e-20, -5.606975087585654e-21,  3.552736703003661e-22, -1.943939411415714e-23,  9.371759908576813e-25, -4.042483405864525e-26,  1.579137079877712e-27,
 -5.635672250471920e-29,  2.972947670637269e-17, -1.069773027661636e-17,  2.028109965515757e-18, -2.610729533394436e-19,  2.548454976297548e-20, -2.006883968403559e-21,
  1.326417862432586e-22, -7.562563108157627e-24,  3.795173332189780e-25, -1.702358983758728e-26,  6.908718813989927e-28, -2.558954148862874e-29,  9.046188486650060e-18,
 -3.384694407997498e-18,  6.690505696963903e-19, -8.978635349466137e-20,  9.130440804339245e-21, -7.483674181492154e-22,  5.143295803358214e-23, -3.046407483575254e-24,
  1.586734878996910e-25, -7.380464579703577e-27,  3.103182969799990e-28, -1.189726220218923e-29,  2.942843376360848e-18, -1.140448175658834e-18,  2.341484942357782e-19,
 -3.263732950634788e-20,  3.445137367819084e-21, -2.928882583064860e-22,  2.086116858568554e-23, -1.279465179882065e-24,  6.894858170229273e-26, -3.315353759678122e-27,
  1.439901123041518e-28, -5.697493923516138e-30,  1.030903636542676e-18, -4.121376822616953e-19,  8.753584823504367e-20, -1.262334342099684e-20,  1.377902287463513e-21,
 -1.210530413849939e-22,  8.903447299863371e-24, -5.634704943885399e-25,  3.130906910957184e-26, -1.551176503905670e-27,  6.936528043186135e-29, -2.823847306967661e-30,
  3.908758989610446e-19, -1.605459921126919e-19,  3.512676958885517e-20, -5.219011288159109e-21,  5.867103268461124e-22, -5.305520364673854e-23,  4.014087274703119e-24,
 -2.611545428049261e-25,  1.490787658720527e-26, -7.583178059088035e-28,  3.479423226448638e-29, -1.452414939233954e-30,  1.606319803247312e-19, -6.750139098951710e-20,
  1.514724350876462e-20, -2.308597954353672e-21,  2.661436989154170e-22, -2.466901695888291e-23,  1.912124331898720e-24, -1.273790648850227e-25,  7.441354924069155e-27,
 -3.871597886940740e-28,  1.816017767340935e-29, -7.745127517661729e-31,  7.114672240295681e-20, -3.045845431086032e-20,  6.977893564709469e-21, -1.085977267442695e-21,
  1.278117694629481e-22, -1.209008024290525e-23,  9.559479100863668e-25, -6.493322918732000e-26,  3.866163706785491e-27, -2.049215288168576e-28,  9.788121069931462e-30,
 -4.248982699547574e-31,  3.326907472953984e-20, -1.444747487707624e-20,  3.363206278481306e-21, -5.319529535312737e-22,  6.361733976747344e-23, -6.113163569909606e-24,
  4.908680300036809e-25, -3.384899830023777e-26,  2.045315066462969e-27, -1.099821821830874e-28,  5.327757531267746e-30, -2.344670172669024e-31,  1.544133092965091e-20,
 -6.772361690131233e-21,  1.594206488974959e-21, -2.550163116000474e-22,  3.084091517581255e-23, -2.996351683577628e-24,  2.432041521687828e-25, -1.694848127349941e-26,
  1.034717271217385e-27, -5.620286524144303e-29,  2.749505580708111e-30, -1.221672901609732e-31,  5.557422307971153e-21, -2.450901325601699e-21,  5.805432644775301e-22,
 -9.345413758378941e-23,  1.137295743545183e-23, -1.111755635635734e-24,  9.078308751828154e-26, -6.363940867353515e-27,  3.907702472028618e-28, -2.134547771644742e-29,
  1.050010152847220e-30, -4.690543768843523e-32,  5.373847914748937e-02, -1.188779491935172e-04,  2.713748462224623e-07, -6.364000799910362e-10,  1.524397299453715e-12,
 -3.709631273809790e-15,  9.124017762688769e-18, -2.260011588647785e-20,  5.618063519964477e-23, -1.399562800456798e-25,  3.485355291360388e-28, -8.680041781529384e-31,
  5.044476962751931e-02, -1.345873894898263e-04,  4.241472314239214e-07, -1.407796174295206e-09,  4.674121817582023e-12, -1.528834034092334e-14,  4.914350544784544e-17,
 -1.554508677055804e-19,  4.847911175064347e-22, -1.493295067138407e-24,  4.549515867459447e-27, -1.372621376393813e-29,  4.445270113878119e-02, -1.591788510749627e-04,
  7.000555402069751e-07, -3.016362345556165e-09,  1.241637496504128e-11, -4.918335387880768e-14,  1.889434964022774e-16, -7.077955877271347e-19,  2.595336158655097e-21,
 -9.341228886182971e-24,  3.307304642959613e-26, -1.153855831155336e-28,  3.677669314100437e-02, -1.821528581453081e-04,  1.041713732682464e-06, -5.471837157456852e-09,
  2.684221260768895e-11, -1.252135390162846e-13,  5.613636559690984e-16, -2.435392264465176e-18,  1.027412725928825e-20, -4.230332816197970e-23,  1.704951833325088e-25,
 -6.741497511286692e-28,  2.856948615902825e-02, -1.939193042353837e-04,  1.372494251025517e-06, -8.572373426205249e-09,  4.928563359630394e-11, -2.666040481981890e-13,
  1.373931968886097e-15, -6.802344518260207e-18,  3.255260705684032e-20, -1.512646989087832e-22,  6.849570048994058e-25, -3.031027979409913e-27,  2.084359388161531e-02,
 -1.894561231385441e-04,  1.614629779927988e-06, -1.183609210467542e-08,  7.882640011490892e-11, -4.887791954816275e-13,  2.863610081258871e-15, -1.601095869327206e-17,
  8.605012211644668e-20, -4.469538518476978e-22,  2.253039327587157e-24, -1.105872691939129e-26,  1.428539341355381e-02, -1.694797051901147e-04,  1.712322169334662e-06,
 -1.459312843403640e-08,  1.115216187372046e-10, -7.855944433044853e-13,  5.188587021316920e-15, -3.250203604245760e-17,  1.946984833945466e-19, -1.122226049071507e-21,
  6.253617647858230e-24, -3.381771892657270e-26,  9.200168957840631e-03, -1.390839825697265e-04,  1.649132599358507e-06, -1.620990453644540e-08,  1.410509615473635e-10,
 -1.120740910378118e-12,  8.289066725798817e-15, -5.780772262041721e-17,  3.836602121338699e-19, -2.439897697340880e-21,  1.494727265213216e-23, -8.857837513625168e-26,
  5.569877659691757e-03, -1.050377018475570e-04,  1.450436919719166e-06, -1.632891655023729e-08,  1.607446668580521e-10, -1.432179668206722e-12,  1.179682740228272e-14,
 -9.112065665861904e-17,  6.667282665934201e-19, -4.656231726841947e-21,  3.121736467556181e-23, -2.018432733312363e-25,  3.171277767439577e-03, -7.323859557329036e-05,
  1.170071879251902e-06, -1.499455363950936e-08,  1.660788925175723e-10, -1.650989613271735e-12,  1.507546181407852e-14, -1.284113196668516e-16,  1.031600275302164e-18,
 -7.880286440372308e-21,  5.760045756463014e-23, -4.048599052015099e-25,  1.698976967879689e-03, -4.729210141577594e-05,  8.688943846807414e-07, -1.260597903145866e-08,
  1.563475607653423e-10, -1.726717977685660e-12,  1.740915957000207e-14, -1.629183219199312e-16,  1.431916160008084e-18, -1.192411804489282e-20,  9.471627478291229e-23,
 -7.214505087176535e-25,  8.569745341840120e-04, -2.835935985460154e-05,  5.958304496591442e-07, -9.738465088292316e-09,  1.346820700475928e-10, -1.646257420655530e-12,
  1.826299649627540e-14, -1.871585735324742e-16,  1.794157340503211e-18, -1.623955296787751e-20,  1.397868595531791e-22, -1.150735560865626e-24,  4.072668962619771e-04,
 -1.583283965478906e-05,  3.783570851481210e-07, -6.935781874302701e-09,  1.065558408073660e-10, -1.436672245575736e-12,  1.748268401512390e-14, -1.956327589564429e-16,
  2.039940703983480e-18, -2.001778483559421e-20,  1.862646561414749e-22, -1.653238427263830e-24,  1.825030980868899e-04, -8.248704849509506e-06,  2.230666792065632e-07,
 -4.567547643765268e-09,  7.768452814650063e-11, -1.151819749730329e-12,  1.533225088257435e-14, -1.868603402886791e-16,  2.114305279991726e-18, -2.244164278933122e-20,
  2.252368213388045e-22, -2.150926069460889e-24,  7.718651848822485e-05, -4.019098079144416e-06,  1.224029511041010e-07, -2.789061238159441e-09,  5.234894076738800e-11,
 -8.511776595620280e-13,  1.236284831931430e-14, -1.637180759974298e-16,  2.005741499359741e-18, -2.298024292285618e-20,  2.482879813985920e-22, -2.546263367292814e-24,
  3.084252752463054e-05, -1.835292325629232e-06,  6.266279716510671e-08, -1.583323346603665e-09,  3.269999435799496e-11, -5.815812515986841e-13,  9.195657975589143e-15,
 -1.320398083884823e-16,  1.748032025661442e-18, -2.157787904454460e-20,  2.505259819017423e-22, -2.754361078668636e-24,  1.165780936836427e-05, -7.870876709710703e-07,
  2.999931677975688e-08, -8.377950895238522e-10,  1.898710996184555e-11, -3.685015209668784e-13,  6.329339975673384e-15, -9.834998132472680e-17,  1.404409471777846e-18,
 -1.864611031541911e-20,  2.322567921243211e-22, -2.733259512931450e-24,  4.173835559275872e-06, -3.176873163055978e-07,  1.346247765235040e-08, -4.142624162177539e-10,
  1.027605790177014e-11, -2.171492081376414e-13,  4.043518823011199e-15, -6.787019639083054e-17,  1.043615625479854e-18, -1.487928967933732e-20,  1.985394756036838e-22,
 -2.497360649559397e-24,  1.417680898178637e-06, -1.209435316001912e-07,  5.676776534768219e-09, -1.919147100137062e-10,  5.198019141215562e-12, -1.193466087249995e-13,
  2.404810401973172e-15, -4.352753004948234e-17,  7.195857442824121e-19, -1.100094322537524e-20,  1.570264635804643e-22, -2.108390560368210e-24,  4.576252458937687e-07,
 -4.352772449765931e-08,  2.254926995412323e-09, -8.352035066653018e-11,  2.464347549121696e-12, -6.135507055691633e-14,  1.335430508035455e-15, -2.602367514178749e-17,
  4.618474343986028e-19, -7.560461534983646e-21,  1.152922902891653e-22, -1.650365844726407e-24,  1.406677035370810e-07, -1.484599278010137e-08,  8.459875252679480e-10,
 -3.423988403882530e-11,  1.098166976662574e-12, -2.959154584791144e-14,  6.945511991065498e-16, -1.454954322480675e-17,  2.768066302715157e-19, -4.845691380596058e-21,
  7.884553181184363e-23, -1.201836754662666e-24,  4.126761552834379e-08, -4.811206485023218e-09,  3.006187187736691e-10, -1.326167290665687e-11,  4.613655084894484e-13,
 -1.343077903546294e-14,  3.393886732720972e-16, -7.631320868317548e-18,  1.554298498435951e-19, -2.905987895119974e-21,  5.039270217965582e-23, -8.170210772205981e-25,
  1.158400481744931e-08, -1.485734319187972e-09,  1.014841925926388e-10, -4.867918119594917e-12,  1.833226896702805e-13, -5.755195422651645e-15,  1.563258941916592e-16,
 -3.767640162416753e-18,  8.204272378331597e-20, -1.636240993172459e-21,  3.020460776084743e-23, -5.203082065610897e-25,  3.120231710151953e-09, -4.385597535449314e-10,
  3.265338972454775e-11, -1.699105357289150e-12,  6.912887228504333e-14, -2.336364648133972e-15,  6.811087500563771e-17, -1.757045344843107e-18,  4.085353785853292e-20,
 -8.680871559665568e-22,  1.703928153282010e-23, -3.115265896679079e-25,  8.090850981673201e-10, -1.241681419862726e-10,  1.004958857264397e-11, -5.659796901927333e-13,
  2.482929550371938e-14, -9.018714370477430e-16,  2.817504438380141e-17, -7.768870451987838e-19,  1.926310831861707e-20, -4.355820519917159e-22,  9.081011786768831e-24,
 -1.760244148015185e-25,  2.027000803260718e-10, -3.384797287863490e-11,  2.969922657019018e-12, -1.806312485822270e-13,  8.528064115510860e-15, -3.323513322264116e-16,
  1.110972461636729e-17, -3.269811462604459e-19,  8.634917298205228e-21, -2.075362621365658e-22,  4.590364863772674e-24, -9.423607247875434e-26,  4.926394118555112e-11,
 -8.921061860448151e-12,  8.463862369113984e-13, -5.547019905026013e-14,  2.813102043751315e-15, -1.174264944917019e-16,  4.193684333884181e-18, -1.315633549708257e-19,
  3.695521473986088e-21, -9.429278952117389e-23,  2.210168834043143e-24, -4.800153354271705e-26,  1.166785278207888e-11, -2.283886325978002e-12,  2.336956148436204e-13,
 -1.646791983675582e-14,  8.953732298200807e-16, -3.996479515740666e-17,  1.522503271990130e-18, -5.083916814332531e-20,  1.516943569176341e-21, -4.103929115795254e-23,
  1.018195289495773e-24, -2.336869149489657e-26,  2.706674480797315e-12, -5.708610469652460e-13,  6.283823484088681e-14, -4.750724113336353e-15,  2.763921454066022e-16,
 -1.316849828573799e-17,  5.342903250706678e-19, -1.896182989659162e-20,  6.001860454714045e-22, -1.719427312151344e-23,  4.509919247412661e-25, -1.092543084847819e-26,
  6.184489555196734e-13, -1.400998288114968e-13,  1.654781338903233e-14, -1.339253163143154e-15,  8.320919180518861e-17, -4.224158673936347e-18,  1.822324204437781e-19,
 -6.863190634604412e-21,  2.301139793386543e-22, -6.971400914420948e-24,  1.930633719261061e-25, -4.930612080064743e-27,  1.400527657684844e-13, -3.396993695223188e-14,
  4.294246704995171e-15, -3.712038018934288e-16,  2.457980917196124e-17, -1.327075995070147e-18,  6.076813109568659e-20, -2.424786564456791e-21,  8.598895343141639e-23,
 -2.750898011235425e-24,  8.032568255745117e-26, -2.159809407668812e-27,  3.164946130165824e-14, -8.193294553467430e-15,  1.105597080163458e-15, -1.018383730141914e-16,
  7.171548802909548e-18, -4.109872669630564e-19,  1.993935290883788e-20, -8.415154340803660e-22,  3.151230801985782e-23, -1.062914120024359e-24,  3.267678616710346e-26,
 -9.237311287920980e-28,  7.190689417023354e-15, -1.980392663616476e-15,  2.844845141720298e-16, -2.785521421604821e-17,  2.081492146143959e-18, -1.263538081777287e-19,
  6.482312485465338e-21, -2.888270820359485e-22,  1.140115222255048e-23, -4.047912992107923e-25,  1.308102980343800e-26, -3.881739854632203e-28,  1.655852084038577e-15,
 -4.835709603614745e-16,  7.374196624114810e-17, -7.655751506330868e-18,  6.056160981764506e-19, -3.885523086942106e-20,  2.103512365713108e-21, -9.875323531745925e-23,
  4.101438418912072e-24, -1.530027282277880e-25,  5.188312943517252e-27, -1.613470089550241e-28,  3.898505898295116e-16, -1.203167059317014e-16,  1.942004878332937e-17,
 -2.131953232677096e-18,  1.780884754238272e-19, -1.204749945286446e-20,  6.867048771329784e-22, -3.389566302701492e-23,  1.478128926323405e-24, -5.782294984127820e-26,
  2.053614886973668e-27, -6.680454011530464e-29,  9.471362238003621e-17, -3.078331275088822e-17,  5.242839779218890e-18, -6.068811196390849e-19,  5.338752621685113e-20,
 -3.798395911399666e-21,  2.274015202784796e-22, -1.177396284298356e-23,  5.379001854184359e-25, -2.201799248727433e-26,  8.173035232794131e-28, -2.775526349189241e-29,
  2.397503988731223e-17, -8.176606700954747e-18,  1.464646710061050e-18, -1.782178957157039e-19,  1.646292561524566e-20, -1.228476592217287e-21,  7.704260168045456e-23,
 -4.173606965449336e-24,  1.992680693457973e-25, -8.514799669775693e-27,  3.295888742883980e-28, -1.165854375033641e-29,  6.386129802883684e-18, -2.276899994912675e-18,
  4.274745519220579e-19, -5.449902617401790e-20,  5.269969301169890e-21, -4.112140467033870e-22,  2.693726221223857e-23, -1.522582472094552e-24,  7.576878233159423e-26,
 -3.371018270050321e-27,  1.357247957597879e-28, -4.988606953036612e-30,  1.807717449437169e-18, -6.712043262055941e-19,  1.315936753944640e-19, -1.751665578784728e-20,
  1.767147212091998e-21, -1.437227274432829e-22,  9.803349850223642e-24, -5.764155489596388e-25,  2.980965161146468e-26, -1.376982520559521e-27,  5.750805039916729e-29,
 -2.190444808718363e-30,  5.489420724327031e-19, -2.114161006202265e-19,  4.311657686835364e-20, -5.969924328098543e-21,  6.260648145515749e-22, -5.288637973904800e-23,
  3.743552228958707e-24, -2.282188509925163e-25,  1.222641714449557e-26, -5.845553507520339e-28,  2.524754458015529e-29, -9.936489973922404e-31,  1.803232908582017e-19,
 -7.174068653366536e-20,  1.515695172642928e-20, -2.174227917682363e-21,  2.360998668065435e-22, -2.063732733565197e-23,  1.510406159067071e-24, -9.513108664961909e-26,
  5.261314984377713e-27, -2.594860581198913e-28,  1.155254872224187e-29, -4.682920511521017e-31,  6.448314459122997e-20, -2.638916402186300e-20,  5.750810087119272e-21,
 -8.510215119764456e-22,  9.529427113491915e-23, -8.584222808749905e-24,  6.470414922251948e-25, -4.194288712380364e-26,  2.385803431040472e-27, -1.209400381448484e-28,
  5.530531006107243e-30, -2.301093268467248e-31,  2.516700352920046e-20, -1.054857224855238e-20,  2.360356771911263e-21, -3.587154192558979e-22,  4.123773693001607e-23,
 -3.811836323951202e-24,  2.946671809098840e-25, -1.957839587487668e-26,  1.140839407682245e-27, -5.920872377955528e-29,  2.770558480388384e-30, -1.178849443126547e-31,
  1.067239234771916e-20, -4.561242145619041e-21,  1.043001937267491e-21, -1.620173358913357e-22,  1.903281743361298e-23, -1.797089882833627e-24,  1.418410789822779e-25,
 -9.617924378623021e-27,  5.716899102297939e-28, -3.025191687611488e-29,  1.442674474938142e-30, -6.252846656881709e-32,  4.821902118971668e-21, -2.091903251582128e-21,
  4.864338407216322e-22, -7.685279111033980e-23,  9.180873577729467e-24, -8.812637150518581e-25,  7.068813061577438e-26, -4.869455028336216e-27,  2.939398760125750e-28,
 -1.579047560617632e-29,  7.641921145771582e-31, -3.359979472357558e-32,  2.184089030474371e-21, -9.574407765186418e-22,  2.252555038047942e-22, -3.601262214584597e-23,
  4.352835511248844e-24, -4.226686437505196e-25,  3.428823833672511e-26, -2.388233908205623e-27,  1.457285551149904e-28, -7.911580998709399e-30,  3.868531944490812e-31,
 -1.718061453116348e-32,  7.753146647867206e-22, -3.418511796302999e-22,  8.095427412082340e-23, -1.302853393786318e-23,  1.585121483196722e-24, -1.549143742356723e-25,
  1.264683955992937e-26, -8.863381911785960e-28,  5.441175399455976e-29, -2.971506479012744e-30,  1.461387941635008e-31, -6.526770740966342e-33,  5.326726155987933e-02,
 -1.167370885539060e-04,  2.638819770073236e-07, -6.125915780413310e-10,  1.452344211670261e-12, -3.498049898389991e-15,  8.515644758552642e-18, -2.088033260391884e-20,
  5.138422056936216e-23, -1.267492093619613e-25,  3.125251104838026e-28, -7.708914125546382e-31,  4.991310119749413e-02, -1.312605373228215e-04,  4.076925063353792e-07,
 -1.335393725515071e-09,  4.379805742972696e-12, -1.415942314293079e-14,  4.500022958964034e-17, -1.407637151757107e-19,  4.341677112694047e-22, -1.322835527264318e-24,
  3.986757295941930e-27, -1.189992196428352e-29,  4.382696205088735e-02, -1.537198880826528e-04,  6.650194831274782e-07, -2.825329873680262e-09,  1.147649626175086e-11,
 -4.487744638512575e-14,  1.702391402451281e-16, -6.298796592717619e-19,  2.281690266703074e-21, -8.114476309431430e-24,  2.839184708354527e-26, -9.790301855902582e-29,
  3.606434333085748e-02, -1.740746810667363e-04,  9.785482076888208e-07, -5.061686437880114e-09,  2.446733183353129e-11, -1.125233133463972e-13,  4.975555945386649e-16,
 -2.129726565186869e-18,  8.867139066726457e-21, -3.604154340873127e-23,  1.434244941778604e-25, -5.600552526677678e-28,  2.781513575541209e-02, -1.833378123706241e-04,
  1.274186863571558e-06, -7.824731032298601e-09,  4.426845624699671e-11, -2.358024073513920e-13,  1.197267487733914e-15, -5.842751857335035e-18,  2.756972220039616e-20,
 -1.263580365254160e-22,  5.644952879740513e-25, -2.465006425503930e-27,  2.011073324202823e-02, -1.770864959578349e-04,  1.479853107298404e-06, -1.064948723729646e-08,
  6.970331697609571e-11, -4.251353467926583e-13,  2.451553485395191e-15, -1.349831551703099e-17,  7.147119572326433e-20, -3.658591554585354e-22,  1.818130240389513e-24,
 -8.800016846199021e-27,  1.363380397327095e-02, -1.564524157521625e-04,  1.547413311822190e-06, -1.292800894244808e-08,  9.698476231659531e-11, -6.713206822516353e-13,
  4.360009497798820e-15, -2.687257552745341e-17,  1.584640493126987e-19, -8.994868518974858e-22,  4.937928152135475e-24, -2.631424986009085e-26,  8.669039199257250e-03,
 -1.266322672666216e-04,  1.467448515447118e-06, -1.412212512479533e-08,  1.205012513141433e-10, -9.399166047371018e-13,  6.829906111754900e-15, -4.682779741177146e-17,
  3.057084686991595e-19, -1.913256926741632e-21,  1.153920131881305e-23, -6.734482833702518e-26,  5.171751822069716e-03, -9.417635304240823e-05,  1.269023730372678e-06,
 -1.397159356071052e-08,  1.347374830331378e-10, -1.177408141659644e-12,  9.520566350271825e-15, -7.224270272059011e-17,  5.195926223511391e-19, -3.568648763135201e-21,
  2.354014788995925e-23, -1.498087381362990e-25,  2.895965568645839e-03, -6.455497324797240e-05,  1.005051649163280e-06, -1.258294986660146e-08,  1.364041956509002e-10,
 -1.328841520010208e-12,  1.190243304172309e-14, -9.952713213028918e-17,  7.854192388568017e-19, -5.896859190132941e-21,  4.238364927621430e-23, -2.930567408677748e-25,
  1.522809571917896e-03, -4.090599125496271e-05,  7.315618803896086e-07, -1.035945405392053e-08,  1.256470677282858e-10, -1.358832855550902e-12,  1.342928604335154e-14,
 -1.232919743370147e-16,  1.063825881606635e-18, -8.702041942890778e-21,  6.793313156542454e-23, -5.087686054758585e-25,  7.523788620828302e-04, -2.402588504042343e-05,
  4.908843585657343e-07, -7.824809794111771e-09,  1.057469350582383e-10, -1.264847040237242e-12,  1.374560637198337e-14, -1.381122077117286e-16,  1.299059424009526e-18,
 -1.154404602343998e-20,  9.761125539931813e-23, -7.897070110889005e-25,  3.495003458441051e-04, -1.311196167893407e-05,  3.044779195786521e-07, -5.439696323571662e-09,
  8.161001823327527e-11, -1.076061787393780e-12,  1.282000671980434e-14, -1.405781544233399e-16,  1.437542595252177e-18, -1.384296801781591e-20,  1.264737235705539e-22,
 -1.102759919126596e-24,  1.527578880325830e-04, -6.663912686858841e-06,  1.750138353847851e-07, -3.490543444607743e-09,  5.794063096164882e-11, -8.396741018028250e-13,
  1.093731709022313e-14, -1.305598662371954e-16,  1.448076714463776e-18, -1.507665200814779e-20,  1.485161891598969e-22, -1.392751098332189e-24,  6.287512406307929e-05,
 -3.160706789925085e-06,  9.344619337250779e-08, -2.072982725098665e-09,  3.795563123899426e-11, -6.029267591941038e-13,  8.565438162339027e-15, -1.110539171007090e-16,
  1.333130129351835e-18, -1.497675552931443e-20,  1.587638981809335e-22, -1.598347053694205e-24,  2.439511275277974e-05, -1.401906977212232e-06,  4.645393565989260e-08,
 -1.142337155136646e-09,  2.300571647851560e-11, -3.995840210547792e-13,  6.177409126470238e-15, -8.681229238901222e-17,  1.125746908224981e-18, -1.362161595785363e-20,
  1.551231612487659e-22, -1.673769206011849e-24,  8.932390189692253e-06, -5.826536103954033e-07,  2.154970790490948e-08, -5.855603977800362e-10,  1.293689297035132e-11,
 -2.451261315894941e-13,  4.115341174053669e-15, -6.256770175940311e-17,  8.749156864582762e-19, -1.138353248548502e-20,  1.390450769902089e-22, -1.605536034916605e-24,
  3.090552377426123e-06, -2.273757659783662e-07,  9.349976739296550e-09, -2.799006852223686e-10,  6.767175124969187e-12, -1.395804664909219e-13,  2.539962629150907e-15,
 -4.170435622086375e-17,  6.278397975012791e-19, -8.770426099658362e-21,  1.147367646149600e-22, -1.415837119715426e-24,  1.011929911450017e-06, -8.349027971549771e-08,
  3.803170032724122e-09, -1.250778510152965e-10,  3.301560290170231e-12, -7.398109014710765e-14,  1.456570150644983e-15, -2.578614101834359e-17,  4.173009226344678e-19,
 -6.249827490387255e-21,  8.745258547888559e-23, -1.151796520320898e-24,  3.140818722425903e-07, -2.891004703184317e-08,  1.453795617835351e-09, -5.238683329345035e-11,
  1.506397061478800e-12, -3.660152053189790e-14,  7.783651547429824e-16, -1.483447742346807e-17,  2.577005890519345e-19, -4.132434777298024e-21,  6.177190071033324e-23,
 -8.673011255590704e-25,  9.258634942351198e-08, -9.462621607665443e-09,  5.235970886807742e-10, -2.062053795772192e-11,  6.445906720628262e-13, -1.695177147009211e-14,
  3.887537695935142e-16, -7.964610988350391e-18,  1.483218773998073e-19, -2.543457457539021e-21,  4.056749666158269e-23, -6.065218120932544e-25,  2.597827748148263e-08,
 -2.935188636555066e-09,  1.781623818459594e-10, -7.649839125147462e-12,  2.594354118992804e-13, -7.371861142141830e-15,  1.820298410828885e-16, -4.003389243286921e-18,
  7.981949743413567e-20, -1.461970023310928e-21,  2.485269455168530e-23, -3.952462703185642e-25,  6.955189761777369e-09, -8.652391705115593e-10,  5.744351842554709e-11,
 -2.682891129204764e-12,  9.852137426655198e-14, -3.019716151908576e-15,  8.016604685098519e-17, -1.890103422177263e-18,  4.029670144290052e-20, -7.874248074395769e-22,
  1.425133787039700e-23, -2.408407615747154e-25,  1.781815451388521e-09, -2.431342859642595e-10,  1.760616764237281e-11, -8.924428572327410e-13,  3.541935414734970e-14,
 -1.169106750219942e-15,  3.332010581529931e-17, -8.410852933004386e-19,  1.915146004263587e-20, -3.988078243866915e-22,  7.676506657163013e-24, -1.377156124533008e-25,
  4.381798848847474e-10, -6.534924165930992e-11,  5.147668882034893e-12, -2.825765416041823e-13,  1.209845174927465e-14, -4.293625010317828e-16,  1.311845918495356e-17,
 -3.540720328330548e-19,  8.600294286566988e-21, -1.906406080324363e-22,  3.898668421080022e-24, -7.417394898282560e-26,  1.038098359138137e-10, -1.686375652244122e-11,
  1.441293738417691e-12, -8.549985669092342e-14,  3.941893174750065e-15, -1.501720947369631e-16,  4.911752429130520e-18, -1.415658577979792e-19,  3.663721780559811e-21,
 -8.635409495102433e-23,  1.874268407647421e-24, -3.777913629303241e-26,  2.378923778902639e-11, -4.195702152866298e-12,  3.880938538645540e-13, -2.482720846370468e-14,
  1.230354001906246e-15, -5.023582107564257e-17,  1.756418545206383e-18, -5.398791108659024e-20,  1.486891467196836e-21, -3.722284966659044e-23,  8.565381347332399e-25,
 -1.827320344096409e-26,  5.297342249703369e-12, -1.011143202744030e-12,  1.009725829358881e-13, -6.951345937466007e-15,  3.696136839167177e-16, -1.614849416217847e-17,
  6.026739367035062e-19, -1.972962280868505e-20,  5.775427370951597e-22, -1.533849527673639e-23,  3.737962899739094e-25, -8.431402827083050e-27,  1.152103903597454e-12,
 -2.372606612526130e-13,  2.551575598112544e-14, -1.886430452576028e-15,  1.074237783568741e-16, -5.013852113970155e-18,  1.994383976347570e-19, -6.944089903510897e-21,
  2.157780141525425e-22, -6.072285748596605e-24,  1.565402747095129e-25, -3.729207341316443e-27,  2.461297084788087e-13, -5.451792150731761e-14,  6.298611334881391e-15,
 -4.990269518959828e-16,  3.037724992451099e-17, -1.512063450224167e-18,  6.400583844179183e-20, -2.366855420184039e-21,  7.796620094739764e-23, -2.321923656609870e-24,
  6.324440140284416e-26, -1.589421293371666e-27,  5.198038965659861e-14, -1.234574396127813e-14,  1.528491724857932e-15, -1.294930557031024e-16,  8.409917048985384e-18,
 -4.456512033040118e-19,  2.004233129066743e-20, -7.859337681407700e-22,  2.740587471868006e-23, -8.625729175804828e-25,  2.479207062450826e-26, -6.564798416906431e-28,
  1.092901322441070e-14, -2.774659731650868e-15,  3.671880063099497e-16, -3.318947819957885e-17,  2.295007584517181e-18, -1.292287393691857e-19,  6.164013883157367e-21,
 -2.559071090513944e-22,  9.431884186112091e-24, -3.132782377579530e-25,  9.488288256132214e-27, -2.643680441722689e-28,  2.305481112726185e-15, -6.236855467059826e-16,
  8.799001845634532e-17, -8.465530905078086e-18,  6.219353415778740e-19, -3.713897071206721e-20,  1.875339923228212e-21, -8.228503961253672e-23,  3.200192262041647e-24,
 -1.119958659547863e-25,  3.568979408073160e-27, -1.044828495506922e-28,  4.921181639529472e-16, -1.413963767575029e-16,  2.120813889929133e-17, -2.166491136438544e-18,
  1.687190743735256e-19, -1.066188175047236e-20,  5.688002959263994e-22, -2.632686658013223e-23,  1.078472943134866e-24, -3.969897463660275e-26,  1.328879192614776e-27,
 -4.081037588207740e-29,  1.072753978568860e-16, -3.262713518964652e-17,  5.187845029206562e-18, -5.612187410291165e-19,  4.621606532964079e-20, -3.083536674644566e-21,
  1.734226541589108e-22, -8.449758433066615e-24,  3.638726960153557e-25, -1.406172030292496e-26,  4.935307652160924e-28, -1.587137158462728e-29,  2.411759063318674e-17,
 -7.737761985456599e-18,  1.300296630477369e-18, -1.485443826397127e-19,  1.290103195729307e-20, -9.065314653634069e-22,  5.362146064481356e-23, -2.744036771060515e-24,
  1.239492134035871e-25, -5.018115072066704e-27,  1.842919641963997e-28, -6.193971610895304e-30,  5.650533357093037e-18, -1.905492385164062e-18,  3.373226789821820e-19,
 -4.057089939359526e-20,  3.705518729188111e-21, -2.734817624320234e-22,  1.696889046178018e-23, -9.097733218204003e-25,  4.300230352068662e-26, -1.819653250468720e-27,
  6.977010504563156e-29, -2.445391656955627e-30,  1.394590951453739e-18, -4.924597830173904e-19,  9.152075020490558e-20, -1.155123798133726e-20,  1.106067362192500e-21,
 -8.548547524153321e-23,  5.548149333094050e-24, -3.107873087019965e-25,  1.533113994340625e-26, -6.763270224977282e-28,  2.700672111334103e-29, -9.847302944922357e-31,
  3.665448616327438e-19, -1.350082442365406e-19,  2.624323347168179e-20, -3.463689791112093e-21,  3.465349924155389e-22, -2.795642903244863e-23,  1.891956267797285e-24,
 -1.103952189459663e-25,  5.666888717856015e-27, -2.598852138154266e-28,  1.077794637158456e-29, -4.077423869354065e-31,  1.036834243934075e-19, -3.967228649535536e-20,
  8.034198480916341e-21, -1.104664378851689e-21,  1.150550962929068e-22, -9.654522679025021e-24,  6.789694535605238e-25, -4.113165139944612e-26,  2.190077604741647e-27,
 -1.040870671506228e-28,  4.469653331575454e-30, -1.749230644649850e-31,  3.186782108764148e-20, -1.261375201139381e-20,  2.650187460037443e-21, -3.780592182081528e-22,
  4.083061301285705e-23, -3.550067000553232e-24,  2.584823767363951e-25, -1.619851967872899e-26,  8.915044838265218e-28, -4.376014871902534e-29,  1.939257662129977e-30,
 -7.825782116285108e-32,  1.072398068031727e-20, -4.371881259418750e-21,  9.487348310464598e-22, -1.398065239394273e-22,  1.559037373107172e-23, -1.398735348368023e-24,
  1.050163217928904e-25, -6.781394628382212e-27,  3.843057104315732e-28, -1.941056805024502e-29,  8.845129967119606e-31, -3.667639515003973e-32,  3.966509573744347e-21,
 -1.658021059122110e-21,  3.698878259279728e-22, -5.604457814888525e-23,  6.423776629472498e-24, -5.920668559660006e-25,  4.563948134436967e-26, -3.024061873872340e-27,
  1.757416669135427e-28, -9.097122102068343e-30,  4.246043164728014e-31, -1.802216065568081e-32,  1.607350426184393e-21, -6.857398269107900e-22,  1.564956052415018e-22,
 -2.426129401020456e-23,  2.844484215340690e-24, -2.680626984512866e-25,  2.111810220654548e-26, -1.429358627279433e-27,  8.481019223031606e-29, -4.480107700502097e-30,
  2.132906659975223e-31, -9.229338975875027e-33,  7.005531193767184e-22, -3.036076624018445e-22,  7.051631029536774e-23, -1.112796225538316e-23,  1.327812307431442e-24,
 -1.273107998382822e-25,  1.020055466498775e-26, -7.019194143025808e-28,  4.232595011955294e-29, -2.271414015323619e-30,  1.098165665622994e-31, -4.823679379270698e-33,
  3.093048353926249e-22, -1.355200708611733e-22,  3.186501416637664e-23, -5.091400977256612e-24,  6.150368819756788e-25, -5.968698153056740e-26,  4.839276845978951e-27,
 -3.368783832233830e-28,  2.054505308118167e-29, -1.114801415215623e-30,  5.448252905401799e-32, -2.418423480002909e-33,  1.082220248696316e-22, -4.770653170642791e-23,
  1.129459055798657e-23, -1.817247389277968e-24,  2.210391521768723e-25, -2.159671591147094e-26,  1.762661364595926e-27, -1.235033946909909e-28,  7.579951890942061e-30,
 -4.138533223881120e-31,  2.034853126554135e-32, -9.085853157188648e-34,  5.280448931111567e-02, -1.146550473418326e-04,  2.566680298370903e-07, -5.899028497286597e-10,
  1.384380554536013e-12, -3.300508542138023e-15,  7.953346434576633e-18, -1.930669717411879e-20,  4.703833022898140e-23, -1.149006464669696e-25,  2.805251995225286e-28,
 -6.854446596881987e-31,  4.939448229232326e-02, -1.280619260114226e-04,  3.920790842474591e-07, -1.267524973409267e-09,  4.107106014036952e-12, -1.312518721787911e-14,
  4.124640715576674e-17, -1.276025190686279e-19,  3.892943017343338e-22, -1.173358375859836e-24,  3.498514064288238e-27, -1.033219696105342e-29,  4.322251240403774e-02,
 -1.485322932452184e-04,  6.321883522254667e-07, -2.648670184473153e-09,  1.061841768334279e-11, -4.099535827986986e-14,  1.535823067127042e-16, -5.613284765681407e-19,
  2.009014454782051e-21, -7.060450827294390e-24,  2.441627304262169e-26, -8.322557178043946e-29,  3.538332586489289e-02, -1.664827681584993e-04,  9.200846165357776e-07,
 -4.687583759294346e-09,  2.233160945147821e-11, -1.012666640889026e-13,  4.417082957664405e-16, -1.865677249846857e-18,  7.667236116573725e-21, -3.076848755543748e-23,
  1.209105236796008e-25, -4.663255073767509e-28,  2.710159335517645e-02, -1.735082120769615e-04,  1.184389142874216e-06, -7.152656762480122e-09,  3.982699887355991e-11,
 -2.089355126160100e-13,  1.045367705062061e-15, -5.029148630980166e-18,  2.340242866642313e-20, -1.058063112394366e-22,  4.664019434001928e-25, -2.010051009344920e-27,
  1.942528148639306e-02, -1.657405132404133e-04,  1.358480204657898e-06, -9.599183000828053e-09,  6.175965447663922e-11, -3.705867435580212e-13,  2.103735566864694e-15,
 -1.140865977229764e-17,  5.952110226014066e-20, -3.003243323918733e-22,  1.471530744144530e-24, -7.024425644802433e-27,  1.303180633642363e-02, -1.446682585304363e-04,
  1.401162411722277e-06, -1.147822449027077e-08,  8.454664314687909e-11, -5.751652453214713e-13,  3.673960466232099e-15, -2.228386390727505e-17,  1.293754525479648e-19,
 -7.233190281256044e-22,  3.912406667873312e-24, -2.054879933461523e-26,  8.184960484099132e-03, -1.155391377541854e-04,  1.308958466714013e-06, -1.233601226029600e-08,
  1.032413454074549e-10, -7.906881516109725e-13,  5.645933698671007e-15, -3.806356846328735e-17,  2.444716624559903e-19, -1.505929855785241e-21,  8.943058805643727e-24,
 -5.140930438451090e-26,  4.814338425740675e-03, -8.465986337937814e-05,  1.113560730515619e-06, -1.199241972313022e-08,  1.133196387594132e-10, -9.714217661336491e-13,
  7.712459277288674e-15, -5.750170336811602e-17,  4.065931783170324e-19, -2.746795358686439e-21,  1.782965380324962e-23, -1.116980967413831e-25,  2.652920035587749e-03,
 -5.708336321365912e-05,  8.663218228641445e-07, -1.059847541073084e-08,  1.124721078601330e-10, -1.073969217645471e-12,  9.437821807539614e-15, -7.748676439520034e-17,
  6.007763329082021e-19, -4.433950711575488e-21,  3.134219634510122e-23, -2.132171140663199e-25,  1.370148940381433e-03, -3.551853121556681e-05,  6.184673976624825e-07,
 -8.550110500706322e-09,  1.014325304555372e-10, -1.074381043750850e-12,  1.041010918828687e-14, -9.377834637407429e-17,  7.945084949766875e-19, -6.384988601633198e-21,
  4.899467731110815e-23, -3.608343703823998e-25,  6.635729973067346e-04, -2.044745019121163e-05,  4.063582098422564e-07, -6.318545071500744e-09,  8.345844156999482e-11,
 -9.770194417929239e-13,  1.040296975287672e-14, -1.025012226456381e-16,  9.461106999008994e-19, -8.255688449077923e-21,  6.858178744639030e-23, -5.453726278481276e-25,
  3.015400398832352e-04, -1.091657910764291e-05,  2.463766325748416e-07, -4.290638984416834e-09,  6.287178358044263e-11, -8.108455106290145e-13,  9.459366754794717e-15,
 -1.016616078947719e-16,  1.019654564598002e-18, -9.636850428567621e-21,  8.646171048968380e-23, -7.406936855542034e-25,  1.286578534745687e-04, -5.416777690498989e-06,
  1.381784463522928e-07, -2.684733710366768e-09,  4.350106901252792e-11, -6.162736636514141e-13,  7.856313029445291e-15, -9.186908676674944e-17,  9.989509340091285e-19,
 -1.020335569229311e-20,  9.866266848406189e-23, -9.087004008874290e-25,  5.158334141258927e-05, -2.503165281867344e-06,  7.184969696031535e-08, -1.551968055924130e-09,
  2.772387968150835e-11, -4.303073087542438e-13,  5.980117673528435e-15, -7.592028405751810e-17,  8.931254491873463e-19, -9.839585806791820e-21,  1.023517675573728e-22,
 -1.011663149936657e-24,  1.945202487369521e-05, -1.079408977798510e-06,  3.471471277589929e-08, -8.308824188211895e-10,  1.631898432714651e-11, -2.768380416077696e-13,
  4.185049305182499e-15, -5.756759251198104e-17,  7.313094073795227e-19, -8.674900233717877e-21,  9.690848537070525e-23, -1.026301861688111e-24,  6.906585588380616e-06,
 -4.351844797063532e-07,  1.561902444760569e-08, -4.129671104219656e-10,  8.895021737953381e-12, -1.645604459082562e-13,  2.700720377242159e-15, -4.017846393819765e-17,
  5.502322798709945e-19, -7.016369450525056e-21,  8.404799797489629e-23, -9.523144471324324e-25,  2.311720251641327e-06, -1.643629743842565e-07,  6.558428965140841e-09,
 -1.910062749089579e-10,  4.501172733003518e-12, -9.062660717734958e-14,  1.611719933939689e-15, -2.588861299907071e-17,  3.816039812020752e-19, -5.223303891191283e-21,
  6.699987909086547e-23, -8.111283726850171e-25,  7.304473171574872e-07, -5.827186017011280e-08,  2.575899878246790e-09, -8.241127296481155e-11,  2.120029279844824e-12,
 -4.636459430762546e-14,  8.919787179713862e-16, -1.544544854394537e-17,  2.446967267544138e-19, -3.590364576677666e-21,  4.925213512195870e-23, -6.363157760442455e-25,
  2.182336479448049e-07, -1.943418877678015e-08,  9.485495007822362e-10, -3.325180125643630e-11,  9.318189055070358e-13, -2.209539117708215e-14,  4.590959570635805e-16,
 -8.557379596605776e-18,  1.455143398098321e-19, -2.285844477740453e-21,  3.349457458110970e-23, -4.612773601248404e-25,  6.176353938039207e-08, -6.111115932054984e-09,
  3.282991566762139e-10, -1.257959259987082e-11,  3.832421963096512e-13, -9.836037687544668e-15,  2.203902819176163e-16, -4.415916462845168e-18,  8.049539809833887e-20,
 -1.352159514424136e-21,  2.114037201610549e-23, -3.100128187573400e-25,  1.659331795907042e-08, -1.816348600826087e-09,  1.070807068921564e-10, -4.474484497310632e-12,
  1.479134794419281e-13, -4.102186299491430e-15,  9.897485673572550e-17, -2.128983955665701e-18,  4.155111457788108e-20, -7.455335354248984e-22,  1.242366863982557e-23,
 -1.938029075852988e-25,  4.241968386023722e-09, -5.116625294990207e-10,  3.300896976416586e-11, -1.500839971675056e-12,  5.373489310430844e-14, -1.607811659596420e-15,
  4.171306222140379e-17, -9.620293926954708e-19,  2.007955644033724e-20, -3.844126084560956e-22,  6.820849782512734e-24, -1.130771686846062e-25,  1.034721994879333e-09,
 -1.370181172734467e-10,  9.647033187476980e-12, -4.762532648300783e-13,  1.843493777068295e-14, -5.941853562134420e-16,  1.655363661630801e-17, -4.088306330484976e-19,
  9.115370936919220e-21, -1.860037886530566e-22,  3.510703112252313e-24, -6.179477429952114e-26,  2.415771698126756e-10, -3.499699259224117e-11,  2.682213559406967e-12,
 -1.434758848366669e-13,  5.993872584158143e-15, -2.077940820885998e-16,  6.208077471496650e-18, -1.639890827995505e-19,  3.901474075794768e-21, -8.476810626459623e-23,
  1.700264747266336e-24, -3.174660200239603e-26,  5.417554130985891e-11, -8.557690803524000e-12,  7.121710982671352e-13, -4.119381522782163e-14,  1.854132347813238e-15,
 -6.903396707748083e-17,  2.208825983906342e-18, -6.233097015587480e-20,  1.580593025477769e-21, -3.652865979209533e-23,  7.778767223412251e-25, -1.539277729456045e-26,
  1.171689004481054e-11, -2.011686680095447e-12,  1.813428869234543e-13, -1.131995040517300e-14,  5.480165084662508e-16, -2.188081808578582e-17,  7.487845122950370e-19,
 -2.254533649458549e-20,  6.086814354720142e-22, -1.494727582602328e-23,  3.376041761758967e-25, -7.073532308942136e-27,  2.455051528512695e-12, -4.567319344506755e-13,
  4.449181873800418e-14, -2.991299939454264e-15,  1.554917415573538e-16, -6.647671984853228e-18,  2.429785918017639e-19, -7.796279859210240e-21,  2.238417236772671e-22,
 -5.834554517122261e-24,  1.396322564748868e-25, -3.094718341514710e-27,  5.009345029714629e-13, -1.006744562106854e-13,  1.057282671068725e-14, -7.640867359697368e-16,
  4.257313134382037e-17, -1.945898062147308e-18,  7.586075056008131e-20, -2.590596547172046e-21,  7.900557817374914e-23, -2.183413930313665e-24,  5.530833475410627e-26,
 -1.295382190919107e-27,  1.001121444877302e-13, -2.167003564969537e-14,  2.447688650375526e-15, -1.897590001814298e-16,  1.131276822219079e-17, -5.519279990516042e-19,
  2.291639491335676e-20, -8.317817242662038e-22,  2.691092766476401e-23, -7.876048003521145e-25,  2.109386911599661e-26, -5.215231589966415e-28,  1.972406338124555e-14,
 -4.584573612172482e-15,  5.556196766371602e-16, -4.611244617158197e-17,  2.936008759865648e-18, -1.526421286532709e-19,  6.739675519051006e-21, -2.596356339746722e-22,
  8.899508729952682e-24, -2.754868482682179e-25,  7.791540982057546e-27, -2.031203054058765e-28,  3.858827598011848e-15, -9.602135244789479e-16,  1.245545685103360e-16,
 -1.104231052709444e-17,  7.494309243894362e-19, -4.144615833221550e-20,  1.942849937440585e-21, -7.931649700247250e-23,  2.876228788651488e-24, -9.404200702598327e-26,
  2.805144302439582e-27, -7.701156241103776e-29,  7.557090278149251e-16, -2.006917589505863e-16,  2.779244555430948e-17, -2.626069310691748e-18,  1.895917743704991e-19,
 -1.113234043470517e-20,  5.530528719569341e-22, -2.388751592498690e-23,  9.149745828450060e-25, -3.155179493285937e-26,  9.911729507476991e-28, -2.861703972563689e-29,
  1.494655979034175e-16, -4.222716342339897e-17,  6.226370573245253e-18, -6.255389384815176e-19,  4.793533762677216e-20, -2.982295302383769e-21,  1.567199732266026e-22,
 -7.148631358638035e-24,  2.887301445327112e-25, -1.048359452113169e-26,  3.462924839430217e-28, -1.049860970671625e-29,  3.014522112270385e-17, -9.030420675381232e-18,
  1.413749422954555e-18, -1.506333077225741e-19,  1.222310596156753e-20, -8.039705903135284e-22,  4.459611062527039e-23, -2.144000396561506e-24,  9.113800960685389e-26,
 -3.477995300318500e-27,  1.205889470468706e-28, -3.832415384303537e-30,  6.265112164033714e-18, -1.983173038264870e-18,  3.286579013630341e-19, -3.703616831314040e-20,
  3.174153828340011e-21, -2.201889063216528e-22,  1.286273743014521e-23, -6.503304570732027e-25,  2.903336305057843e-26, -1.162133959368626e-27,  4.221136484664842e-29,
 -1.403608748203566e-30,  1.356794308217468e-18, -4.521928581079024e-19,  7.907389751439212e-20, -9.396245381506213e-21,  8.481599278288897e-22, -6.188641511693547e-23,
  3.797588779828417e-24, -2.014283261578591e-25,  9.422189002807430e-27, -3.946894388539231e-28,  1.498549938861457e-29, -5.202539694155228e-31,  3.097713959075621e-19,
 -1.082905764656398e-19,  1.991272282214280e-20, -2.487056976046840e-21,  2.357195886118021e-22, -1.803797737979024e-23,  1.159448273629186e-24, -6.434253762839678e-26,
  3.145292380696985e-27, -1.375341213894642e-28,  5.445071308882071e-30, -1.968976208867192e-31,  7.545429529715577e-20, -2.755857161626319e-20,  5.309078058159638e-21,
 -6.945123369832792e-22,  6.888340301102759e-23, -5.510325509130581e-24,  3.698615295459410e-25, -2.140987646609081e-26,  1.090548514906940e-27, -4.963813944324051e-29,
  2.043606124740816e-30, -7.676635251578066e-32,  1.983967713372246e-20, -7.539363446743082e-21,  1.515621272963920e-21, -2.068697140259243e-22,  2.139230495867231e-23,
 -1.782576487975502e-24,  1.245137271834673e-25, -7.493358500811050e-27,  3.964379227629192e-28, -1.872437407422018e-29,  7.992011145081845e-31, -3.109431140908977e-32,
  5.692696506369417e-21, -2.241147376135548e-21,  4.681289258465474e-22, -6.639232133894597e-23,  7.129550800272846e-24, -6.164426249417671e-25,  4.464081248628401e-26,
 -2.782832259711746e-27,  1.523737749298510e-28, -7.442232761859990e-30,  3.282151208641536e-31, -1.318296769507442e-32,  1.798607792153139e-21, -7.302816872856547e-22,
  1.577767342225128e-22, -2.314733158605258e-23,  2.570039858076671e-24, -2.296009976558014e-25,  1.716715285231596e-26, -1.104110898548103e-27,  6.232626740746313e-29,
 -3.136031610636964e-30,  1.423771486942109e-31, -5.882543349723503e-33,  6.290634091797660e-22, -2.621978581554826e-22,  5.830876356847935e-23, -8.806795077403547e-24,
  1.006277838994260e-24, -9.246394422258091e-26,  7.106410620881787e-27, -4.695075786899475e-28,  2.720841067161778e-29, -1.404566985728434e-30,  6.538309653124146e-32,
 -2.767994936111827e-33,  2.431048359390460e-22, -1.035204473375230e-22,  2.357555899081032e-23, -3.647218599788593e-24,  4.267298202528656e-25, -4.013349905265688e-26,
  3.155500721546777e-27, -2.131667755301564e-28,  1.262447610668161e-29, -6.656754124374319e-31,  3.163558649464336e-32, -1.366555750532513e-33,  1.020386078584467e-22,
 -4.417326183561427e-23,  1.024715371735004e-23, -1.615071732529358e-24,  1.924785973934329e-25, -1.843280134346247e-26,  1.475170766346264e-27, -1.013936297274974e-28,
  6.107276107963814e-30, -3.273911363653146e-31,  1.581176512702998e-32, -6.938185049721546e-34,  4.385917004831664e-23, -1.920618324108329e-23,  4.513211607950678e-24,
 -7.206756265214227e-25,  8.700363263097802e-26, -8.438285255647292e-27,  6.837522995352838e-28, -4.757084489977338e-29,  2.899546473792598e-30, -1.572465241688625e-31,
  7.680811309814640e-33, -3.407646905549141e-34,  1.511454949219634e-23, -6.661265449693092e-24,  1.576649355824947e-24, -2.536075745346207e-25,  3.083907360716385e-26,
 -3.012347465785573e-27,  2.457950303196554e-28, -1.721756568390947e-29,  1.056452024656252e-30, -5.766630210735817e-32,  2.834672500741128e-33, -1.265411657133972e-34,
  5.234993150268085e-02, -1.126296468387045e-04,  2.497199509379348e-07, -5.682706518469052e-10,  1.320236262359113e-12, -3.115948933419560e-15,  7.433225348579771e-18,
 -1.786554533571755e-20,  4.309682591798518e-23, -1.042599833478120e-25,  2.520560131615062e-28, -6.101761997138262e-31,  4.888841307298633e-02, -1.249850370101057e-04,
  3.772545750858533e-07, -1.203858711765199e-09,  3.854219117835963e-12, -1.217677829088326e-14,  3.784177778421661e-17, -1.157948116189701e-19,  3.494665413028390e-22,
 -1.042098644248576e-24,  3.074286011527483e-27, -8.984289063145944e-30,  4.263830094268345e-02, -1.435990954244649e-04,  6.013972556115068e-07, -2.485139703628113e-09,
  9.834133750193032e-12, -3.749095298345789e-14,  1.387282402040268e-16, -5.009252729543941e-19,  1.771570198012892e-21, -6.153249490952699e-24,  2.103367417425355e-26,
 -7.087883395115084e-29,  3.473176826676615e-02, -1.593411713182632e-04,  8.659124283519252e-07, -4.345921961942373e-09,  2.040819386524957e-11, -9.126579889821338e-14,
  3.927441650964933e-16, -1.637153601214859e-18,  6.641899956798052e-21, -2.631862814510822e-23,  1.021442358171301e-25, -3.891434611766324e-28,  2.642598201697496e-02,
 -1.643659024721642e-04,  1.102247044562089e-06, -6.547537701903611e-09,  3.588819362615382e-11, -1.854552534176858e-13,  9.144879106310428e-16, -4.337780801527045e-18,
  1.990894175214403e-20, -8.880540858289304e-23,  3.863119138232860e-25, -1.643352516633360e-27,  1.878334857366117e-02, -1.553171797540995e-04,  1.248982946694045e-06,
 -8.667683999294053e-09,  5.482801267134293e-11, -3.237247696393159e-13,  1.809410814653828e-15, -9.666189054695683e-18,  4.969845808388759e-20, -2.472083134524832e-22,
  1.194459471878647e-24, -5.624134648418793e-27,  1.247471090707178e-02, -1.339877614707147e-04,  1.271175545289877e-06, -1.021291781832764e-08,  7.387686841294143e-11,
 -4.940327736024274e-13,  3.104263392882592e-15, -1.853196089473846e-17,  1.059478343307284e-19, -5.835131595215163e-22,  3.110234427556926e-24, -1.610252140783774e-26,
  7.742847849889824e-03, -1.056326727132557e-04,  1.170338529817384e-06, -1.080364561944631e-08,  8.870064305424797e-11, -6.671388224512175e-13,  4.681994737017378e-15,
 -3.104304366794450e-17,  1.961869301670241e-19, -1.189666332977291e-21,  6.957469092697122e-24, -3.940012686590804e-26,  4.492646167141413e-03, -7.629760457560295e-05,
  9.799203837030978e-07, -1.032519802719218e-08,  9.561900767189617e-11, -8.042597510289980e-13,  6.270628026141831e-15, -4.594430006051680e-17,  3.194434467441166e-19,
 -2.123024766587064e-21,  1.356280833450262e-23, -8.365495260133996e-26,  2.437683381259347e-03, -5.063247902301638e-05,  7.492665605088754e-07, -8.959150237439698e-09,
  9.309269229123993e-11, -8.714639135673590e-13,  7.514967993769982e-15, -6.059114580456780e-17,  4.616282525071562e-19, -3.349644967624829e-21,  2.328976154827719e-23,
 -1.559053843974437e-25,  1.237357388447405e-03, -3.095515678623241e-05,  5.249361547748541e-07, -7.086359873427370e-09,  8.224463987500111e-11, -8.533746030682808e-13,
  8.108226628755623e-15, -7.168260547122791e-17,  5.964056014098723e-19, -4.709587471579160e-21,  3.552759110462741e-23, -2.573406051909110e-25,  5.878349139658709e-04,
 -1.747857552170056e-05,  3.379442632773744e-07, -5.126885245848680e-09,  6.619887365364372e-11, -7.586242307106188e-13,  7.915632579490710e-15, -7.649513818083139e-17,
  6.929986185657092e-19, -5.938717946081539e-21,  4.847589186477351e-23, -3.789572275429764e-25,  2.615122742380241e-04, -9.135572487682844e-06,  2.004269610688994e-07,
 -3.402996081353091e-09,  4.871232995668997e-11, -6.145901224362179e-13,  7.021905773582515e-15, -7.397494912576250e-17,  7.278475955485513e-19, -6.752424817828915e-21,
  5.950140076136682e-23, -5.008813107737078e-25,  1.090131063359424e-04, -4.429259316772510e-06,  1.097619466722169e-07, -2.077889459944139e-09,  3.287007318997008e-11,
 -4.552919488198193e-13,  5.681296669186236e-15, -6.509003179707327e-17,  6.939756665675256e-19, -6.954858182548121e-21,  6.602316286530144e-23, -5.972928527369419e-25,
  4.261216920755914e-05, -1.995928047221668e-06,  5.562698634530764e-08, -1.170105665366999e-09,  2.039617270385447e-11, -3.093652283556234e-13,  4.206384249714745e-15,
 -5.229732305898146e-17,  6.029852082837449e-19, -6.515453483048125e-21,  6.651201374519538e-23, -6.455238022862746e-25,  1.563243057075468e-05, -8.375227457721461e-07,
  2.614432030087116e-08, -6.091193685892692e-10,  1.166860503353076e-11, -1.933590047503102e-13,  2.858696993239250e-15, -3.849457785166880e-17,  4.791109239809262e-19,
 -5.572153591337692e-21,  6.106835051726182e-23, -6.348462734668678e-25,  5.387479137826795e-06, -3.278642742296856e-07,  1.141917411440822e-08, -2.938041739557538e-10,
  6.170231676199451e-12, -1.114655556163183e-13,  1.788445563457278e-15, -2.603763615965726e-17,  3.492472562497964e-19, -4.365115809793976e-21,  5.128455477179806e-23,
 -5.702512056831979e-25,  1.746249395165009e-06, -1.199647528096252e-07,  4.644842426499224e-09, -1.316097758668109e-10,  3.023194288541610e-12, -5.942087184201603e-14,
  1.032847797369890e-15, -1.623131335030463e-17,  2.342757900038533e-19, -3.142336856679782e-21,  3.952390334860442e-23, -4.694731207332616e-25,  5.330408946455181e-07,
 -4.110734191510646e-08,  1.763287966252743e-09, -5.487852703281736e-11,  1.375893568072113e-12, -2.936903213403229e-14,  5.521224981930098e-16, -9.351788444881848e-18,
  1.450473329873482e-19, -2.085137532399891e-21,  2.804307552675777e-23, -3.554181947196143e-25,  1.534645356696920e-07, -1.321848915578879e-08,  6.261370022499667e-10,
 -2.135219011916766e-11,  5.831134403768152e-13, -1.349387633500652e-14,  2.739450836761271e-16, -4.994125217453087e-18,  8.313001393861337e-20, -1.279267434222788e-21,
  1.837572602909797e-23, -2.482294183188135e-25,  4.174538738497407e-08, -3.997574161589854e-09,  2.084710287435360e-10, -7.771420935232321e-12,  2.307325456733084e-13,
 -5.779090253115402e-15,  1.265138408529876e-16, -2.479145664028332e-18,  4.423450926823370e-20, -7.278745113586604e-22,  1.115510850575394e-23, -1.604506775176266e-25,
  1.075067749268436e-08, -1.139733197738478e-09,  6.524771100762597e-11, -2.653007131625618e-12,  8.547773045856835e-14, -2.313622492670912e-15,  5.454122058333816e-17,
 -1.147408093810189e-18,  2.192015626737479e-20, -3.852756860304878e-22,  6.293493441453907e-24, -9.629616814921893e-26,  2.627205520436155e-09, -3.071463609232625e-10,
  1.925027703196358e-11, -8.519369573983863e-13,  2.973504980863898e-14, -8.684529455633438e-16,  2.201704570474828e-17, -4.966667866540695e-19,  1.014811103648625e-20,
 -1.903302827901489e-22,  3.310704114903127e-24, -5.383907042983762e-26,  6.108507522947334e-10, -7.846778806375417e-11,  5.370145768845765e-12, -2.581477047704723e-13,
  9.744114850098266e-15, -3.066395910107417e-16,  8.349610617575206e-18, -2.017371955582322e-19,  4.403965855399301e-21, -8.805185210847918e-23,  1.629473353204229e-24,
 -2.813902356936642e-26,  1.355435738308006e-10, -1.906587805652473e-11,  1.421268421172907e-12, -7.406499309584692e-14,  3.018461438296910e-15, -1.022031648768027e-16,
  2.985275287735555e-18, -7.716652453377984e-20,  1.797950972987192e-21, -3.828515343906878e-23,  7.530920180342379e-25, -1.379835163761350e-26,  2.880284949498059e-11,
 -4.422096254209628e-12,  3.582057131938563e-13, -2.019707369757799e-14,  8.872743447740630e-16, -3.227916371143380e-17,  1.010151937996402e-18, -2.790430835752887e-20,
  6.932141670031483e-22, -1.570604575353255e-23,  3.281016829319391e-25, -6.372942973094980e-27,  5.884762655299744e-12, -9.830802310820109e-13,  8.633121467845578e-14,
 -5.256794659504640e-15,  2.485371547662140e-16, -9.701421096542007e-18,  3.248668044527396e-19, -9.579493744782578e-21,  2.534772515989639e-22, -6.104786142258417e-24,
  1.353153696185766e-25, -2.783953602039794e-27,  1.161246245082103e-12, -2.104489209142680e-13,  1.998981425088346e-14, -1.312027335310975e-15,  6.665246165325990e-17,
 -2.787583963351440e-18,  9.975997248439612e-20, -3.136528362102340e-21,  8.830566997852027e-23, -2.258533811454634e-24,  5.306873223900358e-26, -1.155465287487894e-27,
  2.224616419690294e-13, -4.360758048647028e-14,  4.470171706504536e-15, -3.156601353967332e-16,  1.720236526276323e-17, -7.697359726391306e-19,  2.940121259565096e-20,
 -9.844632806847650e-22,  2.945822689468171e-23, -7.992957884811327e-25,  1.989011616223560e-26, -4.578895845488929e-28,  4.161528124633707e-14, -8.797883492295568e-15,
  9.710793558548070e-16, -7.363412495098527e-17,  4.297498411233446e-18, -2.054294481625211e-19,  8.363601396762991e-21, -2.978715187215396e-22,  9.462422732846856e-24,
 -2.720797680648231e-25,  7.163079416787138e-27, -1.741824395254296e-28,  7.652020503991682e-15, -1.739608145679741e-15,  2.062726423750722e-16, -1.676250191024654e-17,
  1.045893979350217e-18, -5.332701473541924e-20,  2.310803918102993e-21, -8.742288757783348e-23,  2.944611868936106e-24, -8.962098401037733e-26,  2.493491806212569e-27,
 -6.397862197059955e-29,  1.393282511360718e-15, -3.396089141954716e-16,  4.315737147256442e-17, -3.750885923200807e-18,  2.497462866315346e-19, -1.355962683101734e-20,
  6.244279856661541e-22, -2.505824535474904e-23,  8.937190172811860e-25, -2.875543624639443e-26,  8.444795204987076e-28, -2.283680182028714e-29,  2.533007360523602e-16,
 -6.599714996010442e-17,  8.966400886085829e-18, -8.316488317801470e-19,  5.897578660775555e-20, -3.403560670384671e-21,  1.662894386626293e-22, -7.067448442053892e-24,
  2.665151375307516e-25, -9.052564718813548e-27,  2.802414920598050e-28, -7.977006620932672e-30,  4.640459543153905e-17, -1.288366305538019e-17,  1.866492169648010e-18,
 -1.843279694999871e-19,  1.389251380601390e-20, -8.505628354220129e-22,  4.400920674324335e-23, -1.977543136984379e-24,  7.872035723737315e-26, -2.818338487608701e-27,
  9.183308034698254e-29, -2.747539814856317e-30,  8.653906527125368e-18, -2.551909965589327e-18,  3.931459384018586e-19, -4.123699971752623e-20,  3.295647914059648e-21,
 -2.136023444907300e-22,  1.168091174820256e-23, -5.538809945194101e-25,  2.323222921683904e-26, -8.751815187269137e-28,  2.996561615106589e-29, -9.408122194396662e-31,
  1.661066597741796e-18, -5.184815853018274e-19,  8.469301368633223e-20, -9.409873664108981e-21,  7.954562810170066e-22, -5.445021095580881e-23,  3.140041977615656e-24,
 -1.567867652890878e-25,  6.915337130946702e-27, -2.735724447203995e-28,  9.824204925110472e-30, -3.230861130916188e-31,  3.320833013512228e-19, -1.093272420754856e-19,
  1.887532983894394e-20, -2.214945603095782e-21,  1.975059421120681e-22, -1.424129529214393e-23,  8.639156499037046e-25, -4.531542479844212e-26,  2.096941348460657e-27,
 -8.692394310916366e-29,  3.266921972502310e-30, -1.123058619162515e-31,  7.002456104744604e-20, -2.422280746111099e-20,  4.405110633514152e-21, -5.442103694807002e-22,
  5.103292989300265e-23, -3.864992926376624e-24,  2.459528752354156e-25, -1.351665216701507e-26,  6.545287978280335e-28, -2.835935808017169e-29,  1.112817946652135e-30,
 -3.989463063621291e-32,  1.577737362683702e-20, -5.711752290537945e-21,  1.090079100406615e-21, -1.412812988324659e-22,  1.388606239637159e-23, -1.101056868945911e-24,
  7.327409108841172e-26, -4.206428861672013e-27,  2.125390450371289e-28, -9.598560483322296e-30,  3.921780921686228e-31, -1.462359232574186e-32,  3.847941261091048e-21,
 -1.451773079131232e-21,  2.896006768055204e-22, -3.922585202056174e-23,  4.025980794590048e-24, -3.330327292863499e-25,  2.309776381117807e-26, -1.380486073661427e-27,
  7.254714865261426e-29, -3.404287557886818e-30,  1.443876343352583e-31, -5.583340278281287e-33,  1.028384191035356e-21, -4.025720327948966e-22,  8.357403956493210e-23,
 -1.178054840116927e-23,  1.257490566888196e-24, -1.080926343803412e-25,  7.783338688956603e-27, -4.825262734334510e-28,  2.627923508887704e-29, -1.276852992127341e-30,
  5.602680831124658e-32, -2.239327126782586e-33,  3.043435274572673e-22, -1.230446061230789e-22,  2.645990938646115e-23, -3.863851115491604e-24,  4.270421845106976e-25,
 -3.798083445629765e-26,  2.827486299881131e-27, -1.810834044645302e-28,  1.018010671578184e-29, -5.101844555173669e-31,  2.307286516861978e-32, -9.497127676042482e-34,
  1.004218379135705e-22, -4.172972196279047e-23,  9.249089616321506e-24, -1.392285842910012e-24,  1.585617683810632e-25, -1.452300096513904e-26,  1.112688925675306e-27,
 -7.328960138093795e-29,  4.234631978770520e-30, -2.179733603439896e-31,  1.011834984557050e-32, -4.271984084277417e-34,  3.693252413143473e-23, -1.569562214146519e-23,
  3.566617800382817e-24, -5.505461585901076e-25,  6.427427491451985e-26, -6.032044116828012e-27,  4.732844137868512e-28, -3.190755934955568e-29,  1.885954485629271e-30,
 -9.925384632935118e-32,  4.708150815599158e-33, -2.030091838049969e-34,  1.490212547883118e-23, -6.443762305680319e-24,  1.492865107971831e-24, -2.349860281394139e-25,
  2.796876677343453e-26, -2.675065699285252e-27,  2.138211215688949e-28, -1.467903660347356e-29,  8.831335959520000e-31, -4.728799950249312e-32,  2.281300387414472e-33,
 -9.999540054754704e-35,  6.227586673250300e-24, -2.725535257563671e-24,  6.400542908836005e-25, -1.021381834361714e-25,  1.232269989567527e-26, -1.194394808549630e-27,
  9.672160569529639e-29, -6.725159573184468e-30,  4.096707152477034e-31, -2.220419588170828e-32,  1.083967267183194e-33, -4.806458861453684e-35,  2.112156047164133e-24,
 -9.306425324727312e-25,  2.202127898677495e-25, -3.541185534742471e-26,  4.304941911643426e-27, -4.203895614182202e-28,  3.429277090080185e-29, -2.401517397171990e-30,
  1.473161026943804e-31, -8.039165181788918e-33,  3.950773137662059e-34, -1.763208316010158e-35,  5.190336574677617e-02, -1.106588097923276e-04,  2.430254202105415e-07,
 -5.476358978726784e-10,  1.259661529643363e-12, -2.943401909976250e-15,  6.951746777164895e-18, -1.654460608110661e-20,  3.951866102937412e-23, -9.469455593062530e-26,
  2.266986648574365e-28, -5.438005938701132e-31,  4.839441896090035e-02, -1.220237554734731e-04,  3.631703957917028e-07, -1.144091224795598e-09,  3.619509342815758e-12,
 -1.130625284434193e-14,  3.475060906752136e-17, -1.051891494031792e-19,  3.140724547396750e-22, -9.266791536622282e-25,  2.705139242365121e-27, -7.823570189517628e-30,
  4.207334174908557e-02, -1.389045850351264e-04,  5.724954852088716e-07, -2.333615870599939e-09,  9.116505628856484e-12, -3.432357913611397e-14,  1.254638179406570e-16,
 -4.476228248808425e-19,  1.564475160591411e-21, -5.371083939080296e-24,  1.815035820396784e-26, -6.047262560429613e-29,  3.410793554822646e-02, -1.526170605892370e-04,
  8.156619333743744e-07, -4.033496414079018e-09,  1.867354393140348e-11, -8.236685351297623e-14,  3.497424329537795e-16, -1.439016077267326e-18,  5.764027130342478e-21,
 -2.255566804845965e-23,  8.646745337630074e-26, -3.254405725464792e-28,  2.578567016586352e-02, -1.558527206810250e-04,  1.027003211260080e-06, -6.001846989484968e-09,
  3.238908746972262e-11, -1.648958979744972e-13,  8.014891102328807e-16, -3.749000100349916e-18,  1.697350981911131e-20, -7.470727284216934e-23,  3.207517725502352e-25,
 -1.346987463346741e-27,  1.818142526178855e-02, -1.457269289694756e-04,  1.150027968645079e-06, -7.839961179095823e-09,  4.876674799034638e-11, -2.833749450363455e-13,
  1.559747582304832e-15, -8.209472174838223e-18,  4.160250614316092e-20, -2.040342772264477e-22,  9.723033558483879e-25, -4.516351948340252e-27,  1.195834989892823e-02,
 -1.242892081347030e-04,  1.155399295628510e-06, -9.106054980170302e-09,  6.470110627405297e-11, -4.253926682871024e-13,  2.629838629744183e-15, -1.545504288094690e-17,
  8.701990097385674e-20, -4.721971225364607e-22,  2.480603967242640e-24, -1.266128102909249e-26,  7.338254270784517e-03, -9.676538869177648e-05,  1.048788731403774e-06,
 -9.485355476260374e-09,  7.641464486454656e-11, -5.645297329428661e-13,  3.894606947854953e-15, -2.539981420215061e-17,  1.579768875541285e-19, -9.431811133078497e-22,
  5.432890904756565e-24, -3.031312614371544e-26,  4.202384930259932e-03, -6.892901408139870e-05,  8.646919608324745e-07, -8.916216042702822e-09,  8.094024486740098e-11,
 -6.681139033474260e-13,  5.116515261359591e-15, -3.684706527429864e-17,  2.519532361201381e-19, -1.647572537654400e-21,  1.036055534101468e-23, -6.292566007200884e-26,
  2.246494912745073e-03, -4.504432824295857e-05,  6.501487263676005e-07, -7.599850031077547e-09,  7.733776209055869e-11, -7.098993705428036e-13,  6.008305235546051e-15,
 -4.758125119612946e-17,  3.562780012752286e-19, -2.542100074604312e-21,  1.738812357132447e-23, -1.145554685952580e-25,  1.121427130787247e-03, -2.707467395352393e-05,
  4.472645682348193e-07, -5.897057977214216e-09,  6.697106092048123e-11, -6.808532922157239e-13,  6.344649345312522e-15, -5.505679165689607e-17,  4.499270073845575e-19,
 -3.491652111467030e-21,  2.589842617606817e-23, -1.845280246488087e-25,  5.229620571727527e-04, -1.500419530200612e-05,  2.823075893075514e-07, -4.179446714068519e-09,
  5.276480860752454e-11, -5.920304632846484e-13,  6.054582156616592e-15, -5.739600432325621e-17,  5.104289604483150e-19, -4.296463453074880e-21,  3.446558110749228e-23,
 -2.649055668342680e-25,  2.279357327507456e-04, -7.683128858251252e-06,  1.638896066004416e-07, -2.713436270524018e-09,  3.795071512662615e-11, -4.684972672202225e-13,
  5.243179911641547e-15, -5.415378445527810e-17,  5.227702577925806e-19, -4.761362356945267e-21,  4.121341498443962e-23, -3.409555933265063e-25,  9.290610740622586e-05,
 -3.642608592206497e-06,  8.770471472722491e-08, -1.617983893117524e-09,  2.499217100816422e-11, -3.385159835282773e-13,  4.135393528271151e-15, -4.642644839783031e-17,
  4.854145723564508e-19, -4.773776469727664e-21,  4.449651669153902e-23, -3.954535727854373e-25,  3.543681498767463e-05, -1.601966389661045e-06,  4.335606601791333e-08,
 -8.882414619523522e-10,  1.511020160334975e-11, -2.240031723653581e-13,  2.980297216185557e-15, -3.629209866638887e-17,  4.101750806961147e-19, -4.347465695408590e-21,
  4.355937795916763e-23, -4.151608992833417e-25,  1.265847732454207e-05, -6.547034398802208e-07,  1.983860099997852e-08, -4.499689056336808e-10,  8.408430893021375e-12,
 -1.361217476228853e-13,  1.968403069772910e-15, -2.595088089959976e-17,  3.164850147330733e-19, -3.609218825118528e-21,  3.881054181362606e-23, -3.960836368363507e-25,
  4.238563390011943e-06, -2.490905990071446e-07,  8.419227004174256e-09, -2.108097102970436e-10,  4.317052604101941e-12, -7.616080342123039e-14,  1.194792163164473e-15,
 -1.702452061191940e-17,  2.236807954372223e-19, -2.740502832705315e-21,  3.158187990767852e-23, -3.446542921013813e-25,  1.331757502710129e-06, -8.838325283146525e-08,
  3.320508502652110e-09, -9.153969322152548e-11,  2.049819021749333e-12, -3.933364622101334e-14,  6.682818925617056e-16, -1.027567647146429e-17,  1.452408686832935e-19,
 -1.909156125579534e-21,  2.354834009054489e-23, -2.744598080843105e-25,  3.931282495517268e-07, -2.930133432676631e-08,  1.219557689659713e-09, -3.692371804042027e-11,
  9.022547129306730e-13, -1.879811764783762e-14,  3.453514443077974e-16, -5.722140201007766e-18,  8.689330356556872e-20, -1.223914435512393e-21,  1.613879826766930e-23,
 -2.006668352995186e-25,  1.091855382927221e-07, -9.094097066511763e-09,  4.180228121610363e-10, -1.386680592303344e-11,  3.690459157808642e-13, -8.334587406404946e-15,
  1.653281089585126e-16, -2.947911312382312e-18,  4.803532872646868e-20, -7.241723299056926e-22,  1.019754481218847e-23, -1.351264207744014e-25,  2.857823924226040e-08,
 -2.647893754460866e-09,  1.340263162900256e-10, -4.860386689813676e-12,  1.406254735587034e-13, -3.437242934651995e-15,  7.351777256148274e-17, -1.408940129588802e-18,
  2.460726526118057e-20, -3.966440892964545e-22,  5.958753909240811e-24, -8.406760790401800e-26,  7.062788706499135e-09, -7.249495038161295e-10,  4.029413870253560e-11,
 -1.594067145656373e-12,  5.005383490892373e-14, -1.322163256031641e-15,  3.045250749257130e-17, -6.265398669153774e-19,  1.171601220438439e-20, -2.017172648089401e-22,
  3.229935682243601e-24, -4.847431611532021e-26,  1.651764414223794e-09, -1.871037548170832e-10,  1.138992893604910e-11, -4.905594166508390e-13,  1.668941570491440e-14,
 -4.757487691663281e-16,  1.178511377433618e-17, -2.600173492280787e-19,  5.200595326641423e-21, -9.555069796679375e-23,  1.629291469832289e-24, -2.598955026996016e-26,
  3.664886689675429e-10, -4.565115607913137e-11,  3.036063298386723e-12, -1.420838697197371e-13,  5.229025486522155e-15, -1.606406494033680e-16,  4.274758355183047e-18,
 -1.010319337339163e-19,  2.159263734925857e-21, -4.229730287503718e-23,  7.674069412828387e-25, -1.300053427859913e-26,  7.737360840437964e-11, -1.056310955089704e-11,
  7.656589578449230e-13, -3.886145474206276e-14,  1.544718471374344e-15, -5.107486766477274e-17,  1.458339422436205e-18, -3.688348201073478e-20,  8.415173511459231e-22,
 -1.755963697843738e-23,  3.387045323595004e-25, -6.089129525681599e-27,  1.559617007351820e-11, -2.326234287845576e-12,  1.833515238992764e-13, -1.007456197412896e-14,
  4.318691348185546e-16, -1.534856001711438e-17,  4.696955409280411e-19, -1.269899186687616e-20,  3.090133856428902e-22, -6.862762661680342e-24,  1.406194418414868e-25,
 -2.680682792328591e-27,  3.013206617057988e-12, -4.895422611542455e-13,  4.186404423247195e-14, -2.485783796984574e-15,  1.147448092087591e-16, -4.377668718228300e-18,
  1.434139980180116e-19, -4.140722820388638e-21,  1.073623880249986e-22, -2.535506896213471e-24,  5.514401356820489e-26, -1.113855869481441e-27,  5.604899348134481e-13,
 -9.889807415367969e-14,  9.156102696188229e-15, -5.864649825054435e-16,  2.910733966234218e-17, -1.190525467770243e-18,  4.170447012142242e-20, -1.284526832500113e-21,
  3.545434484549777e-23, -8.895815163273673e-25,  2.051840968265606e-26, -4.387937501426547e-28,  1.008921392329430e-13, -1.927954483660522e-14,  1.928200324324480e-15,
 -1.329899511802289e-16,  7.086107970095191e-18, -3.103054052795059e-19,  1.160938063580317e-20, -3.810428168744866e-22,  1.118449101687733e-23, -2.978737708439881e-25,
  7.280063866549751e-27, -1.646937193449782e-28,  1.767803757802613e-14, -3.648092307413895e-15,  3.932890805546667e-16, -2.915595145632569e-17,  1.665190805174716e-18,
 -7.796294925058414e-20,  3.111291208679607e-21, -1.086959059467387e-22,  3.389321260709947e-24, -9.571932779254283e-26,  2.476528483656234e-27, -5.921403174517053e-29,
  3.035170536883081e-15, -6.744923816479478e-16,  7.820907384762289e-17, -6.220296822647761e-18,  3.801774951726012e-19, -1.900285779221289e-20,  8.078441074780655e-22,
 -3.000387772302018e-23,  9.927516052106445e-25, -2.969854624048049e-26,  8.126086322418107e-28, -2.051553668597536e-29,  5.144846569098668e-16, -1.227666551837985e-16,
  1.527601023433031e-17, -1.300939533583515e-18,  8.494180940912858e-20, -4.525692896757283e-21,  2.046582731280756e-22, -8.070140861194261e-24,  2.829890563605938e-25,
 -8.957031323502524e-27,  2.588990720393782e-28, -6.894283292980063e-30,  8.683301178428432e-17, -2.218329473000790e-17,  2.955142403914928e-18, -2.689210275540266e-19,
  1.872302926086400e-20, -1.061545077480228e-21,  5.098486649555743e-23, -2.131390621262973e-24,  7.910099232828599e-26, -2.645527268685717e-27,  8.067907320355807e-29,
 -2.263387938683677e-30,  1.473142181112121e-17, -4.016901098016540e-18,  5.714560904953354e-19, -5.544614734817515e-20,  4.108098550271492e-21, -2.474006743935500e-22,
  1.259840889432141e-23, -5.574494799417972e-25,  2.186201755948007e-26, -7.714779407495883e-28,  2.478840109413089e-29, -7.316466501476755e-31,  2.538833413158244e-18,
 -7.365416274487356e-19,  1.116020791234332e-19, -1.151774394016733e-20,  9.061587707836494e-22, -5.784653143964239e-23,  3.117260855185442e-24, -1.457286164713709e-25,
  6.029026495940613e-27, -2.241133553231452e-28,  7.574980388461744e-30, -2.348681784586816e-31,  4.496706839438883e-19, -1.383286150109553e-19,  2.226000843512124e-20,
 -2.437230251206735e-21,  2.031196550318845e-22, -1.371366722577954e-23,  7.803678739624840e-25, -3.846511526718628e-26,  1.675482446945454e-27, -6.548386054581634e-29,
  2.324090014860230e-30, -7.556589833381487e-32,  8.288988787283172e-20, -2.694176492264760e-20,  4.590156226479443e-21, -5.316578780352071e-22,  4.681037245638495e-23,
 -3.334045749455743e-24,  1.998571160891741e-25, -1.036289979418858e-26,  4.742011630031158e-28, -1.944482457779804e-29,  7.231560989583280e-31, -2.460742322332690e-32,
  1.611778381400837e-20, -5.514355817749032e-21,  9.913180445946681e-22, -1.210820401963603e-22,  1.122916919322580e-23, -8.413381085766684e-25,  5.298340065739864e-26,
 -2.882445300300161e-27,  1.382158149828865e-28, -5.931848557442555e-30,  2.306240888528946e-31, -8.194194658744117e-33,  3.352878446265474e-21, -1.202619095506611e-21,
  2.272772446318862e-22, -2.917210040385243e-23,  2.840196460871698e-24, -2.231415875972595e-25,  1.471771035966062e-26, -8.376027267416455e-28,  4.196721849651637e-29,
 -1.879890812550215e-30,  7.620242917070093e-32, -2.819714629143719e-33,  7.568746927626925e-22, -2.834029701141219e-22,  5.607721303163483e-23, -7.534712514791990e-24,
  7.672753771216169e-25, -6.298593756750803e-26,  4.336094884792807e-27, -2.572926194131293e-28,  1.342684833081210e-29, -6.257882782373694e-31,  2.636722770357063e-32,
 -1.013096089123271e-33,  1.879660727966178e-22, -7.314279531239709e-23,  1.508672202777292e-23, -2.112985441814779e-24,  2.241304328027525e-25, -1.914819944000943e-26,
  1.370590384995342e-27, -8.447861871238398e-29,  4.575045151170460e-30, -2.210808185295488e-31,  9.649435656834464e-33, -3.836990428675687e-34,  5.197853908109824e-23,
 -2.092011196488006e-23,  4.476658580352179e-24, -6.505082287696661e-25,  7.155015881087382e-26, -6.333789700561870e-27,  4.693688176306030e-28, -2.992696488306205e-29,
  1.675180312308876e-30, -8.360171886133671e-32,  3.765478907555077e-33, -1.543818516273826e-34,  1.614197021056569e-23, -6.686228227332267e-24,  1.476735500937774e-24,
 -2.215121803624118e-25,  2.513969708414783e-26, -2.294806784647424e-27,  1.752388708545121e-28, -1.150549423730199e-29,  6.627103696144153e-31, -3.400907244481236e-32,
  1.574060420426582e-33, -6.626754647159040e-35,  5.637168917451821e-24, -2.390658840431744e-24,  5.419802477787508e-25, -8.346492245401472e-26,  9.721808130797303e-27,
 -9.103253511356524e-28,  7.126912695622885e-29, -4.794522192954560e-30,  2.828008663884349e-31, -1.485318062689305e-32,  7.031844634565386e-34, -3.026266426371167e-35,
  2.182506779854842e-24, -9.425716889692228e-25,  2.180725439552181e-25, -3.427865164499306e-26,  4.074410072412994e-27, -3.891778367425310e-28,  3.106707718116581e-29,
 -2.130089433344117e-30,  1.279945625286786e-31, -6.845339762586644e-33,  3.298521398228594e-34, -1.444190466322364e-35,  8.855133095882159e-25, -3.873158123964063e-25,
  9.089414543384448e-26, -1.449471515472355e-26,  1.747564431934917e-27, -1.692725055372912e-28,  1.369870147199244e-29, -9.518803267888383e-31,  5.794887913148241e-32,
 -3.138932499668927e-33,  1.531462009110104e-34, -6.786804441320162e-36,  2.953370520445934e-25, -1.300966074963525e-25,  3.077528959420904e-26, -4.947463100370124e-27,
  6.012789372974019e-28, -5.869983876930413e-29,  4.787025059427550e-30, -3.351421112543003e-31,  2.055302198910101e-32, -1.121297078283107e-33,  5.509068326112728e-35,
 -2.458036804353436e-36,  5.146457777188669e-02, -1.087405547416524e-04,  2.365728032375767e-07, -5.279433475996419e-10,  1.202425112886001e-12, -2.781979163977245e-15,
  6.505701891815331e-18, -1.533284860597998e-20,  3.626727640908862e-23, -8.608737743186885e-26,  2.040869129031353e-28, -4.852059831347634e-31,  4.791204908200479e-02,
 -1.191723410753756e-04,  3.497814559629205e-07, -1.087943742327386e-09,  3.401491604360485e-12, -1.050647618966877e-14,  3.194114723853066e-17, -9.565236920713245e-20,
  2.825795444094925e-22, -8.250529386389750e-25,  2.383459815072657e-27, -6.822518715255770e-30,  4.152670941516959e-02, -1.344342061553749e-04,  5.453451442955280e-07,
 -2.193084110212115e-09,  8.459158650462631e-12, -3.145736541244262e-14,  1.136031650670243e-16, -4.005182844611369e-19,  1.383567871758259e-21, -4.695591353402786e-24,
  1.568824107500903e-26, -5.168535231121817e-29,  3.351021836030503e-02, -1.462804160472913e-04,  7.689997152620584e-07, -3.747455677434352e-09,  1.710698597559703e-11,
 -7.443642890316500e-14,  3.119147974790428e-16, -1.266918767775866e-18,  5.010977824077534e-21, -1.936712205994883e-23,  7.334342431624349e-26, -2.727437433110435e-28,
  2.517824730944925e-02, -1.479162178390130e-04,  9.579848590521455e-07, -5.508994409076194e-09,  2.927533113345026e-11, -1.468608464701028e-13,  7.037339291237255e-16,
 -3.246514375895683e-18,  1.450138949050101e-20, -6.298819992991010e-23,  2.669497357563677e-25, -1.106829814304672e-27,  1.761634033109247e-02, -1.368901766945075e-04,
  1.060449395999047e-06, -7.103074823649290e-09,  4.345571904071063e-11, -2.485554789964758e-13,  1.347467397223146e-15, -6.988581572441711e-18,  3.491195638906619e-20,
 -1.688430411208884e-22,  7.936553016122351e-25, -3.637287002441410e-27,  1.147901141488044e-02, -1.154661307328330e-04,  1.052067902531686e-06, -8.135612462621265e-09,
  5.679092412599999e-11, -3.671698201491819e-13,  2.233657286936845e-15, -1.292428001220077e-17,  7.168027843071511e-20, -3.832791892827793e-22,  1.984738433665406e-24,
 -9.988567278790419e-27,  6.967280700757307e-03, -8.881041737019584e-05,  9.419434959840257e-07, -8.348199264693806e-09,  6.600397349121556e-11, -4.790521959214151e-13,
  3.249365871049114e-15, -2.084836045798860e-17,  1.276326166219551e-19, -7.503714401672851e-22,  4.257808122843531e-24, -2.340998406013212e-26,  3.939856107598661e-03,
 -6.241841488152419e-05,  7.650473683265627e-07, -7.721733481267288e-09,  6.872684725511164e-11, -5.568391619021021e-13,  4.189296171248418e-15, -2.965869789982032e-17,
  1.994778532511614e-19, -1.283661957217300e-21,  7.946909862965426e-24, -4.753445911677256e-26,  2.076170727341453e-03, -4.018792566526961e-05,  5.659306124927696e-07,
 -6.468625740056008e-09,  6.448016967307551e-11, -5.804790384055131e-13,  4.822787730346796e-15, -3.751964338863023e-17,  2.761551224152836e-19, -1.937859149848493e-21,
  1.304192152088548e-23, -8.457358400150263e-26,  1.019860908788967e-03, -2.376238369540160e-05,  3.825051661972631e-07, -4.926680396954086e-09,  5.475978230529803e-11,
 -5.455632263445715e-13,  4.987068128437017e-15, -4.248525325102485e-17,  3.410699058951104e-19, -2.601643411910904e-21,  1.897643577357468e-23, -1.330186203993522e-25,
  4.671636961610736e-04, -1.293284717774774e-05,  2.368530679526511e-07, -3.422554420013779e-09,  4.225609025761390e-11, -4.642937780616763e-13,  4.654686390071861e-15,
 -4.329220940831817e-17,  3.779964917510576e-19, -3.125685935327697e-21,  2.464476901213077e-23, -1.862654766236476e-25,  1.996329170638045e-04, -6.492604475662663e-06,
  1.346832480119847e-07, -2.174830741484611e-09,  2.972544881771084e-11, -3.591139768927157e-13,  3.937415565072066e-15, -3.987671645962742e-17,  3.777412387066877e-19,
 -3.378155785247134e-21,  2.872686467066589e-23, -2.335919291629506e-25,  7.962494190700470e-05, -3.012317812742300e-06,  7.048106794787956e-08, -1.267291481246958e-09,
  1.911749033792643e-11, -2.532578729930666e-13,  3.029348122477450e-15, -3.333074896513347e-17,  3.418007406564147e-19, -3.299042658541980e-21,  3.019713662086533e-23,
 -2.636752948710837e-25,  2.966052338538543e-05, -1.293960325624100e-06,  3.401161090048971e-08, -6.787529933587219e-10,  1.127019178741696e-11, -1.633204117454480e-13,
  2.126553661066497e-15, -2.536712569226818e-17,  2.810713863977227e-19, -2.922593390486226e-21,  2.874469857700608e-23, -2.690709472028411e-25,  1.032585919857961e-05,
 -5.154974228516435e-07,  1.516402905378412e-08, -3.348745951683481e-10,  6.104997546723956e-12, -9.656529278560313e-14,  1.365984209305281e-15, -1.763373618014380e-17,
  2.107473839027792e-19, -2.356924999404513e-21,  2.486991101133849e-23, -2.491970724025891e-25,  3.362404045616695e-06, -1.907878022570041e-07,  6.258318005294160e-09,
 -1.525131972006765e-10,  3.045797883069574e-12, -5.248032618936594e-14,  8.050632345446628e-16, -1.122833844705136e-17,  1.445229666782792e-19, -1.735885510457270e-21,
  1.962402495683178e-23, -2.102038531265793e-25,  1.025110498927753e-06, -6.571011470544868e-08,  2.395431226871629e-09, -6.425366215945484e-11,  1.402695205502164e-12,
 -2.627986452489614e-14,  4.364694455053460e-16, -6.567126326613906e-18,  9.090661024260678e-20, -1.171147386814683e-21,  1.416698152516777e-23, -1.620306719457731e-25,
  2.929418082707370e-07, -2.109769449356975e-08,  8.520052407285032e-10, -2.509430583181523e-11,  5.976649370269506e-13, -1.215476720055750e-14,  2.182331695430722e-16,
 -3.537393104608814e-18,  5.259586183681455e-20, -7.259113570427915e-22,  9.385552391238353e-24, -1.144934618692281e-25,  7.857025732891113e-08, -6.326536308866585e-09,
  2.821772873709313e-10, -9.105239513274940e-12,  2.361519081988426e-13, -5.205053093746673e-15,  1.008875451127795e-16, -1.759516160525182e-18,  2.806757132528362e-20,
 -4.145542466597613e-22,  5.722993654558329e-24, -7.439111408727291e-26,  1.980951833393184e-08, -1.775394054831577e-09,  8.721054588565321e-11, -3.076437202108944e-12,
  8.673873554120062e-14, -2.068952824487295e-15,  4.323515926972692e-17, -8.103589180983777e-19,  1.385369818234389e-20, -2.187522964594804e-22,  3.221452336742816e-24,
 -4.457978104285604e-26,  4.703411110769763e-09, -4.672754596310540e-10,  2.521187071057252e-11, -9.703222329749132e-13,  2.969159698884159e-14, -7.653673370642258e-16,
  1.722265827805695e-17, -3.465366509452980e-19,  6.342771657102881e-21, -1.069726660169091e-22,  1.678999441700821e-24, -2.471529632202455e-26,  1.053873347881570e-09,
 -1.156259932843989e-10,  6.835156173211270e-12, -2.864545065733018e-13,  9.498325004959333e-15, -2.642450723276590e-16,  6.395551739300040e-18, -1.380020925673634e-19,
  2.701762475904250e-21, -4.862601251758984e-23,  8.127749695929852e-25, -1.271681873707568e-26,  2.233891156081635e-10, -2.697259998672716e-11,  1.742751667152504e-12,
 -7.938517094663618e-14,  2.848086582415580e-15, -8.540523663657391e-17,  2.220826708805606e-18, -5.133940951822590e-20,  1.074120419432243e-21, -2.061301661317440e-23,
  3.666320245116795e-25, -6.092741347022599e-27,  4.492273584140626e-11, -5.949847393053162e-12,  4.192228123602802e-13, -2.071930414044665e-14,  8.031213562240714e-16,
 -2.592680080905213e-17,  7.235545232685702e-19, -1.790274291658398e-20,  3.999302549526630e-22, -8.176957230132883e-24,  1.546475673899772e-25, -2.727674868125989e-27,
  8.598637099162445e-12, -1.245410879361563e-12,  9.548254039711413e-14, -5.111316926196999e-15,  2.137545775068623e-16, -7.419852821507173e-18,  2.219992199132457e-19,
 -5.873579375874584e-21,  1.399776844504672e-22, -3.046795280992725e-24,  6.122637716291090e-26, -1.145391531709739e-27,  1.572553605673006e-12, -2.483466765205402e-13,
  2.067367729249673e-14, -1.196664647786406e-15,  5.391676078888270e-17, -2.009996623958802e-18,  6.440637111551009e-20, -1.820434366529984e-21,  4.624354558545378e-23,
 -1.070706802885642e-24,  2.284498375929916e-26, -4.529709666662770e-28,  2.759961768899660e-13, -4.739116272573873e-14,  4.274652313417785e-15, -2.671011290591208e-16,
  1.294756419058462e-17, -5.177586796680785e-19,  1.774910117959108e-20, -5.354299656170804e-22,  1.448507842314632e-23, -3.564725441059824e-25,  8.069474795032619e-27,
 -1.694649211535062e-28,  4.672214179194821e-14, -8.698789850085077e-15,  8.484218191820905e-16, -5.713199292995387e-17,  2.975342030012352e-18, -1.274701697715381e-19,
  4.669794700866083e-21, -1.502018347599846e-22,  4.323572500646961e-24, -1.129977527144212e-25,  2.711733624718747e-27, -6.027161225909015e-29,  7.673497558440092e-15,
 -1.544843710085893e-15,  1.625888031660104e-16, -1.177908066155119e-17,  6.580831850176884e-19, -3.016676920779989e-20,  1.179670708901495e-21, -4.041451464498407e-23,
  1.236625269686694e-24, -3.429254368149754e-26,  8.717078515718823e-28, -2.048902118228773e-29,  1.230869879885855e-15, -2.672199044974216e-16,  3.028426739822064e-17,
 -2.356290030703588e-18,  1.410096332984623e-19, -6.906950654640831e-21,  2.879594945156227e-22, -1.049596026628728e-23,  3.410413424865071e-25, -1.002496669784414e-26,
  2.696818242359039e-28, -6.697418139008629e-30,  1.943056442516795e-16, -4.536273359691083e-17,  5.523962572622512e-18, -4.607397813366793e-19,  2.948664795358220e-20,
 -1.541074045149367e-21,  6.840823269852181e-23, -2.649625116531353e-24,  9.131881358087373e-26, -2.842409437299059e-27,  8.083755194672418e-29, -2.119106456660306e-30,
  3.044866374417532e-17, -7.622481645269366e-18,  9.951061940177592e-19, -8.880164539050836e-20,  6.067172565086889e-21, -3.378008512586705e-22,  1.594248246505965e-23,
 -6.552874792345990e-25,  2.392485179965496e-26, -7.876013806490165e-28,  2.365353250821524e-29, -6.537980883441597e-31,  4.782994723741476e-18, -1.280116535072236e-18,
  1.787325640865181e-19, -1.702906277347110e-20,  1.239737789609105e-21, -7.340515526649897e-23,  3.677326227438086e-24, -1.601592390030602e-25,  6.185736898033634e-27,
 -2.150753029568427e-28,  6.812083992276348e-30, -1.982861997473618e-31,  7.614311724963562e-19, -2.171918015032749e-19,  3.234913294454639e-20, -3.283166392651032e-21,
  2.541555458500557e-22, -1.597271979777954e-23,  8.478296751513116e-25, -3.905983072135172e-26,  1.593261313989291e-27, -5.841908073994173e-29,  1.948488635053868e-30,
 -5.964175300710334e-32,  1.243463610225986e-19, -3.767651429551251e-20,  5.969600572106031e-21, -6.437647460238703e-22,  5.286804225937690e-23, -3.518940607824618e-24,
  1.975040533487375e-25, -9.606266078144265e-27,  4.130680293326859e-28, -1.594350926781478e-29,  5.590304134183152e-31, -1.796411530671814e-32,  2.111003531472049e-20,
 -6.770482748564733e-21,  1.137700193926081e-21, -1.300024790421116e-22,  1.129659809962172e-23, -7.944024660718312e-25,  4.703565368207761e-26, -2.409885514519956e-27,
  1.090051366335614e-28, -4.419893228721028e-30,  1.625960707102932e-31, -5.474723592907319e-33,  3.779538502997705e-21, -1.278278167176966e-21,  2.270467105436307e-22,
 -2.740522905982872e-23,  2.512404391443505e-24, -1.861443926245381e-25,  1.159594571108486e-26, -6.242518690019415e-28,  2.962981748892734e-29, -1.259122220899665e-30,
  4.848611179140556e-32, -1.706805407405420e-33,  7.245629517028303e-22, -2.573752656966844e-22,  4.814361448020687e-23, -6.117123637739623e-24,  5.897034185118925e-25,
 -4.588748719729079e-26,  2.998521706834345e-27, -1.691144070326230e-28,  8.399371387530403e-30, -3.730588267737928e-31,  1.499792022987169e-32, -5.505501715525635e-34,
  1.510641206407963e-22, -5.611554329366595e-23,  1.100967933927233e-23, -1.466883647286734e-24,  1.481511408338637e-25, -1.206480337665304e-26,  8.241370888269429e-28,
 -4.853467476486864e-29,  2.514319358921880e-30, -1.163561966121722e-31,  4.868924067593562e-33, -1.858314389721716e-34,  3.477874003194482e-23, -1.344838501374720e-23,
  2.755143811096611e-24, -3.832763191998029e-25,  4.038729812815307e-26, -3.428278526365487e-27,  2.438592056091529e-28, -1.493965448960691e-29,  8.043197079432424e-31,
 -3.864550413177119e-32,  1.677400999161564e-33, -6.634193615242577e-35,  8.964184491616633e-24, -3.590727775938854e-24,  7.644006760867251e-25, -1.105027524230171e-25,
  1.209283821136842e-26, -1.065207863735810e-27,  7.855922155582214e-29, -4.985598355713011e-30,  2.778090371407021e-31, -1.380343616630707e-32,  6.190627406172540e-34,
 -2.527615579795324e-35,  2.613573466008575e-24, -1.078912826309707e-24,  2.374050125545333e-25, -3.547850352839620e-26,  4.011783629472610e-27, -3.648983892688406e-28,
  2.776809857509199e-29, -1.816991586401528e-30,  1.043145625286299e-31, -5.336176204144660e-33,  2.462127242962099e-34, -1.033440369712513e-35,  8.646904849806448e-25,
 -3.658901665351133e-25,  8.274586969402474e-26, -1.271137669796647e-26,  1.476995192866435e-27, -1.379737763632880e-28,  1.077695099052922e-29, -7.233718205034443e-31,
  4.257413397174285e-32, -2.231309999117736e-33,  1.054170671469850e-34, -4.527698789471415e-36,  3.205932994004463e-25, -1.382769471972376e-25,  3.194537176809649e-26,
 -5.014158981957432e-27,  5.951353878966579e-28, -5.676613100301676e-29,  4.525293082405729e-30, -3.098593921409955e-31,  1.859491603603391e-32, -9.932274282975474e-34,
  4.780119654264571e-35, -2.090381491436638e-36,  1.261010498044305e-25, -5.512044897502030e-26,  1.292627413582681e-26, -2.059841713650450e-27,  2.481691041915504e-28,
 -2.402133508673407e-29,  1.942642925441138e-30, -1.348980653063116e-31,  8.207013880055476e-33, -4.442687365953168e-34,  2.166209276889814e-35, -9.593946485693208e-37,
  4.132201613054763e-26, -1.819768728654404e-26,  4.303520653900481e-27, -6.916295294346150e-28,  8.403046947239207e-29, -8.201043772336555e-30,  6.686076107592043e-31,
 -4.679615150912761e-32,  2.869026320935499e-33, -1.564802165748893e-34,  7.685975317750811e-36, -3.428418081848024e-37,  5.103336105030218e-02, -1.068729907110131e-04,
  2.303511068578174e-07, -5.091413226698784e-10,  1.148312788972833e-12, -2.630865821531072e-15,  6.092174961549111e-18, -1.422034734902828e-20,  3.331007210559932e-23,
 -7.833517786123964e-26,  1.839000727324842e-28, -4.334297586778573e-31,  4.744087482272753e-02, -1.164254012252734e-04,  3.370458724495218e-07, -1.035160154164153e-09,
  3.198816183066227e-12, -9.771032845314607e-15,  2.938513921358087e-17, -8.706722517954690e-20,  2.545238011906952e-22, -7.354546840257289e-25,  2.102748090669748e-27,
 -5.957880555801709e-30,  4.099753462493052e-02, -1.301744590184687e-04,  5.198199219961388e-07, -2.062626336626799e-09,  7.856392935088665e-12, -2.886061258463575e-14,
  1.029839173664178e-16, -3.588319700729468e-19,  1.225294952851124e-21, -4.111266574891372e-24,  1.358211650408018e-26, -4.425139079189661e-29,  3.293712230809787e-02,
 -1.403037536569398e-04,  7.256246750835871e-07, -3.485258736682041e-09,  1.569033456042810e-11, -6.735866332444035e-14,  2.785850800786363e-16, -1.117179384923420e-18,
  4.363800097469001e-21, -1.665994631521199e-23,  6.233337750140661e-26, -2.290548001974171e-28,  2.460150246700857e-02, -1.405090252243187e-04,  8.945933201110556e-07,
 -5.063199166874921e-09,  2.649990962417615e-11, -1.310116478266322e-13,  6.190014162606678e-16, -2.816781849971318e-18,  1.241483632483547e-20, -5.322385113566019e-23,
  2.226877774391534e-25, -9.117141242542216e-28,  1.708522318384288e-02, -1.287360758723828e-04,  9.792257157570731e-07, -6.445859428051979e-09,  3.879278090807179e-11,
 -2.184435880813444e-13,  1.166555826234626e-15, -5.962825330195285e-18,  2.936847074451739e-20, -1.400801177431428e-22,  6.495823309121653e-25, -2.937626238256672e-27,
  1.103338276686368e-02, -1.074251895464701e-04,  9.596592592769508e-07, -7.282910692702927e-09,  4.995558059234222e-11, -3.176576296014955e-13,  1.901920361437050e-15,
 -1.083677768812704e-17,  5.921131508150614e-20, -3.120288205547234e-22,  1.592935079206656e-24, -7.905640494325854e-27,  6.626500083088021e-03, -8.165833146967943e-05,
  8.477985141406633e-07, -7.364737348713178e-09,  5.715777670395721e-11, -4.076347777589177e-13,  2.718953359921165e-15, -1.716537413912179e-17,  1.034518693244883e-19,
 -5.990068215343686e-22,  3.348719087722612e-24, -1.814554815168327e-26,  3.701861672484440e-03, -5.665079769428659e-05,  6.786337842343653e-07, -6.706005248535885e-09,
  5.853178349083996e-11, -4.655806678498087e-13,  3.441686329322906e-15, -2.395731500295475e-17,  1.585171794460922e-19, -1.003993138833429e-21,  6.120006959066311e-24,
 -3.605701666745540e-26,  1.924005945419371e-03, -3.595427936730598e-05,  4.941335207449629e-07, -5.523870769250950e-09,  5.394786320781565e-11, -4.764011896977674e-13,
  3.886145288517916e-15, -2.970505642757639e-17,  2.149496050611075e-19, -1.483675021147154e-21,  9.826125674817106e-24, -6.272893573047670e-26,  9.305770142805987e-04,
 -2.092471729135747e-05,  3.283018801503168e-07, -4.131694189446559e-09,  4.495508245277525e-11, -4.389969010419438e-13,  3.937181971026547e-15, -3.293379489287216e-17,
  2.597713691833055e-19, -1.947952441547324e-21,  1.397443265166240e-23, -9.638352617849535e-26,  4.189771855889554e-04, -1.119147983249526e-05,  1.995511573824451e-07,
 -2.815063087993670e-09,  3.399579904118843e-11, -3.658581992023566e-13,  3.596199675290842e-15, -3.282141278829814e-17,  2.814029554463035e-19, -2.286304059995785e-21,
  1.772073111431708e-23, -1.317201442724945e-25,  1.756628787361867e-04, -5.511959330237965e-06,  1.112175575127053e-07, -1.751903823828223e-09,  2.340431835541388e-11,
 -2.767535806356267e-13,  2.973284839612925e-15, -2.953170317457496e-17,  2.745510688645256e-19, -2.411221879686097e-21,  2.014689698777359e-23, -1.610448964436696e-25,
  6.861391768858266e-05, -2.504460079894668e-06,  5.695367863492318e-08, -9.982790259073244e-10,  1.470973282056689e-11, -1.906186322578043e-13,  2.232898696511425e-15,
 -2.408120634202424e-17,  2.422423478952597e-19, -2.295045964819924e-21,  2.063200355810892e-23, -1.770252536813139e-25,  2.498130440563672e-05, -1.051613449584641e-06,
  2.684908608293143e-08, -5.220125457609553e-10,  8.461491061098076e-12, -1.198799453296453e-13,  1.527834399180147e-15, -1.785561424997118e-17,  1.939845923594772e-19,
 -1.979066853169501e-21,  1.910944473475009e-23, -1.757047956654940e-25,  8.483207929002478e-06, -4.087345993338723e-07,  1.167322275352061e-08, -2.510189412762066e-10,
  4.465163731158428e-12, -6.901657716907287e-14,  9.551525970246976e-16, -1.207499991078362e-17,  1.414409388654416e-19, -1.551435213606024e-21,  1.606584637575278e-23,
 -1.580707104055622e-25,  2.688867324678015e-06, -1.472868791821982e-07,  4.689048856515342e-09, -1.112256621500817e-10,  2.166414853061951e-12, -3.646167799458285e-14,
  5.470050288676918e-16, -7.468401628829969e-18,  9.418099507825625e-20, -1.109111895689352e-21,  1.230113900160658e-23, -1.293441486374814e-25,  7.962039377551200e-07,
 -4.928584319546008e-08,  1.743387353439257e-09, -4.550322914443344e-11,  9.685030908698307e-13, -1.771780051537760e-14,  2.876835637929431e-16, -4.235910696672428e-18,
  5.743114175233728e-20, -7.252119922500969e-22,  8.604278919864706e-24, -9.657646631345647e-26,  2.204832325826201e-07, -1.534039505555766e-08,  6.010646705392077e-10,
 -1.722239345452976e-11,  3.998118953395555e-13, -7.937329622556050e-15,  1.392850467386021e-16, -2.208829625478832e-18,  3.215887796925684e-20, -4.349404439316343e-22,
  5.514308969144234e-24, -6.600189003628587e-26,  5.716818532729184e-08, -4.449069464027233e-09,  1.925340810869963e-10, -6.043147007897748e-12,  1.527445651258771e-13,
 -3.285812584435818e-15,  6.223318869544106e-17, -1.061658427219654e-18,  1.657988796767833e-20, -2.399240264106460e-22,  3.247311214848850e-24, -4.140896711461222e-26,
  1.389908182634021e-08, -1.204599196768073e-09,  5.741823798392170e-11, -1.970169744084740e-12,  5.412919960984967e-14, -1.259968697621253e-15,  2.572497041648481e-17,
 -4.715661379934319e-19,  7.891459569078637e-21, -1.220684227876475e-22,  1.762208403838865e-24, -2.392029962772616e-26,  3.173988144920751e-09, -3.051121430299681e-10,
  1.597789150800644e-11, -5.981849073338675e-13,  1.783670940048044e-14, -4.486670849855630e-16,  9.863640620072484e-18, -1.940903400592029e-19,  3.477198429836770e-21,
 -5.744498862378657e-23,  8.838045206390325e-25, -1.276053181743920e-26,  6.821402136898067e-10, -7.246435965529738e-11,  4.158946627730439e-12, -1.695774417576842e-13,
  5.479731409946223e-15, -1.487685644852460e-16,  3.517815545036588e-18, -7.423357406203422e-20,  1.422513718692923e-21, -2.507868547951296e-23,  4.108950155025936e-25,
 -6.305737072296749e-27,  1.382930298233395e-10, -1.617956685067763e-11,  1.015374681279183e-12, -4.501142015810640e-14,  1.574036643005269e-15, -4.606753596350660e-17,
  1.170467721841995e-18, -2.646370442083181e-20,  5.419731810217198e-22, -1.018875063798930e-23,  1.776481660529392e-25, -2.895786832517561e-27,  2.651948845772369e-11,
 -3.406172688944806e-12,  2.332255288735879e-13, -1.122165783764047e-14,  4.240932606950748e-16, -1.336515935130499e-17,  3.645117179322999e-19, -8.822371954203855e-21,
  1.929474119281488e-22, -3.865097830961329e-24,  7.166706697310251e-26, -1.240076224947075e-27,  4.825536476075561e-12, -6.783945965702479e-13,  5.057440565588496e-14,
 -2.636892720657538e-15,  1.075563894793210e-16, -3.645845222002887e-18,  1.066323894422645e-19, -2.760411117385043e-21,  6.441957545302839e-23, -1.374072568199544e-24,
  2.707708200518778e-26, -4.970307295178145e-28,  8.362705463356642e-13, -1.283165832916228e-13,  1.039417069777856e-14, -5.863332215931283e-16,  2.577887132588486e-17,
 -9.388523524504763e-19,  2.941887950623814e-20, -8.138648794451295e-22,  2.025131128222620e-23, -4.596306996690216e-25,  9.619438559700705e-27, -1.872039477011152e-28,
  1.386231226841314e-13, -2.315163084695992e-14,  2.033705133856487e-15, -1.239241581299089e-16,  5.865281306930259e-18, -2.292524595554211e-19,  7.688853267219386e-21,
 -2.271201559760673e-22,  6.021083703720498e-24, -1.453059372285808e-25,  3.227623924354360e-27, -6.655154857175603e-29,  2.208914832693170e-14, -4.004754109553783e-15,
  3.807437528617020e-16, -2.502267354775337e-17,  1.273242573963653e-18, -5.335050682347362e-20,  1.913260738670644e-21, -6.029068720286549e-23,  1.701516258629628e-24,
 -4.362883669953869e-26,  1.027850075463522e-27, -2.244028611745403e-29,  3.403180465683989e-15, -6.680176325701099e-16,  6.860339014972292e-17, -4.854989708854648e-18,
  2.652316292930029e-19, -1.189998488925740e-20,  4.558467312213630e-22, -1.530980776415251e-23,  4.595680377623067e-25, -1.251038993043837e-26,  3.123633798628358e-28,
 -7.215634619078867e-30,  5.103270599718954e-16, -1.081708860169292e-16,  1.197582017296463e-17, -9.111224024910027e-19,  5.336561055679764e-20, -2.560579882927531e-21,
  1.046563661475368e-22, -3.742423704654730e-24,  1.193777110404748e-25, -3.447079684530091e-27,  9.114220213814178e-29, -2.225931185479933e-30,  7.505827704756027e-17,
 -1.713377894666122e-17,  2.040770309022753e-18, -1.666274366599322e-19,  1.044788259918647e-20, -5.354040764095537e-22,  2.332059273848901e-23, -8.869153646747672e-25,
  3.003281745166431e-26, -9.189936610294036e-28,  2.570773155823037e-29, -6.632154192503744e-31,  1.092308359457865e-17, -2.677878848890945e-18,  3.424079335587984e-19,
 -2.994885650684904e-20,  2.007037536533386e-21, -1.096860632567951e-22,  5.084637789654993e-24, -2.054097287459947e-25,  7.375244837268297e-27, -2.388953491314651e-28,
  7.063045375186501e-30, -1.922866010027449e-31,  1.588639841830893e-18, -4.170690742514592e-19,  5.711875939141763e-20, -5.341178600111852e-21,  3.818860841796180e-22,
 -2.222123879425283e-23,  1.094654009483873e-24, -4.690819996191879e-26,  1.783502122073675e-27, -6.107689547135272e-29,  1.906233784827661e-30, -5.470157145391288e-32,
  2.335287428759661e-19, -6.545398078550118e-20,  9.577507465510946e-21, -9.554047629757103e-22,  7.273569372132247e-23, -4.498099523657595e-24,  2.350712033341346e-25,
 -1.066811016791164e-26,  4.288676264533400e-28, -1.550495959834223e-29,  5.101320961845452e-31, -1.540958185641786e-32,  3.513816324293079e-20, -1.048041028902998e-20,
  1.634068909362549e-21, -1.734736900633391e-22,  1.403116625381601e-23, -9.202893480098841e-25,  5.092274712031111e-26, -2.442955638161680e-27,  1.036571302510779e-28,
 -3.949658074842495e-30,  1.367668336501622e-31, -4.342021736256504e-33,  5.488053307491985e-21, -1.735840068407566e-21,  2.875339462304149e-22, -3.239727775041368e-23,
  2.777018181048272e-24, -1.927229450279037e-25,  1.126591218938972e-26, -5.701111688232558e-28,  2.548024711041798e-29, -1.021229579687308e-30,  3.714754388650922e-32,
 -1.237213924085340e-33,  9.034086033458679e-22, -3.018843558005839e-22,  5.295169898210482e-23, -6.313021949195247e-24,  5.718460825900587e-25, -4.187779759554938e-26,
  2.579540560267474e-27, -1.373573045433477e-28,  6.450954216866365e-30, -2.713356577255320e-31,  1.034510509729156e-32, -3.606752354164741e-34,  1.593149416217803e-22,
 -5.601741703610922e-23,  1.036657795276666e-23, -1.303301365138259e-24,  1.243509966552640e-25, -9.579851010214134e-27,  6.199444821740652e-28, -3.463672453922946e-29,
  1.704663723232973e-30, -7.504559311069282e-32,  2.991231871842328e-33, -1.088941885182601e-34,  3.061168941332907e-23, -1.127646388235023e-23,  2.192773525769092e-24,
 -2.895882471184679e-25,  2.899660555390201e-26, -2.341661944374642e-27,  1.586619538464589e-28, -9.270455547217234e-30,  4.765936440726514e-31, -2.189252290219697e-32,
  9.095228841132680e-34, -3.447249919978976e-35,  6.517646267405146e-24, -2.503591301955838e-24,  5.092554766452874e-25, -7.034295351685869e-26,  7.361023181866642e-27,
 -6.206337444200623e-28,  4.385799728255873e-29, -2.669836187983494e-30,  1.428529963950705e-31, -6.822692961401179e-33,  2.944196607325898e-34, -1.157899390003035e-35,
  1.561809089715629e-24, -6.224647757363546e-25,  1.317890797700138e-25, -1.894804517478270e-26,  2.062530889073584e-27, -1.807371314251635e-28,  1.326216031928305e-29,
 -8.375330712507765e-31,  4.644735685097311e-32, -2.297166640116543e-33,  1.025626836603726e-34, -4.169428953085822e-36,  4.264092790895030e-25, -1.753959254836310e-25,
  3.844265946580433e-26, -5.722409764550118e-27,  6.445745675790972e-28, -5.840784226564175e-29,  4.428467340845814e-30, -2.887442453095237e-31,  1.651972994365326e-32,
 -8.422270023321559e-34,  3.873402664765502e-35, -1.620671976853292e-36,  1.333293767451841e-25, -5.628492565962530e-26,  1.269566105488529e-26, -1.945206659381572e-27,
  2.254424751899291e-28, -2.100695380783343e-29,  1.636820201914389e-30, -1.096060180883212e-31,  6.435989929981927e-33, -3.365538411647453e-34,  1.586566622783256e-35,
 -6.799969698663638e-37,  4.724078814214043e-26, -2.034772336350492e-26,  4.693633124773356e-27, -7.355809169996825e-28,  8.717449108431173e-29, -8.302689588742853e-30,
  6.609189091895394e-31, -4.519127735158342e-32,  2.708252400523567e-33, -1.444657111231794e-34,  6.943713874671806e-36, -3.032721276878944e-37,  1.798561212049458e-26,
 -7.856478868965525e-27,  1.841033233993891e-27, -2.931513971758525e-28,  3.529227776517645e-29, -3.413573766405215e-30,  2.758623715810006e-31, -1.914255814247446e-32,
  1.163808849614448e-33, -6.295813414259846e-35,  3.067773866766149e-36, -1.357828482874382e-37,  5.785325990738959e-27, -2.547090801518678e-27,  6.021688856488435e-28,
 -9.674573007079383e-29,  1.175058872062525e-29, -1.146458212940038e-30,  9.343912935322028e-32, -6.537899463037539e-33,  4.007149873111821e-34, -2.184921170360391e-35,
  1.072884340660218e-36, -4.784404760039140e-38,  5.060951644617139e-02, -1.050543122465267e-04,  2.243499380106702e-07, -4.911814456251745e-10,  1.097125954408269e-12,
 -2.489313765833980e-15,  5.708514108037480e-18, -1.319816285909149e-20,  3.061794484183558e-23, -7.134670675651676e-26,  1.658569160655169e-28, -3.876379348707333e-31,
  4.698048848868683e-02, -1.137778664621433e-04,  3.249247099686719e-07, -9.855049548981972e-10,  3.010255145904968e-12, -9.094147630013370e-15,  2.705741612416630e-17,
 -7.933035118198672e-20,  2.295003240747989e-22, -6.563596943433401e-25,  1.857446715032934e-27, -5.209974588057350e-30,  4.048500010810396e-02, -1.261128117800727e-04,
  4.958039975323513e-07, -1.941410794733570e-09,  7.303105323993176e-12, -2.650526854376230e-14,  9.346403024704194e-17, -3.218894586311175e-19,  1.086616949094081e-21,
 -3.604993089309630e-24,  1.177742534778126e-26, -3.795089491537042e-29,  3.238725830161920e-02, -1.346618809813004e-04,  6.852645339949686e-07, -3.244637853491055e-09,
  1.440756721047974e-11, -6.103275162218963e-14,  2.491721961124419e-16, -9.866717322485670e-19,  3.806595777304064e-21, -1.435700734986086e-23,  5.307780030672652e-26,
 -1.927553470882787e-28,  2.405340497596182e-02, -1.335882982714763e-04,  8.362949970327345e-07, -4.659381328882127e-09,  2.402207325965428e-11, -1.170588713516897e-13,
  5.454171406693142e-16, -2.448520353715452e-18,  1.064989683719638e-20, -4.506950595279284e-23,  1.861861689200023e-25, -7.527899968809375e-28,  1.658547107727070e-02,
 -1.212014421879279e-04,  9.054601137188539e-07, -5.858659632282535e-09,  3.469088855509070e-11, -1.923480475710112e-13,  1.012030019138793e-15, -5.098947895202416e-18,
  2.476373183161034e-20, -1.165084163606743e-22,  5.330670759966905e-25, -2.379123595752117e-27,  1.061850162166152e-02, -1.000843744911043e-04,  8.768581734825271e-07,
 -6.532065962620048e-09,  4.403537512020579e-11, -2.754485460481592e-13,  1.623412442921617e-15, -9.110096125215165e-18,  4.904604241069242e-20, -2.547599145294190e-22,
  1.282360858156739e-24, -6.276922759186817e-27,  6.312892973142193e-03, -7.521450118874787e-05,  7.646508275818888e-07, -6.512045901306316e-09,  4.962055088749906e-11,
 -3.477924191905725e-13,  2.281603146641167e-15, -1.417557457955723e-17,  8.411794179913973e-20, -4.797618150655296e-22,  2.642847981821384e-24, -1.411562562588309e-26,
  3.485628544434576e-03, -5.152837464375218e-05,  6.034874276556511e-07, -5.839719833415518e-09,  4.999466622516869e-11, -3.904884370677133e-13,  2.836783286331811e-15,
 -1.941875622170441e-17,  1.264224939805054e-19, -7.882126767303255e-22,  4.731532174152441e-24, -2.746177630754617e-26,  1.787694951201290e-03, -3.225237573516606e-05,
  4.327273163217285e-07, -4.732131029636316e-09,  4.528896022722045e-11, -3.923841127144495e-13,  3.143182580247535e-15, -2.361049620077655e-17,  1.679937617213252e-19,
 -1.140762400779306e-21,  7.435789586848646e-24, -4.673765794377225e-26,  8.518333896391712e-04, -1.848503119902248e-05,  2.827633127652297e-07, -3.477815712643346e-09,
  3.704996731370670e-11, -3.546920910048391e-13,  3.121594613062561e-15, -2.564303167657936e-17,  1.987618151227582e-19, -1.465444721513285e-21,  1.034137410564286e-23,
 -7.019064743696512e-26,  3.772024977612925e-04, -9.721473861940843e-06,  1.688069092570861e-07, -2.325273251806083e-09,  2.747223709746505e-11, -2.896312758325843e-13,
  2.791808567270010e-15, -2.500721154420624e-17,  2.105710716376845e-19, -1.681192786410755e-21,  1.281139504042635e-23, -9.366783333697796e-26,  1.552698404002700e-04,
 -4.700341081514001e-06,  9.227070066259824e-08, -1.418102395415791e-09,  1.852066685298751e-11, -2.143995911173089e-13,  2.257379959255241e-15, -2.199227891991376e-17,
  2.006925089518473e-19, -1.731162237686463e-21,  1.421452640361817e-23, -1.117118274496982e-25,  5.943675607297597e-05, -2.093018897337212e-06,  4.626949765209102e-08,
 -7.907250004319758e-10,  1.138286233894445e-11, -1.443154040810378e-13,  1.655781738032316e-15, -1.750620535050155e-17,  1.727711964908622e-19, -1.606941310180779e-21,
  1.418994527445215e-23, -1.196522462466762e-25,  2.116778733810555e-05, -8.597459067044757e-07,  2.132413566277476e-08, -4.039753436802227e-10,  6.393439773187376e-12,
 -8.857086684648289e-14,  1.105041805837245e-15, -1.265443295485098e-17,  1.348160772619969e-19, -1.349688452964378e-21,  1.279600147896553e-23, -1.155816920342404e-25,
  7.017549509297646e-06, -3.262805506077781e-07,  9.047841496620607e-09, -1.894798272553750e-10,  3.289122093041575e-12, -4.968615208699562e-14,  6.728330008833393e-16,
 -8.330931803252439e-18,  9.565463614776013e-20, -1.029181134543205e-21,  1.046052889591183e-23, -1.010715477306677e-25,  2.167055708481267e-06, -1.145751724444411e-07,
  3.540382092031934e-09, -8.174901177275995e-11,  1.553139194365520e-12, -2.553613675812250e-14,  3.746979390256691e-16, -5.008617384599887e-18,  6.188932369241565e-20,
 -7.146644778297804e-22,  7.777140969332248e-24, -8.028112468375746e-26,  6.238357588584718e-07, -3.728414636565411e-08,  1.279744507048777e-09, -3.250376519008631e-11,
  6.745630254690520e-13, -1.205092937873637e-14,  1.913117694572896e-16, -2.756925294318397e-18,  3.661397368409508e-20, -4.532162093757761e-22,  5.274448223280063e-24,
 -5.810422985824107e-26,  1.675687751127412e-07, -1.126078496163708e-08,  4.280747975987873e-10, -1.193285548152594e-11,  2.700288008471488e-13, -5.233444405331352e-15,
  8.976457278480097e-17, -1.392804009093762e-18,  1.985780556148904e-20, -2.632017154696136e-22,  3.272396723566862e-24, -3.843310583233261e-26,  4.204585053841201e-08,
 -3.161834673012195e-09,  1.327488060764871e-10, -4.052934327312821e-12,  9.983541669148443e-14, -2.096145989017236e-15,  3.879606883686880e-17, -6.474099275575223e-19,
  9.898830915891473e-21, -1.403506233220243e-22,  1.862495245641711e-24, -2.330022345715153e-26,  9.868154228824371e-09, -8.268158789034994e-10,  3.823855207804635e-11,
 -1.276175703633171e-12,  3.416617153281274e-14, -7.761007789452601e-16,  1.548208934638928e-17, -2.775716156571075e-19,  4.547032840861028e-21, -6.890422172846833e-23,
  9.751411917228052e-25, -1.298412459422804e-26,  2.169769032934922e-09, -2.017570437516643e-10,  1.025298739232895e-11, -3.733659060023757e-13,  1.084812581750306e-14,
 -2.662721360211461e-16,  5.718942676547680e-18, -1.100520135015886e-19,  1.929831466295526e-21, -3.123004378161612e-23,  4.709832124394646e-25, -6.669879500846540e-27,
  4.477777918596274e-10, -4.604150887991875e-11,  2.565014101132456e-12, -1.017413064685262e-13,  3.203691576868275e-15, -8.487261121228945e-17,  1.960649778522791e-18,
 -4.046051127351324e-20,  7.588737836305833e-22, -1.310491694089952e-23,  2.104630408984293e-25, -3.167885556462533e-27,  8.692312062556360e-11, -9.850207364398591e-12,
  6.002725565538313e-13, -2.589192926930697e-14,  8.824292204382836e-16, -2.520376972047100e-17,  6.256461136909959e-19, -1.383390954758986e-20,  2.773135161195136e-22,
 -5.106759843664889e-24,  8.728003746155093e-26, -1.395482499422357e-27,  1.591306445563314e-11, -1.981252745307693e-12,  1.317947720830004e-13, -6.172175839245409e-15,
  2.273883237911146e-16, -6.994644464052276e-18,  1.864088331452407e-19, -4.412865793750496e-21,  9.447626313263674e-23, -1.854049418911612e-24,  3.370186121561597e-26,
 -5.720440258373167e-28,  2.755737128560265e-12, -3.758684364713885e-13,  2.723840473609387e-14, -1.382884892015524e-15,  5.500471731314659e-17, -1.820398079651928e-18,
  5.203839478892877e-20, -1.317894765363342e-21,  3.011323116594017e-23, -6.293686691180431e-25,  1.216035124453855e-26, -2.190018899506340e-28,  4.530399577661678e-13,
 -6.750690228141280e-14,  5.319187623219544e-15, -2.923285400753151e-16,  1.253861015669489e-17, -4.460147612464012e-19,  1.366432665901285e-20, -3.699279110596629e-22,
  9.015119950977988e-24, -2.005383893348298e-25,  4.116197791574848e-27, -7.861183681141535e-29,  7.100112784346651e-14, -1.152765142541976e-14,  9.857690829889108e-16,
 -5.855842086046049e-17,  2.705299159260491e-18, -1.033268337018459e-19,  3.389666502953752e-21, -9.802233721597385e-23,  2.545996507914718e-24, -6.024047786851224e-26,
  1.312778106271638e-27, -2.657258782538226e-29,  1.065973161920499e-14, -1.880911051106503e-15,  1.742358442414756e-16, -1.117139217678104e-17,  5.552127798564051e-19,
 -2.274636040230263e-20,  7.983155175592175e-22, -2.463990157171928e-23,  6.816167455588619e-25, -1.714317982206379e-26,  3.964009229827506e-28, -8.499208886076741e-30,
  1.541894354440384e-15, -2.949314580000192e-16,  2.954086237645512e-17, -2.041299331790639e-18,  1.090056706419726e-19, -4.785151807683702e-21,  1.795034057349485e-22,
 -5.908421785862144e-24,  1.739451563037215e-25, -4.647087571994941e-27,  1.139414624537803e-28, -2.586179895548407e-30,  2.163058901557495e-16, -4.473796416449645e-17,
  4.836114176817254e-18, -3.596095905154031e-19,  2.060642765268975e-20, -9.681784035665105e-22,  3.878049933701895e-23, -1.360051838435918e-24,  4.257725863299578e-26,
 -1.207345286869473e-27,  3.136741859239710e-29, -7.531687627518137e-31,  2.965667213722228e-17, -6.615309491971770e-18,  7.702778356356467e-19, -6.153711647122766e-20,
  3.778668302666782e-21, -1.897883771142525e-22,  8.108390215387761e-24, -3.026828918249116e-25,  1.006682520941763e-26, -3.027325631989556e-28,  8.327251717623922e-30,
 -2.113566902210010e-31,  4.009263718983717e-18, -9.619546632703615e-19,  1.204050414672853e-19, -1.031679342976377e-20,  6.778376555643529e-22, -3.634569800199409e-23,
  1.654232580097826e-24, -6.565599201086176e-26,  2.317439298076474e-27, -7.383493039218101e-29,  2.148305002262113e-30, -5.758685388658622e-32,  5.398967481982660e-19,
 -1.389475599429004e-19,  1.865474419901296e-20, -1.711155661172243e-21,  1.200965425350279e-22, -6.864402599741850e-24,  3.323732267341286e-25, -1.400785787761570e-26,
  5.240981088939694e-28, -1.767089616093396e-29,  5.432665783279787e-31, -1.536383013505076e-32,  7.326458428699124e-20, -2.016506653968742e-20,  2.897088721657835e-21,
 -2.839013243363338e-22,  2.124525738623643e-23, -1.292228654506951e-24,  6.645922097324396e-26, -2.969780627821414e-27,  1.176150201446935e-28, -4.191034470640136e-30,
  1.359692210061172e-31, -4.051813745123975e-33,  1.015086677723345e-20, -2.978501136338717e-21,  4.567281816214333e-22, -4.770547363752683e-23,  3.798409922058716e-24,
 -2.453780253050083e-25,  1.337976123094655e-26, -6.328323898516652e-28,  2.648554537305206e-29, -9.958524113359098e-31,  3.404245577612183e-32, -1.067368174252858e-33,
  1.457120962580014e-21, -4.542486228597982e-22,  7.413130867332280e-23, -8.231654569585962e-24,  6.956872855054058e-25, -4.762380262720363e-26,  2.747304247786033e-27,
 -1.372575707871287e-28,  6.058910385444680e-30, -2.399370526881395e-31,  8.626755590756057e-33, -2.840967041010988e-34,  2.202294043265471e-22, -7.267161465201727e-23,
  1.258123813090031e-23, -1.480813932014353e-24,  1.324704889956678e-25, -9.584488673972587e-27,  5.834984142270245e-28, -3.072012698595380e-29,  1.427000590366795e-30,
 -5.938599226979826e-32,  2.240939544147208e-33, -7.735209457218040e-35,  3.566229809605975e-23, -1.240616843589036e-23,  2.270274093294600e-24, -2.822830352218169e-25,
  2.664479057343667e-26, -2.031347750186631e-27,  1.301310997545281e-28, -7.199541922834835e-30,  3.509769608821425e-31, -1.530959282345662e-32,  6.047952607433434e-34,
 -2.182761573248255e-35,  6.301664442830932e-24, -2.301005607116512e-24,  4.432808919211054e-25, -5.800288778779683e-26,  5.755688545442578e-27, -4.607526797916976e-28,
  3.095455183964691e-29, -1.793798246617900e-30,  9.148522086114075e-32, -4.169981079937704e-33,  1.719446818090474e-34, -6.469767110216540e-36,  1.237802370331337e-24,
 -4.721541751956988e-25,  9.532202180617525e-26, -1.306888453485990e-26,  1.357655988188211e-27, -1.136599714324647e-28,  7.976855253948165e-30, -4.823561354024298e-31,
  2.564248819224586e-32, -1.217022996170599e-33,  5.219914722803784e-35, -2.040823152763348e-36,  2.750356593367167e-25, -1.090352549172162e-25,  2.295237942120957e-26,
 -3.281091357540260e-27,  3.551502424771118e-28, -3.095146239010066e-29,  2.259112934143926e-30, -1.419329837808609e-31,  7.831890406517581e-33, -3.854667942994832e-34,
  1.712912776911180e-35, -6.931688545049723e-37,  7.013028384820476e-26, -2.873743734949903e-26,  6.272414485728316e-27, -9.298099835558647e-28,  1.043078745499905e-28,
 -9.414311028321523e-30,  7.110367981985426e-31, -4.618718014769692e-32,  2.632861933912883e-33, -1.337573673066030e-34,  6.130411073134928e-36, -2.556511388625876e-37,
  2.067197926663019e-26, -8.704885720861893e-27,  1.958066814790231e-27, -2.991825852899873e-28,  3.458006537286946e-29, -3.213668775575060e-30,  2.497570833852433e-31,
 -1.668250989488709e-32,  9.772002209727163e-34, -5.097935742584747e-35,  2.397724550286755e-36, -1.025369553667655e-37,  6.984271101316734e-27, -3.003913790140878e-27,
  6.917941388326935e-28, -1.082406779777819e-28,  1.280716124762670e-29, -1.217871352197398e-30,  9.679820050450396e-32, -6.608881705750683e-33,  3.954890252782133e-34,
 -2.106683941723396e-35,  1.011189770792154e-36, -4.410600081521307e-38,  2.569518354925394e-27, -1.121622662969718e-27,  2.626246180822330e-28, -4.178472598918121e-29,
  5.026451150045350e-30, -4.857961730721038e-31,  3.922906767634716e-32, -2.720158467188229e-33,  1.652580408704581e-34, -8.933618615995369e-36,  4.350120170966575e-37,
 -1.924126232094884e-38,  8.105293739866840e-28, -3.567485219769943e-28,  8.431339840761536e-29, -1.354154612560229e-29,  1.644201449296394e-30, -1.603667846040207e-31,
  1.306616123053219e-32, -9.139510112487951e-34,  5.600002021779957e-35, -3.052521693168826e-36,  1.498472328165862e-37, -6.680352002213914e-39,  5.019285188277154e-02,
 -1.032827947695820e-04,  2.185594655818884e-07, -4.740184003393589e-10,  1.048680351325390e-12, -2.356635623784495e-15,  5.352305198090343e-18, -1.225823653096700e-20,
  2.816488240593208e-23, -6.504126276448178e-26,  1.497104065300250e-28, -3.471076720756865e-31,  4.653050205781874e-02, -1.112249678283931e-04,  3.133817451287905e-07,
 -9.387613938831266e-10,  2.834690250022951e-12, -8.470616099218137e-15,  2.493552991331595e-17, -7.235050094846793e-20,  2.071553000450517e-22, -5.864491692023684e-25,
  1.642796472089557e-27, -4.562116523723357e-30,  3.998833692997891e-02, -1.222376205844258e-04,  4.731910592153727e-07, -1.828683070622374e-09,  6.794721084499684e-12,
 -2.436647421390175e-14,  8.491904937749878e-17, -2.891064374710188e-19,  9.649295424147900e-22, -3.165654868821780e-24,  1.022842933694975e-26, -3.260153867804025e-29,
  3.185933383056070e-02, -1.293316791724717e-04,  6.476727520103426e-07, -3.023566249287636e-09,  1.324454489675941e-11, -5.537083928906537e-14,  2.231758704967228e-16,
 -8.727365678622325e-19,  3.326000938096226e-21, -1.239422251567383e-23,  4.528144885983617e-26, -1.625314470453551e-28,  2.353208738542045e-02, -1.271152280167627e-04,
  7.826135230420271e-07, -4.293068987974067e-09,  2.180643554777824e-11, -1.047545021495485e-13,  4.813956928543552e-16, -2.132308683118471e-18,  9.153834709650704e-21,
 -3.824441110280507e-23,  1.560130670092737e-25, -6.230225942835617e-28,  1.611472035855629e-02, -1.142298250485753e-04,  8.383637196750452e-07, -5.333108395049322e-09,
  3.107569725316037e-11, -1.696867612680042e-13,  8.797512821912564e-16, -4.369698351481308e-18,  2.092928605431757e-20, -9.714054666397502e-23,  4.385801247359181e-25,
 -1.932022274431948e-27,  1.023171379185988e-02, -9.337147599364418e-05,  8.025256096755430e-07, -5.869538440770431e-09,  3.889624334633877e-11, -2.393784225422762e-13,
  1.388991190058698e-15, -7.677980564852409e-18,  4.073509528663476e-20, -2.085905866465724e-22,  1.035402522731337e-24, -4.999204568348002e-27,  6.023792847013544e-03,
 -6.939688594470674e-05,  6.910495881529157e-07, -5.770918340214726e-09,  4.318164389347959e-11, -2.975080245781154e-13,  1.919914144365704e-15, -1.174089603141252e-17,
  6.860863117860809e-20, -3.854990595561992e-22,  2.092815399237928e-24, -1.101932165114292e-26,  3.288745470601232e-03, -4.696775362002719e-05,  5.379640517867293e-07,
 -5.098761123761083e-09,  4.282393963042657e-11, -3.284981659122754e-13,  2.345676932673291e-15, -1.579295840237421e-17,  1.011811227179847e-19, -6.210815447491102e-22,
  3.672037460841882e-24, -2.099826913623960e-26,  1.665266080220814e-03, -2.900595176480928e-05,  3.800431985683281e-07, -4.066404723448243e-09,  3.814507879479266e-11,
 -3.243093813927666e-13,  2.551563182520508e-15, -1.883816493104024e-17,  1.318188703689077e-19, -8.807359651739739e-22,  5.651055129232112e-24, -3.497718258884962e-26,
  7.821667121336102e-04, -1.638029610738848e-05,  2.443647727043275e-07, -2.937928199218135e-09,  3.065066734272275e-11, -2.877171911705740e-13,  2.485240053055009e-15,
 -2.005258747119943e-17,  1.527626891332689e-19, -1.107565449246776e-21,  7.689439624262502e-24, -5.136758305907750e-26,  3.408507894289483e-04, -8.475576971507198e-06,
  1.433609819478174e-07, -1.928642996738374e-09,  2.229663938656605e-11, -2.303214452376659e-13,  2.177504917645265e-15, -1.914593637596855e-17,  1.583581660323865e-19,
 -1.242619423313390e-21,  9.311314774879466e-24, -6.697131085016197e-26,  1.378437366656724e-04, -4.025514521529915e-06,  7.689894521005301e-08, -1.153329047882731e-09,
  1.472808746804716e-11, -1.669400612951648e-13,  1.722867340318350e-15, -1.646647700339437e-17,  1.475212114710292e-19, -1.250021162282977e-21,  1.008780627218330e-23,
 -7.795610630842761e-26,  5.174899587041727e-05, -1.757927693245938e-06,  3.778486855272722e-08, -6.296865955773840e-10,  8.857253203551881e-12, -1.098837641466191e-13,
  1.235037875905654e-15, -1.280311237161276e-17,  1.239841521402818e-19, -1.132252663498353e-21,  9.822305013967330e-24, -8.140595873028142e-26,  1.804157644455026e-05,
 -7.069304524586293e-07,  1.703610343912880e-08, -3.145229132428603e-10,  4.860873254047147e-12, -6.585585386240793e-14,  8.044613445454120e-16, -9.028115624362228e-18,
  9.433279211906305e-20, -9.268528495159011e-22,  8.628991517543959e-24, -7.657855729873670e-26,  5.843962484541773e-06, -2.621684017639820e-07,  7.059685850099978e-09,
 -1.439997831305923e-10,  2.439636598034280e-12, -3.602301516787654e-14,  4.773792466045628e-16, -5.790005038890649e-18,  6.517349874137147e-20, -6.879189313392406e-22,
  6.863443791377472e-24, -6.513193033953472e-26,  1.759737166744839e-06, -8.978947627101305e-08,  2.693102971140388e-09, -6.053990084828867e-11,  1.122047429083811e-12,
 -1.802427543956277e-14,  2.587063950906399e-16, -3.386060201980205e-18,  4.100191384549699e-20, -4.643149071721130e-22,  4.958201575221128e-24, -5.025205964240343e-26,
  4.929415750710856e-07, -2.843970777357203e-08,  9.472454893765248e-10, -2.341347860511156e-11,  4.738317526917970e-13, -8.267112624878806e-15,  1.283318015235525e-16,
 -1.810140626158202e-18,  2.355036868587919e-20, -2.857843739538896e-22,  3.262661390893239e-24, -3.527889376007542e-26,  1.285620217682566e-07, -8.342771106922152e-09,
  3.076950412667784e-10, -8.344764258408067e-12,  1.840815246524387e-13, -3.483198597832204e-15,  5.840050680994637e-17, -8.866727479557639e-19,  1.238059197897428e-20,
 -1.608277670126736e-22,  1.961042035815614e-24, -2.260124002046403e-26,  3.124898546681911e-08, -2.270115477391113e-09,  9.246280120709557e-11, -2.745935417975700e-12,
  6.592212964286224e-14, -1.350976121855057e-15,  2.443564019000674e-17, -3.989042905662611e-19,  5.971811220307356e-21, -8.296593302863506e-23,  1.079532866186723e-24,
 -1.325009688798691e-26,  7.087433244883766e-09, -5.739312185073951e-10,  2.575099872764323e-11, -8.358780234847523e-13,  2.180647164177691e-14, -4.834008274613088e-16,
  9.422065240190406e-18, -1.652200633590722e-19,  2.649530358324411e-21, -3.933450940524197e-23,  5.457309760974032e-25, -7.128115974585630e-27,  1.502100165656922e-09,
 -1.350650348467161e-10,  6.659846700277470e-12, -2.358762132786258e-13,  6.677719138839137e-15, -1.599384958282365e-16,  3.355968606217732e-18, -6.315634919950856e-20,
  1.084020936403269e-21, -1.718407240544402e-23,  2.540346979356439e-25, -3.528670597556361e-27,  2.979985856877694e-10, -2.964770001977554e-11,  1.602993936844602e-12,
 -6.184604807279877e-14,  1.897554541538596e-15, -4.905160390091836e-17,  1.106980603690147e-18, -2.233899010620568e-20,  4.100859363626882e-22, -6.936637853211540e-24,
  1.091943891799575e-25, -1.612046504038565e-27,  5.545316870779561e-11, -6.084415493525656e-12,  3.599701220628815e-13, -1.510544080991607e-14,  5.016741977373447e-16,
 -1.398214854630314e-17,  3.390819581298788e-19, -7.331956425118316e-21,  1.438542426384324e-22, -2.594828875032713e-24,  4.347005356487338e-26, -6.816897033396167e-28,
  9.702746153470027e-12, -1.170548085012696e-12,  7.562731880266233e-14, -3.446600184101421e-15,  1.237593640999233e-16, -3.715390836935180e-18,  9.674348190592369e-20,
 -2.239831531665421e-21,  4.693850922779549e-23, -9.023434324682357e-25,  1.607856547061184e-26, -2.676953752560753e-28,  1.600940230988505e-12, -2.117596985087235e-13,
  1.491249624082183e-14, -7.370408610169427e-16,  2.858177427423056e-17, -9.233936395981161e-19,  2.579570174689253e-20, -6.390277766801580e-22,  1.429478095030335e-23,
 -2.927075154261582e-25,  5.544718321747327e-27, -9.796247277212730e-29,  2.499504248030806e-13, -3.615221580952177e-14,  2.769923160425714e-15, -1.482655543482810e-16,
  6.202579610368989e-18, -2.154505760148041e-19,  6.452323464496497e-21, -1.709128552867919e-22,  4.078643638983463e-24, -8.890981219964966e-26,  1.789567101561891e-27,
 -3.353594980681275e-29,  3.707538861630849e-14, -5.848840737273023e-15,  4.866983682079461e-16, -2.817584976195766e-17,  1.270201691733765e-18, -4.739518848367048e-20,
  1.520464726660039e-21, -4.303569401280143e-23,  1.094945265309347e-24, -2.539612131784934e-26,  5.428758576872932e-28, -1.078551049738276e-29,  5.249740826901095e-15,
 -9.010513082490843e-16,  8.129085194339045e-17, -5.082987099249246e-18,  2.466631803989271e-19, -9.877682481695072e-21,  3.391793264720217e-22, -1.025122439338608e-23,
  2.779030944824207e-25, -6.854330682510533e-27,  1.555275744778734e-28, -3.274254786014832e-30,  7.135750920391661e-16, -1.329293986256908e-16,  1.297961745169939e-17,
 -8.754019748578895e-19,  4.567685137033581e-20, -1.961209969527279e-21,  7.202332494006633e-23, -2.322720562386340e-24,  6.704764416174510e-26, -1.757482539952337e-27,
  4.230587236785967e-29, -9.432824800704724e-31,  9.372122115088515e-17, -1.890303515643812e-17,  1.994145276885410e-18, -1.448638139492623e-19,  8.117873324079305e-21,
 -3.733446694406760e-22,  1.465041265915635e-23, -5.037415978979658e-25,  1.547217699883290e-26, -4.307322796273675e-28,  1.099300255434594e-29, -2.594411173966251e-31,
  1.198553230437149e-17, -2.610888482739161e-18,  2.970354164103564e-19, -2.320737067507753e-20,  1.394943144330613e-21, -6.864180096659217e-23,  2.875390568877411e-24,
 -1.053190498552298e-25,  3.439198309807556e-27, -1.016099722293258e-28,  2.747508349596531e-30, -6.858848169554549e-32,  1.505791428753707e-18, -3.533640356374340e-19,
  4.327183611979737e-20, -3.630340039598777e-21,  2.337383280237368e-22, -1.229133507231645e-23,  5.490351595681664e-25, -2.140068366326030e-26,  7.423043529495213e-28,
 -2.325451711311939e-29,  6.656525090296808e-31, -1.756336724320823e-32,  1.877739381228221e-19, -4.734270451786567e-20,  6.227405255510974e-21, -5.600386880722393e-22,
  3.856459567198812e-23, -2.164204682701506e-24,  1.029550679046185e-25, -4.265686896767429e-27,  1.569916778842573e-28, -5.209595900400940e-30,  1.577101059346624e-31,
 -4.394010565572110e-33,  2.351874438837950e-20, -6.352580911910940e-21,  8.955755605958704e-22, -8.616708995605483e-23,  6.335032252540409e-24, -3.788033900138374e-25,
  1.916366566412000e-26, -8.428344576787418e-28,  3.287046687626479e-29, -1.154000437743499e-30,  3.690375427006662e-32, -1.084487283476607e-33,  2.998950678246361e-21,
 -8.651385274106981e-22,  1.303942354249268e-22, -1.339297709793985e-23,  1.049203344232871e-24, -6.672439954740092e-26,  3.583617577210182e-27, -1.670349883614497e-28,
  6.892583204316784e-30, -2.556345413373180e-31,  8.623489288150067e-33, -2.669305076453895e-34,  3.952964530524679e-22, -1.213849348805180e-22,  1.950526658081260e-23,
 -2.133378563358965e-24,  1.776760476473277e-25, -1.199176238461244e-26,  6.823617023414404e-28, -3.364256684256315e-29,  1.466150524916942e-30, -5.734416654869018e-32,
  2.037111748447102e-33, -6.630956579271975e-35,  5.478290810044983e-23, -1.784109592519643e-23,  3.046920633960397e-24, -3.538598854975742e-25,  3.124721914622124e-26,
 -2.232550439585102e-27,  1.342730019310317e-28, -6.986491827497626e-30,  3.208562193407822e-31, -1.320613940878913e-32,  4.930324571429952e-34, -1.684301563460886e-35,
  8.131822640460181e-24, -2.797396285706401e-24,  5.059433846857150e-25, -6.218614621890916e-26,  5.804195263580214e-27, -4.377067928781721e-28,  2.774586124335334e-29,
 -1.519444853398512e-30,  7.334340726870703e-32, -3.168706719546701e-33,  1.240196124388816e-34, -4.435896661430950e-36,  1.318635869464496e-24, -4.770536629744789e-25,
  9.100623402117733e-26, -1.179326626130011e-26,  1.159257566392063e-27, -9.195355349256252e-29,  6.123010654767799e-30, -3.517819930486525e-31,  1.779206433080027e-32,
 -8.044450190756927e-34,  3.291128953700482e-35, -1.228989430262694e-36,  2.383664957889212e-25, -9.025515437543761e-26,  1.807793512181602e-26, -2.459175143799825e-27,
  2.535218659051057e-28, -2.106692876329585e-29,  1.467876964251104e-30, -8.814249740447843e-32,  4.654040611183165e-33, -2.194375734149783e-34,  9.351994455682473e-36,
 -3.633824867039732e-37,  4.897985145662899e-26, -1.930876802114489e-26,  4.039928605988793e-27, -5.740306887091962e-28,  6.176698271789794e-29, -5.352074827663746e-30,
  3.884617246375618e-31, -2.427366632285433e-32,  1.332390014433371e-33, -6.524291172165166e-35,  2.884893266826632e-36, -1.161852184563491e-37,  1.163200516177967e-26,
 -4.747322228818944e-27,  1.031630525936924e-27, -1.522562675629068e-28,  1.700699178760898e-29, -1.528539455301960e-30,  1.149765384888310e-31, -7.439081595197596e-33,
  4.224327303242873e-34, -2.138101664926214e-35,  9.764037414560266e-37, -4.057580090887016e-38,  3.223761289664188e-27, -1.353919300781294e-27,  3.036598196884126e-28,
 -4.626197491707524e-29,  5.331688876495111e-30, -4.941081153856015e-31,  3.829603088645972e-32, -2.551209300992271e-33,  1.490562922593102e-34, -7.756677579910792e-36,
  3.639376163203807e-37, -1.552700755540215e-38,  1.036213186968670e-27, -4.449844562593489e-28,  1.023030148468553e-28, -1.597911443046587e-29,  1.887460567475559e-30,
 -1.791869066404116e-31,  1.421905303804481e-32, -9.692794543981529e-34,  5.791513844269924e-35, -3.080436899344757e-36,  1.476450977275637e-37, -6.430974990743196e-39,
  3.677375152383182e-28, -1.604012480405449e-28,  3.752597252753329e-29, -5.965494937643086e-30,  7.170139978695918e-31, -6.924124944256608e-32,  5.586910742689662e-33,
 -3.870967053261716e-34,  2.349946559988644e-35, -1.269408444352949e-36,  6.176779620781268e-38, -2.730173502136958e-39,  1.136362375608524e-28, -5.000134747258607e-29,
  1.181328341816058e-29, -1.896681421117456e-30,  2.302152888127628e-31, -2.244649496481126e-32,  1.828266526025775e-33, -1.278422381210334e-34,  7.830729282210140e-36,
 -4.267150788107526e-37,  2.094092009338947e-38, -9.332910887169617e-40,  4.978318202777107e-02, -1.015567902244011e-04,  2.129703850056587e-07, -4.576097119054047e-10,
  1.002804907729289e-12, -2.232199345228743e-15,  5.021348509502764e-18, -1.139329751293907e-20,  2.592760736448657e-23, -5.934741924040125e-26,  1.352431434866321e-28,
 -3.112124953260995e-31,  4.609054602036925e-02, -1.087622160459695e-04,  3.023832515371727e-07, -8.947298080731525e-10,  2.671102154439640e-12, -7.895743139802117e-15,
  2.299943579476075e-17, -6.604702595264227e-20,  1.871791360874650e-22, -5.245807676535302e-25,  1.454715274879306e-27, -4.000140191447172e-30,  3.950682108590766e-02,
 -1.185380570649783e-04,  4.518834250450903e-07, -1.723758125544436e-09,  6.327134074486540e-12, -2.242217015372877e-14,  7.723977217704479e-17, -2.599758672600069e-19,
  8.579975061732558e-22, -2.783814480329206e-24,  8.896712696103261e-27, -2.805181325709817e-29,  3.135214506414257e-02, -1.242919081334607e-04,  6.126258090779004e-07,
 -2.820229941126338e-09,  1.218877140457464e-11, -5.029623118554005e-14,  2.001646310792442e-16, -7.731075547056619e-19,  2.910759288892984e-21, -1.071823855683350e-23,
  3.870131671310406e-26, -1.373138458155719e-28,  2.303583018523960e-02, -1.210546110402573e-04,  7.331229543761411e-07, -3.960318719516482e-09,  1.982221021606920e-11,
 -9.388559136408488e-14,  4.255932751630472e-16, -1.860261957981733e-18,  7.883060313399447e-21, -3.251934157023744e-23,  1.310135116548208e-25, -5.168049915326081e-28,
  1.567082116379754e-02, -1.077707025762484e-04,  7.772412982028626e-07, -4.861940203307525e-09,  2.788356970215660e-11, -1.499683830656782e-13,  7.662735337169130e-16,
 -3.752687812391334e-18,  1.772854136374158e-20, -8.118615602213069e-23,  3.617514776565166e-25, -1.573098372004512e-27,  9.870636683555001e-03, -8.722278162330486e-05,
  7.356728715588467e-07, -5.283758380772462e-09,  3.442535194233791e-11, -2.084818004215385e-13,  1.191182755631693e-15, -6.487023528176831e-18,  3.392119851699305e-20,
 -1.712603319103229e-22,  8.384271280990049e-25, -3.993640109124521e-27,  5.756839512230122e-03, -6.413418439670696e-05,  6.257554652984148e-07, -5.125217222466306e-09,
  3.766686421749012e-11, -2.551392056080252e-13,  1.619929322639722e-15, -9.752213465890956e-18,  5.612753484613238e-20, -3.107356500158059e-22,  1.662725168079919e-24,
 -8.631752993850194e-27,  3.109110185340515e-03, -4.289761379332552e-05,  4.806827203373298e-07, -4.463223054998052e-09,  3.678292710188661e-11, -2.771621717524865e-13,
  1.945634053180490e-15, -1.288627058316794e-17,  8.125755714096860e-20, -4.911425540124600e-22,  2.860409775467957e-24, -1.611810929360259e-26,  1.555027941558591e-03,
 -2.615089033176835e-05,  3.347045328989602e-07, -3.504816849536097e-09,  3.223088593204657e-11, -2.689526398542314e-13,  2.078677306588137e-15, -1.508648079386151e-17,
  1.038356135340878e-19, -6.827254252899066e-22,  4.312654860431196e-24, -2.628911457761907e-26,  7.203433002082651e-04, -1.455847868195613e-05,  2.118722040131423e-07,
 -2.490492933616317e-09,  2.545000774452305e-11, -2.342915336261965e-13,  1.986610077777036e-15, -1.574693233547565e-17,  1.179219819786312e-19, -8.408686187155317e-22,
  5.744244447710093e-24, -3.777299085729368e-26,  3.091038029143918e-04, -7.415531799466977e-06,  1.222144546646415e-07, -1.606081203753011e-09,  1.817218159272683e-11,
 -1.839606390045460e-13,  1.706119043901103e-15, -1.472773430368116e-17,  1.196735559485967e-19, -9.230808984229159e-22,  6.802506556576250e-24, -4.813826446283135e-26,
  1.228897472147975e-04, -3.461916608180941e-06,  6.436958365122009e-08, -9.422911093426040e-10,  1.176801849260150e-11, -1.306294986115805e-13,  1.321649023652984e-15,
 -1.239418186522043e-17,  1.090262151795009e-19, -9.076401597742091e-22,  7.200104421191377e-24, -5.471890619670184e-26,  4.527718027079608e-05, -1.483621662586187e-06,
  3.101130460991524e-08, -5.040557339444031e-10,  6.929116086073318e-12, -8.413149030035829e-14,  9.264704550879463e-16, -9.418463116135012e-18,  8.950883672052573e-20,
 -8.026992576552757e-22,  6.841810996019128e-24, -5.574076650172793e-26,  1.546427124160492e-05, -5.845102558413505e-07,  1.368818461086178e-08, -2.463170436348762e-10,
  3.717991369829387e-12, -4.926972382013749e-14,  5.893583770478132e-16, -6.482796065796761e-18,  6.644388306447013e-20, -6.407924946555900e-22,  5.859100119875073e-24,
 -5.109330010083672e-26,  4.898169278187536e-06, -2.119902914276199e-07,  5.543993818949979e-09, -1.101579338688637e-10,  1.821742918270522e-12, -2.629680625662403e-14,
  3.410814088681564e-16, -4.052851223563953e-18,  4.472892008181539e-20, -4.632217745415304e-22,  4.537207116486237e-24, -4.229283982400084e-26,  1.439465200214206e-06,
 -7.087072583351132e-08,  2.063455405126380e-09, -4.516342595009800e-11,  8.166772333078197e-13, -1.281895170759633e-14,  1.800024248880754e-16, -2.307113030965971e-18,
  2.738043714961949e-20, -3.041022772182173e-22,  3.186926057659666e-24, -3.171633909879729e-26,  3.927259037133503e-07, -2.186826710851675e-08,  7.068137274540320e-10,
 -1.700337782207362e-11,  3.355865556596874e-13, -5.718874199764956e-15,  8.681515491361572e-17, -1.198707273474588e-18,  1.527938741800531e-20, -1.817906418921492e-22,
  2.036142519045624e-24, -2.161240142236911e-26,  9.954413867742576e-08, -6.236527838523153e-09,  2.231562044906888e-10, -5.888316627681274e-12,  1.266331938373503e-13,
 -2.339593337216442e-15,  3.834739436305870e-17, -5.697453932237334e-19,  7.791693664437817e-21, -9.920854726260063e-23,  1.186473487374889e-24, -1.341968928424413e-26,
  2.346208355914854e-08, -1.646151003856815e-09,  6.504215984947401e-11, -1.878915142038868e-12,  4.396333670351565e-14, -8.794463539766852e-16,  1.554608146822659e-17,
 -2.482826076421762e-19,  3.639518074150937e-21, -4.954822798648320e-23,  6.321878170387832e-25, -7.613308503988750e-27,  5.147694371351191e-09, -4.027761219520260e-10,
  1.753072141688585e-11, -5.534481532295494e-13,  1.406949711832732e-14, -3.043762192225613e-16,  5.796833456941909e-18, -9.942488185799641e-20,  1.560888231620374e-21,
 -2.270291906200039e-23,  3.088073997350460e-25, -3.956875123139447e-27,  1.052747197328138e-09, -9.150937670512637e-11,  4.377521634246140e-12, -1.507840968691459e-13,
  4.159208712059508e-15, -9.720431410751464e-17,  1.992630216814169e-18, -3.667307825284824e-20,  6.161321190380495e-22, -9.567646920517281e-24,  1.386482441562911e-25,
 -1.889061904822926e-27,  2.009963947138415e-10, -1.934236100326857e-11,  1.014785664886596e-12, -3.807860214473358e-14,  1.138317150574794e-15, -2.871081625751518e-17,
  6.329571990489530e-19, -1.249055928468443e-20,  2.244196803005817e-22, -3.718269220284487e-24,  5.737190876759148e-26, -8.307265926380546e-28,  3.589487512872145e-11,
 -3.811952495271909e-12,  2.188992346037810e-13, -8.935074337122031e-15,  2.891435270861642e-16, -7.863168126426768e-18,  1.862810883774953e-19, -3.938773273665831e-21,
  7.563486199628284e-23, -1.336299253624552e-24,  2.194233665285863e-26, -3.374841016475727e-28,  6.009643959357402e-12, -7.022262546203699e-13,  4.405383169038246e-14,
 -1.953373907923763e-15,  6.835435866494470e-17, -2.002490085147979e-18,  5.094026594419900e-20, -1.153340428719166e-21,  2.365652764162956e-23, -4.454595876020098e-25,
  7.780360641439438e-27, -1.270533275901165e-28,  9.458536938545287e-13, -1.212752819067870e-13,  8.296749104859708e-15, -3.991026122036754e-16,  1.508634628325505e-17,
 -4.757124012113761e-19,  1.298520239636032e-20, -3.146185684022093e-22,  6.889315458504723e-24, -1.381967229175114e-25,  2.566301427304808e-27, -4.447626482323221e-29,
  1.404023314658434e-13, -1.970241480785313e-14,  1.467360502922980e-15, -7.647783027293942e-17,  3.119759673481808e-18, -1.057999676358703e-19,  3.096758034587560e-21,
 -8.024667631503421e-23,  1.874960086420265e-24, -4.004753437706178e-26,  7.903495332104360e-28, -1.453118592808974e-29,  1.973266380170678e-14, -3.023137301473673e-15,
  2.447002318573488e-16, -1.380114495251351e-17,  6.069618456758567e-19, -2.211984895636104e-20,  6.937912841516394e-22, -1.921677027910226e-23,  4.788463090414403e-25,
 -1.088534168372384e-26,  2.282108295940747e-28, -4.449469912343767e-30,  2.637911802903898e-15, -4.401761168218954e-16,  3.865934629582886e-17, -2.356575763603529e-18,
  1.116251808429453e-19, -4.368058408807277e-21,  1.467111513582608e-22, -4.340994105183735e-24,  1.152996974135418e-25, -2.788247038187722e-27,  6.207095391975801e-29,
 -1.282845694448688e-30,  3.372636517406309e-16, -6.115286307026454e-17,  5.818251562436381e-18, -3.828461439513238e-19,  1.951206645808779e-20, -8.191658211913452e-22,
  2.944179160423200e-23, -9.300232999542734e-25,  2.631568699313202e-26, -6.766378657013376e-28,  1.598730317991545e-29, -3.500947406546157e-31,  4.150636766055639e-17,
 -8.158917917102368e-18,  8.395432670978137e-19, -5.955547232850598e-20,  3.262433712528980e-21, -1.468136450336430e-22,  5.642122197866157e-24, -1.901431166081083e-25,
  5.728200175304710e-27, -1.565150114259509e-28,  3.922944331998441e-30, -9.097755359114293e-32,  4.954430307889990e-18, -1.053309151366949e-18,  1.170212463128779e-19,
 -8.937209651032979e-21,  5.256203100855145e-22, -2.532978460218803e-23,  1.039970673628259e-24, -3.736256113045348e-26,  1.197539624815777e-27, -3.474932114199976e-29,
  9.233799440994141e-31, -2.266560491819595e-32,  5.787272373333401e-19, -1.327452111620757e-19,  1.589458422420573e-20, -1.305001918861611e-21,  8.229849804345870e-23,
 -4.242425503252978e-24,  1.859074005165119e-25, -7.113907181492929e-27,  2.423964636261005e-28, -7.464051407445664e-30,  2.101256802521873e-31, -5.455520874932782e-33,
  6.684496908335493e-20, -1.649981895768888e-20,  2.125173507148912e-21, -1.872764875535210e-22,  1.264644649060913e-23, -6.964895366587601e-25,  3.253880652411351e-26,
 -1.324831076586215e-27,  4.794311537136426e-29, -1.565216717025182e-30,  4.664204863173897e-32, -1.279815024759964e-33,  7.727046813480860e-21, -2.046890815554544e-21,
  2.829936720588644e-22, -2.671833524107756e-23,  1.928882954883533e-24, -1.133309916228340e-25,  5.637212163131454e-27, -2.439131631286608e-28,  9.363664246514728e-30,
 -3.237558685221620e-31,  1.020151948948111e-32, -2.955343118964867e-34,  9.064301527115778e-22, -2.569160000601775e-22,  3.803783647880300e-23, -3.839720644186357e-24,
  2.958032174378923e-25, -1.850989542874887e-26,  9.787271430185181e-28, -4.493652506132781e-29,  1.827444199751899e-30, -6.682778143582642e-32,  2.223768165327471e-33,
 -6.793048185969812e-35,  1.096219917973719e-22, -3.313690385478745e-23,  5.239882893360609e-24, -5.641918481846248e-25,  4.628006919080093e-26, -3.078056416379649e-27,
  1.726840847944048e-28, -8.398015107209012e-30,  3.611695003619635e-31, -1.394605749495567e-32,  4.893072465301333e-34, -1.573698694356188e-35,  1.391314398705221e-23,
 -4.469230957134455e-24,  7.525010108081018e-25, -8.618597188397517e-26,  7.508552213589934e-27, -5.295114667741993e-28,  3.144695813010951e-29, -1.616383959072428e-30,
  7.336056479381838e-32, -2.985093836833465e-33,  1.102154746604824e-34, -3.725010020793710e-36,  1.889939456455487e-24, -6.425656159270547e-25,  1.148002290883064e-25,
 -1.394118760246096e-26,  1.286054198166693e-27, -9.588922673597907e-29,  6.011900726791156e-30, -3.257457703424884e-31,  1.556260567185150e-32, -6.656889560987249e-34,
  2.580370421167154e-35, -9.143477159999299e-37,  2.806478192862873e-25, -1.005488065760759e-25,  1.898524113960979e-26, -2.435407774970365e-27,  2.370414987260607e-28,
 -1.862292554786391e-29,  1.228595807260265e-30, -6.995346855054652e-32,  3.507327884377916e-33, -1.572456709113258e-34,  6.380761933162117e-36, -2.363939848054231e-37,
  4.657266049844565e-26, -1.749753647385954e-26,  3.475699513249776e-27, -4.689263124222716e-28,  4.795549154486047e-29, -3.953957104041393e-30,  2.734204404984302e-31,
 -1.629816944846987e-32,  8.544655004523896e-34, -4.001119540099838e-35,  1.693840814672605e-36, -6.539197613661699e-38,  8.825659267819410e-27, -3.458621668660675e-27,
  7.190092270717910e-28, -1.015135422996772e-28,  1.085512908948353e-29, -9.348996979117195e-31,  6.745793618895322e-32, -4.191211911619873e-33,  2.287866951393762e-34,
 -1.114297811109154e-35,  4.901591021254147e-37, -1.964133703807547e-38,  1.946556049345953e-27, -7.910575265761133e-28,  1.711044913023340e-28, -2.513592878950118e-29,
  2.794931262089406e-30, -2.500899463737430e-31,  1.873095508035914e-32, -1.206859007908558e-33,  6.825520258338495e-35, -3.441125646990237e-36,  1.565477740871272e-37,
 -6.481618605984763e-39,  5.058368433147287e-28, -2.118451655569883e-28,  4.736604174618636e-29, -7.193772920116464e-30,  8.265619484353816e-31, -7.637371283045441e-32,
  5.902319849823195e-33, -3.921013299021352e-34,  2.284659816368085e-35, -1.185771168403268e-36,  5.549321797808876e-38, -2.361697392605963e-39,  1.543085046313767e-28,
 -6.615667840991649e-29,  1.518191056360726e-29, -2.366991154831522e-30,  2.790879456310723e-31, -2.644887366095021e-32,  2.095219172051378e-33, -1.425890698726046e-34,
  8.506055126909951e-36, -4.517178900781838e-37,  2.161784373334237e-38, -9.402194573157033e-40,  5.272620195059971e-29, -2.298011201704712e-29,  5.371443814163824e-30,
 -8.531337961020026e-31,  1.024507675374813e-31, -9.885016634089276e-33,  7.969262274223519e-34, -5.517076136522389e-35,  3.346569416370257e-36, -1.806361539763949e-37,
  8.782855417525674e-39, -3.879214421416570e-40,  1.594356673519884e-29, -7.013196919794209e-30,  1.656353512975926e-30, -2.658413052115267e-31,  3.225588008166951e-32,
 -3.143924201115000e-33,  2.559849363681599e-34, -1.789383307430384e-35,  1.095691112287317e-36, -5.968753233395532e-38,  2.928221061072872e-39, -1.304640321400895e-40,
  4.938032799535215e-02, -9.987472299852620e-05,  2.075738854001877e-07, -4.419155442408829e-10,  9.593406807599585e-13, -2.115423312193554e-15,  4.713637850527627e-18,
 -1.059678031537385e-20,  2.388526352403116e-23, -5.420191979603675e-26,  1.222634038349253e-28, -2.794098403922531e-31,  4.566026829886641e-02, -1.063853823344249e-04,
  2.918978039170842e-07, -8.532261180503673e-10,  2.518560786970756e-12, -7.365288698190863e-15,  2.123121440783716e-17, -6.034855699018644e-20,  1.693005686076751e-22,
 -4.697636163776727e-25,  1.289696398245764e-27, -3.511999089146163e-30,  3.903977037232597e-02, -1.150040425135636e-04,  4.317912534075408e-07, -1.626013227228961e-09,
  5.896654241527069e-12, -2.065275519758188e-14,  7.033024081887702e-17, -2.340570839621777e-19,  7.638992366689549e-22, -2.451445618061880e-24,  7.749950216123567e-27,
 -2.417557380089734e-29,  3.086456968886553e-02, -1.195230321424528e-04,  5.799208021580599e-07, -2.633003156048834e-09,  1.122918580569586e-11, -4.574186500735573e-14,
  1.797656962144518e-16, -6.858496132599333e-19,  2.551371067582402e-21, -9.284542644610983e-24,  3.313695438062756e-26, -1.162304086280122e-28,  2.256304815214506e-02,
 -1.153744702489664e-04,  6.874418479542633e-07, -3.657647287407028e-09,  1.804256455727230e-11, -8.426894226547906e-14,  3.768685181205704e-16, -1.625766587745013e-18,
  6.801460774296836e-21, -2.770668753831437e-23,  1.102535082224798e-25, -4.296564462813019e-28,  1.525181512152932e-02, -1.017787826222981e-04,  7.214790011491290e-07,
 -4.438833414546466e-09,  2.505991679717327e-11, -1.327772189366992e-13,  6.687204355925145e-16, -3.229474927812877e-18,  1.505044371865792e-20, -6.801083401707515e-23,
  2.991173308281882e-25, -1.284171439535051e-27,  9.533127571256246e-03, -8.158196245590586e-05,  6.754398747608384e-07, -4.764816155886158e-09,  3.052749778701946e-11,
 -1.819558687589808e-13,  1.023860163593588e-15, -5.494047106351022e-18,  2.831942201962523e-20, -1.409903710537939e-22,  6.808474576249250e-25, -3.199788294735852e-27,
  5.509939315099061e-03, -5.936428024802719e-05,  5.677070831348341e-07, -4.561346597695428e-09,  3.293175178582309e-11, -2.193445835452437e-13,  1.370418167916372e-15,
 -8.122987436876932e-18,  4.605201014695539e-20, -2.512443961343877e-22,  1.325279313554316e-24, -6.784195456519079e-27,  2.944885037997365e-03, -3.925678717247507e-05,
  4.304801730904598e-07, -3.916622654786163e-09,  3.167886175992576e-11, -2.345184949574520e-13,  1.618713552915213e-15, -1.054816057774253e-17,  6.547573227776401e-20,
 -3.897468655628225e-22,  2.236283591754869e-24, -1.241884814623148e-26,  1.455525145702187e-03, -2.363311036042707e-05,  2.955717905646347e-07, -3.029581649542734e-09,
  2.731834782065191e-11, -2.237795460107437e-13,  1.699304170071796e-15, -1.212583511945746e-17,  8.210264663072822e-20, -5.313164847104329e-22,  3.304676544143879e-24,
 -1.984248709430844e-26,  6.653193868937456e-04, -1.297646231543273e-05,  1.842828566888118e-07, -2.118331498064285e-09,  2.120734000575022e-11, -1.915039172398747e-13,
  1.594272524440690e-15, -1.241648236988617e-17,  9.141498158420688e-20, -6.412053145538485e-22,  4.310660476894089e-24, -2.790656428095602e-26,  2.812816716753453e-04,
 -6.510231058250843e-06,  1.045714370991502e-07, -1.342668019403820e-09,  1.487114756447747e-11, -1.475584866026912e-13,  1.342712233625685e-15, -1.138124072072126e-17,
  9.086944230352038e-20, -6.890773463330591e-22,  4.994770228897975e-24, -3.478085276656151e-26,  1.100046505569273e-04, -2.989176929294710e-06,  5.411088116157456e-08,
 -7.732913707420707e-10,  9.446430523888735e-12, -1.027084434737364e-13,  1.018914119181027e-15, -9.376950321001209e-18,  8.100284194880498e-20, -6.626227024350635e-22,
  5.167707696428341e-24, -3.862781719700436e-26,  3.980306781084018e-05, -1.257961634806288e-06,  2.557598588862936e-08, -4.055269625319064e-10,  5.449044063853223e-12,
 -6.476206395149718e-14,  6.988597355182335e-16, -6.968168567232780e-18,  6.499857373961620e-20, -5.724820848926913e-22,  4.794983431695525e-24, -3.840648535313998e-26,
  1.332785598473234e-05, -4.858868900814989e-07,  1.105911990070238e-08, -1.940014657717289e-10,  2.860496731245481e-12, -3.708288190958221e-14,  4.344376613679246e-16,
 -4.684516920713839e-18,  4.710265792174115e-20, -4.459442310443598e-22,  4.005109373727723e-24, -3.432315123686359e-26,  4.131190280852179e-06, -1.724676695172787e-07,
  4.380971943430352e-09, -8.480862499410377e-11,  1.369249258883783e-12, -1.932511156483702e-14,  2.453632871847241e-16, -2.856658424375736e-18,  3.091565552961482e-20,
 -3.141723085155804e-22,  3.021445801822622e-24, -2.766749231311791e-26,  1.185854874010735e-06, -5.632685289068116e-08,  1.592139139353750e-09, -3.393320320034737e-11,
  5.987380071963045e-13, -9.184375041934478e-15,  1.261846602189544e-16, -1.583993271188089e-18,  1.842631352509026e-20, -2.007420282025591e-22,  2.064806282099705e-24,
 -2.017984464102505e-26,  3.153878647373193e-07, -1.694664994370033e-08,  5.315528067476689e-10, -1.244629578776513e-11,  2.395878287916084e-13, -3.988353819049939e-15,
  5.921480506049947e-17, -8.004494860740149e-19,  9.997225449239849e-21, -1.166309606697920e-22,  1.281728696742334e-24, -1.335622526196408e-26,  7.776533183163904e-08,
 -4.702729482058178e-09,  1.632573532331838e-10, -4.191471798000736e-12,  8.788523313447035e-14, -1.585514656277186e-15,  2.540745394689155e-17, -3.694391005882509e-19,
  4.948857573259331e-21, -6.176706302723194e-23,  7.245778479885795e-25, -8.043467618993881e-27,  1.779062872524763e-08, -1.205259517971416e-09,  4.619495933761992e-11,
 -1.298087473681922e-12,  2.960397240389780e-14, -5.780915049705347e-16,  9.987850823789585e-18, -1.560656172116080e-19,  2.240240816162379e-21, -2.988813470928071e-23,
  3.739619582612830e-25, -4.419026552684668e-27,  3.779868671878808e-09, -2.856868178487944e-10,  1.206125149264237e-11, -3.703312001261677e-13,  9.173967634232583e-15,
 -1.936925009889819e-16,  3.604553615705913e-18, -6.047314694557922e-20,  9.294586805299509e-22, -1.324541294415090e-23,  1.766415777911224e-25, -2.220474820026482e-27,
  7.467121143353618e-10, -6.272798812026024e-11,  2.910792889030714e-12, -9.750383220903297e-14,  2.620470310647256e-15, -5.975907595641151e-17,  1.196812806389587e-18,
 -2.154151747763139e-20,  3.542568230762907e-22, -5.388934588262484e-24,  7.655355170362522e-26, -1.023108581462064e-27,  1.373552246308452e-10, -1.278104047049938e-11,
  6.505524318559286e-13, -2.373963388234487e-14,  6.914035062305448e-16, -1.701462735080467e-17,  3.664246983539089e-19, -7.070851782161847e-21,  1.243416042198746e-22,
 -2.017909382239921e-24,  3.051882455337062e-26, -4.334201539263711e-28,  2.356744324614127e-11, -2.421536977722600e-12,  1.349415388590956e-13, -5.357065920755718e-15,
  1.688992690063891e-16, -4.481398233177184e-18,  1.037056013948041e-19, -2.144141207469362e-21,  4.029562779594811e-23, -6.973051188761514e-25,  1.122247940931879e-26,
 -1.692868381028495e-28,  3.779862819466064e-12, -4.276262432972268e-13,  2.604222024225439e-14, -1.123287920479121e-15,  3.830068810809616e-17, -1.094817568754535e-18,
  2.720619686336973e-20, -6.023296573344616e-22,  1.209146327122042e-23, -2.230106008820883e-25,  3.817769358667096e-27, -6.114585252223744e-29,  5.681309792430651e-13,
 -7.058103546917941e-14,  4.689465630003807e-15, -2.195019296200499e-16,  8.086536329077798e-18, -2.488408760902256e-19,  6.636133270338716e-21, -1.572410765616894e-22,
  3.370145701935775e-24, -6.622109753586653e-26,  1.205408237368056e-27, -2.049088835793162e-29,  8.027304097128752e-14, -1.092382293437958e-14,  7.905491207986520e-16,
 -4.010860916279985e-17,  1.595074072348702e-18, -5.280226543829938e-20,  1.510274580803818e-21, -3.828007295709661e-23,  8.755950145694475e-25, -1.832242300891498e-26,
  3.545038681336922e-28, -6.394023604807804e-30,  1.070160686517992e-14, -1.591437299582589e-15,  1.252524276105208e-16, -6.880105530863465e-18,  2.951054537071345e-19,
 -1.050164027703626e-20,  3.219728314056833e-22, -8.725473330356080e-24,  2.129033359345086e-25, -4.742747861875866e-27,  9.750347923529945e-29, -1.865357414986837e-30,
  1.352115096815108e-15, -2.192298198661056e-16,  1.873609313047171e-17, -1.113015149974802e-18,  5.144504948084744e-20, -1.966648910775370e-21,  6.459440060269582e-23,
 -1.870693341810462e-24,  4.867119491479074e-26, -1.153775754742287e-27,  2.519492531579939e-29, -5.110972024131136e-31,  1.627667896760095e-16, -2.870977155014760e-17,
  2.660346744579598e-18, -1.707195192108873e-19,  8.495718716765760e-21, -3.486361226312085e-22,  1.225979562812303e-23, -3.792305366869718e-25,  1.051600945460112e-26,
 -2.651706938255798e-28,  6.148341344955069e-30, -1.322045115868129e-31,  1.878655098006994e-17, -3.596885467755984e-18,  3.608309927199247e-19, -2.498429787572046e-20,
  1.337378662798030e-21, -5.886827635750724e-23,  2.214884660651682e-24, -7.313698212756954e-26,  2.160451647394562e-27, -5.792247861855579e-29,  1.425408767837034e-30,
 -3.247544002398242e-32,  2.094652628849865e-18, -4.343413568145567e-19,  4.709723200592696e-20, -3.514349361532153e-21,  2.021470182646669e-22, -9.536347575463782e-24,
  3.836135169590538e-25, -1.351344786081506e-26,  4.249936552694890e-28, -1.210831585076864e-29,  3.160991135486595e-31, -7.627186567474583e-33,  2.276194955538218e-19,
 -5.099863058752707e-20,  5.967460274540481e-21, -4.792362907384776e-22,  2.958869916548599e-23, -1.494562382526379e-24,  6.422487111108198e-26, -2.411764373454013e-27,
  8.069784189524687e-29, -2.441666938711658e-30,  6.757953986709130e-32, -1.725977862263408e-33,  2.435958652129996e-20, -5.882795224019124e-21,  7.414863980234196e-22,
 -6.399353413702377e-23,  4.235650784781663e-24, -2.288242593509919e-25,  1.049394180629286e-26, -4.196989997209253e-28,  1.492842168651734e-29, -4.793174898178739e-31,
  1.405470250807976e-32, -3.796760858134969e-34,  2.598936641302792e-21, -6.747307449006669e-22,  9.142792731826141e-23, -8.465688468970657e-24,  5.998217766045627e-25,
 -3.461239532929287e-26,  1.691996755778532e-27, -7.199287756534595e-29,  2.719371769530717e-30, -9.256396751264461e-32,  2.872824891551301e-33, -8.201350929160808e-35,
  2.803798815756275e-22, -7.802890713917144e-23,  1.134138189770014e-23, -1.124520707970725e-24,  8.514514150229759e-26, -5.239853111886891e-27,  2.726412266704220e-28,
 -1.232497534080602e-29,  4.937587332781910e-31, -1.779612954493244e-32,  5.839249807277044e-34, -1.759661901830924e-35,  3.108936574714932e-23, -9.245240789669748e-24,
  1.437762351504577e-24, -1.523121097371001e-25,  1.229915167220051e-26, -8.056867251670886e-28,  4.454279011093401e-29, -2.135763372011581e-30,  9.060313167877418e-32,
 -3.452488749638915e-33,  1.195896534813731e-34, -3.798793617643998e-36,  3.609486802629173e-24, -1.142926599278552e-24,  1.896150432295292e-25, -2.140526961478670e-26,
  1.838873115881090e-27, -1.279333108580470e-28,  7.498885772710315e-30, -3.805936990842870e-31,  1.706313456662250e-32, -6.861266642990059e-34,  2.504387035396405e-35,
 -8.370691855726438e-37,  4.479676339739931e-25, -1.504440246028707e-25,  2.653618213812775e-26, -3.182237446601638e-27,  2.899919950775114e-28, -2.136775579160672e-29,
  1.324434696562511e-30, -7.097234398644814e-32,  3.354590570494341e-33, -1.420115215076899e-34,  5.449674347185077e-36, -1.912399694164958e-37,  6.079063201939478e-26,
 -2.155793232672333e-26,  4.026842340916738e-27, -5.110979825159185e-28,  4.923389407619157e-29, -3.829410705634165e-30,  2.501930896125605e-31, -1.411213007767732e-32,
  7.011432075706894e-34, -3.115880623163415e-35,  1.253619532086710e-36, -4.606193430542785e-38,  9.237959537614727e-27, -3.442354691784967e-27,  6.778302760942347e-28,
 -9.066141714075880e-29,  9.193664954941951e-30, -7.518340630992554e-31,  5.157871689827639e-32, -3.050956975439844e-33,  1.587648915637439e-34, -7.380831972740578e-36,
  3.102826022336957e-37, -1.189789302038032e-38,  1.609987562800638e-27, -6.269716299472893e-28,  1.294603306092611e-28, -1.815529323229706e-29,  1.928671977250764e-30,
 -1.650489160526934e-31,  1.183554609322380e-32, -7.309459641800242e-34,  3.966867046618437e-35, -1.921178033765989e-36,  8.404817229837738e-38, -3.350156770749648e-39,
  3.288112442384504e-28, -1.330218340284288e-28,  2.863095939442623e-29, -4.185389598614146e-30,  4.631521287212929e-31, -4.124929819396823e-32,  3.075440688098508e-33,
 -1.972833833733794e-34,  1.111001380387937e-35, -5.578030958505631e-37,  2.527456313702260e-38, -1.042398459333529e-39,  7.988700802073523e-29, -3.335696552146536e-29,
  7.433742023462319e-30, -1.125302752266988e-30,  1.288807267352370e-31, -1.187113838875846e-32,  9.146304089337035e-34, -6.058073953925707e-35,  3.519731687707153e-36,
 -1.821705279373366e-37,  8.502422604604347e-39, -3.609032134952055e-40,  2.306950566903798e-29, -9.873378891344074e-30,  2.261409791390792e-30, -3.518903642535673e-31,
  4.141182281862704e-32, -3.917265278037079e-33,  3.097558786850477e-34, -2.104324899024783e-35,  1.253179220152873e-36, -6.644039865779438e-38,  3.174520867009839e-39,
 -1.378535963832260e-40,  7.574660218209894e-30, -3.298559255899962e-30,  7.702920454917443e-31, -1.222280063857493e-31,  1.466438581528850e-32, -1.413610724008519e-33,
  1.138633550312815e-34, -7.875864095465004e-36,  4.773340179618514e-37, -2.574366110382319e-38,  1.250702421527169e-39, -5.519820093656416e-41,  2.238664120988080e-30,
 -9.844168449813287e-31,  2.324113186455808e-31, -3.728769102274541e-32,  4.522638148195451e-33, -4.406535080327395e-34,  3.586613269710501e-35, -2.506232924697931e-36,
  1.534112046182266e-37, -8.354230092487985e-39,  4.097165169320203e-40, -1.824864029906199e-41,  };
  int offset = -47;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 47;
    if (std::isnan(t)) {
      fill_n(rr+offset, 47, 0.5);
      fill_n(ww+offset, 47, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 47; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=47; ++j) {
        const int boxof = it*564+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
