# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG VX9100"""
import time
from prototypes import *
from prototypeslg import *

# Make all lg stuff available in this module as well
from p_lg import *

# we are the same as lgvx9800 except as noted
# below
from p_lgvx8550 import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

NUMSPEEDDIALS=1000
FIRSTSPEEDDIAL=1
LASTSPEEDDIAL=999

NUMEMERGENCYCONTACTS=3

BREW_FILE_SYSTEM=2

INDEX_RT_TYPE=257
INDEX_SOUND_TYPE=2
INDEX_VIDEO_TYPE=3
INDEX_IMAGE_TYPE=0
INDEX_SDIMAGE_TYPE=16
INDEX_SDVIDEO_TYPE=19
INDEX_SDSOUND_TYPE=18

MAX_PHONEBOOK_GROUPS=30
PB_ENTRY_SOR='<PE>'
PB_ENTRY_EOF='<HPE>\x00VX9100\x00\x00\x00\x00\xD8\x07\x06\x00\x10\x00\x0F\x00\x14\x00\x30'+'\x00'*222+'</HPE>\x00'
PB_NUMBER_SOR='<PN>'

pb_group_filename='pim/pbgroup.dat'
pb_recordid_filename='pim/record_id.dat'
pb_ice_file_name   = 'pim/pbiceentry.dat'

NUMCALENDARENTRIES=300

# SMS index files
inbox_index     = "dload/inbox.dat"
outbox_index    = "dload/outbox.dat"
drafts_index    = "dload/drafts.dat"

class indexentry(BaseProtogenClass):
    __fields=['filename', 'size', 'date', 'type', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(indexentry,self).__init__(**dict)
        if self.__class__ is indexentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(indexentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(indexentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_filename.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        try: self.__field_date
        except:
            self.__field_date=GPSDATE(**{'sizeinbytes': 4, 'default': GPSDATE.now()})
        self.__field_date.writetobuffer(buf)
        self.__field_type.writetobuffer(buf)
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_filename=USTRING(**{'sizeinbytes': 256, 'encoding': PHONE_ENCODING,                 'raiseonunterminatedread': False,                 'raiseontruncate': False })
        self.__field_filename.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_date=GPSDATE(**{'sizeinbytes': 4, 'default': GPSDATE.now()})
        self.__field_date.readfrombuffer(buf)
        self.__field_type=UINT(**{'sizeinbytes': 4})
        self.__field_type.readfrombuffer(buf)
        self.__field_dunno=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'sizeinbytes': 256, 'encoding': PHONE_ENCODING,                 'raiseonunterminatedread': False,                 'raiseontruncate': False })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, "full pathname")

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_date(self):
        try: self.__field_date
        except:
            self.__field_date=GPSDATE(**{'sizeinbytes': 4, 'default': GPSDATE.now()})
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,GPSDATE):
            self.__field_date=value
        else:
            self.__field_date=GPSDATE(value,**{'sizeinbytes': 4, 'default': GPSDATE.now()})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,**{'sizeinbytes': 4})

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, None)

    def __getfield_dunno(self):
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UINT):
            self.__field_dunno=value
        else:
            self.__field_dunno=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('filename', self.__field_filename, "full pathname")
        yield ('size', self.__field_size, None)
        yield ('date', self.__field_date, None)
        yield ('type', self.__field_type, None)
        yield ('dunno', self.__field_dunno, None)




class indexfile(BaseProtogenClass):
    "Used for tracking wallpaper and ringtones"
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(indexfile,self).__init__(**dict)
        if self.__class__ is indexfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(indexfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(indexfile,kwargs)
        if len(args):
            dict2={'elementclass': indexentry, 'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{'elementclass': indexentry, 'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class pbgroup(BaseProtogenClass):
    __fields=['name', 'groupid', 'user_added']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroup,self).__init__(**dict)
        if self.__class__ is pbgroup:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroup,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroup,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.writetobuffer(buf)
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.writetobuffer(buf)
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_user_added.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.readfrombuffer(buf)
        self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.readfrombuffer(buf)
        self.__field_user_added=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_user_added.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_groupid(self):
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_groupid.getvalue()

    def __setfield_groupid(self, value):
        if isinstance(value,UINT):
            self.__field_groupid=value
        else:
            self.__field_groupid=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_groupid(self): del self.__field_groupid

    groupid=property(__getfield_groupid, __setfield_groupid, __delfield_groupid, None)

    def __getfield_user_added(self):
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_user_added.getvalue()

    def __setfield_user_added(self, value):
        if isinstance(value,UINT):
            self.__field_user_added=value
        else:
            self.__field_user_added=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_user_added(self): del self.__field_user_added

    user_added=property(__getfield_user_added, __setfield_user_added, __delfield_user_added, "=1 when was added by user")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('groupid', self.__field_groupid, None)
        yield ('user_added', self.__field_user_added, "=1 when was added by user")




class pbgroups(BaseProtogenClass):
    "Phonebook groups"
    __fields=['groups']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroups,self).__init__(**dict)
        if self.__class__ is pbgroups:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroups,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroups,kwargs)
        if len(args):
            dict2={'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_groups=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_groups(self):
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        return self.__field_groups.getvalue()

    def __setfield_groups(self, value):
        if isinstance(value,LIST):
            self.__field_groups=value
        else:
            self.__field_groups=LIST(value,**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})

    def __delfield_groups(self): del self.__field_groups

    groups=property(__getfield_groups, __setfield_groups, __delfield_groups, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('groups', self.__field_groups, None)




class speeddial(BaseProtogenClass):
    __fields=['entry', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddial,self).__init__(**dict)
        if self.__class__ is speeddial:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddial,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddial,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.writetobuffer(buf)
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.readfrombuffer(buf)
        self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry(self):
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,UINT):
            self.__field_entry=value
        else:
            self.__field_entry=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, "0-based entry number")

    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,UINT):
            self.__field_number=value
        else:
            self.__field_number=UINT(value,**{'sizeinbytes': 1, 'default': 0xff})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, "number type")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry', self.__field_entry, "0-based entry number")
        yield ('number', self.__field_number, "number type")

    def valid(self):
        return self.entry!=0xffff




class speeddials(BaseProtogenClass):
    __fields=['speeddials']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddials,self).__init__(**dict)
        if self.__class__ is speeddials:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddials,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddials,kwargs)
        if len(args):
            dict2={'length': NUMSPEEDDIALS, 'elementclass': speeddial}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_speeddials=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_speeddials(self):
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        return self.__field_speeddials.getvalue()

    def __setfield_speeddials(self, value):
        if isinstance(value,LIST):
            self.__field_speeddials=value
        else:
            self.__field_speeddials=LIST(value,**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})

    def __delfield_speeddials(self): del self.__field_speeddials

    speeddials=property(__getfield_speeddials, __setfield_speeddials, __delfield_speeddials, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('speeddials', self.__field_speeddials, None)




class pbfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'pad00', 'mod_date', 'unk0', 'entry_number1', 'entry_number0', 'name', 'group', 'emails', 'ringtone', 'wallpaper', 'numbertypes', 'numberindices', 'memo', 'exit_tag', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfileentry,self).__init__(**dict)
        if self.__class__ is pbfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            try: self.__field_pad00
            except:
                self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.writetobuffer(buf)
            self.__field_entry_number1.writetobuffer(buf)
            self.__field_entry_number0.writetobuffer(buf)
            try: self.__field_name
            except:
                self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.writetobuffer(buf)
            try: self.__field_group
            except:
                self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.writetobuffer(buf)
            try: self.__field_emails
            except:
                self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx9100_126, 'length': NUMEMAILS})
            self.__field_emails.writetobuffer(buf)
            try: self.__field_ringtone
            except:
                self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.writetobuffer(buf)
            try: self.__field_wallpaper
            except:
                self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.writetobuffer(buf)
            try: self.__field_numbertypes
            except:
                self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx9100_130, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.writetobuffer(buf)
            try: self.__field_numberindices
            except:
                self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx9100_132, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.writetobuffer(buf)
            try: self.__field_memo
            except:
                self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_dontcare
            except:
                self.__field_dontcare=DATA(**{'sizeinbytes': 252,  'default': '\xff'*252 })
            self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_entry_number1=UINT(**{'sizeinbytes': 4})
            self.__field_entry_number1.readfrombuffer(buf)
            self.__field_entry_number0=UINT(**{'sizeinbytes': 2})
            self.__field_entry_number0.readfrombuffer(buf)
            self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.readfrombuffer(buf)
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.readfrombuffer(buf)
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx9100_126, 'length': NUMEMAILS})
            self.__field_emails.readfrombuffer(buf)
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.readfrombuffer(buf)
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.readfrombuffer(buf)
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx9100_130, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.readfrombuffer(buf)
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx9100_132, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.readfrombuffer(buf)
            self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_dontcare=DATA(**{'sizeinbytes': 252,  'default': '\xff'*252 })
            self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_pad00(self):
        try: self.__field_pad00
        except:
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_pad00.getvalue()

    def __setfield_pad00(self, value):
        if isinstance(value,UINT):
            self.__field_pad00=value
        else:
            self.__field_pad00=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_pad00(self): del self.__field_pad00

    pad00=property(__getfield_pad00, __setfield_pad00, __delfield_pad00, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_entry_number1(self):
        return self.__field_entry_number1.getvalue()

    def __setfield_entry_number1(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number1=value
        else:
            self.__field_entry_number1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entry_number1(self): del self.__field_entry_number1

    entry_number1=property(__getfield_entry_number1, __setfield_entry_number1, __delfield_entry_number1, None)

    def __getfield_entry_number0(self):
        return self.__field_entry_number0.getvalue()

    def __setfield_entry_number0(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number0=value
        else:
            self.__field_entry_number0=UINT(value,**{'sizeinbytes': 2})

    def __delfield_entry_number0(self): del self.__field_entry_number0

    entry_number0=property(__getfield_entry_number0, __setfield_entry_number0, __delfield_entry_number0, None)

    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_emails(self):
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx9100_126, 'length': NUMEMAILS})
        return self.__field_emails.getvalue()

    def __setfield_emails(self, value):
        if isinstance(value,LIST):
            self.__field_emails=value
        else:
            self.__field_emails=LIST(value,**{'elementclass': _gen_p_lgvx9100_126, 'length': NUMEMAILS})

    def __delfield_emails(self): del self.__field_emails

    emails=property(__getfield_emails, __setfield_emails, __delfield_emails, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_numbertypes(self):
        try: self.__field_numbertypes
        except:
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx9100_130, 'length': NUMPHONENUMBERS})
        return self.__field_numbertypes.getvalue()

    def __setfield_numbertypes(self, value):
        if isinstance(value,LIST):
            self.__field_numbertypes=value
        else:
            self.__field_numbertypes=LIST(value,**{'elementclass': _gen_p_lgvx9100_130, 'length': NUMPHONENUMBERS})

    def __delfield_numbertypes(self): del self.__field_numbertypes

    numbertypes=property(__getfield_numbertypes, __setfield_numbertypes, __delfield_numbertypes, None)

    def __getfield_numberindices(self):
        try: self.__field_numberindices
        except:
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx9100_132, 'length': NUMPHONENUMBERS})
        return self.__field_numberindices.getvalue()

    def __setfield_numberindices(self, value):
        if isinstance(value,LIST):
            self.__field_numberindices=value
        else:
            self.__field_numberindices=LIST(value,**{'elementclass': _gen_p_lgvx9100_132, 'length': NUMPHONENUMBERS})

    def __delfield_numberindices(self): del self.__field_numberindices

    numberindices=property(__getfield_numberindices, __setfield_numberindices, __delfield_numberindices, None)

    def __getfield_memo(self):
        try: self.__field_memo
        except:
            self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
        return self.__field_memo.getvalue()

    def __setfield_memo(self, value):
        if isinstance(value,USTRING):
            self.__field_memo=value
        else:
            self.__field_memo=USTRING(value,**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })

    def __delfield_memo(self): del self.__field_memo

    memo=property(__getfield_memo, __setfield_memo, __delfield_memo, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 252,  'default': '\xff'*252 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 252,  'default': '\xff'*252 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag==PB_ENTRY_SOR:
            yield ('pad00', self.__field_pad00, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('entry_number1', self.__field_entry_number1, None)
            yield ('entry_number0', self.__field_entry_number0, None)
            yield ('name', self.__field_name, None)
            yield ('group', self.__field_group, None)
            yield ('emails', self.__field_emails, None)
            yield ('ringtone', self.__field_ringtone, None)
            yield ('wallpaper', self.__field_wallpaper, None)
            yield ('numbertypes', self.__field_numbertypes, None)
            yield ('numberindices', self.__field_numberindices, None)
            yield ('memo', self.__field_memo, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        global PB_ENTRY_SOR
        return self.entry_tag==PB_ENTRY_SOR




class _gen_p_lgvx9100_126(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['email']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_126,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_126:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_126,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_126,kwargs)
        if len(args):
            dict2={'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_email=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_email.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_email=USTRING(**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})
        self.__field_email.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('email', self.__field_email, None)




class _gen_p_lgvx9100_130(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numbertype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_130,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_130:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_130,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_130,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numbertype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numbertype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numbertype=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_numbertype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numbertype(self):
        return self.__field_numbertype.getvalue()

    def __setfield_numbertype(self, value):
        if isinstance(value,UINT):
            self.__field_numbertype=value
        else:
            self.__field_numbertype=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_numbertype(self): del self.__field_numbertype

    numbertype=property(__getfield_numbertype, __setfield_numbertype, __delfield_numbertype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numbertype', self.__field_numbertype, None)




class _gen_p_lgvx9100_132(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numberindex']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_132,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_132:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_132,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_132,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0xffff }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numberindex=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numberindex.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numberindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_numberindex.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numberindex(self):
        return self.__field_numberindex.getvalue()

    def __setfield_numberindex(self, value):
        if isinstance(value,UINT):
            self.__field_numberindex=value
        else:
            self.__field_numberindex=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_numberindex(self): del self.__field_numberindex

    numberindex=property(__getfield_numberindex, __setfield_numberindex, __delfield_numberindex, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numberindex', self.__field_numberindex, None)




class pbfile(BaseProtogenClass):
    __fields=['items', 'eof_tag', 'model_name', 'mod_date', 'blanks', 'eof_close_tag']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfile,self).__init__(**dict)
        if self.__class__ is pbfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.writetobuffer(buf)
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.writetobuffer(buf)
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'default': 'VX9100' })
        self.__field_model_name.writetobuffer(buf)
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.writetobuffer(buf)
        try: self.__field_blanks
        except:
            self.__field_blanks=STRING(**{'sizeinbytes': 221,  'default': '' })
        self.__field_blanks.writetobuffer(buf)
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.readfrombuffer(buf)
        self.__field_model_name=STRING(**{'sizeinbytes': 10,  'default': 'VX9100' })
        self.__field_model_name.readfrombuffer(buf)
        self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.readfrombuffer(buf)
        self.__field_blanks=STRING(**{'sizeinbytes': 221,  'default': '' })
        self.__field_blanks.readfrombuffer(buf)
        self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def __getfield_eof_tag(self):
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        return self.__field_eof_tag.getvalue()

    def __setfield_eof_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_tag=value
        else:
            self.__field_eof_tag=STRING(value,**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })

    def __delfield_eof_tag(self): del self.__field_eof_tag

    eof_tag=property(__getfield_eof_tag, __setfield_eof_tag, __delfield_eof_tag, None)

    def __getfield_model_name(self):
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'default': 'VX9100' })
        return self.__field_model_name.getvalue()

    def __setfield_model_name(self, value):
        if isinstance(value,STRING):
            self.__field_model_name=value
        else:
            self.__field_model_name=STRING(value,**{'sizeinbytes': 10,  'default': 'VX9100' })

    def __delfield_model_name(self): del self.__field_model_name

    model_name=property(__getfield_model_name, __setfield_model_name, __delfield_model_name, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=STRING(**{'sizeinbytes': 221,  'default': '' })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,STRING):
            self.__field_blanks=value
        else:
            self.__field_blanks=STRING(value,**{'sizeinbytes': 221,  'default': '' })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def __getfield_eof_close_tag(self):
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        return self.__field_eof_close_tag.getvalue()

    def __setfield_eof_close_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_close_tag=value
        else:
            self.__field_eof_close_tag=STRING(value,**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })

    def __delfield_eof_close_tag(self): del self.__field_eof_close_tag

    eof_close_tag=property(__getfield_eof_close_tag, __setfield_eof_close_tag, __delfield_eof_close_tag, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)
        yield ('eof_tag', self.__field_eof_tag, None)
        yield ('model_name', self.__field_model_name, None)
        yield ('mod_date', self.__field_mod_date, None)
        yield ('blanks', self.__field_blanks, None)
        yield ('eof_close_tag', self.__field_eof_close_tag, None)




class pnfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'pad00', 'mod_date', 'unk0', 'pn_id', 'pe_id', 'pn_order', 'phone_number', 'type', 'unk2', 'exit_tag', 'blanks']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfileentry,self).__init__(**dict)
        if self.__class__ is pnfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag==PB_NUMBER_SOR:
            try: self.__field_pad00
            except:
                self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.writetobuffer(buf)
            self.__field_pn_id.writetobuffer(buf)
            self.__field_pe_id.writetobuffer(buf)
            self.__field_pn_order.writetobuffer(buf)
            self.__field_phone_number.writetobuffer(buf)
            self.__field_type.writetobuffer(buf)
            try: self.__field_unk2
            except:
                self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
            self.__field_unk2.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_blanks
            except:
                self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag==PB_NUMBER_SOR:
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_pn_id=UINT(**{'sizeinbytes': 2})
            self.__field_pn_id.readfrombuffer(buf)
            self.__field_pe_id=UINT(**{'sizeinbytes': 2})
            self.__field_pe_id.readfrombuffer(buf)
            self.__field_pn_order=UINT(**{'sizeinbytes': 1})
            self.__field_pn_order.readfrombuffer(buf)
            self.__field_phone_number=LGHEXPN(**{'sizeinbytes': 25})
            self.__field_phone_number.readfrombuffer(buf)
            self.__field_type=UINT(**{'sizeinbytes': 2})
            self.__field_type.readfrombuffer(buf)
            self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
            self.__field_unk2.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_pad00(self):
        try: self.__field_pad00
        except:
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_pad00.getvalue()

    def __setfield_pad00(self, value):
        if isinstance(value,UINT):
            self.__field_pad00=value
        else:
            self.__field_pad00=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_pad00(self): del self.__field_pad00

    pad00=property(__getfield_pad00, __setfield_pad00, __delfield_pad00, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_pn_id(self):
        return self.__field_pn_id.getvalue()

    def __setfield_pn_id(self, value):
        if isinstance(value,UINT):
            self.__field_pn_id=value
        else:
            self.__field_pn_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pn_id(self): del self.__field_pn_id

    pn_id=property(__getfield_pn_id, __setfield_pn_id, __delfield_pn_id, None)

    def __getfield_pe_id(self):
        return self.__field_pe_id.getvalue()

    def __setfield_pe_id(self, value):
        if isinstance(value,UINT):
            self.__field_pe_id=value
        else:
            self.__field_pe_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pe_id(self): del self.__field_pe_id

    pe_id=property(__getfield_pe_id, __setfield_pe_id, __delfield_pe_id, None)

    def __getfield_pn_order(self):
        return self.__field_pn_order.getvalue()

    def __setfield_pn_order(self, value):
        if isinstance(value,UINT):
            self.__field_pn_order=value
        else:
            self.__field_pn_order=UINT(value,**{'sizeinbytes': 1})

    def __delfield_pn_order(self): del self.__field_pn_order

    pn_order=property(__getfield_pn_order, __setfield_pn_order, __delfield_pn_order, "0-based order of this phone within this contact")

    def __getfield_phone_number(self):
        return self.__field_phone_number.getvalue()

    def __setfield_phone_number(self, value):
        if isinstance(value,LGHEXPN):
            self.__field_phone_number=value
        else:
            self.__field_phone_number=LGHEXPN(value,**{'sizeinbytes': 25})

    def __delfield_phone_number(self): del self.__field_phone_number

    phone_number=property(__getfield_phone_number, __setfield_phone_number, __delfield_phone_number, None)

    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,**{'sizeinbytes': 2})

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, None)

    def __getfield_unk2(self):
        try: self.__field_unk2
        except:
            self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
        return self.__field_unk2.getvalue()

    def __setfield_unk2(self, value):
        if isinstance(value,UINT):
            self.__field_unk2=value
        else:
            self.__field_unk2=UINT(value,**{'sizeinbytes': 3,  'default': 0 })

    def __delfield_unk2(self): del self.__field_unk2

    unk2=property(__getfield_unk2, __setfield_unk2, __delfield_unk2, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,DATA):
            self.__field_blanks=value
        else:
            self.__field_blanks=DATA(value,**{'sizeinbytes': 60,  'default': '\xFF'*60 })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag==PB_NUMBER_SOR:
            yield ('pad00', self.__field_pad00, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('pn_id', self.__field_pn_id, None)
            yield ('pe_id', self.__field_pe_id, None)
            yield ('pn_order', self.__field_pn_order, "0-based order of this phone within this contact")
            yield ('phone_number', self.__field_phone_number, None)
            yield ('type', self.__field_type, None)
            yield ('unk2', self.__field_unk2, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('blanks', self.__field_blanks, None)

    def valid(self):
        global PB_NUMBER_SOR
        return self.entry_tag==PB_NUMBER_SOR




class pnfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfile,self).__init__(**dict)
        if self.__class__ is pnfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfile,kwargs)
        if len(args):
            dict2={ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class PathIndexEntry(BaseProtogenClass):
    __fields=['pathname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexEntry,self).__init__(**dict)
        if self.__class__ is PathIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pathname=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)




class PathIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexFile,self).__init__(**dict)
        if self.__class__ is PathIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class RecordIdEntry(BaseProtogenClass):
    __fields=['idnum']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RecordIdEntry,self).__init__(**dict)
        if self.__class__ is RecordIdEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RecordIdEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RecordIdEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 4}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_idnum=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_idnum.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_idnum=UINT(**{'sizeinbytes': 4})
        self.__field_idnum.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_idnum(self):
        return self.__field_idnum.getvalue()

    def __setfield_idnum(self, value):
        if isinstance(value,UINT):
            self.__field_idnum=value
        else:
            self.__field_idnum=UINT(value,**{'sizeinbytes': 4})

    def __delfield_idnum(self): del self.__field_idnum

    idnum=property(__getfield_idnum, __setfield_idnum, __delfield_idnum, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('idnum', self.__field_idnum, None)




class iceentry(BaseProtogenClass):
    "ICE index entries"
    __fields=['entry_assigned', 'entry_number', 'pb_index', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(iceentry,self).__init__(**dict)
        if self.__class__ is iceentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(iceentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(iceentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_assigned
        except:
            self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        self.__field_entry_assigned.writetobuffer(buf)
        try: self.__field_entry_number
        except:
            self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xFFFF })
        self.__field_entry_number.writetobuffer(buf)
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        self.__field_pb_index.writetobuffer(buf)
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        self.__field_entry_assigned.readfrombuffer(buf)
        self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xFFFF })
        self.__field_entry_number.readfrombuffer(buf)
        self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        self.__field_pb_index.readfrombuffer(buf)
        self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_assigned(self):
        try: self.__field_entry_assigned
        except:
            self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        return self.__field_entry_assigned.getvalue()

    def __setfield_entry_assigned(self, value):
        if isinstance(value,UINT):
            self.__field_entry_assigned=value
        else:
            self.__field_entry_assigned=UINT(value,**{'sizeinbytes': 2,  'default': 0x0000 })

    def __delfield_entry_assigned(self): del self.__field_entry_assigned

    entry_assigned=property(__getfield_entry_assigned, __setfield_entry_assigned, __delfield_entry_assigned, "0 if not assigned, 1 if assigned")

    def __getfield_entry_number(self):
        try: self.__field_entry_number
        except:
            self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xFFFF })
        return self.__field_entry_number.getvalue()

    def __setfield_entry_number(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number=value
        else:
            self.__field_entry_number=UINT(value,**{'sizeinbytes': 2,  'default': 0xFFFF })

    def __delfield_entry_number(self): del self.__field_entry_number

    entry_number=property(__getfield_entry_number, __setfield_entry_number, __delfield_entry_number, "0-based ICE entry number when assigned, 0xffff if unassigned")

    def __getfield_pb_index(self):
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0x0000 })
        return self.__field_pb_index.getvalue()

    def __setfield_pb_index(self, value):
        if isinstance(value,UINT):
            self.__field_pb_index=value
        else:
            self.__field_pb_index=UINT(value,**{'sizeinbytes': 2,  'default': 0x0000 })

    def __delfield_pb_index(self): del self.__field_pb_index

    pb_index=property(__getfield_pb_index, __setfield_pb_index, __delfield_pb_index, "0-based phone book entry number")

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 82,  'default': '\x00'*82 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_assigned', self.__field_entry_assigned, "0 if not assigned, 1 if assigned")
        yield ('entry_number', self.__field_entry_number, "0-based ICE entry number when assigned, 0xffff if unassigned")
        yield ('pb_index', self.__field_pb_index, "0-based phone book entry number")
        yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        return self.entry_assigned==1 and \
               self.entry_number<NUMEMERGENCYCONTACTS and \
               self.pb_index<NUMPHONEBOOKENTRIES




class iceentryfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(iceentryfile,self).__init__(**dict)
        if self.__class__ is iceentryfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(iceentryfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(iceentryfile,kwargs)
        if len(args):
            dict2={ 'elementclass': iceentry,             'createdefault': True,             'length': NUMEMERGENCYCONTACTS }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': iceentry,             'createdefault': True,             'length': NUMEMERGENCYCONTACTS })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': iceentry,             'createdefault': True,             'length': NUMEMERGENCYCONTACTS })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': iceentry,             'createdefault': True,             'length': NUMEMERGENCYCONTACTS })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': iceentry,             'createdefault': True,             'length': NUMEMERGENCYCONTACTS })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class scheduleevent(BaseProtogenClass):
    __fields=['packet_size', 'pos', 'description', 'cdate', 'mdate', 'start', 'end_time', 'end_date', 'repeat', 'alarmindex_vibrate', 'ringtone', 'unknown1', 'alarmminutes', 'alarmhours', 'unknown2', 'unknown3', 'unknown4', 'serial_number', 'blanks']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(scheduleevent,self).__init__(**dict)
        if self.__class__ is scheduleevent:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(scheduleevent,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(scheduleevent,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_packet_size
        except:
            self.__field_packet_size=UINT(**{ 'constant': 138 })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pos
        except:
            self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0xffffffff })
        self.__field_pos.writetobuffer(buf)
        if self.pos!=0xffffffff:
            try: self.__field_description
            except:
                self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_description.writetobuffer(buf)
            try: self.__field_cdate
            except:
                self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
            self.__field_cdate.writetobuffer(buf)
            try: self.__field_mdate
            except:
                self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
            self.__field_mdate.writetobuffer(buf)
            try: self.__field_start
            except:
                self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_start.writetobuffer(buf)
            try: self.__field_end_time
            except:
                self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_end_time.writetobuffer(buf)
            try: self.__field_end_date
            except:
                self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_end_date.writetobuffer(buf)
            try: self.__field_repeat
            except:
                self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_repeat.writetobuffer(buf)
            try: self.__field_alarmindex_vibrate
            except:
                self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_alarmindex_vibrate.writetobuffer(buf)
            try: self.__field_ringtone
            except:
                self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_ringtone.writetobuffer(buf)
            try: self.__field_unknown1
            except:
                self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown1.writetobuffer(buf)
            try: self.__field_alarmminutes
            except:
                self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_alarmminutes.writetobuffer(buf)
            try: self.__field_alarmhours
            except:
                self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_alarmhours.writetobuffer(buf)
            try: self.__field_unknown2
            except:
                self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown2.writetobuffer(buf)
            try: self.__field_unknown3
            except:
                self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FC })
            self.__field_unknown3.writetobuffer(buf)
            try: self.__field_unknown4
            except:
                self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
            self.__field_unknown4.writetobuffer(buf)
            try: self.__field_serial_number
            except:
                self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000d1-00000000-0000000000-VX910V03',                     'encoding': PHONE_ENCODING,                     'raiseonunterminatedread': False,                     'raiseontruncate': False })
            self.__field_serial_number.writetobuffer(buf)
        else:
            try: self.__field_blanks
            except:
                self.__field_blanks=STRING(**{'sizeinbytes': 134,  'default': '',                     'terminator': 0xff,                     'pad': 0xff })
            self.__field_blanks.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0xffffffff })
        self.__field_pos.readfrombuffer(buf)
        if self.pos!=0xffffffff:
            self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_description.readfrombuffer(buf)
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
            self.__field_cdate.readfrombuffer(buf)
            self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
            self.__field_mdate.readfrombuffer(buf)
            self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_start.readfrombuffer(buf)
            self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_end_time.readfrombuffer(buf)
            self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_end_date.readfrombuffer(buf)
            self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
            self.__field_repeat.readfrombuffer(buf)
            self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_alarmindex_vibrate.readfrombuffer(buf)
            self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_ringtone.readfrombuffer(buf)
            self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown1.readfrombuffer(buf)
            self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_alarmminutes.readfrombuffer(buf)
            self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_alarmhours.readfrombuffer(buf)
            self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown2.readfrombuffer(buf)
            self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FC })
            self.__field_unknown3.readfrombuffer(buf)
            self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
            self.__field_unknown4.readfrombuffer(buf)
            self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000d1-00000000-0000000000-VX910V03',                     'encoding': PHONE_ENCODING,                     'raiseonunterminatedread': False,                     'raiseontruncate': False })
            self.__field_serial_number.readfrombuffer(buf)
        else:
            self.__field_blanks=STRING(**{'sizeinbytes': 134,  'default': '',                     'terminator': 0xff,                     'pad': 0xff })
            self.__field_blanks.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_packet_size(self):
        return self.__field_packet_size.getvalue()

    def __setfield_packet_size(self, value):
        if isinstance(value,UINT):
            self.__field_packet_size=value
        else:
            self.__field_packet_size=UINT(value,**{ 'constant': 138 })

    def __delfield_packet_size(self): del self.__field_packet_size

    packet_size=property(__getfield_packet_size, __setfield_packet_size, __delfield_packet_size, None)

    def __getfield_pos(self):
        try: self.__field_pos
        except:
            self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0xffffffff })
        return self.__field_pos.getvalue()

    def __setfield_pos(self, value):
        if isinstance(value,UINT):
            self.__field_pos=value
        else:
            self.__field_pos=UINT(value,**{'sizeinbytes': 4,  'default': 0xffffffff })

    def __delfield_pos(self): del self.__field_pos

    pos=property(__getfield_pos, __setfield_pos, __delfield_pos, "position within file, used as an event id")

    def __getfield_description(self):
        try: self.__field_description
        except:
            self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_description.getvalue()

    def __setfield_description(self, value):
        if isinstance(value,USTRING):
            self.__field_description=value
        else:
            self.__field_description=USTRING(value,**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_description(self): del self.__field_description

    description=property(__getfield_description, __setfield_description, __delfield_description, None)

    def __getfield_cdate(self):
        try: self.__field_cdate
        except:
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        return self.__field_cdate.getvalue()

    def __setfield_cdate(self, value):
        if isinstance(value,GPSDATE):
            self.__field_cdate=value
        else:
            self.__field_cdate=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now() })

    def __delfield_cdate(self): del self.__field_cdate

    cdate=property(__getfield_cdate, __setfield_cdate, __delfield_cdate, None)

    def __getfield_mdate(self):
        try: self.__field_mdate
        except:
            self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        return self.__field_mdate.getvalue()

    def __setfield_mdate(self, value):
        if isinstance(value,GPSDATE):
            self.__field_mdate=value
        else:
            self.__field_mdate=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now() })

    def __delfield_mdate(self): del self.__field_mdate

    mdate=property(__getfield_mdate, __setfield_mdate, __delfield_mdate, None)

    def __getfield_start(self):
        try: self.__field_start
        except:
            self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_start=value
        else:
            self.__field_start=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, None)

    def __getfield_end_time(self):
        try: self.__field_end_time
        except:
            self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_end_time.getvalue()

    def __setfield_end_time(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_end_time=value
        else:
            self.__field_end_time=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_end_time(self): del self.__field_end_time

    end_time=property(__getfield_end_time, __setfield_end_time, __delfield_end_time, None)

    def __getfield_end_date(self):
        try: self.__field_end_date
        except:
            self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_end_date.getvalue()

    def __setfield_end_date(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_end_date=value
        else:
            self.__field_end_date=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_end_date(self): del self.__field_end_date

    end_date=property(__getfield_end_date, __setfield_end_date, __delfield_end_date, None)

    def __getfield_repeat(self):
        try: self.__field_repeat
        except:
            self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_repeat.getvalue()

    def __setfield_repeat(self, value):
        if isinstance(value,LGCALREPEAT):
            self.__field_repeat=value
        else:
            self.__field_repeat=LGCALREPEAT(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_repeat(self): del self.__field_repeat

    repeat=property(__getfield_repeat, __setfield_repeat, __delfield_repeat, None)

    def __getfield_alarmindex_vibrate(self):
        try: self.__field_alarmindex_vibrate
        except:
            self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_alarmindex_vibrate.getvalue()

    def __setfield_alarmindex_vibrate(self, value):
        if isinstance(value,UINT):
            self.__field_alarmindex_vibrate=value
        else:
            self.__field_alarmindex_vibrate=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_alarmindex_vibrate(self): del self.__field_alarmindex_vibrate

    alarmindex_vibrate=property(__getfield_alarmindex_vibrate, __setfield_alarmindex_vibrate, __delfield_alarmindex_vibrate, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_unknown1(self):
        try: self.__field_unknown1
        except:
            self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UINT):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_alarmminutes(self):
        try: self.__field_alarmminutes
        except:
            self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_alarmminutes.getvalue()

    def __setfield_alarmminutes(self, value):
        if isinstance(value,UINT):
            self.__field_alarmminutes=value
        else:
            self.__field_alarmminutes=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_alarmminutes(self): del self.__field_alarmminutes

    alarmminutes=property(__getfield_alarmminutes, __setfield_alarmminutes, __delfield_alarmminutes, "a value of 0xFF indicates not set")

    def __getfield_alarmhours(self):
        try: self.__field_alarmhours
        except:
            self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_alarmhours.getvalue()

    def __setfield_alarmhours(self, value):
        if isinstance(value,UINT):
            self.__field_alarmhours=value
        else:
            self.__field_alarmhours=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_alarmhours(self): del self.__field_alarmhours

    alarmhours=property(__getfield_alarmhours, __setfield_alarmhours, __delfield_alarmhours, "a value of 0xFF indicates not set")

    def __getfield_unknown2(self):
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_unknown3(self):
        try: self.__field_unknown3
        except:
            self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FC })
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,UINT):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=UINT(value,**{'sizeinbytes': 2,  'default': 0x01FC })

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def __getfield_unknown4(self):
        try: self.__field_unknown4
        except:
            self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_unknown4.getvalue()

    def __setfield_unknown4(self, value):
        if isinstance(value,UINT):
            self.__field_unknown4=value
        else:
            self.__field_unknown4=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_unknown4(self): del self.__field_unknown4

    unknown4=property(__getfield_unknown4, __setfield_unknown4, __delfield_unknown4, None)

    def __getfield_serial_number(self):
        try: self.__field_serial_number
        except:
            self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000d1-00000000-0000000000-VX910V03',                     'encoding': PHONE_ENCODING,                     'raiseonunterminatedread': False,                     'raiseontruncate': False })
        return self.__field_serial_number.getvalue()

    def __setfield_serial_number(self, value):
        if isinstance(value,USTRING):
            self.__field_serial_number=value
        else:
            self.__field_serial_number=USTRING(value,**{'sizeinbytes': 65,  'default': '000000d1-00000000-0000000000-VX910V03',                     'encoding': PHONE_ENCODING,                     'raiseonunterminatedread': False,                     'raiseontruncate': False })

    def __delfield_serial_number(self): del self.__field_serial_number

    serial_number=property(__getfield_serial_number, __setfield_serial_number, __delfield_serial_number, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=STRING(**{'sizeinbytes': 134,  'default': '',                     'terminator': 0xff,                     'pad': 0xff })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,STRING):
            self.__field_blanks=value
        else:
            self.__field_blanks=STRING(value,**{'sizeinbytes': 134,  'default': '',                     'terminator': 0xff,                     'pad': 0xff })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('packet_size', self.__field_packet_size, None)
        yield ('pos', self.__field_pos, "position within file, used as an event id")
        if self.pos!=0xffffffff:
            yield ('description', self.__field_description, None)
            yield ('cdate', self.__field_cdate, None)
            yield ('mdate', self.__field_mdate, None)
            yield ('start', self.__field_start, None)
            yield ('end_time', self.__field_end_time, None)
            yield ('end_date', self.__field_end_date, None)
            yield ('repeat', self.__field_repeat, None)
            yield ('alarmindex_vibrate', self.__field_alarmindex_vibrate, None)
            yield ('ringtone', self.__field_ringtone, None)
            yield ('unknown1', self.__field_unknown1, None)
            yield ('alarmminutes', self.__field_alarmminutes, "a value of 0xFF indicates not set")
            yield ('alarmhours', self.__field_alarmhours, "a value of 0xFF indicates not set")
            yield ('unknown2', self.__field_unknown2, None)
            yield ('unknown3', self.__field_unknown3, None)
            yield ('unknown4', self.__field_unknown4, None)
            yield ('serial_number', self.__field_serial_number, None)
        else:
            yield ('blanks', self.__field_blanks, None)




class schedulefile(BaseProtogenClass):
    __fields=['numactiveitems', 'events']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(schedulefile,self).__init__(**dict)
        if self.__class__ is schedulefile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(schedulefile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(schedulefile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numactiveitems.writetobuffer(buf)
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': scheduleevent,             'length': NUMCALENDARENTRIES,             'createdefault': True })
        self.__field_events.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numactiveitems=UINT(**{'sizeinbytes': 2})
        self.__field_numactiveitems.readfrombuffer(buf)
        self.__field_events=LIST(**{ 'elementclass': scheduleevent,             'length': NUMCALENDARENTRIES,             'createdefault': True })
        self.__field_events.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numactiveitems(self):
        return self.__field_numactiveitems.getvalue()

    def __setfield_numactiveitems(self, value):
        if isinstance(value,UINT):
            self.__field_numactiveitems=value
        else:
            self.__field_numactiveitems=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numactiveitems(self): del self.__field_numactiveitems

    numactiveitems=property(__getfield_numactiveitems, __setfield_numactiveitems, __delfield_numactiveitems, None)

    def __getfield_events(self):
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': scheduleevent,             'length': NUMCALENDARENTRIES,             'createdefault': True })
        return self.__field_events.getvalue()

    def __setfield_events(self, value):
        if isinstance(value,LIST):
            self.__field_events=value
        else:
            self.__field_events=LIST(value,**{ 'elementclass': scheduleevent,             'length': NUMCALENDARENTRIES,             'createdefault': True })

    def __delfield_events(self): del self.__field_events

    events=property(__getfield_events, __setfield_events, __delfield_events, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numactiveitems', self.__field_numactiveitems, None)
        yield ('events', self.__field_events, None)




class scheduleringerfile(BaseProtogenClass):
    __fields=['numringers', 'ringerpaths']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(scheduleringerfile,self).__init__(**dict)
        if self.__class__ is scheduleringerfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(scheduleringerfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(scheduleringerfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numringers.writetobuffer(buf)
        try: self.__field_ringerpaths
        except:
            self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx9100_265})
        self.__field_ringerpaths.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numringers=UINT(**{'sizeinbytes': 4})
        self.__field_numringers.readfrombuffer(buf)
        self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx9100_265})
        self.__field_ringerpaths.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numringers(self):
        return self.__field_numringers.getvalue()

    def __setfield_numringers(self, value):
        if isinstance(value,UINT):
            self.__field_numringers=value
        else:
            self.__field_numringers=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numringers(self): del self.__field_numringers

    numringers=property(__getfield_numringers, __setfield_numringers, __delfield_numringers, None)

    def __getfield_ringerpaths(self):
        try: self.__field_ringerpaths
        except:
            self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx9100_265})
        return self.__field_ringerpaths.getvalue()

    def __setfield_ringerpaths(self, value):
        if isinstance(value,LIST):
            self.__field_ringerpaths=value
        else:
            self.__field_ringerpaths=LIST(value,**{'elementclass': _gen_p_lgvx9100_265})

    def __delfield_ringerpaths(self): del self.__field_ringerpaths

    ringerpaths=property(__getfield_ringerpaths, __setfield_ringerpaths, __delfield_ringerpaths, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numringers', self.__field_numringers, None)
        yield ('ringerpaths', self.__field_ringerpaths, None)




class _gen_p_lgvx9100_265(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['path']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_265,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_265:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_265,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_265,kwargs)
        if len(args):
            dict2={'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_path=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_path.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_path=USTRING(**{'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True })
        self.__field_path.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_path(self):
        return self.__field_path.getvalue()

    def __setfield_path(self, value):
        if isinstance(value,USTRING):
            self.__field_path=value
        else:
            self.__field_path=USTRING(value,**{'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True })

    def __delfield_path(self): del self.__field_path

    path=property(__getfield_path, __setfield_path, __delfield_path, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('path', self.__field_path, None)




class msg_record(BaseProtogenClass):
    __fields=['lastone', 'msglen', 'binary', 'unknown3', 'unknown4', 'unknown6', 'length', 'msg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(msg_record,self).__init__(**dict)
        if self.__class__ is msg_record:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(msg_record,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(msg_record,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_lastone
        except:
            self.__field_lastone=BOOL(**{ 'default': False })
        try: self.__field_msglen
        except:
            self.__field_msglen=UINT(**{ 'default': 220 if self.lastone else 223 })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_binary.writetobuffer(buf)
        self.__field_unknown3.writetobuffer(buf)
        self.__field_unknown4.writetobuffer(buf)
        self.__field_unknown6.writetobuffer(buf)
        self.__field_length.writetobuffer(buf)
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_280, 'length': self.msglen })
        self.__field_msg.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_binary=UINT(**{'sizeinbytes': 1})
        self.__field_binary.readfrombuffer(buf)
        self.__field_unknown3=UINT(**{'sizeinbytes': 1})
        self.__field_unknown3.readfrombuffer(buf)
        self.__field_unknown4=UINT(**{'sizeinbytes': 1})
        self.__field_unknown4.readfrombuffer(buf)
        self.__field_unknown6=UINT(**{'sizeinbytes': 1})
        self.__field_unknown6.readfrombuffer(buf)
        self.__field_length=UINT(**{'sizeinbytes': 1})
        self.__field_length.readfrombuffer(buf)
        self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_280, 'length': self.msglen })
        self.__field_msg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_lastone(self):
        try: self.__field_lastone
        except:
            self.__field_lastone=BOOL(**{ 'default': False })
        return self.__field_lastone.getvalue()

    def __setfield_lastone(self, value):
        if isinstance(value,BOOL):
            self.__field_lastone=value
        else:
            self.__field_lastone=BOOL(value,**{ 'default': False })

    def __delfield_lastone(self): del self.__field_lastone

    lastone=property(__getfield_lastone, __setfield_lastone, __delfield_lastone, None)

    def __getfield_msglen(self):
        try: self.__field_msglen
        except:
            self.__field_msglen=UINT(**{ 'default': 220 if self.lastone else 223 })
        return self.__field_msglen.getvalue()

    def __setfield_msglen(self, value):
        if isinstance(value,UINT):
            self.__field_msglen=value
        else:
            self.__field_msglen=UINT(value,**{ 'default': 220 if self.lastone else 223 })

    def __delfield_msglen(self): del self.__field_msglen

    msglen=property(__getfield_msglen, __setfield_msglen, __delfield_msglen, None)

    def __getfield_binary(self):
        return self.__field_binary.getvalue()

    def __setfield_binary(self, value):
        if isinstance(value,UINT):
            self.__field_binary=value
        else:
            self.__field_binary=UINT(value,**{'sizeinbytes': 1})

    def __delfield_binary(self): del self.__field_binary

    binary=property(__getfield_binary, __setfield_binary, __delfield_binary, None)

    def __getfield_unknown3(self):
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,UINT):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def __getfield_unknown4(self):
        return self.__field_unknown4.getvalue()

    def __setfield_unknown4(self, value):
        if isinstance(value,UINT):
            self.__field_unknown4=value
        else:
            self.__field_unknown4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown4(self): del self.__field_unknown4

    unknown4=property(__getfield_unknown4, __setfield_unknown4, __delfield_unknown4, None)

    def __getfield_unknown6(self):
        return self.__field_unknown6.getvalue()

    def __setfield_unknown6(self, value):
        if isinstance(value,UINT):
            self.__field_unknown6=value
        else:
            self.__field_unknown6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown6(self): del self.__field_unknown6

    unknown6=property(__getfield_unknown6, __setfield_unknown6, __delfield_unknown6, None)

    def __getfield_length(self):
        return self.__field_length.getvalue()

    def __setfield_length(self, value):
        if isinstance(value,UINT):
            self.__field_length=value
        else:
            self.__field_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_length(self): del self.__field_length

    length=property(__getfield_length, __setfield_length, __delfield_length, None)

    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_280, 'length': self.msglen })
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,LIST):
            self.__field_msg=value
        else:
            self.__field_msg=LIST(value,**{'elementclass': _gen_p_lgvx9100_280, 'length': self.msglen })

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('lastone', self.__field_lastone, None)
        yield ('msglen', self.__field_msglen, None)
        yield ('binary', self.__field_binary, None)
        yield ('unknown3', self.__field_unknown3, None)
        yield ('unknown4', self.__field_unknown4, None)
        yield ('unknown6', self.__field_unknown6, None)
        yield ('length', self.__field_length, None)
        yield ('msg', self.__field_msg, None)




class _gen_p_lgvx9100_280(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['byte']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_280,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_280:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_280,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_280,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_byte=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_byte.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_byte=UINT(**{'sizeinbytes': 1})
        self.__field_byte.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_byte(self):
        return self.__field_byte.getvalue()

    def __setfield_byte(self, value):
        if isinstance(value,UINT):
            self.__field_byte=value
        else:
            self.__field_byte=UINT(value,**{'sizeinbytes': 1})

    def __delfield_byte(self): del self.__field_byte

    byte=property(__getfield_byte, __setfield_byte, __delfield_byte, "individual byte of message")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('byte', self.__field_byte, "individual byte of message")




class recipient_record(BaseProtogenClass):
    __fields=['lastone', 'unknown1', 'number', 'numberlen', 'status', 'dunno1', 'timesent', 'timereceived', 'unknown2', 'unknown3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(recipient_record,self).__init__(**dict)
        if self.__class__ is recipient_record:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(recipient_record,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(recipient_record,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_lastone
        except:
            self.__field_lastone=BOOL(**{ 'default': False })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown1.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_numberlen.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_timereceived.writetobuffer(buf)
        self.__field_unknown2.writetobuffer(buf)
        self.__field_unknown3.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown1=DATA(**{'sizeinbytes': 33})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_number=USTRING(**{'sizeinbytes': 49})
        self.__field_number.readfrombuffer(buf)
        self.__field_numberlen=UINT(**{'sizeinbytes': 1})
        self.__field_numberlen.readfrombuffer(buf)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 8})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_timesent=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_timereceived=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_timereceived.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 1})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_unknown3=DATA(**{ 'sizeinbytes': 142 if self.lastone else 147 })
        self.__field_unknown3.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_lastone(self):
        try: self.__field_lastone
        except:
            self.__field_lastone=BOOL(**{ 'default': False })
        return self.__field_lastone.getvalue()

    def __setfield_lastone(self, value):
        if isinstance(value,BOOL):
            self.__field_lastone=value
        else:
            self.__field_lastone=BOOL(value,**{ 'default': False })

    def __delfield_lastone(self): del self.__field_lastone

    lastone=property(__getfield_lastone, __setfield_lastone, __delfield_lastone, None)

    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,DATA):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=DATA(value,**{'sizeinbytes': 33})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,USTRING):
            self.__field_number=value
        else:
            self.__field_number=USTRING(value,**{'sizeinbytes': 49})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_numberlen(self):
        return self.__field_numberlen.getvalue()

    def __setfield_numberlen(self, value):
        if isinstance(value,UINT):
            self.__field_numberlen=value
        else:
            self.__field_numberlen=UINT(value,**{'sizeinbytes': 1})

    def __delfield_numberlen(self): del self.__field_numberlen

    numberlen=property(__getfield_numberlen, __setfield_numberlen, __delfield_numberlen, "length of the number")

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 8})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_timereceived(self):
        return self.__field_timereceived.getvalue()

    def __setfield_timereceived(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_timereceived=value
        else:
            self.__field_timereceived=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_timereceived(self): del self.__field_timereceived

    timereceived=property(__getfield_timereceived, __setfield_timereceived, __delfield_timereceived, None)

    def __getfield_unknown2(self):
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_unknown3(self):
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,DATA):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=DATA(value,**{ 'sizeinbytes': 142 if self.lastone else 147 })

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('lastone', self.__field_lastone, None)
        yield ('unknown1', self.__field_unknown1, None)
        yield ('number', self.__field_number, None)
        yield ('numberlen', self.__field_numberlen, "length of the number")
        yield ('status', self.__field_status, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('timereceived', self.__field_timereceived, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('unknown3', self.__field_unknown3, None)




class sms_saved(BaseProtogenClass):
    __fields=['outboxmsg', 'GPStime', 'outbox']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_saved,self).__init__(**dict)
        if self.__class__ is sms_saved:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_saved,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_saved,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_outboxmsg
        except:
            self.__field_outboxmsg=BOOL(**{ 'default': True })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_GPStime.writetobuffer(buf)
        self.__field_outbox.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_outbox=sms_out()
        self.__field_outbox.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_outboxmsg(self):
        try: self.__field_outboxmsg
        except:
            self.__field_outboxmsg=BOOL(**{ 'default': True })
        return self.__field_outboxmsg.getvalue()

    def __setfield_outboxmsg(self, value):
        if isinstance(value,BOOL):
            self.__field_outboxmsg=value
        else:
            self.__field_outboxmsg=BOOL(value,**{ 'default': True })

    def __delfield_outboxmsg(self): del self.__field_outboxmsg

    outboxmsg=property(__getfield_outboxmsg, __setfield_outboxmsg, __delfield_outboxmsg, None)

    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_outbox(self):
        return self.__field_outbox.getvalue()

    def __setfield_outbox(self, value):
        if isinstance(value,sms_out):
            self.__field_outbox=value
        else:
            self.__field_outbox=sms_out(value,)

    def __delfield_outbox(self): del self.__field_outbox

    outbox=property(__getfield_outbox, __setfield_outbox, __delfield_outbox, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('outboxmsg', self.__field_outboxmsg, None)
        yield ('GPStime', self.__field_GPStime, None)
        yield ('outbox', self.__field_outbox, None)




class sms_out(BaseProtogenClass):
    __fields=['unk0', 'index', 'locked', 'unk1', 'timestamp', 'timesent', 'subject', 'num_msg_elements', 'priority', 'unk2', 'callback', 'rcps', 'rcplast', 'msgs', 'msglast', 'pad1']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_out,self).__init__(**dict)
        if self.__class__ is sms_out:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_out,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_out,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unk0.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_locked.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        self.__field_timestamp.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_subject.writetobuffer(buf)
        self.__field_num_msg_elements.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        self.__field_unk2.writetobuffer(buf)
        self.__field_callback.writetobuffer(buf)
        try: self.__field_rcps
        except:
            self.__field_rcps=LIST(**{ 'elementclass': recipient_record,'length': 9 })
        self.__field_rcps.writetobuffer(buf)
        try: self.__field_rcplast
        except:
            self.__field_rcplast=recipient_record(**{ 'lastone': True })
        self.__field_rcplast.writetobuffer(buf)
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': msg_record, 'length': 6})
        self.__field_msgs.writetobuffer(buf)
        try: self.__field_msglast
        except:
            self.__field_msglast=msg_record(**{ 'lastone': True })
        self.__field_msglast.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unk0=UINT(**{'sizeinbytes': 4})
        self.__field_unk0.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 4})
        self.__field_index.readfrombuffer(buf)
        self.__field_locked=UINT(**{'sizeinbytes': 1})
        self.__field_locked.readfrombuffer(buf)
        self.__field_unk1=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_timestamp=GPSDATE(**{'sizeinbytes': 4})
        self.__field_timestamp.readfrombuffer(buf)
        self.__field_timesent=GPSDATE(**{'sizeinbytes': 4})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_subject=USTRING(**{'sizeinbytes': 61, 'encoding': PHONE_ENCODING})
        self.__field_subject.readfrombuffer(buf)
        self.__field_num_msg_elements=UINT(**{'sizeinbytes': 2})
        self.__field_num_msg_elements.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 2})
        self.__field_priority.readfrombuffer(buf)
        self.__field_unk2=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_unk2.readfrombuffer(buf)
        self.__field_callback=USTRING(**{'sizeinbytes': 29})
        self.__field_callback.readfrombuffer(buf)
        self.__field_rcps=LIST(**{ 'elementclass': recipient_record,'length': 9 })
        self.__field_rcps.readfrombuffer(buf)
        self.__field_rcplast=recipient_record(**{ 'lastone': True })
        self.__field_rcplast.readfrombuffer(buf)
        self.__field_msgs=LIST(**{'elementclass': msg_record, 'length': 6})
        self.__field_msgs.readfrombuffer(buf)
        self.__field_msglast=msg_record(**{ 'lastone': True })
        self.__field_msglast.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN()
        self.__field_pad1.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unk0(self):
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 4})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_locked(self):
        return self.__field_locked.getvalue()

    def __setfield_locked(self, value):
        if isinstance(value,UINT):
            self.__field_locked=value
        else:
            self.__field_locked=UINT(value,**{'sizeinbytes': 1})

    def __delfield_locked(self): del self.__field_locked

    locked=property(__getfield_locked, __setfield_locked, __delfield_locked, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unk1=value
        else:
            self.__field_unk1=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_timestamp(self):
        return self.__field_timestamp.getvalue()

    def __setfield_timestamp(self, value):
        if isinstance(value,GPSDATE):
            self.__field_timestamp=value
        else:
            self.__field_timestamp=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_timestamp(self): del self.__field_timestamp

    timestamp=property(__getfield_timestamp, __setfield_timestamp, __delfield_timestamp, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,GPSDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_subject(self):
        return self.__field_subject.getvalue()

    def __setfield_subject(self, value):
        if isinstance(value,USTRING):
            self.__field_subject=value
        else:
            self.__field_subject=USTRING(value,**{'sizeinbytes': 61, 'encoding': PHONE_ENCODING})

    def __delfield_subject(self): del self.__field_subject

    subject=property(__getfield_subject, __setfield_subject, __delfield_subject, None)

    def __getfield_num_msg_elements(self):
        return self.__field_num_msg_elements.getvalue()

    def __setfield_num_msg_elements(self, value):
        if isinstance(value,UINT):
            self.__field_num_msg_elements=value
        else:
            self.__field_num_msg_elements=UINT(value,**{'sizeinbytes': 2})

    def __delfield_num_msg_elements(self): del self.__field_num_msg_elements

    num_msg_elements=property(__getfield_num_msg_elements, __setfield_num_msg_elements, __delfield_num_msg_elements, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 2})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_unk2(self):
        return self.__field_unk2.getvalue()

    def __setfield_unk2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unk2=value
        else:
            self.__field_unk2=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_unk2(self): del self.__field_unk2

    unk2=property(__getfield_unk2, __setfield_unk2, __delfield_unk2, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,USTRING):
            self.__field_callback=value
        else:
            self.__field_callback=USTRING(value,**{'sizeinbytes': 29})

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_rcps(self):
        try: self.__field_rcps
        except:
            self.__field_rcps=LIST(**{ 'elementclass': recipient_record,'length': 9 })
        return self.__field_rcps.getvalue()

    def __setfield_rcps(self, value):
        if isinstance(value,LIST):
            self.__field_rcps=value
        else:
            self.__field_rcps=LIST(value,**{ 'elementclass': recipient_record,'length': 9 })

    def __delfield_rcps(self): del self.__field_rcps

    rcps=property(__getfield_rcps, __setfield_rcps, __delfield_rcps, None)

    def __getfield_rcplast(self):
        try: self.__field_rcplast
        except:
            self.__field_rcplast=recipient_record(**{ 'lastone': True })
        return self.__field_rcplast.getvalue()

    def __setfield_rcplast(self, value):
        if isinstance(value,recipient_record):
            self.__field_rcplast=value
        else:
            self.__field_rcplast=recipient_record(value,**{ 'lastone': True })

    def __delfield_rcplast(self): del self.__field_rcplast

    rcplast=property(__getfield_rcplast, __setfield_rcplast, __delfield_rcplast, None)

    def __getfield_msgs(self):
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': msg_record, 'length': 6})
        return self.__field_msgs.getvalue()

    def __setfield_msgs(self, value):
        if isinstance(value,LIST):
            self.__field_msgs=value
        else:
            self.__field_msgs=LIST(value,**{'elementclass': msg_record, 'length': 6})

    def __delfield_msgs(self): del self.__field_msgs

    msgs=property(__getfield_msgs, __setfield_msgs, __delfield_msgs, None)

    def __getfield_msglast(self):
        try: self.__field_msglast
        except:
            self.__field_msglast=msg_record(**{ 'lastone': True })
        return self.__field_msglast.getvalue()

    def __setfield_msglast(self, value):
        if isinstance(value,msg_record):
            self.__field_msglast=value
        else:
            self.__field_msglast=msg_record(value,**{ 'lastone': True })

    def __delfield_msglast(self): del self.__field_msglast

    msglast=property(__getfield_msglast, __setfield_msglast, __delfield_msglast, None)

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,)

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unk0', self.__field_unk0, None)
        yield ('index', self.__field_index, None)
        yield ('locked', self.__field_locked, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('timestamp', self.__field_timestamp, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('subject', self.__field_subject, None)
        yield ('num_msg_elements', self.__field_num_msg_elements, None)
        yield ('priority', self.__field_priority, None)
        yield ('unk2', self.__field_unk2, None)
        yield ('callback', self.__field_callback, None)
        yield ('rcps', self.__field_rcps, None)
        yield ('rcplast', self.__field_rcplast, None)
        yield ('msgs', self.__field_msgs, None)
        yield ('msglast', self.__field_msglast, None)
        yield ('pad1', self.__field_pad1, None)

    _msg=None
    def _get_msg(self):
        if self._msg is None:
            self._msg=[x for x in self.msgs]+[self.msglast]
        return self._msg
    messages=property(fget=_get_msg)
    _rcp=None
    def _get_recipients(self):
        if self._rcp is None:
            self._rcp=[x for x in self.rcps]+[self.rcplast]
        return self._rcp
    recipients=property(fget=_get_recipients)




class SMSINBOXMSGFRAGMENT(BaseProtogenClass):
    __fields=['msg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(SMSINBOXMSGFRAGMENT,self).__init__(**dict)
        if self.__class__ is SMSINBOXMSGFRAGMENT:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(SMSINBOXMSGFRAGMENT,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(SMSINBOXMSGFRAGMENT,kwargs)
        if len(args):
            dict2={'elementclass': _gen_p_lgvx9100_333,  'length': 222 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_msg=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_333,  'length': 222 })
        self.__field_msg.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_333,  'length': 222 })
        self.__field_msg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx9100_333,  'length': 222 })
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,LIST):
            self.__field_msg=value
        else:
            self.__field_msg=LIST(value,**{'elementclass': _gen_p_lgvx9100_333,  'length': 222 })

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg', self.__field_msg, None)




class _gen_p_lgvx9100_333(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['byte']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_333,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_333:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_333,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_333,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_byte=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_byte.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_byte=UINT(**{'sizeinbytes': 1})
        self.__field_byte.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_byte(self):
        return self.__field_byte.getvalue()

    def __setfield_byte(self, value):
        if isinstance(value,UINT):
            self.__field_byte=value
        else:
            self.__field_byte=UINT(value,**{'sizeinbytes': 1})

    def __delfield_byte(self): del self.__field_byte

    byte=property(__getfield_byte, __setfield_byte, __delfield_byte, "individual byte of message")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('byte', self.__field_byte, "individual byte of message")




class sms_in(BaseProtogenClass):
    __fields=['unk0', 'index', 'unk1', 'GPStime', 'timesent', 'unk2', 'gtimesent', 'read', 'locked', 'priority', 'dunno1', 'subject', 'msgs', 'sender', 'sender_length', 'unk3', 'sender_name', 'callback', 'callback_length']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_in,self).__init__(**dict)
        if self.__class__ is sms_in:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_in,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_in,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unk0.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        self.__field_GPStime.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_unk2.writetobuffer(buf)
        self.__field_gtimesent.writetobuffer(buf)
        self.__field_read.writetobuffer(buf)
        self.__field_locked.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_subject.writetobuffer(buf)
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx9100_350,  'length': 20 })
        self.__field_msgs.writetobuffer(buf)
        self.__field_sender.writetobuffer(buf)
        self.__field_sender_length.writetobuffer(buf)
        self.__field_unk3.writetobuffer(buf)
        self.__field_sender_name.writetobuffer(buf)
        self.__field_callback.writetobuffer(buf)
        self.__field_callback_length.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unk0=UINT(**{'sizeinbytes': 4})
        self.__field_unk0.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 4})
        self.__field_index.readfrombuffer(buf)
        self.__field_unk1=UINT(**{'sizeinbytes': 4})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_timesent=SMSDATE(**{'sizeinbytes': 6})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_unk2=UINT(**{'sizeinbytes': 2})
        self.__field_unk2.readfrombuffer(buf)
        self.__field_gtimesent=GPSDATE(**{'sizeinbytes': 4})
        self.__field_gtimesent.readfrombuffer(buf)
        self.__field_read=UINT(**{'sizeinbytes': 1})
        self.__field_read.readfrombuffer(buf)
        self.__field_locked=UINT(**{'sizeinbytes': 1})
        self.__field_locked.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 15})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_subject=USTRING(**{'sizeinbytes': 64, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False })
        self.__field_subject.readfrombuffer(buf)
        self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx9100_350,  'length': 20 })
        self.__field_msgs.readfrombuffer(buf)
        self.__field_sender=USTRING(**{'sizeinbytes': 49})
        self.__field_sender.readfrombuffer(buf)
        self.__field_sender_length=UINT(**{'sizeinbytes': 1})
        self.__field_sender_length.readfrombuffer(buf)
        self.__field_unk3=UINT(**{'sizeinbytes': 2})
        self.__field_unk3.readfrombuffer(buf)
        self.__field_sender_name=USTRING(**{'sizeinbytes': 33})
        self.__field_sender_name.readfrombuffer(buf)
        self.__field_callback=USTRING(**{'sizeinbytes': 49})
        self.__field_callback.readfrombuffer(buf)
        self.__field_callback_length=UINT(**{'sizeinbytes': 1})
        self.__field_callback_length.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unk0(self):
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 4})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UINT):
            self.__field_unk1=value
        else:
            self.__field_unk1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,SMSDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=SMSDATE(value,**{'sizeinbytes': 6})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_unk2(self):
        return self.__field_unk2.getvalue()

    def __setfield_unk2(self, value):
        if isinstance(value,UINT):
            self.__field_unk2=value
        else:
            self.__field_unk2=UINT(value,**{'sizeinbytes': 2})

    def __delfield_unk2(self): del self.__field_unk2

    unk2=property(__getfield_unk2, __setfield_unk2, __delfield_unk2, None)

    def __getfield_gtimesent(self):
        return self.__field_gtimesent.getvalue()

    def __setfield_gtimesent(self, value):
        if isinstance(value,GPSDATE):
            self.__field_gtimesent=value
        else:
            self.__field_gtimesent=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_gtimesent(self): del self.__field_gtimesent

    gtimesent=property(__getfield_gtimesent, __setfield_gtimesent, __delfield_gtimesent, None)

    def __getfield_read(self):
        return self.__field_read.getvalue()

    def __setfield_read(self, value):
        if isinstance(value,UINT):
            self.__field_read=value
        else:
            self.__field_read=UINT(value,**{'sizeinbytes': 1})

    def __delfield_read(self): del self.__field_read

    read=property(__getfield_read, __setfield_read, __delfield_read, None)

    def __getfield_locked(self):
        return self.__field_locked.getvalue()

    def __setfield_locked(self, value):
        if isinstance(value,UINT):
            self.__field_locked=value
        else:
            self.__field_locked=UINT(value,**{'sizeinbytes': 1})

    def __delfield_locked(self): del self.__field_locked

    locked=property(__getfield_locked, __setfield_locked, __delfield_locked, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 15})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_subject(self):
        return self.__field_subject.getvalue()

    def __setfield_subject(self, value):
        if isinstance(value,USTRING):
            self.__field_subject=value
        else:
            self.__field_subject=USTRING(value,**{'sizeinbytes': 64, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False })

    def __delfield_subject(self): del self.__field_subject

    subject=property(__getfield_subject, __setfield_subject, __delfield_subject, None)

    def __getfield_msgs(self):
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx9100_350,  'length': 20 })
        return self.__field_msgs.getvalue()

    def __setfield_msgs(self, value):
        if isinstance(value,LIST):
            self.__field_msgs=value
        else:
            self.__field_msgs=LIST(value,**{'elementclass': _gen_p_lgvx9100_350,  'length': 20 })

    def __delfield_msgs(self): del self.__field_msgs

    msgs=property(__getfield_msgs, __setfield_msgs, __delfield_msgs, None)

    def __getfield_sender(self):
        return self.__field_sender.getvalue()

    def __setfield_sender(self, value):
        if isinstance(value,USTRING):
            self.__field_sender=value
        else:
            self.__field_sender=USTRING(value,**{'sizeinbytes': 49})

    def __delfield_sender(self): del self.__field_sender

    sender=property(__getfield_sender, __setfield_sender, __delfield_sender, None)

    def __getfield_sender_length(self):
        return self.__field_sender_length.getvalue()

    def __setfield_sender_length(self, value):
        if isinstance(value,UINT):
            self.__field_sender_length=value
        else:
            self.__field_sender_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_sender_length(self): del self.__field_sender_length

    sender_length=property(__getfield_sender_length, __setfield_sender_length, __delfield_sender_length, None)

    def __getfield_unk3(self):
        return self.__field_unk3.getvalue()

    def __setfield_unk3(self, value):
        if isinstance(value,UINT):
            self.__field_unk3=value
        else:
            self.__field_unk3=UINT(value,**{'sizeinbytes': 2})

    def __delfield_unk3(self): del self.__field_unk3

    unk3=property(__getfield_unk3, __setfield_unk3, __delfield_unk3, None)

    def __getfield_sender_name(self):
        return self.__field_sender_name.getvalue()

    def __setfield_sender_name(self, value):
        if isinstance(value,USTRING):
            self.__field_sender_name=value
        else:
            self.__field_sender_name=USTRING(value,**{'sizeinbytes': 33})

    def __delfield_sender_name(self): del self.__field_sender_name

    sender_name=property(__getfield_sender_name, __setfield_sender_name, __delfield_sender_name, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,USTRING):
            self.__field_callback=value
        else:
            self.__field_callback=USTRING(value,**{'sizeinbytes': 49})

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_callback_length(self):
        return self.__field_callback_length.getvalue()

    def __setfield_callback_length(self, value):
        if isinstance(value,UINT):
            self.__field_callback_length=value
        else:
            self.__field_callback_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_length(self): del self.__field_callback_length

    callback_length=property(__getfield_callback_length, __setfield_callback_length, __delfield_callback_length, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unk0', self.__field_unk0, None)
        yield ('index', self.__field_index, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('GPStime', self.__field_GPStime, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('unk2', self.__field_unk2, None)
        yield ('gtimesent', self.__field_gtimesent, None)
        yield ('read', self.__field_read, None)
        yield ('locked', self.__field_locked, None)
        yield ('priority', self.__field_priority, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('subject', self.__field_subject, None)
        yield ('msgs', self.__field_msgs, None)
        yield ('sender', self.__field_sender, None)
        yield ('sender_length', self.__field_sender_length, None)
        yield ('unk3', self.__field_unk3, None)
        yield ('sender_name', self.__field_sender_name, None)
        yield ('callback', self.__field_callback, None)
        yield ('callback_length', self.__field_callback_length, None)




class _gen_p_lgvx9100_350(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['msg_id', 'msg_length', 'msg_data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx9100_350,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx9100_350:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx9100_350,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx9100_350,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_msg_id.writetobuffer(buf)
        self.__field_msg_length.writetobuffer(buf)
        self.__field_msg_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msg_id=UINT(**{'sizeinbytes': 1})
        self.__field_msg_id.readfrombuffer(buf)
        self.__field_msg_length=UINT(**{'sizeinbytes': 1})
        self.__field_msg_length.readfrombuffer(buf)
        self.__field_msg_data=SMSINBOXMSGFRAGMENT()
        self.__field_msg_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg_id(self):
        return self.__field_msg_id.getvalue()

    def __setfield_msg_id(self, value):
        if isinstance(value,UINT):
            self.__field_msg_id=value
        else:
            self.__field_msg_id=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_id(self): del self.__field_msg_id

    msg_id=property(__getfield_msg_id, __setfield_msg_id, __delfield_msg_id, None)

    def __getfield_msg_length(self):
        return self.__field_msg_length.getvalue()

    def __setfield_msg_length(self, value):
        if isinstance(value,UINT):
            self.__field_msg_length=value
        else:
            self.__field_msg_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_length(self): del self.__field_msg_length

    msg_length=property(__getfield_msg_length, __setfield_msg_length, __delfield_msg_length, None)

    def __getfield_msg_data(self):
        return self.__field_msg_data.getvalue()

    def __setfield_msg_data(self, value):
        if isinstance(value,SMSINBOXMSGFRAGMENT):
            self.__field_msg_data=value
        else:
            self.__field_msg_data=SMSINBOXMSGFRAGMENT(value,)

    def __delfield_msg_data(self): del self.__field_msg_data

    msg_data=property(__getfield_msg_data, __setfield_msg_data, __delfield_msg_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg_id', self.__field_msg_id, None)
        yield ('msg_length', self.__field_msg_length, None)
        yield ('msg_data', self.__field_msg_data, None)




