// DCCPerson.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include "DCCPerson.H"

DCCPerson::DCCPerson(DCCConnection *cnx)
  : Person(cnx->get_bot(), cnx->get_nuh()), dcc(cnx)
{ }

DCCPerson::DCCPerson(DCCPerson &p)
  : Person(p), dcc(p.dcc)
{ }

void
DCCPerson::sendNotice(String message)
{
  dcc->sendNotice(message);
}

Person *
DCCPerson::copy()
{
  return (Person *)(new DCCPerson(*this));
}

void
DCCPerson::keepAlive()
{
  dcc->set_autoRemove (false);
}

bool
DCCPerson::handleInput ()
{
  return dcc->handleInput ();
}
